/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITServerAutoDetectPackage;

import SwingModelPackage.ListTools;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.ComboBoxModel;

/**
 *
 * @author Hagi
 */
public class ServerAutoDetect_Client {
	public static boolean						DEBUGON = true;
		
	public static int							s_MulticastZyclusTime = 5000; //the time in milliseconds the mutlicast will start newly
	
	public static ArrayList<ServerAutoDetect_Client>		s_ServerAutoDetect_Clients = new ArrayList<ServerAutoDetect_Client>();
	public static final Object								s_SyncServerAutoDetectClients = new Object();
	
	
	/**
	 * Starts the autodetection of servers.<br>
	 * @param p_CallerObject the instance which is calling this function.<br>
	 * This will be used later in stopServerAutoDetect(..( to decide if the autodetection can be stopped or not.<br>
	 * Every ServerAutoDetect_Client instance has a list of his callers, if the list is empty we can stop the autodetection.<br>
	 * <br>
	 * If p_CallerObject == null, the autodetection will NOT start, but the ServerAutoDetect_Client instance will be created and returned.<br>
	 * @param p_ServerTaskID used to search for specific servers.<br>
	 * The TaskID is a flag/description of what the server does.
	 * Like a summary of all the server's jobs.<br>
	 * The TaskID is defined by the server in the server.ini, it is a logical hint provided by the developer of a project.<br>
	 * @return the instance of ServerAutoDetect_Client belonging to p_ServerTaskID<br>
	 * If p_CallerObject == null. no autodetection will start.
	 */
	public static ServerAutoDetect_Client startServerAutoDetect(Object p_CallerObject, String p_ServerTaskID) {
		if (p_ServerTaskID == null || p_ServerTaskID.length() <= 0) {
			p_ServerTaskID = ServerAutoDetect.SEARCH_ALL_SERVERS;
		}
		ServerAutoDetect_Client o_ServerAutoDetect_Client;
		synchronized(s_SyncServerAutoDetectClients) {
			o_ServerAutoDetect_Client = getServerAutoDetect_Client(p_ServerTaskID);
			if (o_ServerAutoDetect_Client != null) {
				o_ServerAutoDetect_Client.startDetection(p_CallerObject);
			}
			else {
				o_ServerAutoDetect_Client = new ServerAutoDetect_Client(p_ServerTaskID);
				addServerAutoDetect_Client(o_ServerAutoDetect_Client);
				o_ServerAutoDetect_Client.startDetection(p_CallerObject);
			}
		}
		return o_ServerAutoDetect_Client;
	}
	
	public static ServerAutoDetect_Client getServerAutoDetect_Client(String p_ServerTsskID) {
		if (p_ServerTsskID == null) return null;
		ServerAutoDetect_Client o_ServerAutoDetect_Client;
		synchronized(s_SyncServerAutoDetectClients) {
			for (int intClient = 0; intClient < s_ServerAutoDetect_Clients.size(); intClient++) {
				o_ServerAutoDetect_Client = s_ServerAutoDetect_Clients.get(intClient);
				if (p_ServerTsskID.equals(o_ServerAutoDetect_Client.getServerTaskID())) {
					return o_ServerAutoDetect_Client;
				}
			}
		}
		return null;
	}
	
	/**
	 * Stops te clients autodetection of the server for all instances.
	 */
	public static void stopServerAutoDetect_All() {
		ArrayList<ServerAutoDetect_Client> o_ServerAutoDetect_Clients;
		ServerAutoDetect_Client o_ServerAutoDetect_Client;
		synchronized(s_SyncServerAutoDetectClients) {
			o_ServerAutoDetect_Clients = new ArrayList<ServerAutoDetect_Client>(s_ServerAutoDetect_Clients.size());
			o_ServerAutoDetect_Clients.addAll(s_ServerAutoDetect_Clients);
			s_ServerAutoDetect_Clients.clear();
		}
		for (int intServer = 0; intServer < o_ServerAutoDetect_Clients.size(); intServer++) {
			o_ServerAutoDetect_Client = o_ServerAutoDetect_Clients.get(intServer);
			o_ServerAutoDetect_Client.stopDetectionAll();
		}
	}
	/**
	 * Stop the autodetection of servers with the given p_ServerTaskID.
	 * @param p_CallerObject the instance which is calling stopServerAutoDetect(..).<br>
	 * This will be used to decide if the auto detection can be stoppeed, if there are some callers left , we can't stop the sutodetection.
	 * @param p_ServerTaskID if NOT null or empty -> the search for servers with this TaskID will stop.<br>
	 * if null or empty the search 'for all servers' will stop, but the search for other specified TaskIDs will continue.
	 * To stopp all searches use stopServerAutoDetect_All().
	 * @return the stopped ServerAutoDetect_Client.<br>
	 * Or null if there exists no autodetection for p_ServerTaskID
	 */
	public static ServerAutoDetect_Client stopServerAutoDetect(Object p_CallerObject, String p_ServerTaskID) {
		if (p_ServerTaskID == null || p_ServerTaskID.length() <= 0) {
			p_ServerTaskID = ServerAutoDetect.SEARCH_ALL_SERVERS;
		}
		ServerAutoDetect_Client o_ServerAutoDetect_Client = null;
		
		synchronized(s_SyncServerAutoDetectClients) {
			if (p_ServerTaskID != null) {
				o_ServerAutoDetect_Client = getServerAutoDetect_Client(p_ServerTaskID);
				if (o_ServerAutoDetect_Client != null) {
					o_ServerAutoDetect_Client.stopDetection(p_CallerObject);
				}
			}
		}
		return o_ServerAutoDetect_Client;
	}
	
	
	private static ServerAutoDetect_Client addServerAutoDetect_Client(ServerAutoDetect_Client p_ServerAutoDetect_Client) {
		if (p_ServerAutoDetect_Client == null) return null;
		ServerAutoDetect_Client o_ServerAutoDetect_Client;
		synchronized(s_SyncServerAutoDetectClients) {
			o_ServerAutoDetect_Client = getServerAutoDetect_Client(p_ServerAutoDetect_Client.getServerTaskID());
			if (o_ServerAutoDetect_Client != null) {
				//There exists on with the same ServerID
				return o_ServerAutoDetect_Client;
			}
			else {
				s_ServerAutoDetect_Clients.add(p_ServerAutoDetect_Client);
			}
		}
		return p_ServerAutoDetect_Client;
	}

	private static ServerAutoDetect_Client removeServerAutoDetect_Client(String p_TaskID) {
		if (p_TaskID == null) return null;
		ServerAutoDetect_Client o_ServerAutoDetect_Client = null;
		synchronized(s_SyncServerAutoDetectClients) {
			o_ServerAutoDetect_Client = getServerAutoDetect_Client(p_TaskID);
			if (o_ServerAutoDetect_Client != null) {
				s_ServerAutoDetect_Clients.remove(o_ServerAutoDetect_Client);
			}
		}
		return o_ServerAutoDetect_Client;
	}
	
	
	/**
	 * Must be set before call startServerAutoDetect.<br>
	 * Every p_Milliseconds the list of the servers will be polled.
	 * @param p_Milliseconds (betwenn 1000 (1s) and 60000 (1m))
	 */
	public static void setMutlicastRefreshTime(int p_Milliseconds) {
		if (p_Milliseconds < 1000) p_Milliseconds = 1000;
		if (p_Milliseconds > 60000) p_Milliseconds = 60000;
		s_MulticastZyclusTime = p_Milliseconds;
	}
		
	private ArrayList<Object>									m_CallerObjects;
	private ArrayList<ServerAutoDetect.DetectedServer>			m_DetectedServers;
	private ArrayList<ServerAutoDetect.DetectedServer>			m_DetectedServers_Added;
	private ArrayList<ServerAutoDetect.DetectedServer>			m_DetectedServers_Removed;
	private ArrayList<ServerAutoDetect.DetectedServer>			m_DetectedServers_Changed;
	
	private final Object										m_SyncDetectedServers = new Object();
	private ListTools.ListModel<ServerAutoDetect.DetectedServer>	m_DetectedServer_ListModel;
	private ServerAutoDetect.DetectedServer_ListCellRenderer		m_DetectedServer_CellRenderer;
	
	private String										m_ServerTaskID; //like a suumary of all jobs of the server
																	//Every Server get an id descibing the task of the server
	private int											m_MutlicastZyclusTime; //Milliseconds the list will polled new
	private Runnable									m_Runnable_Send;
	private Runnable									m_Runnable_Receive;
	private Thread										m_ThreadSend;
	private Thread										m_ThreadReceive;
	private boolean										m_IsMulticastRunning;
	private boolean										m_RunBroadcast = true;
	private DatagramSocket								m_DatagramSocket;
	
	private boolean										m_StopAutoDetect;
	

	
	private ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>	m_ServerAutoDetect_Listeners;
	private ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>	m_NewServerAutoDetect_Listeners;
	private final Object											m_SyncListeners = new Object();
	
	
	public ServerAutoDetect_Client(String p_ServerTaskID) {
		initMembers();
		if (p_ServerTaskID == null) {
			m_ServerTaskID = ServerAutoDetect.SEARCH_ALL_SERVERS;
		}
		else {
			m_ServerTaskID = p_ServerTaskID;
		}
		
	}
	
	private void initMembers() {
		m_CallerObjects = new ArrayList<Object>();
		m_ServerAutoDetect_Listeners = new ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>();
		m_NewServerAutoDetect_Listeners = new ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>();
		m_DetectedServers = new ArrayList<ServerAutoDetect.DetectedServer>();
		m_DetectedServers_Added = new ArrayList<ServerAutoDetect.DetectedServer>();
		m_DetectedServers_Removed = new ArrayList<ServerAutoDetect.DetectedServer>();
		m_DetectedServers_Changed = new ArrayList<ServerAutoDetect.DetectedServer>();
		m_StopAutoDetect = false;
		m_IsMulticastRunning = false;
		m_MutlicastZyclusTime = s_MulticastZyclusTime;
		
		//Don't create the list model here, because EventQueue will be used
		//ANDROID will run in error when EventQueue is used
//		m_DetectedServer_ListModel = new LiveDBListTools.LiveDBListModel<ServerAutoDetect.DetectedServer>();
//		m_DetectedServer_CellRenderer = new ServerAutoDetect.DetectedServer_ListCellRenderer(true, true, true, true);
	}
	
	public String getServerTaskID() {
		return m_ServerTaskID;
	}
	
	public void multicastZyclusStart() {
		ServerAutoDetect.DetectedServer o_DetectedServer;
		synchronized(m_SyncDetectedServers) {
			for (int intServer = 0; intServer < m_DetectedServers.size(); intServer++) {
				o_DetectedServer = m_DetectedServers.get(intServer);
				o_DetectedServer.multicastZyclusStart();
			}
		}
	}
	public void multicastZyclusEnd() {
		ServerAutoDetect.DetectedServer o_DetectedServer;
		synchronized(m_SyncDetectedServers) {
			m_DetectedServers_Added.clear();
			m_DetectedServers_Changed.clear();
			m_DetectedServers_Removed.clear();
			
			for(int intServer = 0; intServer < m_DetectedServers.size(); intServer++) {
				o_DetectedServer = m_DetectedServers.get(intServer);
				
				o_DetectedServer.multicastZyclusEnd();
				
				if (o_DetectedServer.isNew()) {
					m_DetectedServers_Added.add(o_DetectedServer);
				}
				else if (o_DetectedServer.IsDetected() == false) {
					m_DetectedServers_Removed.add(o_DetectedServer);
				}
				else if (o_DetectedServer.isChanged() == true) {
					m_DetectedServers_Changed.add(o_DetectedServer);
				}
			}
			
			for (int intServer = 0; intServer < m_DetectedServers_Removed.size(); intServer++) {
				o_DetectedServer = m_DetectedServers_Removed.get(intServer);
				m_DetectedServers.remove(o_DetectedServer);
			}
		}
		
		//new added listeners must get the list of detected servers as added event
		boolean boolNewListenersAdded = false;
		synchronized(m_SyncListeners) {
			if (m_NewServerAutoDetect_Listeners.size() > 0) {
				boolNewListenersAdded = true;
			}
		}
		if (boolNewListenersAdded == true) {
			ArrayList<ServerAutoDetect.ServerAutoDetect_Listener> o_NewServerAutoDetect_Listeners;
			ServerAutoDetect.ServerAutoDetect_Listener o_Listener;
			ArrayList<ServerAutoDetect.DetectedServer> o_DetectedServers;
			synchronized(m_SyncListeners) {
				o_NewServerAutoDetect_Listeners = new ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>(m_NewServerAutoDetect_Listeners.size());
				o_NewServerAutoDetect_Listeners.addAll(m_NewServerAutoDetect_Listeners);
				m_NewServerAutoDetect_Listeners.clear();
			}
			synchronized(m_SyncDetectedServers) {
				o_DetectedServers = new ArrayList<ServerAutoDetect.DetectedServer>(m_DetectedServers.size());
				o_DetectedServers.addAll(m_DetectedServers);
			}
			for (int intListener = 0; intListener < o_NewServerAutoDetect_Listeners.size(); intListener++) {
				o_Listener = o_NewServerAutoDetect_Listeners.get(intListener);
				for (int intDetectesServer = 0; intDetectesServer < o_DetectedServers.size(); intDetectesServer++) {
					o_DetectedServer = o_DetectedServers.get(intDetectesServer);
					if (m_DetectedServers_Added.contains(o_DetectedServer)) {
						//this will done later by notifyDetectedServerAdded
						continue;
					}
					o_Listener.eventDetectedServer_Added(o_DetectedServer);
				}
			}
		}
		
		for (int intDetectedServer = 0; intDetectedServer < m_DetectedServers_Added.size(); intDetectedServer++) {
			o_DetectedServer = m_DetectedServers_Added.get(intDetectedServer);
			notifyDetectedServerAdded(o_DetectedServer);
		}
		for (int intDetectedServer = 0; intDetectedServer < m_DetectedServers_Removed.size(); intDetectedServer++) {
			o_DetectedServer = m_DetectedServers_Removed.get(intDetectedServer);
			notifyDetectedServerRemoved(o_DetectedServer);
		}
		for (int intDetectedServer = 0; intDetectedServer < m_DetectedServers_Changed.size(); intDetectedServer++) {
			o_DetectedServer = m_DetectedServers_Changed.get(intDetectedServer);
			notifyDetectedServerChanged(o_DetectedServer);
		}
	}
	
	/**
	 * Start the detection if not started yet.<br>
	 * Add the caller object to the list of callers.<br>
	 * @param p_CallerObject the object which has started the autodetection
	 */
	public void startDetection(Object p_CallerObject) {
		if (p_CallerObject == null) return;

		addCallerObject(p_CallerObject);

		if (m_IsMulticastRunning == true) return;
		
		m_IsMulticastRunning = true;
		try {
			//Open a random port to receive and send packages
			m_DatagramSocket = new DatagramSocket();
			m_DatagramSocket.setBroadcast(true);
			if (DEBUGON) {
				System.out.println(getClass().getName() + " StartDetection DatagramSocket created");
			}
			
		}
		catch (Exception e) {
			if (DEBUGON) {
				System.out.println(getClass().getName() + "Error can't create DatagramSocket: " + e.getMessage());
			}
			m_IsMulticastRunning = false;
			synchronized(m_SyncListeners) {
				m_CallerObjects.remove(p_CallerObject);
			}
			return;
		}
		
		checkRunnables();
		m_StopAutoDetect = false;
		
		m_ThreadReceive = new Thread(m_Runnable_Receive, getClass().getName());
		m_ThreadSend = new Thread(m_Runnable_Send, getClass().getName());
		m_ThreadReceive.start();
		m_ThreadSend.start();
	}
	
	private void addCallerObject(Object p_CallerObject) {
		if (p_CallerObject == null) return;
		synchronized(m_SyncListeners) {
			if (m_CallerObjects.contains(p_CallerObject)) return;
			m_CallerObjects.add(p_CallerObject);
			if (p_CallerObject instanceof ServerAutoDetect.ServerAutoDetect_Listener) {
				ServerAutoDetect.ServerAutoDetect_Listener o_ServerAutoDetect_Listener;
				o_ServerAutoDetect_Listener = (ServerAutoDetect.ServerAutoDetect_Listener)p_CallerObject;
				
				addServerAutoDetectListener(o_ServerAutoDetect_Listener);
				
			}
		}
	}
	
	/**
	 * Removes the caller object and returns the callers count.<br>
	 * 
	 * @param p_CallerObject
	 * @return 0 = there are no caller objects -> we can stop the detection
	 */
	private int removeCallerObject(Object p_CallerObject) {
		synchronized(m_SyncListeners) {
			if (p_CallerObject == null) return m_CallerObjects.size();
			if (m_CallerObjects.contains(p_CallerObject) == true) {
				m_CallerObjects.remove(p_CallerObject);
				if (p_CallerObject instanceof ServerAutoDetect.ServerAutoDetect_Listener) {
					removeServerAutoDetectListener((ServerAutoDetect.ServerAutoDetect_Listener)p_CallerObject);
				}
			}
			return m_CallerObjects.size();
		}		
	}
	private void checkRunnables() {
		
		if (m_Runnable_Receive == null) {
				m_Runnable_Receive = new Runnable() {
				@Override
				public void run() {
					DatagramPacket o_AnswerDatagramPacket;
					byte[] byteArray_Received;
					String stringMessage;
					String[] o_StringMessageParts;
					String stringAnswerServerTaskID;
					String stringAnswerServerTaskName;
					String stringAnswerServerID;
					String stringAnswerComputerName;
					int intAnserServerPortConnected;
					String stringAnswerClientIP;
					String stringServerAddition = null;
					
					byteArray_Received = new byte[ServerAutoDetect.BYTEBUFFERSIZE];
					
					while (m_StopAutoDetect == false) {
						//Wait for a response
						o_AnswerDatagramPacket = new DatagramPacket(byteArray_Received, byteArray_Received.length);
						try {
							m_DatagramSocket.receive(o_AnswerDatagramPacket);
						}
						catch (SocketTimeoutException e_SocketTimeoutException) {
							o_AnswerDatagramPacket = null;
							continue;
						}
						catch (Exception e) {
							if (DEBUGON) {
								System.out.println(getClass().getName() + " " + m_DatagramSocket.getInetAddress() + " Error receiving message: " + e.getMessage());
							}
							m_StopAutoDetect = true;
							o_AnswerDatagramPacket = null;
						}
						if (o_AnswerDatagramPacket == null) {
							//receive was interrupted -> continue;
							//either m_DatagramSocket timeout - this is not set (setSOTimeout)
							//or m_DatagramSocket closed
							continue;
						}
						//We have a response
						//Check if the message is correct
						try {
							stringMessage = new String(o_AnswerDatagramPacket.getData(), o_AnswerDatagramPacket.getOffset(), o_AnswerDatagramPacket.getLength(),  ServerAutoDetect.CHARSET).trim();
							if (DEBUGON) {
								System.out.println(getClass().getName() + " " + m_DatagramSocket.getInetAddress() + " received udp message: " + stringMessage);
							}
						}
						catch(Exception e) {
							if (DEBUGON) {
								System.out.println(getClass().getName() + " " + m_DatagramSocket.getInetAddress() + " Error converting charset message: " + e.getMessage());
							}
							continue;
						}
						if (stringMessage.startsWith(ServerAutoDetect.PRECODE, 0) == false) {
							//Precode is wrong -> continue
							continue;
						}
						o_StringMessageParts = stringMessage.split(ServerAutoDetect.SEPERATOR);
						if (o_StringMessageParts.length < 7) {
							//Wrong messadepart's count
							continue;
						}
						stringAnswerServerTaskID = o_StringMessageParts[1];
						//Check if the cleint seraches for all servers
						if (ServerAutoDetect.SEARCH_ALL_SERVERS.equals(m_ServerTaskID) == false) {
							if (m_ServerTaskID.equals(stringAnswerServerTaskID) == false) {
								//the ServerID is wrong -> continue
								continue;
							}
						}
						stringAnswerServerTaskName = o_StringMessageParts[2];
						stringAnswerServerID = o_StringMessageParts[3];
						stringAnswerComputerName = o_StringMessageParts[4];
						try {
							intAnserServerPortConnected = Integer.valueOf(o_StringMessageParts[5]);
						}
						catch (Exception e) {
							if (DEBUGON) {
								System.out.println(getClass().getName() + " ERROR received Packet " + o_StringMessageParts[1] + " wrong Port " + o_StringMessageParts[4]);
							}
							continue;
						}
						stringAnswerClientIP = o_StringMessageParts[6];
						stringServerAddition = "";
						if (o_StringMessageParts.length >= 8) {
							stringServerAddition = o_StringMessageParts[7];
						}
						
						serverDetected(stringAnswerServerID, stringAnswerServerTaskID, stringAnswerServerTaskName, stringAnswerComputerName, 
								o_AnswerDatagramPacket.getAddress(), intAnserServerPortConnected, stringAnswerClientIP, stringServerAddition);
						if (DEBUGON) {
							System.out.println(getClass().getSimpleName() + " Server detected " + o_AnswerDatagramPacket.getAddress());
						}
					}
					m_IsMulticastRunning = false;
				}
			};
		}
		
		if (m_Runnable_Send == null) {
			m_Runnable_Send = new Runnable() {
				@Override
				public void run() {
					DatagramPacket o_DatagramPacket_Send;
					byte[] byteArray_Send_IP4;
					byte[] byteArray_Send_IP6;
					StringBuffer o_StringBuffer_Send;
					Enumeration<NetworkInterface> o_NetworkInterfaces;
					NetworkInterface o_NetworkInterface;
					InetAddress	o_InetAddressBroadcast_IP4;
//					InetAddress o_InetAddressMulticast_IP4;
					InetAddress o_InetAddressMulticast_IP6;
				
					o_StringBuffer_Send = new StringBuffer();

					try {
						o_InetAddressMulticast_IP6 = InetAddress.getByName(ServerAutoDetect.MULTICASTGROUPNAME_IP6);
					}
					catch (Exception e) {
						o_InetAddressMulticast_IP6 = null;
					}
					
					o_StringBuffer_Send.delete(0, o_StringBuffer_Send.length());
					o_StringBuffer_Send.append(ServerAutoDetect.PRECODE);
					o_StringBuffer_Send.append(ServerAutoDetect.SEPERATOR);
					o_StringBuffer_Send.append(m_ServerTaskID);
					byteArray_Send_IP4 = o_StringBuffer_Send.toString().getBytes(ServerAutoDetect.CHARSET);
					byteArray_Send_IP6 = o_StringBuffer_Send.toString().getBytes(ServerAutoDetect.CHARSET);

					
					while (m_StopAutoDetect == false) {
						
						multicastZyclusStart();
						
						
						//--- IP4 ----
						try {
							o_NetworkInterfaces = NetworkInterface.getNetworkInterfaces();
						}
						catch (Exception e) {
							o_NetworkInterfaces = null;
						}
						if (o_NetworkInterfaces != null) {
							while (o_NetworkInterfaces.hasMoreElements()) {
								o_NetworkInterface = (NetworkInterface)o_NetworkInterfaces.nextElement();
								try {
									if (!o_NetworkInterface.isUp()) {
										continue;
									}
								}
								catch (Exception e) {
									continue;
								}
								for (InterfaceAddress o_InterfaceAddress : o_NetworkInterface.getInterfaceAddresses()) {
									o_InetAddressBroadcast_IP4 = o_InterfaceAddress.getBroadcast();
									if (o_InetAddressBroadcast_IP4 == null) {
										continue;
									}
									try {
										if (DEBUGON) {
											System.out.println(getClass().getName() + " send message to : " + o_InetAddressBroadcast_IP4.toString());
											System.out.println(o_StringBuffer_Send.toString());
										}
										o_DatagramPacket_Send = new DatagramPacket(byteArray_Send_IP4, byteArray_Send_IP4.length, o_InetAddressBroadcast_IP4, ServerAutoDetect.PORT_IP4);
										m_DatagramSocket.send(o_DatagramPacket_Send);
									} 
									catch (Exception e) {
										if (DEBUGON) {
											System.out.println(getClass().getName() + " ERROR IP4 send DatagramPacket to : " + o_InetAddressBroadcast_IP4.toString() + e.getMessage());
										}
									}				
								}
							}		
						}


						//--- IP6 ----
						if (o_InetAddressMulticast_IP6 != null) {
							try {
								if (DEBUGON) {
									System.out.println(getClass().getName() + " send message to : " + o_InetAddressMulticast_IP6.toString());
									System.out.println(o_StringBuffer_Send.toString());
								}
								o_DatagramPacket_Send = new DatagramPacket(byteArray_Send_IP6, byteArray_Send_IP6.length, o_InetAddressMulticast_IP6, ServerAutoDetect.PORT_IP6);
								m_DatagramSocket.send(o_DatagramPacket_Send);
							} 
							catch (Exception e) {
								if (DEBUGON) {
									System.out.println(getClass().getName() + " ERROR IP6 send DatagramPacket: " +e.getMessage());
								}
							}
						}
						
						//Sleep for m_MutlicastZyclusTime Milliseconds
						//In the meantime the answers will arrive see m_Runnable_Receive
						try {
							Thread.currentThread().sleep(m_MutlicastZyclusTime);
						}
						catch (Exception e) {
							
						}
						
						multicastZyclusEnd();
						
					}
					m_IsMulticastRunning = false;
				}
			};
		}
		
	}
	/**
	 * 
	 * @param p_ServerID the unique id of the server.<br>
	 * Two servers's either running on the same computer or on different computers must not have the same ID.<br>
	 * If p_ServerID == null -> a unique ID will be created automatically 
	 * This can be used by the client to identify the server.<br>
	 * @param p_ServerTaskID a flag/description of the waht the server does .<br>
	 * This will be used to decide which kind of server is searched for.<br>
	 * @param p_ServerTaskName talking description of p_ServerTaskID.<br>
	 * @param p_LocalPortConnected the port number the server is bind to.
	 * @param p_ComputerName the servers's computername
	 * @param p_InetAddress the server's inet address
	 * @param p_Port the server's port
	 * @param p_ClientIP the ip of this client, which has received the server's answer
	 * @param p_ServerAddition a free usable string maybe null<br>
	 * For example, can be used to distinguish two server instances of the same server name
	 */
	private void serverDetected(String p_ServerID, String p_ServerTaskID, String p_ServerTaskName, String p_ComputerName, InetAddress p_InetAddress, int p_Port, String p_ClientIP, String p_ServerAddition) {
		ServerAutoDetect.DetectedServer o_DetectedServer;
		synchronized(m_SyncDetectedServers) {
			o_DetectedServer = getDetectedServer_ByID(p_ServerID);
			//MEDIASERVER ID (p_ServerID) comes from ini and is therefore the same for two different instances
			//May be there is some work to change the id for several instances started on the same computer
			if (o_DetectedServer == null) {
				o_DetectedServer = new ServerAutoDetect.DetectedServer(p_ServerID, p_ServerTaskID, p_ServerTaskName, p_ComputerName, p_Port, p_ClientIP, p_ServerAddition);
				m_DetectedServers.add(o_DetectedServer);
			}
		}
		o_DetectedServer.addInetAddress(p_InetAddress);
	}
	
	public void stopDetectionAll() {
		synchronized(m_SyncListeners) {
			m_CallerObjects.clear();
		}
		
		m_StopAutoDetect = true;
		if (m_DatagramSocket != null) {
			try {
				if (m_DatagramSocket.isClosed() == false) {
					m_DatagramSocket.close();
					if (DEBUGON) {
						System.out.println(getClass().getName() + " stopDetectionAll - DatagramSocket closed");
					}
				}
			}
			catch (Exception e) {
				
			}
		}
		synchronized(m_SyncDetectedServers) {
			m_DetectedServers.clear();
		}
	}
	
	public void stopDetection(Object p_CallerObject) {
		int intRestCallerCount;
		intRestCallerCount = removeCallerObject(p_CallerObject);
		//only stop the autodetection when all callerobjects have stop the detection
		if (intRestCallerCount > 0) return;
		
		m_StopAutoDetect = true;
		if (m_DatagramSocket != null) {
			try {
				if (m_DatagramSocket.isClosed() == false) {
					m_DatagramSocket.close();
					if (DEBUGON) {
						System.out.println(getClass().getName() + " stopDetection - DatagramSocket closed");
					}
				}
			}
			catch (Exception e) {
				
			}
		}
		synchronized(m_SyncDetectedServers) {
			//Don't clear the detected servers
			//stopDetetction may be called when the client established a connection, then a startConnection maybe called 
			//when the client connection has benn lost -> we need the detected servers to detect a lost server
//			m_DetectedServers.clear();
		}
	}
	public int getDetectedServerCount() {
		synchronized(m_SyncDetectedServers) {
			return m_DetectedServers.size();
		}
	}

	public ServerAutoDetect.DetectedServer getDetectedServer(int p_Index) {
		if (p_Index < 0) return null;
		ServerAutoDetect.DetectedServer o_DetectedServer;
		synchronized(m_SyncDetectedServers) {
			if (p_Index >= m_DetectedServers.size()) return null;
			o_DetectedServer = m_DetectedServers.get(p_Index);
		}
		return o_DetectedServer;
	}
	
	public ArrayList<ServerAutoDetect.DetectedServer> getDetectedServers() {
		ArrayList<ServerAutoDetect.DetectedServer> o_DetectedServers;
		synchronized(m_SyncDetectedServers) {
			o_DetectedServers = new ArrayList<ServerAutoDetect.DetectedServer>(m_DetectedServers.size());
			o_DetectedServers.addAll(m_DetectedServers);
		}
		return o_DetectedServers;
	}
	
	public ServerAutoDetect.DetectedServer getDetectedServer_ByID(String p_ServerID) {
		if (p_ServerID == null) return null;
		ServerAutoDetect.DetectedServer o_DetectedServer;
		synchronized(m_SyncDetectedServers) {
			for (int intServer = 0; intServer < m_DetectedServers.size(); intServer++) {
				o_DetectedServer = m_DetectedServers.get(intServer);
				if (p_ServerID.equals(o_DetectedServer.getServerID())) {
					return o_DetectedServer;
				}
			}
		}
		return null;
	}
	public ServerAutoDetect.DetectedServer getDetectedServer_ByIPPort(String p_ServerIP, int p_ServerPort) {
		if (p_ServerIP == null) return null;
		ServerAutoDetect.DetectedServer o_DetectedServer;
		Iterator o_Iterator;
		String stringID;

		synchronized(m_SyncDetectedServers) {
			for (int intServer = 0; intServer < m_DetectedServers.size(); intServer++) {
				o_DetectedServer = m_DetectedServers.get(intServer);
				if (o_DetectedServer.getPort() == p_ServerPort) {
					if (o_DetectedServer.containsIP(p_ServerIP)) {
						return o_DetectedServer;
					}
				}
			}
		}
		return null;
	}
	public ServerAutoDetect.DetectedServer getDetectedServer_ByHostNamePort(String p_ServerHostName, int p_ServerPort) {
		if (p_ServerHostName == null) return null;
		p_ServerHostName.trim();
		ServerAutoDetect.DetectedServer o_DetectedServer;
		Iterator o_Iterator;
		String stringID;

		synchronized(m_SyncDetectedServers) {
			for (int intServer = 0; intServer < m_DetectedServers.size(); intServer++) {
				o_DetectedServer = m_DetectedServers.get(intServer);
				if (o_DetectedServer.getPort() == p_ServerPort) {
					if (p_ServerHostName.equals(o_DetectedServer.getComputerName())) {
						return o_DetectedServer;
					}
				}
			}
		}
		return null;
	}
	
	/**
	 * Retuns the List Model for DetectedServers. The model will be instanciated here.<br>
	 * CAUTION: Don't call this in Android, because Android cannot handle the EventQueue, which will be used here.
	 * @return a list model for detected servers.
	 */
	public ComboBoxModel<ServerAutoDetect.DetectedServer> getDetectedServerListModel() {
		if (m_DetectedServer_ListModel == null) {
			ServerAutoDetect.DetectedServer o_DetectedServer;
			m_DetectedServer_ListModel = new ListTools.ListModel<ServerAutoDetect.DetectedServer>(null);
			m_DetectedServer_CellRenderer = new ServerAutoDetect.DetectedServer_ListCellRenderer(false, false, true, true, true, true);
			
			synchronized(m_SyncDetectedServers) {
//				m_DetectedServer_ListModel.clear();
				for (int intServer = 0; intServer < m_DetectedServers.size(); intServer++) {
					o_DetectedServer = m_DetectedServers.get(intServer);
					if (o_DetectedServer == null) continue;
					m_DetectedServer_ListModel.addElement(o_DetectedServer);
				}
			}
		}
		return m_DetectedServer_ListModel;
	}
	
	public ServerAutoDetect.DetectedServer_ListCellRenderer getDetectedServer_CellRenderer() {
		if (m_DetectedServer_ListModel == null) {
			getDetectedServerListModel();
		}
		return m_DetectedServer_CellRenderer;
	}
	
	//----------- ServerAutoDetectListeners ------------
	
	public void addServerAutoDetectListener(ServerAutoDetect.ServerAutoDetect_Listener p_ServerAutoDetect_Listener) {
		if (p_ServerAutoDetect_Listener == null) return;
		synchronized(m_SyncListeners) {
			if (m_ServerAutoDetect_Listeners.contains(p_ServerAutoDetect_Listener)) return;
			m_ServerAutoDetect_Listeners.add(p_ServerAutoDetect_Listener);
			m_NewServerAutoDetect_Listeners.add(p_ServerAutoDetect_Listener);
		}
	}
	public void removeServerAutoDetectListener(ServerAutoDetect.ServerAutoDetect_Listener p_ServerAutoDetect_Listener) {
		if (p_ServerAutoDetect_Listener == null) return;
		synchronized(m_SyncListeners) {
			m_ServerAutoDetect_Listeners.remove(p_ServerAutoDetect_Listener);
		}
	}
	
	private void notifyDetectedServerAdded(final ServerAutoDetect.DetectedServer p_DetectedServer) {
		if (p_DetectedServer == null) return;

		//ANDROID cannot handle the EventQueue-> check m_DetectedServer_ListModel != null
		if (m_DetectedServer_ListModel != null) {
			EventQueueHandler.invokeLater(new Runnable() {
				@Override
				public void run() {
					if (m_DetectedServer_ListModel != null) {
						m_DetectedServer_ListModel.addElement(p_DetectedServer);
					}
				}
			});
		}

		ArrayList<ServerAutoDetect.ServerAutoDetect_Listener> o_Listeners;
		ServerAutoDetect.ServerAutoDetect_Listener o_Listener;
		synchronized(m_SyncListeners) {
			if (m_ServerAutoDetect_Listeners.size() <= 0) return;
			o_Listeners = new ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>(m_ServerAutoDetect_Listeners.size());
			o_Listeners.addAll(m_ServerAutoDetect_Listeners);
		}
		for (int intListener = 0; intListener < o_Listeners.size(); intListener++) {
			o_Listener = o_Listeners.get(intListener);
			o_Listener.eventDetectedServer_Added(p_DetectedServer);
		}
	}
	private void notifyDetectedServerRemoved(final ServerAutoDetect.DetectedServer p_DetectedServer) {
		if (p_DetectedServer == null) return;

		//ANDROID cannot handle the EventQueue-> check m_DetectedServer_ListModel != null
		if (m_DetectedServer_ListModel != null) {
			EventQueueHandler.invokeLater(new Runnable() {
				@Override
				public void run() {
					if (m_DetectedServer_ListModel != null) {
						m_DetectedServer_ListModel.remove(p_DetectedServer);
					}
				}
			});
		}

		ArrayList<ServerAutoDetect.ServerAutoDetect_Listener> o_Listeners;
		ServerAutoDetect.ServerAutoDetect_Listener o_Listener;
		synchronized(m_SyncListeners) {
			if (m_ServerAutoDetect_Listeners.size() <= 0) return;
			o_Listeners = new ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>(m_ServerAutoDetect_Listeners.size());
			o_Listeners.addAll(m_ServerAutoDetect_Listeners);
		}
		for (int intListener = 0; intListener < o_Listeners.size(); intListener++) {
			o_Listener = o_Listeners.get(intListener);
			o_Listener.eventDetectedServer_Removed(p_DetectedServer);
		}
	}
	private void notifyDetectedServerChanged(final ServerAutoDetect.DetectedServer p_DetectedServer) {
		if (p_DetectedServer == null) return;

		//ANDROID cannot handle the EventQueue-> check m_DetectedServer_ListModel != null
		if (m_DetectedServer_ListModel != null) {
			EventQueueHandler.invokeLater(new Runnable() {
				@Override
				public void run() {
					if (m_DetectedServer_ListModel != null) {
						m_DetectedServer_ListModel.changed(p_DetectedServer);
					}
				}
			});
		}

		ArrayList<ServerAutoDetect.ServerAutoDetect_Listener> o_Listeners;
		ServerAutoDetect.ServerAutoDetect_Listener o_Listener;
		synchronized(m_SyncListeners) {
			if (m_ServerAutoDetect_Listeners.size() <= 0) return;
			o_Listeners = new ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>(m_ServerAutoDetect_Listeners.size());
			o_Listeners.addAll(m_ServerAutoDetect_Listeners);
		}
		for (int intListener = 0; intListener < o_Listeners.size(); intListener++) {
			o_Listener = o_Listeners.get(intListener);
			o_Listener.eventDetectedServer_Changed(p_DetectedServer);
		}
	}
}
