/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package SwingModelPackage;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/**
 *
 * @author Hagi
 */

/**
 * This is a utility class that can be used by Objects to support propertychangeEvents.
 * It manages a list of listeners and fires
 * {@link PropertyChangeEvent}s to them.
 * The {@link PropertyChangeListener} can be registered for all properties
 * or for a property specified by name.
 * <p>
 * The differneces to the java.beans.PropertyChangeSupport are:<br>
 * - this class is a little bit less expensive<br>
 * - this class does NOT implements Serializable<br>
 * - a PropertyChangeListener can be added only once for all properties or even for a property specified by name.<br>
 * That means a PropertyChangeListener can be added only once for all properties and once for every named property.
 * <p>
 * Here is an example of {@code PropertyChangeSupport} usage that follows
 * the rules and recommendations laid out in the JavaBeans&trade; specification:
 * <pre>
 * public class MyObject {
 *     private final PropertyChangeSupport pcs = new SinglePropertyChangeSupport(this);
 *
 *     public void addPropertyChangeListener(PropertyChangeListener listener) {
 *         this.pcs.addPropertyChangeListener(listener);
 *     }
 *
 *     public void removePropertyChangeListener(PropertyChangeListener listener) {
 *         this.pcs.removePropertyChangeListener(listener);
 *     }
 *
 *     private String value;
 *
 *     public String getValue() {
 *         return this.value;
 *     }
 *
 *     public void setValue(String newValue) {
 *         String oldValue = this.value;
 *         this.value = newValue;
 *         this.pcs.firePropertyChange("value", oldValue, newValue);
 *     }
 *
 *     [...]
 * }
 * </pre>
 * <p>
 * A {@code SinglePropertyChangeSupport} instance is thread-safe.
 * <p>
 * This class is NOT serializable.
 * @see VetoableChangeSupport
 */
public class SinglePropertyChangeSupport {
	private PropertyChangeListener[]	s_EmptyList = new PropertyChangeListener[0];
	
    private HashMap<String, ArrayList<PropertyChangeListener>> m_HashMapPropertyChangeListeners;
    /**
     * The object to be provided as the "source" for any generated events.
     */
    private Object m_ObjectSource;
	
	private final Object	m_SyncListeners = new Object();

    /**
     * Constructs a <code>PropertyChangeSupport</code> object.
     *
     * @param p_ObjectSource  The bean to be given as the source for any events.
     */
    public SinglePropertyChangeSupport(Object p_ObjectSource) {
        if (p_ObjectSource == null) {
            throw new NullPointerException();
        }
		initMembers();
        m_ObjectSource = p_ObjectSource;
    }

	private void initMembers() {
		m_HashMapPropertyChangeListeners = new HashMap<String, ArrayList<PropertyChangeListener>>();
	}
	
	/**
	 * Removes all PropertyChangeListeners which are registered.<br>
	 */
	public void clear() {
		synchronized(m_SyncListeners) {
		if (m_HashMapPropertyChangeListeners != null) {
			Iterator<ArrayList<PropertyChangeListener>> o_IteratorPropertyName;
			ArrayList<PropertyChangeListener> o_PropertyChangeListeners;
			PropertyChangeListener o_PropertyChangeListener;
			String stringPropertyName;
			o_IteratorPropertyName = m_HashMapPropertyChangeListeners.values().iterator();
			while (o_IteratorPropertyName.hasNext()) {
				o_PropertyChangeListeners = o_IteratorPropertyName.next();
				if (o_PropertyChangeListeners != null) {
					for (int intListener = o_PropertyChangeListeners.size()-1; intListener >= 0; intListener--) {
						o_PropertyChangeListener = o_PropertyChangeListeners.get(intListener);
						o_PropertyChangeListeners.remove(o_PropertyChangeListener);
					}
					o_PropertyChangeListeners.clear();
				}
				o_IteratorPropertyName.remove();
			}
			m_HashMapPropertyChangeListeners.clear();
		}
		}
	}
    /**
     * Add a PropertyChangeListener to the listener list.
     * The listener is registered for all properties.
     * The same listener object cannot be added more than once
     * If <code>p_PropertyChangeListener</code> is null, no exception is thrown and no action
     * is taken.
     *
     * @param p_PropertyChangeListener  The PropertyChangeListener to be added
     */
    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
		synchronized(m_SyncListeners) {
		ArrayList<PropertyChangeListener> o_PropertyChangeListeners;
		o_PropertyChangeListeners = m_HashMapPropertyChangeListeners.get(null);
		if (o_PropertyChangeListeners == null) {
			o_PropertyChangeListeners = new ArrayList<PropertyChangeListener>();
			m_HashMapPropertyChangeListeners.put(null, o_PropertyChangeListeners);
		}
		if (o_PropertyChangeListeners.contains(p_PropertyChangeListener)) return;
		o_PropertyChangeListeners.add(p_PropertyChangeListener);
		}
    }

    /**
     * Remove a PropertyChangeListener from the listener list.
     * This removes a PropertyChangeListener that was registered
     * for all properties.
     * If <code>listener</code> is null, or was never added, no exception is
     * thrown and no action is taken.
     *
     * @param   The PropertyChangeListener to be removed
     */
    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
		synchronized(m_SyncListeners) {
		ArrayList<PropertyChangeListener> o_PropertyChangeListeners;
		o_PropertyChangeListeners = m_HashMapPropertyChangeListeners.get(null);
		if (o_PropertyChangeListeners == null) return;
		o_PropertyChangeListeners.remove(p_PropertyChangeListener);
		}
    }

    /**
     * Returns an array of all the listeners that were added to the
     * PropertyChangeSupport object with addPropertyChangeListener().
     * <p>
     * If some listeners have been added with a named property, then
     * the returned array will be a mixture of PropertyChangeListeners
     * and <code>PropertyChangeListenerProxy</code>s. If the calling
     * method is interested in distinguishing the listeners then it should
     * use <code>getPropertyChangeListeners(String p_PropeertyName)</code>
     *
     * @return all of the <code>PropertyChangeListeners</code> added or an
     *         empty array if no listeners have been added
     */
    public PropertyChangeListener[] getPropertyChangeListeners() {
		ArrayList<PropertyChangeListener> o_PropertyChangeListeners;
		PropertyChangeListener[] arrayPropertyChangeListeners;
		ArrayList<PropertyChangeListener> o_PropertyChangeListenersInMap;
		Iterator<ArrayList<PropertyChangeListener>> o_IteratorArray;
		PropertyChangeListener o_PropertyChangeListener;
		
		synchronized(m_SyncListeners) {
			o_PropertyChangeListeners = new ArrayList<PropertyChangeListener>();
			if (m_HashMapPropertyChangeListeners != null) {
				o_IteratorArray = m_HashMapPropertyChangeListeners.values().iterator();
				while (o_IteratorArray.hasNext()) {
					o_PropertyChangeListenersInMap = o_IteratorArray.next();
					for (int intListener = 0; intListener < o_PropertyChangeListenersInMap.size(); intListener++) {
						o_PropertyChangeListener = o_PropertyChangeListenersInMap.get(intListener);
						if (o_PropertyChangeListeners.contains(o_PropertyChangeListener)) continue;
						o_PropertyChangeListeners.add(o_PropertyChangeListener);
					}
				}
			}
		}
		arrayPropertyChangeListeners = new PropertyChangeListener[o_PropertyChangeListeners.size()];
		for (int intListener = 0; intListener < o_PropertyChangeListeners.size(); intListener++) {
			arrayPropertyChangeListeners[intListener] = o_PropertyChangeListeners.get(intListener);
		}
        return arrayPropertyChangeListeners;
    }

    /**
     * Add a PropertyChangeListener for a specific property.  The listener
     * will be invoked only when a call on firePropertyChange names that
     * specific property.
     * The same listener object cannot be added more than once for the same p_PropertyName.<br>
	 * But for several p_PropertyName the listener can be added once for each p_PropertyName 
     * If <code>propertyName</code> or <code>listener</code> is null, no
     * exception is thrown and no action is taken.
     *
     * @param p_PropertyName  The name of the property to listen on.
     * @param p_Property  The PropertyChangeListener to be added
     */
    public void addPropertyChangeListener(
                String p_PropertyName,
                PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null || p_PropertyName == null) {
            return;
        }
		synchronized(m_SyncListeners) {
		ArrayList<PropertyChangeListener> o_PropertyChangeListeners;
		o_PropertyChangeListeners = m_HashMapPropertyChangeListeners.get(p_PropertyName);
		if (o_PropertyChangeListeners == null) {
			o_PropertyChangeListeners = new ArrayList<PropertyChangeListener>();
			m_HashMapPropertyChangeListeners.put(p_PropertyName, o_PropertyChangeListeners);
		}
		if (o_PropertyChangeListeners.contains(p_PropertyChangeListener)) return;
		o_PropertyChangeListeners.add(p_PropertyChangeListener);
		}
    }

    /**
     * Remove a PropertyChangeListener for a specific property.
     * If <code>listener</code> was added more than once to the same event
     * source for the specified property, it will be notified one less time
     * after being removed.
     * If <code>propertyName</code> is null,  no exception is thrown and no
     * action is taken.
     * If <code>listener</code> is null, or was never added for the specified
     * property, no exception is thrown and no action is taken.
     *
     * @param propertyName  The name of the property that was listened on.
     * @param p_PropertyChangeListener  The PropertyChangeListener to be removed
     */
    public void removePropertyChangeListener(
                String p_PropertyName,
                PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null || p_PropertyName == null) {
            return;
        }
		synchronized(m_SyncListeners) {
		ArrayList<PropertyChangeListener> o_PropertyChangeListeners;
		o_PropertyChangeListeners = m_HashMapPropertyChangeListeners.get(p_PropertyName);
		if (o_PropertyChangeListeners == null) return;
		o_PropertyChangeListeners.remove(p_PropertyChangeListener);
		}
    }

    /**
     * Returns an array of all the listeners which have been associated
     * with the named property.
     *
     * @param p_PropertyName  The name of the property being listened to
     * @return all of the <code>PropertyChangeListeners</code> associated with
     *         the named property.  If no such listeners have been added,
     *         or if <code>propertyName</code> is null, an empty array is
     *         returned.
     * @since 1.4
     */
    public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
        if (p_PropertyName != null) {
			synchronized(m_SyncListeners) {
				ArrayList<PropertyChangeListener> o_PropertyChangeListeners;
				PropertyChangeListener[] arrayPropertyChangeListeners;
				o_PropertyChangeListeners = m_HashMapPropertyChangeListeners.get(p_PropertyName);
				if (o_PropertyChangeListeners != null) {
					arrayPropertyChangeListeners = new PropertyChangeListener[o_PropertyChangeListeners.size()];
					for (int intListener = 0; intListener < o_PropertyChangeListeners.size(); intListener++) {
						arrayPropertyChangeListeners[intListener] = o_PropertyChangeListeners.get(intListener);
					}
					return arrayPropertyChangeListeners;
				}
			}
        }
        return s_EmptyList;
    }

    /**
     * Reports a bound property update to listeners
     * that have been registered to track updates of
     * all properties or a property with the specified name.
     * <p>
     * No event is fired if old and new values are equal and non-null.
     * <p>
     * This is merely a convenience wrapper around the more general
     * {@link #firePropertyChange(PropertyChangeEvent)} method.
     *
     * @param propertyName  the programmatic name of the property that was changed
     * @param oldValue      the old value of the property
     * @param newValue      the new value of the property
     */
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            firePropertyChange(new PropertyChangeEvent(this.m_ObjectSource, propertyName, oldValue, newValue));
        }
    }

    /**
     * Reports an integer bound property update to listeners
     * that have been registered to track updates of
     * all properties or a property with the specified name.
     * <p>
     * No event is fired if old and new values are equal.
     * <p>
     * This is merely a convenience wrapper around the more general
     * {@link #firePropertyChange(String, Object, Object)}  method.
     *
     * @param propertyName  the programmatic name of the property that was changed
     * @param oldValue      the old value of the property
     * @param newValue      the new value of the property
     */
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue != newValue) {
            firePropertyChange(propertyName, Integer.valueOf(oldValue), Integer.valueOf(newValue));
        }
    }

    /**
     * Reports a boolean bound property update to listeners
     * that have been registered to track updates of
     * all properties or a property with the specified name.
     * <p>
     * No event is fired if old and new values are equal.
     * <p>
     * This is merely a convenience wrapper around the more general
     * {@link #firePropertyChange(String, Object, Object)}  method.
     *
     * @param propertyName  the programmatic name of the property that was changed
     * @param oldValue      the old value of the property
     * @param newValue      the new value of the property
     */
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            firePropertyChange(propertyName, Boolean.valueOf(oldValue), Boolean.valueOf(newValue));
        }
    }

    /**
     * Fires a property change event to listeners
     * that have been registered to track updates of
     * all properties or a property with the specified name.
     * <p>
     * No event is fired if the given event's old and new values are equal and non-null.
     *
     * @param event  the {@code PropertyChangeEvent} to be fired
     */
    public void firePropertyChange(PropertyChangeEvent event) {
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            String stringPropertyName = event.getPropertyName();

			int intListenerCount = 0;
			ArrayList<PropertyChangeListener> o_PropertyChangeListeners;
			ArrayList<PropertyChangeListener> o_PropertyChangeListeners_Null = null;
			ArrayList<PropertyChangeListener> o_PropertyChangeListeners_Named = null;
			synchronized(m_SyncListeners) {
				o_PropertyChangeListeners_Null = m_HashMapPropertyChangeListeners.get(null);
				if (o_PropertyChangeListeners_Null != null) {
					intListenerCount = o_PropertyChangeListeners_Null.size();
				}
/////				fire(o_PropertyChangeListeners_Null, event);

				if (stringPropertyName != null) {
					o_PropertyChangeListeners_Named = m_HashMapPropertyChangeListeners.get(stringPropertyName);
					if (o_PropertyChangeListeners_Named != null) {
						intListenerCount += o_PropertyChangeListeners_Named.size();
					}
/////					fire(o_PropertyChangeListeners_Named, event);
				}
				
				if (intListenerCount <= 0) {
					return;
				}
				else {
					o_PropertyChangeListeners = new ArrayList<PropertyChangeListener>(intListenerCount);
					if (o_PropertyChangeListeners_Null != null) {
						o_PropertyChangeListeners.addAll(o_PropertyChangeListeners_Null);
					}
					if (o_PropertyChangeListeners_Named != null) {
						o_PropertyChangeListeners.addAll(o_PropertyChangeListeners_Named);
					}
				}
			}
			
			fire(o_PropertyChangeListeners, event);
			o_PropertyChangeListeners.clear();
        }
    }

    private static void fire(ArrayList<PropertyChangeListener> p_PropertyChangeListeners, PropertyChangeEvent p_PropertyChangeEvent) {
        if (p_PropertyChangeListeners != null) {
            for (int intListener = 0; intListener < p_PropertyChangeListeners.size(); intListener++) {
                p_PropertyChangeListeners.get(intListener).propertyChange(p_PropertyChangeEvent);
            }
        }
    }

    /**
     * Reports a bound indexed property update to listeners
     * that have been registered to track updates of
     * all properties or a property with the specified name.
     * <p>
     * No event is fired if old and new values are equal and non-null.
     * <p>
     * This is merely a convenience wrapper around the more general
     * {@link #firePropertyChange(PropertyChangeEvent)} method.
     *
     * @param propertyName  the programmatic name of the property that was changed
     * @param index         the index of the property element that was changed
     * @param oldValue      the old value of the property
     * @param newValue      the new value of the property
     * @since 1.5
     */
    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            firePropertyChange(new IndexedPropertyChangeEvent(m_ObjectSource, propertyName, oldValue, newValue, index));
        }
    }

    /**
     * Reports an integer bound indexed property update to listeners
     * that have been registered to track updates of
     * all properties or a property with the specified name.
     * <p>
     * No event is fired if old and new values are equal.
     * <p>
     * This is merely a convenience wrapper around the more general
     * {@link #fireIndexedPropertyChange(String, int, Object, Object)} method.
     *
     * @param propertyName  the programmatic name of the property that was changed
     * @param index         the index of the property element that was changed
     * @param oldValue      the old value of the property
     * @param newValue      the new value of the property
     * @since 1.5
     */
    public void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        if (oldValue != newValue) {
            fireIndexedPropertyChange(propertyName, index, Integer.valueOf(oldValue), Integer.valueOf(newValue));
        }
    }

    /**
     * Reports a boolean bound indexed property update to listeners
     * that have been registered to track updates of
     * all properties or a property with the specified name.
     * <p>
     * No event is fired if old and new values are equal.
     * <p>
     * This is merely a convenience wrapper around the more general
     * {@link #fireIndexedPropertyChange(String, int, Object, Object)} method.
     *
     * @param propertyName  the programmatic name of the property that was changed
     * @param index         the index of the property element that was changed
     * @param oldValue      the old value of the property
     * @param newValue      the new value of the property
     * @since 1.5
     */
    public void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            fireIndexedPropertyChange(propertyName, index, Boolean.valueOf(oldValue), Boolean.valueOf(newValue));
        }
    }

    /**
     * Check if there are any listeners for a specific property, including
     * those registered on all properties.  If <code>propertyName</code>
     * is null, only check for listeners registered on all properties.
     *
     * @param propertyName  the property name.
     * @return true if there are one or more listeners for the given property
     */
    public boolean hasListeners(String propertyName) {
		synchronized(m_SyncListeners) {
			if (m_HashMapPropertyChangeListeners == null) return false;
			ArrayList<PropertyChangeListener> o_PropertyChangeListeners;
			o_PropertyChangeListeners = m_HashMapPropertyChangeListeners.get(propertyName);
			if (o_PropertyChangeListeners == null) return false;
			if (o_PropertyChangeListeners.size() > 0) return true;
			else return false;
		}
	}

}
	

