/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SwingModelPackage;

import SPITActionPackage.SPIT_ActionStatus;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

/**
 *
 * @author Hagi
 */
public class RemoteSPITObjectTableModel extends AbstractTableModel implements PropertyChangeListener  {
		public static final int		COLUMNCOUNT = 4;

		public static final int		COLUMNINDEX_SPITTYPEGROUPNAME = 0;
		public static final int		COLUMNINDEX_SPITTYPENAME = 1;
		public static final int		COLUMNINDEX_OBJECTNAME = 2;
		public static final int		COLUMNINDEX_OBJECTPLAYVALUE = 3;

		public static String	COLUMN_SPITTYPEGROUPNAME = "Group";
		public static String	COLUMN_OBJECTNAME = "Name";
		public static String	COLUMN_OBJECTPLAYVALUE = "Value %";
		public static String	COLUMN_SPITTYPENAME = "TriggerType";
		public static boolean	s_LanguageLoaded = false;

		private ArrayList<SPIT_Object_Interface>	m_SPIT_Objects;

		private TableRowSorter			m_TableRowSorter;
		private SPITRowFilter			m_SPITRowFilter;

		private final Object			m_SyncObject = new Object();
		
		public RemoteSPITObjectTableModel() {
			super();
			initMembers();
/*			if (s_LanguageLoaded == false) {
				LiveLanguage.loadLanguageStrings(this);
				s_LanguageLoaded = true;
			}
			LiveLanguage.addLanguageListener(this);
*/
		}

		private void initMembers() {
			m_SPIT_Objects = new ArrayList<>();

			m_TableRowSorter = new TableRowSorter(this);
			m_SPITRowFilter = new SPITRowFilter(this);
			
		}

		public void finishJTable(JTable p_JTable) {
			if (p_JTable == null) return;
			p_JTable.setRowSorter(m_TableRowSorter);
			fireTableStructureChanged();

			m_TableRowSorter.setComparator(COLUMNINDEX_OBJECTNAME, new StringComparator_Normal());
		}

		public void clear() {
			int intLastRow;
			synchronized(m_SyncObject) {
				intLastRow = m_SPIT_Objects.size()-1;
				m_SPIT_Objects.clear();
			}
			if (intLastRow >= 0) {
				fireTableRowsDeleted(0, intLastRow);
			}
		}
/*		@Override
		public String languageGetFileNameBasis() {
			return "Languages/LiveShow";		
		}

		@Override
		public ArrayList<LiveLanguageObject> languageGetAdditionalObjects() {
			return null;
		}

		@Override
		public void languageAdditionalObjectLoaded(LiveLanguageObject p_LanguageObject) {
		}

		@Override
		public void languageApplyComponentOrientation(ComponentOrientation p_Orientation) {
		}
*/		
		
		
		public static class StringComparator_Normal implements Comparator<String> {
			@Override
			public int compare(String o1, String o2) {
				if (o1 == null || o2 == null) return 0;
				return (o1.compareToIgnoreCase(o2));
			}
		}

		public static class StringComparator_NumericInteger implements Comparator<String> {
			@Override
			public int compare(String o1, String o2) {
				if (o1 == null || o2 == null) return 0;
				Integer int1;
				Integer int2;
				try {
					int1 = Integer.valueOf(o1);
					int2 = Integer.valueOf(o2);
				}
				catch(Exception e) {
					return 0;
				}
				return int1.compareTo(int2);
			}
		}

		public void filter(String p_FilterString) {
			if (m_SPITRowFilter == null) return;
			m_SPITRowFilter.setFilterString(p_FilterString);
		} 

		public boolean contains(SPIT_Type_Interface p_SPIT_Type_Interface) {
			if (p_SPIT_Type_Interface == null) return false;
			return m_SPIT_Objects.contains(p_SPIT_Type_Interface);
		}
		public boolean contains(String p_ID) {
			if (p_ID == null) return false;
			SPIT_Object_Interface o_SPIT_Object_Interface;
			o_SPIT_Object_Interface = getSPIT_Object(p_ID);
			if (o_SPIT_Object_Interface == null) return false;
			else return true;
		}
		
		public SPIT_Object_Interface getSPIT_Object(String p_ID) {
			SPIT_Object_Interface o_SPIT_Object_Interface;
			synchronized(m_SyncObject) {
				for (int intType = 0; intType < m_SPIT_Objects.size(); intType++) {
					o_SPIT_Object_Interface = m_SPIT_Objects.get(intType);
					if (o_SPIT_Object_Interface == null) continue;
					if (p_ID.equals(o_SPIT_Object_Interface.getID())) {
						return o_SPIT_Object_Interface;
					}
				}
			}
			return null;
		}
		
		public boolean addSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
			if (p_SPIT_Object_Interface == null) return false;
			int intRow;
			synchronized(m_SyncObject) {
				intRow = m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
				if (intRow >= 0) {
					fireTableRowsUpdated(intRow, intRow);
					return false;
				}
				m_SPIT_Objects.add(p_SPIT_Object_Interface);
				intRow = m_SPIT_Objects.size()-1;
				p_SPIT_Object_Interface.addPropertyChangeListener(this);
			}
			fireTableRowsInserted(intRow, intRow);
			return true;
		}

		public boolean removeSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
			if (p_SPIT_Object_Interface == null) return false;
			int intRow;
			synchronized(m_SyncObject) {
				intRow = m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
				if (intRow < 0) return false;
				m_SPIT_Objects.remove(p_SPIT_Object_Interface);
				p_SPIT_Object_Interface.removePropertyChangeListener(this);
			}
			fireTableRowsDeleted(intRow, intRow);
			return true;
		}

		public int getRowOfSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
			synchronized(m_SyncObject) {
				return m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
			}
		}

		public void addSelectedSPIT_Object(JTable p_JTable, SPIT_Object_Interface p_SPIT_Object_Interface) {
			if (p_JTable == null) return;
			if (p_SPIT_Object_Interface == null) return;
			int intRow;
			synchronized(m_SyncObject) {
				intRow = m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
				if (intRow < 0) return;
				intRow = p_JTable.convertRowIndexToView(intRow);
			}
			p_JTable.setRowSelectionInterval(intRow, intRow);
//			p_JTable.getSelectionModel().addSelectionInterval(intRow, intRow);
//			p_JTable.revalidate();
		}
		public void removeSelectedSPIT_Object(JTable p_JTable, SPIT_Object_Interface p_SPIT_Object_Interface) {
			if (p_JTable == null) return;
			if (p_SPIT_Object_Interface == null) return;
			int intRow;
			synchronized(m_SyncObject) {
				intRow = m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
				if (intRow < 0) return;
				intRow = p_JTable.convertRowIndexToView(intRow);
			}
			p_JTable.removeRowSelectionInterval(intRow, intRow); //getSelectionModel().removeSelectionInterval(intRow, intRow);
		}

		public SPIT_Object_Interface getSPIT_Object(int p_Index) {
			if (p_Index < 0) return null;
			synchronized(m_SyncObject) {
				if (p_Index >= m_SPIT_Objects.size()) return null;
				return m_SPIT_Objects.get(p_Index);
			}
		}

		@Override
		public int getRowCount() {
			return m_SPIT_Objects.size();
		}

		@Override
		public int getColumnCount() {
			return COLUMNCOUNT;
		}

		@Override
		public String getColumnName(int col) {
			switch(col) {
				case COLUMNINDEX_SPITTYPEGROUPNAME:
					return COLUMN_SPITTYPEGROUPNAME;
				case COLUMNINDEX_OBJECTNAME:
					return COLUMN_OBJECTNAME;
				case COLUMNINDEX_OBJECTPLAYVALUE:
					return COLUMN_OBJECTPLAYVALUE;
				case COLUMNINDEX_SPITTYPENAME:
					return COLUMN_SPITTYPENAME;
			}
			return "";
		}

		@Override
		public Object getValueAt(int rowIndex, int columnIndex) {
			String stringValue = "";
			SPIT_Object_Interface o_SPIT_Object_Interface;
			SPIT_ActionStatus o_SPIT_ActionStatus;
			synchronized(m_SyncObject) {
				o_SPIT_Object_Interface = getSPIT_Object(rowIndex);
				if (o_SPIT_Object_Interface == null) return stringValue;
				o_SPIT_ActionStatus = o_SPIT_Object_Interface.getSPIT_ActionStatus();
				SPIT_Type_Interface o_SPIT_Type_Interface;
				o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type();
				
				switch(columnIndex) {
					case COLUMNINDEX_SPITTYPEGROUPNAME:
						if (o_SPIT_Type_Interface == null) return "";
						stringValue = o_SPIT_Type_Interface.getGroupName();
						break;
					case COLUMNINDEX_OBJECTNAME:
						stringValue = o_SPIT_Object_Interface.getName();
						break;
					case COLUMNINDEX_OBJECTPLAYVALUE:
						//ppm -> percent
						if (o_SPIT_ActionStatus.getPlayValue() == 0) stringValue = "";
						else stringValue = String.valueOf((int)(o_SPIT_ActionStatus.getPlayValue() * (o_SPIT_Object_Interface.getValueFactor() / 1000000f ) / 10000f));
						break;
					case COLUMNINDEX_SPITTYPENAME:
						if (o_SPIT_Type_Interface == null) return "";
						stringValue = o_SPIT_Type_Interface.getName();
						break;
				}
				return stringValue;
			}
		}

		@Override
		public boolean isCellEditable(int row, int col) {
			switch(col) {
				case COLUMNINDEX_SPITTYPEGROUPNAME:
					return false;
				case COLUMNINDEX_OBJECTNAME:
					return false;
				case COLUMNINDEX_OBJECTPLAYVALUE:
					return false;
				case COLUMNINDEX_SPITTYPENAME:
					return false;
			}
			return false;
		}

	 /*
		 * Don't need to implement this method unless your table's
		 * data can change.
		 */
		@Override
		public void setValueAt(Object value, int row, int col) {
			SPIT_Object_Interface o_SPIT_Object_Interface;
			String stringValue;
			if (!(value instanceof String)) {
				return;
			}
			synchronized(m_SyncObject) {
				if (row < 0 || row >= m_SPIT_Objects.size()) return;
				o_SPIT_Object_Interface = m_SPIT_Objects.get(row);
				if (o_SPIT_Object_Interface == null) return;
			}
			switch (col) {
			}
//			fireTableCellUpdated(row, col);
		}


		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			if (evt.getSource() instanceof SPIT_Object_Interface) {
				int intRow;
				SPIT_Object_Interface o_SPIT_Object_Interface;
				o_SPIT_Object_Interface = (SPIT_Object_Interface)evt.getSource();
				if (SPIT_Object_Interface.PROP_PARAMCHANGED.equals(evt.getPropertyName())) {
					intRow = getRowOfSPIT_Object(o_SPIT_Object_Interface);
					if (intRow >= 0) {
						fireTableRowsUpdated(intRow, intRow);
					}
				}
				if (SPIT_Object_Interface.PROP_CONFIRMED.equals(evt.getPropertyName())) {
					intRow = getRowOfSPIT_Object(o_SPIT_Object_Interface);
					if (intRow >= 0) {
						fireTableRowsUpdated(intRow, intRow);
					}
				}
			}
		}

		
	public static class SPITRowFilter extends RowFilter<SPIT_Object_Interface, Integer> {
		private RemoteSPITObjectTableModel m_RemoteSPITObjectTableModel;
		private String		m_FilterString;
			
		public SPITRowFilter(RemoteSPITObjectTableModel p_SPIT_ObjectModel) {
			super();
			initMembers();
			m_RemoteSPITObjectTableModel = p_SPIT_ObjectModel;
		}
		private void initMembers() {
			m_FilterString = null;
		}
		public void setFilterString(String p_FilterString) {
			if (p_FilterString == null) m_FilterString = "";
			else m_FilterString = p_FilterString.toLowerCase();
			if (m_RemoteSPITObjectTableModel != null) {
				m_RemoteSPITObjectTableModel.fireTableDataChanged();
			}
		} 
		@Override
		public boolean include(RowFilter.Entry entry) {
			if (m_RemoteSPITObjectTableModel == null) return false;
			int intRow;
			SPIT_Object_Interface o_SPIT_Object_Interface;
			SPIT_Type_Interface o_SPIT_Type_Interface;
			
			intRow = (int)entry.getIdentifier();
			o_SPIT_Object_Interface = m_RemoteSPITObjectTableModel.getSPIT_Object(intRow);
			if (o_SPIT_Object_Interface == null) return false;
			
			if (m_FilterString == null) return true;
			if (m_FilterString.length() <= 0) return true;
			if (o_SPIT_Object_Interface.getName().toLowerCase().contains(m_FilterString)) return true;
			o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type();
			if (o_SPIT_Type_Interface == null) return false;
			if (o_SPIT_Type_Interface.getGroupName().toLowerCase().contains(m_FilterString)) return true;
			if (o_SPIT_Type_Interface.getName().toLowerCase().contains(m_FilterString)) return true;
			return false;
		}
	}
		
		
	public static class RemoteSPITObjectCellRenderer extends JLabel implements TableCellRenderer, Serializable {

	   /**
		* An empty <code>Border</code>. This field might not be used. To change the
		* <code>Border</code> used by this renderer override the
		* <code>getTableCellRendererComponent</code> method and set the border
		* of the returned component directly.
		*/
		private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
		protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;

		// We need a place to store the color the JLabel should be returned
		// to after its foreground and background colors have been set
		// to the selection background color.
		// These ivars will be made protected when their names are finalized.
		private Color m_UnselectedForeground;
		private Color m_UnselectedBackground;
		public static Color	s_NotConfirmedColor = new Color(255, 200, 200);
		public static Color	s_FIXEDColor = new Color(0, 100, 0);

		/**
		 * Creates a default table cell renderer.
		 */
		public RemoteSPITObjectCellRenderer(int p_FontSize) {
			super();
			super.setFont(new Font(getFont().getFamily(), Font.PLAIN, p_FontSize));
			setOpaque(true);
			setBorder(getNoFocusBorder());
			setName("Table.cellRenderer");
		}

		private Border getNoFocusBorder() {
			return m_NoFocusBorder;
		}

		/**
		 * Overrides <code>JComponent.setForeground</code> to assign
		 * the unselected-foreground color to the specified color.
		 *
		 * @param c set the foreground color to this value
		 */
		@Override
		public void setForeground(Color c) {
			super.setForeground(c);
			m_UnselectedForeground = c;
		}

		/**
		 * Overrides <code>JComponent.setBackground</code> to assign
		 * the unselected-background color to the specified color.
		 *
		 * @param c set the background color to this value
		 */
		@Override
		public void setBackground(Color c) {
			super.setBackground(c);
			m_UnselectedBackground = c;
		}

		/**
		 * Notification from the <code>UIManager</code> that the look and feel
		 * [L&F] has changed.
		 * Replaces the current UI object with the latest version from the
		 * <code>UIManager</code>.
		 *
		 * @see JComponent#updateUI
		 */
		@Override
		public void updateUI() {
			super.updateUI();
			setForeground(null);
			setBackground(null);
		}

		// implements javax.swing.table.TableCellRenderer
		/**
		 *
		 * Returns the default table cell renderer.
		 * <p>
		 * During a printing operation, this method will be called with
		 * <code>isSelected</code> and <code>hasFocus</code> values of
		 * <code>false</code> to prevent selection and focus from appearing
		 * in the printed output. To do other customization based on whether
		 * or not the table is being printed, check the return value from
		 * {@link javax.swing.JComponent#isPaintingForPrint()}.
		 *
		 * @param table  the <code>JTable</code>
		 * @param value  the value to assign to the cell at
		 *			<code>[row, column]</code>
		 * @param isSelected true if cell is selected
		 * @param hasFocus true if cell has focus
		 * @param row  the row of the cell to render
		 * @param column the column of the cell to render
		 * @return the default table cell renderer
		 * @see javax.swing.JComponent#isPaintingForPrint()
		 */
		@Override
		public Component getTableCellRendererComponent(JTable table, Object value,
							  boolean isSelected, boolean hasFocus, int row, int column) {

			Color colorBackground;
			Color colorForeground;
			
			colorBackground = table.getBackground();
			colorForeground = table.getForeground();
			
			
			JTable.DropLocation dropLocation = table.getDropLocation();
			if (dropLocation != null
					&& !dropLocation.isInsertRow()
					&& !dropLocation.isInsertColumn()
					&& dropLocation.getRow() == row
					&& dropLocation.getColumn() == column) {


				isSelected = true;
			}

			try {
				if (table.convertColumnIndexToModel(column) == 0) {
					setIcon(null);
				}
				else {
					setIcon(null);
				}
			}
			catch(Exception e) {
				setIcon(null);
			}
			if (isSelected) {
				super.setForeground(table.getSelectionForeground());
				super.setBackground(table.getSelectionBackground());
			} 
			else {
				super.setForeground(colorForeground);
				super.setBackground(colorBackground);
			}

			setFont(super.getFont());

			if (hasFocus) {
				setBorder(m_NoFocusBorder);

				if (!isSelected && table.isCellEditable(row, column)) {
						Color col;
						col = table.getForeground();
						super.setForeground(col);
						col = table.getBackground();
						super.setBackground(col);
				}
			} 
			else {
				setBorder(getNoFocusBorder());
			}

			setText((value == null) ? "" : value.toString());

			return this;
		}

		/*
		 * The following methods are overridden as a performance measure to
		 * to prune code-paths are often called in the case of renders
		 * but which we know are unnecessary.  Great care should be taken
		 * when writing your own renderer to weigh the benefits and
		 * drawbacks of overriding methods like these.
		 */

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public boolean isOpaque() {
		Color back = getBackground();
		Component p = getParent();
		if (p != null) {
			p = p.getParent();
		}

		// p should now be the JTable.
		boolean colorMatch = (back != null) && (p != null) &&
			back.equals(p.getBackground()) &&
				p.isOpaque();
		return !colorMatch && super.isOpaque();
		}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 *
		 * @since 1.5
		 */
		@Override
		public void invalidate() {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void validate() {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void revalidate() {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void repaint(long tm, int x, int y, int width, int height) {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void repaint(Rectangle r) { }

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 *
		 * @since 1.5
		 */
		@Override
		public void repaint() {
		}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		// Strings get interned...
		if ("text".equals(propertyName)
				|| "labelFor".equals(propertyName)
				|| "displayedMnemonic".equals(propertyName)
				|| (("font".equals(propertyName) || "foreground".equals(propertyName))
					&& oldValue != newValue
					&& getClientProperty(javax.swing.plaf.basic.BasicHTML.propertyKey) != null)) {

				super.firePropertyChange(propertyName, oldValue, newValue);
			}
		}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) { }




		/**
		 * A subclass of <code>DefaultTableCellRenderer</code> that
		 * implements <code>UIResource</code>.
		 * <code>DefaultTableCellRenderer</code> doesn't implement
		 * <code>UIResource</code>
		 * directly so that applications can safely override the
		 * <code>cellRenderer</code> property with
		 * <code>DefaultTableCellRenderer</code> subclasses.
		 * <p>
		 * <strong>Warning:</strong>
		 * Serialized objects of this class will not be compatible with
		 * future Swing releases. The current serialization support is
		 * appropriate for short term storage or RMI between applications running
		 * the same version of Swing.  As of 1.4, support for long term storage
		 * of all JavaBeans<sup><font size="-2">TM</font></sup>
		 * has been added to the <code>java.beans</code> package.
		 * Please see {@link java.beans.XMLEncoder}.
		 */
		public static class UIResource extends DefaultTableCellRenderer
			implements javax.swing.plaf.UIResource {
		}

	}
	
		
}
	
	

