/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITClientPackage;

import SPITActionPackage.SPIT_ActionStatus;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_ObjectDescription;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import SPITActionPackage.SPIT_Action_Interface;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITRemotePackage.SPITRemote;
import SwingModelPackage.SPIT_ObjectModel;
import SwingModelPackage.SinglePropertyChangeSupport;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.UUID;

/**
 *
 * @author Hagi
 */
public class SPIT_Object implements SPIT_Object_Interface, Externalizable {
	public static SPIT_ObjectModel	s_SPIT_ObjectModel = new SPIT_ObjectModel();
	
	public static ArrayList<SPIT_Object_Listener>	s_SPIT_Object_Listeners = new ArrayList<>();
	public static final Object						s_SyncListeners = new Object();
	
	private SPIT_ObjectDescription	m_SPIT_ObjectDescription;	//contains all parametere/members of a SPIT_Object
	private boolean					m_Confirmed;	//true = both the control side and the client side have this SPIT_Object 
												//false = a site has not yet confirmed the existence of this instance
	private boolean					m_SelfCreated;
	private boolean					m_ServerProjectDepending;
	private SPIT_Action_Interface	m_SPIT_Action_Interface;	//an object which implements SPIT_Action_Interface interface
												//this is the action the SPIT_Object will do when it is played
	private Object					m_SPIT_Action_Object;	//an object which will be changed by playAction()
	
	private SPIT_ActionStatus		m_SPIT_ActionStatus; //when the object is played (Play-Sequence) the status will be set
	private final Object			m_SyncActions = new Object();
	
	private SinglePropertyChangeSupport	m_SinglePropertyChangeSupport; //alternative PropertyChangeSupport

	
	public static boolean addSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ClientInterface p_SPIT_ClientInterface) {
		if (p_SPIT_Object_Interface == null) return false;
		boolean boolRemote = false;
		boolean boolAdded = false;
		SPIT_Message o_SPIT_Message;
		
		SPIT_Type_Interface o_SPIT_Type_Interface;
		
		// the remote SPIT_Types are listet in SPITRemote
		o_SPIT_Type_Interface = SPITRemote.getRemoteSPIT_Type(p_SPIT_Object_Interface.getSPITTypeID());
		if (o_SPIT_Type_Interface != null) {
			//Remote
			return SPITRemote.addRemoteSPIT_Object(p_SPIT_Object_Interface);
		}
		o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(p_SPIT_Object_Interface.getSPITTypeID());
		if (o_SPIT_Type_Interface == null) return false;
				
		boolAdded = s_SPIT_ObjectModel.addSPIT_Object(p_SPIT_Object_Interface);
		if (boolAdded) {
			//Add p_SPIT_Object_Interface as PropertyChangeListener to o_SPIT_Type_Interface
			o_SPIT_Type_Interface.addPropertyChangeListener(p_SPIT_Object_Interface);
			notifySPIT_Object_Added(p_SPIT_Object_Interface);
			if (p_SPIT_Object_Interface.getConfirmed() == false) {
				if (p_SPIT_ClientInterface != null) {
					o_SPIT_Message = SPIT_Message.createReportSPITObject(p_SPIT_Object_Interface);
					p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message);
				}
			}
		}
		return boolAdded;
	}
	public static boolean addSPIT_Object_ReadExternal(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ClientInterface p_SPIT_ClientInterface) {
		if (p_SPIT_Object_Interface == null) return false;
		boolean boolRemote = false;
		boolean boolAdded = false;
		SPIT_Message o_SPIT_Message;
		
		SPIT_Type_Interface o_SPIT_Type_Interface;
		
		// the remote SPIT_Types are listet in SPITRemote
		o_SPIT_Type_Interface = SPITRemote.getRemoteSPIT_Type(p_SPIT_Object_Interface.getSPITTypeID());
		if (o_SPIT_Type_Interface != null) {
			//Remote
			return SPITRemote.addRemoteSPIT_Object_ReadExternal(p_SPIT_Object_Interface);
		}
		o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(p_SPIT_Object_Interface.getSPITTypeID());
		if (o_SPIT_Type_Interface == null) {
			p_SPIT_Object_Interface.close();
			return false;
		}
				
		boolAdded = s_SPIT_ObjectModel.addSPIT_Object(p_SPIT_Object_Interface);
		if (boolAdded) {
			//Add p_SPIT_Object_Interface as PropertyChangeListener to o_SPIT_Type_Interface
			o_SPIT_Type_Interface.addPropertyChangeListener(p_SPIT_Object_Interface);
/*			notifySPIT_Object_Added(p_SPIT_Object_Interface);
			if (p_SPIT_Object_Interface.getConfirmed() == false) {
				if (p_SPIT_ClientInterface != null) {
					o_SPIT_Message = SPIT_Message.createReportSPITObject(p_SPIT_Object_Interface);
					p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message);
				}
			}
*/
		}
		return boolAdded;
	}
	
	public static boolean removeSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ClientInterface p_SPIT_Client) {
		if (p_SPIT_Object_Interface == null) return false;
		boolean boolRemoved = false;
		SPIT_Message o_SPIT_Message;
		
		// the remote SPIT_Objects are listet in SPITRemote
		if (p_SPIT_Object_Interface.getServerRemote() == true) {
			return SPITRemote.removeRemoteSPIT_Object(p_SPIT_Object_Interface);
		}
		//non remote SPIT_Objects are listet in SPIT_Object
		boolRemoved = s_SPIT_ObjectModel.removeSPIT_Object(p_SPIT_Object_Interface);
		if (boolRemoved) {
			notifySPIT_Object_Removed(p_SPIT_Object_Interface);
			if (p_SPIT_Client != null) {
				o_SPIT_Message = SPIT_Message.createRemoveSPITObject(p_SPIT_Object_Interface.getID());
				p_SPIT_Client.sendSPIT_Message(o_SPIT_Message);
			}
			p_SPIT_Object_Interface.close();
		}
		return boolRemoved;
	}
	
	
	
	public static int getSPIT_ObjectCount() {
		return s_SPIT_ObjectModel.getRowCount();
	}
	public static SPIT_Object_Interface getSPIT_Object(String p_ID) {
		return s_SPIT_ObjectModel.getSPIT_Object(p_ID);
	}
	public static SPIT_Object_Interface getSPIT_Object(int p_Index) {
		return s_SPIT_ObjectModel.getSPIT_Object(p_Index);
	}
	
	public static boolean parseReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject, SPIT_ClientInterface p_SPIT_Client, boolean p_IsTransferringProject) {
		if (p_ReportSPITObject == null) return false;
		SPIT_Type_Interface o_SPIT_Type_Interface;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		
		// the remote SPIT_Objects are listet in SPITRemote
		if (p_ReportSPITObject.getServerRemote()) {
			//Remote
			return SPITRemote.parseRemoteSPIT_Object(p_ReportSPITObject);
		}
		
		//Check SPIT_Type
		o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(p_ReportSPITObject.getSPITTypeID());
		if (o_SPIT_Type_Interface == null) return false;
		
		o_SPIT_Object_Interface = getSPIT_Object(p_ReportSPITObject.getID());
		if (o_SPIT_Object_Interface == null) {
			o_SPIT_Object_Interface = new SPIT_Object();
			o_SPIT_Object_Interface.readReportSPITObject(p_ReportSPITObject);
			o_SPIT_Object_Interface.setConfirmed(true);
			addSPIT_Object(o_SPIT_Object_Interface, p_SPIT_Client);
			return true;
		}
		
		// the Server is transferring his project 
		if (p_IsTransferringProject) {
			if (o_SPIT_Object_Interface.checkEqualsReportSPITObject(p_ReportSPITObject) == true) {
				o_SPIT_Object_Interface.setConfirmed(true);
			}
			else {
				o_SPIT_Object_Interface.setConfirmed(false);
				//dont't overwrite the SPIT_Object members, because the server will list the o_SPIT_Object_Interface as conflict
			}
			return true;
		}
		
		//SPIT_Object exists - no project transfer
		o_SPIT_Object_Interface.setConfirmed(true);
		o_SPIT_Object_Interface.readReportSPITObject(p_ReportSPITObject);
		return true;
	}
	public static boolean parseSPITObject_Removed(SPIT_Message.RemoveSPITObject p_RemoveSPITObject, SPIT_ClientInterface p_SPIT_Client) {	
		if (p_RemoveSPITObject == null) return false;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		boolean boolRemote = false;
		
		o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object(p_RemoveSPITObject.getID());
		if (o_SPIT_Object_Interface != null) {
			//Remote
			return SPITRemote.removeRemoteSPIT_Object(o_SPIT_Object_Interface);
		}
		o_SPIT_Object_Interface = getSPIT_Object(p_RemoveSPITObject.getID());
		return removeSPIT_Object(o_SPIT_Object_Interface, p_SPIT_Client);
	}
	
	public static boolean parseReportPlayStatus(SPIT_Message.ReportPlayStatus p_ReportPlayStatus) {
		if (p_ReportPlayStatus == null) return false;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		boolean boolRemote;
		o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object(p_ReportPlayStatus.getID());
		if (o_SPIT_Object_Interface != null) {
			boolRemote = true;
		}
		else {
			boolRemote = false;
			o_SPIT_Object_Interface = getSPIT_Object(p_ReportPlayStatus.getID());
		}
		if (o_SPIT_Object_Interface == null) return false;
		
		return o_SPIT_Object_Interface.readReportPlayStatus(p_ReportPlayStatus);
	}
	
	
	public static void parseReportSPITProject() {
		unconfirmeAll();
	}
	public static void parseCloseSPITProject_Server() {
		unconfirmeAll();
	}
	public static void parseCloseSPITProject_Client() {
		SPIT_Object_Interface o_SPIT_Object_Interface;
		for (int intSPITObject = s_SPIT_ObjectModel.getRowCount()-1; intSPITObject >= 0; intSPITObject--) {
			o_SPIT_Object_Interface = s_SPIT_ObjectModel.getSPIT_Object(intSPITObject);
			if (o_SPIT_Object_Interface == null) continue;
			s_SPIT_ObjectModel.removeSPIT_Object(o_SPIT_Object_Interface);
			o_SPIT_Object_Interface.close();
		}
	}
	
	public static void unconfirmeAll() {
		int intSPIT_ObjectCount;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		intSPIT_ObjectCount = s_SPIT_ObjectModel.getRowCount();
		for (int intSPITObject = 0; intSPITObject < intSPIT_ObjectCount; intSPITObject++) {
			o_SPIT_Object_Interface = s_SPIT_ObjectModel.getSPIT_Object(intSPITObject);
			if (o_SPIT_Object_Interface == null) continue;
			o_SPIT_Object_Interface.setConfirmed(false);
		}
	}
	
	// --- SPIT_Object_Listener ---
	public static void addSPIT_Object_Listener(SPIT_Object_Listener p_SPIT_Object_Listener) {
		if (p_SPIT_Object_Listener == null) return;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Object_Listeners.contains(p_SPIT_Object_Listener)) return;
			s_SPIT_Object_Listeners.add(p_SPIT_Object_Listener);
		}
	}
	public static void removeSPIT_Object_Listener(SPIT_Object_Listener p_SPIT_Object_Listener) {
		if (p_SPIT_Object_Listener == null) return;
		synchronized(s_SyncListeners) {
			s_SPIT_Object_Listeners.remove(p_SPIT_Object_Listener);
		}
	}
	public static void notifySPIT_Object_Added(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		ArrayList<SPIT_Object_Listener> o_SPIT_Object_Listeners;
		SPIT_Object_Listener o_SPIT_Object_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Object_Listeners.size() <= 0) return;
			o_SPIT_Object_Listeners = new ArrayList<>(s_SPIT_Object_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Object_Listeners.size(); intListener++) {
			o_SPIT_Object_Listener = o_SPIT_Object_Listeners.get(intListener);
			o_SPIT_Object_Listener.eventSPIT_Object_Added(p_SPIT_Object_Interface);
		}
	}
	public static void notifySPIT_Object_Changed(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		ArrayList<SPIT_Object_Listener> o_SPIT_Object_Listeners;
		SPIT_Object_Listener o_SPIT_Object_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Object_Listeners.size() <= 0) return;
			o_SPIT_Object_Listeners = new ArrayList<>(s_SPIT_Object_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Object_Listeners.size(); intListener++) {
			o_SPIT_Object_Listener = o_SPIT_Object_Listeners.get(intListener);
			o_SPIT_Object_Listener.eventSPIT_Object_Changed(p_SPIT_Object_Interface);
		}
	}
	public static void notifySPIT_Object_Removed(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		ArrayList<SPIT_Object_Listener> o_SPIT_Object_Listeners;
		SPIT_Object_Listener o_SPIT_Object_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Object_Listeners.size() <= 0) return;
			o_SPIT_Object_Listeners = new ArrayList<>(s_SPIT_Object_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Object_Listeners.size(); intListener++) {
			o_SPIT_Object_Listener = o_SPIT_Object_Listeners.get(intListener);
			o_SPIT_Object_Listener.eventSPIT_Object_Removed(p_SPIT_Object_Interface);
		}
	}
	public static void notifyRemoteSPIT_Object_Added(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		ArrayList<SPIT_Object_Listener> o_SPIT_Object_Listeners;
		SPIT_Object_Listener o_SPIT_Object_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Object_Listeners.size() <= 0) return;
			o_SPIT_Object_Listeners = new ArrayList<>(s_SPIT_Object_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Object_Listeners.size(); intListener++) {
			o_SPIT_Object_Listener = o_SPIT_Object_Listeners.get(intListener);
			o_SPIT_Object_Listener.eventRemoteSPIT_Object_Added(p_SPIT_Object_Interface);
		}
	}
	public static void notifyRemoteSPIT_Object_Changed(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		ArrayList<SPIT_Object_Listener> o_SPIT_Object_Listeners;
		SPIT_Object_Listener o_SPIT_Object_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Object_Listeners.size() <= 0) return;
			o_SPIT_Object_Listeners = new ArrayList<>(s_SPIT_Object_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Object_Listeners.size(); intListener++) {
			o_SPIT_Object_Listener = o_SPIT_Object_Listeners.get(intListener);
			o_SPIT_Object_Listener.eventRemoteSPIT_Object_Changed(p_SPIT_Object_Interface);
		}
	}
	public static void notifyRemoteSPIT_Object_Removed(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		ArrayList<SPIT_Object_Listener> o_SPIT_Object_Listeners;
		SPIT_Object_Listener o_SPIT_Object_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Object_Listeners.size() <= 0) return;
			o_SPIT_Object_Listeners = new ArrayList<>(s_SPIT_Object_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Object_Listeners.size(); intListener++) {
			o_SPIT_Object_Listener = o_SPIT_Object_Listeners.get(intListener);
			o_SPIT_Object_Listener.eventRemoteSPIT_Object_Removed(p_SPIT_Object_Interface);
		}
	}
	
	
	
	
	/**
	 * Standard constructor, should only be used before  readExternal
	 */
	public SPIT_Object() {
		initMembers();
		m_SPIT_ObjectDescription = new SPIT_ObjectDescription();
		m_Confirmed = false;
		m_SelfCreated = true;
		m_ServerProjectDepending = false;
	}
	
	/**
	 * Used by parseReportSPITObject to create not existing SPIT_Objects<br>
	 * @param p_ReportSPITObject
	 * @see #parseReportSPITObject(SPITLibraryPackage.SPIT_Message.ReportSPITObject, SPITLibraryPackage.SPIT_ClientInterface, boolean) 
	 */
	public SPIT_Object(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
		SPIT_Type_Interface o_SPIT_Type_Interface;
		initMembers();
		m_SPIT_ObjectDescription = new SPIT_ObjectDescription();
		if (p_ReportSPITObject != null) {
			m_SPIT_ObjectDescription.readReportSPITObject(p_ReportSPITObject);
		}
		o_SPIT_Type_Interface = getSPIT_Type();
		if (o_SPIT_Type_Interface != null) {
			o_SPIT_Type_Interface.addPropertyChangeListener(this);
		}
		m_Confirmed = true;
	}
	
	/**
	 * Can be used to create a SPIT_Object instance.
	 * @param p_SPIT_ObjectDescription should have proper filled paramters<br>
	 * to avoid mistakes (for excample when p_SPIT_ObjectDescription is used in several constructors):<br>
	 * the constructor creates a new SPIT_ObjectDescription and copies all members of p_SPIT_ObjectDescription.<br>
	 * When the 'fixed' member (p_SPIT_ObjectDescription.getFixed()) is true: <br>
	 *  - the id of p_SPIT_ObjectDescription is used,  Take care that two instances of SPIT_Object have never the same id!!!<br> 
	 *  - the 'confirmed' member is set to true
	 * When the 'fixed' member (p_SPIT_ObjectDescription.getFixed()) is false:<br>
	 *  - a new id is created.<br>
	 *  - the 'confirmed' member is set to false
	 */
	public SPIT_Object(SPIT_ObjectDescription p_SPIT_ObjectDescription) {
		SPIT_Type_Interface o_SPIT_Type_Interface;
		initMembers();
		//to avoid mistakes (for excample when p_SPIT_TypeDescription is used in several constructors)
		//we create a new description and copy all values of p_SPIT_TypeDescription
		m_SPIT_ObjectDescription = new SPIT_ObjectDescription();
		if (p_SPIT_ObjectDescription != null) {
			if (p_SPIT_ObjectDescription.getFixed()) {
				m_SPIT_ObjectDescription.copyFromDescription(p_SPIT_ObjectDescription);
				m_Confirmed = true;
			}
			else {
				p_SPIT_ObjectDescription.setID(UUID.randomUUID().toString());
				m_SPIT_ObjectDescription.copyFromDescription(p_SPIT_ObjectDescription);
				m_Confirmed = false;
			}
		}
		o_SPIT_Type_Interface = getSPIT_Type();
		if (o_SPIT_Type_Interface != null) {
			o_SPIT_Type_Interface.addPropertyChangeListener(this);
		}
		m_SelfCreated = true;
	}

	private void initMembers() {
		m_SPIT_ActionStatus = new SPIT_ActionStatus();
		m_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(this);
		m_Confirmed = false;
		m_SPIT_Action_Interface = null;
		m_SPIT_Action_Object = null;
		m_SelfCreated = false;
		SPIT_ObjectDescription.s_InstanceCount++;
	}
	
	@Override
	public void close() {
		SPIT_Type_Interface o_SPIT_Type_Interface;
		o_SPIT_Type_Interface = getSPIT_Type();
		if (o_SPIT_Type_Interface != null) {
			o_SPIT_Type_Interface.removePropertyChangeListener(this);
		}
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_CLOSED, null, this);
		m_SPIT_Action_Interface = null;
		m_SPIT_Action_Object = null;
		m_SinglePropertyChangeSupport.clear();
	}
	
	public boolean getIsSelfCreated() {
		return m_SelfCreated;
	}
	
	@Override
	public SPIT_ObjectDescription getSPIT_ObjectDescription() {
		return m_SPIT_ObjectDescription;
	}
	
	@Override
	public void setID(String p_ID) {
		if (m_SPIT_ObjectDescription.setID(p_ID) == false) return;
	}
	@Override
	public String getID() {
		return m_SPIT_ObjectDescription.getID();
	}
	
	@Override
	public void setFixed(boolean p_Fixed) {
		if (m_SPIT_ObjectDescription.setFixed(p_Fixed) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			//SPITRemote will only send the message when s_SPIT_ServerInterface is set 
			//SPITRemote.s_SPIT_ServerInterface is only set on server side
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public boolean getFixed() {
		return m_SPIT_ObjectDescription.getFixed();
	}
	@Override
	public void setServerRemote(boolean p_IsServerRemote) {
		if (m_SPIT_ObjectDescription.setServerRemote(p_IsServerRemote) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message = null;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public boolean getServerRemote() {
		return m_SPIT_ObjectDescription.getServerRemote();
	}
	

	@Override
	public void setName(String p_Name) {
		if (m_SPIT_ObjectDescription.setName(p_Name) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public String getName() {
		return m_SPIT_ObjectDescription.getName();
	}
	
	@Override
	public void setSPITTypeID(String p_SPITTypeID) {
		if (m_SPIT_ObjectDescription.setSPITTypeID(p_SPITTypeID) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public String getSPITTypeID() {
		return m_SPIT_ObjectDescription.getSPITTypeID();
	}
	@Override
	public SPIT_Type_Interface getSPIT_Type() {
		SPIT_Type_Interface o_SPIT_Type_Interface;
		o_SPIT_Type_Interface = SPITRemote.getRemoteSPIT_Type(m_SPIT_ObjectDescription.getSPITTypeID());
		if (o_SPIT_Type_Interface == null) {
			o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(m_SPIT_ObjectDescription.getSPITTypeID());
		}
		return o_SPIT_Type_Interface;
	}
	@Override
	public void setServerParams(String p_Parameters) {
		if (m_SPIT_ObjectDescription.setServerParams(p_Parameters) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public String getServerParams() {
		return m_SPIT_ObjectDescription.getServerParams();
	}
	@Override
	public void setFrameStart(long p_Time_frames) {
		if (m_SPIT_ObjectDescription.setFrameStart(p_Time_frames) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public long getFrameStart() {
		return m_SPIT_ObjectDescription.getFrameStart();
	}
	@Override
	public void setFrameLength(long p_Length_ms) {
		if (m_SPIT_ObjectDescription.setFrameLength(p_Length_ms) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public long getFrameLength() {
		return m_SPIT_ObjectDescription.getFrameLength();
	}
	@Override
	public void setFrameFadeInLength(long p_Time_ms) {
		if (m_SPIT_ObjectDescription.setFrameFadeInLength(p_Time_ms) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public long getFrameFadeInLength() {
		return m_SPIT_ObjectDescription.getFrameFadeInLength();
	}
	@Override
	public void setFrameFadeOutLength(long p_Time_ms) {
		if (m_SPIT_ObjectDescription.setFrameFadeOutLength(p_Time_ms) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public long getFrameFadeOutLength() {
		return m_SPIT_ObjectDescription.getFrameFadeOutLength();
	}
	@Override
	public void setValueFactor(int p_Volume_ppm) {
		if (m_SPIT_ObjectDescription.setValueFactor(p_Volume_ppm) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public int getValueFactor() {
		return m_SPIT_ObjectDescription.getValueFactor();
	}
	@Override
	public void setValueUse(byte p_ValueUse) {
		if (m_SPIT_ObjectDescription.setValueUse(p_ValueUse) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public byte getValueUse() {
		return m_SPIT_ObjectDescription.getValueUse();
	}
	@Override
	public void setTrack(int p_Track) {
		if (m_SPIT_ObjectDescription.setTrack(p_Track) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public int getTrack() {
		return m_SPIT_ObjectDescription.getTrack();
	}

	@Override
	public void setRemark(String p_Remark) {
		if (m_SPIT_ObjectDescription.setRemark(p_Remark) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public String getRemark() {
		return m_SPIT_ObjectDescription.getRemark();
	}
	
	@Override
	public void setDelay(long p_Delay) {
		if (m_SPIT_ObjectDescription.setDelay(p_Delay) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public long getDelay() {
		return m_SPIT_ObjectDescription.getDelay();
	}
	@Override
	public void setDuration(long p_Duration) {
		if (m_SPIT_ObjectDescription.setDuration(p_Duration) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public long getDuration() {
		return m_SPIT_ObjectDescription.getDuration();
	}

	@Override
	public void setPlayValue(int p_PlayValue) {
		if (m_SPIT_ActionStatus == null) return;
		SPIT_Message o_SPIT_Message;
		if (m_SPIT_ActionStatus.setPlayValue(p_PlayValue)) {
		}
		//Send always the ReportPlayStatus
		//because SPIT_ActionStatus.setStatus sets the value but don't send a ReportpLayStatus
		if (SPITRemote.getSPITClientInterfaceCount() > 0) {
			o_SPIT_Message = SPIT_Message.createReportPlayStatus(this);
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
		}
	}
	
	@Override
	public boolean readReportPlayStatus(SPIT_Message.ReportPlayStatus p_ReportPlayStatus) {
		if (p_ReportPlayStatus == null) return false;
		SPIT_ActionStatus o_SPIT_ActionStatus;
		o_SPIT_ActionStatus = m_SPIT_ActionStatus;
		if (o_SPIT_ActionStatus == null) return false;
		if (o_SPIT_ActionStatus.readReportPlayStatus(p_ReportPlayStatus)) {
			m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
			if (m_SPIT_ObjectDescription.getServerRemote()) {
				notifyRemoteSPIT_Object_Changed(this);
			}
			else {
				notifySPIT_Object_Changed(this);
			}
			return true;
		}
		return false;
	}
	
	@Override
	public boolean copyFromSPIT_ObjectDescription(SPIT_ObjectDescription p_TypeDescription) {
		if (p_TypeDescription == null) return false;
		if (m_SPIT_ObjectDescription.copyFromDescription(m_SPIT_ObjectDescription)){
			m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
			if (m_SPIT_ObjectDescription.getServerRemote()) {
				notifyRemoteSPIT_Object_Changed(this);
			}
			else {
				notifySPIT_Object_Changed(this);
			}
			return true;
		}
		return false;
	}
	
	@Override
	public boolean readReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
		if (p_ReportSPITObject == null) return false;
		SPIT_Type_Interface o_SPIT_Type_Interface;
		o_SPIT_Type_Interface = getSPIT_Type();
		if (m_SPIT_ObjectDescription.readReportSPITObject(p_ReportSPITObject) == true) {
			//remove Listener from old SPIT_TypeInterface
			if (o_SPIT_Type_Interface != null) {
				o_SPIT_Type_Interface.removePropertyChangeListener(this);
			}
			//Add listener to new SPIT_Type_Interface
			o_SPIT_Type_Interface = getSPIT_Type();
			if (o_SPIT_Type_Interface != null) {
				o_SPIT_Type_Interface.addPropertyChangeListener(this);
			}
			m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
			if (m_SPIT_ObjectDescription.getServerRemote()) {
				notifyRemoteSPIT_Object_Changed(this);
			}
			else {
				notifySPIT_Object_Changed(this);
			}
			return true;
		}
		return false;
		
	}
	@Override
	public boolean checkEqualsReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
		return m_SPIT_ObjectDescription.checkEqualsReportSPITObject(p_ReportSPITObject);
	}
	
	@Override
	public boolean getConfirmed() {
		return m_Confirmed;
	}
	@Override
	public void setConfirmed(boolean p_Confirmed) {
		if (m_Confirmed == p_Confirmed) return;
		boolean oldValue;
		oldValue = m_Confirmed;
		m_Confirmed = p_Confirmed;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_CONFIRMED, oldValue, m_Confirmed);
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			notifySPIT_Object_Changed(this);
		}
	}
	
	@Override
	public void setSPIT_Action_Interface(SPIT_Action_Interface p_SPIT_Action_Interface, Object p_ActionObject) {
		if (m_SPIT_Action_Interface == p_SPIT_Action_Interface && m_SPIT_Action_Object == p_ActionObject) return;
		SPIT_Action_Interface oldValue;
		oldValue = m_SPIT_Action_Interface;
		m_SPIT_Action_Interface = p_SPIT_Action_Interface;
		m_SPIT_Action_Object = p_ActionObject;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_ACTIONASSIGNED, oldValue, m_SPIT_Action_Interface);		
		//When at leat one action is assigned -> notify the server
		SPIT_Message o_SPIT_Message;
		if (oldValue == null || m_SPIT_Action_Interface == null) { 
			o_SPIT_Message = SPIT_Message.createReportSPITObject(this);
			if (m_SPIT_ObjectDescription.getServerRemote()) {
				SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			}
			else {
				SPIT_Client.sendMessage(o_SPIT_Message);
			}
		}
		if (m_SPIT_ObjectDescription.getServerRemote()) {
			notifyRemoteSPIT_Object_Changed(this);
		}
		else {
			notifySPIT_Object_Changed(this);
		}
	}
	@Override
	public SPIT_Action_Interface getSPIT_Action_Interface() {
		return m_SPIT_Action_Interface;
	}
	
	@Override
	public Object getSPIT_Action_Object() {
		return m_SPIT_Action_Object;
	}
	@Override
	public boolean getActionAssigned() {
		if (m_SPIT_Action_Interface == null) return false;
		return true;
	}
	
	
	@Override
	public SPIT_ActionStatus getSPIT_ActionStatus() {
		return m_SPIT_ActionStatus;
	}
	
	@Override
	public void playStarted() {
		//ActionStatus may be changed
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Action_Interface o_SPIT_Action_Interface;
		Object	o_SPIT_Action_Object;
		o_SPIT_Action_Interface = m_SPIT_Action_Interface;
		o_SPIT_Action_Object = m_SPIT_Action_Object;
		if (o_SPIT_Action_Interface == null) return;
		int intOldValue;
		intOldValue = m_SPIT_ActionStatus.getPlayValue();
		if (m_SPIT_ActionStatus.getPlayerIsRunning() && intOldValue < 1000000) {
			//the object is fadet either per himself or by Scenebridge
			if (getFrameFadeInLength() > 0) {
				//The object is fadet by himself
				//-> at the start of the ubject the value is 0
				m_SPIT_ActionStatus.setPlayValue(0); 
			}
		}
		o_SPIT_Action_Interface.playStarted(this, m_SPIT_ActionStatus, o_SPIT_Action_Object);
		m_SPIT_ActionStatus.setPlayValue(intOldValue);		
	}
	@Override
	public void playAction() {
		//ActionStatus may be changed
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Action_Interface o_SPIT_Action_Interface;
		Object	o_SPIT_Action_Object;
		o_SPIT_Action_Interface = m_SPIT_Action_Interface;
		o_SPIT_Action_Object = m_SPIT_Action_Object;
		if (o_SPIT_Action_Interface == null) return;
		o_SPIT_Action_Interface.play(this, m_SPIT_ActionStatus, o_SPIT_Action_Object);
		
	}
	@Override
	public void playEnd() {
		//ActionStatus may be changed
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Action_Interface o_SPIT_Action_Interface;
		Object	o_SPIT_Action_Object;
		o_SPIT_Action_Interface = m_SPIT_Action_Interface;
		o_SPIT_Action_Object = m_SPIT_Action_Object;
		if (o_SPIT_Action_Interface == null) return;
		o_SPIT_Action_Interface.playEnd(this, m_SPIT_ActionStatus, o_SPIT_Action_Object);
	}
	
	
	@Override
	public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
		if (p_PropertyChangeListener == null) return;
		m_SinglePropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
	}
	@Override
	public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
		if (p_PropertyChangeListener == null) return;
		m_SinglePropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
	}

	
	public static final int	SOFTWAREVERSION = 1; //used for externalizable changes
	@Override
	public void writeExternal(ObjectOutput out) throws IOException {
		out.writeInt(SOFTWAREVERSION);
		
		m_SPIT_ObjectDescription.writeExternal(out);
		
		//perhaps write additional members
	}

	@Override
	public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
		int intSoftwareVersion;
		SPIT_Type_Interface o_SPIT_Type_Interface;
		
		intSoftwareVersion = in.readInt();
		
		m_SPIT_ObjectDescription.readExternal(in);
		//perhaps read additional members

		//We want to load all SPIT_Objects without notifying the server
		//AFter all is loaded we make a ProjectTransfer with the server
		addSPIT_Object_ReadExternal(this, SPIT_Client.s_SelfReference);
		
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		SPIT_Type_Interface o_SPIT_Type_Interface;
		if (evt.getSource() instanceof SPIT_Type_Interface) {
			if (SPIT_Type_Interface.PROP_CLOSED.equals(evt.getPropertyName())) {
				o_SPIT_Type_Interface = (SPIT_Type_Interface)evt.getSource();
				if (o_SPIT_Type_Interface.getID().equals(m_SPIT_ObjectDescription.getSPITTypeID())) {
					removeSPIT_Object(this, SPIT_Client.s_SelfReference);
				}
			}
			else if (SPIT_Type_Interface.PROP_PARAMCHANGED.equals(evt.getPropertyName())) {
				m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
			}
		}
	}
	
}
