/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITClientGUI;

import SPITActionPackage.SPIT_ActionPlayer;
import SPITActionPackage.SPIT_Action_Interface;
import SPITServerAutoDetectPackage.ServerAutoDetect;
import SPITServerAutoDetectPackage.ServerAutoDetect_Client;
import SPITClientPackage.SPIT_Client;
import SPITClientPackage.SPIT_ClientSocket;
import SPITClientPackage.SPIT_Object;
import SPITClientPackage.SPIT_Type;
import SPITLibraryPackage.SPIT_Message;
import javax.swing.ComboBoxModel;
import java.net.InetAddress;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_ClientListener;
import SPITLibraryPackage.SPIT_Object_Interface;
import SwingModelPackage.SPIT_TypeModel;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import SPITServerAutoDetectPackage.EventQueueHandler;
import SwingModelPackage.RemoteSPITObjectTableModel;
import SwingModelPackage.SPIT_ObjectModel;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/**
 *
 * @author Hagi
 */
public class SPIT_ClientFrame extends javax.swing.JFrame implements SPIT_ClientListener, ServerAutoDetect.ServerAutoDetect_Listener, 
		SPIT_ActionPlayer.TimeCodeListener, SPIT_Type_Interface.SPIT_Type_Listener, SPIT_Object_Interface.SPIT_Object_Listener {
	private ServerAutoDetect_Client	m_ServerAutoDetect_Client;
	private SPIT_Client				m_Spit_Client;
	private boolean					m_ConnectionLost;
	private String					m_SPITServer_ProjectName;
	private SPIT_Action_Interface	m_SelectedSPIT_Action_Interface;
	private Border					m_SelectedBorder = new LineBorder(Color.BLUE, 2);

	/**
	 * Creates new form Trigger_ClientFrame
	 */
	public SPIT_ClientFrame() {
		initMembers();
		initComponents();
		initComponentsFurther();
		//Altenative to the static tablemodels of SPIT_Type or SPIT_Object
		// you can use the SPIT_Type_Listener and SPIT_Object_Listener
		// to detect add, remove and  change events 
		// or to make your own listing of types and objects
		SPIT_Type.addSPIT_Type_Listener(this);
		SPIT_Object.addSPIT_Object_Listener(this);
		//Start the autodetection of SPIT servers in the local network
		m_ServerAutoDetect_Client.startDetection(this);
		refreshGUI();		
	}
	private void initMembers() {
		m_ServerAutoDetect_Client = new ServerAutoDetect_Client(SPIT_Message.SPITID);
		m_ServerAutoDetect_Client.addServerAutoDetectListener(this);
		m_Spit_Client = new SPIT_Client("SPIT_TestClient");
		m_Spit_Client.addSPITClientListener(this);
		m_SPITServer_ProjectName = "";
		SPIT_ActionPlayer.addTimeCodeListener(this);
		m_SelectedSPIT_Action_Interface = null;
		m_ConnectionLost = false;
	}

	/**
	 * This method is called from within the constructor to initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is always
	 * regenerated by the Form Editor.
	 */
	@SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel_Frame = new javax.swing.JPanel();
        jPanel_Server = new javax.swing.JPanel();
        jLabel_ServerHeader = new javax.swing.JLabel();
        jLabel_ServerProjectName = new javax.swing.JLabel();
        jLabel_ServerComputerName = new javax.swing.JLabel();
        jLabel_ServerName = new javax.swing.JLabel();
        jComboBox_DetectedServer = new javax.swing.JComboBox<>();
        jButton_Connect = new javax.swing.JButton();
        jButton_Disconnect = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel_Project = new javax.swing.JPanel();
        jButton_AddSPITType = new javax.swing.JButton();
        jScrollPane_Types = new javax.swing.JScrollPane();
        jTable_SPITTypes = new javax.swing.JTable();
        jButton_RemoveSPITType = new javax.swing.JButton();
        jScrollPane_Objects = new javax.swing.JScrollPane();
        jTable_SPITObjects = new javax.swing.JTable();
        jLabel_SPIT_TypeHeader = new javax.swing.JLabel();
        jLabel_SPIT_ObjectHeader = new javax.swing.JLabel();
        jButton_RemoveSPITObject = new javax.swing.JButton();
        jPanel_ServerRemote = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTable_Remote_SPITObjects = new javax.swing.JTable();
        jLabel_SPIT_ObjectHeader1 = new javax.swing.JLabel();
        jButton_RemotePlay = new javax.swing.JButton();
        jButton_RemoteValuePlus = new javax.swing.JButton();
        jButton_RemoteValueMinus = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jLabel_TimeCode = new javax.swing.JLabel();
        jLabel_PlayerNameHeader = new javax.swing.JLabel();
        jPanel_SPITActions = new javax.swing.JPanel();
        jPanelActionRed = new SPITClientGUI.jPanelActionColorRed();
        jPanelActionYellow = new SPITClientGUI.jPanelActionColorYellow();
        jLabel_Actions = new javax.swing.JLabel();
        jButton_AdviseAction = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("SPITTestClient");
        setMinimumSize(new java.awt.Dimension(600, 500));
        setPreferredSize(new java.awt.Dimension(600, 600));
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jPanel_Frame.setBackground(new java.awt.Color(0, 0, 0));
        jPanel_Frame.setLayout(new java.awt.GridBagLayout());

        jPanel_Server.setBackground(new java.awt.Color(0, 0, 0));
        jPanel_Server.setLayout(new java.awt.GridBagLayout());

        jLabel_ServerHeader.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel_ServerHeader.setForeground(new java.awt.Color(255, 255, 255));
        jLabel_ServerHeader.setText("Server");
        jLabel_ServerHeader.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Server.add(jLabel_ServerHeader, gridBagConstraints);

        jLabel_ServerProjectName.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel_ServerProjectName.setForeground(new java.awt.Color(255, 255, 255));
        jLabel_ServerProjectName.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel_ServerProjectName.setText("Server's Project");
        jLabel_ServerProjectName.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Server.add(jLabel_ServerProjectName, gridBagConstraints);

        jLabel_ServerComputerName.setForeground(new java.awt.Color(255, 255, 255));
        jLabel_ServerComputerName.setText("ServerComputerName");
        jLabel_ServerComputerName.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Server.add(jLabel_ServerComputerName, gridBagConstraints);

        jLabel_ServerName.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel_ServerName.setForeground(new java.awt.Color(255, 255, 255));
        jLabel_ServerName.setText("ServerName");
        jLabel_ServerName.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Server.add(jLabel_ServerName, gridBagConstraints);

        jComboBox_DetectedServer.setModel(new javax.swing.DefaultComboBoxModel<>(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_DetectedServer.setMinimumSize(new java.awt.Dimension(56, 24));
        jComboBox_DetectedServer.setName(""); // NOI18N
        jComboBox_DetectedServer.setPreferredSize(new java.awt.Dimension(56, 24));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Server.add(jComboBox_DetectedServer, gridBagConstraints);

        jButton_Connect.setBackground(new java.awt.Color(0, 0, 0));
        jButton_Connect.setText("Connect to Server");
        jButton_Connect.setToolTipText("");
        jButton_Connect.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(51, 255, 51), 1, true));
        jButton_Connect.setMaximumSize(new java.awt.Dimension(100, 24));
        jButton_Connect.setMinimumSize(new java.awt.Dimension(100, 24));
        jButton_Connect.setPreferredSize(new java.awt.Dimension(100, 24));
        jButton_Connect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ConnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Server.add(jButton_Connect, gridBagConstraints);

        jButton_Disconnect.setBackground(new java.awt.Color(0, 0, 0));
        jButton_Disconnect.setText("Disconect");
        jButton_Disconnect.setToolTipText("");
        jButton_Disconnect.setBorder(new javax.swing.border.LineBorder(new java.awt.Color(255, 51, 0), 1, true));
        jButton_Disconnect.setMaximumSize(new java.awt.Dimension(100, 24));
        jButton_Disconnect.setMinimumSize(new java.awt.Dimension(100, 24));
        jButton_Disconnect.setPreferredSize(new java.awt.Dimension(100, 24));
        jButton_Disconnect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_DisconnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Server.add(jButton_Disconnect, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        jPanel_Frame.add(jPanel_Server, gridBagConstraints);

        jTabbedPane1.setBackground(new java.awt.Color(0, 0, 0));
        jTabbedPane1.setMinimumSize(new java.awt.Dimension(100, 100));
        jTabbedPane1.setPreferredSize(new java.awt.Dimension(200, 250));

        jPanel_Project.setBackground(new java.awt.Color(0, 0, 0));
        jPanel_Project.setPreferredSize(new java.awt.Dimension(650, 500));
        jPanel_Project.setLayout(new java.awt.GridBagLayout());

        jButton_AddSPITType.setText("+");
        jButton_AddSPITType.setToolTipText("Add SPIT Type");
        jButton_AddSPITType.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton_AddSPITType.setMaximumSize(new java.awt.Dimension(41, 41));
        jButton_AddSPITType.setMinimumSize(new java.awt.Dimension(41, 41));
        jButton_AddSPITType.setPreferredSize(new java.awt.Dimension(41, 41));
        jButton_AddSPITType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_AddSPITTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Project.add(jButton_AddSPITType, gridBagConstraints);

        jTable_SPITTypes.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jTable_SPITTypes.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jTable_SPITTypes.setRowHeight(20);
        jScrollPane_Types.setViewportView(jTable_SPITTypes);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Project.add(jScrollPane_Types, gridBagConstraints);

        jButton_RemoveSPITType.setText("-");
        jButton_RemoveSPITType.setToolTipText("Remove selected SPIT Types");
        jButton_RemoveSPITType.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton_RemoveSPITType.setMaximumSize(new java.awt.Dimension(41, 41));
        jButton_RemoveSPITType.setMinimumSize(new java.awt.Dimension(41, 41));
        jButton_RemoveSPITType.setPreferredSize(new java.awt.Dimension(41, 41));
        jButton_RemoveSPITType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_RemoveSPITTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Project.add(jButton_RemoveSPITType, gridBagConstraints);

        jTable_SPITObjects.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jTable_SPITObjects.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jTable_SPITObjects.setRowHeight(20);
        jScrollPane_Objects.setViewportView(jTable_SPITObjects);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Project.add(jScrollPane_Objects, gridBagConstraints);

        jLabel_SPIT_TypeHeader.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel_SPIT_TypeHeader.setForeground(new java.awt.Color(255, 255, 255));
        jLabel_SPIT_TypeHeader.setText("SPIT_Types");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Project.add(jLabel_SPIT_TypeHeader, gridBagConstraints);

        jLabel_SPIT_ObjectHeader.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel_SPIT_ObjectHeader.setForeground(new java.awt.Color(255, 255, 255));
        jLabel_SPIT_ObjectHeader.setText("SPIT_Objects");
        jLabel_SPIT_ObjectHeader.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Project.add(jLabel_SPIT_ObjectHeader, gridBagConstraints);

        jButton_RemoveSPITObject.setText("-");
        jButton_RemoveSPITObject.setToolTipText("Remove selected SPIT Object");
        jButton_RemoveSPITObject.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton_RemoveSPITObject.setMaximumSize(new java.awt.Dimension(41, 41));
        jButton_RemoveSPITObject.setMinimumSize(new java.awt.Dimension(41, 41));
        jButton_RemoveSPITObject.setPreferredSize(new java.awt.Dimension(41, 41));
        jButton_RemoveSPITObject.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_RemoveSPITObjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Project.add(jButton_RemoveSPITObject, gridBagConstraints);

        jTabbedPane1.addTab("Client", jPanel_Project);

        jPanel_ServerRemote.setBackground(new java.awt.Color(0, 0, 0));
        jPanel_ServerRemote.setLayout(new java.awt.GridBagLayout());

        jTable_Remote_SPITObjects.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jTable_Remote_SPITObjects.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null},
                {null, null, null, null}
            },
            new String [] {
                "Title 1", "Title 2", "Title 3", "Title 4"
            }
        ));
        jTable_Remote_SPITObjects.setRowHeight(20);
        jTable_Remote_SPITObjects.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane2.setViewportView(jTable_Remote_SPITObjects);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_ServerRemote.add(jScrollPane2, gridBagConstraints);

        jLabel_SPIT_ObjectHeader1.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        jLabel_SPIT_ObjectHeader1.setForeground(new java.awt.Color(255, 255, 255));
        jLabel_SPIT_ObjectHeader1.setText("REMOTE");
        jLabel_SPIT_ObjectHeader1.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_ServerRemote.add(jLabel_SPIT_ObjectHeader1, gridBagConstraints);

        jButton_RemotePlay.setText("Play Remote");
        jButton_RemotePlay.setToolTipText("Play selected Remote Object");
        jButton_RemotePlay.setMargin(new java.awt.Insets(14, 14, 14, 14));
        jButton_RemotePlay.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_RemotePlayActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_ServerRemote.add(jButton_RemotePlay, gridBagConstraints);

        jButton_RemoteValuePlus.setText("+");
        jButton_RemoteValuePlus.setToolTipText("Decrease Value");
        jButton_RemoteValuePlus.setMargin(new java.awt.Insets(14, 14, 14, 14));
        jButton_RemoteValuePlus.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_RemoteValuePlusActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        jPanel_ServerRemote.add(jButton_RemoteValuePlus, gridBagConstraints);

        jButton_RemoteValueMinus.setText("-");
        jButton_RemoteValueMinus.setToolTipText("Increase Value");
        jButton_RemoteValueMinus.setMargin(new java.awt.Insets(14, 14, 14, 14));
        jButton_RemoteValueMinus.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_RemoteValueMinusActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        jPanel_ServerRemote.add(jButton_RemoteValueMinus, gridBagConstraints);

        jTabbedPane1.addTab("Server Remote", jPanel_ServerRemote);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Frame.add(jTabbedPane1, gridBagConstraints);

        jPanel1.setBackground(new java.awt.Color(0, 0, 0));
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabel_TimeCode.setFont(new java.awt.Font("Tahoma", 0, 14)); // NOI18N
        jLabel_TimeCode.setForeground(new java.awt.Color(255, 255, 255));
        jLabel_TimeCode.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel_TimeCode.setText("---");
        jLabel_TimeCode.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel1.add(jLabel_TimeCode, gridBagConstraints);

        jLabel_PlayerNameHeader.setForeground(new java.awt.Color(255, 255, 255));
        jLabel_PlayerNameHeader.setText("Player");
        jLabel_PlayerNameHeader.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel1.add(jLabel_PlayerNameHeader, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel_Frame.add(jPanel1, gridBagConstraints);

        jPanel_SPITActions.setBackground(new java.awt.Color(51, 51, 51));
        jPanel_SPITActions.setMinimumSize(new java.awt.Dimension(200, 10));
        jPanel_SPITActions.setPreferredSize(new java.awt.Dimension(200, 100));
        jPanel_SPITActions.setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_SPITActions.add(jPanelActionRed, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_SPITActions.add(jPanelActionYellow, gridBagConstraints);

        jLabel_Actions.setForeground(new java.awt.Color(255, 255, 255));
        jLabel_Actions.setText("Actions");
        jLabel_Actions.setToolTipText("");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_SPITActions.add(jLabel_Actions, gridBagConstraints);

        jButton_AdviseAction.setText("<-");
        jButton_AdviseAction.setToolTipText("Advise selected action to SPIT_Object");
        jButton_AdviseAction.setMargin(new java.awt.Insets(2, 2, 2, 2));
        jButton_AdviseAction.setMaximumSize(new java.awt.Dimension(41, 41));
        jButton_AdviseAction.setMinimumSize(new java.awt.Dimension(41, 41));
        jButton_AdviseAction.setPreferredSize(new java.awt.Dimension(41, 41));
        jButton_AdviseAction.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_AdviseActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_SPITActions.add(jButton_AdviseAction, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel_Frame.add(jPanel_SPITActions, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        getContentPane().add(jPanel_Frame, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

	
	private void initComponentsFurther() {
		ComboBoxModel o_ListModel;
		o_ListModel = m_ServerAutoDetect_Client.getDetectedServerListModel();
		jComboBox_DetectedServer.setModel(o_ListModel);
		jComboBox_DetectedServer.setRenderer(m_ServerAutoDetect_Client.getDetectedServer_CellRenderer());

		//the static SPIT_TypeModel is used to list the SPIT_Types in jTable_SPITTypes
		//instead you can make your own listing using SPIT_Type_Listener
		jTable_SPITTypes.setModel(SPIT_Type.s_SPIT_TypeModel);
		SPIT_Type.s_SPIT_TypeModel.finishJTable(jTable_SPITTypes);
		jTable_SPITTypes.setDefaultRenderer(String.class, new SPIT_TypeModel.SPITTypeTableCellRenderer(14));
		jTable_SPITTypes.getColumnModel().getColumn(0).getClass();
		jTable_SPITTypes.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			@Override
			public void valueChanged(ListSelectionEvent e) {
				if (e.getValueIsAdjusting()) return;
				refreshGUI();
			}
		});
		
		//the static SPIT_ObjectModel is used to list the SPIT_Objects in jTable_SPITObjects
		//instead you can make your own listing using SPIT_Object_Listener
		jTable_SPITObjects.setModel(SPIT_Object.s_SPIT_ObjectModel);
		SPIT_Object.s_SPIT_ObjectModel.finishJTable(jTable_SPITObjects);
		jTable_SPITObjects.setDefaultRenderer(String.class, new SPIT_ObjectModel.SPITObjectTableCellRenderer(14));
		jTable_SPITObjects.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			@Override
			public void valueChanged(ListSelectionEvent e) {
				if (e.getValueIsAdjusting()) return;
				refreshGUI();
			}
		});

				
		//the static SPIT_ObjectModel of SPITRemote is used to list the remote SPIT_Objects in jTable_Remote_SPITObjects
		//instead you can make your own listing using SPIT_Object_Listener
		jTable_Remote_SPITObjects.setModel(SPITRemote.s_RemoteSPITObjectModel);
		SPITRemote.s_RemoteSPITObjectModel.finishJTable(jTable_Remote_SPITObjects);
		jTable_Remote_SPITObjects.setDefaultRenderer(String.class, new RemoteSPITObjectTableModel.RemoteSPITObjectCellRenderer(14));
		jTable_Remote_SPITObjects.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
			@Override
			public void valueChanged(ListSelectionEvent e) {
				if (e.getValueIsAdjusting()) return;
				refreshGUI();
			}
		});
		
		
		jPanelActionRed.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				setSelectedAction(jPanelActionRed);
			}
		});
		jPanelActionYellow.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				setSelectedAction(jPanelActionYellow);
			}
		});
	}
	public void setSelectedAction(SPIT_Action_Interface p_SPIT_Action_Interface) {
		if (p_SPIT_Action_Interface == null) {
			m_SelectedSPIT_Action_Interface = null;
		}
		else if (m_SelectedSPIT_Action_Interface == p_SPIT_Action_Interface) {
			m_SelectedSPIT_Action_Interface = null;
		}
		else {
				m_SelectedSPIT_Action_Interface = p_SPIT_Action_Interface;
		}
		refreshGUI();
	}
	
	
	/**
	 * If ServerAutoDetect is used this function can be used to connect the SPIT_CLient to the SPIT_Server.
	 * @param p_DetectedServer autodetected server, his InetAddress and Port will be used for connection
	 * @param p_ClientPort port number of the SPIT_Client<br>
	 * maybe 0 then any free port number of the local machine is used
	 * @param p_LoginName Login name, is checked by the server when the SPITConnect message is sent 
	 * @param p_LoginPassword Login password, is checked by the server when the SPITConnect message is sent
	 * @return true = connection is ok<br>
	 * false = connection failed
	 * @see #connect(java.net.InetAddress, int, java.lang.String, java.lang.String) 
	 */
	public boolean connect(ServerAutoDetect.DetectedServer p_DetectedServer, int p_ClientPort, String p_LoginName, String p_LoginPassword) {
		if (p_DetectedServer == null) return false;
		InetAddress o_ServerInetAddress;
		int intServerPort;
		SPIT_Client o_SPIT_Client;
		o_SPIT_Client = m_Spit_Client;
		if (o_SPIT_Client == null) return false;
		o_ServerInetAddress = p_DetectedServer.getFirstInetAddress();
		intServerPort = p_DetectedServer.getPort();
		m_ConnectionLost = false;
		return o_SPIT_Client.connect(o_ServerInetAddress, intServerPort, p_ClientPort, p_LoginName, p_LoginPassword);
	}
	public boolean disconnect() {
		SPIT_Client o_SPIT_Client;
		o_SPIT_Client = m_Spit_Client;
		if (o_SPIT_Client == null) return false;
		o_SPIT_Client.disconnect(false);
		refreshGUI();
		return true;
	}
	
	public void refreshGUI() {
		int intSelectedRowCount;
		int intRow;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		SPIT_Client o_SPIT_Client;
		SPIT_ClientSocket o_SPIT_ClientSocket;
		String stringServerIP = "";
		String stringServerPort = "";
		InetAddress o_InetAddress;
		
		//Connection
		o_SPIT_Client = m_Spit_Client;
		if (o_SPIT_Client != null) {
			if (o_SPIT_Client.isConnected()) {
				jButton_Connect.setEnabled(false);
				jButton_Disconnect.setEnabled(true);
				o_SPIT_ClientSocket = m_Spit_Client.getSPIT_ClientSocket();
				if (o_SPIT_ClientSocket != null) {
					o_InetAddress = o_SPIT_ClientSocket.getServerInetAddress();
					if (o_InetAddress != null) {
						stringServerIP = SPIT_Client.cleanIPAddress(o_InetAddress.getHostAddress());
					}
					stringServerPort = String.valueOf(o_SPIT_ClientSocket.getServerPort());				}
					jLabel_ServerComputerName.setText(o_SPIT_Client.getServerComputerName() + "(" + stringServerIP + " " + stringServerPort +")");
					jLabel_ServerName.setText(o_SPIT_Client.getServerName());
			}
			else {
				jButton_Connect.setEnabled(true);
				jButton_Disconnect.setEnabled(false);
				jLabel_ServerComputerName.setText("-");
				jLabel_ServerName.setText("-");
			}
		}
		else {
			jButton_Connect.setEnabled(false);
			jButton_Disconnect.setEnabled(false);
			
		}
		
		//SPITServer Project
		jLabel_ServerProjectName.setText(m_SPITServer_ProjectName);
		
		//SPIT Types
		intSelectedRowCount = jTable_SPITTypes.getSelectedRowCount();
		if (intSelectedRowCount <= 0) {
			jButton_RemoveSPITType.setEnabled(false);
		}
		else {
			jButton_RemoveSPITType.setEnabled(true);
		}
		
		//SPIT Objects
		if (jTable_SPITObjects.getSelectedRowCount() == 1) {
			jButton_AdviseAction.setEnabled(true);
		}
		else {
			jButton_AdviseAction.setEnabled(false);
		}
		
		//Actions
		if (m_SelectedSPIT_Action_Interface == null) {
			jPanelActionRed.setBorder(null);
			jPanelActionYellow.setBorder(null);
		}
		else if (m_SelectedSPIT_Action_Interface == jPanelActionRed) {
			jPanelActionRed.setBorder(m_SelectedBorder);
			jPanelActionYellow.setBorder(null);
		}
		else {
			jPanelActionRed.setBorder(null);
			jPanelActionYellow.setBorder(m_SelectedBorder);
		}
		//Remote
		intRow = jTable_Remote_SPITObjects.getSelectedRow();
		if (intRow < 0) {
			o_SPIT_Object_Interface = null;
		}
		else {
			try {
				intRow =  jTable_Remote_SPITObjects.convertRowIndexToModel(intRow);
				o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object(intRow);
			}
			catch (Exception e) {
				o_SPIT_Object_Interface = null;
			}
		}
		if (o_SPIT_Object_Interface == null) {
			jButton_RemotePlay.setVisible(true);
			jButton_RemotePlay.setEnabled(false);
			
			jButton_RemoteValueMinus.setVisible(false);
			jButton_RemoteValuePlus.setVisible(false);
		}
		else {
			if (o_SPIT_Object_Interface.getValueUse() == SPIT_Object_Interface.VALUEUSE_DISCARD) {
				jButton_RemotePlay.setVisible(true);
				jButton_RemotePlay.setEnabled(true);
			
				jButton_RemoteValueMinus.setVisible(false);
				jButton_RemoteValuePlus.setVisible(false);
			}
			else {
				jButton_RemotePlay.setVisible(false);
				jButton_RemotePlay.setEnabled(false);
				jButton_RemoteValueMinus.setVisible(true);
				jButton_RemoteValuePlus.setVisible(true);
			}
		}	
	}
	/**
	 * Creates a simple test project.<br>
	 * 
	 */
	
    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        // TODO add your handling code here:
		SPIT_Client o_SPIT_Client;
		o_SPIT_Client = m_Spit_Client;
		SPIT_ActionPlayer.removeTimeCodeListener(this);
		if (o_SPIT_Client != null) {
			o_SPIT_Client.close();
		}
		m_ServerAutoDetect_Client.removeServerAutoDetectListener(this);		
		m_ServerAutoDetect_Client.stopDetection(this);
    }//GEN-LAST:event_formWindowClosing

    private void jButton_ConnectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ConnectActionPerformed
        // TODO add your handling code here:
		SPIT_Client o_Spit_Client;
		o_Spit_Client = m_Spit_Client;
		if (o_Spit_Client == null) return;
		ServerAutoDetect.DetectedServer o_DetectedServer;
		o_DetectedServer = (ServerAutoDetect.DetectedServer)jComboBox_DetectedServer.getSelectedItem();
		if (o_DetectedServer == null) return;
		
		connect(o_DetectedServer, 0, "", "");
		
    }//GEN-LAST:event_jButton_ConnectActionPerformed

    private void jButton_AddSPITTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_AddSPITTypeActionPerformed
        // TODO add your handling code here:
		SPIT_Client o_Spit_Client;
		SPIT_Type o_SPIT_Type;

		o_Spit_Client = m_Spit_Client;
		if (o_Spit_Client == null) return;
		o_SPIT_Type = new SPIT_Type();
		SPIT_Type.addSPIT_Type(o_SPIT_Type, o_Spit_Client);
    }//GEN-LAST:event_jButton_AddSPITTypeActionPerformed

    private void jButton_RemoveSPITTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_RemoveSPITTypeActionPerformed
        // TODO add your handling code here:
		int intRow;
		SPIT_Client o_Spit_Client;
		SPIT_Type_Interface o_SPIT_Type_Interface;

		o_Spit_Client = m_Spit_Client;
		if (o_Spit_Client == null) return;
		int[] o_SelectedRows;
		o_SelectedRows = jTable_SPITTypes.getSelectedRows();
		for (int intSelectedRow = o_SelectedRows.length-1; intSelectedRow >= 0; intSelectedRow--) {
			intRow = o_SelectedRows[intSelectedRow];
			try {
				intRow = jTable_SPITTypes.convertRowIndexToModel(intRow);
				o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(intRow);
			}
			catch (Exception e) {
				o_SPIT_Type_Interface = null;
			}
			if (o_SPIT_Type_Interface == null) return;
			if (o_SPIT_Type_Interface.getFixed()) return;
			SPIT_Type.removeSPIT_Type(o_SPIT_Type_Interface, o_Spit_Client);
		}
    }//GEN-LAST:event_jButton_RemoveSPITTypeActionPerformed

    private void jButton_RemotePlayActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_RemotePlayActionPerformed
        // TODO add your handling code here:
		SPIT_Object_Interface o_SPIT_Object_Interface;
		int intRow;
		
		intRow = jTable_Remote_SPITObjects.getSelectedRow();
		if (intRow < 0) return;
		try {
			intRow = jTable_Remote_SPITObjects.convertRowIndexToModel(intRow);
			o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object(intRow);
		}
		catch (Exception e) {
			o_SPIT_Object_Interface = null; 
		}
		if (o_SPIT_Object_Interface == null) return;
		
		SPITRemote.playClientRemoteSPIT_Object(m_Spit_Client, o_SPIT_Object_Interface);
    }//GEN-LAST:event_jButton_RemotePlayActionPerformed

    private void jButton_RemoteValuePlusActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_RemoteValuePlusActionPerformed
		SPIT_Object_Interface o_SPIT_Object_Interface;
		int intRow;
		
		intRow = jTable_Remote_SPITObjects.getSelectedRow();
		if (intRow < 0) return;
		try {
			intRow = jTable_Remote_SPITObjects.convertRowIndexToModel(intRow);
			o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object(intRow);
		}
		catch(Exception e) {
			o_SPIT_Object_Interface = null;
		}
		if (o_SPIT_Object_Interface == null) return;
		
		SPITRemote.playClientRemoteSPIT_Object(m_Spit_Client, o_SPIT_Object_Interface, (int)(0.05 * 1000000), true);
    }//GEN-LAST:event_jButton_RemoteValuePlusActionPerformed

    private void jButton_RemoteValueMinusActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_RemoteValueMinusActionPerformed
        // TODO add your handling code here:
		SPIT_Object_Interface o_SPIT_Object_Interface;
		int intRow;
		
		intRow = jTable_Remote_SPITObjects.getSelectedRow();
		if (intRow < 0) return;
		try {
			intRow = jTable_Remote_SPITObjects.convertRowIndexToModel(intRow);
			o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object(intRow);
		}
		catch (Exception e) {
			o_SPIT_Object_Interface = null;
		}
		if (o_SPIT_Object_Interface == null) return;
		
		SPITRemote.playClientRemoteSPIT_Object(m_Spit_Client, o_SPIT_Object_Interface, (int)(0.05 * 1000000), false);
    }//GEN-LAST:event_jButton_RemoteValueMinusActionPerformed

    private void jButton_AdviseActionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_AdviseActionActionPerformed
        // TODO add your handling code here:
		int intRow;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		if (jTable_SPITObjects.getSelectedRowCount() != 1) return;
		intRow = jTable_SPITObjects.getSelectedRow();
		if (intRow < 0) return;
		try {
			intRow = jTable_SPITObjects.convertRowIndexToModel(intRow);
			o_SPIT_Object_Interface = SPIT_Object.getSPIT_Object(intRow);
		}
		catch (Exception e) {
			o_SPIT_Object_Interface = null;
		}
		if (o_SPIT_Object_Interface == null) return;
		o_SPIT_Object_Interface.setSPIT_Action_Interface(m_SelectedSPIT_Action_Interface, null);
    }//GEN-LAST:event_jButton_AdviseActionActionPerformed

    private void jButton_DisconnectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_DisconnectActionPerformed
        // TODO add your handling code here:
		disconnect();
    }//GEN-LAST:event_jButton_DisconnectActionPerformed

    private void jButton_RemoveSPITObjectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_RemoveSPITObjectActionPerformed
        // TODO add your handling code here:
		int intRow;
		SPIT_Client o_Spit_Client;
		SPIT_Object_Interface o_SPIT_Object_Interface;

		o_Spit_Client = m_Spit_Client;
		if (o_Spit_Client == null) return;
		int[] o_SelectedRows;
		o_SelectedRows = jTable_SPITObjects.getSelectedRows();
		for (int intSelectedRow = o_SelectedRows.length-1; intSelectedRow >= 0; intSelectedRow--) {
			intRow = o_SelectedRows[intSelectedRow];
			try {
				intRow = jTable_SPITObjects.convertRowIndexToModel(intRow);
				o_SPIT_Object_Interface = SPIT_Object.getSPIT_Object(intRow);
			}
			catch (Exception e) {
				o_SPIT_Object_Interface = null;
			}
			if (o_SPIT_Object_Interface == null) return;
			if (o_SPIT_Object_Interface.getFixed()) return;
			SPIT_Object.removeSPIT_Object(o_SPIT_Object_Interface, o_Spit_Client);
		}
		
    }//GEN-LAST:event_jButton_RemoveSPITObjectActionPerformed

	

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton_AddSPITType;
    private javax.swing.JButton jButton_AdviseAction;
    private javax.swing.JButton jButton_Connect;
    private javax.swing.JButton jButton_Disconnect;
    private javax.swing.JButton jButton_RemotePlay;
    private javax.swing.JButton jButton_RemoteValueMinus;
    private javax.swing.JButton jButton_RemoteValuePlus;
    private javax.swing.JButton jButton_RemoveSPITObject;
    private javax.swing.JButton jButton_RemoveSPITType;
    private javax.swing.JComboBox<String> jComboBox_DetectedServer;
    private javax.swing.JLabel jLabel_Actions;
    private javax.swing.JLabel jLabel_PlayerNameHeader;
    private javax.swing.JLabel jLabel_SPIT_ObjectHeader;
    private javax.swing.JLabel jLabel_SPIT_ObjectHeader1;
    private javax.swing.JLabel jLabel_SPIT_TypeHeader;
    private javax.swing.JLabel jLabel_ServerComputerName;
    private javax.swing.JLabel jLabel_ServerHeader;
    private javax.swing.JLabel jLabel_ServerName;
    private javax.swing.JLabel jLabel_ServerProjectName;
    private javax.swing.JLabel jLabel_TimeCode;
    private javax.swing.JPanel jPanel1;
    private SPITClientGUI.jPanelActionColorRed jPanelActionRed;
    private SPITClientGUI.jPanelActionColorYellow jPanelActionYellow;
    private javax.swing.JPanel jPanel_Frame;
    private javax.swing.JPanel jPanel_Project;
    private javax.swing.JPanel jPanel_SPITActions;
    private javax.swing.JPanel jPanel_Server;
    private javax.swing.JPanel jPanel_ServerRemote;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane_Objects;
    private javax.swing.JScrollPane jScrollPane_Types;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTable jTable_Remote_SPITObjects;
    private javax.swing.JTable jTable_SPITObjects;
    private javax.swing.JTable jTable_SPITTypes;
    // End of variables declaration//GEN-END:variables

	//-------------------------------
	//----- SPIT_ClientListener -----
	//-------------------------------
	
	@Override
	public void eventServer_SPITProject(SPIT_ClientInterface p_SPIT_Client) {
		if (p_SPIT_Client == null) return;
		m_SPITServer_ProjectName = p_SPIT_Client.getServerProjectName();
		refreshGUI();
	}
	@Override
	public void eventServer_SPITProject_Closed(SPIT_ClientInterface p_SPIT_Client) {
		if (p_SPIT_Client == null) return;
		m_SPITServer_ProjectName = "";
		refreshGUI();
	}
	@Override
	public void eventServer_SPITProject_TransferStart(SPIT_ClientInterface p_SPIT_Client) {
		if (p_SPIT_Client == null) return;
	}
	@Override
	public void eventServer_SPITProject_TransferEnd(SPIT_ClientInterface p_SPIT_Client) {
		if (p_SPIT_Client == null) return;
	}
	
	@Override
	public void eventConnected(SPIT_ClientInterface p_SPIT_Client) {
		m_ConnectionLost = false;
		refreshGUI();
		m_ServerAutoDetect_Client.stopDetection(this);
	}
	@Override
	public void eventDisconnected(SPIT_ClientInterface p_SPIT_Client, boolean p_ConnectionLost) {
		m_ConnectionLost = p_ConnectionLost;
		refreshGUI();
		m_ServerAutoDetect_Client.startDetection(this);
	}

	//------------------------------------------------
	// ----- SPITActionPlayer - TimeCodeListener -----
	//------------------------------------------------

	@Override
	public void eventTimeCode(long p_PlayFrame, long FramesOerSecond) {
		//will be set when a PlaySequence has been parsed and the player is a main player
		//see SPIT_ActionPlayer - endPlayTransfer()
		jLabel_TimeCode.setText(String.valueOf(p_PlayFrame));
	}

	//------------------------------
	//----- SPIT_Type_Listener -----
	//------------------------------

	@Override
	public void eventSPIT_Type_Added(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITTypeListener SPIT_Type added " + p_SPIT_Type_Interface.getName());
	}

	@Override
	public void eventSPIT_Type_Changed(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITTypeListener SPIT_Type changed " + p_SPIT_Type_Interface.getName());
	}

	@Override
	public void eventSPIT_Type_Removed(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITTypeListener SPIT_Type removed " + p_SPIT_Type_Interface.getName());
	}

	//----- Remote SPIT_Types -----
	@Override
	public void eventRemoteSPIT_Type_Added(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITTypeListener RemoteSPIT_Type added " + p_SPIT_Type_Interface.getName());
	}

	@Override
	public void eventRemoteSPIT_Type_Changed(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITTypeListener RemoteSPIT_Type changed " + p_SPIT_Type_Interface.getName());
	}

	@Override
	public void eventRemoteSPIT_Type_Removed(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITTypeListener RemoteSPIT_Type removed " + p_SPIT_Type_Interface.getName());
	}
	
	//--------------------------------
	//----- SPIT_Object_Listener -----
	//--------------------------------

	@Override
	public void eventSPIT_Object_Added(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITObjectListener SPIT_Object added " + p_SPIT_Object_Interface.getName());
	}

	@Override
	public void eventSPIT_Object_Changed(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITObjectListener SPIT_Object changed " + p_SPIT_Object_Interface.getName());
	}

	@Override
	public void eventSPIT_Object_Removed(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITObjectListener SPIT_Object removed " + p_SPIT_Object_Interface.getName());
	}
	
	//----- Remote SPITObjects -----
	@Override
	public void eventRemoteSPIT_Object_Added(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITObjectListener RemoteSPIT_Object added " + p_SPIT_Object_Interface.getName());
	}

	@Override
	public void eventRemoteSPIT_Object_Changed(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITObjectListener RemoteSPIT_Object changed " + p_SPIT_Object_Interface.getName());
	}

	@Override
	public void eventRemoteSPIT_Object_Removed(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		//TODO make your own listing?
//		System.out.println("SPITObjectListener RemoteSPIT_Object removed " + p_SPIT_Object_Interface.getName());
	}

	//-------------------------------------------------------------
	//----- AutoDetectServer                                 ------
	//----- called from thread, which is not the EventThread ------
	//-------------------------------------------------------------
	@Override
	public void eventDetectedServer_Added(ServerAutoDetect.DetectedServer p_DetectedServer) {
		if (m_ServerAutoDetect_Client.getDetectedServerCount() == 1) {
			//this function is called by ServerAutodetect thread -> use EventQueue thread to set the selected item
			ServerAutoDetect.DetectedServer o_DetectedServer;
			o_DetectedServer = m_ServerAutoDetect_Client.getDetectedServer(0);
			EventQueueHandler.invokeLater(new Runnable() {
				@Override
				public void run() {
					jComboBox_DetectedServer.setSelectedItem(o_DetectedServer);
					revalidate();
					repaint();
				}
			});
		}
		else {
			EventQueueHandler.invokeLater(new Runnable() {
				@Override
				public void run() {
					jComboBox_DetectedServer.setSelectedItem(null);
					revalidate();
					repaint();
				}
			});
		}
	}

	@Override
	public void eventDetectedServer_Changed(ServerAutoDetect.DetectedServer p_DetectedServer) {
	}

	@Override
	public void eventDetectedServer_Removed(ServerAutoDetect.DetectedServer p_DetectedServer) {
		if (m_ServerAutoDetect_Client.getDetectedServerCount() == 1) {
			//the first element is null
			ServerAutoDetect.DetectedServer o_DetectedServer;
			o_DetectedServer = m_ServerAutoDetect_Client.getDetectedServer(0);
			EventQueueHandler.invokeLater(new Runnable() {
				@Override
				public void run() {
					jComboBox_DetectedServer.setSelectedItem(o_DetectedServer);
					revalidate();
					repaint();
				}
			});
		}
		else {
			if (m_ServerAutoDetect_Client.getDetectedServerCount() <= 0) {
				EventQueueHandler.invokeLater(new Runnable() {
					@Override
					public void run() {
						jComboBox_DetectedServer.setSelectedItem(null);
						revalidate();
						repaint();
					}
				});
			}
		}
	}
	
}
