/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SwingModelPackage;

/**
 *
 * @author Hagi
 */
public class SPIT_TimeTools {
	public static final int		UNIT_TIME = 0;
	public static final int		UNIT_FRAMES = 1;
	/**
	 * Returns a string representing the time (duration) of p_Frames.
	 * @param p_Frames
	 * @return string contaiming the time
	 */
	public static String getTimeStringFromFrames(long p_Frames, double p_FramesPerSecond) {
		if (p_FramesPerSecond <= 0) return getTimeStringFromMillis(0);
		return getTimeStringFromMillis((long)(1000d * p_Frames / p_FramesPerSecond) );
	}
	/**
	 * Returns a string representing the time (duration) of milliseconds.
	 * @param p_Milliseconds 
	 * @return 
	 */
	public static String getTimeStringFromMillis(long p_Milliseconds) {
		int intHours;
		int intMinutes;
		int intSeconds;
		int intMilliseconds;

		String stringTime = "";
		String stringTemp;

		boolean boolSetString = false;
		intHours = (int)(p_Milliseconds / 3600000);
		p_Milliseconds -= intHours * 3600000;
		if (boolSetString == true || intHours > 0) {
			stringTemp = "00";
			stringTemp += String.valueOf(intHours);
			stringTime += stringTemp.substring(stringTemp.length()-2, stringTemp.length()) + ":";
			boolSetString = true;
		}
		intMinutes = (int)(p_Milliseconds / 60000);
		p_Milliseconds -= intMinutes * 60000;
		if (boolSetString == true || intMinutes > 0) {
			stringTemp = "00";
			stringTemp += String.valueOf(intMinutes);
			stringTime += stringTemp.substring(stringTemp.length()-2, stringTemp.length()) + ":";
			boolSetString = true;
		}
		intSeconds = (int)(p_Milliseconds / 1000);
		p_Milliseconds -= intSeconds * 1000;
		if (boolSetString == true || intSeconds > 0) {
			stringTemp = "00";
			stringTemp += String.valueOf(intSeconds);
			stringTime += stringTemp.substring(stringTemp.length()-2, stringTemp.length()) + ":";
			boolSetString = true;
		}
		intMilliseconds = (int)p_Milliseconds;
		stringTemp = "000";
		stringTemp += String.valueOf(intMilliseconds);
		stringTime += stringTemp.substring(stringTemp.length()-3, stringTemp.length());

		return stringTime;

	}
	public static long getFramesFromTimeString(String p_TimeString, double p_FramesPerSecond) {
		if (p_TimeString == null || p_TimeString.length() <= 0) return 0;
		if (p_FramesPerSecond <= 0) return 0;
		try {
		
			long longFrames = 0;
			String[] arrayTimeString;
			long longMilliseconds = 0;
			int intSeconds = 0;
			int intMinutes = 0;
			int intHours = 0;

			arrayTimeString = p_TimeString.split(":");
			if (arrayTimeString.length >= 1) {
				longMilliseconds = Integer.valueOf(arrayTimeString[arrayTimeString.length -1].trim());
			}
			if (arrayTimeString.length >= 2) {
				intSeconds = Integer.valueOf(arrayTimeString[arrayTimeString.length -2].trim());
				longMilliseconds += (intSeconds * 1000);
			}
			if (arrayTimeString.length >= 3) {
				intMinutes = Integer.valueOf(arrayTimeString[arrayTimeString.length -3].trim());
				longMilliseconds += (intMinutes * 60000);
			}
			if (arrayTimeString.length >= 4) {
				intHours = Integer.valueOf(arrayTimeString[arrayTimeString.length -4].trim());
				longMilliseconds += (intHours * 3600000);
			}

			longFrames = (long)((longMilliseconds / 1000d) * p_FramesPerSecond);
			return longFrames;
		}
		catch (Exception e) {
			return 0;
		}
	}
	public static long getMillisecondsFromString(String p_TimeString) {
		if (p_TimeString == null || p_TimeString.length() <= 0) return 0;

		String[] arrayTimeString;
		String stringSub;
		long longMilliseconds = 0;
		int intSeconds = 0;
		int intMinutes = 0;
		int intHours = 0;
		try {
			arrayTimeString = p_TimeString.split(":");
			
			
			arrayTimeString = p_TimeString.split(":");
			if (arrayTimeString.length >= 1) {
				longMilliseconds = Integer.valueOf(arrayTimeString[arrayTimeString.length -1].trim());
			}
			if (arrayTimeString.length >= 2) {
				intSeconds = Integer.valueOf(arrayTimeString[arrayTimeString.length -2].trim());
				longMilliseconds += (intSeconds * 1000);
			}
			if (arrayTimeString.length >= 3) {
				intMinutes = Integer.valueOf(arrayTimeString[arrayTimeString.length -3].trim());
				longMilliseconds += (intMinutes * 60000);
			}
			if (arrayTimeString.length >= 4) {
				intHours = Integer.valueOf(arrayTimeString[arrayTimeString.length -4].trim());
				longMilliseconds += (intHours * 3600000);
			}
		}
		catch (Exception e) {
			return 0;
		}
		return longMilliseconds;
	}
	
}
