/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SwingModelPackage;

import SPITLibraryPackage.SPIT_ClientInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

/**
 *
 * @author Hagi
 */
public class SPITClientTableModel extends AbstractTableModel implements PropertyChangeListener {
		public static final int		COLUMNCOUNT = 3;

		public static final int		COLUMNINDEX_CLIENTCMPUTERNAME = 0;
		public static final int		COLUMNINDEX_CLIENTNAME = 1;
		public static final int		COLUMNINDEX_CLIENTPROJECTNAME = 2;

		public static String	COLUMN_CLIENTCOMPUTERNAME = "Computer";
		public static String	COLUMN_CLIENTNAME = "Client";
		public static String	COLUMN_CLIENTPROJECTNAME = "Project";
		public static boolean	s_LanguageLoaded = false;

		private ArrayList<SPIT_ClientInterface>	m_SPIT_Clients;

		private TableRowSorter			m_TableRowSorter;

		private final Object			m_SyncObject = new Object();
		
		public SPITClientTableModel() {
			super();
			initMembers();
/*			if (s_LanguageLoaded == false) {
				LiveLanguage.loadLanguageStrings(this);
				s_LanguageLoaded = true;
			}
			LiveLanguage.addLanguageListener(this);
*/
		}

		private void initMembers() {
			m_SPIT_Clients = new ArrayList<>();

			m_TableRowSorter = new TableRowSorter(this);
			
		}

		public void finishJTable(JTable p_JTable) {
			if (p_JTable == null) return;
			p_JTable.setRowSorter(m_TableRowSorter);
			fireTableStructureChanged();

			m_TableRowSorter.setComparator(COLUMNINDEX_CLIENTNAME, new StringComparator_Normal());
		}

		public void clear() {
			int intLastRow;
			synchronized(m_SyncObject) {
				intLastRow = m_SPIT_Clients.size()-1;
				m_SPIT_Clients.clear();
			}
			if (intLastRow >= 0) {
				fireTableRowsDeleted(0, intLastRow);
			}
		}
/*		@Override
		public String languageGetFileNameBasis() {
			return "Languages/LiveShow";		
		}

		@Override
		public ArrayList<LiveLanguageObject> languageGetAdditionalObjects() {
			return null;
		}

		@Override
		public void languageAdditionalObjectLoaded(LiveLanguageObject p_LanguageObject) {
		}

		@Override
		public void languageApplyComponentOrientation(ComponentOrientation p_Orientation) {
		}
*/		
		
		
		public static class StringComparator_Normal implements Comparator<String> {
			@Override
			public int compare(String o1, String o2) {
				if (o1 == null || o2 == null) return 0;
				return (o1.compareToIgnoreCase(o2));
			}
		}

		public static class StringComparator_NumericInteger implements Comparator<String> {
			@Override
			public int compare(String o1, String o2) {
				if (o1 == null || o2 == null) return 0;
				Integer int1;
				Integer int2;
				try {
					int1 = Integer.valueOf(o1);
					int2 = Integer.valueOf(o2);
				}
				catch(Exception e) {
					return 0;
				}
				return int1.compareTo(int2);
			}
		}


		public boolean contains(SPIT_ClientInterface p_SPIT_ClientInterface) {
			if (p_SPIT_ClientInterface == null) return false;
			return m_SPIT_Clients.contains(p_SPIT_ClientInterface);
		}
		public boolean contains(String p_ID) {
			if (p_ID == null) return false;
			SPIT_ClientInterface o_SPIT_ClientInterface;
			o_SPIT_ClientInterface = getSPIT_ClientInterface(p_ID);
			if (o_SPIT_ClientInterface == null) return false;
			else return true;
		}
		
		public SPIT_ClientInterface getSPIT_ClientInterface(String p_ID) {
			SPIT_ClientInterface o_SPIT_ClientInterface;
			synchronized(m_SyncObject) {
				for (int intClient = 0; intClient < m_SPIT_Clients.size(); intClient++) {
					o_SPIT_ClientInterface = m_SPIT_Clients.get(intClient);
					if (o_SPIT_ClientInterface == null) continue;
					if (p_ID.equals(o_SPIT_ClientInterface.getID())) {
						return o_SPIT_ClientInterface;
					}
				}
			}
			return null;
		}
		
		public boolean addSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
			if (p_SPIT_ClientInterface == null) return false;
			int intRow;
			synchronized(m_SyncObject) {
				intRow = m_SPIT_Clients.indexOf(p_SPIT_ClientInterface);
				if (intRow >= 0) {
					fireTableRowsUpdated(intRow, intRow);
					return false;
				}
				m_SPIT_Clients.add(p_SPIT_ClientInterface);
				intRow = m_SPIT_Clients.size()-1;
				p_SPIT_ClientInterface.addPropertyChangeListener(this);
			}
			fireTableRowsInserted(intRow, intRow);
			return true;
		}

		public boolean removeSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
			if (p_SPIT_ClientInterface == null) return false;
			int intRow;
			synchronized(m_SyncObject) {
				intRow = m_SPIT_Clients.indexOf(p_SPIT_ClientInterface);
				if (intRow < 0) return false;
				m_SPIT_Clients.remove(intRow);
				p_SPIT_ClientInterface.removePropertyChangeListener(this);
			}
			fireTableRowsDeleted(intRow, intRow);
			return true;
		}

		public int getRowOfSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
			return m_SPIT_Clients.indexOf(p_SPIT_ClientInterface);
		}

		public void addSelectedSPIT_ClientInterface(JTable p_JTable, SPIT_ClientInterface p_SPIT_ClientInterface) {
			if (p_JTable == null) return;
			if (p_SPIT_ClientInterface == null) return;
			int intRow;
			synchronized(m_SyncObject) {
				intRow = m_SPIT_Clients.indexOf(p_SPIT_ClientInterface);
				if (intRow < 0) return;
				intRow = p_JTable.convertRowIndexToView(intRow);
			}
			p_JTable.setRowSelectionInterval(intRow, intRow);
//			p_JTable.getSelectionModel().addSelectionInterval(intRow, intRow);
//			p_JTable.revalidate();
		}
		public void removeSelectedSPIT_ClientInterface(JTable p_JTable, SPIT_ClientInterface p_SPIT_ClientInterface) {
			if (p_JTable == null) return;
			if (p_SPIT_ClientInterface == null) return;
			int intRow;
			synchronized(m_SyncObject) {
				intRow = m_SPIT_Clients.indexOf(p_SPIT_ClientInterface);
				if (intRow < 0) return;
				intRow = p_JTable.convertRowIndexToView(intRow);
			}
			p_JTable.removeRowSelectionInterval(intRow, intRow); //getSelectionModel().removeSelectionInterval(intRow, intRow);
		}

		public SPIT_ClientInterface getSPIT_ClientInterface(int p_Index) {
			if (p_Index < 0) return null;
			synchronized(m_SyncObject) {
				if (p_Index >= m_SPIT_Clients.size()) return null;
				return m_SPIT_Clients.get(p_Index);
			}
		}

		public ArrayList<SPIT_ClientInterface> getArrayList() {
			return m_SPIT_Clients;
		}
		@Override
		public int getRowCount() {
			return m_SPIT_Clients.size();
		}

		@Override
		public int getColumnCount() {
			return COLUMNCOUNT;
		}

		@Override
		public String getColumnName(int col) {
			switch(col) {
				case COLUMNINDEX_CLIENTNAME:
					return COLUMN_CLIENTNAME;
				case COLUMNINDEX_CLIENTCMPUTERNAME:
					return COLUMN_CLIENTCOMPUTERNAME;
				case COLUMNINDEX_CLIENTPROJECTNAME:
					return COLUMN_CLIENTPROJECTNAME;
			}
			return "";
		}

		@Override
		public Object getValueAt(int rowIndex, int columnIndex) {
			String stringValue = "";
			SPIT_ClientInterface o_SPIT_ClientInterface;
			synchronized(m_SyncObject) {
				o_SPIT_ClientInterface = getSPIT_ClientInterface(rowIndex);
				if (o_SPIT_ClientInterface == null) return stringValue;
				switch(columnIndex) {
					case COLUMNINDEX_CLIENTNAME:
						stringValue = o_SPIT_ClientInterface.getName();
						break;
					case COLUMNINDEX_CLIENTCMPUTERNAME:
						stringValue = o_SPIT_ClientInterface.getClientComputerName();
						break;
					case COLUMNINDEX_CLIENTPROJECTNAME:
						stringValue = o_SPIT_ClientInterface.getClientProjectName();
				}
				return stringValue;
			}
		}

		@Override
		public boolean isCellEditable(int row, int col) {
/*			switch(col) {
				case COLUMNINDEX_CLIENTNAME:
					return true;
			}
*/
			return false;
		}

	 /*
		 * Don't need to implement this method unless your table's
		 * data can change.
		 */
		@Override
		public void setValueAt(Object value, int row, int col) {
			SPIT_ClientInterface o_SPIT_ClientInterface;
			String stringValue;
			if (!(value instanceof String)) {
				return;
			}
			synchronized(m_SyncObject) {
				if (row < 0 || row >= m_SPIT_Clients.size()) return;
				o_SPIT_ClientInterface = m_SPIT_Clients.get(row);
				if (o_SPIT_ClientInterface == null) return;
			}
/*			switch (col) {
				case COLUMNINDEX_CLIENTNAME:
					stringValue = (String)value;
					o_SPIT_ClientInterface.changeName(stringValue);
					break;
			}
*/
			fireTableCellUpdated(row, col);
		}


		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			if (evt.getSource() instanceof SPIT_ClientInterface) {
				int intRow;
				synchronized(m_SyncObject) {
					intRow = m_SPIT_Clients.indexOf(evt.getSource());
					if (intRow < 0) return;
				}
				fireTableRowsUpdated(intRow, intRow);
			}
		}

	

	

	public static class SPIT_ClientInterfaceTableCellRenderer extends JLabel implements TableCellRenderer, Serializable {

	   /**
		* An empty <code>Border</code>. This field might not be used. To change the
		* <code>Border</code> used by this renderer override the
		* <code>getTableCellRendererComponent</code> method and set the border
		* of the returned component directly.
		*/
		private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
		protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;

		// We need a place to store the color the JLabel should be returned
		// to after its foreground and background colors have been set
		// to the selection background color.
		// These ivars will be made protected when their names are finalized.
		private Color m_UnselectedForeground;
		private Color m_UnselectedBackground;
		public static Color	s_NotConfirmedColor = new Color(255, 200, 200);
		public static Color	s_FIXEDColor = new Color(0, 100, 0);

		/**
		 * Creates a default table cell renderer.
		 */
		public SPIT_ClientInterfaceTableCellRenderer(int p_FontSize) {
			super();
			super.setFont(new Font(getFont().getFamily(), Font.PLAIN, p_FontSize));
			setOpaque(true);
			setBorder(getNoFocusBorder());
			setName("Table.cellRenderer");
		}

		private Border getNoFocusBorder() {
			return m_NoFocusBorder;
		}

		/**
		 * Overrides <code>JComponent.setForeground</code> to assign
		 * the unselected-foreground color to the specified color.
		 *
		 * @param c set the foreground color to this value
		 */
		@Override
		public void setForeground(Color c) {
			super.setForeground(c);
			m_UnselectedForeground = c;
		}

		/**
		 * Overrides <code>JComponent.setBackground</code> to assign
		 * the unselected-background color to the specified color.
		 *
		 * @param c set the background color to this value
		 */
		@Override
		public void setBackground(Color c) {
			super.setBackground(c);
			m_UnselectedBackground = c;
		}

		/**
		 * Notification from the <code>UIManager</code> that the look and feel
		 * [L&F] has changed.
		 * Replaces the current UI object with the latest version from the
		 * <code>UIManager</code>.
		 *
		 * @see JComponent#updateUI
		 */
		@Override
		public void updateUI() {
			super.updateUI();
			setForeground(null);
			setBackground(null);
		}

		// implements javax.swing.table.TableCellRenderer
		/**
		 *
		 * Returns the default table cell renderer.
		 * <p>
		 * During a printing operation, this method will be called with
		 * <code>isSelected</code> and <code>hasFocus</code> values of
		 * <code>false</code> to prevent selection and focus from appearing
		 * in the printed output. To do other customization based on whether
		 * or not the table is being printed, check the return value from
		 * {@link javax.swing.JComponent#isPaintingForPrint()}.
		 *
		 * @param table  the <code>JTable</code>
		 * @param value  the value to assign to the cell at
		 *			<code>[row, column]</code>
		 * @param isSelected true if cell is selected
		 * @param hasFocus true if cell has focus
		 * @param row  the row of the cell to render
		 * @param column the column of the cell to render
		 * @return the default table cell renderer
		 * @see javax.swing.JComponent#isPaintingForPrint()
		 */
		@Override
		public Component getTableCellRendererComponent(JTable table, Object value,
							  boolean isSelected, boolean hasFocus, int row, int column) {

			Color colorBackground;
			Color colorForeground;
			
			SPITClientTableModel o_SPITClientTableModel;
			SPIT_ClientInterface o_SPIT_ClientInterface;
			int intRowModel;
			colorBackground = table.getBackground();
			colorForeground = table.getForeground();
			if (table.getModel() instanceof SPITClientTableModel) {
				o_SPITClientTableModel = (SPITClientTableModel)table.getModel();
				try {
					intRowModel = table.convertRowIndexToModel(row);				
					o_SPIT_ClientInterface = o_SPITClientTableModel.getSPIT_ClientInterface(intRowModel);
				}
				catch(Exception e) {
					
				}
			}
			
			
			JTable.DropLocation dropLocation = table.getDropLocation();
			if (dropLocation != null
					&& !dropLocation.isInsertRow()
					&& !dropLocation.isInsertColumn()
					&& dropLocation.getRow() == row
					&& dropLocation.getColumn() == column) {


				isSelected = true;
			}
			try {
				if (table.convertColumnIndexToModel(column) == 0) {
					setIcon(null);
				}
				else {
					setIcon(null);
				}
			}
			catch (Exception e) {
				setIcon(null);
			}
			
			if (isSelected) {
				super.setForeground(table.getSelectionForeground());
				super.setBackground(table.getSelectionBackground());
			} 
			else {
				super.setForeground(colorForeground);
				super.setBackground(colorBackground);
			}

			setFont(super.getFont());

			if (hasFocus) {
				setBorder(m_NoFocusBorder);

				if (!isSelected && table.isCellEditable(row, column)) {
						Color col;
						col = table.getForeground();
						super.setForeground(col);
						col = table.getBackground();
						super.setBackground(col);
				}
			} 
			else {
				setBorder(getNoFocusBorder());
			}

			setText((value == null) ? "" : value.toString());

			return this;
		}

		/*
		 * The following methods are overridden as a performance measure to
		 * to prune code-paths are often called in the case of renders
		 * but which we know are unnecessary.  Great care should be taken
		 * when writing your own renderer to weigh the benefits and
		 * drawbacks of overriding methods like these.
		 */

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public boolean isOpaque() {
		Color back = getBackground();
		Component p = getParent();
		if (p != null) {
			p = p.getParent();
		}

		// p should now be the JTable.
		boolean colorMatch = (back != null) && (p != null) &&
			back.equals(p.getBackground()) &&
				p.isOpaque();
		return !colorMatch && super.isOpaque();
		}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 *
		 * @since 1.5
		 */
		@Override
		public void invalidate() {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void validate() {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void revalidate() {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void repaint(long tm, int x, int y, int width, int height) {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void repaint(Rectangle r) { }

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 *
		 * @since 1.5
		 */
		@Override
		public void repaint() {
		}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		// Strings get interned...
		if ("text".equals(propertyName)
				|| "labelFor".equals(propertyName)
				|| "displayedMnemonic".equals(propertyName)
				|| (("font".equals(propertyName) || "foreground".equals(propertyName))
					&& oldValue != newValue
					&& getClientProperty(javax.swing.plaf.basic.BasicHTML.propertyKey) != null)) {

				super.firePropertyChange(propertyName, oldValue, newValue);
			}
		}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) { }




		/**
		 * A subclass of <code>DefaultTableCellRenderer</code> that
		 * implements <code>UIResource</code>.
		 * <code>DefaultTableCellRenderer</code> doesn't implement
		 * <code>UIResource</code>
		 * directly so that applications can safely override the
		 * <code>cellRenderer</code> property with
		 * <code>DefaultTableCellRenderer</code> subclasses.
		 * <p>
		 * <strong>Warning:</strong>
		 * Serialized objects of this class will not be compatible with
		 * future Swing releases. The current serialization support is
		 * appropriate for short term storage or RMI between applications running
		 * the same version of Swing.  As of 1.4, support for long term storage
		 * of all JavaBeans<sup><font size="-2">TM</font></sup>
		 * has been added to the <code>java.beans</code> package.
		 * Please see {@link java.beans.XMLEncoder}.
		 */
		public static class UIResource extends DefaultTableCellRenderer
			implements javax.swing.plaf.UIResource {
		}

	}
}

