/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package SwingModelPackage;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

/**
 *
 * @author Hagi
 */

public class ListTools {
/*	public static interface LiveDB_ListElement<T> {
		public void addListener(ListObjectListener<T> p_Listener);
		public void removeListener(ListObjectListener<T> p_Listener);
	}
	
	public static interface ListObjectListener<T> {
		public void changed(T p_Element);
	}
*/
	/**
	 * LiveDB_ListModel extends the DefaultComboBoxModel. <br>
	 * If a component sets a selection, the model handles the selection,
	 * therefore all components will get the same selection.<br>
	 * To allow components as JComoboBox to make their own selection, 
	 * a wrapper class (LiveDB_ListModelWrapper) is used.
	 * @param <T> the type of the list elements
	 * @see LiveDB_ListModelWrapper
	 */
	public static class ListModel<T> implements ComboBoxModel, PropertyChangeListener {
	
		protected ArrayList<T>					m_Elements;
		protected ArrayList<T>					m_ElementsFilterNegative; //contains all outfiltered elements
		protected ArrayList<T>					m_ElementsFilterTemp; //used to temporarly save elements
		protected final Object					m_SyncElements = new Object();
		protected T								m_SelectedElement;
		protected ArrayList<ListModelWrapper<T>>	m_ListModelWrappers;
		protected final Object					m_SyncWrappers = new Object();
		protected ArrayList<ListDataListener>		m_ListDataListeners;
		protected final Object					m_SyncListeners = new Object();
		
		
		
		public ListModel() {
			super();
			initMembers();
		}

		public ListModel(T p_FirstElement) {
			super();
			initMembers();
			addElement(p_FirstElement);
		}
		private void initMembers() {
			m_Elements = new ArrayList<T>();
			m_ElementsFilterNegative = new ArrayList<T>();
			m_ElementsFilterTemp = new ArrayList<T>();
			m_ListModelWrappers = new ArrayList<ListModelWrapper<T>>();
			m_SelectedElement = null;
			m_ListDataListeners = new ArrayList<ListDataListener>();
		}
		
		public void close() {
			ListDataListener o_ListDataListener;
			synchronized(m_SyncListeners) {
			for (int intListener = m_ListDataListeners.size()-1; intListener >= 0; intListener--) {
				o_ListDataListener = m_ListDataListeners.get(intListener);
				m_ListDataListeners.remove(intListener);
			}
			}
			ListModelWrapper o_ListModelWrapper;
			synchronized(m_SyncWrappers) {
			for (int intWrapper = m_ListModelWrappers.size()-1; intWrapper >= 0; intWrapper--) {
				o_ListModelWrapper = m_ListModelWrappers.get(intWrapper);
				removeListModelWrapper(o_ListModelWrapper);
			}
			}
			removeElementsAll();
		}
		/**
		 * Adds a LiveDB_ListModelWrapper-instance all events will fired to this instance too.<br>
		 * @param p_ListModelWrapper 
		 */
		public void addListModelWrapper(ListModelWrapper<T> p_ListModelWrapper) {
			if (p_ListModelWrapper == null) return;
			synchronized(m_SyncWrappers) {
				if (m_ListModelWrappers.contains(p_ListModelWrapper)) return;
				m_ListModelWrappers.add(p_ListModelWrapper);
			}
		}
		/**
		 * Removes a LiveDB_ListModelWrapper-instance the events will no longer fired to this instance.<br>
		 * @param p_ListModelWrapper
		 */
		public void removeListModelWrapper(ListModelWrapper p_ListModelWrapper) {
			if (p_ListModelWrapper == null) return;
			synchronized(m_SyncWrappers) {
				m_ListModelWrappers.remove(p_ListModelWrapper);
			}
		}

		
		public int size() {
			return getSize();
		}
		@Override
		public int getSize() {
			return m_Elements.size();
		}
		
		public boolean contains(T p_Element) {
			return containsElement(p_Element);
		}
		public boolean containsElement(T p_Element) {
			return m_Elements.contains(p_Element);
		}
		
		public String getListSortPreFix(T p_Element) {
			if (p_Element == null) return null;
				Method o_MethodSortPreFix;
				Class<?> o_Class;
				o_Class = p_Element.getClass();
				try {
					o_MethodSortPreFix = o_Class.getMethod("getListSortPreFix");
					if (o_MethodSortPreFix == null) return null;
					return (String)o_MethodSortPreFix.invoke(p_Element);
				}
				catch (Exception e) {
					return null;
				}
			
		}
		
		public boolean addSortedByName(T p_Element, boolean p_ExludeFirst, boolean p_UseClassName, boolean p_UseListSortPreFix) {

			if (contains(p_Element)) return true;
			int intStartIndex;

			if (p_ExludeFirst) intStartIndex = 1;
			else intStartIndex = 0;
			
			
			if (m_Elements.size() < intStartIndex+1) {
				return addElement(p_Element);
			}
			
			String stringNameNew;
			String stringTemp;

			stringTemp = null;
			if (p_UseListSortPreFix) {
				stringTemp = getListSortPreFix(p_Element);
			}
			if (stringTemp != null) {
				stringNameNew = stringTemp;
			}
			else {
				stringNameNew = "";
			}
			
			if (p_UseClassName && p_Element != null) {
				stringNameNew += p_Element.getClass().getSimpleName();
			}
			stringTemp = getName(p_Element);
			if (stringTemp != null) {
				stringNameNew += stringTemp;
			}
	
			int intElement;
			T o_Element;
			String stringName;
			synchronized(m_SyncElements) {
			for (intElement = intStartIndex; intElement < m_Elements.size(); intElement++) {
				o_Element = m_Elements.get(intElement);
				stringTemp = null;
				if (p_UseListSortPreFix) {
					stringTemp = getListSortPreFix(o_Element);
				}
				if (stringTemp != null) {
					stringName = stringTemp;
				}
				else {
					stringName = "";
				}
				if (p_UseClassName && o_Element != null) {
					stringName += o_Element.getClass().getSimpleName();
				}
				stringTemp = getName(o_Element);
				if (stringTemp != null) {
					stringName += stringTemp;
				}
				if (stringName.compareToIgnoreCase(stringNameNew) <= 0) continue;
				break;
			}
			}
			return add(intElement, p_Element);
		}
		
		public void resortByName(T p_Element, boolean p_ExludeFirst, boolean p_UseClassName, boolean p_UseListSortPreFix) {
			if (p_Element == null) return;
			String stringTemp;
			String stringNameNew;
			int intOldIndex;
			
			stringTemp = null;
			if (p_UseListSortPreFix) {
				stringTemp = getListSortPreFix(p_Element);
			}
			if (stringTemp != null) {
				stringNameNew = stringTemp;
			}
			else {
				stringNameNew = "";
			}
			if (p_UseClassName && p_Element != null) {
				stringNameNew += p_Element.getClass().getSimpleName();
			}
			stringTemp = getName(p_Element);
			if (stringTemp != null) {
				stringNameNew += stringTemp;
			}
			
			
			intOldIndex = m_Elements.indexOf(p_Element);
			if (intOldIndex < 0) return;
			
			int intStartIndex;
			int intElement;
			T o_Element;
			String stringName;
			if (p_ExludeFirst) intStartIndex = 1;
			else intStartIndex = 0;
			
			synchronized(m_SyncElements) {
			if (m_Elements.size() < intStartIndex+1) {
				return;
			}
			for (intElement = intStartIndex; intElement < m_Elements.size(); intElement++) {
				if (intElement == intOldIndex) continue;
				o_Element = m_Elements.get(intElement);
				stringTemp = null;
				if (p_UseListSortPreFix) {
					stringTemp = getListSortPreFix(o_Element);
				}
				if (stringTemp != null) {
					stringName = stringTemp;
				}
				else {
					stringName = "";
				}
				if (p_UseClassName && o_Element != null) {
					stringName += o_Element.getClass().getSimpleName();
				}		
				stringTemp = getName(o_Element);
				if (stringTemp != null) {
					stringName += stringTemp;
				}
				
				if (stringName.compareToIgnoreCase(stringNameNew) <= 0) continue;
				break;
			}
			}
			if (intElement == intOldIndex+1) return;
			if (intElement < intOldIndex) {
				removeElement(p_Element);
				add(intElement, p_Element);		
			}
			if (intElement > intOldIndex) {
				removeElement(p_Element);
				add(intElement-1, p_Element);
			}
		}
		private String getName(T p_Element) {
			if (p_Element == null) return null;
				Method o_MethodGetName;
				Class<?> o_Class;
				o_Class = p_Element.getClass();
				try {
					o_MethodGetName = o_Class.getMethod("getName");
					if (o_MethodGetName == null) return null;
					return (String)o_MethodGetName.invoke(p_Element);
				}
				catch (Exception e) {
					return null;
				}
		}
		
		/**
		 * Returns the element which name contains the p_SearchString.
		 * @param p_SearchString the string which is searched inside the elements names
		 * @return the first element which name contains the search string
		 */
		public T findByName(String p_SearchString) {
			if (p_SearchString == null) return null;
			if (p_SearchString.length() <= 0) return null;
			T o_Element;
			String stringName;
			synchronized(m_SyncElements) {
			for (int intElement = 0; intElement < m_Elements.size(); intElement++) {
				o_Element = m_Elements.get(intElement);
				stringName = getName(o_Element);
				if (stringName == null) continue;
				if (stringName.length() < p_SearchString.length()) continue;
				if (stringName.toLowerCase().contains(p_SearchString.toLowerCase())) return o_Element;
//				if (stringName.toLowerCase().startsWith(p_SearchString.toLowerCase())) return o_Element;
			}
			}
			return null;
		}
		
		public void filterByName(String p_FilterString, boolean p_ExludeFirst, boolean p_UseClassName, boolean p_UseListSortPreFix) {
			T o_Element;
			String stringFilter;
			String stringName;
			int intStartIndex;
			if (p_FilterString == null || p_FilterString.length() <= 0) {
				//Add all outfiltered elements back
				for (int intElement = m_ElementsFilterNegative.size()-1; intElement >= 0 ; intElement--) {
					o_Element = m_ElementsFilterNegative.get(intElement);
					addSortedByName(o_Element, p_ExludeFirst, p_UseClassName, p_UseListSortPreFix);
					m_ElementsFilterNegative.remove(intElement);
				}
				return;
			}
			
			stringFilter = p_FilterString.toLowerCase();
			if (p_ExludeFirst == false) intStartIndex = 0;
			else intStartIndex = 1;
			synchronized(m_SyncElements) {
				for (int intElement = m_Elements.size()-1; intElement >= intStartIndex ; intElement--) {
					o_Element = m_Elements.get(intElement);
					stringName = getName(o_Element).toLowerCase();
					if (stringName.contains(stringFilter) == false) {
						remove(o_Element);
						m_ElementsFilterTemp.add(o_Element);
					}
				}
				for (int intElement = m_ElementsFilterNegative.size()-1; intElement >= 0 ; intElement--) {
					o_Element = m_ElementsFilterNegative.get(intElement);
					stringName = getName(o_Element).toLowerCase();
					if (stringName.contains(stringFilter)) {
						addSortedByName(o_Element, p_ExludeFirst, p_UseClassName, p_UseListSortPreFix);
						m_ElementsFilterNegative.remove(intElement);
					}
				}
				m_ElementsFilterNegative.addAll(m_ElementsFilterTemp);
			}
		}
		
		public boolean add(T p_Element) {
			return addElement(p_Element);
		}
		public boolean addElement(Object p_Element) {
			if (p_Element == null) {
//				return;
			}
			T o_Element;
			boolean boolAdded = false;
			try {
				if (p_Element != null) {
					o_Element = (T)p_Element;
				}
				else {
					o_Element = null;
				} 
			}
			catch (Exception e) {
				return false;
			}
			if (containsElement(o_Element)) return true;
			if (o_Element != null) {
				call_AddPropertyChangeListener(o_Element);
			}
			
			synchronized(m_SyncElements) {
				boolAdded = m_Elements.add(o_Element);
			}
			
			if (boolAdded) {
				int intIndex = m_Elements.indexOf(p_Element);
				try {
					fireIntervalAdded(this, intIndex, intIndex);
				}
				catch (Exception e) {
				}
				return true;
			}
			return false;
		}
		
		public boolean add(int p_Index, T p_Element) {
			return insertElementAt(p_Element, p_Index);
		}
		public boolean insertElementAt(T anObject,int index) {
			if (contains(anObject)) return true;

			boolean boolAdded = false;
			synchronized(m_SyncElements) {
			try {
				m_Elements.add(index, anObject);
				boolAdded = true;
			}
			catch (Exception e) {
				boolAdded = false;
			}
			}
			if (boolAdded) {
				fireIntervalAdded(this, index, index);
			}
			return boolAdded;
		}
		
		public boolean remove(T p_Element) {
			return removeElement(p_Element);
		}
		public boolean removeElement(Object p_Element) {
			if (p_Element == null) {
//				return;
			}
			T o_Element;
			boolean boolRemoved;
			try {
				if (p_Element != null) {
					o_Element = (T)p_Element;
				}
				else {
					o_Element = null;
				}
			}
			catch (Exception e) {
				return false;
			}
			int intIndex;
			synchronized(m_SyncElements) {
				intIndex = m_Elements.indexOf(o_Element);
				if (intIndex < 0) return false;
				if (o_Element != null) {
					call_RemovePropertyChangeListener(o_Element);
				}
				boolRemoved = m_Elements.remove(o_Element);			
			}
			if (boolRemoved) {
				fireIntervalRemoved(this, intIndex, intIndex);
			}
			
			return boolRemoved;
		}
		
		public void remove(int p_Index) {
			removeElementAt(p_Index);
		}
		public void removeElementAt(int index) {
			Object o_Object = null;
			synchronized(m_SyncElements) {
				if (index < 0 || index >= m_Elements.size()) return;
				try {
					o_Object = m_Elements.remove(index);
				}
				catch (Exception e) {
					o_Object = null;
				}
			}
			if (o_Object != null) {
				fireIntervalRemoved(this, index, index);
			}
			
		}
		
		public void removeElementsAll() {
			int intSize;
			
			intSize = getSize();
			for (int intElement = intSize-1; intElement >= 0; intElement--) {
				removeElementAt(intElement);
			}
		}
		
		public void clear() {
			removeElementsAll();
		}
		
		
		@Override
		public T getElementAt(int p_Index) {
			return get(p_Index);
		}

		public T get(int p_Index) {
			synchronized(m_SyncElements) {
				if (p_Index < 0 || p_Index >= m_Elements.size()) return null;
				return m_Elements.get(p_Index);
			}
		}
		
		public ArrayList<T> getArrayList() {
			return m_Elements;
		}
		
		public int indexOf(T p_Element) {
			return m_Elements.indexOf(p_Element);
		}
		
		protected void call_AddPropertyChangeListener(Object p_Element) {
			if (p_Element == null) return;
			Method o_Method = null;
			try {
				o_Method = p_Element.getClass().getDeclaredMethod("addPropertyChangeListener", PropertyChangeListener.class);
				if (o_Method != null) {
					o_Method.invoke(p_Element, this);
				}
			}
			catch (Exception e) {
				o_Method = null;
			}		
		} 
		protected void call_RemovePropertyChangeListener(Object p_Element) {
			if (p_Element == null) return;
			Method o_Method = null;
			try {
				o_Method = p_Element.getClass().getDeclaredMethod("removePropertyChangeListener", PropertyChangeListener.class);
				if (o_Method != null) {
					o_Method.invoke(p_Element, this);
				}
			}
			catch (Exception e) {
				o_Method = null;
			}		
		}
		
    /**
     * Returns an array containing all of the elements in this listmodel
     * in proper sequence (from first to last element).
     *
     * <p>The returned array will be "safe" in that no references to it are
     * maintained by this list.  (In other words, this method must allocate
     * a new array).  The caller is thus free to modify the returned array.
     *
     * @return an array containing all of the elements in this listmodel in
     *         proper sequence
     */
		public T[] toArray() {
			T[] o_Array;
			T o_Element;
			o_Array = (T[])(new Object[getSize()]);
			for (int intElement = 0; intElement < getSize(); intElement++) {
				o_Element = (T)getElementAt(intElement);
				o_Array[intElement] = o_Element;
			}
			return o_Array;
		}
		/**
		 * Retuns an ArrayList of all elements in the list.<br>
		 * @return ArrayList of all Elements
		 */
		public ArrayList<T> toArrayList() {
			return (ArrayList<T>)m_Elements.clone();
		}
		
		@Override
		public T getSelectedItem() {
			return m_SelectedElement;
		}

	    protected void fireContentsChanged(Object source, int index0, int index1) {
			ArrayList<ListDataListener> o_ListDataListeners;
			ListDataListener o_Listener;
			ListDataEvent o_ListDataEvent;
			o_ListDataEvent = new ListDataEvent(this, ListDataEvent.CONTENTS_CHANGED, index0, index1);
			
			synchronized(m_SyncListeners) {
				o_ListDataListeners = new ArrayList<>(m_ListDataListeners.size());
				o_ListDataListeners.addAll(m_ListDataListeners);
			}
			for (int intListener = 0; intListener < o_ListDataListeners.size(); intListener++) {
				o_Listener = o_ListDataListeners.get(intListener);
				o_Listener.contentsChanged(o_ListDataEvent);
			}
			
			ArrayList<ListModelWrapper> o_ListModelWrappers;
			synchronized(m_SyncWrappers) {
				o_ListModelWrappers = new ArrayList<>(m_ListModelWrappers.size());
				o_ListModelWrappers.addAll(m_ListModelWrappers);
			}
			for (int intSingleModel = 0; intSingleModel < o_ListModelWrappers.size(); intSingleModel++) {
				o_ListModelWrappers.get(intSingleModel).fireContentsChanged(source, index0, index1);
			}
		}
		protected void fireIntervalAdded(Object source, int index0, int index1) {
			ArrayList<ListDataListener> o_ListDataListeners;
			ListDataListener o_Listener;
			ListDataEvent o_ListDataEvent;
			o_ListDataEvent = new ListDataEvent(this, ListDataEvent.INTERVAL_ADDED, index0, index1);
			
			synchronized(m_SyncListeners) {
				o_ListDataListeners = new ArrayList<>(m_ListDataListeners.size());
				o_ListDataListeners.addAll(m_ListDataListeners);
			}
			
			for (int intListener = 0; intListener < o_ListDataListeners.size(); intListener++) {
				o_Listener = o_ListDataListeners.get(intListener);
				o_Listener.intervalAdded(o_ListDataEvent);
			}
			ArrayList<ListModelWrapper> o_ListModelWrappers;
			synchronized(m_SyncWrappers) {
				o_ListModelWrappers = new ArrayList<>(m_ListModelWrappers.size());
				o_ListModelWrappers.addAll(m_ListModelWrappers);
			}
			for (int intSingleModel = 0; intSingleModel < o_ListModelWrappers.size(); intSingleModel++) {
				o_ListModelWrappers.get(intSingleModel).fireIntervalAdded(source, index0, index1);
			}
		}

		protected void fireIntervalRemoved(Object source, int index0, int index1) {
			ArrayList<ListDataListener> o_ListDataListeners;
			ListDataListener o_Listener;
			ListDataEvent o_ListDataEvent;
			o_ListDataEvent = new ListDataEvent(this, ListDataEvent.INTERVAL_REMOVED, index0, index1);
			synchronized(m_SyncListeners) {
				o_ListDataListeners = new ArrayList<>(m_ListDataListeners.size());
				o_ListDataListeners.addAll(m_ListDataListeners);
			}
			for (int intListener = 0; intListener < o_ListDataListeners.size(); intListener++) {
				o_Listener = o_ListDataListeners.get(intListener);
				o_Listener.intervalRemoved(o_ListDataEvent);
			}
			ArrayList<ListModelWrapper> o_ListModelWrappers;
			synchronized(m_SyncWrappers) {
				o_ListModelWrappers = new ArrayList<>(m_ListModelWrappers.size());
				o_ListModelWrappers.addAll(m_ListModelWrappers);
			}
			for (int intSingleModel = 0; intSingleModel < o_ListModelWrappers.size(); intSingleModel++) {
				o_ListModelWrappers.get(intSingleModel).fireIntervalRemoved(source, index0, index1);
			}
		}

		public void changed(T p_Element) {
			int intIndex;
			intIndex = indexOf(p_Element);
			if (intIndex < 0) return;
			fireContentsChanged(this, intIndex, intIndex);
		}
		
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			changed((T)evt.getSource());
		}

		@Override
		public void setSelectedItem(Object anItem) {
			m_SelectedElement = (T)anItem;
		}


		@Override
		public void addListDataListener(ListDataListener l) {
			if (l == null) return;
			synchronized(m_SyncListeners) {
				if (m_ListDataListeners.contains(l)) return;
				m_ListDataListeners.add(l);
			}
		}

		@Override
		public void removeListDataListener(ListDataListener l) {
			synchronized(m_SyncListeners) {
				m_ListDataListeners.remove(l);
			}
		}

	}

	/**
	 * this is a wrapper-class for the TriggerListModel which uses the single-instance of the TriggerListModel,
	 * But handles the selection seperatly.<br>
	 * For excample if two JComboBoxes wants use the same ListModel and wants to allow a seperate selection of an element,
	 * they have to create a own instance of LiveDB_ListModelWrapper.<br>
	 * If both uses only the single instance of TriggerListModel the change of the selection of one of them
	 * will change the selection of the other one.<br>
	 * This happens because the selection is handled by the DefaultComboBoxModel.<br>
	 * @see LiveDB_ListModel
	 */
	public static class ListModelWrapper<T>  implements MutableComboBoxModel {
		private ListModel<T>	m_ListModel;
		private T						m_SelectedElement;
		protected EventListenerList		m_ListenerList;
		
		private final Object			m_SyncEventListeners = new Object();

		public ListModelWrapper(ListModel<T> p_ListModel) {
			initMembers();
			m_ListModel = p_ListModel;
			m_ListModel.addListModelWrapper(this);
			if (m_ListModel.getSize() == 1) {
				setSelectedItem(m_ListModel.getElementAt(0));
			}
		}
		private void initMembers() {
			m_SelectedElement = null;
			m_ListenerList = new EventListenerList();
		}
		public void close() {
			if (m_ListModel != null) m_ListModel.removeListModelWrapper(this);
		}
		
		public ListModel<T> getListModel() {
			return m_ListModel;
		}
		
		public boolean containsElement(T p_Element) {
			return m_ListModel.containsElement(p_Element);
		}
		@Override
		public void addElement(Object p_Element) {
			m_ListModel.addElement(p_Element);
		}
		@Override
		public void removeElement(Object p_Element) {
			m_ListModel.removeElement(p_Element);
		}

		public void clear() {
			removeElementsAll();
		}
		public void removeElementsAll() {
			m_ListModel.removeElementsAll();
		}
		@Override
		public int getSize() {
			return m_ListModel.getSize();
		}

		@Override
		public Object getElementAt(int index) {
			return m_ListModel.getElementAt(index);
		}
		

		public int getIndexOf(T anObject) {
			return m_ListModel.indexOf(anObject);
		}

		@Override
		public T getSelectedItem() {
			return m_SelectedElement;
		}
		@Override
		public void setSelectedItem(Object p_Element) {
			try {
				m_SelectedElement = (T)p_Element;
			}
			catch (Exception e) {
				
			}
		}

		@Override
		public void addListDataListener(ListDataListener l) {
			synchronized(m_SyncEventListeners) {
				m_ListenerList.add(ListDataListener.class, l);
			}
		}

		@Override
		public void removeListDataListener(ListDataListener l) {
			synchronized(m_SyncEventListeners) {
				m_ListenerList.remove(ListDataListener.class, l);
			}
		}

		public ListDataListener[] getListDataListeners() {
			synchronized(m_SyncEventListeners) {
			return (ListDataListener[])m_ListenerList.getListeners(
					ListDataListener.class);
			}
		}

		protected void fireContentsChanged(Object source, int index0, int index1) {
			Object[] listeners;
			Object[] listenersCopy;
			ListDataEvent e = null;
			synchronized(m_SyncEventListeners) {
				listeners = m_ListenerList.getListenerList();
				listenersCopy = new Object[listeners.length];
				System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
			}
			for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
				if (listenersCopy[i] == ListDataListener.class) {
				if (e == null) {
					e = new ListDataEvent(source, ListDataEvent.CONTENTS_CHANGED, index0, index1);
				}
				((ListDataListener)listenersCopy[i+1]).contentsChanged(e);
				}
			}
		}

		protected void fireIntervalAdded(Object source, int index0, int index1) {
			Object[] listeners;
			Object[] listenersCopy;
			ListDataEvent e = null;
			synchronized(m_SyncEventListeners) {
				listeners = m_ListenerList.getListenerList();
				listenersCopy = new Object[listeners.length];
				System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
			}
			if (m_ListModel.getSize() == 1) setSelectedItem(m_ListModel.getElementAt(0));
			
			for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
				if (listenersCopy[i] == ListDataListener.class) {
				if (e == null) {
					e = new ListDataEvent(source, ListDataEvent.INTERVAL_ADDED, index0, index1);
				}
				((ListDataListener)listenersCopy[i+1]).intervalAdded(e);
				}
			}
		}

		protected void fireIntervalRemoved(Object source, int index0, int index1) {
			Object[] listeners;
			Object[] listenersCopy;
			ListDataEvent e = null;
			synchronized(m_SyncEventListeners) {
				listeners = m_ListenerList.getListenerList();
				listenersCopy = new Object[listeners.length];
				System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
			}
			

			T o_Element;
			boolean boolSelectedFound = false;
			int intElement;
			for (intElement = 0; intElement <= m_ListModel.getSize(); intElement++) {
				o_Element = (T)m_ListModel.getElementAt(intElement);
				if (o_Element == m_SelectedElement) {
					boolSelectedFound = true;
					break;
				}
			}
			if (boolSelectedFound == false) {
				if (m_ListModel.getSize() <= 0) setSelectedItem(null);
				else setSelectedItem(m_ListModel.getElementAt(0));
			}

			for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
				if (listenersCopy[i] == ListDataListener.class) {
				if (e == null) {
					e = new ListDataEvent(source, ListDataEvent.INTERVAL_REMOVED, index0, index1);
				}
				((ListDataListener)listenersCopy[i+1]).intervalRemoved(e);
				}
			}
		}
		public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
			synchronized (m_SyncEventListeners) {
				return m_ListenerList.getListeners(listenerType);
			}
		}

	   // implements javax.swing.MutableComboBoxModel
		@Override
		public void insertElementAt(Object anObject,int index) {
			m_ListModel.insertElementAt((T)anObject,index);
			fireIntervalAdded(this, index, index);
		}

		// implements javax.swing.MutableComboBoxModel
		@Override
		public void removeElementAt(int index) {
			if ( getElementAt( index ) == m_SelectedElement ) {
				if ( index == 0 ) {
					setSelectedItem( getSize() == 1 ? null : getElementAt( index + 1 ) );
				}
				else {
					setSelectedItem( getElementAt( index - 1 ) );
				}
			}

			m_ListModel.removeElementAt(index);

			fireIntervalRemoved(this, index, index);
		}


	}
	
	public static class ListRenderer extends DefaultListCellRenderer {
		private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
		protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;

		public ListRenderer() {
			super();
			setHorizontalAlignment(JLabel.CENTER);
		}
		
		
		private Border getNoFocusBorder() {
			return m_NoFocusBorder;
		}
		private String getName(Object p_Element) {
			if (p_Element == null) return null;
				Method o_MethodGetName;
				Class<?> o_Class;
				o_Class = p_Element.getClass();
				try {
					o_MethodGetName = o_Class.getMethod("getName");
					if (o_MethodGetName == null) return null;
					return (String)o_MethodGetName.invoke(p_Element);
				}
				catch (Exception e) {
					return null;
				}
		}
		
		@Override
		public Component getListCellRendererComponent(JList<?> list, Object value, int index, 
				boolean isSelected, boolean cellHasFocus) {
			
			setComponentOrientation(list.getComponentOrientation());
			
			Color bg = null;
			Color fg = null;

			JList.DropLocation dropLocation = list.getDropLocation();
			if (dropLocation != null
					&& !dropLocation.isInsert()
					&& dropLocation.getIndex() == index) {


				isSelected = true;
			}

			if (isSelected) {
				setBackground(bg == null ? list.getSelectionBackground() : bg);
				setForeground(fg == null ? list.getSelectionForeground() : fg);
			}
			else {
				setBackground(list.getBackground());
				setForeground(list.getForeground());
			}

			String stringName;
			stringName = getName(value);
			if (value instanceof Icon) {
				setIcon((Icon)value);
				setText("");
			}
			else if (stringName != null) {
				setText(stringName);
			}
			else {
				setIcon(null);
				setText((value == null) ? "" : value.toString());
			}

			setEnabled(list.isEnabled());
			setFont(list.getFont());

			Border border = null;
			if (cellHasFocus) {
				if (isSelected) {
					border = getNoFocusBorder();
				}
				if (border == null) {
					border = getNoFocusBorder();
				}
			} else {
				border = getNoFocusBorder();
			}
			setBorder(border);

			return this;
		}
		
	}

}

	

