/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITLibraryPackage;


/**
 *
 * @author Hagi
 */
public class SPIT_Watchdog {
	public static int				WATCHDOG_TIME = 3000; //milliseconds
	private SPIT_ClientInterface	m_SPITClient;
	private boolean					m_StopWatchdog;
	private boolean					m_WatchdogConfirmed;
	private Thread					m_ThreadWatchdog;
	private Runnable				m_RunnableWatchdog;
	private final Object			m_SyncWatchdog = new Object();
	
	public SPIT_Watchdog(SPIT_ClientInterface p_SPIT_ClientInterface) {
		initMembers();
		m_SPITClient = p_SPIT_ClientInterface;
		initRunnable();
	}
	private void initMembers() {
		
	}
	
	public void close() {
		stopWatchdog();
	}
	
	private void initRunnable() {
		m_RunnableWatchdog = new Runnable() {
			@Override
			public void run() {
				SPIT_ClientInterface o_SPIT_Client;
				SPIT_Message o_SPIT_Message;
				o_SPIT_Message = SPIT_Message.createWatchdog();
				while (m_StopWatchdog == false) {
					synchronized(m_SyncWatchdog) {
						o_SPIT_Client = m_SPITClient;
						if (o_SPIT_Client == null) break;
					}
					m_WatchdogConfirmed = false;
					o_SPIT_Client.sendSPIT_Message(o_SPIT_Message);
					//Wait WATCHDOG_TIME (milliseconds) before sending new watchdog
					//or check m_WatchdogConfirmed
					synchronized(m_SyncWatchdog) {
						try {
							m_SyncWatchdog.wait(WATCHDOG_TIME);
						}
						catch (Exception e) {
							
						}						
					}
					if (m_StopWatchdog == true) {
						break;
					}
					if (m_WatchdogConfirmed == false) {
						o_SPIT_Client.watchdogMissed();
						break;
					}
				}
			}
		};
	}
	public void startWatchdog() {
		Thread o_Thread;
		o_Thread = m_ThreadWatchdog;
		if (o_Thread != null) {
			stopWatchdog();
			//wait for stop
			try {
				o_Thread.join(1000);
			}
			catch (Exception e) {
				
			}
		}
		m_StopWatchdog = false;
		m_ThreadWatchdog = new Thread(m_RunnableWatchdog);
		m_ThreadWatchdog.start();

	}
	
	public void stopWatchdog() {

		m_StopWatchdog = true;
		synchronized(m_SyncWatchdog) {
			m_SyncWatchdog.notifyAll();
		}

	}
	
	public void eventWatchdogAnswer() {
		synchronized(m_SyncWatchdog) {
			m_WatchdogConfirmed = true;
		}
	}
	
}
