/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITLibraryPackage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

/**
 *
 * @author Hagi
 */
public class SPIT_ObjectDescription implements Externalizable {
	public static int SOFTWAREVERSION = 1;
	
		public static int	s_InstanceCount = 1;	// used to increase the default name for new cretaed SPIT_Types
		
		private String		m_ID;				//ID of this SPIT_Object instance
		private boolean		m_Fixed;			//true = the object is fixed, cannot be deleted/edit by other clients or controller 
		private boolean		m_ServerRemote;		//0x00 false the client is the owner of the object
												//0x01 true the server is the owner (Remote)
		private String		m_Name;				//name of the SPIT_Object
		private String		m_SPITTypeID;		//ID of the SPIT_Type
		private String		m_AdditionalParams;	//Special information use by the server
												//Should not changed by the client unless the client knows what it is doing
		private long		m_FrameStart;		//start time in frames
		private long		m_FrameLength;			//length in frames
		private long		m_FrameFadeInLength;	//fade in in frames
		private long		m_FrameFadeOutLength;	//fade out in frames
		private int			m_ValueFactor;			//Volume in ppm
		private byte		m_ValueUse;			//0x00 = the SPIT_Object discards the Value
												//0x01 = value 0 - 1000000 ppm
												//0x02 = value can be overridden (in PlaySPITObject the value is a valuechange in- or decrease the object's value 
		private int			m_Track;			//Layer level
		private String		m_Remark;			//free usable remark (less than 175 characters)
		private long		m_Delay;			//Delay in frames default first set  = SPIT_Type.delay
		private long		m_Duration;			//Duration in Frames default first set  = SPIT_Type.duration

		public SPIT_ObjectDescription() {
			initMembers();
		}
		public SPIT_ObjectDescription(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
			initMembers();
			if (p_ReportSPITObject == null) return;
			readReportSPITObject(p_ReportSPITObject);
		}
		
		private void initMembers() {
			m_ID = UUID.randomUUID().toString();
			m_Fixed = false;
			m_ServerRemote = false;
			m_Name = "TriggerObject " + s_InstanceCount;
			m_SPITTypeID = "";
			m_AdditionalParams = "";
			m_Remark = "";
			m_ValueFactor = 1000000; // = 100%
			m_ValueUse = 0x00;
			m_Delay = 0;
			m_Duration = 0;
		}
		
		public boolean setID(String p_ID) {
			if (m_ID.equals(p_ID)) return false;
			if (p_ID == null) m_ID = "";
			else m_ID = p_ID;
			return true;
		}
		public String getID() {
			return m_ID;
		}
		public boolean setFixed(boolean p_Fixed) {
			if (m_Fixed == p_Fixed) return false;
			m_Fixed = p_Fixed;
			return true;
		}
		public boolean getFixed() {
			return m_Fixed;
		}
		
		public boolean setServerRemote(boolean p_IsServerRemote) {
			if (m_ServerRemote == p_IsServerRemote) return false;
			m_ServerRemote = p_IsServerRemote;
			return true;
		}
		public boolean getServerRemote() {
			return m_ServerRemote;
		}
		
		public boolean setName(String p_Name) {
			if (m_Name.equals(p_Name)) return false;
			if (p_Name == null) m_Name = "";
			else m_Name = p_Name;
			return true;
		}
		public String getName() {
			return m_Name;
		}


		public boolean setSPITTypeID(String p_ID) {
			if (m_SPITTypeID.equals(p_ID)) return false;
			if (p_ID == null) m_SPITTypeID = "";
			else m_SPITTypeID = p_ID;
			return true;
		}
		public String getSPITTypeID() {
			return m_SPITTypeID;
		}
		public boolean setServerParams(String p_Parameters) {
			if (m_AdditionalParams.equals(p_Parameters)) return false;
			if (p_Parameters == null) m_AdditionalParams = "";
			else m_AdditionalParams = p_Parameters;
			return true;
		}
		public String getServerParams() {
			return m_AdditionalParams;
		}
		
		public boolean setFrameStart(long p_Time_frames) {
			if (m_FrameStart == p_Time_frames) return false;
			if (p_Time_frames < 0) m_FrameStart = 0;
			else m_FrameStart = p_Time_frames;
			return true;
		}
		public long getFrameStart() {
			return m_FrameStart;
		}
		
		public boolean setFrameLength(long p_Length_frames) {
			if (m_FrameLength == p_Length_frames) return false;
			if(p_Length_frames < 0) m_FrameLength = 0;
			else m_FrameLength = p_Length_frames;
			return true;
		}
		public long getFrameLength() {
			return m_FrameLength;
		}
		public boolean setFrameFadeInLength(long p_Time_Frames) {
			if (m_FrameFadeInLength == p_Time_Frames) return false;
			if(p_Time_Frames < 0) m_FrameFadeInLength = 0;
			else m_FrameFadeInLength = p_Time_Frames;
			return true;
		}
		public long getFrameFadeInLength() {
			return m_FrameFadeInLength;
		}
		public boolean setFrameFadeOutLength(long p_Time_Frames) {
			if (m_FrameFadeOutLength == p_Time_Frames) return false;
			if(p_Time_Frames < 0) m_FrameFadeOutLength = 0;
			else m_FrameFadeOutLength = p_Time_Frames;
			return true;
		}
		public long getFrameFadeOutLength() {
			return m_FrameFadeOutLength;
		}
		
		public boolean setValueFactor(int p_Volume_ppm) {
			if (m_ValueFactor == p_Volume_ppm) return false;
			if(p_Volume_ppm < 0) m_ValueFactor = 0;
			else m_ValueFactor = p_Volume_ppm;
			return true;
		}
		public int getValueFactor() {
			return m_ValueFactor;
		}
		public boolean setValueUse(byte p_ValueUse) {
			if (m_ValueUse == p_ValueUse) return false;
			m_ValueUse = p_ValueUse;
			return true;
		}
		public byte getValueUse() {
			return m_ValueUse;
		}
		public boolean setTrack(int p_Track) {
			if (m_Track == p_Track) return false;
			m_Track = p_Track;
			return true;
		}
		public int getTrack() {
			return m_Track;
		}
		
		public boolean setRemark(String p_Remark) {
			if (m_Remark.equals(p_Remark)) return false;
			if (p_Remark == null) m_Remark = "";
			else m_Remark = p_Remark;
			return true;
		}
		public String getRemark() {
			return m_Remark;
		}
		
		public boolean setDelay(long p_Delay) {
			if (p_Delay < 0) p_Delay = 0;
			if (m_Delay == p_Delay) return false;
			m_Delay = p_Delay;
			return true;
		}
		public long getDelay() {
			return m_Delay;
		}
		public boolean setDuration(long p_Duration) {
			if (p_Duration < 0) p_Duration = 0;
			if (m_Duration == p_Duration) return false;
			m_Duration = p_Duration;
			return true;
		}
		public long getDuration() {
			return m_Duration;
		}
		
		public boolean equals(SPIT_ObjectDescription p_Description) {
			if (p_Description == null) return false;
		
			if (m_ID.equals(p_Description.getID()) == false) return false;	
			if (m_ServerRemote != p_Description.getServerRemote()) return false;
			if (m_Name.equals(p_Description.getName()) == false) return false;
			if (m_SPITTypeID.equals(p_Description.getSPITTypeID()) == false) return false;
			if (m_AdditionalParams.equals(p_Description.getServerParams()) == false) return false;
			if (m_FrameStart != p_Description.getFrameStart()) return false;
			if (m_FrameLength != p_Description.getFrameLength()) return false;
			if (m_FrameFadeInLength != p_Description.getFrameFadeInLength()) return false;
			if (m_FrameFadeOutLength != p_Description.getFrameFadeOutLength()) return false;
			if (m_ValueFactor != p_Description.getValueFactor()) return false;
			if (m_ValueUse != p_Description.getValueUse()) return false;
			if (m_Track != p_Description.getTrack()) return false;
			if (m_Remark.equals(p_Description.getRemark()) == false) return false;
			if (m_Delay != p_Description.getDelay()) return false;
			if (m_Duration != p_Description.getDuration()) return false;
			return true;
		}
		
		public boolean checkEqualsReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
			if (p_ReportSPITObject == null) return false;
		
			if (m_ID.equals(p_ReportSPITObject.getID()) == false) return false;	
			if (m_ServerRemote != p_ReportSPITObject.getServerRemote()) return false;
			if (m_Name.equals(p_ReportSPITObject.getName()) == false) return false;
			if (m_SPITTypeID.equals(p_ReportSPITObject.getSPITTypeID()) == false) return false;
			if (m_AdditionalParams.equals(p_ReportSPITObject.getServerParams()) == false) return false;
			if (m_FrameStart != p_ReportSPITObject.getFrameStart()) return false;
			if (m_FrameLength != p_ReportSPITObject.getFrameLength()) return false;
			if (m_FrameFadeInLength != p_ReportSPITObject.getFrameFadeInLength()) return false;
			if (m_FrameFadeOutLength != p_ReportSPITObject.getFrameFadeOutLength()) return false;
			if (m_ValueFactor != p_ReportSPITObject.getValueFactor()) return false;
			if (m_ValueUse != p_ReportSPITObject.getValueUse()) return false;
			if (m_Track != p_ReportSPITObject.getTrack()) return false;
			if (m_Remark.equals(p_ReportSPITObject.getRemark()) == false) return false;
			if (m_Delay != p_ReportSPITObject.getDelay()) return false;
			if (m_Duration != p_ReportSPITObject.getDuration()) return false;
			return true;
		}
	public boolean copyFromDescription(SPIT_ObjectDescription p_SPIT_ObjectDescription) {
		if (p_SPIT_ObjectDescription == null) return false;
		boolean boolChanged = false;
		if (setID(p_SPIT_ObjectDescription.getID())) boolChanged = true;
		if (setServerRemote(p_SPIT_ObjectDescription.getServerRemote())) boolChanged = true;
		if (setName(p_SPIT_ObjectDescription.getName())) boolChanged = true;
		if (setSPITTypeID(p_SPIT_ObjectDescription.getSPITTypeID())) boolChanged = true;
		if (setFixed(p_SPIT_ObjectDescription.getFixed())) boolChanged = true;
		if (setServerParams(p_SPIT_ObjectDescription.getServerParams())) boolChanged = true;
		if (setFrameStart(p_SPIT_ObjectDescription.getFrameStart())) boolChanged = true;
		if (setFrameLength(p_SPIT_ObjectDescription.getFrameLength())) boolChanged = true;
		if (setFrameFadeInLength(p_SPIT_ObjectDescription.getFrameFadeInLength())) boolChanged = true;
		if (setFrameFadeOutLength(p_SPIT_ObjectDescription.getFrameFadeOutLength())) boolChanged = true;
		if (setValueFactor(p_SPIT_ObjectDescription.getValueFactor())) boolChanged = true;
		if (setValueUse(p_SPIT_ObjectDescription.getValueUse())) boolChanged = true;
		if (setTrack(p_SPIT_ObjectDescription.getTrack())) boolChanged = true;
		if (setRemark(p_SPIT_ObjectDescription.getRemark())) boolChanged = true;
		if (setDelay(p_SPIT_ObjectDescription.getDelay())) boolChanged = true;
		if (setDuration(p_SPIT_ObjectDescription.getDuration())) boolChanged = true;
		return boolChanged;
	}	
	public boolean readReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
		if (p_ReportSPITObject == null) return false;
		boolean boolChanged = false;
		if (setID(p_ReportSPITObject.getID())) boolChanged = true;
		if (setServerRemote(p_ReportSPITObject.getServerRemote())) boolChanged = true;
		if (setName(p_ReportSPITObject.getName())) boolChanged = true;
		if (setSPITTypeID(p_ReportSPITObject.getSPITTypeID())) boolChanged = true;
		if (setFixed(p_ReportSPITObject.getFixed())) boolChanged = true;
		if (setServerParams(p_ReportSPITObject.getServerParams())) boolChanged = true;
		if (setFrameStart(p_ReportSPITObject.getFrameStart())) boolChanged = true;
		if (setFrameLength(p_ReportSPITObject.getFrameLength())) boolChanged = true;
		if (setFrameFadeInLength(p_ReportSPITObject.getFrameFadeInLength())) boolChanged = true;
		if (setFrameFadeOutLength(p_ReportSPITObject.getFrameFadeOutLength())) boolChanged = true;
		if (setValueFactor(p_ReportSPITObject.getValueFactor())) boolChanged = true;
		if (setValueUse(p_ReportSPITObject.getValueUse())) boolChanged = true;
		if (setTrack(p_ReportSPITObject.getTrack())) boolChanged = true;
		if (setRemark(p_ReportSPITObject.getRemark())) boolChanged = true;
		if (setDelay(p_ReportSPITObject.getDelay())) boolChanged = true;
		if (setDuration(p_ReportSPITObject.getDuration())) boolChanged = true;
		return boolChanged;
	}
		
	@Override
	public void writeExternal(ObjectOutput out) throws IOException {
		out.writeInt(SOFTWAREVERSION);
		
		out.writeUTF(m_ID);
		out.writeBoolean(m_Fixed);
		out.writeBoolean(m_ServerRemote);
		out.writeUTF(m_Name);
		out.writeUTF(m_SPITTypeID);
		out.writeUTF(m_AdditionalParams);
		out.writeLong(m_FrameStart);
		out.writeLong(m_FrameLength);
		out.writeLong(m_FrameFadeInLength);
		out.writeLong(m_FrameFadeOutLength);
		out.writeInt(m_ValueFactor);
		out.writeByte(m_ValueUse);
		out.writeInt(m_Track);
		out.writeUTF(m_Remark);
		out.writeLong(m_Delay);
		out.writeLong(m_Duration);
	}

	@Override
	public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
		int intSoftwareVersion;
		intSoftwareVersion = in.readInt();
		
		m_ID = in.readUTF();
		m_Fixed = in.readBoolean();
		m_ServerRemote = in.readBoolean();
		m_Name = in.readUTF();
		m_SPITTypeID = in.readUTF();
		m_AdditionalParams = in.readUTF();
		m_FrameStart = in.readLong();
		m_FrameLength = in.readLong();
		m_FrameFadeInLength = in.readLong();
		m_FrameFadeOutLength = in.readLong();
		m_ValueFactor = in.readInt();
		m_ValueUse = in.readByte();
		m_Track = in.readInt();
		m_Remark = in.readUTF();
		m_Delay = in.readLong();
		m_Duration = in.readLong();
	}
		
}
