/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITLibraryPackage;

import java.util.ArrayList;

/**
 * Play messages (PlaySPITStart, PlaySPITObject, PlaySPITEnd) may be sended very often.<br>
 * To avoid memory allocation, the old (prior allocated and sended) messages are collected in a pool and will be reused.<br> 
 * @author Hagi
 */
public class SPIT_MessagePlayPool {
	public static final Object	s_SyncPool = new Object();
	public static int			s_PoolSize = 100;
	public static ArrayList<SPIT_Message> s_PlaySPITStartPool = new ArrayList<>(s_PoolSize);
	public static ArrayList<SPIT_Message> s_PlaySPITEndPool = new ArrayList<>(s_PoolSize);
	public static ArrayList<SPIT_Message> s_PlaySPITObjectPool = new ArrayList<>(s_PoolSize);
	public static ArrayList<SPIT_Message> s_ReportPlayStatusPool = new ArrayList<>(s_PoolSize);
	
	public static SPIT_Message getPlaySPITStart() {
		SPIT_Message o_SPIT_Message;
		synchronized(s_SyncPool) {
			if (s_PlaySPITStartPool.size() > 0) {
				int intIndex;
				intIndex = s_PlaySPITStartPool.size()-1;
				o_SPIT_Message = s_PlaySPITStartPool.get(intIndex);
//				o_PlaySPITStart.reactivate();
				s_PlaySPITStartPool.remove(intIndex);
			}
			else {
				SPIT_Message.PlaySPITStart o_PlaySPITStart;
				o_PlaySPITStart = new SPIT_Message.PlaySPITStart();
				o_SPIT_Message = new SPIT_Message(o_PlaySPITStart);
			}
		}
		return o_SPIT_Message;
	}
	public static SPIT_Message getPlaySPITEnd() {
		SPIT_Message o_SPIT_Message;
		synchronized(s_SyncPool) {
			if (s_PlaySPITEndPool.size() > 0) {
				int intIndex;
				intIndex = s_PlaySPITEndPool.size()-1;
				o_SPIT_Message = s_PlaySPITEndPool.get(intIndex);
//				o_PlaySPITStart.reactivate();
				s_PlaySPITEndPool.remove(intIndex);
			}
			else {
				SPIT_Message.PlaySPITEnd o_PlaySPITEnd;
				o_PlaySPITEnd = new SPIT_Message.PlaySPITEnd();
				o_SPIT_Message = new SPIT_Message(o_PlaySPITEnd);
			}
		}
		return o_SPIT_Message;
	}
	public static SPIT_Message getPlaySPITObject() {
		SPIT_Message o_SPIT_Message;
		synchronized(s_SyncPool) {
			if (s_PlaySPITObjectPool.size() > 0) {
				int intIndex;
				intIndex = s_PlaySPITObjectPool.size()-1;
				o_SPIT_Message = s_PlaySPITObjectPool.get(intIndex);
//				o_PlaySPITStart.reactivate();
				s_PlaySPITObjectPool.remove(intIndex);
			}
			else {
				SPIT_Message.PlaySPITObject o_PlaySPITObject;
				o_PlaySPITObject = new SPIT_Message.PlaySPITObject();
				o_SPIT_Message = new SPIT_Message(o_PlaySPITObject);
			}
		}
		return o_SPIT_Message;
	}
	public static SPIT_Message getReportPlayStatus() {
		SPIT_Message o_SPIT_Message;
		synchronized(s_SyncPool) {
			if (s_ReportPlayStatusPool.size() > 0) {
				int intIndex;
				intIndex = s_ReportPlayStatusPool.size()-1;
				o_SPIT_Message = s_ReportPlayStatusPool.get(intIndex);
//				o_PlaySPITStart.reactivate();
				s_ReportPlayStatusPool.remove(intIndex);
			}
			else {
				SPIT_Message.ReportPlayStatus o_ReportPlayStatus;
				o_ReportPlayStatus = new SPIT_Message.ReportPlayStatus();
				o_SPIT_Message = new SPIT_Message(o_ReportPlayStatus);
			}
		}
		return o_SPIT_Message;
	}
	
	public static boolean addEmpty(SPIT_Message p_SPIT_Message) {
		if (p_SPIT_Message == null) return false;
		if (p_SPIT_Message.getOPPart() instanceof SPIT_Message.PlaySPITStart) {
			synchronized(s_SyncPool) {
				if (s_PlaySPITStartPool.size() < s_PoolSize) {
					s_PlaySPITStartPool.add(p_SPIT_Message);
					return true;
				}
			}			
		}
		else if (p_SPIT_Message.getOPPart() instanceof SPIT_Message.PlaySPITEnd) {
			synchronized(s_SyncPool) {
				if (s_PlaySPITEndPool.size() < s_PoolSize) {
					s_PlaySPITEndPool.add(p_SPIT_Message);
					return true;
				}
			}			
		}
		else if (p_SPIT_Message.getOPPart() instanceof SPIT_Message.PlaySPITObject) {
			synchronized(s_SyncPool) {
				if (s_PlaySPITObjectPool.size() < s_PoolSize) {
					s_PlaySPITObjectPool.add(p_SPIT_Message);
					return true;
				}
			}			
		}
		else if (p_SPIT_Message.getOPPart() instanceof SPIT_Message.ReportPlayStatus) {
			synchronized(s_SyncPool) {
				if (s_ReportPlayStatusPool.size() < s_PoolSize) {
					s_ReportPlayStatusPool.add(p_SPIT_Message);
					return true;
				}
			}			
		}
		return false;
	}
	/**
	 * Clears the complete pools
	 */
	public static void poolClear() {
		synchronized(s_SyncPool) {
			s_PlaySPITStartPool.clear();
			s_PlaySPITEndPool.clear();
			s_PlaySPITObjectPool.clear();
		}
	}
	
}
