/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITLibraryPackage;

import SPITActionPackage.SPIT_ActionStatus;
import java.nio.charset.Charset;

/**
 *
 * @author Hagi
 */
public class SPIT_Message {

	public static final String	SPITID = "#spit#";
	public static final int		SPITVERSION = 1;
	public static final Charset	CHARSET = Charset.forName("ISO-8859-15");

	public static String		s_ParseError = "ParseError";
	
	private byte[]				m_MessageBytes;
	private Header				m_Header;
	private OPPart				m_OPPart;

	private void initMembers() {
		m_MessageBytes = null;
		m_Header = null;
		m_OPPart = null;
	}
	
	//Receive
	public SPIT_Message(byte[] p_MessageBytes) {
		initMembers();
		m_MessageBytes = p_MessageBytes;
		if (m_MessageBytes == null) return;
		if (parse() == null) {
			
		}
	}
	public OPPart parse() {
		if (m_MessageBytes == null) return null;
		m_OPPart = null;
		
		//parse Header
		m_Header = new Header();
		if (m_Header.parse(m_MessageBytes) == false) {
			m_Header = null;
			m_OPPart = null;
			return m_OPPart;
		}
		
		//parse OP
		switch (m_Header.getOPFlag()) {
			//Connection
			case Connect.OPFLAG:
				m_OPPart = new Connect(m_Header);
				break;
			case ConnectAnswer.OPFLAG:
				m_OPPart = new ConnectAnswer(m_Header);
				break;
			case Disconnect.OPFLAG:
				m_OPPart = new Disconnect(m_Header);
				break;
			case Watchdog.OPFLAG:
				m_OPPart = new Watchdog(m_Header);
				break;
			case WatchdogAnswer.OPFLAG:
				m_OPPart = new WatchdogAnswer(m_Header);
				break;
				
			//SPITProject
			case ReportSPITProject.OPFLAG:
				m_OPPart = new ReportSPITProject(m_Header);
				break;
			case CloseSPITProject.OPFLAG:
				m_OPPart = new CloseSPITProject(m_Header);
				break;
			case RequestProjectTransfer.OPFLAG:
				m_OPPart = new RequestProjectTransfer(m_Header);
				break;
			case StartProjectTransfer.OPFLAG:
				m_OPPart = new StartProjectTransfer(m_Header);
				break;
			case EndProjectTransfer.OPFLAG:
				m_OPPart = new EndProjectTransfer(m_Header);
				break;
				
			//SPITType
			case ReportSPITType.OPFLAG:
				m_OPPart = new ReportSPITType(m_Header);
				break;
			case RemoveSPITType.OPFLAG:
				m_OPPart = new RemoveSPITType(m_Header);
				break;
				
			//SPITObject
			case ReportSPITObject.OPFLAG:
				m_OPPart = new ReportSPITObject(m_Header);
				break;
			case RemoveSPITObject.OPFLAG:
				m_OPPart = new RemoveSPITObject(m_Header);
				break;
			//PlaySPITObjects
			case PlaySPITStart.OPFLAG:
				m_OPPart = new PlaySPITStart(m_Header);
				break;
			case PlaySPITObject.OPFLAG:
				m_OPPart = new PlaySPITObject(m_Header);
				break;
			case PlaySPITEnd.OPFLAG:
				m_OPPart = new PlaySPITEnd(m_Header);
				break;
			case ReportPlayStatus.OPFLAG:
				m_OPPart = new ReportPlayStatus(m_Header);
				break;
			default:
				break;
		}
		if (m_OPPart != null) {		
			if (m_OPPart.parse(m_MessageBytes) == false) {
				m_Header = null;
				m_OPPart = null;
			}		
		}
		return m_OPPart;
	}
	
	public Header getHeader() {
		return m_Header;
	}
	public OPPart getOPPart() {
		return m_OPPart;
	}	
	public int getOPFlag() {
		if (m_Header == null) return -1;
		return m_Header.getOPFlag();
	}
	
	//Send
	public SPIT_Message(OPPart p_OPPart) {
		initMembers();
		m_OPPart = p_OPPart;
		if (m_OPPart == null) return;
		m_Header = m_OPPart.getHeader();
		if (m_Header == null) {
			m_OPPart = null;
			return;
		}
	}
	private boolean fillBytes() {
		if (m_OPPart == null) return false;
		if (m_MessageBytes == null) m_MessageBytes = createByteArray(m_OPPart);
		return m_OPPart.fillBytes(m_MessageBytes);
	}
	
	
	public byte[] getMessageBytes() {
		if (m_OPPart == null) return null;
		if (fillBytes() == false) return null;
		return m_MessageBytes;
	}
	
	
	//----------- Header -----------
	public static class Header {
		public static final int	BYTESLENGTH = 99;
		private String	m_SPITID;
		private int		m_SPITVersion;
		private byte	m_MessageNumber;
		private int		m_BytesCount;
		private String	m_ServerID;
		private String	m_ClientID;
		private int		m_OPFlag;
		private int		m_ParseOffset = 0;

		//Receive
		public Header() {
			initMembers();
		}
		private void initMembers() {
			m_SPITID = SPITID;
			m_SPITVersion = SPITVERSION;
			m_MessageNumber = 0;
			m_BytesCount = BYTESLENGTH;
			m_ServerID = "";
			m_ClientID = "";
		}
		
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			String stringSPIT_ID;
			try {
				m_ParseOffset = 0;
				//SPIT ID
				stringSPIT_ID = getString(p_MessageBytes, m_ParseOffset, 7);
				if (SPITID.toLowerCase().equals(stringSPIT_ID.toLowerCase()) == false) return false;
				m_ParseOffset += 7;
				m_SPITVersion = getInt(p_MessageBytes, m_ParseOffset);
				if (m_SPITVersion < 0) return false;
				m_ParseOffset += 4;
				m_MessageNumber = getByte(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				if (m_BytesCount < 0) return false;
				m_ParseOffset += 4;
				m_ServerID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_ClientID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_OPFlag = p_MessageBytes[m_ParseOffset] & 0xFF;
				m_ParseOffset += 1;
			}
			catch (Exception e) {
				return false;
			}
			return true;			
		}
		public String getSPITID() {
			return m_SPITID;
		}
		public int getSPITVersion() {
			return m_SPITVersion;
		}
		public byte getMessageNumber() {
			return m_MessageNumber;
		}
		public int getBytesCount() {
			return m_BytesCount;
		}
		public String getServerID() {
			return m_ServerID;
		}
		public String getClientID() {
			return m_ClientID;
		}
		public int getOPFlag() {
			return m_OPFlag;
		}
		
		//Send
		public Header(int p_SPITVersion, int p_OPFlag) {
			initMembers();
			m_SPITVersion = p_SPITVersion;
			m_OPFlag = p_OPFlag;
		}
		
		public void setMessageNumber(byte p_MessageNumber) {
			m_MessageNumber = p_MessageNumber;
		}
		
		public void setBytesCount(int p_BytesCount) {
			m_BytesCount = p_BytesCount;
		}
		public void setServerID(String p_ID) {
			m_ServerID = p_ID;
		}
		public void setClientID(String p_ID) {
			m_ClientID = p_ID;
		}
		public void setOPFlag(int p_OPFlag) {
			m_OPFlag = p_OPFlag;
		}
		public boolean fillBytes(byte[] p_Bytes) {
			if (p_Bytes == null) return false;
			try {
				m_ParseOffset = 0;
				m_ParseOffset += setString(m_SPITID, p_Bytes, m_ParseOffset, 7);
				m_ParseOffset += setInt(SPITVERSION, p_Bytes, m_ParseOffset);
				m_ParseOffset += setByte(m_MessageNumber, p_Bytes, m_ParseOffset);
				m_ParseOffset += setInt(m_BytesCount, p_Bytes, m_ParseOffset);
				m_ParseOffset += setString(m_ServerID, p_Bytes, m_ParseOffset, 41);
				m_ParseOffset += setString(m_ClientID, p_Bytes, m_ParseOffset, 41);
				m_ParseOffset += setByte(m_OPFlag, p_Bytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}
			return true;
		}
	}
	
	//---------- OP classes -------
	public abstract static class OPPart {
		protected Header		m_Header;
		protected int			m_ParseOffset;
		protected int			m_BytesCount;

		//Send
		public OPPart() {
			m_Header = null;
			m_ParseOffset = 0;
		}
		public abstract boolean fillBytes(byte[] p_MessageBytes);
		
		//Receive
		public OPPart(Header p_Header, int p_OPFlag) {
			m_Header = p_Header;
			if (m_Header != null) {
				m_ParseOffset = m_Header.getBytesCount();
				m_Header.setOPFlag(p_OPFlag);
			}
		}
		public void setHeader(Header p_Header) {
			m_Header = p_Header;
			if (m_Header != null) {
				m_ParseOffset = m_Header.getBytesCount();
			}
		}
		public Header getHeader() {
			return m_Header;
		}
		public void setBytesCount(int p_BytesCount) {
			m_BytesCount = p_BytesCount;
		}
		public int getBytesCount() {
			return m_BytesCount;
		}
		public String getServerID() {
			if (m_Header == null) return "";
			return m_Header.getServerID();
		}
		public String getClientID() {
			if (m_Header == null) return "";
			return m_Header.getClientID();
		}		
		public int getOPFlag() {
			if (m_Header == null) return -1;
			return m_Header.getOPFlag();
		}
		public abstract boolean parse(byte[] p_MessageBytes);
	}
	
	//---------------- Connection --------------
	public static class Connect extends OPPart {
		public static final int	OPFLAG = 1;
		public static final int	BYTESLENGTH = 304;
		
		private String	m_ClientComputerName;
		private String	m_ClientName;
		private String	m_LoginName;
		private String	m_LoginPassword;
		private String	m_ServerIP;
		private int		m_ServerPort;

		private void initMembers() {
			m_ClientComputerName = "";
			m_ClientName = "";
			m_LoginName = "";
			m_LoginPassword = "";
			m_ServerIP = "";
			m_ServerPort = 0;
			m_BytesCount = BYTESLENGTH;
		}
		//Receive
		public Connect(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_ClientComputerName = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_ClientName = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_LoginName = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_LoginPassword = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_ServerIP = getString(p_MessageBytes, m_ParseOffset, 40);
				m_ParseOffset += 40;
				m_ServerPort = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		public String getClientComputerName() {
			return m_ClientComputerName;
		}
		public String getClientName() {
			return m_ClientName;
		}
		public String getLoginName() {
			return m_LoginName;
		}
		public String getLoginPassword() {
			return m_LoginPassword;
		}
		public String getServerIP() {
			return m_ServerIP;
		} 
		public int getServerPort() {
			return m_ServerPort;
		}
		
		//Send
		public Connect() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		public void setClientComputerName(String p_ComputerName) {
			m_ClientComputerName = p_ComputerName;
		}
		public void setClientName(String p_ClientName) {
			m_ClientName = p_ClientName;
		}
		public void setLoginName(String p_LoginName) {
			m_LoginName = p_LoginName;
		}
		public void setLoginPassword(String p_LoginPassword) {
			m_LoginPassword = p_LoginPassword;
		}
		public void setServerIP(String p_ServerIP) {
			if (p_ServerIP == null) p_ServerIP = "";
			m_ServerIP = p_ServerIP;
		}
		public void setServerPort(int p_ServerPort) {
			if (p_ServerPort < 0 || p_ServerPort > 65535) p_ServerPort = 0;
			m_ServerPort = p_ServerPort;
		}
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_ClientComputerName, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setString(m_ClientName, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setString(m_LoginName, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setString(m_LoginPassword, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setString(m_ServerIP, p_MessageBytes, m_ParseOffset, 40);
				m_ParseOffset += setInt(m_ServerPort, p_MessageBytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	public static class ConnectAnswer extends OPPart {
		public static final int OPFLAG = 2;
		public static final int	BYTESLENGTH = 137;
		
		private String	m_ServerComputerName;
		private String	m_ServerName;
		private boolean	m_Connected;
		private int		m_StepTime; //ms step size the Server will send play sequences 
				
		private void initMembers() {
			m_ServerComputerName = "";
			m_ServerName = "";
			m_Connected = false;
			m_BytesCount = BYTESLENGTH;
			m_StepTime = 40;
		}
		//Receive
		public ConnectAnswer(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_ServerComputerName = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_ServerName = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_StepTime = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_Connected = getBoolean(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		public String getServerComputerName() {
			return m_ServerComputerName;
		}
		public String getServerName() {
			return m_ServerName;
		}
		public boolean getConnected() {
			return m_Connected;
		}
		public int getStepTime() {
			return m_StepTime;
		}
		
		//Send
		public ConnectAnswer() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		public void setServerComputerName(String p_ServerComputerName) {
			if (p_ServerComputerName == null) p_ServerComputerName = "";
			m_ServerComputerName = p_ServerComputerName;
		}
		public void setServerName(String p_ServerName) {
			if (p_ServerName == null) p_ServerName = "";
			m_ServerName = p_ServerName;
		}
		public void setConnected(boolean p_Connected) {
			m_Connected = p_Connected;
		}
		public void setStepTime(int p_StepTime_ms) {
			if (p_StepTime_ms < 0) p_StepTime_ms = 1;
			m_StepTime = p_StepTime_ms;
		}
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_ServerComputerName, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setString(m_ServerName, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setInt(m_StepTime, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setBoolean(m_Connected, p_MessageBytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	public static class Disconnect extends OPPart {
		public static final int OPFLAG = 3;
		public static final int	BYTESLENGTH = 4;
		
		
		private void initMembers() {
			m_BytesCount = BYTESLENGTH;
		}
		public Disconnect(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (Exception e) {
				return false;
			}
			return true;
		}
		
		// Send
		public Disconnect() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
		}
		
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (Exception e) {
				return false;
			}
			return true;
		}
		
	}
	
	public static class Watchdog extends OPPart {
		public static final int OPFLAG = 8;
		public static final int	BYTESLENGTH = 4;
		

		private void initMembers() {
			m_BytesCount = BYTESLENGTH;
		}
		//Receive
		public Watchdog(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (Exception e) {
				return false;
			}
			return true;
		}
				
		// Send
		public Watchdog() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;	
			}
			catch (Exception e) {
				return false;
			}
			return true;
		}
	}
	public static class WatchdogAnswer extends OPPart {
		public static final int OPFLAG = 9;
		public static final int	BYTESLENGTH = 4;
		
		private void initMembers() {
			m_BytesCount = BYTESLENGTH;
		}
		//Receive
		public WatchdogAnswer(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (Exception e) {
				return false;
			}
			return true;
		}
		
		
		// Send
		public WatchdogAnswer() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (Exception e) {
				return false;
			}
			return true;
		}	
	}
	
	public static class ReportSPITProject extends OPPart {
		public static final int OPFLAG = 11;
		public static final int	BYTESLENGTH = 113;
		
		private String	m_ProjectID;
		private String	m_ProjectName;
		private int		m_FramesPerSecond; //Frames per second
		
		private void initMembers() {
			m_ProjectID = "";
			m_ProjectName = "";
			m_BytesCount = BYTESLENGTH;
			m_FramesPerSecond = 1000;
		}
		//Receive
		public ReportSPITProject(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_ProjectID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_ProjectName = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_FramesPerSecond = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		public String getProjectID() {
			return m_ProjectID;
		}
		public String getProjectName() {
			return m_ProjectName;
		}
		public int getFramesPerSecond() {
			return m_FramesPerSecond;
		}
		// Send
		public ReportSPITProject() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		public void setProjectID(String p_ProjectID) {
			m_ProjectID = p_ProjectID;
		}
		public void setProjectName(String p_ProjectName) {
			m_ProjectName = p_ProjectName;
		}
		public void setFramesPerSecond(int p_FramesPerSecond) {
			m_FramesPerSecond = p_FramesPerSecond;
		}
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_ProjectID, p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += setString(m_ProjectName, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setInt(m_FramesPerSecond, p_MessageBytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	public static class CloseSPITProject extends OPPart {
		public static final int OPFLAG = 13;
		public static final int	BYTESLENGTH = 45;
		
		private String	m_ProjectID;
		
		private void initMembers() {
			m_ProjectID = "";
			m_BytesCount = BYTESLENGTH;
		}
		//Receive
		public CloseSPITProject(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_ProjectID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		public String getProjectID() {
			return m_ProjectID;
		}
		// Send
		public CloseSPITProject() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		public void setProjectID(String p_ClientID) {
			m_ProjectID = p_ClientID;
		}
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_ProjectID, p_MessageBytes, m_ParseOffset, 41);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	public static class RequestProjectTransfer extends OPPart {
		public static final int OPFLAG = 15;
		public static final int	BYTESLENGTH = 4;
		
		
		private void initMembers() {
			m_BytesCount = BYTESLENGTH;
		}
		//Receive
		public RequestProjectTransfer(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		// Send
		public RequestProjectTransfer() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	public static class StartProjectTransfer extends OPPart {
		public static final int OPFLAG = 16;
		public static final int	BYTESLENGTH = 4;
		
		
		private void initMembers() {
			m_BytesCount = BYTESLENGTH;
		}
		//Receive
		public StartProjectTransfer(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		// Send
		public StartProjectTransfer() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	public static class EndProjectTransfer extends OPPart {
		public static final int OPFLAG = 17;
		public static final int	BYTESLENGTH = 4;
				
		private void initMembers() {
			m_BytesCount = BYTESLENGTH;
		}
		//Receive
		public EndProjectTransfer(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		// Send
		public EndProjectTransfer() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	//-------------- SPITTypes ----------------
	public static class ReportSPITType extends OPPart {
		public static final int OPFLAG = 21;
		public static final int	BYTESLENGTH = 168;
		
		private boolean	m_Confirmed;
		private String	m_SPITTypeID;
		private boolean	m_Fixed;
		private boolean	m_ServerRemote;
		private boolean	m_ServerProjectIndepended;
		private String	m_SPITTypeGroupName;
		private String	m_SPITTypeName;
		private long	m_Delay;
		private long	m_Duration;
		
		private void initMembers() {
			m_Confirmed = false;
			m_SPITTypeID = "";
			m_Fixed = false;
			m_ServerRemote = false;
			m_ServerProjectIndepended = false;
			m_SPITTypeGroupName = "";
			m_SPITTypeName = "";
			m_Delay = 0;
			m_Duration = 0;
			m_BytesCount = BYTESLENGTH;
		}

		//Receive
		public ReportSPITType(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_Confirmed = getBoolean(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_SPITTypeID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_Fixed = getBoolean(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_ServerRemote = getBoolean(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_ServerProjectIndepended = getBoolean(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_SPITTypeGroupName = getString(p_MessageBytes, m_ParseOffset, 39);
				m_ParseOffset += 39;
				m_SPITTypeName = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_Delay = getLong(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 8;
				m_Duration = getLong(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 8;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		
		public boolean getConfirmed() {
			return m_Confirmed;
		}
		public String getID() {
			return m_SPITTypeID;
		}
		public boolean getFixed() {
			return m_Fixed;
		}
		public boolean getServerRemote() {
			return m_ServerRemote;
		}
		public boolean getServerProjectIndepended() {
			return m_ServerProjectIndepended;
		}
		public String getGroupName() {
			return m_SPITTypeGroupName;
		}
		public String getName() {
			return m_SPITTypeName;
		}
		public long getDelay() {
			return m_Delay;
		}
		public long getDuration() {
			return m_Duration;
		}
		// Send
		public ReportSPITType() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		public void setConfirmed(boolean p_Confirmed) {
			m_Confirmed = p_Confirmed;
		}
		public void setID(String p_ID) {
			m_SPITTypeID = p_ID;
		}
		public void setFixed(boolean p_Fixed) {
			m_Fixed = p_Fixed;
		}
		public void setServerRemote(boolean p_IsServerRemote) {
			m_ServerRemote = p_IsServerRemote;
		}
		public void setServerProjectIndepended(boolean p_ProjectIndpended) {
			m_ServerProjectIndepended = p_ProjectIndpended;
		}
		public void setGroupName(String p_GroupName) {
			m_SPITTypeGroupName = p_GroupName;
		}
		public void setName(String p_Name) {
			m_SPITTypeName = p_Name;
		}
		public void setDelay(long p_Delay) {
			m_Delay = p_Delay;
		}
		public void setDuration(long p_Duration) {
			m_Duration = p_Duration;
		}
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setBoolean(m_Confirmed, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_SPITTypeID, p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += setBoolean(m_Fixed, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setBoolean(m_ServerRemote, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setBoolean(m_ServerProjectIndepended, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_SPITTypeGroupName, p_MessageBytes, m_ParseOffset, 39);
				m_ParseOffset += setString(m_SPITTypeName, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setLong(m_Delay, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setLong(m_Duration, p_MessageBytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	
	public static class RemoveSPITType extends OPPart {
		public static final int OPFLAG = 23;
		public static final int	BYTESLENGTH = 45;
		
		private String	m_SPITTypeID;
		
		private void initMembers() {
			m_SPITTypeID = "";
			m_BytesCount = BYTESLENGTH;
		}

		//Receive
		public RemoveSPITType(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_SPITTypeID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		public String getID() {
			return m_SPITTypeID;
		}
		// Send
		public RemoveSPITType() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		public void setID(String p_ID) {
			m_SPITTypeID = p_ID;
		}
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_SPITTypeID, p_MessageBytes, m_ParseOffset, 41);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	//-------------- SPITObjects ----------------
	public static final byte	VALUEUSE_DISCARD = 0x00; //value of SPITObejct is not used
	public static final byte	VALUEUSE_INRANGE = 0x01; //value of SPITOBject in range 0 - 1000000ppm
	public static final byte	VALUEUSE_OVERRIDE = 0x02; //value can be overridden
	
	public static class ReportSPITObject extends OPPart {
		public static final int OPFLAG = 31;
		public static final int	BYTESLENGTH = 339;
		
		private boolean	m_Confirmed;
		private String	m_SPITObjectID;
		private Boolean	m_Fixed;
		private boolean	m_ServerRemote;
		private String	m_SPITObjectName;
		private String	m_SPITTypeID;
		private String	m_ServerParams;
		private long	m_FrameStart;
		private long	m_FrameLength;
		private long	m_FrameFadeInLength;
		private long	m_FrameFadeOutLength;
		private int		m_ValueFactor;
		private byte	m_ValueUse;
		private int		m_Track;
		private String	m_Remark;
		private long	m_Delay;
		private long	m_Duration;
		private boolean	m_ActionAssigned;
		
		private void initMembers() {
			m_Confirmed = false;
			m_SPITObjectID = "";
			m_Fixed = false;
			m_ServerRemote = false;
			m_SPITObjectName = "";
			m_SPITTypeID = "";
			m_ServerParams = "";
			m_FrameStart = 0;
			m_FrameLength = 0;
			m_FrameFadeInLength = 0;
			m_FrameFadeOutLength = 0;
			m_ValueFactor = 0;
			m_ValueUse = VALUEUSE_DISCARD;
			m_Track = 0;
			m_Remark = "";
			m_Delay = 0;
			m_Duration = 0;
			m_ActionAssigned = false;
			m_BytesCount = BYTESLENGTH;
		}

		//Receive
		public ReportSPITObject(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_Confirmed = getBoolean(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_SPITObjectID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_Fixed = getBoolean(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_ServerRemote = getBoolean(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_SPITObjectName = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_SPITTypeID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_ServerParams = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_FrameStart = getLong(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 8;
				m_FrameLength = getLong(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 8;
				m_FrameFadeInLength = getLong(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 8;
				m_FrameFadeOutLength = getLong(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 8;
				m_ValueFactor = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_ValueUse = getByte(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_Track = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_Remark = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_Delay = getLong(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 8;
				m_Duration = getLong(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 8;
				m_ActionAssigned = getBoolean(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		public boolean getConfirmed() {
			return m_Confirmed;
		}
		public String getID() {
			return m_SPITObjectID;
		}
		public boolean getFixed() {
			return m_Fixed;
		}
		public boolean getServerRemote() {
			return m_ServerRemote;
		}
		public String getName() {
			return m_SPITObjectName;
		}
		public String getSPITTypeID() {
			return m_SPITTypeID;
		}
		public String getServerParams() {
			return m_ServerParams;
		}
		public long getFrameStart() {
			return m_FrameStart;
		}
		public long getFrameLength() {
			return m_FrameLength;
		}
		public long getFrameFadeInLength() {
			return m_FrameFadeInLength;
		}
		public long getFrameFadeOutLength() {
			return m_FrameFadeOutLength;
		}
		public int getValueFactor() {
			return m_ValueFactor;
		}
		public byte getValueUse() {
			return m_ValueUse;
		}
		public int getTrack() {
			return m_Track;
		}
		public String getRemark() {
			return m_Remark;
		}
		public long getDelay() {
			return m_Delay;
		}
		public long getDuration() {
			return m_Duration;
		}
		public boolean getActionAssigned() {
			return m_ActionAssigned;
		}
		// Send
		public ReportSPITObject() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		public void setConfirmed(boolean p_Confirmed) {
			m_Confirmed = p_Confirmed;
		}
		public void setID(String p_ID) {
			m_SPITObjectID = p_ID;
		}
		public void setFixed(boolean p_Fixed) {
			m_Fixed = p_Fixed;
		}
		public void setServerRemote(boolean p_IsRemote) {
			m_ServerRemote = p_IsRemote;
		}
		public void setName(String p_Name) {
			m_SPITObjectName = p_Name;
		}
		public void setSPITTypeID(String p_ID) {
			m_SPITTypeID = p_ID;
		}
		public void setServerParams(String p_Parameters) {
			m_ServerParams = p_Parameters;
		}
		public void setFrameStart(long p_StartTime) {
			m_FrameStart = p_StartTime;
		}
		public void setFrameLength(long p_Length) {
			m_FrameLength = p_Length;
		}
		public void setFrameFadeInLength(long p_FadeInTime) {
			m_FrameFadeInLength = p_FadeInTime;
		}
		public void setFrameFadeOutLength(long p_FadeOutTime) {
			m_FrameFadeOutLength = p_FadeOutTime;
		}
		public void setValueFactor(int p_Volume) {
			m_ValueFactor = p_Volume;
		}
		public void setValueUse(byte p_ValueUse) {
			m_ValueUse = p_ValueUse;
		}
		public void setTrack(int p_Track) {
			m_Track = p_Track;
		}
		public void setRemark(String p_Description) {
			m_Remark = p_Description;
		}
		public void setDelay(long p_Delay) {
			if (p_Delay < 0) p_Delay = 0;
			m_Delay = p_Delay;
		}
		public void setDuration(long p_Duration) {
			if (p_Duration < 0) p_Duration = 0;
			m_Duration = p_Duration;
		}
		
		public void setActionAssigned(boolean p_ActionAssigned) {
			m_ActionAssigned = p_ActionAssigned;
		}
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setBoolean(m_Confirmed, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_SPITObjectID, p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += setBoolean(m_Fixed, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setBoolean(m_ServerRemote, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_SPITObjectName, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setString(m_SPITTypeID, p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += setString(m_ServerParams, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setLong(m_FrameStart, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setLong(m_FrameLength, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setLong(m_FrameFadeInLength, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setLong(m_FrameFadeOutLength, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setInt(m_ValueFactor, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setByte(m_ValueUse, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setInt(m_Track, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_Remark, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setLong(m_Delay, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setLong(m_Duration, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setBoolean(m_ActionAssigned, p_MessageBytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	
	public static class RemoveSPITObject extends OPPart {
		public static final int OPFLAG = 33;
		public static final int	BYTESLENGTH = 45;
		
		private String	m_SPITObjectID;
		
		private void initMembers() {
			m_SPITObjectID = "";
			m_BytesCount = BYTESLENGTH;
		}

		//Receive
		public RemoveSPITObject(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_SPITObjectID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		public String getID() {
			return m_SPITObjectID;
		}
		
		// Send
		public RemoveSPITObject() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		public void setID(String p_ID) {
			m_SPITObjectID = p_ID;
		}
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_SPITObjectID, p_MessageBytes, m_ParseOffset, 41);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}

	public static final byte PLAYERTYPE_MAIN = 0x02;
	public static final byte PLAYERTYPE_CONTINIOUS = 0x01;
	public static final byte PLAYERTYPE_DISCRETE = 0x00;
	
	
	public static class PlaySPITStart extends OPPart {
		public static final int OPFLAG = 37;
		public static final int	BYTESLENGTH = 119;
						
		private String	m_PlayerID;
		private String	m_PlayerName;
		private byte	m_PlayerType;
		private boolean	m_PlayerIsRunning;
		private long	m_Time; //Frames
		
		private void initMembers() {
			m_PlayerID = "";
			m_PlayerName = "";
			m_PlayerType = 0x00;
			m_Time = 0;
			m_PlayerIsRunning = false;
			m_BytesCount = BYTESLENGTH;
		}

		//Receive
		public PlaySPITStart(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_PlayerID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_PlayerName = getString(p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += 64;
				m_PlayerType = getByte(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_PlayerIsRunning = getBoolean(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_Time = getLong(p_MessageBytes, m_ParseOffset);
				m_ParseOffset+= 8;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		public String getPlayerID() {
			return m_PlayerID;
		}
		public String getPlayerName() {
			return m_PlayerName;
		}
		public byte getPlayerType() {
			return m_PlayerType;
		}
		public boolean getPlayerIsRunning() {
			return m_PlayerIsRunning;
		}
		public long getTime() {
			return m_Time;
		}
		
		// Send
		public PlaySPITStart() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		public void setPlayerID(String p_PlayerID) {
			if (p_PlayerID == null) p_PlayerID = "";
			m_PlayerID = p_PlayerID;
		}
		public void setPlayerName(String p_PlayerName) {
			if (p_PlayerName == null) p_PlayerName = "";
			m_PlayerName = p_PlayerName;
		}
		public void setPlayerType(byte p_PlayerType) {
			m_PlayerType = p_PlayerType;
		}
		public void setPlayerIsRunning(boolean p_IsPlaying) {
			m_PlayerIsRunning = p_IsPlaying;
		}
		public void setTime(long p_Time) {
			m_Time = p_Time;
		}
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_PlayerID, p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += setString(m_PlayerName, p_MessageBytes, m_ParseOffset, 64);
				m_ParseOffset += setByte(m_PlayerType, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setBoolean(m_PlayerIsRunning, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setLong(m_Time, p_MessageBytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	public static final byte VALUEFLAG_DIRECT = 0x00;
	public static final byte VALUEFLAG_INCREASE = 0x01;
	public static final byte VALUEFLAG_DECREASE = 0x02;
	
	public static class PlaySPITObject extends OPPart {
		public static final int OPFLAG = 38;
		public static final int	BYTESLENGTH = 100;
		
		private String	m_PlayerID;
		private String	m_SPITObjectID;
		private long	m_FrameInsideObject; //Frames
		private boolean	m_PlayPrePosition;
		private int		m_Value;
		private byte	m_ValueFlag;
		
		private void initMembers() {
			m_PlayerID = "";
			m_SPITObjectID = "";
			m_FrameInsideObject = 0;
			m_Value = 0;
			m_ValueFlag = VALUEFLAG_DIRECT;
			m_BytesCount = BYTESLENGTH;
		}

		//Receive
		public PlaySPITObject(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_PlayerID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_SPITObjectID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_FrameInsideObject = getLong(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 8;
				m_PlayPrePosition = getBoolean(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
				m_Value = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_ValueFlag = getByte(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 1;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		public String getPlayerID() {
			return m_PlayerID;
		} 
		public String getID() {
			return m_SPITObjectID;
		}
		public long getFrameInsideObject() {
			return m_FrameInsideObject;
		}
		public boolean getPlayPrePosition() {
			return m_PlayPrePosition;
		}
		public int getValue() {
			return m_Value;
		}
		public byte getValueFlag() {
			return m_ValueFlag;
		}
		// Send
		public PlaySPITObject() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		public void setPlayerID(String p_PlayerID) {
			if (p_PlayerID == null) p_PlayerID = "";
			m_PlayerID = p_PlayerID;
		}
		public void setID(String p_ID) {
			m_SPITObjectID = p_ID;
		}
		public void setFrameInsideObject(long p_TimeInside) {
			m_FrameInsideObject = p_TimeInside;
		}
		public void setPlayPrePosition(boolean p_PlayOldPosition) {
			m_PlayPrePosition = p_PlayOldPosition;
		}
		public void setValue(int p_Value) {
			m_Value = p_Value;
		}
		public void setValueFlag(byte p_ValueFlag) {
			m_ValueFlag = p_ValueFlag;
		}
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_PlayerID, p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += setString(m_SPITObjectID, p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += setLong(m_FrameInsideObject, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setBoolean(m_PlayPrePosition, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setInt(m_Value, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setByte(m_ValueFlag, p_MessageBytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	public static class PlaySPITEnd extends OPPart {
		public static final int OPFLAG = 39;
		public static final int	BYTESLENGTH = 45;
		
		private String	m_PlayerID;
		
		private void initMembers() {
			m_PlayerID = "";
			m_BytesCount = BYTESLENGTH;
		}

		//Receive
		public PlaySPITEnd(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_PlayerID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		public String getPlayerID() {
			return m_PlayerID;
		}
		
		// Send
		public PlaySPITEnd() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		public void setPlayerID(String p_PlayerID) {
			if (p_PlayerID == null) p_PlayerID = "";
			m_PlayerID = p_PlayerID;
		}
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_PlayerID, p_MessageBytes, m_ParseOffset, 41);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	public static class ReportPlayStatus extends OPPart {
		public static final int OPFLAG = 40;
		public static final int	BYTESLENGTH = 57;
		
		private String	m_SPITObjectID;
		private long	m_FrameInsideObject; //Frames
		private int		m_Value;
		
		private void initMembers() {
			m_SPITObjectID = "";
			m_FrameInsideObject = 0;
			m_Value = 0;
			m_BytesCount = BYTESLENGTH;
		}

		//Receive
		public ReportPlayStatus(Header p_Header) {
			super(p_Header, OPFLAG);
			initMembers();
		}
		
		@Override
		public boolean parse(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			int intOPFlag = m_Header.getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_BytesCount = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
				m_SPITObjectID = getString(p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_FrameInsideObject = getLong(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 8;
				m_Value = getInt(p_MessageBytes, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (Exception e) {
				return false;
			}			
			return true;
		}
		public String getID() {
			return m_SPITObjectID;
		}
		public long getFrameInsideObject() {
			return m_FrameInsideObject;
		}
		public int getValue() {
			return m_Value;
		}
		// Send
		public ReportPlayStatus() {
			super();
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			super.setHeader(m_Header);
			m_ParseOffset = Header.BYTESLENGTH;
		}	
		
		public void setID(String p_ID) {
			m_SPITObjectID = p_ID;
		}
		public void setFrameInsideObject(long p_TimeInside) {
			m_FrameInsideObject = p_TimeInside;
		}
		public void setValue(int p_Value) {
			m_Value = p_Value;
		}
		
		@Override
		public boolean fillBytes(byte[] p_MessageBytes) {
			if (p_MessageBytes == null) return false;
			if (m_Header == null) return false;
			if (m_Header.fillBytes(p_MessageBytes) == false) return false;
			try {
				m_ParseOffset = m_Header.getBytesCount();
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setString(m_SPITObjectID, p_MessageBytes, m_ParseOffset, 41);
				m_ParseOffset += setLong(m_FrameInsideObject, p_MessageBytes, m_ParseOffset);
				m_ParseOffset += setInt(m_Value, p_MessageBytes, m_ParseOffset);
			}
			catch (Exception e) {
				return false;
			}		
			return true;
		}
	}
	
	
	
	//-------------------------------------------------
	//--------- COnversion type <-> ByteArray ---------
	//-------------------------------------------------
	
	public static byte[] createByteArray(OPPart p_OPPart) {
		if (p_OPPart == null) return null;
		int intBytesCount = 0;
		byte[] o_ByteArray;
		try {
			intBytesCount = p_OPPart.getHeader().getBytesCount();
			intBytesCount += p_OPPart.getBytesCount();
			o_ByteArray = new byte[intBytesCount];
		}
		catch (Exception e) {
			return null;
		}
		return o_ByteArray;
	}
	
	/**
	 * Fill the p_String in the byte array. A 0x00 byte will be added.<br>
	 * If p_String.length() is greater than p_Length -1, the p_String will be truncated.
	 * @param p_String the string
	 * @param p_Bytes the byte array where the string will be filled
	 * @param p_Offset the offset inside the byte array
	 * @param p_Length the length of the string included the null terminate byte.<br>
	 * @throws Exception if p_String == null, p_Bytes == null<br>
	 * p_Offset less than 0<br>
	 * p_Bytes.length less than p_Offset + p_Length
	 */
	public static int setString(String p_String, byte[] p_Bytes, int p_Offset, int p_Length) throws Exception {
		if (p_String == null)  throw new Exception(s_ParseError);
		if (p_Offset < 0) throw new Exception(s_ParseError);
		int intMaxStringLength;
		intMaxStringLength = p_Length-1;
		if (intMaxStringLength < 0) throw new Exception(s_ParseError + " at byte " + p_Offset);
		if (p_Bytes == null || p_Bytes.length < p_Offset + p_Length) throw new Exception(s_ParseError + " at byte " + p_Offset);
		StringBuilder o_StringBuilder = new StringBuilder(p_Length);
		if (p_String.length() > intMaxStringLength) {
			o_StringBuilder.append(p_String, 0, intMaxStringLength);
		}
		else {
			o_StringBuilder.append(p_String);
		}
		System.arraycopy(o_StringBuilder.toString().getBytes(CHARSET), 0, p_Bytes, p_Offset, o_StringBuilder.length());
		
		if (o_StringBuilder.length() < p_Length) {
			//Instead of filling the whole byte array set only the null terminate byte (0x00)
			p_Bytes[p_Offset + p_String.length()] = 0x00;
//			byte[] o_ByteFiller;
//			o_ByteFiller = new byte[p_Length - o_StringBuilder.length()];
//			System.arraycopy(o_ByteFiller, 0, p_Bytes, p_Offset + p_String.length(), o_ByteFiller.length);
		}
		return p_Length;
	}
	/**
	 * Returns the string of the part of the byte sequence (0x00 null terminated).
	 * @param p_Bytes the byte array
	 * @param p_Offset the startposition of strings bytes
	 * @param p_Length the length of the string included the null terminate byte (0x00).<br>
	 * The length of the string will be p_Length -1.
	 * @return
	 * @throws Exception  if p_Bytes == null<br>
	 * p_Offset less than 0<br>
	 * p_Bytes.length less than p_Offset + p_Length<br>
	 * No 0x00 null terminate byte is found
	 */
	public static String getString(byte[] p_Bytes, int p_Offset, int p_Length) throws Exception {
		if (p_Offset < 0) throw new Exception(s_ParseError + " at byte " + p_Offset);
		if (p_Bytes == null || p_Bytes.length < p_Offset + p_Length) throw new Exception(s_ParseError + " at byte " + p_Offset);
		int intPos;
		for (intPos = 0; intPos < p_Length; intPos++) {
			if (p_Bytes[p_Offset + intPos] == 0x00) break;
		}
		if (intPos >= p_Length) throw new Exception(s_ParseError + " at byte " + p_Offset);
		return new String(p_Bytes, p_Offset, intPos, CHARSET);
	}
	
	public static int getInt(byte[] p_Bytes, int p_Offset) throws Exception {
		if (p_Offset < 0) throw new Exception(s_ParseError + " at byte " + p_Offset);
		if (p_Bytes == null || p_Bytes.length < p_Offset + 4) throw new Exception(s_ParseError + " at byte " + p_Offset);
		//low byte first
		int intValue = 0;
		intValue += ((p_Bytes[p_Offset] & 0x000000ff));
		intValue += ((p_Bytes[p_Offset+1] & 0x000000ff)<<8);
		intValue += ((p_Bytes[p_Offset+2] & 0x000000ff)<<16);
		intValue += ((p_Bytes[p_Offset+3] & 0x000000ff)<<24);
		return intValue;
	}
	public static long getLong(byte[] p_Bytes, int p_Offset) throws Exception {
		if (p_Offset < 0) throw new Exception(s_ParseError + " at byte " + p_Offset);
		if (p_Bytes == null || p_Bytes.length < p_Offset + 8) throw new Exception(s_ParseError + " at byte " + p_Offset);
		//low byte first
		long intValue = 0;
		intValue += ((long)(p_Bytes[p_Offset] & 0x000000ff));
		intValue += ((long)(p_Bytes[p_Offset+1] & 0x000000ff)<<8);
		intValue += ((long)(p_Bytes[p_Offset+2] & 0x000000ff)<<16);
		intValue += ((long)(p_Bytes[p_Offset+3] & 0x000000ff)<<24);
		intValue += ((long)(p_Bytes[p_Offset+4] & 0x000000ff)<<32);
		intValue += ((long)(p_Bytes[p_Offset+5] & 0x000000ff)<<40);
		intValue += ((long)(p_Bytes[p_Offset+6] & 0x000000ff)<<48);
		intValue += ((long)(p_Bytes[p_Offset+7] & 0x000000ff)<<56);
		return intValue;
	}
	public static int setInt(int p_Value, byte[] p_Bytes, int p_Offset) throws Exception {
		if (p_Offset < 0) throw new Exception(s_ParseError + " at byte " + p_Offset);
		if (p_Bytes == null || p_Bytes.length < p_Offset + 4) throw new Exception(s_ParseError + " at byte " + p_Offset);
		//low byte first
		p_Bytes[p_Offset+0] = (byte)(p_Value & 0x000000ff);
		p_Bytes[p_Offset+1] = (byte)((p_Value & 0x0000ff00)>>8);
		p_Bytes[p_Offset+2] = (byte)((p_Value & 0x00ff0000)>>16);
		p_Bytes[p_Offset+3] = (byte)((p_Value & 0xff000000)>>24);
		return 4;
	}
	public static int setLong(long p_Value, byte[] p_Bytes, int p_Offset) throws Exception {
		if (p_Offset < 0) throw new Exception(s_ParseError + " at byte " + p_Offset);
		if (p_Bytes == null || p_Bytes.length < p_Offset + 8) throw new Exception(s_ParseError + " at byte " + p_Offset);
		//low byte first
		p_Bytes[p_Offset+0] = (byte)((p_Value & 0x00000000000000ffL));
		p_Bytes[p_Offset+1] = (byte)((p_Value & 0x000000000000ff00L)>>8);
		p_Bytes[p_Offset+2] = (byte)((p_Value & 0x0000000000ff0000L)>>16);
		p_Bytes[p_Offset+3] = (byte)((p_Value & 0x00000000ff000000L)>>24);
		p_Bytes[p_Offset+4] = (byte)((p_Value & 0x000000ff00000000L)>>32);
		p_Bytes[p_Offset+5] = (byte)((p_Value & 0x0000ff0000000000L)>>40);
		p_Bytes[p_Offset+6] = (byte)((p_Value & 0x00ff000000000000L)>>48);
		p_Bytes[p_Offset+7] = (byte)((p_Value & 0xff00000000000000L)>>56);
		return 8;
	}
	public static boolean getBoolean(byte[] p_Bytes, int p_Offset) throws Exception {
		if (p_Offset < 0) throw new Exception(s_ParseError + " at byte " + p_Offset);
		if (p_Bytes == null || p_Bytes.length < p_Offset + 1) throw new Exception(s_ParseError + " at byte " + p_Offset);
		//low byte first
		if (p_Bytes[p_Offset] > 0x00) return true;
		else return false;
	}
	public static int setBoolean(boolean p_Value, byte[] p_Bytes, int p_Offset) throws Exception {
		if (p_Offset < 0) throw new Exception(s_ParseError + " at byte " + p_Offset);
		if (p_Bytes == null || p_Bytes.length < p_Offset + 1) throw new Exception(s_ParseError + " at byte " + p_Offset);
		if (p_Value == false) {
			p_Bytes[p_Offset] = 0x00;
		}
		else {
			p_Bytes[p_Offset] = 0x01;
		}
		return 1;
	}
	public static byte getByte(byte[] p_Bytes, int p_Offset) throws Exception {
		if (p_Offset < 0) throw new Exception(s_ParseError + " at byte " + p_Offset);
		if (p_Bytes == null || p_Bytes.length < p_Offset + 1) throw new Exception(s_ParseError + " at byte " + p_Offset);
		//low byte first
		return p_Bytes[p_Offset];
	}
	public static int setByte(int p_Value, byte[] p_Bytes, int p_Offset) throws Exception {
		if (p_Offset < 0) throw new Exception(s_ParseError + " at byte " + p_Offset);
		if (p_Bytes == null || p_Bytes.length < p_Offset + 1) throw new Exception(s_ParseError + " at byte " + p_Offset);
		p_Bytes[p_Offset] = (byte)(p_Value & 0xff);
		return 1;
	}
	
	
	//--------------------------------------------------------------
	//---------      Create SPIT_Messages               ------------
	//--------- without setting the CLint/Server ID		------------
	//- they will be set by send functions of the client instances -
	//--------------------------------------------------------------
	
	public static SPIT_Message createConnect(String p_ClientComputerName, String p_ClientName, String p_LoginName, String p_LoginPassword, String p_ServerIP, int p_Serverport) {
		SPIT_Message.Connect o_Connect;
		SPIT_Message o_SPIT_Message;
		o_Connect = new SPIT_Message.Connect();
		o_Connect.setClientComputerName(p_ClientComputerName);
		o_Connect.setClientName(p_ClientName);
		o_Connect.setLoginName(p_LoginName);
		o_Connect.setLoginPassword(p_LoginPassword);
		o_Connect.setServerIP(p_ServerIP);
		o_Connect.setServerPort(p_Serverport);
		o_SPIT_Message = new SPIT_Message(o_Connect);
		return o_SPIT_Message;
	}
			
	
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @param p_ConnectOK
	 * @param p_ServerName
	 * @param p_ServerStepTime
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createConnectAnswer(boolean p_ConnectOK, String p_ServerComputerName, String p_ServerName, int p_ServerStepTime) {
		SPIT_Message.ConnectAnswer o_ConnectAnswer;
		SPIT_Message o_SPIT_Message;
		o_ConnectAnswer = new SPIT_Message.ConnectAnswer();
		o_ConnectAnswer.setConnected(p_ConnectOK);
		o_ConnectAnswer.setServerComputerName(p_ServerComputerName);
		o_ConnectAnswer.setServerName(p_ServerName);
		o_ConnectAnswer.setStepTime(p_ServerStepTime);
		o_SPIT_Message = new SPIT_Message(o_ConnectAnswer);
		return o_SPIT_Message;
	}
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createDisconnect() {
		SPIT_Message.Disconnect o_Disconnect;
		SPIT_Message o_SPIT_Message;
		o_Disconnect = new SPIT_Message.Disconnect();
		o_SPIT_Message = new SPIT_Message(o_Disconnect);
		return o_SPIT_Message;		
	}
	
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @param p_ProjectID
	 * @param p_ProjectName
	 * @param p_ServerTimeResolution
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createReportSPITProject (String p_ProjectID, String p_ProjectName, int p_ServerTimeResolution) {
		SPIT_Message.ReportSPITProject o_ReportSPITProject;
		SPIT_Message o_SPIT_Message;
		o_ReportSPITProject = new SPIT_Message.ReportSPITProject();
		o_ReportSPITProject.setProjectID(p_ProjectID);
		o_ReportSPITProject.setProjectName(p_ProjectName);
		o_ReportSPITProject.setFramesPerSecond(p_ServerTimeResolution);
		o_SPIT_Message = new SPIT_Message(o_ReportSPITProject);
		return o_SPIT_Message;
	}
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createCloseSPITProject (String p_ProjectID) {
		SPIT_Message.CloseSPITProject o_CloseSPITProject;
		SPIT_Message o_SPIT_Message;
		o_CloseSPITProject = new SPIT_Message.CloseSPITProject();
		o_CloseSPITProject.setProjectID(p_ProjectID);
		o_SPIT_Message = new SPIT_Message(o_CloseSPITProject);
		return o_SPIT_Message;		
	}
	
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createRequestProjectTransfer() {
		SPIT_Message o_SPIT_Message;
		SPIT_Message.RequestProjectTransfer o_RequestProjectTransfer;
		o_RequestProjectTransfer = new SPIT_Message.RequestProjectTransfer();
		o_SPIT_Message = new SPIT_Message(o_RequestProjectTransfer);
		return o_SPIT_Message;		
	}
	
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @param p_ProjectID 
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createStartProjectTransfer() {
		SPIT_Message o_SPIT_Message;
		SPIT_Message.StartProjectTransfer o_StartProjectTransfer;
	
		o_StartProjectTransfer = new SPIT_Message.StartProjectTransfer();
		o_SPIT_Message = new SPIT_Message(o_StartProjectTransfer);
		return o_SPIT_Message;
	}
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @param p_ProjectID 
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createEndProjectTransfer() {
		SPIT_Message o_SPIT_Message;
		SPIT_Message.EndProjectTransfer o_EndProjectTransfer;
	
		o_EndProjectTransfer = new SPIT_Message.EndProjectTransfer();
		o_SPIT_Message = new SPIT_Message(o_EndProjectTransfer);
		return o_SPIT_Message;
	}

	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @param p_SPIT_Type_Interface
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createReportSPITType(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return null;
		SPIT_Message o_SPIT_Message;
		SPIT_Message.ReportSPITType o_ReportSPITType;
		o_ReportSPITType = new SPIT_Message.ReportSPITType();
		o_ReportSPITType.setConfirmed(p_SPIT_Type_Interface.getConfirmed());
		o_ReportSPITType.setID(p_SPIT_Type_Interface.getID());
		o_ReportSPITType.setFixed(p_SPIT_Type_Interface.getFixed());
		o_ReportSPITType.setServerRemote(p_SPIT_Type_Interface.getServerRemote());
		o_ReportSPITType.setServerProjectIndepended(p_SPIT_Type_Interface.getServerProjectIndepended());
		o_ReportSPITType.setGroupName(p_SPIT_Type_Interface.getGroupName());
		o_ReportSPITType.setName(p_SPIT_Type_Interface.getName());
		o_ReportSPITType.setDelay(p_SPIT_Type_Interface.getDelay());
		o_ReportSPITType.setDuration(p_SPIT_Type_Interface.getDuration());
		o_SPIT_Message = new SPIT_Message(o_ReportSPITType);
		return o_SPIT_Message;
	}
	
	
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @param p_SPIT_Type_Interface
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createRemoveSPITType(String p_SPIT_Type_ID) {
		if (p_SPIT_Type_ID == null) return null;
		SPIT_Message o_SPIT_Message;
		SPIT_Message.RemoveSPITType o_RemoveSPITType;
		o_RemoveSPITType = new SPIT_Message.RemoveSPITType();
		o_RemoveSPITType.setID(p_SPIT_Type_ID);
		o_SPIT_Message = new SPIT_Message(o_RemoveSPITType);
		return o_SPIT_Message;		
	}

	/**
	 * creates a SPIT_Message ReportSPITObject
	 * @param p_SPIT_Object_Interface
	 * @return 
	 */
	public static SPIT_Message createReportSPITObject(SPIT_Object_Interface p_SPIT_Object_Interface) {
		
		SPIT_Message o_SPIT_Message;
		SPIT_Message.ReportSPITObject o_ReportSPITObject;
		
		o_ReportSPITObject = new SPIT_Message.ReportSPITObject();
		
		o_ReportSPITObject.setConfirmed(p_SPIT_Object_Interface.getConfirmed());
		o_ReportSPITObject.setID(p_SPIT_Object_Interface.getID());
		o_ReportSPITObject.setFixed(p_SPIT_Object_Interface.getFixed());
		o_ReportSPITObject.setServerRemote(p_SPIT_Object_Interface.getServerRemote());
		o_ReportSPITObject.setName(p_SPIT_Object_Interface.getName());
		o_ReportSPITObject.setRemark(p_SPIT_Object_Interface.getRemark());
		o_ReportSPITObject.setSPITTypeID(p_SPIT_Object_Interface.getSPITTypeID());
		o_ReportSPITObject.setServerParams(p_SPIT_Object_Interface.getServerParams());
		o_ReportSPITObject.setFrameStart(p_SPIT_Object_Interface.getFrameStart());
		o_ReportSPITObject.setFrameLength(p_SPIT_Object_Interface.getFrameLength());
		o_ReportSPITObject.setFrameFadeInLength(p_SPIT_Object_Interface.getFrameFadeInLength());
		o_ReportSPITObject.setFrameFadeOutLength(p_SPIT_Object_Interface.getFrameFadeOutLength());
		o_ReportSPITObject.setValueFactor(p_SPIT_Object_Interface.getValueFactor());
		o_ReportSPITObject.setValueUse(p_SPIT_Object_Interface.getValueUse());
		o_ReportSPITObject.setTrack(p_SPIT_Object_Interface.getTrack());	
		o_ReportSPITObject.setDelay(p_SPIT_Object_Interface.getDelay());
		o_ReportSPITObject.setDuration(p_SPIT_Object_Interface.getDuration());
		o_ReportSPITObject.setActionAssigned(p_SPIT_Object_Interface.getActionAssigned());
		
		
		o_SPIT_Message = new SPIT_Message(o_ReportSPITObject);
		return o_SPIT_Message;
	}
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @param p_SPIT_ObjectID 
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createRemoveSPITObject(String p_SPIT_ObjectID) {
		SPIT_Message o_SPIT_Message;
		SPIT_Message.RemoveSPITObject o_RemoveSPITObject;
		
		o_RemoveSPITObject = new SPIT_Message.RemoveSPITObject();
		o_RemoveSPITObject.setID(p_SPIT_ObjectID);
		
		o_SPIT_Message = new SPIT_Message(o_RemoveSPITObject);
		return o_SPIT_Message;
	}
	

	
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @param p_PlayerID
	 * @param p_PlayerType
	 * @param p_PlayerIsRunning
	 * @param p_TimeFrames
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createPlaySPITStart(String p_PlayerID, String p_PLayerName, byte p_PlayerType, boolean p_PlayerIsRunning, long p_TimeFrames) {
		SPIT_Message o_SPIT_Message;
		SPIT_Message.PlaySPITStart o_PlaySPITStart;
		o_SPIT_Message = SPIT_MessagePlayPool.getPlaySPITStart();
		o_PlaySPITStart = (SPIT_Message.PlaySPITStart)o_SPIT_Message.getOPPart();
		o_PlaySPITStart.setPlayerID(p_PlayerID);
		o_PlaySPITStart.setPlayerName(p_PLayerName);
		o_PlaySPITStart.setPlayerType(p_PlayerType);
		o_PlaySPITStart.setPlayerIsRunning(p_PlayerIsRunning);
		o_PlaySPITStart.setTime(p_TimeFrames);
//System.out.println("SPITServer_Client sendPlaySPITStart " + o_PlaySPITStart.getTime() + " Running " + o_PlaySPITStart.getPlayerIsRunning());
		return o_SPIT_Message;
	}
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @param p_PlayerID
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createPlaySPITEnd(String p_PlayerID) {
		SPIT_Message o_SPIT_Message;
		SPIT_Message.PlaySPITEnd o_PlaySPITEnd;
		o_SPIT_Message = SPIT_MessagePlayPool.getPlaySPITEnd();
		o_PlaySPITEnd = (SPIT_Message.PlaySPITEnd)o_SPIT_Message.getOPPart();
		o_PlaySPITEnd.setPlayerID(p_PlayerID);
//System.out.println("SPITServer_Client sendPlaySPITEnd " + o_PlaySPITEnd.getTime() + " Running " + o_PlaySPITEnd.getPlayerIsRunning());
		return o_SPIT_Message;
	}
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @param p_PlayerID
	 * @param p_SPIT_ObjectID
	 * @param p_FrameInside
	 * @param p_IsPreObject
	 * @param p_Value ppm
	 * @param p_ValueFlag
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createPlaySPITObject(String p_PlayerID, 
			String p_SPIT_ObjectID , long p_FrameInside, boolean p_IsPreObject, int p_Value, byte p_ValueFlag) {
		SPIT_Message o_SPIT_Message;
		SPIT_Message.PlaySPITObject o_PlaySPITObject;
		
		o_SPIT_Message = SPIT_MessagePlayPool.getPlaySPITObject();
		o_PlaySPITObject = (SPIT_Message.PlaySPITObject)o_SPIT_Message.getOPPart();
		
		o_PlaySPITObject.setPlayerID(p_PlayerID);
		o_PlaySPITObject.setID(p_SPIT_ObjectID);
		o_PlaySPITObject.setFrameInsideObject(p_FrameInside);
		o_PlaySPITObject.setPlayPrePosition(p_IsPreObject);
		o_PlaySPITObject.setValue(p_Value);
		o_PlaySPITObject.setValueFlag(p_ValueFlag);
		return o_SPIT_Message;
	}

	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createWatchdog() {
		SPIT_Message o_SPIT_Message;
		SPIT_Message.Watchdog o_Watchdog;
		o_Watchdog = new SPIT_Message.Watchdog();
		o_SPIT_Message = new SPIT_Message(o_Watchdog);
		return o_SPIT_Message;
	}
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @param p_SPIT_Object_Interface instance of p_SPIT_Object_Interface must have SPIT_ActionStatus
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createReportPlayStatus(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return null;
		SPIT_Message o_SPIT_Message;
		SPIT_Message.ReportPlayStatus o_ReportPlayStatus;
		SPIT_ActionStatus o_SPIT_ActionStatus;
		o_SPIT_ActionStatus = p_SPIT_Object_Interface.getSPIT_ActionStatus();
		if (o_SPIT_ActionStatus == null) return null;
		o_SPIT_Message = SPIT_MessagePlayPool.getReportPlayStatus();
		o_ReportPlayStatus = (SPIT_Message.ReportPlayStatus)o_SPIT_Message.getOPPart();
		
		o_ReportPlayStatus.setID(p_SPIT_Object_Interface.getID());
		o_ReportPlayStatus.setFrameInsideObject(o_SPIT_ActionStatus.getPlayFrameInside());
		o_ReportPlayStatus.setValue(o_SPIT_ActionStatus.getPlayValue());
		return o_SPIT_Message;
	}
	
	/**
	 * Create the SPITMessage, the Server ID and the Client ID must be set before the message is sent. 
	 * @return message without set Server ID and client ID.
	 * @see Header#setServerID(java.lang.String) 
	 * @see Header#setClientID(java.lang.String) 
	 */
	public static SPIT_Message createWatchdogAnswer() {
		SPIT_Message o_SPIT_Message;
		SPIT_Message.WatchdogAnswer o_WatchdogAnswer;
		o_WatchdogAnswer = new SPIT_Message.WatchdogAnswer();
		o_SPIT_Message = new SPIT_Message(o_WatchdogAnswer);
		return o_SPIT_Message;
	}
	
}
