/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITClientPackage;

import SPITActionPackage.SPIT_ActionPlayer;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.UUID;
import SPITLibraryPackage.SPIT_Watchdog;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_ClientListener;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import SwingModelPackage.SPIT_ObjectModel;
import SwingModelPackage.SPIT_TypeModel;
import SwingModelPackage.SinglePropertyChangeSupport;
import java.beans.PropertyChangeListener;

/**
 *
 * @author Hagi
 */
public class SPIT_Client implements SPIT_ClientInterface {
//	private ServerAutoDetect.DetectedServer m_DetectedServer;
	private byte				m_MessageNumber_Send;
	private byte				m_MessageNumber_Received;
	private final Object		m_SyncMessageNumber = new Object();
	private String				m_ID;
	private String				m_ClientComputerName;
	private String				m_Name;
	private String				m_ServerID;
	private String				m_ServerComputerName;
	private String				m_ServerName;
	private String				m_ServerProjectID; //may not be used
	private String				m_ServerProjectName;
	private int					m_ServerStepTime;
	private int					m_ServerFramesPerSecond;
	private boolean				m_Connected;
	
	private String				m_ProjectID;
	private String				m_ProjectName;
	private boolean				m_TransferringProject;
//	private SPIT_Project_Client		m_SPIT_Project;
	
	
	private SPIT_ClientSocket		m_SPIT_ClientSocket;
	private SPIT_Watchdog			m_SPIT_Watchdog;
	
	private ArrayList<SPIT_ClientListener>	m_SPITClientListeners;
	private final Object					m_SyncListener = new Object();
	
	public static SPIT_Client				s_SelfReference;

	private static SinglePropertyChangeSupport	s_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(SPIT_Client.class);
	
	public static SinglePropertyChangeSupport getPropertyChangeSupport() {
		return s_SinglePropertyChangeSupport;
	}

	
	public SPIT_Client(String p_ClientName) {
		s_SelfReference = this;
		initMembers();
		m_Name = p_ClientName;
		//create SPIT_CLientSocket
		m_SPIT_ClientSocket = new SPIT_ClientSocket(this);
	}
	private void initMembers() {
		m_ID = UUID.randomUUID().toString();
		m_MessageNumber_Send = 0;
		m_MessageNumber_Received = 0;
		m_ProjectID = "";
		m_ProjectName = "";
		m_ServerID = "";
		m_Name = getClass().getSimpleName(); // = "SPIT_Client";
		try {
			m_ClientComputerName = InetAddress.getLocalHost().getHostName();
		}
		catch (Exception e) {
			m_ClientComputerName = "";
		}
		m_ServerComputerName = "";
		m_ServerName = "";
		m_ServerProjectID = "";
		m_ServerProjectName = "";
		m_ServerStepTime = -1;
		m_Connected = false;
		
		//Init List for SPIT_CLientListeners
		m_SPITClientListeners = new ArrayList<>();

		//Create Watchdog
		m_SPIT_Watchdog = new SPIT_Watchdog(this);
	}
	
	@Override
	public void close() {
		eventCloseProject_Client(m_ProjectID);
		disconnect(false);	
		if (m_SPIT_ClientSocket != null) {
	//		m_SPIT_Watchdog.close();
		}
	}
	
	/**
	 * Connect the SPIT_Client to the SPIT_Server
	 * @param p_ServerInetAddress InetAddress of the SPIT_Server
	 * @param p_ServerPort port number of the SPIT_Server
	 * @param p_ClientPort port number of the SPIT_Client<br>
	 * maybe 0 then any free port number of the local machine is used
	 * @param p_LoginName Login name, is checked by the server when the SPITConnect message is sent 
	 * @param p_LoginPassword Login password, is checked by the server when the SPITConnect message is sent
	 * @return true = connection is ok, client listens to SPITMessages<br>
	 * false = the connection failed
	 * @see SPIT_ClientSocket#connect(java.net.InetAddress, int, java.lang.String, java.lang.String) 
	 */
	public boolean connect(InetAddress p_ServerInetAddress, int  p_ServerPort, int p_ClientPort, String p_LoginName, String p_LoginPassword) {
		return m_SPIT_ClientSocket.connect(p_ServerInetAddress, p_ServerPort, p_ClientPort, p_LoginName,  p_LoginPassword);		
	}

	
	/**
	 * Disconnect the SPIT_Client from the SPIT_Server 
	 * @return true = disconneted and the SPITDIsconnect message could be sent to the server<br>
	 * false = disconnected, but the SPITDIsconnect message could NOT be sent to the server
	 */
	public boolean disconnect(boolean p_ConnectionLost) {
		if (m_SPIT_ClientSocket == null) return false;
		boolean boolDisconnected;
		m_Connected = false;
		m_SPIT_Watchdog.stopWatchdog();
		SPIT_Type.unconfirmeAll();
		SPIT_Object.unconfirmeAll();
		SPITRemote.unconfirmeAll();
		boolDisconnected = m_SPIT_ClientSocket.disconnect();
		notifyDisconnected(p_ConnectionLost);
		return boolDisconnected;
	}

	@Override
	public boolean isConnected() {
		return m_Connected;
	}
	/**
	 * Return the ID of this SPIT_Client
	 * @return ID
	 */
	@Override
	public String getID() {
		return m_ID;
	}

	@Override
	public String getServerIP() {
		SPIT_ClientSocket o_SPIT_ClientSocket;
		o_SPIT_ClientSocket = m_SPIT_ClientSocket;
		if (o_SPIT_ClientSocket == null) return "";
		else return o_SPIT_ClientSocket.getServerHostAddress();
	}
	@Override
	public int getServerPort() {
		SPIT_ClientSocket o_SPIT_ClientSocket;
		o_SPIT_ClientSocket = m_SPIT_ClientSocket;
		if (o_SPIT_ClientSocket == null) return 0;
		else return o_SPIT_ClientSocket.getServerPort();
	}
	/**
	 * Returns the ID of the SPIT server to which the client is connected
	 * @return ID if connected to the server or empty String if not connected
	 */
	public String getServerID() {
		return m_ServerID;
	}
	@Override
	public String getServerComputerName() {
		return m_ServerComputerName;
	}
	@Override
	public void setServerProjectName(String p_ServerProjectName) {
		if (p_ServerProjectName == null) p_ServerProjectName = "";
		m_ServerProjectName = p_ServerProjectName;
	}
	@Override
	public String getServerProjectName() {
		return m_ServerProjectName;
	}
	@Override
	public String getClientComputerName() {
		return m_ClientComputerName;
	}
	
	public void setName(String p_ClientName) {
		if (p_ClientName == null) p_ClientName = getClass().getSimpleName();
		m_Name = p_ClientName;
	}
	/**
	 * Retuns the name of this SPIT_Client
	 * @return name
	 */
	@Override
	public String getName() {
		return m_Name;
	}
	
	/**
	 * Returns the name of the SPIT server to which the client is connected
	 * @return name if connected to the server or empty String if not connected
	 */
	@Override
	public String getServerName() {
		return m_ServerName;
	}
	
	
	/**
	 * Returns the step time in ms of the SPIT server to which the client is connected
	 * @return step time in ms or -1 if not connected
	 */
	@Override
	public int getServerStepTime() {
		return m_ServerStepTime;
	}
	
	/**
	 * Returns the frames per second of the SPIT server to which the client is connected.<br>
	 * This value is only valid after the server has sent ReportSPITProject.<br>
	 * All temporal specifications are made in frames. This value can be used to convert frames to seconds.
	 * @return step frame time in frames per second
	 */
	@Override
	public int getServerFramesPerSecond() {
		return m_ServerFramesPerSecond;
	}
	
	@Override
	public InetAddress getInetAddress() {
		SPIT_ClientSocket o_SPIT_ClientSocket;
		o_SPIT_ClientSocket = m_SPIT_ClientSocket;
		if (o_SPIT_ClientSocket == null) {
			return null;
		}
		return o_SPIT_ClientSocket.getInetAddress();
	}
	
	/**
	 * Returns the IP-Address of this SPIT_CLient, which has been used for the connection to the server.
	 * @return ip address if connection is ok<br>
	 * an empty string if connection failed
	 */
	@Override
	public String getIPAddress() {
		SPIT_ClientSocket o_SPIT_ClientSocket;
		o_SPIT_ClientSocket = m_SPIT_ClientSocket;
		if (o_SPIT_ClientSocket == null) {
			return "";
		}
		return o_SPIT_ClientSocket.getIPAddress();
	}
	
	
	/**
	 * Returns the port number of this SPIT_CLient, which has been used for the connection to the server.
	 * @return port number if connection is ok<br>
	 * 0 if connection failed
	 */
	@Override
	public int getPort() {
		SPIT_ClientSocket o_Spit_ClientSocket;
		o_Spit_ClientSocket = m_SPIT_ClientSocket;
		if (o_Spit_ClientSocket == null) {
			return 0;
		}
		return o_Spit_ClientSocket.getPort();
	}
	
	/**
	 * Returns the SPIT_ClientSocket instance
	 * @return instance of SPIT_ClientSocket
	 */
	public SPIT_ClientSocket getSPIT_ClientSocket() {
		return m_SPIT_ClientSocket;
	}
	
	
	
	/**
	 * Sets the SPIT_Project Name.<br>
	 * @param p_ProjectName  the name of the loaded/created project
	 * @return <br>
	 * true<br>
	 * if p_SPIT_Project differs from the existibg one,_an attempt has been made to send the ReportSPITProject message to the server
	 */
	@Override
	public void setClientProjectID(String p_ProjectID) {
		SPIT_Message o_SPIT_Message;
		if (p_ProjectID == null) p_ProjectID = "";
		if (m_ProjectID.equals(p_ProjectID)) return;
		m_ProjectID = p_ProjectID;
//		o_SPIT_Message = SPIT_Message.createReportSPITProject(p_ProjectID, m_ProjectName, m_ServerFramesPerSecond);
//		sendSPIT_Message(o_SPIT_Message);
		return;
	}
	@Override
	public String getClientProjectID() {
		return m_ProjectID;
	}
	/**
	 * Sets the SPIT_Project Name.<br>
	 * @param p_ProjectName  the name of the loaded/created project
	 * @return <br>
	 * true<br>
	 * if p_SPIT_Project differs from the existibg one,_an attempt has been made to send the ReportSPITProject message to the server
	 */
	@Override
	public void setClientProjectName(String p_ProjectName) {
		SPIT_Message o_SPIT_Message;
		if (p_ProjectName == null) p_ProjectName = "";
		if (m_ProjectName.equals(p_ProjectName)) return;
		m_ProjectName = p_ProjectName;
		o_SPIT_Message = SPIT_Message.createReportSPITProject(m_ProjectID, p_ProjectName, m_ServerFramesPerSecond);
		sendSPIT_Message(o_SPIT_Message);
		return;
	}
	@Override
	public String getClientProjectName() {
		return m_ProjectName;
	}
	
	
	public byte getMessageNumberSend() {
		return m_MessageNumber_Send;
	}
	@Override
	public void setMessageNumberSend(byte p_MessageNumber) {
		if (p_MessageNumber > 255 || p_MessageNumber < 0) m_MessageNumber_Send = 0;
		else m_MessageNumber_Send = p_MessageNumber;
	}
	public byte getMessageNumberReceived() {
		return m_MessageNumber_Received;
	}
	@Override
	public void setMessageNumberReceived(byte p_MessageNumber) {
		if (p_MessageNumber > 255 || p_MessageNumber < 0) m_MessageNumber_Received = 0;
		else m_MessageNumber_Received = p_MessageNumber;
	}
	
	
	@Override
	public boolean sendSPIT_Message(SPIT_Message p_SPIT_Message) {
		if (p_SPIT_Message == null) return false;
		SPIT_ClientSocket o_Spit_ClientSocket;
		o_Spit_ClientSocket = getSPIT_ClientSocket();
		if (o_Spit_ClientSocket == null) return false;
		synchronized(m_SyncMessageNumber) {
			p_SPIT_Message.getHeader().setClientID(getID());
			p_SPIT_Message.getHeader().setServerID(getServerID());
			p_SPIT_Message.getHeader().setMessageNumber(m_MessageNumber_Send);
			if (m_MessageNumber_Send == 255) m_MessageNumber_Send = 0;
			else m_MessageNumber_Send++;
		}
		return o_Spit_ClientSocket.sendSPIT_Message(p_SPIT_Message);		
	}
	
	
	public static void closeProject_Client(String p_ProjectID) {
		eventCloseProject_Client(p_ProjectID);
	}
	public static void loadedProject_Client(String p_ProjectID, String p_ProjectName) {
		eventLoadedProject_Client(p_ProjectID, p_ProjectName);
	}
	
	//---------------------------------------------------
	//---------- Parsing/Sending SPIT_Messages ----------
	//---------------------------------------------------
	
	/**
	 * Parses and delegates all incoming SPIT_Messages related to this this SPIT_Client.
	 * @param p_SPIT_Message an instance of a SPIT_Message
	 * @return true = message is persed<br>
	 * false = message is not parsed<br>
	 * - p_SPIT_Message == null<br>
	 * - p_SPIT_Message is unknown<br>
	 * - perhaps connection to the SPIT_Server is not established
	 */
	@Override
	public boolean parseSPIT_Message(SPIT_Message p_SPIT_Message) {
		if (p_SPIT_Message == null) return false;
		SPIT_Message.Header o_Header;
		SPIT_Message.OPPart o_OPPart;
		o_Header = p_SPIT_Message.getHeader();
		o_OPPart = p_SPIT_Message.getOPPart();
		if (o_Header == null || o_OPPart == null) {
			System.out.println("SPIT_Client parseSPIT_Message Header or OPPart wrong");
			return false;
		}
		
		setMessageNumberReceived(o_Header.getMessageNumber());
		
		
		//--- Connection ---
		if (o_OPPart instanceof SPIT_Message.ConnectAnswer) {
			return parseConnectionAnswer((SPIT_Message.ConnectAnswer)o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.Disconnect) {
			return parseDisconnect((SPIT_Message.Disconnect)o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.Watchdog) {
			return parseWatchdog((SPIT_Message.Watchdog) o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.WatchdogAnswer) {
			return parseWatchdogAnswer((SPIT_Message.WatchdogAnswer)o_OPPart);
		}
		
		//--- Project ----
		else if (o_OPPart instanceof SPIT_Message.ReportSPITProject) {
			return parseReportSPITProject_Server((SPIT_Message.ReportSPITProject)o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.CloseSPITProject) {
			return parseCloseSPITProject((SPIT_Message.CloseSPITProject)o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.RequestProjectTransfer) {
			return parseRequestProjectTransfer((SPIT_Message.RequestProjectTransfer)o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.StartProjectTransfer) {
			return parseStartProjectTransfer((SPIT_Message.StartProjectTransfer)o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.EndProjectTransfer) {
			return parseEndProjectTransfer((SPIT_Message.EndProjectTransfer)o_OPPart);
		}
		
		//--- SPIT_Type ---
		else if (o_OPPart instanceof SPIT_Message.ReportSPITType) {
			return parseReportSPITType((SPIT_Message.ReportSPITType)o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.RemoveSPITType) {
			return parseRemoveSPITType((SPIT_Message.RemoveSPITType)o_OPPart);
		}
		//--- SPIT_Object ---
		else if (o_OPPart instanceof SPIT_Message.ReportSPITObject) {
			return parseReportSPITObject((SPIT_Message.ReportSPITObject)o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.RemoveSPITObject) {
			return parseRemoveSPITObject((SPIT_Message.RemoveSPITObject)o_OPPart);
		}
		//--- Play Object ---
		else if (o_OPPart instanceof SPIT_Message.PlaySPITStart) {
			return parsePlaySPITStart((SPIT_Message.PlaySPITStart)o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.PlaySPITObject) {
			return parsePlaySPITObject((SPIT_Message.PlaySPITObject)o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.PlaySPITEnd) {
			return parsePlaySPITEnd((SPIT_Message.PlaySPITEnd)o_OPPart);
		}
		else if (o_OPPart instanceof SPIT_Message.ReportPlayStatus) {
			return parseReportPlayStatus((SPIT_Message.ReportPlayStatus)o_OPPart);
		}
		
		return false;
	}
	
	/**
	 * Sends a SPIT_Message to the SPIT_Server
	 * @param p_SPIT_Message 
	 * @return true = the message is sent to the SPIT_Server<br>
	 * false = the message could NOT be sent to the SPIT_Server<br>
	 * - no connection to the SPIT_Server is established<br>
	 * - p_SPIT_Message == null
	 * @see SPIT_ClientSocket#sendSPIT_Message(SPITLibraryPackage.SPIT_Message) 
	 */
	public static boolean sendMessage(SPIT_Message p_SPIT_Message) {
		if (p_SPIT_Message == null) return false;
		SPIT_Client o_SPIT_Client;
		o_SPIT_Client = SPIT_Client.s_SelfReference;
		if (o_SPIT_Client == null) return false;
		return o_SPIT_Client.sendSPIT_Message(p_SPIT_Message);
	}
	
	//------------- Connection --------------
	public boolean parseConnectionAnswer(SPIT_Message.ConnectAnswer p_ConnectAnswer) {
		if (p_ConnectAnswer == null) return false;
		if (p_ConnectAnswer.getConnected() == false) {
			//Server denied login
			m_Connected = false;
			disconnect(false);
			return false;
		}
		SPIT_Message o_SPIT_Message;
		SPIT_Message.Header o_Header;
		o_Header = p_ConnectAnswer.getHeader();
		m_ServerID = o_Header.getServerID();
		m_ServerComputerName = p_ConnectAnswer.getServerComputerName();
		m_ServerName = p_ConnectAnswer.getServerName();
		m_ServerStepTime = p_ConnectAnswer.getStepTime();
		m_Connected = true;
	
		startWatchdog();
		notifyConnected();
		
		
		return true;
	}
	public boolean parseDisconnect(SPIT_Message.Disconnect p_Disconnect) {
		if (p_Disconnect == null) return false;
		disconnect(false);
		SPIT_Type.unconfirmeAll();
		SPIT_Object.unconfirmeAll();
		return true;
	}
	
	public boolean parseWatchdog(SPIT_Message.Watchdog p_Watchdog) {
		if (p_Watchdog == null) return false;
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createWatchdogAnswer();
		sendSPIT_Message(o_SPIT_Message);
		return true;
	}
	
	public boolean parseWatchdogAnswer(SPIT_Message.WatchdogAnswer p_WatchdogAnswer) {
		if (p_WatchdogAnswer == null) return false;
		m_SPIT_Watchdog.eventWatchdogAnswer();
		return true;
	}
	
	@Override
	public void startWatchdog() {
		if (m_SPIT_Watchdog != null) {
			m_SPIT_Watchdog.startWatchdog();
		}
	}
	@Override
	public void stopWatchdog() {
		if (m_SPIT_Watchdog != null) {
			m_SPIT_Watchdog.stopWatchdog();
		}
	}
	/**
	 * Is called by the SPIT_Watchdog, if no answer is given in an appropriate time.
	 * @see SPIT_Watchdog#WATCHDOG_TIME
	 */
	@Override
	public void watchdogMissed() {
		disconnect(true);
	}
	
	
	
	//---------- Project ---------
	
	public boolean parseReportSPITProject_Server(SPIT_Message.ReportSPITProject p_ReportSPITProject) {
		if (p_ReportSPITProject == null) return false;
		SPIT_Message o_SPIT_Message;
		m_ServerProjectID = p_ReportSPITProject.getProjectID();
		m_ServerProjectName = p_ReportSPITProject.getProjectName();
		m_ServerFramesPerSecond = p_ReportSPITProject.getFramesPerSecond();
		SPIT_TypeModel.FRAMESPERSECOND = m_ServerFramesPerSecond;
		SPIT_ObjectModel.FRAMESPERSECOND = m_ServerFramesPerSecond;
		SPIT_Type.parseReportSPITProject();
		SPIT_Object.parseReportSPITProject();
		notifyServerProject();
		//1.) send RequestProjectTransfer
		o_SPIT_Message = SPIT_Message.createRequestProjectTransfer();
		sendSPIT_Message(o_SPIT_Message);
		//2.) send ReportSPITProject
		o_SPIT_Message = SPIT_Message.createReportSPITProject(m_ProjectName, m_ProjectName, m_ServerFramesPerSecond);
		sendSPIT_Message(o_SPIT_Message);
		return true;
	}
	public boolean parseCloseSPITProject(SPIT_Message.CloseSPITProject p_CloseSPITProject) {
		if (p_CloseSPITProject == null) return false;
		SPIT_Object.parseCloseSPITProject_Server();
		SPIT_Type.parseCloseSPITProject_Server();
		m_ServerProjectID = "";
		m_ServerProjectName = "";
//		m_ServerFramesPerSecond = 1000;
		//The ActionPlayer will be created when the server sends Play-Sequence
		//--> remove all ActionPlayer
		SPIT_ActionPlayer.clearSPIT_ActionPlayers();
		notifyServerProject_Closed();		
		return true;
	}


	private boolean parseRequestProjectTransfer(SPIT_Message.RequestProjectTransfer p_RequestProjectTransfer) {
		if (p_RequestProjectTransfer == null) return false;
		SPIT_Message o_SPIT_Message;
		
		// 1) Send StartProjectTransfer
		o_SPIT_Message = SPIT_Message.createStartProjectTransfer();
		sendSPIT_Message(o_SPIT_Message);
		
		// 2) Send SPIT_Types
		int intCount;
		SPIT_Type_Interface o_SPIT_Type_Interface;
		intCount = SPIT_Type.getSPIT_TypeCount();
		for (int intType = 0; intType < intCount; intType++) {
			o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(intType);
			if (o_SPIT_Type_Interface == null) continue;
			o_SPIT_Message = SPIT_Message.createReportSPITType(o_SPIT_Type_Interface);
			sendSPIT_Message(o_SPIT_Message);
			sleepSend();
		}
		// 3) Send SPIT_Objects
		SPIT_Object_Interface o_SPIT_Object_Interface;
		intCount = SPIT_Object.getSPIT_ObjectCount();
		for (int intObject = 0; intObject < intCount; intObject++) {
			o_SPIT_Object_Interface = SPIT_Object.getSPIT_Object(intObject);
			o_SPIT_Message = SPIT_Message.createReportSPITObject(o_SPIT_Object_Interface);
			sendSPIT_Message(o_SPIT_Message);
			sleepSend();
		}
				
		// 4) Send EndProjectTransfer
		o_SPIT_Message = SPIT_Message.createEndProjectTransfer();
		sendSPIT_Message(o_SPIT_Message);
				
		return true;
	}
	
	/**
	 * Let the current Thread sleep a while (5 ms) To give the receiver the possibility to process the received messages..<br>
	 * Sending a lot of udp messages very fast will fill the sending buffer of the datagramsocket.<br>
	 * This must be called by the sending thread if many udp packets are sent.<br>
	 */
	public void sleepSend() {
		try {
			Thread.sleep(5);
		}
		catch (Exception e) {
			
		}
	}
	
	private boolean parseStartProjectTransfer(SPIT_Message.StartProjectTransfer p_StartProjectTransfer) {
		if (p_StartProjectTransfer == null) return false;
		m_TransferringProject = true;
		notifyServerProject_TransferStart();
		return true;
	}
	private boolean parseEndProjectTransfer(SPIT_Message.EndProjectTransfer p_EndProjectTransfer) {
		if (p_EndProjectTransfer == null) return false;
		m_TransferringProject = false;
		notifyServerProject_TransferEnd();
		SPITRemote.clearUnconfirmed();
		return true;
	}

	//------------ SPIT_Type -------------
	
	private boolean parseReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType) {
		if (p_ReportSPITType == null) return false;
		return SPIT_Type.parseReportSPITType(p_ReportSPITType, this, m_TransferringProject);
	}	
	private boolean parseRemoveSPITType(SPIT_Message.RemoveSPITType p_RemoveSPITType) {
		if (p_RemoveSPITType == null) return false;
		return SPIT_Type.parseRemoveSPITType(p_RemoveSPITType, null);
	}
	
	//------------ SPIT_Object -------------
	public boolean parseReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
		if (p_ReportSPITObject == null) return false;
		return SPIT_Object.parseReportSPITObject(p_ReportSPITObject, this, m_TransferringProject);
	}	
	

	public boolean parseRemoveSPITObject(SPIT_Message.RemoveSPITObject p_RemoveSPITObject) {
		if (p_RemoveSPITObject == null) return false;
		return SPIT_Object.parseSPITObject_Removed(p_RemoveSPITObject, this);
		
	}
	
	public static void eventCloseProject_Client(String p_ProjectID) {
		SPIT_Message o_SPIT_Message;
		//notify the SPIT_Types and SPIT_Objects 
		SPITRemote.parseCloseSPITProject_Client();
		SPIT_Object.parseCloseSPITProject_Client();
		SPIT_Type.parseCloseSPITProject_Client();
		o_SPIT_Message = SPIT_Message.createCloseSPITProject(p_ProjectID);
		SPIT_Client.sendMessage(o_SPIT_Message);
	}
	
	public static void eventLoadedProject_Client(String p_ProjectID, String p_ProjectName) {
		SPIT_Client.s_SelfReference.setClientProjectID(p_ProjectID);
		SPIT_Client.s_SelfReference.setClientProjectName(p_ProjectName);
		SPIT_Message o_SPIT_Message;
		//notify the SPIT_Types and SPIT_Objects 
		o_SPIT_Message = SPIT_Message.createReportSPITProject(p_ProjectID, p_ProjectName, 0);
		SPIT_Client.sendMessage(o_SPIT_Message);
		o_SPIT_Message = SPIT_Message.createRequestProjectTransfer();
		SPIT_Client.sendMessage(o_SPIT_Message);
	}
	
	
	//------------------------------------------------
	//---------- Editing the play sequences ----------
	//------------------------------------------------
	
	public boolean parsePlaySPITStart(SPIT_Message.PlaySPITStart p_PlaySPITStart) {
		if (p_PlaySPITStart == null) return false;
		SPIT_ActionPlayer o_SPIT_ActionPlayer;
		o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer(p_PlaySPITStart.getPlayerID());
		if (o_SPIT_ActionPlayer == null) {
			o_SPIT_ActionPlayer = new SPIT_ActionPlayer(p_PlaySPITStart.getPlayerID(), p_PlaySPITStart.getPlayerName(), p_PlaySPITStart.getPlayerType());
			SPIT_ActionPlayer.addSPIT_ActionPlayer(o_SPIT_ActionPlayer);
		}
		o_SPIT_ActionPlayer.startPlayTransfer(this, p_PlaySPITStart.getPlayerIsRunning(), p_PlaySPITStart.getTime());
		return true;
	}
	public boolean parsePlaySPITObject(SPIT_Message.PlaySPITObject p_PlaySPITObject) {
		if (p_PlaySPITObject == null) return false;
		SPIT_ActionPlayer o_SPIT_ActionPlayer;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer(p_PlaySPITObject.getPlayerID());
		if (o_SPIT_ActionPlayer == null) return false;
		o_SPIT_Object_Interface = SPIT_Object.getSPIT_Object(p_PlaySPITObject.getID());
		o_SPIT_ActionPlayer.playObjectTransfer(this, o_SPIT_Object_Interface, 
				p_PlaySPITObject.getPlayPrePosition(), p_PlaySPITObject.getFrameInsideObject(), 
				p_PlaySPITObject.getValue(), p_PlaySPITObject.getValueFlag());
		return true;
	}
	
	public boolean parsePlaySPITEnd(SPIT_Message.PlaySPITEnd p_PlaySPITEnd) {
		if (p_PlaySPITEnd == null) return false;

		SPIT_ActionPlayer o_SPIT_ActionPlayer;
		o_SPIT_ActionPlayer = SPIT_ActionPlayer.getSPIT_ActionPlayer(p_PlaySPITEnd.getPlayerID());
		if (o_SPIT_ActionPlayer == null) return false;
		o_SPIT_ActionPlayer.endPlayTransfer(this);
		
		return true;
	}
	
	public boolean parseReportPlayStatus(SPIT_Message.ReportPlayStatus p_ReportPlayStatus) {
		if (p_ReportPlayStatus == null) return false;
		return SPIT_Object.parseReportPlayStatus(p_ReportPlayStatus);
	}
	
	
	/**
	 * Java InetAddress.getHostAddress() can return IP addresses with leading "/".<br>
	 * @param p_IPAddress
	 * @return returns cleared ip address
	 */
	public static String cleanIPAddress(String p_IPAddress) {
		if (p_IPAddress == null) return null;
		if (p_IPAddress.length() <= 0) return p_IPAddress;
		String stringCleanIPAddress;
		
		stringCleanIPAddress = p_IPAddress;
		try {
			while(stringCleanIPAddress.startsWith("/")) {
				stringCleanIPAddress = stringCleanIPAddress.substring(1);
			}
		}
		catch (Exception e) {
		}
		
		try {
			while(stringCleanIPAddress.endsWith("/")) {
				stringCleanIPAddress = stringCleanIPAddress.substring(0, stringCleanIPAddress.length()-1);
			}
		}
		catch(Exception e) {
		}
		return stringCleanIPAddress;
	}
	
	
	//-------------------------------
	//---------- Listeners ----------
	//-------------------------------

	public void addSPITClientListener(SPIT_ClientListener p_SPITClientListener) {
		if (p_SPITClientListener == null) return;
		synchronized(m_SyncListener) {
			if (m_SPITClientListeners.contains(p_SPITClientListener)) return;
			m_SPITClientListeners.add(p_SPITClientListener);
		}
	}
	public void removeSPITClientListener(SPIT_ClientListener p_SPITClientListener) {
		if (p_SPITClientListener == null) return;
		synchronized(m_SyncListener) {
			m_SPITClientListeners.remove(p_SPITClientListener);
		}
	}
	
	public void notifyConnected() {
		ArrayList<SPIT_ClientListener> o_SPITClientListeners;
		SPIT_ClientListener o_SPITClientListener;
		synchronized(m_SyncListener) {
			o_SPITClientListeners = new ArrayList<>(m_SPITClientListeners.size());
			o_SPITClientListeners.addAll(m_SPITClientListeners);
		}
		for (int intListener = 0; intListener < o_SPITClientListeners.size(); intListener++) {
			o_SPITClientListener = o_SPITClientListeners.get(intListener);
			o_SPITClientListener.eventConnected(this);
		}
	}
	public void notifyDisconnected(boolean p_ConnectionLost) {
		ArrayList<SPIT_ClientListener> o_SPITClientListeners;
		SPIT_ClientListener o_SPITClientListener;
		synchronized(m_SyncListener) {
			o_SPITClientListeners = new ArrayList<>(m_SPITClientListeners.size());
			o_SPITClientListeners.addAll(m_SPITClientListeners);
		}
		for (int intListener = 0; intListener < o_SPITClientListeners.size(); intListener++) {
			o_SPITClientListener = o_SPITClientListeners.get(intListener);
			o_SPITClientListener.eventDisconnected(this, p_ConnectionLost);
		}
	}
	
	public void notifyServerProject() {
		ArrayList<SPIT_ClientListener> o_SPITClientListeners;
		SPIT_ClientListener o_SPITClientListener;
		synchronized(m_SyncListener) {
			o_SPITClientListeners = new ArrayList<>(m_SPITClientListeners.size());
			o_SPITClientListeners.addAll(m_SPITClientListeners);
		}
		for (int intListener = 0; intListener < o_SPITClientListeners.size(); intListener++) {
			o_SPITClientListener = o_SPITClientListeners.get(intListener);
			o_SPITClientListener.eventServer_SPITProject(this);
		}
		
	}
	public void notifyServerProject_Closed() {
		ArrayList<SPIT_ClientListener> o_SPITClientListeners;
		SPIT_ClientListener o_SPITClientListener;
		synchronized(m_SyncListener) {
			o_SPITClientListeners = new ArrayList<>(m_SPITClientListeners.size());
			o_SPITClientListeners.addAll(m_SPITClientListeners);
		}
		for (int intListener = 0; intListener < o_SPITClientListeners.size(); intListener++) {
			o_SPITClientListener = o_SPITClientListeners.get(intListener);
			o_SPITClientListener.eventServer_SPITProject_Closed(this);
		}
		
	}
	public void notifyServerProject_TransferStart() {
		ArrayList<SPIT_ClientListener> o_SPITClientListeners;
		SPIT_ClientListener o_SPITClientListener;
		synchronized(m_SyncListener) {
			o_SPITClientListeners = new ArrayList<>(m_SPITClientListeners.size());
			o_SPITClientListeners.addAll(m_SPITClientListeners);
		}
		for (int intListener = 0; intListener < o_SPITClientListeners.size(); intListener++) {
			o_SPITClientListener = o_SPITClientListeners.get(intListener);
			o_SPITClientListener.eventServer_SPITProject_TransferStart(this);
		}		
	}
	public void notifyServerProject_TransferEnd() {
		ArrayList<SPIT_ClientListener> o_SPITClientListeners;
		SPIT_ClientListener o_SPITClientListener;
		synchronized(m_SyncListener) {
			o_SPITClientListeners = new ArrayList<>(m_SPITClientListeners.size());
			o_SPITClientListeners.addAll(m_SPITClientListeners);
		}
		for (int intListener = 0; intListener < o_SPITClientListeners.size(); intListener++) {
			o_SPITClientListener = o_SPITClientListeners.get(intListener);
			o_SPITClientListener.eventServer_SPITProject_TransferStart(this);
		}		
	}
	

	@Override
	public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
		
	}
	@Override
	public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
		
	}
	
}
