/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITServerAutoDetectPackage;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.UUID;

/**
 *
 * @author Hagi
 */
public class ServerAutoDetect_Server {
	public static boolean						DEBUGON = true;
	
	
	public static String									s_ComputerName;
	public static ArrayList<ServerAutoDetect_Server>		s_ServerAutoDetect_Servers = new ArrayList<ServerAutoDetect_Server>();
	public static final Object								s_SyncServerAutoDetectServers = new Object();
	public static InetAddress								s_MulticastGroup_IP4;
	public static InetAddress								s_MulticastGroup_IP6;
	
	
	/**
	 * Starts the AutoDetection.<br>
	 * For every kind of server (described by the p_ServerTask) an extra autodetection will be started.<br>
	 * @param p_ServerID the unique id of the server.<br>
	 * Two servers's either running on the same computer or on different computers must not have the same ID.<br>
	 * If p_ServerID == null -> a unique ID will be created automatically.<br>
	 * This can be used by the client to identify the server.<br>
	 * For every ServerID an extra ServerAutoDetect instance will start.
	 * @param p_ServerTaskID a flag/description of the what the server does.<br>
	 * This will be used to decide which kind of server is searched for.<br>
	 * @param p_LocalPortConnected the port number the server is bind to.
	 */
	public static void startServerAutoDetect(String p_ServerID, String p_ServerTaskID, String p_ServerTaskName, 
			int p_LocalPortConnected, String p_ServerAdditon) {
		if (p_ServerTaskID == null) {
			p_ServerTaskID = "";
		}
		try {
			s_ComputerName = InetAddress.getLocalHost().getHostName();
		}
		catch (Exception e) {
			s_ComputerName = "";
		}
/*		if (s_MulticastGroup_IP4 == null) {
			try {
				s_MulticastGroup_IP4 = InetAddress.getByName(ServerAutoDetect.MULTICASTGROUPNAME_IP4);
			}
			catch (Exception e) {
				s_MulticastGroup_IP4 = null;
			}
		}
*/
		if (s_MulticastGroup_IP6 == null) {
			try {
				s_MulticastGroup_IP6 = InetAddress.getByName(ServerAutoDetect.MULTICASTGROUPNAME_IP6);
			}
			catch (Exception e) {
				s_MulticastGroup_IP6 = null;
			}
		}
		ServerAutoDetect_Server o_ServerAutoDetect_Server;
		synchronized(s_SyncServerAutoDetectServers) {
			o_ServerAutoDetect_Server = getServerAutoDetect_Server(p_ServerID);
			if (o_ServerAutoDetect_Server == null) {
				o_ServerAutoDetect_Server = new ServerAutoDetect_Server(p_ServerID, p_ServerTaskID, p_ServerTaskName, p_LocalPortConnected, p_ServerAdditon);
				s_ServerAutoDetect_Servers.add(o_ServerAutoDetect_Server);
			}
		}
		o_ServerAutoDetect_Server.startDetection();
	}
	
	public static ServerAutoDetect_Server getServerAutoDetect_Server(String p_ServerID) {
		if (p_ServerID == null) return null;
		ServerAutoDetect_Server o_ServerAutoDetect_Server;
		synchronized(s_SyncServerAutoDetectServers) {
			for (int intServer = 0; intServer < s_ServerAutoDetect_Servers.size(); intServer++) {
				o_ServerAutoDetect_Server = s_ServerAutoDetect_Servers.get(intServer);
				if (p_ServerID.equals(o_ServerAutoDetect_Server.getServerID())) {
					return o_ServerAutoDetect_Server;
				}
			}
		}
		return null;
	}
	/**
	 * Stops the ServerAutoDetect for 
	 * @param p_ServerTaskID 
	 */
	public static void stopServerAutoDetect(String p_ServerID) {
		ServerAutoDetect_Server o_ServerAutoDetect_Server = null;
		
		synchronized(s_SyncServerAutoDetectServers) {
			try {
			o_ServerAutoDetect_Server = getServerAutoDetect_Server(p_ServerID);
			if (o_ServerAutoDetect_Server != null) {
					s_ServerAutoDetect_Servers.remove(o_ServerAutoDetect_Server);
			}
			}
			catch (Exception e) {
e.printStackTrace();
			}
		}
		if (o_ServerAutoDetect_Server != null) {
			o_ServerAutoDetect_Server.stopDetection();
		}
	}

	
	
	
	private String					m_ServerID;
	private String					m_ServerTaskID;
	private String					m_ServerTaskName;
	private int						m_LocalPortConnected;
	private String					m_ServerAddition;
	
//	private Runnable				m_RunnableMulticast_IP4;
	private Runnable				m_RunnableMulticast_IP6;
//	private Thread					m_MulticastThread_IP4;
	private Thread					m_MulticastThread_IP6;
//	private MulticastSocket			m_MulticastSocket_IP4;
//	private DatagramSocket			m_MulticastSocket_IP4;
	private MulticastSocket			m_MulticastSocket_IP6;
//	public static boolean			m_IsMulticastRunning_IP4;
	public static boolean			m_IsMulticastRunning_IP6;
	private boolean					m_StopAutoDetect;
	
	/**
	 * Starts the AutoDetection.<br>
	 * @param p_ServerID the unique id of the server.<br>
	 * Two servers's either running on the same computer or on different computers must not have the same ID.<br>
	 * If p_ServerID == null -> a unique ID will be created automatically 
	 * This can be used by the client to identify the server.<br>
	 * @param p_ServerTaskID a flag/description of the waht the server does .<br>
	 * This will be used to decide which kind of server is searched for.<br>
	 * @param p_ServerTaskName the talking description of p_ServerTaskID.<br>
	 * @param p_LocalPortConnected the port number the server is bind to.
	 * @param p_ServerAddition a free usable string maybe null<br>
	 * For example, can be used to distinguish two server instances of the same server name
	 */
	public ServerAutoDetect_Server(String p_ServerID, String p_ServerTaskID, String p_ServerTaskName,
			int p_LocalPortConnected, String p_ServerAddition) {
		if (p_ServerTaskID == null) {
			p_ServerTaskID = "";
		}
		initMembers();
		if (p_ServerID != null) {
			m_ServerID = p_ServerID;
		}
		m_ServerTaskID = p_ServerTaskID;
		m_ServerTaskName = p_ServerTaskName;
		m_LocalPortConnected = p_LocalPortConnected;
		m_ServerAddition = p_ServerAddition;
		if (m_ServerAddition == null) {
			m_ServerAddition = "";
		}
	}
	
	private void initMembers() {
		m_ServerID = UUID.randomUUID().toString();
		m_ServerAddition = "";
//		m_IsMulticastRunning_IP4 = false;
		m_IsMulticastRunning_IP6 = false;
		m_StopAutoDetect = false;
		checkRunnables();
	}
	
	private void checkRunnables() {
		//----- IP4 -----
/*		if (m_RunnableMulticast_IP4 == null) {
			m_RunnableMulticast_IP4 = new Runnable() {
				@Override
				public void run() {
					
					DatagramPacket o_DatagramPacket_Received;
					DatagramPacket o_DatagramPacket_Send;
					byte[] byteArray_Send;
					byte[] byteArray_Received;
					String stringMessage;
					String[] o_StringMessageParts;
					String stringMessageServerJobID;
					StringBuffer stringBufferAnswer;

					if (s_MulticastGroup_IP4 == null) {
						return;
					}
					try {
						//Keep a socket open to listen to all the UDP trafic that is destined for this port
						m_MulticastSocket_IP4 = new MulticastSocket(ServerAutoDetect.PORT);
						m_MulticastSocket_IP4.joinGroup(s_MulticastGroup_IP4);
					}
					catch(Exception e) {
System.out.println(">>> IP4 Error can't join group " + s_MulticastGroup_IP4.getHostAddress() + " : " + ServerAutoDetect.PORT);
						m_IsMulticastRunning_IP4 = false;
						return;
					}
					byteArray_Received = new byte[15000];
					stringBufferAnswer = new StringBuffer();
					
					while (m_StopAutoDetect == false) {
						//Receive a packet
						o_DatagramPacket_Received = new DatagramPacket(byteArray_Received, byteArray_Received.length);
						try {
							m_MulticastSocket_IP4.receive(o_DatagramPacket_Received);
						}
						catch (Exception e) {
System.out.println(">>> IP4 Error can't listen to " + s_MulticastGroup_IP4.getHostAddress() + " : " + ServerAutoDetect.PORT);
							m_MulticastSocket_IP4.close();
							m_IsMulticastRunning_IP4 = false;
							return;
						}
						//Packet received
						//See if the packet holds the right command (message)
						stringMessage = new String(o_DatagramPacket_Received.getData(), ServerAutoDetect.CHARSET).trim();

						if (stringMessage.startsWith(ServerAutoDetect.PRECODE) == false) {
								//Precode is wrong -> continue
								continue;
						}
							o_StringMessageParts = stringMessage.split(ServerAutoDetect.SEPERATOR);
							if (o_StringMessageParts.length < 2) {
								continue;
							}
							stringMessageServerJobID = o_StringMessageParts[1];
							if (m_ServerJobID.equals(stringMessageServerJobID) == false) {
								//the ServerJobID is wrong check if the LiveDBClient asks for all servers
								if (ServerAutoDetect.SEARCHALL_JOBID.equals(stringMessageServerJobID) == false) {
									continue;
								}
							}
						
							stringBufferAnswer.delete(0, stringBufferAnswer.length());
							stringBufferAnswer.append(ServerAutoDetect.PRECODE);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(m_ServerJobID);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(m_MulticastTempID);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(s_ComputerName);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(m_LocalPortConnected);
							byteArray_Send = stringBufferAnswer.toString().getBytes(ServerAutoDetect.CHARSET);
							//Send a response
							o_DatagramPacket_Send = new DatagramPacket(byteArray_Send, byteArray_Send.length, o_DatagramPacket_Received.getAddress(), o_DatagramPacket_Received.getPort());
							try {
								m_MulticastSocket_IP4.send(o_DatagramPacket_Send);
							}
							catch (Exception e) {
System.out.println(">>> IP4 ERROR: multicast server cannot send to client: " + o_DatagramPacket_Received.getAddress() + " : " + o_DatagramPacket_Received.getPort());
									
							}
					} //end while
					try {
						m_MulticastSocket_IP4.leaveGroup(s_MulticastGroup_IP4);
						m_MulticastSocket_IP4.close();
						m_IsMulticastRunning_IP4 = false;
					}
					catch (Exception e_Disconnect) {
					}	
				}
			};
		}	
*/		

/*
		if (m_RunnableMulticast_IP4 == null) {
			m_RunnableMulticast_IP4 = new Runnable() {
				@Override
				public void run() {
					//Use BROADCAST for IP4
					DatagramPacket o_DatagramPacket_Received;
					DatagramPacket o_DatagramPacket_Send;
					byte[] byteArray_Send;
					byte[] byteArray_Received;
					String stringMessage;
					String[] o_StringMessageParts;
					String stringMessageServerTaskID;
					StringBuffer stringBufferAnswer;

					try {
						//Keep a socket open to listen to all the UDP trafic that is destined for this port
						m_MulticastSocket_IP4 = new MulticastSocket(ServerAutoDetect.PORT_IP4);
						m_MulticastSocket_IP4.setSoTimeout(1000);
						m_MulticastSocket_IP4.setReuseAddress(true);
						m_MulticastSocket_IP4.setBroadcast(true);
					}
					catch(Exception e) {
						if (DEBUGON) {
							System.out.println(getClass().getName() + " IP4 Error can't create BroadcastSocket: " + e.getMessage());
						}
						m_IsMulticastRunning_IP4 = false;
						return;
					}
					byteArray_Received = new byte[ServerAutoDetect.BYTEBUFFERSIZE];
					stringBufferAnswer = new StringBuffer();
					
					while (m_StopAutoDetect == false) {
						//Receive a packet
						o_DatagramPacket_Received = new DatagramPacket(byteArray_Received, byteArray_Received.length);
						try {
							m_MulticastSocket_IP4.receive(o_DatagramPacket_Received);
						}
						catch (Exception e) {
							if (e instanceof SocketTimeoutException) {
								if (m_StopAutoDetect == false) {
									continue;
								}
							}
							else {
								if (DEBUGON) {
									System.out.println(getClass().getName() + " IP4 Error can't listen to " + m_MulticastSocket_IP4.getInetAddress() + " : " + ServerAutoDetect.PORT_IP4 + " : " + e.getMessage());
								}
							}
							m_StopAutoDetect = true;
							continue;
						}
						if (m_StopAutoDetect == true) {
							continue;
						}
						//Packet received
						//See if the packet holds the right command (message)
						try {
							stringMessage = new String(o_DatagramPacket_Received.getData(), o_DatagramPacket_Received.getOffset(), o_DatagramPacket_Received.getLength(), ServerAutoDetect.CHARSET).trim();
						}
						catch(Exception e) {
							continue;
						}

						if (stringMessage.startsWith(ServerAutoDetect.PRECODE) == false) {
								//Precode is wrong -> continue
								continue;
						}
							o_StringMessageParts = stringMessage.split(ServerAutoDetect.SEPERATOR);
							if (o_StringMessageParts.length < 2) {
								continue;
							}
							stringMessageServerTaskID = o_StringMessageParts[1];
							if (m_ServerTaskID.equals(stringMessageServerTaskID) == false) {
								//the ServerTaskID is wrong check if the LiveDBClient asks for all servers
								if (ServerAutoDetect.SEARCH_ALL_SERVERS.equals(stringMessageServerTaskID) == false) {
									continue;
								}
							}
						
							stringBufferAnswer.delete(0, stringBufferAnswer.length());
							stringBufferAnswer.append(ServerAutoDetect.PRECODE);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(m_ServerTaskID);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(m_ServerID);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(s_ComputerName);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(m_LocalPortConnected);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(o_DatagramPacket_Received.getAddress()); //ClientIP
							//send the addition if not null
							if (m_ServerAddition != null) {
								stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
								stringBufferAnswer.append(m_ServerAddition);
							}
							byteArray_Send = stringBufferAnswer.toString().getBytes(ServerAutoDetect.CHARSET);
							//Send a response
							o_DatagramPacket_Send = new DatagramPacket(byteArray_Send, byteArray_Send.length, o_DatagramPacket_Received.getAddress(), o_DatagramPacket_Received.getPort());
							try {
								m_MulticastSocket_IP4.send(o_DatagramPacket_Send);
							}
							catch (Exception e) {
								if (DEBUGON) {
									System.out.println(getClass().getName() + " IP4 ERROR: multicast server cannot send to client: " + o_DatagramPacket_Received.getAddress() + " : " + o_DatagramPacket_Received.getPort() + " : " + e.getMessage());
								}
									
							}
					} //end while
					try {
//						m_MulticastSocket_IP4.leaveGroup(s_MulticastGroup_IP4);
						if (m_MulticastSocket_IP4.isClosed() == false) {
							m_MulticastSocket_IP4.close();
						}
						m_IsMulticastRunning_IP4 = false;
					}
					catch (Exception e_Disconnect) {
					}	
				}
			};
		}	
*/		
		//----- IP6 -----
		if (m_RunnableMulticast_IP6 == null) {
			m_RunnableMulticast_IP6 = new Runnable() {
				@Override
				public void run() {
					
					DatagramPacket o_DatagramPacket_Received;
					DatagramPacket o_DatagramPacket_Send;
					byte[] byteArray_Send;
					byte[] byteArray_Received;
					String stringMessage;
					String stringClientIP;
					String[] o_StringMessageParts;
					String stringMessageServerTaskID;
					StringBuffer stringBufferAnswer;

					if (s_MulticastGroup_IP6 == null) {
						return;
					}
					try {
						//Keep a socket open to listen to all the UDP traffic that is destined for this port
						m_MulticastSocket_IP6 = new MulticastSocket(ServerAutoDetect.PORT_IP6);
						m_MulticastSocket_IP6.setSoTimeout(1000);
						m_MulticastSocket_IP6.setReuseAddress(true);
						m_MulticastSocket_IP6.joinGroup(s_MulticastGroup_IP6);
					}
					catch(Exception e) {
						if (DEBUGON) {
							System.out.println(getClass().getName() + " IP6 Error can't join group " + s_MulticastGroup_IP6.getHostAddress() + " : " + ServerAutoDetect.PORT_IP6 + " : " + e.getMessage());
						}
						m_IsMulticastRunning_IP6 = false;
						return;
					}
					
					byteArray_Received = new byte[15000];
					stringBufferAnswer = new StringBuffer();
					
					while (m_StopAutoDetect == false) {
						//Receive a packet
						o_DatagramPacket_Received = new DatagramPacket(byteArray_Received, byteArray_Received.length);
						try {
							m_MulticastSocket_IP6.receive(o_DatagramPacket_Received);
						}
						catch (Exception e) {
							if (e instanceof SocketTimeoutException) {
								if (m_StopAutoDetect == false) {
									continue;
								}
							}
							else {
								if (DEBUGON) {
									System.out.println(getClass().getName() + " IP6 Error can't listen to " + s_MulticastGroup_IP6.getHostAddress() + " : " + ServerAutoDetect.PORT_IP6 + " : " + e.getMessage());
								}
							}
							try {
								m_MulticastSocket_IP6.leaveGroup(s_MulticastGroup_IP6);
								if (m_MulticastSocket_IP6.isClosed() == false) {
									m_MulticastSocket_IP6.close();
								}
							}
							catch(Exception e_Close) {
								
							}
							m_IsMulticastRunning_IP6 = false;
							return;
						}
						//Packet received
						//See if the packet holds the right command (message)
						try {
							stringMessage = new String(o_DatagramPacket_Received.getData(), o_DatagramPacket_Received.getOffset(), o_DatagramPacket_Received.getLength(), ServerAutoDetect.CHARSET).trim();
						}
						catch(Exception e) {
							continue;
						}
						if (stringMessage.startsWith(ServerAutoDetect.PRECODE) == false) {
								//Precode is wrong -> continue
								continue;
						}
							o_StringMessageParts = stringMessage.split(ServerAutoDetect.SEPERATOR);
							if (o_StringMessageParts.length < 2) {
								continue;
							}
							stringMessageServerTaskID = o_StringMessageParts[1];
							if (m_ServerTaskID.equals(stringMessageServerTaskID) == false) {
								//the ServerTaskID is wrong check if the LiveDBClient asks for all servers
								if (ServerAutoDetect.SEARCH_ALL_SERVERS.equals(stringMessageServerTaskID) == false) {
									continue;
								}
							}
						
							stringBufferAnswer.delete(0, stringBufferAnswer.length());
							stringBufferAnswer.append(ServerAutoDetect.PRECODE);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(m_ServerTaskID);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(m_ServerTaskName);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(m_ServerID);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(s_ComputerName);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(m_LocalPortConnected);
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							InetAddress o_InetAddress;
							o_InetAddress = o_DatagramPacket_Received.getAddress();
							stringClientIP = ServerAutoDetect.cleanIPAddress(o_InetAddress.toString());
							stringBufferAnswer.append(stringClientIP); //ClientIP
							//send the addition
							if (m_ServerAddition == null) {
								m_ServerAddition = "";
							}
							stringBufferAnswer.append(ServerAutoDetect.SEPERATOR);
							stringBufferAnswer.append(m_ServerAddition);
							//Send ProjectID
							
							byteArray_Send = stringBufferAnswer.toString().getBytes(ServerAutoDetect.CHARSET);
							//Send a response
							o_DatagramPacket_Send = new DatagramPacket(byteArray_Send, byteArray_Send.length, o_DatagramPacket_Received.getAddress(), o_DatagramPacket_Received.getPort());
							try {
								m_MulticastSocket_IP6.send(o_DatagramPacket_Send);
							}
							catch (Exception e) {
								if (DEBUGON) {
									System.out.println(getClass().getName() + " IP6 ERROR: multicast server cannot send to client: " + o_DatagramPacket_Received.getAddress() + " : " + o_DatagramPacket_Received.getPort() + " : " + e.getMessage());
								}
									
							}
					} //end while
					try {
						m_MulticastSocket_IP6.leaveGroup(s_MulticastGroup_IP6);
						if (m_MulticastSocket_IP6.isClosed() == false) {
							m_MulticastSocket_IP6.close();
						}
						m_IsMulticastRunning_IP6 = false;
					}
					catch (Exception e_Disconnect) {
					}	
				}
			};
		}	
	}
	
	public void startDetection() {
		m_StopAutoDetect = false;
		
/*		if (m_IsMulticastRunning_IP4 == false) {
			m_IsMulticastRunning_IP4 = true;
			m_MulticastThread_IP4 = new Thread(m_RunnableMulticast_IP4, ServerAutoDetect_Server.class.getName());		
			m_MulticastThread_IP4.start();
		}
*/
		if (m_IsMulticastRunning_IP6 == false) {
			m_IsMulticastRunning_IP6 = true;
			m_MulticastThread_IP6 = new Thread(m_RunnableMulticast_IP6, ServerAutoDetect_Server.class.getName());
			m_MulticastThread_IP6.start();
		}
	}
	
	public void stopDetection() {
		m_StopAutoDetect = true;
	}
	
	
	
	public String getServerTaskID() {
		return m_ServerTaskID;
	}
	public String getServerID() {
		return m_ServerID;
	}
	
	public String getServerName;
}
