/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITServerAutoDetectPackage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;

/**
 *
 * @author Hagi
 */
public class ServerAutoDetect {
	
	public static final String					SEARCH_ALL_SERVERS = "*"; //Wildcard, if the client doesn't define the server task id
	
	public static final String					PRECODE = "#SAD#";
	public static final String					SEPERATOR = "#,#";
	
	public static final int						PORT_IP4 = 15110;
	public static final int						PORT_IP6 = 15110;
//	public static String						BROADCAST_IP4 = "255.255.255.255";
//	public static String						MULTICASTGROUPNAME_IP4 = "239.255.255.250";
	public static String						MULTICASTGROUPNAME_IP6 = "ff02::1";
	
	public static Charset						CHARSET = Charset.forName("ISO-8859-15");
	
	public static int							BYTEBUFFERSIZE = 15000;
	
	
	
	public static String cleanIPAddress(String p_IPAddress) {
		if (p_IPAddress == null) return null;
		if (p_IPAddress.length() <= 0) return p_IPAddress;
		String stringCleanIPAddress;
		
		stringCleanIPAddress = p_IPAddress;
		try {
			while(stringCleanIPAddress.startsWith("/")) {
				stringCleanIPAddress = stringCleanIPAddress.substring(1);
			}
		}
		catch (Exception e) {
		}
		
		try {
			while(stringCleanIPAddress.endsWith("/")) {
				stringCleanIPAddress = stringCleanIPAddress.substring(0, stringCleanIPAddress.length()-1);
			}
		}
		catch(Exception e) {
		}
		return stringCleanIPAddress;
	}
	
	public static class DetectedServer {
		private String							m_ServerID;
		private String							m_ServerTaskID;
		private String							m_ServerTaskName;
		private String							m_ComputerName;
		private ArrayList<InetAddress>			m_InetAddresses;
		private ArrayList<InetAddress>			m_DetectedInetAddresses;
		private int								m_Port;
		private String							m_ClientIP;
		private String							m_ServerAddition;
		
		private final Object					m_SyncInetAddresses = new Object();
		
		private boolean							m_Changed;
		private boolean							m_IsNew;
		

		/**
		 * 
		 * @param p_ServerID the ID of the server, maybe set by ServerAUtoDetect_Server
		 * @param p_ServerTaskID a textual flag/description of the server's jobs/the task of the server
		 * @param p_ComputerName the Cpmoutername of the server
		 * @param p_ServerPort the port of the server (NOT the multicast port)
		 * @param p_ClientIP the ip of the client
		 * @param p_ServerAddition a free usable string maybe null<br>
		 * For example, can be used to distinguish two server instances of the same server name
		 * @see ServerAutoDetect_Server#ServerAutoDetect_Server(java.lang.String, java.lang.String, int, java.lang.String) 
		 */
		public DetectedServer(String p_ServerID, String p_ServerTaskID, String p_ServerTaskName, 
				String p_ComputerName, int p_ServerPort, String p_ClientIP, String p_ServerAddition) {
			initMembers();
			m_ServerID = p_ServerID;
			m_ServerTaskID = p_ServerTaskID;
			m_ServerTaskName = p_ServerTaskName;
			m_ComputerName = p_ComputerName;
			m_Port = p_ServerPort;
			m_ClientIP = cleanIPAddress(p_ClientIP);
			m_ServerAddition = p_ServerAddition;
			
		}
		private void initMembers() {
			m_IsNew = true;
			m_Changed = false;
			m_InetAddresses = new ArrayList<InetAddress>(4);
			m_DetectedInetAddresses = new ArrayList<InetAddress>(4);
		}
		/**
		 * The Multicast zyclus will start
		 */
		public void multicastZyclusStart() {
			synchronized(m_SyncInetAddresses) {
				m_IsNew = false;
				m_InetAddresses.clear();
			}
			
		}
		/**
		 * The multicast zyclus ends.<br>
		 * In the meantime addInetAddress maybe called several times,
		 * we can determine with the help of the added/removed inetaddresses the servers status.<br>
		 * Therefor we have two lists:<br>
		 * a) m_DetectedInetAddresses the actual status<br>
		 * b) m_InetAddresses will be cleared every multicastzyclus start and changed by addInetAddress(..)<br>
		 */
		public void multicastZyclusEnd() {
			synchronized(m_SyncInetAddresses) {
				m_Changed = false;
				if (m_IsNew == true) {
					m_DetectedInetAddresses.clear();
					m_DetectedInetAddresses.addAll(m_InetAddresses);
					return;
				} 
				else if (m_DetectedInetAddresses.size() != m_InetAddresses.size()) {
					m_Changed = true;
					m_DetectedInetAddresses.clear();
					if (m_InetAddresses.size() > 0) {
						m_DetectedInetAddresses.addAll(m_InetAddresses);
						return;
					}
					return;
				}
				else if (m_InetAddresses.size() <= 0) {
					m_Changed = true;
					//Server was not found in one multicastZyclus
					m_DetectedInetAddresses.clear();
					return;
				}
				//InetAddress size is equal, but the InetAddresses could have been changed
					InetAddress o_DetectedInetAddress;
					InetAddress o_InetAddress;
					boolean boolFound;
					//check if InetAddresses changed
					for (int intDetectedInetAddress = 0; intDetectedInetAddress < m_DetectedInetAddresses.size(); intDetectedInetAddress++) {
						o_DetectedInetAddress = m_DetectedInetAddresses.get(intDetectedInetAddress);
						boolFound = false;
						for (int intInetAddress = 0; intInetAddress < m_InetAddresses.size(); intInetAddress++) {
							o_InetAddress = m_InetAddresses.get(intInetAddress);
							if (o_InetAddress.getHostAddress().equals(o_DetectedInetAddress.getHostAddress())) {
								boolFound = true;
								break;
							}
						}
						if (boolFound == false) {
							m_Changed = true;
							break;
						}
					}
					if (m_Changed) {
						m_DetectedInetAddresses.clear();
						m_DetectedInetAddresses.addAll(m_InetAddresses);
					}
			}
			
		}
		
		/**
		 * Adds a detected InetAddress of the server.<br>
		 * A server can own a loopbackaddress a ip4 or ip6 address for every networkinterface.<br>
		 * @param p_InetAddress 
		 */
		public void addInetAddress(InetAddress p_InetAddress) {
			if (p_InetAddress == null) return;
			InetAddress o_InetAddress;
			synchronized(m_SyncInetAddresses) {
				//add sorted, we prefere loopback first then IP4 addresses and IP6 addresses last
				for (int intAddress = 0; intAddress < m_InetAddresses.size(); intAddress++) {
					o_InetAddress = m_InetAddresses.get(intAddress);
					if (o_InetAddress.getHostAddress().equals(p_InetAddress.getHostAddress())) {
						//Address exists
						return;
					}
					if (p_InetAddress.isLoopbackAddress()) {
						m_InetAddresses.add(0, p_InetAddress);
						return;
					}
					if (p_InetAddress instanceof Inet4Address) {
						if (o_InetAddress instanceof Inet6Address) {
							m_InetAddresses.add(intAddress, p_InetAddress);
							return;
						}
					}
					else {
						continue;	
					}
				}
				m_InetAddresses.add(p_InetAddress);
			}
		}
		
		/**
		 * returns if the DetectedServer is newly detected
		 * @return true = the DetcetdServer has just been added.<br>
		 * false = the DetectedServer is an old one.
		 */
		public boolean isNew() {
			return m_IsNew;
		}
		
		/**
		 * Retuns if the DetectedServer has been detected inside the multicastzyclus.
		 * @return true = the DetectedServer has been detected inside the zyclus<br>
		 * fasle = the DetectedServer was not found inside the zyclus -> has been removed/DIsconnected/closed. 
		 */
		public boolean IsDetected() {
			synchronized(m_SyncInetAddresses) {
				if (m_DetectedInetAddresses.size() > 0) return true;
			}
			return false;
		}
		
		/**
		 * Retuns if the DetectedServer's list of InetAddresses has been changed.<br>
		 * @return true = the inetaddresses has been changed
		 */
		public boolean isChanged() {
			synchronized (m_SyncInetAddresses) {
				return m_Changed;
			}
		}

		/**
		 * The ID of the Server, can be used to identify the server.<br>
		 * This may set by ServerAutoDetect_Server startServerAutoDetect.<br>
		 * Or if not a ID has been set automatically by the ServerAutoDetect_Server.
		 * @return ID of the server
		 */
		public String getServerID() {
			return m_ServerID;
		}
		
		/**
		 * Returns the textual flag/description of the server's task.<br>
		 * @return taskid of the servers, used to decide which server has been searched.
		 */
		public String getServerTaskID() {
			return m_ServerTaskID;
		}
		/**
		 * Returns the textual flag/description of the server's task.<br>
		 * @return taskid of the servers, used to decide which server has been searched.
		 */
		public String getServerTaskName() {
			return m_ServerTaskName;
		}
		/**
		 * Returns a free usable string - which has been set by the 
		 * @return a free usable string maybe null<br>
		 * For example, can be used to distinguish two server instances of the same server name.
		 * @see ServerAutoDetect_Server#ServerAutoDetect_Server(java.lang.String, java.lang.String, int, java.lang.String) 
		 */
		public String getServerAddition() {
			return m_ServerAddition;
		}
		
		/**
		 * The Server's computername.
		 * @return 
		 */
		public String getComputerName() {
			return m_ComputerName;
		}
		
		/**
		 * The first InetAddress in the list of found InetAddresses (The addresses the client can reache the server).<br>
		 * The list is sorted (Loopbacks - IP4 -IP6).<br>
		 * Therefore if a loopback address exists this will be retunrd first.
		 * @return first InetAddress
		 */
		public InetAddress getFirstInetAddress() {
			synchronized(m_SyncInetAddresses) {
				if (m_DetectedInetAddresses.size() <=0) return null;
				return m_DetectedInetAddresses.get(0);
			}
		}
		/**
		 * The first IP in the list of found InetAddresses (The addresses the client can reache the server).<br>
		 * The list is sorted (Loopbacks - IP4 -IP6).<br>
		 * Therefore if a loopback address exists this will be returned first.<br>
		 * @return first IP (first InetAddress.getHostAddress())
		 */
		public String getFirstIP() {
			InetAddress o_InetAddress;
			String stringIP = "";
			o_InetAddress = getFirstInetAddress();
			if (o_InetAddress == null) return "";
			stringIP = cleanIPAddress(o_InetAddress.getHostAddress());
			return stringIP;
		}
		
		/**
		 * Returns a copied list of all detected InetAddresses, the client can reache the server.<br>
		 * @return a copied list of all detected INetAddresses
		 */
		public ArrayList<InetAddress> getInetAddresses() {
			ArrayList<InetAddress> o_InetAddresses;
			synchronized(m_SyncInetAddresses) {
				o_InetAddresses = new ArrayList<InetAddress>(m_DetectedInetAddresses.size());
				o_InetAddresses.addAll(m_DetectedInetAddresses);
			}
			return o_InetAddresses;
		}
		
		public boolean containsIP(String p_IP) {
			if (p_IP == null) return false;
			p_IP = p_IP.trim();
			InetAddress o_InetAddress;
			synchronized(m_SyncInetAddresses) {
				for (int intInetAddress = 0; intInetAddress < m_DetectedInetAddresses.size(); intInetAddress++) {
					o_InetAddress = m_DetectedInetAddresses.get(intInetAddress);
					if (o_InetAddress.getHostAddress().contains(p_IP)) {
						return true;
					}
				}
			}
			return false;
		}
		
		/**
		 * The port number of the server.
		 * @return port number of the server
		 */
		public int getPort() {
			return m_Port;
		}
		
		public String getClientIP() {
			return m_ClientIP;
		}
	}
	
	public static interface ServerAutoDetect_Listener {
		public void eventDetectedServer_Added(DetectedServer p_DetectedServer);
		public void eventDetectedServer_Changed(DetectedServer p_DetectedServer);
		public void eventDetectedServer_Removed(DetectedServer p_DetectedServer);
	}
	

	public static class DetectedServer_ListCellRenderer extends DefaultListCellRenderer {
		protected static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
		protected static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
		protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2, true);
		private Dimension			m_PreferredDimension;
		private StringBuffer		m_StringBuffer;
		private boolean				m_ShowServerTaskID;
		private boolean				m_ShowServerTaskName;
		private boolean				m_ShowComputerName;
		private boolean				m_ShowServerIP;
		private boolean				m_ShowServerPort;
		private boolean				m_ShowServerAddition;
		

		public DetectedServer_ListCellRenderer() {
			super();
			initMembers();
		}
		public DetectedServer_ListCellRenderer(boolean p_ShowServerTaskID, boolean p_ShowServerTaskName, 
				boolean p_ShowComputerName,
				boolean p_ShowServerIP, boolean p_ShowServerPort, boolean p_ShowServerAddition) {
			super();
			initMembers();
			m_ShowServerTaskID = p_ShowServerTaskID;
			m_ShowServerTaskName = p_ShowServerTaskName;
			m_ShowComputerName = p_ShowComputerName;
			m_ShowServerIP = p_ShowServerIP;
			m_ShowServerPort = p_ShowServerPort;
			m_ShowServerAddition = p_ShowServerAddition;
		}
		private void initMembers() {
			m_PreferredDimension = new Dimension(60, 28);
			m_StringBuffer = new StringBuffer();
			m_ShowServerTaskID = false;
			m_ShowServerTaskName = false;
			m_ShowComputerName = true;
			m_ShowServerIP = false;
			m_ShowServerPort = true;
			m_ShowServerAddition = true;
		}
		@Override
		public Component getListCellRendererComponent(JList list, Object value, int index,
			boolean isSelected, boolean cellHasFocus) {
			setComponentOrientation(list.getComponentOrientation());

			DetectedServer o_DetectedServer;
			Color bg = null;
			Color fg = null;
			JList.DropLocation dropLocation = list.getDropLocation();
			if (dropLocation != null
					&& !dropLocation.isInsert()
					&& dropLocation.getIndex() == index) {
				//bg = DefaultLookup.getColor(this, ui, "List.dropCellBackground");
				//fg = DefaultLookup.getColor(this, ui, "List.dropCellForeground");
				bg = Color.GRAY;
				fg = Color.BLACK;
				isSelected = true;
			}

			if (isSelected) {
//				setBackground(bg == null ? list.getSelectionBackground() : bg);
//				setForeground(fg == null ? list.getSelectionForeground() : fg);
			}
			else {
//				setBackground(list.getBackground());
//				setForeground(list.getForeground());
			}
			setForeground(Color.BLACK);
			setBackground(Color.WHITE);
			if (value == null || !(value instanceof DetectedServer)) {
				setText("...");
			}
			else {
				o_DetectedServer = (DetectedServer)value;
				InetAddress o_InetAddress;
				o_InetAddress = o_DetectedServer.getFirstInetAddress();
				m_StringBuffer.delete(0, m_StringBuffer.length());
				if (m_ShowServerTaskID) {
					m_StringBuffer.append(o_DetectedServer.getServerTaskID());
					m_StringBuffer.append(" ");
				}
				if (m_ShowServerTaskName) {
					m_StringBuffer.append(o_DetectedServer.getServerTaskName());
					m_StringBuffer.append(" ");
				}
				if (m_ShowComputerName) {
					m_StringBuffer.append(o_DetectedServer.getComputerName());
					m_StringBuffer.append(" ");
				}
				if (m_ShowServerIP || m_ShowServerPort) {
					m_StringBuffer.append(" (");
					if (m_ShowServerIP && o_InetAddress != null) {
						m_StringBuffer.append(o_InetAddress.getHostAddress());
						m_StringBuffer.append("  ");
					}
					if (m_ShowServerPort) {
						m_StringBuffer.append(o_DetectedServer.getPort());
					}
					
					m_StringBuffer.append(") ");
				}
				if (m_ShowServerAddition) {
					String stringAddition;
					stringAddition = o_DetectedServer.getServerAddition();
					if (stringAddition != null && stringAddition.length() > 0) {
						m_StringBuffer.append(stringAddition);
						m_StringBuffer.append(" ");
					}
				}
				
				setIcon(null);
				if (m_StringBuffer.length() > 2) {
					m_StringBuffer.delete(m_StringBuffer.length()-1, m_StringBuffer.length());
				}
				setText(m_StringBuffer.toString());

				m_StringBuffer.delete(0, m_StringBuffer.length());
				m_StringBuffer.append("<html>");
				ArrayList<InetAddress> o_InetAddresses;
				o_InetAddresses = o_DetectedServer.getInetAddresses();
				for (int intAddress = 0; intAddress < o_InetAddresses.size(); intAddress++) {
					o_InetAddress = o_InetAddresses.get(intAddress);
					m_StringBuffer.append(o_InetAddress.getHostAddress());
					if (intAddress < o_InetAddresses.size()-1) {
						m_StringBuffer.append("<br>");
					}
				}
				m_StringBuffer.append("</html>");
				setToolTipText(m_StringBuffer.toString());
			}

			setEnabled(list.isEnabled());
			setFont(list.getFont());

			Border border = null;
//			if (cellHasFocus) {
				if (isSelected) {
					border = SELECTED_BORDER;
				}
				if (border == null) border = getNoFocusBorder();
/*				if (isSelected) {
					border = DefaultLookup.getBorder(this, ui, "List.focusSelectedCellHighlightBorder");
				}
				if (border == null) {
					border = DefaultLookup.getBorder(this, ui, "List.focusCellHighlightBorder");
				}
 */
/*			} else {
				border = getNoFocusBorder();
			}
 */
			setBorder(border);
			setPreferredSize(m_PreferredDimension);
			return this;
		}
		private Border getNoFocusBorder() {
			Border border = null;
//			border = DefaultLookup.getBorder(this, ui, "List.cellNoFocusBorder");
			if (System.getSecurityManager() != null) {
				if (border != null) return border;
				return SAFE_NO_FOCUS_BORDER;
			} else {
				if (border != null &&
						(noFocusBorder == null ||
						noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
					return border;
				}
				return noFocusBorder;
			}
		}
	}
	public static class DetectedServer_TableCellRenderer extends DefaultTableCellRenderer {
//		private static Border s_InvalidBorder = new LineBorder(Color.RED);;
		private StringBuffer		m_StringBuffer;
		private boolean				m_ShowServerTaskID;
		private boolean				m_ShowServerTaskName;
		private boolean				m_ShowComputerName;
		private boolean				m_ShowServerIP;
		private boolean				m_ShowServerPort;
		private boolean				m_ShowServerAddition;
		
		
		public DetectedServer_TableCellRenderer() {
			super();
			initMembers();
		}
		public DetectedServer_TableCellRenderer(boolean p_ShowServerTaskID, boolean p_ShowServerTaskName, boolean p_ShowComputerName,
				boolean p_ShowServerIP, boolean p_ShowServerPort, boolean p_ShowServerAddition) {
			super();
			initMembers();
			m_ShowServerTaskID = p_ShowServerTaskID;
			m_ShowServerTaskName = p_ShowServerTaskName;
			m_ShowComputerName = p_ShowComputerName;
			m_ShowServerIP = p_ShowServerIP;
			m_ShowServerPort = p_ShowServerPort;
			p_ShowServerAddition = p_ShowServerAddition;
		}
		private void initMembers() {
			m_StringBuffer = new StringBuffer();
			m_ShowServerTaskID = false;
			m_ShowComputerName = true;
			m_ShowServerIP = false;
			m_ShowServerPort = true;
			m_ShowServerAddition = true;
		}
			
		@Override
		public Component getTableCellRendererComponent(JTable table, Object value,
								  boolean isSelected, boolean hasFocus, int row, int column) {

			Color fg = null;
			Color bg = null;

			if (value == null || !(value instanceof DetectedServer)) {
				setText("...");
			}
			else {
				DetectedServer o_DetectedServer;
				o_DetectedServer = (DetectedServer)value;
				InetAddress o_InetAddress;
				o_InetAddress = o_DetectedServer.getFirstInetAddress();
				m_StringBuffer.delete(0, m_StringBuffer.length());
				if (m_ShowServerTaskID) {
					m_StringBuffer.append(o_DetectedServer.getServerTaskID());
					m_StringBuffer.append(" ");
				}
				if (m_ShowServerTaskName) {
					m_StringBuffer.append(o_DetectedServer.getServerTaskName());
					m_StringBuffer.append(" ");
				}
				if (m_ShowComputerName) {
					m_StringBuffer.append(o_DetectedServer.getComputerName());
					m_StringBuffer.append(" ");
				}
				if (m_ShowServerIP || m_ShowServerPort) {
					m_StringBuffer.append(" (");
					if (m_ShowServerIP && o_InetAddress != null) {
						m_StringBuffer.append(o_InetAddress.getHostAddress());
						m_StringBuffer.append("  ");
					}
					if (m_ShowServerPort) {
						m_StringBuffer.append(o_DetectedServer.getPort());
					}
					
					m_StringBuffer.append(") ");
				}
				if (m_ShowServerAddition) {
					String stringAddition;
					stringAddition = o_DetectedServer.getServerAddition();
					if (stringAddition != null && stringAddition.length() > 0) {
						m_StringBuffer.append(stringAddition);
						m_StringBuffer.append(" ");
					}
				}
				
				
				setIcon(null);
				if (m_StringBuffer.length() > 2) {
					m_StringBuffer.delete(m_StringBuffer.length()-1, m_StringBuffer.length());
				}
				setText(m_StringBuffer.toString());

				m_StringBuffer.delete(0, m_StringBuffer.length());
				m_StringBuffer.append("<html>");
				ArrayList<InetAddress> o_InetAddresses;
				o_InetAddresses = o_DetectedServer.getInetAddresses();
				for (int intAddress = 0; intAddress < o_InetAddresses.size(); intAddress++) {
					o_InetAddress = o_InetAddresses.get(intAddress);
					m_StringBuffer.append(o_InetAddress.getHostAddress());
					if (intAddress < o_InetAddresses.size()-1) {
						m_StringBuffer.append("<br>");
					}
				}
				m_StringBuffer.append("</html>");
				setToolTipText(m_StringBuffer.toString());
			}
				
				JTable.DropLocation dropLocation = table.getDropLocation();
				if (dropLocation != null
						&& !dropLocation.isInsertRow()
						&& !dropLocation.isInsertColumn()
						&& dropLocation.getRow() == row
						&& dropLocation.getColumn() == column) {

//					fg = DefaultLookup.getColor(this, ui, "Table.dropCellForeground");
//					bg = DefaultLookup.getColor(this, ui, "Table.dropCellBackground");
					
					
					isSelected = true;
				}

				if (isSelected) {
					super.setForeground(fg == null ? table.getSelectionForeground()
												   : fg);
					super.setBackground(bg == null ? table.getSelectionBackground()
												   : bg);
				} else {
					Color background = table.getBackground();
					if (background == null || background instanceof javax.swing.plaf.UIResource) {
//						Color alternateColor = DefaultLookup.getColor(this, ui, "Table.alternateRowColor");
						Color alternateColor = null;
//						Color alternateColor = bg.darker();
						if (alternateColor != null && row % 2 == 0)
							background = alternateColor;
					}
					super.setForeground(table.getForeground());
					super.setBackground(background);
				}

				setFont(table.getFont());
					if (hasFocus) {
/*						Border border = null;
						if (isSelected) {
							border = DefaultLookup.getBorder(this, ui, "Table.focusSelectedCellHighlightBorder");
						}
						if (border == null) {
							border = DefaultLookup.getBorder(this, ui, "Table.focusCellHighlightBorder");
						}
						setBorder(border);

						if (!isSelected && table.isCellEditable(row, column)) {
								Color col;
								col = DefaultLookup.getColor(this, ui, "Table.focusCellForeground");
								if (col != null) {
									super.setForeground(col);
								}
								col = DefaultLookup.getColor(this, ui, "Table.focusCellBackground");
								if (col != null) {
									super.setBackground(col);
								}
						}
* 
*/
						setBorder(null);
					} else {
						setBorder(null);
					}
//				setValue(value); 

				return this;
		}
	}
	
}
