/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SwingModelPackage;

import SPITLibraryPackage.SPIT_Type_Interface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

/**
 *
 * @author Hagi
 */
public class SPIT_TypeModel extends AbstractTableModel implements PropertyChangeListener {
		public static final int		COLUMNCOUNT = 4;

		public static final int		COLUMNINDEX_GROUPNAME = 0;
		public static final int		COLUMNINDEX_TYPENAME = 1;
		public static final int		COLUMNINDEX_DELAY = 2;
		public static final int		COLUMNINDEX_DURATION = 3;

		public static String	COLUMN_TYPENAME = "Name";
		public static String	COLUMN_GROUPNAME = "Group";
		public static String	COLUMN_DELAYNAME = "Delay";
		public static String	COLUMN_DURATIONNAME = "Duration";
		
		public static double	FRAMESPERSECOND = 44100;
		
		public static boolean	s_LanguageLoaded = false;

		private ArrayList<SPIT_Type_Interface>	m_SPIT_Types;
		private HashMap<String, SPIT_Type_Interface> m_SPIT_TypesByID;

		private TableRowSorter			m_TableRowSorter;
		private SPITRowFilter			m_SPITRowFilter;

		private final Object			m_SyncObject = new Object();
		
		private SPIT_TypeListModel		m_SPIT_TypeListModel;
		private SPIT_TypeLListRenderer	m_SPIT_TypeListRenderer;
		
		public SPIT_TypeModel() {
			super();
			initMembers();
/*			if (s_LanguageLoaded == false) {
				LiveLanguage.loadLanguageStrings(this);
				s_LanguageLoaded = true;
			}
			LiveLanguage.addLanguageListener(this, "LiveShow");
*/
		}

		private void initMembers() {
			m_SPIT_Types = new ArrayList<>();
			m_SPIT_TypesByID = new HashMap<>();

			m_TableRowSorter = new TableRowSorter(this);
			m_SPITRowFilter = new SPITRowFilter(this);
			
			m_SPIT_TypeListModel = new SPIT_TypeListModel();
			m_SPIT_TypeListRenderer = new SPIT_TypeLListRenderer();
		}

		public void finishJTable(JTable p_JTable) {
			if (p_JTable == null) return;
			p_JTable.setRowSorter(m_TableRowSorter);
			fireTableStructureChanged();
			
			m_TableRowSorter.setComparator(COLUMNINDEX_TYPENAME, new StringComparator_Normal());
			m_TableRowSorter.setComparator(COLUMNINDEX_GROUPNAME, new StringComparator_Normal());
			m_TableRowSorter.setComparator(COLUMNINDEX_DELAY, new StringComparator_Time());
			m_TableRowSorter.setComparator(COLUMNINDEX_DURATION, new StringComparator_Time());
			m_TableRowSorter.setRowFilter(m_SPITRowFilter);
		}

		public void clear() {
			int intLastRow;
			synchronized(m_SyncObject) {
				intLastRow = m_SPIT_Types.size()-1;
				m_SPIT_Types.clear();
				m_SPIT_TypesByID.clear();
				m_SPIT_TypeListModel.clear();
			}
			if (intLastRow >= 0) {
				fireTableRowsDeleted(0, intLastRow);
			}
		}
/*		@Override
		public String languageGetFileNameBasis() {
			return "Languages/LiveShow";		
		}

		@Override
		public ArrayList<LiveLanguageObject> languageGetAdditionalObjects() {
			return null;
		}

		@Override
		public void languageAdditionalObjectLoaded(LiveLanguageObject p_LanguageObject) {
		}

		@Override
		public void languageApplyComponentOrientation(ComponentOrientation p_Orientation) {
		}
*/		
		
		public SPIT_TypeListModel getSPIT_TypeListModel() {
			return m_SPIT_TypeListModel;
		}
		public SPIT_TypeLListRenderer getSPIT_TypeLListRenderer() {
			return m_SPIT_TypeListRenderer;
		}
		
		public static class StringComparator_Normal implements Comparator<String> {
			@Override
			public int compare(String o1, String o2) {
				if (o1 == null || o2 == null) return 0;
				return (o1.compareToIgnoreCase(o2));
			}
		}

		public static class StringComparator_NumericInteger implements Comparator<String> {
			@Override
			public int compare(String o1, String o2) {
				if (o1 == null || o2 == null) return 0;
				Integer int1;
				Integer int2;
				try {
					int1 = Integer.valueOf(o1);
					int2 = Integer.valueOf(o2);
				}
				catch(Exception e) {
					return 0;
				}
				return int1.compareTo(int2);
			}
		}
		public static class StringComparator_Time implements Comparator<String> {
			@Override
			public int compare(String o1, String o2) {
				if (o1 == null || o2 == null) return 0;
				Long milli1;
				Long milli2;
				try {
					milli1 = SPIT_TimeTools.getMillisecondsFromString(o1);
					milli2 = SPIT_TimeTools.getMillisecondsFromString(o2);
				}
				catch(Exception e) {
					return 0;
				}
				return milli1.compareTo(milli2);
			}
		}

		public void filter(String p_FilterString) {
			if (m_SPITRowFilter == null) return;
			m_SPITRowFilter.setFilterString(p_FilterString);
		} 


		public boolean contains(SPIT_Type_Interface p_SPIT_Type_Interface) {
			if (p_SPIT_Type_Interface == null) return false;
			return contains(p_SPIT_Type_Interface.getID());
		}
		public boolean contains(String p_ID) {
			if (p_ID == null) return false;
			SPIT_Type_Interface o_SPIT_Type_Interface;
			synchronized(m_SyncObject) {
				o_SPIT_Type_Interface = getSPIT_Type(p_ID);
			}
			if (o_SPIT_Type_Interface == null) return false;
			else return true;
		}
		
		public SPIT_Type_Interface getSPIT_Type(String p_ID) {
			SPIT_Type_Interface o_SPIT_Type_Interface;
			synchronized(m_SyncObject) {
				o_SPIT_Type_Interface = m_SPIT_TypesByID.get(p_ID);
			}
			return o_SPIT_Type_Interface;
		}
		
		public boolean addSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface) {
			if (p_SPIT_Type_Interface == null) return false;
			int intRow;
			synchronized(m_SyncObject) {
				intRow = m_SPIT_Types.indexOf(p_SPIT_Type_Interface);
				if (intRow >= 0) {
					fireTableRowsUpdated(intRow, intRow);
					return false;
				}
				m_SPIT_Types.add(p_SPIT_Type_Interface);
				intRow = m_SPIT_Types.size()-1;
				m_SPIT_TypesByID.put(p_SPIT_Type_Interface.getID(), p_SPIT_Type_Interface);
				
				p_SPIT_Type_Interface.addPropertyChangeListener(this);
				m_SPIT_TypeListModel.addSorted(p_SPIT_Type_Interface);
				p_SPIT_Type_Interface.addPropertyChangeListener(m_SPIT_TypeListModel);
			}
			fireTableRowsInserted(intRow, intRow);
			return true;
		}

		public boolean removeSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface) {
			if (p_SPIT_Type_Interface == null) return false;
			int intIndex;
			synchronized(m_SyncObject) {
				intIndex = m_SPIT_Types.indexOf(p_SPIT_Type_Interface);
				if (intIndex < 0) return false;
				m_SPIT_Types.remove(p_SPIT_Type_Interface);
				m_SPIT_TypesByID.remove(p_SPIT_Type_Interface.getID());
				
				p_SPIT_Type_Interface.removePropertyChangeListener(this);
				m_SPIT_TypeListModel.removeSPITType(p_SPIT_Type_Interface);
				p_SPIT_Type_Interface.removePropertyChangeListener(m_SPIT_TypeListModel);
			}
			fireTableRowsDeleted(intIndex, intIndex);
			return true;
		}

		public int getRowOfSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface) {
			synchronized(m_SyncObject) {
				return m_SPIT_Types.indexOf(p_SPIT_Type_Interface);
			}
		}

		public void addSelectedSPIT_Type(JTable p_JTable, SPIT_Type_Interface p_SPIT_Type_Interface) {
			if (p_JTable == null) return;
			if (p_SPIT_Type_Interface == null) return;
			int intRow;
			synchronized(m_SyncObject) {
				intRow = m_SPIT_Types.indexOf(p_SPIT_Type_Interface);
				if (intRow < 0) return;
				intRow = p_JTable.convertRowIndexToView(intRow);
			}
			p_JTable.setRowSelectionInterval(intRow, intRow);
//			p_JTable.getSelectionModel().addSelectionInterval(intRow, intRow);
//			p_JTable.revalidate();
		}
		public void removeSelectedSPIT_Type(JTable p_JTable, SPIT_Type_Interface p_SPIT_Type_Interface) {
			if (p_JTable == null) return;
			if (p_SPIT_Type_Interface == null) return;
			int intRow;
			synchronized(m_SyncObject) {
				intRow = m_SPIT_Types.indexOf(p_SPIT_Type_Interface);
				if (intRow < 0) return;
				intRow = p_JTable.convertRowIndexToView(intRow);
			}
			p_JTable.removeRowSelectionInterval(intRow, intRow); //getSelectionModel().removeSelectionInterval(intRow, intRow);
		}

		public SPIT_Type_Interface getSPIT_Type(int p_Index) {
			if (p_Index < 0) return null;
			synchronized(m_SyncObject) {
				if (p_Index >= m_SPIT_Types.size()) return null;
				return m_SPIT_Types.get(p_Index);
			}
		}

		public Object[] getSPIT_Types() {
			Object[] o_SPIT_TypeInterfaces;
			synchronized(m_SyncObject) {
				o_SPIT_TypeInterfaces = m_SPIT_Types.toArray();
			}
			return o_SPIT_TypeInterfaces;
		}
		@Override
		public int getRowCount() {
			return m_SPIT_Types.size();
		}

		@Override
		public int getColumnCount() {
			return COLUMNCOUNT;
		}

		public void setColumnName(int p_Column, String p_ColumnName) {
			if (p_ColumnName == null) return;
			if (p_Column < 0 || p_Column >= COLUMNCOUNT) return;
			switch(p_Column) {
				case COLUMNINDEX_GROUPNAME:
					COLUMN_GROUPNAME = p_ColumnName;
					break;
				case COLUMNINDEX_TYPENAME:
					COLUMN_TYPENAME = p_ColumnName;
					break;
				case COLUMNINDEX_DELAY:
					COLUMN_DELAYNAME = p_ColumnName;
					break;
				case COLUMNINDEX_DURATION:
					COLUMN_DURATIONNAME = p_ColumnName;
					break;
			}
			fireTableStructureChanged();
		}
		@Override
		public String getColumnName(int col) {
			switch(col) {
				case COLUMNINDEX_GROUPNAME:
					return COLUMN_GROUPNAME;
				case COLUMNINDEX_TYPENAME:
					return COLUMN_TYPENAME;
				case COLUMNINDEX_DELAY:
					return COLUMN_DELAYNAME;
				case COLUMNINDEX_DURATION:
					return COLUMN_DURATIONNAME;
			}
			return "";
		}

		@Override
		public Object getValueAt(int rowIndex, int columnIndex) {
			String stringValue = "";
			SPIT_Type_Interface o_SPIT_Type_Interface;
			synchronized(m_SyncObject) {
				o_SPIT_Type_Interface = getSPIT_Type(rowIndex);
				if (o_SPIT_Type_Interface == null) return stringValue;
				switch(columnIndex) {
					case COLUMNINDEX_GROUPNAME:
						stringValue = o_SPIT_Type_Interface.getGroupName();
						break;
					case COLUMNINDEX_TYPENAME:
						stringValue = o_SPIT_Type_Interface.getName();
						break;
					case COLUMNINDEX_DELAY:
						stringValue = SPIT_TimeTools.getTimeStringFromFrames(o_SPIT_Type_Interface.getDelay(), FRAMESPERSECOND);
						break;
					case COLUMNINDEX_DURATION:
						stringValue = SPIT_TimeTools.getTimeStringFromFrames(o_SPIT_Type_Interface.getDuration(), FRAMESPERSECOND);
						break;
				}
				return stringValue;
			}
		}
		@Override
		public Class<? extends Object> getColumnClass(int c) {
			Object o_Value = getValueAt(0, c);
			if(o_Value == null) {
				return Object.class;
			}
			return getValueAt(0, c).getClass();
		}
		@Override
		public boolean isCellEditable(int row, int col) {
			switch(col) {
				case COLUMNINDEX_GROUPNAME:
					return true;
				case COLUMNINDEX_TYPENAME:
					return true;
				case COLUMNINDEX_DELAY:
					return true;
				case COLUMNINDEX_DURATION:
					return true;
			}
			return false;
		}

	 /*
		 * Don't need to implement this method unless your table's
		 * data can change.
		 */
		@Override
		public void setValueAt(Object value, int row, int col) {
			SPIT_Type_Interface o_SPIT_Type_Interface;
			String stringValue;
			long longFrames;
			if (!(value instanceof String)) {
				return;
			}
			synchronized(m_SyncObject) {
				if (row < 0 || row >= m_SPIT_Types.size()) return;
				o_SPIT_Type_Interface = m_SPIT_Types.get(row);
				if (o_SPIT_Type_Interface == null) return;
			}
			switch (col) {
				case COLUMNINDEX_GROUPNAME:
					stringValue = (String)value;
					o_SPIT_Type_Interface.setGroupName(stringValue);
					break;
				case COLUMNINDEX_TYPENAME:
					stringValue = (String)value;
					o_SPIT_Type_Interface.setName(stringValue);
					break;
				case COLUMNINDEX_DELAY:
					stringValue = (String)value;
					longFrames = SPIT_TimeTools.getFramesFromTimeString(stringValue, FRAMESPERSECOND);
					o_SPIT_Type_Interface.setDelay(longFrames);
					break;
				case COLUMNINDEX_DURATION:
					stringValue = (String)value;
					longFrames = SPIT_TimeTools.getFramesFromTimeString(stringValue, FRAMESPERSECOND);
					o_SPIT_Type_Interface.setDuration(longFrames);
					break;
			}
			fireTableCellUpdated(row, col);
		}


		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			if (evt.getSource() instanceof SPIT_Type_Interface) {
				int intRow;
				synchronized(m_SyncObject) {
					intRow = m_SPIT_Types.indexOf(evt.getSource());
					if (intRow < 0) return;
				}
				if (SPIT_Type_Interface.PROP_PARAMCHANGED.equals(evt.getPropertyName())) {
					EventQueue.invokeLater(new Runnable() {
						@Override
						public void run() {
							fireTableRowsUpdated(intRow, intRow);
						}
					});
					
				}
				else if (SPIT_Type_Interface.PROP_CONFIRMED.equals(evt.getPropertyName())) {
					EventQueue.invokeLater(new Runnable() {
						@Override
						public void run() {
							fireTableRowsUpdated(intRow, intRow);
						}
					});					
				}
			}
		}

	
	public static class SPITRowFilter extends RowFilter<SPIT_Type_Interface, Integer> {
		private SPIT_TypeModel	m_SPIT_TypeModel;
		private String			m_FilterString;
			
		public SPITRowFilter(SPIT_TypeModel p_SPIT_TypeModel) {
			super();
			initMembers();
			m_SPIT_TypeModel = p_SPIT_TypeModel;
		}
		private void initMembers() {
			m_FilterString = null;
		}
		public void setFilterString(String p_FilterString) {
			if (p_FilterString == null) m_FilterString = "";
			else m_FilterString = p_FilterString.toLowerCase();
			if (m_SPIT_TypeModel != null) {
				m_SPIT_TypeModel.fireTableDataChanged();
			}
		} 
		@Override
		public boolean include(RowFilter.Entry entry) {
			int intRow;
			if (m_SPIT_TypeModel == null) return false;
			SPIT_Type_Interface o_SPIT_Type_Interface;

			intRow = (int)entry.getIdentifier();
			o_SPIT_Type_Interface = m_SPIT_TypeModel.getSPIT_Type(intRow);
			if (o_SPIT_Type_Interface == null) return false;

			if (m_FilterString == null) return true;
			if (m_FilterString.length() <= 0) return true;
			if (o_SPIT_Type_Interface.getGroupName().toLowerCase().contains(m_FilterString)) return true;
			if (o_SPIT_Type_Interface.getName().toLowerCase().contains(m_FilterString)) return true;
			return false;
		}
	}

	

	public static class SPITTypeTableCellRenderer extends JLabel implements TableCellRenderer, Serializable {

	   /**
		* An empty <code>Border</code>. This field might not be used. To change the
		* <code>Border</code> used by this renderer override the
		* <code>getTableCellRendererComponent</code> method and set the border
		* of the returned component directly.
		*/
		private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
		protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;

		// We need a place to store the color the JLabel should be returned
		// to after its foreground and background colors have been set
		// to the selection background color.
		// These ivars will be made protected when their names are finalized.
		private Color m_UnselectedForeground;
		private Color m_UnselectedBackground;
		public static Color	s_NotConfirmedColor = new Color(255, 200, 200);
		public static Color	s_FIXEDColor = new Color(0, 100, 0);

		/**
		 * Creates a default table cell renderer.
		 */
		public SPITTypeTableCellRenderer(int p_FontSize) {
			super();
			super.setFont(new Font(getFont().getFamily(), Font.PLAIN, p_FontSize));
			setOpaque(true);
			setBorder(getNoFocusBorder());
			setName("Table.cellRenderer");
		}

		private Border getNoFocusBorder() {
			return m_NoFocusBorder;
		}

		/**
		 * Overrides <code>JComponent.setForeground</code> to assign
		 * the unselected-foreground color to the specified color.
		 *
		 * @param c set the foreground color to this value
		 */
		@Override
		public void setForeground(Color c) {
			super.setForeground(c);
			m_UnselectedForeground = c;
		}

		/**
		 * Overrides <code>JComponent.setBackground</code> to assign
		 * the unselected-background color to the specified color.
		 *
		 * @param c set the background color to this value
		 */
		@Override
		public void setBackground(Color c) {
			super.setBackground(c);
			m_UnselectedBackground = c;
		}

		/**
		 * Notification from the <code>UIManager</code> that the look and feel
		 * [L&F] has changed.
		 * Replaces the current UI object with the latest version from the
		 * <code>UIManager</code>.
		 *
		 * @see JComponent#updateUI
		 */
		@Override
		public void updateUI() {
			super.updateUI();
			setForeground(null);
			setBackground(null);
		}

		// implements javax.swing.table.TableCellRenderer
		/**
		 *
		 * Returns the default table cell renderer.
		 * <p>
		 * During a printing operation, this method will be called with
		 * <code>isSelected</code> and <code>hasFocus</code> values of
		 * <code>false</code> to prevent selection and focus from appearing
		 * in the printed output. To do other customization based on whether
		 * or not the table is being printed, check the return value from
		 * {@link javax.swing.JComponent#isPaintingForPrint()}.
		 *
		 * @param table  the <code>JTable</code>
		 * @param value  the value to assign to the cell at
		 *			<code>[row, column]</code>
		 * @param isSelected true if cell is selected
		 * @param hasFocus true if cell has focus
		 * @param row  the row of the cell to render
		 * @param column the column of the cell to render
		 * @return the default table cell renderer
		 * @see javax.swing.JComponent#isPaintingForPrint()
		 */
		@Override
		public Component getTableCellRendererComponent(JTable table, Object value,
							  boolean isSelected, boolean hasFocus, int row, int column) {

			Color colorBackground;
			Color colorForeground;
			
			SPIT_TypeModel o_SPITTypeTableModel;
			SPIT_Type_Interface o_SPIT_Type_Interface;
			int intRowModel;
			colorBackground = table.getBackground();
			colorForeground = table.getForeground();
			if (table.getModel() instanceof SPIT_TypeModel) {
				o_SPITTypeTableModel = (SPIT_TypeModel)table.getModel();
				try {
					intRowModel = table.convertRowIndexToModel(row);
					o_SPIT_Type_Interface = o_SPITTypeTableModel.getSPIT_Type(intRowModel);
				}
				catch(Exception e) {
					o_SPIT_Type_Interface = null;
				}
				if (o_SPIT_Type_Interface != null) {
					if (o_SPIT_Type_Interface.getConfirmed() == false) {
						colorBackground = s_NotConfirmedColor;
					}
					if (o_SPIT_Type_Interface.getFixed() == true) {
						colorForeground = s_FIXEDColor;
					}
				}
			}
			
			
			JTable.DropLocation dropLocation = table.getDropLocation();
			if (dropLocation != null
					&& !dropLocation.isInsertRow()
					&& !dropLocation.isInsertColumn()
					&& dropLocation.getRow() == row
					&& dropLocation.getColumn() == column) {


				isSelected = true;
			}

			try {
			if (table.convertColumnIndexToModel(column) == 0) {
				setIcon(null);
			}
			else {
				setIcon(null);
			}
			}
			catch (Exception e) {
				setIcon(null);
			}
			if (isSelected) {
				super.setForeground(table.getSelectionForeground());
				super.setBackground(table.getSelectionBackground());
			} 
			else {
				super.setForeground(colorForeground);
				super.setBackground(colorBackground);
			}

			setFont(super.getFont());

			if (hasFocus) {
				setBorder(m_NoFocusBorder);

				if (!isSelected && table.isCellEditable(row, column)) {
						Color col;
						col = table.getForeground();
						super.setForeground(col);
						col = table.getBackground();
						super.setBackground(col);
				}
			} 
			else {
				setBorder(getNoFocusBorder());
			}

			setText((value == null) ? "" : value.toString());

			return this;
		}

		/*
		 * The following methods are overridden as a performance measure to
		 * to prune code-paths are often called in the case of renders
		 * but which we know are unnecessary.  Great care should be taken
		 * when writing your own renderer to weigh the benefits and
		 * drawbacks of overriding methods like these.
		 */

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
			 * @return 
		 */
		@Override
		public boolean isOpaque() {
		Color back = getBackground();
		Component p = getParent();
		if (p != null) {
			p = p.getParent();
		}

		// p should now be the JTable.
		boolean colorMatch = (back != null) && (p != null) &&
			back.equals(p.getBackground()) &&
				p.isOpaque();
		return !colorMatch && super.isOpaque();
		}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 *
		 * @since 1.5
		 */
		@Override
		public void invalidate() {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void validate() {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void revalidate() {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void repaint(long tm, int x, int y, int width, int height) {}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void repaint(Rectangle r) { }

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 *
		 * @since 1.5
		 */
		@Override
		public void repaint() {
		}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		// Strings get interned...
		if ("text".equals(propertyName)
				|| "labelFor".equals(propertyName)
				|| "displayedMnemonic".equals(propertyName)
				|| (("font".equals(propertyName) || "foreground".equals(propertyName))
					&& oldValue != newValue
					&& getClientProperty(javax.swing.plaf.basic.BasicHTML.propertyKey) != null)) {

				super.firePropertyChange(propertyName, oldValue, newValue);
			}
		}

		/**
		 * Overridden for performance reasons.
		 * See the <a href="#override">Implementation Note</a>
		 * for more information.
		 */
		@Override
		public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) { }




		/**
		 * A subclass of <code>DefaultTableCellRenderer</code> that
		 * implements <code>UIResource</code>.
		 * <code>DefaultTableCellRenderer</code> doesn't implement
		 * <code>UIResource</code>
		 * directly so that applications can safely override the
		 * <code>cellRenderer</code> property with
		 * <code>DefaultTableCellRenderer</code> subclasses.
		 * <p>
		 * <strong>Warning:</strong>
		 * Serialized objects of this class will not be compatible with
		 * future Swing releases. The current serialization support is
		 * appropriate for short term storage or RMI between applications running
		 * the same version of Swing.  As of 1.4, support for long term storage
		 * of all JavaBeans<sup><font size="-2">TM</font></sup>
		 * has been added to the <code>java.beans</code> package.
		 * Please see {@link java.beans.XMLEncoder}.
		 */
		public static class UIResource extends DefaultTableCellRenderer
			implements javax.swing.plaf.UIResource {
		}

	}
	
	public static class SPIT_TypeListModel extends DefaultComboBoxModel<SPIT_Type_Interface> implements PropertyChangeListener { //implements PropertyChangeListener, LiveLanguageListener {
		private final Object	m_SyncObject = new Object();
		public SPIT_TypeListModel() {
			super();
//			super.addElement(null);
		}
		
		public void clear() {
			SPIT_Type_Interface o_SPIT_Type_Interface;
			synchronized(m_SyncObject) {
				for (int intType = super.getSize()-1; intType >= 0; intType--) {
					o_SPIT_Type_Interface = getElementAt(intType);
					removeSPITType(o_SPIT_Type_Interface);
				}
			}
		}
		public void addSPITType(SPIT_Type_Interface p_SPIT_Type_Interface) {
			if (p_SPIT_Type_Interface == null) return;
			int intIndex;
			synchronized(m_SyncObject) {
				intIndex = getIndexOf(p_SPIT_Type_Interface);
				if (intIndex >= 0) return;			
				addSorted(p_SPIT_Type_Interface);
			}
			
		}
		
		public void removeSPITType(SPIT_Type_Interface p_SPIT_Type_Interface) {
			if (p_SPIT_Type_Interface == null) return;
			int intIndex;
			synchronized(m_SyncObject) {
				intIndex = getIndexOf(p_SPIT_Type_Interface);
				if (intIndex < 0) return;
				removeElementAt(intIndex);
			}
			p_SPIT_Type_Interface.removePropertyChangeListener(this);
		}		

		private void addSorted(SPIT_Type_Interface p_SPIT_Type_Interface) {
			if (p_SPIT_Type_Interface == null) return;
			SPIT_Type_Interface o_SPIT_Type_Interface;
			int intType;
			synchronized(m_SyncObject) {
				for (intType = 0; intType < getSize(); intType++) {
					o_SPIT_Type_Interface = getElementAt(intType);
					if (o_SPIT_Type_Interface.getName().compareToIgnoreCase(p_SPIT_Type_Interface.getName()) < 0) continue;
					break;
				}
				super.insertElementAt(p_SPIT_Type_Interface, intType);
			}
			p_SPIT_Type_Interface.addPropertyChangeListener(this);
		}
		
		private void resort(SPIT_Type_Interface p_SPIT_Type_Interface) {
			if (p_SPIT_Type_Interface == null) return;
			int intIndex;
			boolean boolWasSelected = false;
			synchronized(m_SyncObject) {
				intIndex = getIndexOf(p_SPIT_Type_Interface);
				if (intIndex < 0) return;
				if (p_SPIT_Type_Interface == getSelectedItem()) boolWasSelected = true; 
				removeElementAt(intIndex);
			}
			p_SPIT_Type_Interface.removePropertyChangeListener(this);
			addSPITType(p_SPIT_Type_Interface);
			
			if (boolWasSelected) {
				setSelectedItem(p_SPIT_Type_Interface);
			}
		}
		@Override
		public SPIT_Type_Interface getElementAt(int p_Index) {
			synchronized(m_SyncObject) {
				return super.getElementAt(p_Index);
			}
		}
		
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
			if (evt.getSource() instanceof SPIT_Type_Interface) {
				int intIndex;
				synchronized(m_SyncObject) {
					intIndex = getIndexOf(evt.getSource());
					if (intIndex < 0) return;
				}
				
				if (SPIT_Type_Interface.PROP_PARAMCHANGED.equals(evt.getPropertyName())) {
					resort((SPIT_Type_Interface)evt.getSource());
//					fireContentsChanged(this, intIndex, intIndex);
				}
				else if (SPIT_Type_Interface.PROP_CONFIRMED.equals(evt.getPropertyName())) {
					fireContentsChanged(this, intIndex, intIndex);
				}
			}
		}
		
	}


	public static class SPIT_TypeLListRenderer extends DefaultListCellRenderer {
		public static Dimension		s_DimensionIcon = new Dimension(20,20);

		public SPIT_TypeLListRenderer() {
			super();
			initMembers();
		}
		private void initMembers() {
			
		}
		private void initComponents() {
		}
		
		@Override
		public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {			
			SPIT_Type_Interface o_SPIT_Type_Interface;
			if (isSelected) {
				setBackground(list.getSelectionBackground());
				setForeground(list.getSelectionForeground());
			}
	        else {
				setBackground(list.getBackground());
				setForeground(list.getForeground());
			}

			if (value == null || !(value instanceof SPIT_Type_Interface)) {
				setIcon(null);
				setText("");
			}
			else {
				o_SPIT_Type_Interface = (SPIT_Type_Interface)value;
				setIcon(o_SPIT_Type_Interface.getIcon());
				setText(o_SPIT_Type_Interface.getName());
			}
			return this;
		}

	}
	
	
	
}

