/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITRemotePackage;

import SPITActionPackage.SPIT_Action_Interface;
import SPITClientPackage.SPIT_Object;
import SPITClientPackage.SPIT_Type;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_ObjectDescription;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_TypeDescription;
import SwingModelPackage.SPIT_TypeModel;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITServerPackage.SPIT_ServerInterface;
import SwingModelPackage.RemoteSPITObjectTableModel;

/**
 * SPITRemote collects all REMOTE Spit_TypeInterfaces and SPIT_ObjectInterfaces.<br>
 * The SPIT_ObjectInterfaces are an instances of SPIT_Object for the SPIT_Cleint even for the SPITServer.<br>
 * @author Hagi
 */
public class SPITRemote {
	public static SPIT_ServerInterface	s_SPIT_ServerInterface = null;
	
	public static SPIT_TypeModel	s_SPIT_TypeModel = new SPIT_TypeModel();
	
	public static RemoteSPITObjectTableModel	s_RemoteSPITObjectModel = new RemoteSPITObjectTableModel();
	public static RemoteSPITObjectTableModel.RemoteSPITObjectCellRenderer	s_SPITObjectRemoteCellRenderer = new RemoteSPITObjectTableModel.RemoteSPITObjectCellRenderer(14);
	
	
	//-------------------------------------------------------------------
	//----- Functions used by Server AND Client                     -----
	//----- both list the remote SPIT_Types and SPIT_Objects here   -----
	//----- s_SPIT_ServerInterface must be set on the server!!!	    -----
	//----- s_SPIT_ServerInterface must NOT be set on the client!!! -----
	//-------------------------------------------------------------------
	
	public static boolean addRemoteSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return false;
		boolean boolAdded;
		SPIT_Message o_SPIT_Message;
			//Remote SPIT_Types are listet in SPITRemote
			//add the SPIT_Type to the remote table model
		boolAdded =  s_SPIT_TypeModel.addSPIT_Type(p_SPIT_Type_Interface);
		if (boolAdded) {
			SPIT_Type.notifyRemoteSPIT_Type_Added(p_SPIT_Type_Interface);
			if (getSPITClientInterfaceCount() > 0) {
				o_SPIT_Message = SPIT_Message.createReportSPITType(p_SPIT_Type_Interface);
				sendServerSPIT_Message(o_SPIT_Message);
			}
			//SPITRemote will only send the message when s_SPIT_ServerInterface is set 
			//SPITRemote.s_SPIT_ServerInterface is only set on server side
		}
		return boolAdded;
	}
	public static boolean removeRemoteSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return false;
		boolean boolRemoved;
		SPIT_Message o_SPIT_Message;
		String stringID;
		//Remote SPIT_Types are listet in SPITRemote
		boolRemoved = s_SPIT_TypeModel.removeSPIT_Type(p_SPIT_Type_Interface);
		if (boolRemoved) {
			SPIT_Type.notifyRemoteSPIT_Type_Removed(p_SPIT_Type_Interface);
			stringID = p_SPIT_Type_Interface.getID();
			p_SPIT_Type_Interface.close();
			if (getSPITClientInterfaceCount() > 0) {
				o_SPIT_Message = SPIT_Message.createRemoveSPITType(stringID);
				sendServerSPIT_Message(o_SPIT_Message);	
			}
			//SPITRemote will only send the message when s_SPIT_ServerInterface is set 
			//SPITRemote.s_SPIT_ServerInterface is only set on server side
		}
		return boolRemoved;
	}
	public static void unconfirmeAll() {
		int intSPIT_ObjectCount;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		intSPIT_ObjectCount = s_RemoteSPITObjectModel.getRowCount();
		for (int intSPITType = 0; intSPITType < intSPIT_ObjectCount; intSPITType++) {
			o_SPIT_Object_Interface = s_RemoteSPITObjectModel.getSPIT_Object(intSPITType);
			if (o_SPIT_Object_Interface == null) continue;
			o_SPIT_Object_Interface.setConfirmed(false);
		}		

		int intSPIT_TypeCount;
		SPIT_Type_Interface o_SPIT_Type_Interface;
		intSPIT_TypeCount = s_SPIT_TypeModel.getRowCount();
		for (int intSPITType = 0; intSPITType < intSPIT_TypeCount; intSPITType++) {
			o_SPIT_Type_Interface = s_SPIT_TypeModel.getSPIT_Type(intSPITType);
			if (o_SPIT_Type_Interface == null) continue;
			o_SPIT_Type_Interface.setConfirmed(false);
		}
		
	}
	
	public static void clearUnconfirmed() {
		int intSPIT_ObjectCount;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		intSPIT_ObjectCount = s_RemoteSPITObjectModel.getRowCount();
		for (int intSPITObject = intSPIT_ObjectCount-1; intSPITObject >= 0 ; intSPITObject--) {
			o_SPIT_Object_Interface = s_RemoteSPITObjectModel.getSPIT_Object(intSPITObject);
			if (o_SPIT_Object_Interface == null) continue;
			if (o_SPIT_Object_Interface.getConfirmed() == false) {
				removeRemoteSPIT_Object(o_SPIT_Object_Interface);
			}
		}		
		int intSPIT_TypeCount;
		SPIT_Type_Interface o_SPIT_Type_Interface;
		intSPIT_TypeCount = s_SPIT_TypeModel.getRowCount();
		for (int intSPITType = intSPIT_TypeCount-1; intSPITType >= 0 ; intSPITType--) {
			o_SPIT_Type_Interface = s_SPIT_TypeModel.getSPIT_Type(intSPITType);
			if (o_SPIT_Type_Interface == null) continue;
			if (o_SPIT_Type_Interface.getConfirmed() == false) {
				removeRemoteSPIT_Type(o_SPIT_Type_Interface);
			}
		}
		
		
	}
	
	public static boolean parseRemoteSPIT_Type(SPIT_Message.ReportSPITType p_ReportSPITType) {
		if (p_ReportSPITType == null) return false;
		SPIT_Type_Interface o_SPIT_Type_Interface;
		o_SPIT_Type_Interface = getRemoteSPIT_Type(p_ReportSPITType.getID());
		if (o_SPIT_Type_Interface == null) {
			o_SPIT_Type_Interface = new SPIT_Type(p_ReportSPITType);
			return addRemoteSPIT_Type(o_SPIT_Type_Interface);
		}
		else {
			o_SPIT_Type_Interface.readReportSPITType(p_ReportSPITType);
			o_SPIT_Type_Interface.setConfirmed(true);
		}
		return true;		
	}
	
	public static int getRemoteSPIT_TypeCount() {
		return s_SPIT_TypeModel.getRowCount();
	}
	public static SPIT_Type_Interface getRemoteSPIT_Type(String p_ID) {
		return s_SPIT_TypeModel.getSPIT_Type(p_ID);
	}
	public static SPIT_Type_Interface getRemoteSPIT_Type(int p_Index) {
		if (p_Index < 0) return null;
		return s_SPIT_TypeModel.getSPIT_Type(p_Index);
	}

	
	public static boolean addRemoteSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return false;
		SPIT_Type_Interface o_SPIT_Type_Interface;
		boolean boolAdded;
		SPIT_Message o_SPIT_Message;
		//Check if the SPIT_Type exists
		o_SPIT_Type_Interface = getRemoteSPIT_Type(p_SPIT_Object_Interface.getSPITTypeID());
		if (o_SPIT_Type_Interface == null) return false;
	
		boolAdded = s_RemoteSPITObjectModel.addSPIT_Object(p_SPIT_Object_Interface);
		if (boolAdded) {
			//Add p_SPIT_Object_Interface as PropertyChangeListener to o_SPIT_Type_Interface
			o_SPIT_Type_Interface.addPropertyChangeListener(p_SPIT_Object_Interface);
			SPIT_Object.notifyRemoteSPIT_Object_Added(p_SPIT_Object_Interface);
			
			if (getSPITClientInterfaceCount() > 0) {
				newSPITObject(p_SPIT_Object_Interface);
				o_SPIT_Message = SPIT_Message.createReportSPITObject(p_SPIT_Object_Interface);
				sendServerSPIT_Message(o_SPIT_Message);
			}
			//SPITRemote will only send the message when s_SPIT_ServerInterface is set 
			//SPITRemote.s_SPIT_ServerInterface is only set on server side
		}
		return boolAdded;
	}
	/**
	 * This is used only by clients.<br>
	 * When a client project is loaded we need to add the SPIT_Object without notifiying.<br>
	 * 
	 * @param p_SPIT_Object_Interface
	 * @return 
	 */
	public static boolean addRemoteSPIT_Object_ReadExternal(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return false;
		SPIT_Type_Interface o_SPIT_Type_Interface;
		boolean boolAdded;
		SPIT_Message o_SPIT_Message;
		//Check if the SPIT_Type exists
		o_SPIT_Type_Interface = getRemoteSPIT_Type(p_SPIT_Object_Interface.getSPITTypeID());
		if (o_SPIT_Type_Interface == null) return false;
	
		boolAdded = s_RemoteSPITObjectModel.addSPIT_Object(p_SPIT_Object_Interface);
		if (boolAdded) {
			//Add p_SPIT_Object_Interface as PropertyChangeListener to o_SPIT_Type_Interface
			o_SPIT_Type_Interface.addPropertyChangeListener(p_SPIT_Object_Interface);
/*			SPIT_Object.notifyRemoteSPIT_Object_Added(p_SPIT_Object_Interface);
			
			if (getSPITClientInterfaceCount() > 0) {
				o_SPIT_Message = SPIT_Message.createReportSPITObject(p_SPIT_Object_Interface);
				sendServerSPIT_Message(o_SPIT_Message);
			}
			//SPITRemote will only send the message when s_SPIT_ServerInterface is set 
			//SPITRemote.s_SPIT_ServerInterface is only set on server side
*/
		}
		return boolAdded;
	}
		
	public static boolean removeRemoteSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return false;
		SPIT_Message o_SPIT_Message;
		if (s_RemoteSPITObjectModel.removeSPIT_Object(p_SPIT_Object_Interface) == true) {
			SPIT_Object.notifyRemoteSPIT_Object_Removed(p_SPIT_Object_Interface);
			if (getSPITClientInterfaceCount() > 0) {
				o_SPIT_Message = SPIT_Message.createRemoveSPITObject(p_SPIT_Object_Interface.getID());
				sendServerSPIT_Message(o_SPIT_Message);
			}
			//SPITRemote will only send the message when s_SPIT_ServerInterface is set 
			//SPITRemote.s_SPIT_ServerInterface is only set on server side
			p_SPIT_Object_Interface.close();
			return true;
		}
		return false;
	}
	
	
	public static boolean parseRemoteSPIT_Object(SPIT_Message.ReportSPITObject p_ReportSPITObject) {
		if (p_ReportSPITObject == null) return false;
		SPIT_Type_Interface o_SPIT_Type_Interface;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		//Check SPIT_Type
		o_SPIT_Type_Interface = SPITRemote.getRemoteSPIT_Type(p_ReportSPITObject.getSPITTypeID());
		if (o_SPIT_Type_Interface == null) {
			return false;
		}
		o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object(p_ReportSPITObject.getID());
		if (o_SPIT_Object_Interface == null) {
			o_SPIT_Object_Interface = new SPIT_Object();
			o_SPIT_Object_Interface.readReportSPITObject(p_ReportSPITObject);
			o_SPIT_Object_Interface.setConfirmed(true);
			return addRemoteSPIT_Object(o_SPIT_Object_Interface);
		}
		else {
			o_SPIT_Object_Interface.setConfirmed(true);
			o_SPIT_Object_Interface.readReportSPITObject(p_ReportSPITObject);
			return true;
		}		
	}
	
	public static int getRemoteSPIT_ObjectCount() {
		return s_RemoteSPITObjectModel.getRowCount();
	}
	public static SPIT_Object_Interface getRemoteSPIT_Object(String p_ID) {
		return s_RemoteSPITObjectModel.getSPIT_Object(p_ID);
	}
	public static SPIT_Object_Interface getRemoteSPIT_Object(int p_Index) {
		if (p_Index < 0) return null;
		return s_RemoteSPITObjectModel.getSPIT_Object(p_Index);
	}
	
	public static SPIT_Object_Interface getRemoteSPIT_ObjectByActionInterface(SPIT_Action_Interface p_SPIT_Action_Interface) {
		if (p_SPIT_Action_Interface == null) return null;
		int intSPIT_ObjectCount;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		intSPIT_ObjectCount = s_RemoteSPITObjectModel.getRowCount();
		for (int intObject = 0; intObject < intSPIT_ObjectCount; intObject++) {
			o_SPIT_Object_Interface = s_RemoteSPITObjectModel.getSPIT_Object(intObject);
			if (o_SPIT_Object_Interface == null) continue;
			if (o_SPIT_Object_Interface.getSPIT_Action_Interface() == p_SPIT_Action_Interface) {
				return o_SPIT_Object_Interface;
			}
		}
		return null;
	}
	public static SPIT_Object_Interface getRemoteSPIT_ObjectByActionObject(Object p_SPIT_Action_Object) {
		if (p_SPIT_Action_Object == null) return null;
		int intSPIT_ObjectCount;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		intSPIT_ObjectCount = s_RemoteSPITObjectModel.getRowCount();
		for (int intObject = 0; intObject < intSPIT_ObjectCount; intObject++) {
			o_SPIT_Object_Interface = s_RemoteSPITObjectModel.getSPIT_Object(intObject);
			if (o_SPIT_Object_Interface == null) continue;
			if (o_SPIT_Object_Interface.getSPIT_Action_Object() == p_SPIT_Action_Object) {
				return o_SPIT_Object_Interface;
			}
		}
		return null;
	}
	
	//----------------------------------------
	//----- functions used by the server -----
	//----------------------------------------

	/**
	 * At the server, the SPIT_ServerInterface must be set. <br>
	 * The SPIT_SerevrInterface implements a function to send SPIT_Messages to all connected clients.
	 * @param p_SPIT_ServerInterface 
	 */
	public static void setSPIT_ServerInterface(SPIT_ServerInterface p_SPIT_ServerInterface) {
		s_SPIT_ServerInterface = p_SPIT_ServerInterface;
	}
	
	public static int getSPITClientInterfaceCount() {
		if (s_SPIT_ServerInterface == null) return 0;
		return s_SPIT_ServerInterface.getSPIT_ClientInterfaceCount();
	}
	/**
	 * Can be used by the server to create a remote SPIT_Type.<br>
	 * The 'Fixed' member of the SPIT_Type is always set to true.<br>
	 * The 'Confirmed' member of the SPIT_Type is always set to true<br>
	 * 
	 * @param p_ID the ID must be unique for every SPIT_Type.<br>
	 * if p_ID == null, a random ID is used, this is not recommended<br>
	 * The clients require fixed IDs for their assignment of the remote buttons / functions.  
	 * @param p_GroupName free name to structure the SPIT_Types
	 * @param p_Name name of the SPIT_Type
	 * @param p_ProjectIndepended true = if the SPIT_Type (next scene, main sound volume, ..) is independed of the server's project.<br>
	 * false = the SPIT_type descibes an action which is depneded of the server's project (concrete scene, ..)
	 * @return 
	 */
	public static SPIT_Type_Interface createServerRemoteSPIT_Type(String p_ID, String p_GroupName, String p_Name, boolean p_ProjectIndepended) {
		SPIT_TypeDescription o_SPIT_TypeDescription;
		SPIT_Type o_SPIT_Type;
		o_SPIT_TypeDescription = new SPIT_TypeDescription();
		o_SPIT_TypeDescription.setServerRemote(true);
		o_SPIT_TypeDescription.setFixed(true);
		o_SPIT_TypeDescription.setServerProjectIndepended(p_ProjectIndepended);
		o_SPIT_TypeDescription.setDelay(0);
		o_SPIT_TypeDescription.setDuration(0);
		o_SPIT_TypeDescription.setID(p_ID);
		o_SPIT_TypeDescription.setGroupName(p_GroupName);
		o_SPIT_TypeDescription.setName(p_Name);
		o_SPIT_Type = new SPIT_Type(o_SPIT_TypeDescription);
		o_SPIT_Type.setConfirmed(true);
		return o_SPIT_Type;
	}
	public static SPIT_Object_Interface createServerRemoteSPIT_Object(SPIT_Type_Interface p_SPIT_Type_Interface, String p_ObjectID, String p_ObjectName, byte p_ValueUse) {
		if (p_SPIT_Type_Interface == null) return null;
		SPIT_ObjectDescription o_SPIT_ObjectDescription;
		SPIT_Object o_SPIT_Object;
		o_SPIT_ObjectDescription = new SPIT_ObjectDescription();
		o_SPIT_ObjectDescription.setServerRemote(true);
		o_SPIT_ObjectDescription.setFixed(true);
		o_SPIT_ObjectDescription.setValueUse(p_ValueUse);
		o_SPIT_ObjectDescription.setDelay(0);
		o_SPIT_ObjectDescription.setDuration(0);
		if (p_ObjectID == null) {
			o_SPIT_ObjectDescription.setID(p_SPIT_Type_Interface.getID());
		}
		else {
			o_SPIT_ObjectDescription.setID(p_ObjectID);
		}
		o_SPIT_ObjectDescription.setSPITTypeID(p_SPIT_Type_Interface.getID());
		if (p_ObjectName == null) {
			o_SPIT_ObjectDescription.setName(p_SPIT_Type_Interface.getName());
		}
		else {
			o_SPIT_ObjectDescription.setName(p_ObjectName);
		}
		o_SPIT_Object = new SPIT_Object(o_SPIT_ObjectDescription);
		o_SPIT_Object.setConfirmed(true);
		return o_SPIT_Object;
	}

	public static void parseCloseSPITProject_Server() {
		SPIT_Type_Interface o_SPIT_Type_Interface;
		for (int intType = s_SPIT_TypeModel.getRowCount()-1; intType >= 0; intType--) {
			o_SPIT_Type_Interface = s_SPIT_TypeModel.getSPIT_Type(intType);
			if (o_SPIT_Type_Interface == null) continue;
			//remove all project depended remote SPIT Types
			if (o_SPIT_Type_Interface.getServerProjectIndepended() == false) {
				removeRemoteSPIT_Type(o_SPIT_Type_Interface);
				o_SPIT_Type_Interface.close();
			}
		}
	}
	public static void newSPITObject(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		SPIT_ServerInterface o_SPIT_ServerInterface;
		SPIT_Message o_SPIT_Message;
		o_SPIT_ServerInterface = s_SPIT_ServerInterface;
		if (s_SPIT_ServerInterface == null) return;
		if (s_SPIT_ServerInterface.sendedReportProject() == false) return;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(p_SPIT_Object_Interface);
		sendServerSPIT_Message(o_SPIT_Message);
	}
	public static void changedSPITObject(SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_Object_Interface == null) return;
		SPIT_Message o_SPIT_Message;
		SPIT_ServerInterface o_SPIT_ServerInterface;
		o_SPIT_ServerInterface = s_SPIT_ServerInterface;
		if (s_SPIT_ServerInterface == null) return;
		if (s_SPIT_ServerInterface.sendedReportProject() == false) return;
		o_SPIT_Message = SPIT_Message.createReportSPITObject(p_SPIT_Object_Interface);
		sendServerSPIT_Message(o_SPIT_Message);
	}
	/**
	 * Send a SPIT_Message to all connected clients.<br>
	 * To do this the s_SPIT_ServerInterface must be set at the server.<br>
	 * @param p_SPIT_Message
	 * @return true = message sended
	 * @see #setSPIT_ServerInterface(SPITServerPackage.SPIT_ServerInterface) 
	 */
	public static boolean sendServerSPIT_Message(SPIT_Message p_SPIT_Message) {
		if (p_SPIT_Message == null) return false;
		SPIT_ServerInterface o_SPIT_ServerInterface;
		o_SPIT_ServerInterface = s_SPIT_ServerInterface;
		if (o_SPIT_ServerInterface == null) return false;
		return o_SPIT_ServerInterface.sendSPIT_Message(p_SPIT_Message);
	}
	

	//----------------------------------------
	//----- functions used by the client -----
	//----------------------------------------
	
	/**
	 * Can be used by the client to fire a remote SPIT_Object.<br>
	 * If the server has assigned an action for the SPIT_Object, the action will ne played.<br>
	 * This function will send a playsequence: PLAYSPITStart, PLAYSPITObject, PLAYSPITEnd 
	 * @param p_SPIT_ClientInterface the SPIT_Client instance which fires the SPIT_Object
	 * @param p_SPIT_Object_Interface the SPIT_Object instance
	 * @return 
	 */
	public static boolean playClientRemoteSPIT_Object(SPIT_ClientInterface p_SPIT_ClientInterface, SPIT_Object_Interface p_SPIT_Object_Interface) {
		if (p_SPIT_ClientInterface == null) return false;
		if (p_SPIT_Object_Interface == null) return false;
		SPIT_Message o_SPIT_Message;
		boolean boolPlaySequenceSended = true;
		o_SPIT_Message = SPIT_Message.createPlaySPITStart(p_SPIT_ClientInterface.getID(), p_SPIT_ClientInterface.getName(), (byte)0x00, false, 0);
		//use p_SPIT_ClientInterface.getID() as PlayerID -> several clients have several ids
		if (p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message) == false) boolPlaySequenceSended = false;
		o_SPIT_Message = SPIT_Message.createPlaySPITObject(p_SPIT_ClientInterface.getID(), p_SPIT_Object_Interface.getID(), 0, false, 0, (byte)0x00);
		if (p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message) == false) boolPlaySequenceSended = false;
		o_SPIT_Message = SPIT_Message.createPlaySPITEnd(p_SPIT_ClientInterface.getID());
		if (p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message) == false) boolPlaySequenceSended = false;
		return boolPlaySequenceSended;
	}
	/**
	 * Can be used by the client to fire a remote SPIT_Object.<br>
	 * If the server has assigned an action for the SPIT_Object, the action will ne played.<br>
	 * This function will send a playsequence: PLAYSPITStart, PLAYSPITObject, PLAYSPITEnd 
	 * @param p_SPIT_ClientInterface the SPIT_Client instance which fires the SPIT_Object
	 * @param p_SPIT_Object_Interface the SPIT_Object instance
	 * @param p_Value_ppm value in ppm
	 * @return 
	 */
	public static boolean playClientRemoteSPIT_Object(SPIT_ClientInterface p_SPIT_ClientInterface, SPIT_Object_Interface p_SPIT_Object_Interface, int p_Value_ppm) {
		if (p_SPIT_ClientInterface == null) return false;
		if (p_SPIT_Object_Interface == null) return false;
		SPIT_Message o_SPIT_Message;
		boolean boolPlaySequenceSended = true;
		o_SPIT_Message = SPIT_Message.createPlaySPITStart(p_SPIT_ClientInterface.getID(), p_SPIT_ClientInterface.getName(), (byte)0x00, false, 0);
		//use p_SPIT_ClientInterface.getID() as PlayerID -> several clients have several ids
		if (p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message) == false) boolPlaySequenceSended = false;
		o_SPIT_Message = SPIT_Message.createPlaySPITObject(p_SPIT_ClientInterface.getID(), p_SPIT_Object_Interface.getID(), 0, false, p_Value_ppm, (byte)0x00);
		if (p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message) == false) boolPlaySequenceSended = false;
		o_SPIT_Message = SPIT_Message.createPlaySPITEnd(p_SPIT_ClientInterface.getID());
		if (p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message) == false) boolPlaySequenceSended = false;
		return boolPlaySequenceSended;
	}
	/**
	 * Can be used by the client to fire a remote SPIT_Object.<br>
	 * If the server has assigned an action for the SPIT_Object, the action will ne played.<br>
	 * This function will send a playsequence: PLAYSPITStart, PLAYSPITObject, PLAYSPITEnd 
	 * @param p_SPIT_ClientInterface the SPIT_Client instance which fires the SPIT_Object
	 * @param p_SPIT_Object_Interface the SPIT_Object instance
	 * @param p_ValueDiff value to increase or decrease
	 * @param p_Increase true = value of SPIT_p_SPIT_ClientInterface's ActionStatus will be increased by p_ValueDiff<br>
	 * false = value of p_SPIT_ClientInterface's SPIT_ActionStatus will be decreased by p_ValueDiff
	 * @return 
	 */
	public static boolean playClientRemoteSPIT_Object(SPIT_ClientInterface p_SPIT_ClientInterface, SPIT_Object_Interface p_SPIT_Object_Interface, int p_ValueDiff, boolean p_Increase) {
		if (p_SPIT_ClientInterface == null) return false;
		if (p_SPIT_Object_Interface == null) return false;
		SPIT_Message o_SPIT_Message;
		boolean boolPlaySequenceSended = true;
		o_SPIT_Message = SPIT_Message.createPlaySPITStart(p_SPIT_ClientInterface.getID(), p_SPIT_ClientInterface.getName(), (byte)0x00, false, 0);
		//use p_SPIT_ClientInterface.getID() as PlayerID -> several clients have several ids
		if (p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message) == false) boolPlaySequenceSended = false;
		if (p_Increase) {
			o_SPIT_Message = SPIT_Message.createPlaySPITObject(p_SPIT_ClientInterface.getID(), p_SPIT_Object_Interface.getID(), 0, false, p_ValueDiff, SPIT_Message.VALUEFLAG_INCREASE);
		}
		else {
			o_SPIT_Message = SPIT_Message.createPlaySPITObject(p_SPIT_ClientInterface.getID(), p_SPIT_Object_Interface.getID(), 0, false, p_ValueDiff, SPIT_Message.VALUEFLAG_DECREASE);
		}
		if (p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message) == false) boolPlaySequenceSended = false;
		o_SPIT_Message = SPIT_Message.createPlaySPITEnd(p_SPIT_ClientInterface.getID());
		if (p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message) == false) boolPlaySequenceSended = false;
		return boolPlaySequenceSended;
	}
	
	public static void parseCloseSPITProject_Client() {
		SPIT_Type_Interface o_SPIT_Type_Interface;
		SPIT_Object_Interface o_SPIT_Object_Interface;
		for (int intSPITObject = s_RemoteSPITObjectModel.getRowCount()-1; intSPITObject >= 0; intSPITObject--) {
			o_SPIT_Object_Interface = s_RemoteSPITObjectModel.getSPIT_Object(intSPITObject);
			if (o_SPIT_Object_Interface == null) continue;
			s_RemoteSPITObjectModel.removeSPIT_Object(o_SPIT_Object_Interface);
			o_SPIT_Object_Interface.close();
		}
		for (int intSPITType = s_SPIT_TypeModel.getRowCount()-1; intSPITType >= 0; intSPITType--) {
			o_SPIT_Type_Interface = s_SPIT_TypeModel.getSPIT_Type(intSPITType);
			if (o_SPIT_Type_Interface == null) continue;
			s_SPIT_TypeModel.removeSPIT_Type(o_SPIT_Type_Interface);
			o_SPIT_Type_Interface.close();
		}
	}
	
}
