/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITLibraryPackage;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;

/**
 *
 * @author Hagi
 */
public class SPIT_TypeDescription implements Externalizable {
	public static int SOFTWAREVERSION = 1;
	
		public static int	s_InstanceCount = 1; // used to increse the default name for new cretaed SPIT_Types
		private String		m_ID;			//ID of this SPIT_Type instance
		private boolean		m_Fixed;		//true = the SPIT_Type can't be changed
		private boolean		m_ServerRemote;		//false = the client is the source of the type
											//true = the Server is the source of the type (Server remote)
		private boolean		m_ServerProjectIndepended;	//0x00 false = the object is independent of the server's projekt
														//maybe remote main loudness, next secene, ...
														//0x01 true = depends on the server's project
														// maybe concrete scene, all objects created inside the server's project
		private String		m_GroupName;	//GroupName can be used to classify the SPIT_Types in GUI
		private String		m_Name;			//name of the SPIT_Type
		private long		m_Delay;		//in Frames
		private long		m_Duration;		//in Frames

		public SPIT_TypeDescription() {
			initMembers();
		}
		public SPIT_TypeDescription(SPIT_Message.ReportSPITType p_ReportSPITType) {
			initMembers();
			if (p_ReportSPITType == null) return;
			m_ID = p_ReportSPITType.getID();
			m_Fixed = p_ReportSPITType.getFixed();
			m_ServerRemote = p_ReportSPITType.getServerRemote();
			m_GroupName = p_ReportSPITType.getGroupName();
			m_Name = p_ReportSPITType.getName();
			m_Delay = p_ReportSPITType.getDelay();
			m_Duration = p_ReportSPITType.getDuration();
		}
		private void initMembers() {
			m_ID = UUID.randomUUID().toString();
			m_Fixed = false;
			m_ServerRemote = false;
			m_ServerProjectIndepended = false;
			m_GroupName = "";
			m_Name = "TriggerType " + s_InstanceCount;
			m_Delay = 0;
			m_Duration = 0;
		}
		
		public boolean setID(String p_ID) {
			if (m_ID.equals(p_ID)) return false;
			if (p_ID == null) m_ID = "";
			else m_ID = p_ID;
			return true;
		}
		public String getID() {
			return m_ID;
		}
		
		public boolean setFixed(boolean p_Fixed) {
			if (m_Fixed == p_Fixed) return false;
			m_Fixed = p_Fixed;
			return true;
		}
		public boolean getFixed() {
			return m_Fixed;
		}
		
		public boolean setServerRemote(boolean p_IsServerRemote) {
			if (m_ServerRemote == p_IsServerRemote) return false;
			m_ServerRemote = p_IsServerRemote;
			return true;
		}
		public boolean getServerRemote() {
			return m_ServerRemote;
		}
		public boolean setServerProjectIndepended(boolean p_ProjectDepending) {
			if (m_ServerProjectIndepended == p_ProjectDepending) return false;
			m_ServerProjectIndepended = p_ProjectDepending;
			return true;
		}
	/**
	 * All remote SPIT_Objects referencing on a SPIT_Type depending on the server's project, should be removed, when the project is closed.<br> 
	 * @return  true = the SPIT Type is indepepended of the server's project
	 */
		public boolean getServerProjectIndepended() {
			return m_ServerProjectIndepended;
		}
		
		public boolean setGroupName(String p_GroupName) {
			if (m_GroupName.equals(p_GroupName)) return false;
			if (p_GroupName == null) m_GroupName = "";
			else m_GroupName = p_GroupName;
			return true;
		}
		public String getGroupName() {
			return m_GroupName;
		}
		public boolean setName(String p_Name) {
			if (m_Name.equals(p_Name)) return false;
			if (p_Name == null) m_Name = "";
			else m_Name = p_Name;
			return true;
		}
		public String getName() {
			return m_Name;
		}
		public boolean setDelay(long p_Delay) {
			if (m_Delay == p_Delay) return false;
			if(p_Delay < 0) m_Delay = 0;
			else m_Delay = p_Delay;
			return true;
		}
		public long getDelay() {
			return m_Delay;
		}
		public boolean setDuration(long p_Duration) {
			if (m_Duration == p_Duration) return false;
			if(p_Duration < 0) m_Duration = 0;
			else m_Duration = p_Duration;
			return true;
		}
		public long getDuration() {
			return m_Duration;
		}

	public boolean copyFromDescription(SPIT_TypeDescription p_SPIT_TypeDescription) {
		if (p_SPIT_TypeDescription == null) return false;
		boolean boolChanged = false;
		if (setID(p_SPIT_TypeDescription.getID())) boolChanged = true;
		if (setFixed(p_SPIT_TypeDescription.getFixed())) boolChanged = true;
		if (setServerRemote(p_SPIT_TypeDescription.getServerRemote())) boolChanged = true;
		if (setServerProjectIndepended(p_SPIT_TypeDescription.getServerProjectIndepended())) boolChanged = true;
		if (setGroupName(p_SPIT_TypeDescription.getGroupName())) boolChanged = true;
		if (setName(p_SPIT_TypeDescription.getName())) boolChanged = true;
		if (setDelay(p_SPIT_TypeDescription.getDelay())) boolChanged = true;
		if (setDuration(p_SPIT_TypeDescription.getDuration())) boolChanged = true;
		return boolChanged;
	}
	public boolean readReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType) {
		if (p_ReportSPITType == null) return false;
		boolean boolChanged = false;
		if (setID(p_ReportSPITType.getID())) boolChanged = true;
		if (setFixed(p_ReportSPITType.getFixed())) boolChanged = true;
		if (setServerRemote(p_ReportSPITType.getServerRemote())) boolChanged = true;
		if (setServerProjectIndepended(p_ReportSPITType.getServerProjectIndepended())) boolChanged = true;
		if (setGroupName(p_ReportSPITType.getGroupName())) boolChanged = true;
		if (setName(p_ReportSPITType.getName())) boolChanged = true;
		if (setDelay(p_ReportSPITType.getDelay())) boolChanged = true;
		if (setDuration(p_ReportSPITType.getDuration())) boolChanged = true;
		return boolChanged;
	}
	public boolean checkEqualsReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType) {
		if (p_ReportSPITType == null) return false;
		if (m_ID.equals(p_ReportSPITType.getID()) == false) return false;
		if (m_Fixed != p_ReportSPITType.getFixed()) return false;
		if (m_ServerRemote != p_ReportSPITType.getServerRemote()) return false;
		if (m_ServerProjectIndepended != p_ReportSPITType.getServerProjectIndepended()) return false;
		if (m_GroupName.equals(p_ReportSPITType.getGroupName()) == false) return false;
		if (m_Name.equals(p_ReportSPITType.getName()) == false) return false;
		if (m_Delay != p_ReportSPITType.getDelay()) return false;
		if (m_Duration != p_ReportSPITType.getDuration()) return false;
		return true;
	}
	
	@Override
	public void writeExternal(ObjectOutput out) throws IOException {
		out.writeInt(SOFTWAREVERSION);
		
		out.writeUTF(m_ID);
		out.writeBoolean(m_Fixed);
		out.writeBoolean(m_ServerRemote);
		out.writeBoolean(m_ServerProjectIndepended);
		out.writeUTF(m_GroupName);
		out.writeUTF(m_Name);
		out.writeLong(m_Delay);
		out.writeLong(m_Duration);
	}

	@Override
	public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
		int intSoftwareVersion;
		intSoftwareVersion = in.readInt();
		
		m_ID = in.readUTF();
		m_Fixed = in.readBoolean();
		m_ServerRemote = in.readBoolean();
		m_ServerProjectIndepended = in.readBoolean();
		m_GroupName = in.readUTF();
		m_Name = in.readUTF();
		m_Delay = in.readLong();
		m_Duration = in.readLong();
	}
		
		
}
