/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITLibraryPackage;

import SPITActionPackage.SPIT_ActionStatus;
import SPITActionPackage.SPIT_Action_Interface;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;

/**
 *
 * @author Hagi
 */
public interface SPIT_Object_Interface extends Externalizable, PropertyChangeListener {
	
	public static final byte	VALUEUSE_DISCARD = SPIT_Message.VALUEUSE_DISCARD; //value of SPITObejct is not used
	public static final byte	VALUEUSE_INRANGE = SPIT_Message.VALUEUSE_INRANGE; //value of SPITOBject in range 0 - 1000000ppm
	public static final byte	VALUEUSE_OVERRIDE = SPIT_Message.VALUEUSE_OVERRIDE; //value can be overridden
	
	public static final String PROP_PARAMCHANGED = "paramchanged";
	public static final String PROP_CONFIRMED = "confirmed";
	public static final String PROP_ACTIONASSIGNED = "actionassigned";
	public static final String PROP_CLOSED = "closed";
	
	/**
	 * Close the SPIT Object
	 */
	public void close();
	
	/**
	 * Set the SPIT Object confirmed or unconfirmed.<br>
	 * This is not a member of the SPIT_ObjectDescription!<br>
	 * Confirmes should be set<br>
	 * + when an object is created by the client<br>
	 * + when the connection to the server is closed
	 * + when the client's project is loaded
	 * + when a ReportSPITObject message is arrived
	 * @param p_Confirmed
	*/
	public void setConfirmed(boolean p_Confirmed);
	public boolean getConfirmed();
	
	
	public void setID(String p_OBjectID);
	public String getID();
	public void setFixed(boolean p_Fixed);
	public boolean getFixed();
	public void setServerRemote(boolean p_SourceFlag);
	public boolean getServerRemote();
	public void setName(String p_ObjectName);
	public String getName();
	public void setRemark(String p_ObjectRemark);
	public String getRemark();
	public void setSPITTypeID(String p_SourceString);
	public String getSPITTypeID(); 
	public SPIT_Type_Interface getSPIT_Type();
	public void setServerParams(String p_Params);
	public String getServerParams();
	public void setFrameStart(long p_FrameStart);
	public long getFrameStart();
	public void setFrameLength(long p_FrameLength);
	public long getFrameLength();
	public void setFrameFadeInLength(long p_FrameFadeInLength);
	public long getFrameFadeInLength();
	public void setFrameFadeOutLength(long p_FrameFadeOutLength);
	public long getFrameFadeOutLength();
	public void setValueFactor(int p_VolumeFactor);
	public int getValueFactor();
	public void setValueUse(byte p_VolumeFactor);
	public byte getValueUse();
	public void setTrack(int p_VIPTrackNumber);
	public int getTrack();
	public void setDelay(long p_Delay);
	public long getDelay();
	public void setDuration(long p_Duration);
	public long getDuration();
	
	/**
	 * This is not a member of the SPIT_ObjectDescription.<br>
	 * Assigning an action is done by the client!<br>
	 * The server will only be informed that an action has been assigned.
	 * @return false = no action assigned
	 */
	public boolean getActionAssigned();
		
	public SPIT_ActionStatus getSPIT_ActionStatus();
	public void setSPIT_Action_Interface(SPIT_Action_Interface p_SPIT_Action_Interface, Object p_ActionObject);
	public SPIT_Action_Interface getSPIT_Action_Interface();
	public Object getSPIT_Action_Object();
	public void playStarted();
	public void playAction();
	public void playEnd();
	public void setPlayValue(int p_PlayValue);	
	
	public boolean copyFromSPIT_ObjectDescription(SPIT_ObjectDescription p_SPIT_ObjectDescription);
	public SPIT_ObjectDescription getSPIT_ObjectDescription();
	public boolean readReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject);
	public boolean checkEqualsReportSPITObject(SPIT_Message.ReportSPITObject p_ReportSPITObject);
	public boolean readReportPlayStatus(SPIT_Message.ReportPlayStatus p_ReportPlayStatus);
	public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener);
	public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener);
	
	
	public static interface SPIT_Object_Listener {
		public void eventSPIT_Object_Added(SPIT_Object_Interface p_SPIT_Object_Interface);
		public void eventSPIT_Object_Changed(SPIT_Object_Interface p_SPIT_Object_Interface);
		public void eventSPIT_Object_Removed(SPIT_Object_Interface p_SPIT_Object_Interface);
		//Remote objects
		public void eventRemoteSPIT_Object_Added(SPIT_Object_Interface p_SPIT_Object_Interface);
		public void eventRemoteSPIT_Object_Changed(SPIT_Object_Interface p_SPIT_Object_Interface);
		public void eventRemoteSPIT_Object_Removed(SPIT_Object_Interface p_SPIT_Object_Interface);
	}
}
