/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITClientPackage;

import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_TypeDescription;
import SwingModelPackage.SPIT_TypeModel;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import SwingModelPackage.SinglePropertyChangeSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.ImageIcon;

/**
 *
 * @author Hagi
 */
public class SPIT_Type implements SPIT_Type_Interface, Externalizable, PropertyChangeListener {
	public static SPIT_TypeModel	s_SPIT_TypeModel = new SPIT_TypeModel();
	
	public static ArrayList<SPIT_Type_Listener>	s_SPIT_Type_Listeners = new ArrayList<>();
	public static final Object					s_SyncListeners = new Object();

	public static ImageIcon s_Icon = null;
	
	private SPIT_TypeDescription	m_SPIT_TypeDescription;	//contains all parametere/members of a SPIT_Type
	private boolean					m_Confirmed;	//true = both the control side and the client side have this SPIT_Type 
												//false = a site has not yet confirmed the existence of this instance
	private boolean					m_SelfCreated;	//true = the client itself has created this SPIT_Type instance
		
	
	private SinglePropertyChangeSupport	m_SinglePropertyChangeSupport;
	
	public static boolean addSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface, SPIT_ClientInterface p_SPIT_ClientInterface) {
		if (p_SPIT_Type_Interface == null) return false;
		boolean boolAdded;
		SPIT_Message o_SPIT_Message;
				
		if (p_SPIT_Type_Interface.getServerRemote() == true) {
			return SPITRemote.addRemoteSPIT_Type(p_SPIT_Type_Interface);
		}
		
		//Non remote SPIT_Types are listet in SPIT_Type
		boolAdded = s_SPIT_TypeModel.addSPIT_Type(p_SPIT_Type_Interface);
		if (boolAdded) {
			notifySPIT_Type_Added(p_SPIT_Type_Interface);
			if (p_SPIT_Type_Interface.getConfirmed() == false) {
				if (p_SPIT_ClientInterface != null) {
					o_SPIT_Message = SPIT_Message.createReportSPITType(p_SPIT_Type_Interface);
					p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message);
				}
			}
		}
		return boolAdded;
	}
	public static boolean addSPIT_Type_ReadExternal(SPIT_Type_Interface p_SPIT_Type_Interface, SPIT_ClientInterface p_SPIT_ClientInterface) {
		if (p_SPIT_Type_Interface == null) return false;
		boolean boolAdded;
		SPIT_Message o_SPIT_Message;
				
		if (p_SPIT_Type_Interface.getServerRemote() == true) {
			return SPITRemote.addRemoteSPIT_Type(p_SPIT_Type_Interface);
		}
		
		//Non remote SPIT_Types are listet in SPIT_Type
		boolAdded = s_SPIT_TypeModel.addSPIT_Type(p_SPIT_Type_Interface);
		if (boolAdded) {
/*			notifySPIT_Type_Added(p_SPIT_Type_Interface);
			if (p_SPIT_Type_Interface.getConfirmed() == false) {
				if (p_SPIT_ClientInterface != null) {
					o_SPIT_Message = SPIT_Message.createReportSPITType(p_SPIT_Type_Interface);
					p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message);
				}
			}
*/
		}
		return boolAdded;
	}
	
	public static boolean removeSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface, SPIT_ClientInterface p_SPIT_ClientInterface) {
		if (p_SPIT_Type_Interface == null) return false;
		boolean boolRemoved = false;
		SPIT_Message o_SPIT_Message;
		String stringID;
		if (p_SPIT_Type_Interface.getServerRemote() == true) {
			return SPITRemote.removeRemoteSPIT_Type(p_SPIT_Type_Interface);
		}
		
		//Non remote SPIT_Types are listet in SPIT_Type
		boolRemoved = s_SPIT_TypeModel.removeSPIT_Type(p_SPIT_Type_Interface);
		if (boolRemoved) {
			notifySPIT_Type_Removed(p_SPIT_Type_Interface);
			stringID = p_SPIT_Type_Interface.getID();
			p_SPIT_Type_Interface.close();
			if (p_SPIT_ClientInterface != null) {
				o_SPIT_Message = SPIT_Message.createRemoveSPITType(stringID);
				p_SPIT_ClientInterface.sendSPIT_Message(o_SPIT_Message);
			}
		}
		return boolRemoved;
	}
	
	
	public static int getSPIT_TypeCount() {
		return s_SPIT_TypeModel.getRowCount();
	}
	
	public static SPIT_Type_Interface getSPIT_Type(String p_ID) {
			return s_SPIT_TypeModel.getSPIT_Type(p_ID);
	}
	public static SPIT_Type_Interface getSPIT_Type(int p_Index) {
		return s_SPIT_TypeModel.getSPIT_Type(p_Index);
	}
	
	public static void unconfirmeAll() {
		int intSPIT_TypeCount;
		SPIT_Type_Interface o_SPIT_Type_Interface;
		intSPIT_TypeCount = s_SPIT_TypeModel.getRowCount();
		for (int intSPITType = 0; intSPITType < intSPIT_TypeCount; intSPITType++) {
			o_SPIT_Type_Interface = getSPIT_Type(intSPITType);
			if (o_SPIT_Type_Interface == null) continue;
			o_SPIT_Type_Interface.setConfirmed(false);
		}		
	}
	/**
	 * The other side sends a SPIT_Type.<br>
	 * While ProjectTransferring this is used to check changed or missing SPIT_Type.<br>
	 * After ProjectTransferring this will be send if a new SPIT_Type is created or changed.<br>
	 * @param p_ReportSPITType
	 * @param p_SPIT_ClientInterface 
	 * @param p_IsTransferringProject 
	 * @return false = the p_ReportSPITType is null, or contains the wrong project id.<br>
	 * Or on clientside the project does not allow editing types or the SPIT_Types is fixed. 
	 */
	public static boolean parseReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType, SPIT_ClientInterface p_SPIT_ClientInterface, boolean p_IsTransferringProject) {
		if (p_ReportSPITType == null) return false;
		if (p_SPIT_ClientInterface == null) return false;
		SPIT_Type_Interface o_SPITType_Interface;

		//Check remote
		if (p_ReportSPITType.getServerRemote() == true) {
			return SPITRemote.parseRemoteSPIT_Type(p_ReportSPITType);
		}
			
		o_SPITType_Interface = getSPIT_Type(p_ReportSPITType.getID());
		if (o_SPITType_Interface == null) {
			//add SPIT_Type 
			o_SPITType_Interface = new SPIT_Type(p_ReportSPITType);
			addSPIT_Type(o_SPITType_Interface, p_SPIT_ClientInterface);
			return true;
		}
		//--- ProjectTransfer ---
		if (p_IsTransferringProject) {
			if (o_SPITType_Interface.checkEqualsReportSPITType(p_ReportSPITType) == false) {
				o_SPITType_Interface.setConfirmed(false);
				return true;
			} 
			else {
				o_SPITType_Interface.setConfirmed(true);
				return true;
			}
		}
		o_SPITType_Interface.setConfirmed(true);
		//Change SPIT_Type		
		o_SPITType_Interface.readReportSPITType(p_ReportSPITType);
		return true;
	}
	
	public static boolean parseRemoveSPITType(SPIT_Message.RemoveSPITType p_RemoveSPITType, SPIT_ClientInterface p_SPIT_ClientInterface) {
		if (p_RemoveSPITType == null) return false;
		SPIT_Type_Interface o_SPITTypeExisting;
		boolean boolRemote = false;
		
		//Remote SPIT_Types are listet in SPITRemote
		o_SPITTypeExisting = SPITRemote.getRemoteSPIT_Type(p_RemoveSPITType.getID());
		if (o_SPITTypeExisting != null) {
			//Remote
			boolRemote = true;
			removeSPIT_Type(o_SPITTypeExisting, p_SPIT_ClientInterface);
		}
		//Non remote SPIT_Types are listet in SPIT_Type
		o_SPITTypeExisting = getSPIT_Type(p_RemoveSPITType.getID());		
		return removeSPIT_Type(o_SPITTypeExisting, p_SPIT_ClientInterface);
	}
	
	public static void parseReportSPITProject() {
		unconfirmeAll();
	}
	public static void parseCloseSPITProject_Server() {
		unconfirmeAll();		
	}
	public static void parseCloseSPITProject_Client() {
		SPIT_Type_Interface o_SPIT_Type_Interface;
		for (int intSPITType = s_SPIT_TypeModel.getRowCount()-1; intSPITType >= 0; intSPITType--) {
			o_SPIT_Type_Interface = s_SPIT_TypeModel.getSPIT_Type(intSPITType);
			if (o_SPIT_Type_Interface == null) continue;
			s_SPIT_TypeModel.removeSPIT_Type(o_SPIT_Type_Interface);
			o_SPIT_Type_Interface.close();
		}
	}
	
	
	// --- SPIT_Type_Listener ---
	public static void addSPIT_Type_Listener(SPIT_Type_Listener p_SPIT_Type_Listener) {
		if (p_SPIT_Type_Listener == null) return;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Type_Listeners.contains(p_SPIT_Type_Listener)) return;
			s_SPIT_Type_Listeners.add(p_SPIT_Type_Listener);
		}
	}
	public static void removeSPIT_Type_Listener(SPIT_Type_Listener p_SPIT_Type_Listener) {
		if (p_SPIT_Type_Listener == null) return;
		synchronized(s_SyncListeners) {
			s_SPIT_Type_Listeners.remove(p_SPIT_Type_Listener);
		}
	}
	public static void notifySPIT_Type_Added(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		ArrayList<SPIT_Type_Listener> o_SPIT_Type_Listeners;
		SPIT_Type_Listener o_SPIT_Type_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Type_Listeners.size() <= 0) return;
			o_SPIT_Type_Listeners = new ArrayList<>(s_SPIT_Type_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Type_Listeners.size(); intListener++) {
			o_SPIT_Type_Listener = o_SPIT_Type_Listeners.get(intListener);
			o_SPIT_Type_Listener.eventSPIT_Type_Added(p_SPIT_Type_Interface);
		}
	}
	public static void notifySPIT_Type_Changed(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		ArrayList<SPIT_Type_Listener> o_SPIT_Type_Listeners;
		SPIT_Type_Listener o_SPIT_Type_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Type_Listeners.size() <= 0) return;
			o_SPIT_Type_Listeners = new ArrayList<>(s_SPIT_Type_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Type_Listeners.size(); intListener++) {
			o_SPIT_Type_Listener = o_SPIT_Type_Listeners.get(intListener);
			o_SPIT_Type_Listener.eventSPIT_Type_Changed(p_SPIT_Type_Interface);
		}
	}
	public static void notifySPIT_Type_Removed(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		ArrayList<SPIT_Type_Listener> o_SPIT_Type_Listeners;
		SPIT_Type_Listener o_SPIT_Type_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Type_Listeners.size() <= 0) return;
			o_SPIT_Type_Listeners = new ArrayList<>(s_SPIT_Type_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Type_Listeners.size(); intListener++) {
			o_SPIT_Type_Listener = o_SPIT_Type_Listeners.get(intListener);
			o_SPIT_Type_Listener.eventSPIT_Type_Removed(p_SPIT_Type_Interface);
		}
	}
	
	public static void notifyRemoteSPIT_Type_Added(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		ArrayList<SPIT_Type_Listener> o_SPIT_Type_Listeners;
		SPIT_Type_Listener o_SPIT_Type_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Type_Listeners.size() <= 0) return;
			o_SPIT_Type_Listeners = new ArrayList<>(s_SPIT_Type_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Type_Listeners.size(); intListener++) {
			o_SPIT_Type_Listener = o_SPIT_Type_Listeners.get(intListener);
			o_SPIT_Type_Listener.eventRemoteSPIT_Type_Added(p_SPIT_Type_Interface);
		}
	}
	public static void notifyRemoteSPIT_Type_Changed(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		ArrayList<SPIT_Type_Listener> o_SPIT_Type_Listeners;
		SPIT_Type_Listener o_SPIT_Type_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Type_Listeners.size() <= 0) return;
			o_SPIT_Type_Listeners = new ArrayList<>(s_SPIT_Type_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Type_Listeners.size(); intListener++) {
			o_SPIT_Type_Listener = o_SPIT_Type_Listeners.get(intListener);
			o_SPIT_Type_Listener.eventRemoteSPIT_Type_Changed(p_SPIT_Type_Interface);
		}
	}
	public static void notifyRemoteSPIT_Type_Removed(SPIT_Type_Interface p_SPIT_Type_Interface) {
		if (p_SPIT_Type_Interface == null) return;
		ArrayList<SPIT_Type_Listener> o_SPIT_Type_Listeners;
		SPIT_Type_Listener o_SPIT_Type_Listener;
		synchronized(s_SyncListeners) {
			if (s_SPIT_Type_Listeners.size() <= 0) return;
			o_SPIT_Type_Listeners = new ArrayList<>(s_SPIT_Type_Listeners);
		}
		for (int intListener = 0; intListener < o_SPIT_Type_Listeners.size(); intListener++) {
			o_SPIT_Type_Listener = o_SPIT_Type_Listeners.get(intListener);
			o_SPIT_Type_Listener.eventRemoteSPIT_Type_Removed(p_SPIT_Type_Interface);
		}
	}
	
	
	
	/**
	 * Standard constructor, should only be used before  readExternal
	 */
	public SPIT_Type() {
		initMembers();
		m_SPIT_TypeDescription = new SPIT_TypeDescription();
		m_Confirmed = false;
		m_SelfCreated = true;
	}
	
	/**
	 * Used by parseReportSPITType to create not existing SPIT_Types<br>
	 * @param p_ReportSPITType
	 * @see #parseReportSPITType(SPITLibraryPackage.SPIT_Message.ReportSPITType, SPITLibraryPackage.SPIT_ClientInterface, boolean) 
	 */
	public SPIT_Type(SPIT_Message.ReportSPITType p_ReportSPITType) {
		initMembers();
		m_SPIT_TypeDescription = new SPIT_TypeDescription();
		if (p_ReportSPITType != null) {
			m_SPIT_TypeDescription.readReportSPITType(p_ReportSPITType);
		}
		m_Confirmed = true;
	}
	
	/**
	 * Can be used to create a SPIT_Type instance.
	 * @param p_SPIT_TypeDescription should have proper filled parameters<br>
	 * to avoid mistakes (for excample when p_SPIT_TypeDescription is used in several constructors):<br>
	 * the constructor creates a new SPIT_TypeDescription and copies all members of p_SPIT_TypeDescription.<br>
	 * When the 'fixed' member (getFixed()) is true: <br>
	 *  - the id of p_SPIT_TypeDescription is used,  Take care that two instances of SPIT_Type have never the same id!!!<br> 
	 *  - the 'confirmed' member is set to true
	 * When the 'fixed' member (getFixed()) is false:<br>
	 *  - a new id is created.<br>
	 *  - the 'confirmed' member is set to false
	 */
	public SPIT_Type(SPIT_TypeDescription p_SPIT_TypeDescription) {
		initMembers();
		//to avoid mistakes (for excample when p_SPIT_TypeDescription is used in several constructors)
		//we create a new description and copy all values of p_SPIT_TypeDescription
		m_SPIT_TypeDescription = new SPIT_TypeDescription();
		if (p_SPIT_TypeDescription != null) {
			if (p_SPIT_TypeDescription.getFixed()) {
				m_SPIT_TypeDescription.copyFromDescription(p_SPIT_TypeDescription);
				m_Confirmed = true;
			}
			else {
				p_SPIT_TypeDescription.setID(UUID.randomUUID().toString());
				m_SPIT_TypeDescription.copyFromDescription(p_SPIT_TypeDescription);
				m_Confirmed = false;
			}
		}
		m_SelfCreated = true;
	}

	
	private void initMembers() {
		m_SinglePropertyChangeSupport = new SinglePropertyChangeSupport(this);
		m_Confirmed = false;
		m_SelfCreated = false;
		SPIT_TypeDescription.s_InstanceCount++;
	}
	
	@Override
	public void close() {
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_CLOSED, null, this);
		m_SinglePropertyChangeSupport.clear();
	}

	public boolean getIsSelfCreated() {
		return m_SelfCreated;
	}
	
	public SPIT_TypeDescription getSPIT_TypeDescription() {
		return m_SPIT_TypeDescription;
	}
	
	@Override
	public void setID(String p_ID) {
		m_SPIT_TypeDescription.setID(p_ID);
	}
	@Override
	public String getID() {
		return m_SPIT_TypeDescription.getID();
	}
	
	
	@Override
	public void setFixed(boolean p_Fixed) {
		if (m_SPIT_TypeDescription.setFixed(p_Fixed) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITType(this);
		if (m_SPIT_TypeDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			//SPITRemote will only send the message when s_SPIT_ServerInterface is set 
			//SPITRemote.s_SPIT_ServerInterface is only set on server side
			notifyRemoteSPIT_Type_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Type_Changed(this);
		}
	}
	@Override
	public boolean getFixed() {
		return m_SPIT_TypeDescription.getFixed();
	}
	@Override
	public void setServerRemote(boolean p_IsServerRemote) {
		if (m_SPIT_TypeDescription.setServerRemote(p_IsServerRemote) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITType(this);				
		if (m_SPIT_TypeDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Type_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Type_Changed(this);
		}
	}
	@Override
	public boolean getServerRemote() {
		return m_SPIT_TypeDescription.getServerRemote();
	}
	
	/**
	 * All remote SPIT_Objects depending on the server's project, should be removed, when the project is closed.<br> 
	 * @param p_ProjectIndepended true = depends on the server's project
	 */
	@Override
	public void setServerProjectIndepended(boolean p_ProjectIndepended) {
		if (m_SPIT_TypeDescription.setServerProjectIndepended(p_ProjectIndepended) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITType(this);
		if (m_SPIT_TypeDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Type_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Type_Changed(this);
		}
	}
	/**
	 * All remote SPIT_Objects depending on the server's project, should be removed, when the project is closed.<br> 
	 * @return  true = depends on the server's project
	 */
	@Override
	public boolean getServerProjectIndepended() {
		return m_SPIT_TypeDescription.getServerProjectIndepended();
	}
	
	@Override
	public void setGroupName(String p_GroupName) {
		if (m_SPIT_TypeDescription.setGroupName(p_GroupName) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITType(this);				
		if (m_SPIT_TypeDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Type_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Type_Changed(this);
		}
	}
	@Override
	public String getGroupName() {
		return m_SPIT_TypeDescription.getGroupName();
	}
	
	@Override
	public void setName(String p_Name) {
		if (m_SPIT_TypeDescription.setName(p_Name) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITType(this);				
		SPIT_Client.sendMessage(o_SPIT_Message);
		if (m_SPIT_TypeDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Type_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Type_Changed(this);
		}
	}
	@Override
	public String getName() {
		return m_SPIT_TypeDescription.getName();
	}
	
	@Override
	public void setDelay(long p_Delay) {
		if (m_SPIT_TypeDescription.setDelay(p_Delay) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITType(this);				
		if (m_SPIT_TypeDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Type_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Type_Changed(this);
		}
	}
	@Override
	public long getDelay() {
		return m_SPIT_TypeDescription.getDelay();
	}
	@Override
	public void setDuration(long p_Duration) {
		if (m_SPIT_TypeDescription.setDuration(p_Duration) == false) return;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
		SPIT_Message o_SPIT_Message;
		o_SPIT_Message = SPIT_Message.createReportSPITType(this);				
		SPIT_Client.sendMessage(o_SPIT_Message);
		if (m_SPIT_TypeDescription.getServerRemote()) {
			SPITRemote.sendServerSPIT_Message(o_SPIT_Message);
			notifyRemoteSPIT_Type_Changed(this);
		}
		else {
			SPIT_Client.sendMessage(o_SPIT_Message);
			notifySPIT_Type_Changed(this);
		}
	}
	@Override
	public long getDuration() {
		return m_SPIT_TypeDescription.getDuration();
	}
	
	@Override
	public boolean copyFromDescription(SPIT_TypeDescription p_SPIT_TypeDescription) {
		if (p_SPIT_TypeDescription == null) return false;
		if (m_SPIT_TypeDescription.copyFromDescription(p_SPIT_TypeDescription)) {
			m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
			if (m_SPIT_TypeDescription.getServerRemote()) {
				notifyRemoteSPIT_Type_Changed(this);
			}
			else {
				notifySPIT_Type_Changed(this);
			}
			return true;
		}
		return false;
	}
	
	
	@Override
	public boolean getConfirmed() {
		return m_Confirmed;
	}
	@Override
	public void setConfirmed(boolean p_Confirmed) {
		if (m_Confirmed == p_Confirmed) return;
		boolean oldValue;
		oldValue = m_Confirmed;
		m_Confirmed = p_Confirmed;
		m_SinglePropertyChangeSupport.firePropertyChange(PROP_CONFIRMED, oldValue, m_Confirmed);		
			if (m_SPIT_TypeDescription.getServerRemote()) {
				notifyRemoteSPIT_Type_Changed(this);
			}
			else {
				notifySPIT_Type_Changed(this);
			}
	}
	
	
	@Override
	public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
		if (p_PropertyChangeListener == null) return;
		m_SinglePropertyChangeSupport.addPropertyChangeListener(p_PropertyChangeListener);
	}
	@Override
	public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
		if (p_PropertyChangeListener == null) return;
		m_SinglePropertyChangeSupport.removePropertyChangeListener(p_PropertyChangeListener);
	}

	
	@Override
	public boolean readReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType) {
		if (m_SPIT_TypeDescription.readReportSPITType(p_ReportSPITType) == true) {
			m_SinglePropertyChangeSupport.firePropertyChange(PROP_PARAMCHANGED, false, true);
			if (m_SPIT_TypeDescription.getServerRemote()) {
				notifyRemoteSPIT_Type_Changed(this);
			}
			else {
				notifySPIT_Type_Changed(this);
			}
			return true;
		}
		return false;
	}
	@Override
	public boolean checkEqualsReportSPITType(SPIT_Message.ReportSPITType p_ReportSPITType) {
		
		return m_SPIT_TypeDescription.checkEqualsReportSPITType(p_ReportSPITType);
	}
	
	public static final int	SOFTWAREVERSION = 1;
	@Override
	public void writeExternal(ObjectOutput out) throws IOException {
		out.writeInt(SOFTWAREVERSION);
		
		m_SPIT_TypeDescription.writeExternal(out);
		//perhaps write additional members
	}
	@Override
	public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
		int intSoftwareVersion;
		intSoftwareVersion = in.readInt();
		
		m_SPIT_TypeDescription.readExternal(in);
		//perhaps read additional members
		
		addSPIT_Type_ReadExternal(this, SPIT_Client.s_SelfReference);
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {
	}

	@Override
	public Icon getIcon() {
		return null;
	}

	
}
