/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITActionPackage;

import SPITLibraryPackage.SPIT_Object_Interface;

/**
 * An SPIT_Action_Interface should be implemented by all classes that can play an SPITAction,<br>
 * when the server plays an SPIT_Object.<br>
 * The class instance can then be added to a SPIT_Object as SPIT_Action_Interface.
 * @see SPIT_Object_Interface#
 * @author Hagi
 */
public interface SPIT_Action_Interface {
	/**
	 * Will be called when the cursor reaches the object or jumps from outside in the object
	 * @param p_SPIT_Object_Interface
	 * @param p_SPIT_ActionStatus
	 * @param p_ActionObject 
	 */
	public void playStarted(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject);
	/**
	 * Will be called when the trigger object is played, the amount of calls depend on the sampling rate of the cursor
	 * @param p_SPIT_Object_Interface
	 * @param p_SPIT_ActionStatus
	 * @param p_ActionObject 
	 */
	public void play(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject);
	/**
	 * Will be called when the cursor leaves the object or jumps to outside of the object.<br>
	 * Caution: The p_SPIT_ActionStatus is resetted at this moment, therefore getPlayValue() will always return 0
	 * @param p_SPIT_Object_Interface
	 * @param p_SPIT_ActionStatus
	 * @param p_ActionObject 
	 */
	public void playEnd(SPIT_Object_Interface p_SPIT_Object_Interface, SPIT_ActionStatus p_SPIT_ActionStatus, Object p_ActionObject);
}
