/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITActionPackage;

import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_Object_Interface;

/**
 *
 * @author Hagi
 */
public class SPIT_ActionStatus {
	public static final byte VALUEFLAG_DIRECT = SPIT_Message.VALUEFLAG_DIRECT;
	public static final byte VALUEFLAG_INCREASE = SPIT_Message.VALUEFLAG_INCREASE;
	public static final byte VALUEFLAG_DECREASE = SPIT_Message.VALUEFLAG_DECREASE;
	
	private boolean				m_PlayerIsRunning;
	private boolean				m_IsPlayPrePosition;	//true = the Pplaycursor is inside the object -> the object is actual played
	private long				m_PlayFrameInside;	//position of the playcursor inside of this object in frames
	private int					m_PlayValue;	//ppm

	public SPIT_ActionStatus() {
	}
	
	private void initMembers() {
		m_PlayerIsRunning = false;
		m_IsPlayPrePosition = false;
		m_PlayFrameInside = -1;
		m_PlayValue = 0;
	}
	
	public boolean setPlayerIsRunning(boolean p_PlayerIsRunning) {
		if (m_PlayerIsRunning == p_PlayerIsRunning) return false;
		m_PlayerIsRunning = p_PlayerIsRunning;
		return true;
	}
	public boolean getPlayerIsRunning() {
		return m_PlayerIsRunning;
	}
	
	public boolean setIsPlayPrePosition(boolean p_IsPlaying) {
		if (m_IsPlayPrePosition == p_IsPlaying) return false;
		m_IsPlayPrePosition = p_IsPlaying;
		return true;
	}
	public boolean getIsPlayPrePosition() {
		return m_IsPlayPrePosition;
	}
	
	public boolean setPlayFrameInside(long p_FrameInside) {
		if (m_PlayFrameInside == p_FrameInside) return false;
		m_PlayFrameInside = p_FrameInside;
		return true;
	}
	public long getPlayFrameInside() {
		return m_PlayFrameInside;
	}
	
	public boolean setPlayValue(int p_PlayFactor_ppm) {
		if (m_PlayValue == p_PlayFactor_ppm) return false;
		m_PlayValue = p_PlayFactor_ppm;
		return true;
	}
	public int getPlayValue() {
		return m_PlayValue;
	}
	
	//the server plays the object
	public boolean setStatus(boolean p_PlayerIsRunning, 
			boolean p_IsPlayPrePosition, long p_FrameInside, int p_PlayValue_ppm, byte p_ValueFlag, SPIT_Object_Interface p_SPIT_Object_Interface) {
		boolean boolChanged = false;
		int intOldValue;
		if (setPlayerIsRunning(p_PlayerIsRunning)) boolChanged = true;
		if (setIsPlayPrePosition(p_IsPlayPrePosition)) boolChanged = true;
		if (setPlayFrameInside(p_FrameInside)) boolChanged = true;
		intOldValue = m_PlayValue;
		switch (p_ValueFlag) {
			case VALUEFLAG_DIRECT:
				m_PlayValue = p_PlayValue_ppm;
//				if (m_PlayValue < 0) m_PlayValue = 0;
//				if (m_PlayValue > 1000000) m_PlayValue = 1000000;
				break;
			case VALUEFLAG_INCREASE:
				m_PlayValue += p_PlayValue_ppm;
				break;
			case VALUEFLAG_DECREASE:
				m_PlayValue -= p_PlayValue_ppm;
				break;
			default:
				m_PlayValue = p_PlayValue_ppm;
				break;				
		}
		if (p_SPIT_Object_Interface.getValueUse() == SPIT_Object_Interface.VALUEUSE_INRANGE) {
			if (m_PlayValue < 0) m_PlayValue = 0;
			if (m_PlayValue > 1000000) m_PlayValue = 1000000;
		}
		if (intOldValue != m_PlayValue ) boolChanged = true;
		return boolChanged;
	}
	
	public boolean readReportPlayStatus(SPIT_Message.ReportPlayStatus p_ReportPlayStatus) {
		if (p_ReportPlayStatus == null) return false;
		boolean boolChanged = false;
		if (setPlayFrameInside(p_ReportPlayStatus.getFrameInsideObject())) boolChanged = true;
		if (setPlayValue(p_ReportPlayStatus.getValue())) boolChanged = true;
		return boolChanged;
	}
	
	//when the object is not actual played by the server 
	public boolean resetStatus() {
		boolean boolChanged = false;
		if (setPlayerIsRunning(false)) boolChanged = true;
		if (setIsPlayPrePosition(false)) boolChanged = true;
		if (setPlayFrameInside(-1)) boolChanged = true;
		if (setPlayValue(0)) boolChanged = true;
		return boolChanged;
	}
}
