/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package SPITActionPackage;

import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Message;
import SPITLibraryPackage.SPIT_Object_Interface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/**
 *
 * @author Hagi
 */
public class SPIT_ActionPlayer {
	public static byte	PLAYERFLAG_MAIN = SPIT_Message.PLAYERTYPE_MAIN;
														//continous player over the whole project
														//can be used to play a timeline
														//the time of this player can be used as a timecode
	public static byte	PLAYERFLAG_CONTINOUS = SPIT_Message.PLAYERTYPE_CONTINIOUS;	
														//continous player but no time code player
														//can be used to play jingles, ...
	public static byte	PLAYERFLAG_DISCRETE = SPIT_Message.PLAYERTYPE_DISCRETE;		
														//discrete player 
														//can be used to set an value for objects once, send Remote Objects, ..)
	
	
	public static HashMap<String, SPIT_ActionPlayer>	s_SPIT_ActionPlayers = new HashMap<>();
	public static Object								s_SyncPlayers = new Object();
	
	private String	m_PlayerID;
	private byte	m_PlayerType;
	private String	m_PlayerName;
	private boolean	m_PlayerIsRunning;
	private long	m_PlayFrameGlobal;
	private HashMap<String, SPIT_Object_Interface>	m_PlaySPITObjects;
	private HashMap<String, SPIT_Object_Interface>	m_ActualPlayingObjects;
	private HashMap<String, SPIT_Object_Interface>	m_EndedSPITObjects;
	private final Object	m_SyncPlayObjects = new Object();

	public SPIT_ActionPlayer(String p_PlayerID, String p_PlayerName, byte p_PlayerType) {
		initMembers();
		m_PlayerID = p_PlayerID;
		m_PlayerName = p_PlayerName;
		if (p_PlayerType != PLAYERFLAG_MAIN && p_PlayerType != PLAYERFLAG_CONTINOUS && p_PlayerType != PLAYERFLAG_DISCRETE) {
			p_PlayerType = PLAYERFLAG_DISCRETE;
		}
		m_PlayerType = p_PlayerType;
	}
	
	private void initMembers() {
		m_PlaySPITObjects = new HashMap<>();
		m_EndedSPITObjects = new HashMap<>();
		m_ActualPlayingObjects = new HashMap<>();
		m_PlayerIsRunning = false;
	}
	
	public String getID() {
		return m_PlayerID;
	}
	public String getName() {
		return m_PlayerName;
	}
	public byte getType() {
		return m_PlayerType;
	}
	public boolean getPlayerIsRunning() {
		return m_PlayerIsRunning;
	}
	public long getPlayFrameGlobal() {
		return m_PlayFrameGlobal;
	}
		
	public void startPlayTransfer(SPIT_ClientInterface p_SPIT_ClientInterface, boolean p_PlayerIsRunning, long p_PlayFrameGlobal) {
		synchronized(m_SyncPlayObjects) {
			m_PlaySPITObjects.clear();
		}
		m_PlayFrameGlobal = p_PlayFrameGlobal;
		m_PlayerIsRunning = p_PlayerIsRunning;
	}
	public void playObjectTransfer(SPIT_ClientInterface p_SPIT_ClientInterface, SPIT_Object_Interface p_SPIT_Object_Interface, 
			boolean p_PlayingPrePosition, long p_FrameInside, int p_Value_ppm, byte p_ValueFlag) {
		if (p_SPIT_Object_Interface == null) return;
		SPIT_ActionStatus o_SPIT_ActionStatus;
		o_SPIT_ActionStatus = p_SPIT_Object_Interface.getSPIT_ActionStatus();
		if (o_SPIT_ActionStatus == null) return;
		synchronized(m_SyncPlayObjects) {
			m_PlaySPITObjects.put(p_SPIT_Object_Interface.getID(), p_SPIT_Object_Interface);
		}			
		if (o_SPIT_ActionStatus.setStatus(m_PlayerIsRunning, p_PlayingPrePosition, p_FrameInside, p_Value_ppm, p_ValueFlag, p_SPIT_Object_Interface)) {
			
		}
	}
	public boolean endPlayTransfer(SPIT_ClientInterface p_SPIT_ClientInterface) {
		SPIT_Object_Interface o_SPIT_Object_Interface;
		Iterator<SPIT_Object_Interface> o_Iterator;
		Iterator<SPIT_Object_Interface> o_IteratorSPITObjects;
		SPIT_ActionStatus o_SPIT_ActionStatus;
		SPIT_Object_Interface o_SPIT_Object_LastPlayed;
			
		//collect actual played objects
		//--- Check if Object is started and remove from ended played objects		
		m_ActualPlayingObjects.clear();
		o_Iterator = m_PlaySPITObjects.values().iterator();
		while (o_Iterator.hasNext()) {
			o_SPIT_Object_Interface = o_Iterator.next();
			if (o_SPIT_Object_Interface == null) continue;
			//remove from the last played objects
			o_SPIT_Object_LastPlayed = m_EndedSPITObjects.remove(o_SPIT_Object_Interface.getID());
			if (o_SPIT_Object_LastPlayed == null) {
				//Object is just started
				if (m_PlayerType != PLAYERFLAG_DISCRETE) {
					o_SPIT_Object_Interface.playStarted();
				}
			}
			o_SPIT_Object_Interface.playAction();
			//add to actual played objects
			m_ActualPlayingObjects.put(o_SPIT_Object_Interface.getID(), o_SPIT_Object_Interface);
		}
		//Objects played with discrete players will stay in there actual status 
		if (m_PlayerType != PLAYERFLAG_DISCRETE) {
			//reset status for all objects leaved in last played objects 
			o_IteratorSPITObjects = m_EndedSPITObjects.values().iterator();
			while (o_IteratorSPITObjects.hasNext()) {
				o_SPIT_Object_Interface = o_IteratorSPITObjects.next();
				o_SPIT_ActionStatus = o_SPIT_Object_Interface.getSPIT_ActionStatus();
				//reset action status to a null status
				o_SPIT_ActionStatus.resetStatus();
				//play action to inform that the object isn't played yet
				o_SPIT_Object_Interface.playAction();
				o_SPIT_Object_Interface.playEnd();
			}
		}
		//fill last played objects with actual played objects
		m_EndedSPITObjects.clear();
		m_EndedSPITObjects.putAll(m_ActualPlayingObjects);
		
		//notify time code to all TimeCodeListener
		if (m_PlayerType == PLAYERFLAG_MAIN) {
			notifyTimeCode(p_SPIT_ClientInterface, this);
		}
		return true;
	}
	
	public static void addSPIT_ActionPlayer(SPIT_ActionPlayer p_ActionPlayer) {
		if (p_ActionPlayer == null) return;
		synchronized(s_SPIT_ActionPlayers) {
			s_SPIT_ActionPlayers.put(p_ActionPlayer.getID(), p_ActionPlayer);
		}
	}
	public static void removeSPIT_ActionPlayer(SPIT_ActionPlayer p_ActionPlayer) {
		if (p_ActionPlayer == null) return;
		synchronized(s_SPIT_ActionPlayers) {
			s_SPIT_ActionPlayers.remove(p_ActionPlayer.getID());
		}
	}
	public static void clearSPIT_ActionPlayers() {
		synchronized(s_SyncPlayers) {
			s_SPIT_ActionPlayers.clear();
		}
	}
	public static SPIT_ActionPlayer getSPIT_ActionPlayer(String p_ID) {
		synchronized(s_SyncPlayers) {
			return s_SPIT_ActionPlayers.get(p_ID);
		}
	}
	
	//--- TimeCode Listener ---
	private static ArrayList<TimeCodeListener>	s_TimeCodeListeners = new ArrayList<>();
	private static final Object					s_SyncTimeCodeListeners = new Object();
	public static interface TimeCodeListener {
		public void eventTimeCode(long p_PlayFrame, long p_FramesPerSecond);
	}
	
	public static void addTimeCodeListener(TimeCodeListener p_TimeCodeListener) {
		if (p_TimeCodeListener == null) return;
		synchronized(s_SyncTimeCodeListeners) {
			if (s_TimeCodeListeners.contains(p_TimeCodeListener)) return;
			s_TimeCodeListeners.add(p_TimeCodeListener);
		}
	}
	public static void removeTimeCodeListener(TimeCodeListener p_TimeCodeListener) {
		if (p_TimeCodeListener == null) return;
		synchronized(s_SyncTimeCodeListeners) {
			s_TimeCodeListeners.remove(p_TimeCodeListener);
		}
	}
	private static void notifyTimeCode(SPIT_ClientInterface p_SPIT_ClientInterface, SPIT_ActionPlayer p_SPIT_ActionPlayer) {
		if (p_SPIT_ActionPlayer == null) return;
		if (p_SPIT_ActionPlayer.getType() != PLAYERFLAG_MAIN) return;
		ArrayList<TimeCodeListener> o_TimeCodeListeners;
		TimeCodeListener o_TimeCodeListener;
		synchronized(s_SyncTimeCodeListeners) {
			if (s_TimeCodeListeners.size() <= 0) return;
			o_TimeCodeListeners = new ArrayList<>(s_TimeCodeListeners.size());
			o_TimeCodeListeners.addAll(s_TimeCodeListeners);
		}
		for (int intListener = 0; intListener < o_TimeCodeListeners.size(); intListener++) {
			o_TimeCodeListener = o_TimeCodeListeners.get(intListener);
			o_TimeCodeListener.eventTimeCode(p_SPIT_ActionPlayer.getPlayFrameGlobal(), p_SPIT_ClientInterface.getServerFramesPerSecond());
		}
	}
}
