/*
 * Decompiled with CFR 0.152.
 */
package SPITActionPackage;

import SPITActionPackage.SPIT_ActionStatus;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Object_Interface;
import java.util.ArrayList;
import java.util.HashMap;

public class SPIT_ActionPlayer {
    public static byte PLAYERFLAG_MAIN = (byte)2;
    public static byte PLAYERFLAG_CONTINOUS = 1;
    public static byte PLAYERFLAG_DISCRETE = 0;
    public static HashMap<String, SPIT_ActionPlayer> s_SPIT_ActionPlayers = new HashMap();
    public static Object s_SyncPlayers = new Object();
    private String m_PlayerID;
    private byte m_PlayerType;
    private String m_PlayerName;
    private boolean m_PlayerIsRunning;
    private long m_PlayFrameGlobal;
    private HashMap<String, SPIT_Object_Interface> m_PlaySPITObjects;
    private HashMap<String, SPIT_Object_Interface> m_ActualPlayingObjects;
    private HashMap<String, SPIT_Object_Interface> m_EndedSPITObjects;
    private final Object m_SyncPlayObjects = new Object();
    private static ArrayList<TimeCodeListener> s_TimeCodeListeners = new ArrayList();
    private static final Object s_SyncTimeCodeListeners = new Object();

    public SPIT_ActionPlayer(String p_PlayerID, String p_PlayerName, byte p_PlayerType) {
        this.initMembers();
        this.m_PlayerID = p_PlayerID;
        this.m_PlayerName = p_PlayerName;
        if (p_PlayerType != PLAYERFLAG_MAIN && p_PlayerType != PLAYERFLAG_CONTINOUS && p_PlayerType != PLAYERFLAG_DISCRETE) {
            p_PlayerType = PLAYERFLAG_DISCRETE;
        }
        this.m_PlayerType = p_PlayerType;
    }

    private void initMembers() {
        this.m_PlaySPITObjects = new HashMap();
        this.m_EndedSPITObjects = new HashMap();
        this.m_ActualPlayingObjects = new HashMap();
        this.m_PlayerIsRunning = false;
    }

    public String getID() {
        return this.m_PlayerID;
    }

    public String getName() {
        return this.m_PlayerName;
    }

    public byte getType() {
        return this.m_PlayerType;
    }

    public boolean getPlayerIsRunning() {
        return this.m_PlayerIsRunning;
    }

    public long getPlayFrameGlobal() {
        return this.m_PlayFrameGlobal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPlayTransfer(SPIT_ClientInterface p_SPIT_ClientInterface, boolean p_PlayerIsRunning, long p_PlayFrameGlobal) {
        Object object = this.m_SyncPlayObjects;
        synchronized (object) {
            this.m_PlaySPITObjects.clear();
        }
        this.m_PlayFrameGlobal = p_PlayFrameGlobal;
        this.m_PlayerIsRunning = p_PlayerIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playObjectTransfer(SPIT_ClientInterface p_SPIT_ClientInterface, SPIT_Object_Interface p_SPIT_Object_Interface, boolean p_PlayingPrePosition, long p_FrameInside, int p_Value_ppm, byte p_ValueFlag) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        SPIT_ActionStatus o_SPIT_ActionStatus = p_SPIT_Object_Interface.getSPIT_ActionStatus();
        if (o_SPIT_ActionStatus == null) {
            return;
        }
        Object object = this.m_SyncPlayObjects;
        synchronized (object) {
            this.m_PlaySPITObjects.put(p_SPIT_Object_Interface.getID(), p_SPIT_Object_Interface);
        }
        if (o_SPIT_ActionStatus.setStatus(this.m_PlayerIsRunning, p_PlayingPrePosition, p_FrameInside, p_Value_ppm, p_ValueFlag, p_SPIT_Object_Interface)) {
            // empty if block
        }
    }

    public boolean endPlayTransfer(SPIT_ClientInterface p_SPIT_ClientInterface) {
        this.m_ActualPlayingObjects.clear();
        for (SPIT_Object_Interface o_SPIT_Object_Interface : this.m_PlaySPITObjects.values()) {
            if (o_SPIT_Object_Interface == null) continue;
            SPIT_Object_Interface o_SPIT_Object_LastPlayed = this.m_EndedSPITObjects.remove(o_SPIT_Object_Interface.getID());
            if (o_SPIT_Object_LastPlayed == null && this.m_PlayerType != PLAYERFLAG_DISCRETE) {
                o_SPIT_Object_Interface.playStarted();
            }
            o_SPIT_Object_Interface.playAction();
            this.m_ActualPlayingObjects.put(o_SPIT_Object_Interface.getID(), o_SPIT_Object_Interface);
        }
        if (this.m_PlayerType != PLAYERFLAG_DISCRETE) {
            for (SPIT_Object_Interface o_SPIT_Object_Interface : this.m_EndedSPITObjects.values()) {
                SPIT_ActionStatus o_SPIT_ActionStatus = o_SPIT_Object_Interface.getSPIT_ActionStatus();
                o_SPIT_ActionStatus.resetStatus();
                o_SPIT_Object_Interface.playAction();
                o_SPIT_Object_Interface.playEnd();
            }
        }
        this.m_EndedSPITObjects.clear();
        this.m_EndedSPITObjects.putAll(this.m_ActualPlayingObjects);
        if (this.m_PlayerType == PLAYERFLAG_MAIN) {
            SPIT_ActionPlayer.notifyTimeCode(p_SPIT_ClientInterface, this);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSPIT_ActionPlayer(SPIT_ActionPlayer p_ActionPlayer) {
        if (p_ActionPlayer == null) {
            return;
        }
        HashMap<String, SPIT_ActionPlayer> hashMap = s_SPIT_ActionPlayers;
        synchronized (hashMap) {
            s_SPIT_ActionPlayers.put(p_ActionPlayer.getID(), p_ActionPlayer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSPIT_ActionPlayer(SPIT_ActionPlayer p_ActionPlayer) {
        if (p_ActionPlayer == null) {
            return;
        }
        HashMap<String, SPIT_ActionPlayer> hashMap = s_SPIT_ActionPlayers;
        synchronized (hashMap) {
            s_SPIT_ActionPlayers.remove(p_ActionPlayer.getID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearSPIT_ActionPlayers() {
        Object object = s_SyncPlayers;
        synchronized (object) {
            s_SPIT_ActionPlayers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SPIT_ActionPlayer getSPIT_ActionPlayer(String p_ID) {
        Object object = s_SyncPlayers;
        synchronized (object) {
            return s_SPIT_ActionPlayers.get(p_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTimeCodeListener(TimeCodeListener p_TimeCodeListener) {
        if (p_TimeCodeListener == null) {
            return;
        }
        Object object = s_SyncTimeCodeListeners;
        synchronized (object) {
            if (s_TimeCodeListeners.contains(p_TimeCodeListener)) {
                return;
            }
            s_TimeCodeListeners.add(p_TimeCodeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTimeCodeListener(TimeCodeListener p_TimeCodeListener) {
        if (p_TimeCodeListener == null) {
            return;
        }
        Object object = s_SyncTimeCodeListeners;
        synchronized (object) {
            s_TimeCodeListeners.remove(p_TimeCodeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyTimeCode(SPIT_ClientInterface p_SPIT_ClientInterface, SPIT_ActionPlayer p_SPIT_ActionPlayer) {
        ArrayList<TimeCodeListener> o_TimeCodeListeners;
        if (p_SPIT_ActionPlayer == null) {
            return;
        }
        if (p_SPIT_ActionPlayer.getType() != PLAYERFLAG_MAIN) {
            return;
        }
        Object object = s_SyncTimeCodeListeners;
        synchronized (object) {
            if (s_TimeCodeListeners.size() <= 0) {
                return;
            }
            o_TimeCodeListeners = new ArrayList<TimeCodeListener>(s_TimeCodeListeners.size());
            o_TimeCodeListeners.addAll(s_TimeCodeListeners);
        }
        for (int intListener = 0; intListener < o_TimeCodeListeners.size(); ++intListener) {
            TimeCodeListener o_TimeCodeListener = (TimeCodeListener)o_TimeCodeListeners.get(intListener);
            o_TimeCodeListener.eventTimeCode(p_SPIT_ActionPlayer.getPlayFrameGlobal(), p_SPIT_ClientInterface.getServerFramesPerSecond());
        }
    }

    public static interface TimeCodeListener {
        public void eventTimeCode(long var1, long var3);
    }
}

