/*
 * Decompiled with CFR 0.152.
 */
package SwingModelPackage;

public class SPIT_TimeTools {
    public static final int UNIT_TIME = 0;
    public static final int UNIT_FRAMES = 1;

    public static String getTimeStringFromFrames(long p_Frames, double p_FramesPerSecond) {
        if (p_FramesPerSecond <= 0.0) {
            return SPIT_TimeTools.getTimeStringFromMillis(0L);
        }
        return SPIT_TimeTools.getTimeStringFromMillis((long)(1000.0 * (double)p_Frames / p_FramesPerSecond));
    }

    public static String getTimeStringFromMillis(long p_Milliseconds) {
        String stringTemp;
        String stringTime = "";
        boolean boolSetString = false;
        int intHours = (int)(p_Milliseconds / 3600000L);
        p_Milliseconds -= (long)(intHours * 3600000);
        if (boolSetString || intHours > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intHours);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
            boolSetString = true;
        }
        int intMinutes = (int)(p_Milliseconds / 60000L);
        p_Milliseconds -= (long)(intMinutes * 60000);
        if (boolSetString || intMinutes > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intMinutes);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
            boolSetString = true;
        }
        int intSeconds = (int)(p_Milliseconds / 1000L);
        p_Milliseconds -= (long)(intSeconds * 1000);
        if (boolSetString || intSeconds > 0) {
            stringTemp = "00";
            stringTemp = stringTemp + String.valueOf(intSeconds);
            stringTime = stringTime + stringTemp.substring(stringTemp.length() - 2, stringTemp.length()) + ":";
            boolSetString = true;
        }
        int intMilliseconds = (int)p_Milliseconds;
        stringTemp = "000";
        stringTemp = stringTemp + String.valueOf(intMilliseconds);
        stringTime = stringTime + stringTemp.substring(stringTemp.length() - 3, stringTemp.length());
        return stringTime;
    }

    public static long getFramesFromTimeString(String p_TimeString, double p_FramesPerSecond) {
        if (p_TimeString == null || p_TimeString.length() <= 0) {
            return 0L;
        }
        if (p_FramesPerSecond <= 0.0) {
            return 0L;
        }
        try {
            long longFrames = 0L;
            long longMilliseconds = 0L;
            int intSeconds = 0;
            int intMinutes = 0;
            int intHours = 0;
            String[] arrayTimeString = p_TimeString.split(":");
            if (arrayTimeString.length >= 1) {
                longMilliseconds = Integer.valueOf(arrayTimeString[arrayTimeString.length - 1].trim()).intValue();
            }
            if (arrayTimeString.length >= 2) {
                intSeconds = Integer.valueOf(arrayTimeString[arrayTimeString.length - 2].trim());
                longMilliseconds += (long)(intSeconds * 1000);
            }
            if (arrayTimeString.length >= 3) {
                intMinutes = Integer.valueOf(arrayTimeString[arrayTimeString.length - 3].trim());
                longMilliseconds += (long)(intMinutes * 60000);
            }
            if (arrayTimeString.length >= 4) {
                intHours = Integer.valueOf(arrayTimeString[arrayTimeString.length - 4].trim());
                longMilliseconds += (long)(intHours * 3600000);
            }
            longFrames = (long)((double)longMilliseconds / 1000.0 * p_FramesPerSecond);
            return longFrames;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public static long getMillisecondsFromString(String p_TimeString) {
        if (p_TimeString == null || p_TimeString.length() <= 0) {
            return 0L;
        }
        long longMilliseconds = 0L;
        int intSeconds = 0;
        int intMinutes = 0;
        int intHours = 0;
        try {
            String[] arrayTimeString = p_TimeString.split(":");
            arrayTimeString = p_TimeString.split(":");
            if (arrayTimeString.length >= 1) {
                longMilliseconds = Integer.valueOf(arrayTimeString[arrayTimeString.length - 1].trim()).intValue();
            }
            if (arrayTimeString.length >= 2) {
                intSeconds = Integer.valueOf(arrayTimeString[arrayTimeString.length - 2].trim());
                longMilliseconds += (long)(intSeconds * 1000);
            }
            if (arrayTimeString.length >= 3) {
                intMinutes = Integer.valueOf(arrayTimeString[arrayTimeString.length - 3].trim());
                longMilliseconds += (long)(intMinutes * 60000);
            }
            if (arrayTimeString.length >= 4) {
                intHours = Integer.valueOf(arrayTimeString[arrayTimeString.length - 4].trim());
                longMilliseconds += (long)(intHours * 3600000);
            }
        }
        catch (Exception e) {
            return 0L;
        }
        return longMilliseconds;
    }
}

