/*
 * Decompiled with CFR 0.152.
 */
package SPITServerAutoDetectPackage;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;

public class ServerAutoDetect {
    public static final String SEARCH_ALL_SERVERS = "*";
    public static final String PRECODE = "#SAD#";
    public static final String SEPERATOR = "#,#";
    public static final int PORT_IP4 = 15110;
    public static final int PORT_IP6 = 15110;
    public static String MULTICASTGROUPNAME_IP6 = "ff02::1";
    public static Charset CHARSET = Charset.forName("ISO-8859-15");
    public static int BYTEBUFFERSIZE = 15000;

    public static String cleanIPAddress(String p_IPAddress) {
        if (p_IPAddress == null) {
            return null;
        }
        if (p_IPAddress.length() <= 0) {
            return p_IPAddress;
        }
        String stringCleanIPAddress = p_IPAddress;
        try {
            while (stringCleanIPAddress.startsWith("/")) {
                stringCleanIPAddress = stringCleanIPAddress.substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            while (stringCleanIPAddress.endsWith("/")) {
                stringCleanIPAddress = stringCleanIPAddress.substring(0, stringCleanIPAddress.length() - 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringCleanIPAddress;
    }

    public static class DetectedServer_TableCellRenderer
    extends DefaultTableCellRenderer {
        private StringBuffer m_StringBuffer;
        private boolean m_ShowServerTaskID;
        private boolean m_ShowServerTaskName;
        private boolean m_ShowComputerName;
        private boolean m_ShowServerIP;
        private boolean m_ShowServerPort;
        private boolean m_ShowServerAddition;

        public DetectedServer_TableCellRenderer() {
            this.initMembers();
        }

        public DetectedServer_TableCellRenderer(boolean p_ShowServerTaskID, boolean p_ShowServerTaskName, boolean p_ShowComputerName, boolean p_ShowServerIP, boolean p_ShowServerPort, boolean p_ShowServerAddition) {
            this.initMembers();
            this.m_ShowServerTaskID = p_ShowServerTaskID;
            this.m_ShowServerTaskName = p_ShowServerTaskName;
            this.m_ShowComputerName = p_ShowComputerName;
            this.m_ShowServerIP = p_ShowServerIP;
            this.m_ShowServerPort = p_ShowServerPort;
        }

        private void initMembers() {
            this.m_StringBuffer = new StringBuffer();
            this.m_ShowServerTaskID = false;
            this.m_ShowComputerName = true;
            this.m_ShowServerIP = false;
            this.m_ShowServerPort = true;
            this.m_ShowServerAddition = true;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color fg = null;
            Color bg = null;
            if (value == null || !(value instanceof DetectedServer)) {
                this.setText("...");
            } else {
                String stringAddition;
                DetectedServer o_DetectedServer = (DetectedServer)value;
                InetAddress o_InetAddress = o_DetectedServer.getFirstInetAddress();
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                if (this.m_ShowServerTaskID) {
                    this.m_StringBuffer.append(o_DetectedServer.getServerTaskID());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerTaskName) {
                    this.m_StringBuffer.append(o_DetectedServer.getServerTaskName());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowComputerName) {
                    this.m_StringBuffer.append(o_DetectedServer.getComputerName());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerIP || this.m_ShowServerPort) {
                    this.m_StringBuffer.append(" (");
                    if (this.m_ShowServerIP && o_InetAddress != null) {
                        this.m_StringBuffer.append(o_InetAddress.getHostAddress());
                        this.m_StringBuffer.append("  ");
                    }
                    if (this.m_ShowServerPort) {
                        this.m_StringBuffer.append(o_DetectedServer.getPort());
                    }
                    this.m_StringBuffer.append(") ");
                }
                if (this.m_ShowServerAddition && (stringAddition = o_DetectedServer.getServerAddition()) != null && stringAddition.length() > 0) {
                    this.m_StringBuffer.append(stringAddition);
                    this.m_StringBuffer.append(" ");
                }
                this.setIcon(null);
                if (this.m_StringBuffer.length() > 2) {
                    this.m_StringBuffer.delete(this.m_StringBuffer.length() - 1, this.m_StringBuffer.length());
                }
                this.setText(this.m_StringBuffer.toString());
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                this.m_StringBuffer.append("<html>");
                ArrayList<InetAddress> o_InetAddresses = o_DetectedServer.getInetAddresses();
                for (int intAddress = 0; intAddress < o_InetAddresses.size(); ++intAddress) {
                    o_InetAddress = o_InetAddresses.get(intAddress);
                    this.m_StringBuffer.append(o_InetAddress.getHostAddress());
                    if (intAddress >= o_InetAddresses.size() - 1) continue;
                    this.m_StringBuffer.append("<br>");
                }
                this.m_StringBuffer.append("</html>");
                this.setToolTipText(this.m_StringBuffer.toString());
            }
            JTable.DropLocation dropLocation = table.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
                isSelected = true;
            }
            if (isSelected) {
                super.setForeground(fg == null ? table.getSelectionForeground() : fg);
                super.setBackground(bg == null ? table.getSelectionBackground() : bg);
            } else {
                Object alternateColor;
                Color background = table.getBackground();
                if ((background == null || background instanceof UIResource) && (alternateColor = null) != null && row % 2 == 0) {
                    background = alternateColor;
                }
                super.setForeground(table.getForeground());
                super.setBackground(background);
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(null);
            } else {
                this.setBorder(null);
            }
            return this;
        }
    }

    public static class DetectedServer_ListCellRenderer
    extends DefaultListCellRenderer {
        protected static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
        protected static final Border SELECTED_BORDER = new LineBorder(Color.BLUE, 2, true);
        private Dimension m_PreferredDimension;
        private StringBuffer m_StringBuffer;
        private boolean m_ShowServerTaskID;
        private boolean m_ShowServerTaskName;
        private boolean m_ShowComputerName;
        private boolean m_ShowServerIP;
        private boolean m_ShowServerPort;
        private boolean m_ShowServerAddition;

        public DetectedServer_ListCellRenderer() {
            this.initMembers();
        }

        public DetectedServer_ListCellRenderer(boolean p_ShowServerTaskID, boolean p_ShowServerTaskName, boolean p_ShowComputerName, boolean p_ShowServerIP, boolean p_ShowServerPort, boolean p_ShowServerAddition) {
            this.initMembers();
            this.m_ShowServerTaskID = p_ShowServerTaskID;
            this.m_ShowServerTaskName = p_ShowServerTaskName;
            this.m_ShowComputerName = p_ShowComputerName;
            this.m_ShowServerIP = p_ShowServerIP;
            this.m_ShowServerPort = p_ShowServerPort;
            this.m_ShowServerAddition = p_ShowServerAddition;
        }

        private void initMembers() {
            this.m_PreferredDimension = new Dimension(60, 28);
            this.m_StringBuffer = new StringBuffer();
            this.m_ShowServerTaskID = false;
            this.m_ShowServerTaskName = false;
            this.m_ShowComputerName = true;
            this.m_ShowServerIP = false;
            this.m_ShowServerPort = true;
            this.m_ShowServerAddition = true;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color bg = null;
            Color fg = null;
            JList.DropLocation dropLocation = list.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
                bg = Color.GRAY;
                fg = Color.BLACK;
                isSelected = true;
            }
            if (isSelected) {
                // empty if block
            }
            this.setForeground(Color.BLACK);
            this.setBackground(Color.WHITE);
            if (value == null || !(value instanceof DetectedServer)) {
                this.setText("...");
            } else {
                String stringAddition;
                DetectedServer o_DetectedServer = (DetectedServer)value;
                InetAddress o_InetAddress = o_DetectedServer.getFirstInetAddress();
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                if (this.m_ShowServerTaskID) {
                    this.m_StringBuffer.append(o_DetectedServer.getServerTaskID());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerTaskName) {
                    this.m_StringBuffer.append(o_DetectedServer.getServerTaskName());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowComputerName) {
                    this.m_StringBuffer.append(o_DetectedServer.getComputerName());
                    this.m_StringBuffer.append(" ");
                }
                if (this.m_ShowServerIP || this.m_ShowServerPort) {
                    this.m_StringBuffer.append(" (");
                    if (this.m_ShowServerIP && o_InetAddress != null) {
                        this.m_StringBuffer.append(o_InetAddress.getHostAddress());
                        this.m_StringBuffer.append("  ");
                    }
                    if (this.m_ShowServerPort) {
                        this.m_StringBuffer.append(o_DetectedServer.getPort());
                    }
                    this.m_StringBuffer.append(") ");
                }
                if (this.m_ShowServerAddition && (stringAddition = o_DetectedServer.getServerAddition()) != null && stringAddition.length() > 0) {
                    this.m_StringBuffer.append(stringAddition);
                    this.m_StringBuffer.append(" ");
                }
                this.setIcon(null);
                if (this.m_StringBuffer.length() > 2) {
                    this.m_StringBuffer.delete(this.m_StringBuffer.length() - 1, this.m_StringBuffer.length());
                }
                this.setText(this.m_StringBuffer.toString());
                this.m_StringBuffer.delete(0, this.m_StringBuffer.length());
                this.m_StringBuffer.append("<html>");
                ArrayList<InetAddress> o_InetAddresses = o_DetectedServer.getInetAddresses();
                for (int intAddress = 0; intAddress < o_InetAddresses.size(); ++intAddress) {
                    o_InetAddress = o_InetAddresses.get(intAddress);
                    this.m_StringBuffer.append(o_InetAddress.getHostAddress());
                    if (intAddress >= o_InetAddresses.size() - 1) continue;
                    this.m_StringBuffer.append("<br>");
                }
                this.m_StringBuffer.append("</html>");
                this.setToolTipText(this.m_StringBuffer.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            Border border = null;
            if (isSelected) {
                border = SELECTED_BORDER;
            }
            if (border == null) {
                border = this.getNoFocusBorder();
            }
            this.setBorder(border);
            this.setPreferredSize(this.m_PreferredDimension);
            return this;
        }

        private Border getNoFocusBorder() {
            Border border = null;
            if (System.getSecurityManager() != null) {
                if (border != null) {
                    return border;
                }
                return SAFE_NO_FOCUS_BORDER;
            }
            if (border != null && (noFocusBorder == null || noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
                return border;
            }
            return noFocusBorder;
        }
    }

    public static interface ServerAutoDetect_Listener {
        public void eventDetectedServer_Added(DetectedServer var1);

        public void eventDetectedServer_Changed(DetectedServer var1);

        public void eventDetectedServer_Removed(DetectedServer var1);
    }

    public static class DetectedServer {
        private String m_ServerID;
        private String m_ServerTaskID;
        private String m_ServerTaskName;
        private String m_ComputerName;
        private ArrayList<InetAddress> m_InetAddresses;
        private ArrayList<InetAddress> m_DetectedInetAddresses;
        private int m_Port;
        private String m_ClientIP;
        private String m_ServerAddition;
        private final Object m_SyncInetAddresses = new Object();
        private boolean m_Changed;
        private boolean m_IsNew;

        public DetectedServer(String p_ServerID, String p_ServerTaskID, String p_ServerTaskName, String p_ComputerName, int p_ServerPort, String p_ClientIP, String p_ServerAddition) {
            this.initMembers();
            this.m_ServerID = p_ServerID;
            this.m_ServerTaskID = p_ServerTaskID;
            this.m_ServerTaskName = p_ServerTaskName;
            this.m_ComputerName = p_ComputerName;
            this.m_Port = p_ServerPort;
            this.m_ClientIP = ServerAutoDetect.cleanIPAddress(p_ClientIP);
            this.m_ServerAddition = p_ServerAddition;
        }

        private void initMembers() {
            this.m_IsNew = true;
            this.m_Changed = false;
            this.m_InetAddresses = new ArrayList(4);
            this.m_DetectedInetAddresses = new ArrayList(4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void multicastZyclusStart() {
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                this.m_IsNew = false;
                this.m_InetAddresses.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void multicastZyclusEnd() {
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                this.m_Changed = false;
                if (this.m_IsNew) {
                    this.m_DetectedInetAddresses.clear();
                    this.m_DetectedInetAddresses.addAll(this.m_InetAddresses);
                    return;
                }
                if (this.m_DetectedInetAddresses.size() != this.m_InetAddresses.size()) {
                    this.m_Changed = true;
                    this.m_DetectedInetAddresses.clear();
                    if (this.m_InetAddresses.size() > 0) {
                        this.m_DetectedInetAddresses.addAll(this.m_InetAddresses);
                        return;
                    }
                    return;
                }
                if (this.m_InetAddresses.size() <= 0) {
                    this.m_Changed = true;
                    this.m_DetectedInetAddresses.clear();
                    return;
                }
                for (int intDetectedInetAddress = 0; intDetectedInetAddress < this.m_DetectedInetAddresses.size(); ++intDetectedInetAddress) {
                    InetAddress o_DetectedInetAddress = this.m_DetectedInetAddresses.get(intDetectedInetAddress);
                    boolean boolFound = false;
                    for (int intInetAddress = 0; intInetAddress < this.m_InetAddresses.size(); ++intInetAddress) {
                        InetAddress o_InetAddress = this.m_InetAddresses.get(intInetAddress);
                        if (!o_InetAddress.getHostAddress().equals(o_DetectedInetAddress.getHostAddress())) continue;
                        boolFound = true;
                        break;
                    }
                    if (boolFound) continue;
                    this.m_Changed = true;
                    break;
                }
                if (this.m_Changed) {
                    this.m_DetectedInetAddresses.clear();
                    this.m_DetectedInetAddresses.addAll(this.m_InetAddresses);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addInetAddress(InetAddress p_InetAddress) {
            if (p_InetAddress == null) {
                return;
            }
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                for (int intAddress = 0; intAddress < this.m_InetAddresses.size(); ++intAddress) {
                    InetAddress o_InetAddress = this.m_InetAddresses.get(intAddress);
                    if (o_InetAddress.getHostAddress().equals(p_InetAddress.getHostAddress())) {
                        return;
                    }
                    if (p_InetAddress.isLoopbackAddress()) {
                        this.m_InetAddresses.add(0, p_InetAddress);
                        return;
                    }
                    if (!(p_InetAddress instanceof Inet4Address) || !(o_InetAddress instanceof Inet6Address)) continue;
                    this.m_InetAddresses.add(intAddress, p_InetAddress);
                    return;
                }
                this.m_InetAddresses.add(p_InetAddress);
            }
        }

        public boolean isNew() {
            return this.m_IsNew;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean IsDetected() {
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                if (this.m_DetectedInetAddresses.size() > 0) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isChanged() {
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                return this.m_Changed;
            }
        }

        public String getServerID() {
            return this.m_ServerID;
        }

        public String getServerTaskID() {
            return this.m_ServerTaskID;
        }

        public String getServerTaskName() {
            return this.m_ServerTaskName;
        }

        public String getServerAddition() {
            return this.m_ServerAddition;
        }

        public String getComputerName() {
            return this.m_ComputerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InetAddress getFirstInetAddress() {
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                if (this.m_DetectedInetAddresses.size() <= 0) {
                    return null;
                }
                return this.m_DetectedInetAddresses.get(0);
            }
        }

        public String getFirstIP() {
            String stringIP = "";
            InetAddress o_InetAddress = this.getFirstInetAddress();
            if (o_InetAddress == null) {
                return "";
            }
            stringIP = ServerAutoDetect.cleanIPAddress(o_InetAddress.getHostAddress());
            return stringIP;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ArrayList<InetAddress> getInetAddresses() {
            ArrayList<InetAddress> o_InetAddresses;
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                o_InetAddresses = new ArrayList<InetAddress>(this.m_DetectedInetAddresses.size());
                o_InetAddresses.addAll(this.m_DetectedInetAddresses);
            }
            return o_InetAddresses;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsIP(String p_IP) {
            if (p_IP == null) {
                return false;
            }
            p_IP = p_IP.trim();
            Object object = this.m_SyncInetAddresses;
            synchronized (object) {
                for (int intInetAddress = 0; intInetAddress < this.m_DetectedInetAddresses.size(); ++intInetAddress) {
                    InetAddress o_InetAddress = this.m_DetectedInetAddresses.get(intInetAddress);
                    if (!o_InetAddress.getHostAddress().contains(p_IP)) continue;
                    return true;
                }
            }
            return false;
        }

        public int getPort() {
            return this.m_Port;
        }

        public String getClientIP() {
            return this.m_ClientIP;
        }
    }
}

