/*
 * Decompiled with CFR 0.152.
 */
package SPITClientGUI;

import SPITActionPackage.SPIT_ActionPlayer;
import SPITActionPackage.SPIT_Action_Interface;
import SPITClientGUI.jPanelActionColorRed;
import SPITClientGUI.jPanelActionColorYellow;
import SPITClientPackage.SPIT_Client;
import SPITClientPackage.SPIT_ClientSocket;
import SPITClientPackage.SPIT_Object;
import SPITClientPackage.SPIT_Type;
import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_ClientListener;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SPITRemotePackage.SPITRemote;
import SPITServerAutoDetectPackage.EventQueueHandler;
import SPITServerAutoDetectPackage.ServerAutoDetect;
import SPITServerAutoDetectPackage.ServerAutoDetect_Client;
import SwingModelPackage.RemoteSPITObjectTableModel;
import SwingModelPackage.SPIT_ObjectModel;
import SwingModelPackage.SPIT_TypeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.InetAddress;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class SPIT_ClientFrame
extends JFrame
implements SPIT_ClientListener,
ServerAutoDetect.ServerAutoDetect_Listener,
SPIT_ActionPlayer.TimeCodeListener,
SPIT_Type_Interface.SPIT_Type_Listener,
SPIT_Object_Interface.SPIT_Object_Listener {
    private ServerAutoDetect_Client m_ServerAutoDetect_Client;
    private SPIT_Client m_Spit_Client;
    private boolean m_ConnectionLost;
    private String m_SPITServer_ProjectName;
    private SPIT_Action_Interface m_SelectedSPIT_Action_Interface;
    private Border m_SelectedBorder = new LineBorder(Color.BLUE, 2);
    private JButton jButton_AddSPITType;
    private JButton jButton_AdviseAction;
    private JButton jButton_Connect;
    private JButton jButton_Disconnect;
    private JButton jButton_RemotePlay;
    private JButton jButton_RemoteValueMinus;
    private JButton jButton_RemoteValuePlus;
    private JButton jButton_RemoveSPITObject;
    private JButton jButton_RemoveSPITType;
    private JComboBox<String> jComboBox_DetectedServer;
    private JLabel jLabel_Actions;
    private JLabel jLabel_PlayerNameHeader;
    private JLabel jLabel_SPIT_ObjectHeader;
    private JLabel jLabel_SPIT_ObjectHeader1;
    private JLabel jLabel_SPIT_TypeHeader;
    private JLabel jLabel_ServerComputerName;
    private JLabel jLabel_ServerHeader;
    private JLabel jLabel_ServerName;
    private JLabel jLabel_ServerProjectName;
    private JLabel jLabel_TimeCode;
    private JPanel jPanel1;
    private jPanelActionColorRed jPanelActionRed;
    private jPanelActionColorYellow jPanelActionYellow;
    private JPanel jPanel_Frame;
    private JPanel jPanel_Project;
    private JPanel jPanel_SPITActions;
    private JPanel jPanel_Server;
    private JPanel jPanel_ServerRemote;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane_Objects;
    private JScrollPane jScrollPane_Types;
    private JTabbedPane jTabbedPane1;
    private JTable jTable_Remote_SPITObjects;
    private JTable jTable_SPITObjects;
    private JTable jTable_SPITTypes;

    public SPIT_ClientFrame() {
        this.initMembers();
        this.initComponents();
        this.initComponentsFurther();
        SPIT_Type.addSPIT_Type_Listener(this);
        SPIT_Object.addSPIT_Object_Listener(this);
        this.m_ServerAutoDetect_Client.startDetection(this);
        this.refreshGUI();
    }

    private void initMembers() {
        this.m_ServerAutoDetect_Client = new ServerAutoDetect_Client("#spit#");
        this.m_ServerAutoDetect_Client.addServerAutoDetectListener(this);
        this.m_Spit_Client = new SPIT_Client("SPIT_TestClient");
        this.m_Spit_Client.addSPITClientListener(this);
        this.m_SPITServer_ProjectName = "";
        SPIT_ActionPlayer.addTimeCodeListener(this);
        this.m_SelectedSPIT_Action_Interface = null;
        this.m_ConnectionLost = false;
    }

    private void initComponents() {
        this.jPanel_Frame = new JPanel();
        this.jPanel_Server = new JPanel();
        this.jLabel_ServerHeader = new JLabel();
        this.jLabel_ServerProjectName = new JLabel();
        this.jLabel_ServerComputerName = new JLabel();
        this.jLabel_ServerName = new JLabel();
        this.jComboBox_DetectedServer = new JComboBox();
        this.jButton_Connect = new JButton();
        this.jButton_Disconnect = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel_Project = new JPanel();
        this.jButton_AddSPITType = new JButton();
        this.jScrollPane_Types = new JScrollPane();
        this.jTable_SPITTypes = new JTable();
        this.jButton_RemoveSPITType = new JButton();
        this.jScrollPane_Objects = new JScrollPane();
        this.jTable_SPITObjects = new JTable();
        this.jLabel_SPIT_TypeHeader = new JLabel();
        this.jLabel_SPIT_ObjectHeader = new JLabel();
        this.jButton_RemoveSPITObject = new JButton();
        this.jPanel_ServerRemote = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.jTable_Remote_SPITObjects = new JTable();
        this.jLabel_SPIT_ObjectHeader1 = new JLabel();
        this.jButton_RemotePlay = new JButton();
        this.jButton_RemoteValuePlus = new JButton();
        this.jButton_RemoteValueMinus = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel_TimeCode = new JLabel();
        this.jLabel_PlayerNameHeader = new JLabel();
        this.jPanel_SPITActions = new JPanel();
        this.jPanelActionRed = new jPanelActionColorRed();
        this.jPanelActionYellow = new jPanelActionColorYellow();
        this.jLabel_Actions = new JLabel();
        this.jButton_AdviseAction = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("SPITTestClient");
        this.setMinimumSize(new Dimension(600, 500));
        this.setPreferredSize(new Dimension(600, 600));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SPIT_ClientFrame.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel_Frame.setBackground(new Color(0, 0, 0));
        this.jPanel_Frame.setLayout(new GridBagLayout());
        this.jPanel_Server.setBackground(new Color(0, 0, 0));
        this.jPanel_Server.setLayout(new GridBagLayout());
        this.jLabel_ServerHeader.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_ServerHeader.setForeground(new Color(255, 255, 255));
        this.jLabel_ServerHeader.setText("Server");
        this.jLabel_ServerHeader.setToolTipText("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add((Component)this.jLabel_ServerHeader, gridBagConstraints);
        this.jLabel_ServerProjectName.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_ServerProjectName.setForeground(new Color(255, 255, 255));
        this.jLabel_ServerProjectName.setHorizontalAlignment(0);
        this.jLabel_ServerProjectName.setText("Server's Project");
        this.jLabel_ServerProjectName.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add((Component)this.jLabel_ServerProjectName, gridBagConstraints);
        this.jLabel_ServerComputerName.setForeground(new Color(255, 255, 255));
        this.jLabel_ServerComputerName.setText("ServerComputerName");
        this.jLabel_ServerComputerName.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add((Component)this.jLabel_ServerComputerName, gridBagConstraints);
        this.jLabel_ServerName.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_ServerName.setForeground(new Color(255, 255, 255));
        this.jLabel_ServerName.setText("ServerName");
        this.jLabel_ServerName.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add((Component)this.jLabel_ServerName, gridBagConstraints);
        this.jComboBox_DetectedServer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_DetectedServer.setMinimumSize(new Dimension(56, 24));
        this.jComboBox_DetectedServer.setName("");
        this.jComboBox_DetectedServer.setPreferredSize(new Dimension(56, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add(this.jComboBox_DetectedServer, gridBagConstraints);
        this.jButton_Connect.setBackground(new Color(0, 0, 0));
        this.jButton_Connect.setText("Connect to Server");
        this.jButton_Connect.setToolTipText("");
        this.jButton_Connect.setBorder(new LineBorder(new Color(51, 255, 51), 1, true));
        this.jButton_Connect.setMaximumSize(new Dimension(100, 24));
        this.jButton_Connect.setMinimumSize(new Dimension(100, 24));
        this.jButton_Connect.setPreferredSize(new Dimension(100, 24));
        this.jButton_Connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SPIT_ClientFrame.this.jButton_ConnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add((Component)this.jButton_Connect, gridBagConstraints);
        this.jButton_Disconnect.setBackground(new Color(0, 0, 0));
        this.jButton_Disconnect.setText("Disconect");
        this.jButton_Disconnect.setToolTipText("");
        this.jButton_Disconnect.setBorder(new LineBorder(new Color(255, 51, 0), 1, true));
        this.jButton_Disconnect.setMaximumSize(new Dimension(100, 24));
        this.jButton_Disconnect.setMinimumSize(new Dimension(100, 24));
        this.jButton_Disconnect.setPreferredSize(new Dimension(100, 24));
        this.jButton_Disconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SPIT_ClientFrame.this.jButton_DisconnectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Server.add((Component)this.jButton_Disconnect, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel_Frame.add((Component)this.jPanel_Server, gridBagConstraints);
        this.jTabbedPane1.setBackground(new Color(0, 0, 0));
        this.jTabbedPane1.setMinimumSize(new Dimension(100, 100));
        this.jTabbedPane1.setPreferredSize(new Dimension(200, 250));
        this.jPanel_Project.setBackground(new Color(0, 0, 0));
        this.jPanel_Project.setPreferredSize(new Dimension(650, 500));
        this.jPanel_Project.setLayout(new GridBagLayout());
        this.jButton_AddSPITType.setText("+");
        this.jButton_AddSPITType.setToolTipText("Add SPIT Type");
        this.jButton_AddSPITType.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_AddSPITType.setMaximumSize(new Dimension(41, 41));
        this.jButton_AddSPITType.setMinimumSize(new Dimension(41, 41));
        this.jButton_AddSPITType.setPreferredSize(new Dimension(41, 41));
        this.jButton_AddSPITType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SPIT_ClientFrame.this.jButton_AddSPITTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Project.add((Component)this.jButton_AddSPITType, gridBagConstraints);
        this.jTable_SPITTypes.setFont(new Font("Tahoma", 0, 14));
        this.jTable_SPITTypes.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_SPITTypes.setRowHeight(20);
        this.jScrollPane_Types.setViewportView(this.jTable_SPITTypes);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Project.add((Component)this.jScrollPane_Types, gridBagConstraints);
        this.jButton_RemoveSPITType.setText("-");
        this.jButton_RemoveSPITType.setToolTipText("Remove selected SPIT Types");
        this.jButton_RemoveSPITType.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_RemoveSPITType.setMaximumSize(new Dimension(41, 41));
        this.jButton_RemoveSPITType.setMinimumSize(new Dimension(41, 41));
        this.jButton_RemoveSPITType.setPreferredSize(new Dimension(41, 41));
        this.jButton_RemoveSPITType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SPIT_ClientFrame.this.jButton_RemoveSPITTypeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Project.add((Component)this.jButton_RemoveSPITType, gridBagConstraints);
        this.jTable_SPITObjects.setFont(new Font("Tahoma", 0, 14));
        this.jTable_SPITObjects.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_SPITObjects.setRowHeight(20);
        this.jScrollPane_Objects.setViewportView(this.jTable_SPITObjects);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.7;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Project.add((Component)this.jScrollPane_Objects, gridBagConstraints);
        this.jLabel_SPIT_TypeHeader.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_SPIT_TypeHeader.setForeground(new Color(255, 255, 255));
        this.jLabel_SPIT_TypeHeader.setText("SPIT_Types");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Project.add((Component)this.jLabel_SPIT_TypeHeader, gridBagConstraints);
        this.jLabel_SPIT_ObjectHeader.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_SPIT_ObjectHeader.setForeground(new Color(255, 255, 255));
        this.jLabel_SPIT_ObjectHeader.setText("SPIT_Objects");
        this.jLabel_SPIT_ObjectHeader.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Project.add((Component)this.jLabel_SPIT_ObjectHeader, gridBagConstraints);
        this.jButton_RemoveSPITObject.setText("-");
        this.jButton_RemoveSPITObject.setToolTipText("Remove selected SPIT Object");
        this.jButton_RemoveSPITObject.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_RemoveSPITObject.setMaximumSize(new Dimension(41, 41));
        this.jButton_RemoveSPITObject.setMinimumSize(new Dimension(41, 41));
        this.jButton_RemoveSPITObject.setPreferredSize(new Dimension(41, 41));
        this.jButton_RemoveSPITObject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SPIT_ClientFrame.this.jButton_RemoveSPITObjectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Project.add((Component)this.jButton_RemoveSPITObject, gridBagConstraints);
        this.jTabbedPane1.addTab("Client", this.jPanel_Project);
        this.jPanel_ServerRemote.setBackground(new Color(0, 0, 0));
        this.jPanel_ServerRemote.setLayout(new GridBagLayout());
        this.jTable_Remote_SPITObjects.setFont(new Font("Tahoma", 0, 14));
        this.jTable_Remote_SPITObjects.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable_Remote_SPITObjects.setRowHeight(20);
        this.jTable_Remote_SPITObjects.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.jTable_Remote_SPITObjects);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_ServerRemote.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabel_SPIT_ObjectHeader1.setFont(new Font("Tahoma", 1, 11));
        this.jLabel_SPIT_ObjectHeader1.setForeground(new Color(255, 255, 255));
        this.jLabel_SPIT_ObjectHeader1.setText("REMOTE");
        this.jLabel_SPIT_ObjectHeader1.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_ServerRemote.add((Component)this.jLabel_SPIT_ObjectHeader1, gridBagConstraints);
        this.jButton_RemotePlay.setText("Play Remote");
        this.jButton_RemotePlay.setToolTipText("Play selected Remote Object");
        this.jButton_RemotePlay.setMargin(new Insets(14, 14, 14, 14));
        this.jButton_RemotePlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SPIT_ClientFrame.this.jButton_RemotePlayActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_ServerRemote.add((Component)this.jButton_RemotePlay, gridBagConstraints);
        this.jButton_RemoteValuePlus.setText("+");
        this.jButton_RemoteValuePlus.setToolTipText("Decrease Value");
        this.jButton_RemoteValuePlus.setMargin(new Insets(14, 14, 14, 14));
        this.jButton_RemoteValuePlus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SPIT_ClientFrame.this.jButton_RemoteValuePlusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        this.jPanel_ServerRemote.add((Component)this.jButton_RemoteValuePlus, gridBagConstraints);
        this.jButton_RemoteValueMinus.setText("-");
        this.jButton_RemoteValueMinus.setToolTipText("Increase Value");
        this.jButton_RemoteValueMinus.setMargin(new Insets(14, 14, 14, 14));
        this.jButton_RemoteValueMinus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SPIT_ClientFrame.this.jButton_RemoteValueMinusActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.jPanel_ServerRemote.add((Component)this.jButton_RemoteValueMinus, gridBagConstraints);
        this.jTabbedPane1.addTab("Server Remote", this.jPanel_ServerRemote);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Frame.add((Component)this.jTabbedPane1, gridBagConstraints);
        this.jPanel1.setBackground(new Color(0, 0, 0));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel_TimeCode.setFont(new Font("Tahoma", 0, 14));
        this.jLabel_TimeCode.setForeground(new Color(255, 255, 255));
        this.jLabel_TimeCode.setHorizontalAlignment(0);
        this.jLabel_TimeCode.setText("---");
        this.jLabel_TimeCode.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_TimeCode, gridBagConstraints);
        this.jLabel_PlayerNameHeader.setForeground(new Color(255, 255, 255));
        this.jLabel_PlayerNameHeader.setText("Player");
        this.jLabel_PlayerNameHeader.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel1.add((Component)this.jLabel_PlayerNameHeader, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.jPanel_Frame.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel_SPITActions.setBackground(new Color(51, 51, 51));
        this.jPanel_SPITActions.setMinimumSize(new Dimension(200, 10));
        this.jPanel_SPITActions.setPreferredSize(new Dimension(200, 100));
        this.jPanel_SPITActions.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_SPITActions.add((Component)this.jPanelActionRed, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_SPITActions.add((Component)this.jPanelActionYellow, gridBagConstraints);
        this.jLabel_Actions.setForeground(new Color(255, 255, 255));
        this.jLabel_Actions.setText("Actions");
        this.jLabel_Actions.setToolTipText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_SPITActions.add((Component)this.jLabel_Actions, gridBagConstraints);
        this.jButton_AdviseAction.setText("<-");
        this.jButton_AdviseAction.setToolTipText("Advise selected action to SPIT_Object");
        this.jButton_AdviseAction.setMargin(new Insets(2, 2, 2, 2));
        this.jButton_AdviseAction.setMaximumSize(new Dimension(41, 41));
        this.jButton_AdviseAction.setMinimumSize(new Dimension(41, 41));
        this.jButton_AdviseAction.setPreferredSize(new Dimension(41, 41));
        this.jButton_AdviseAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SPIT_ClientFrame.this.jButton_AdviseActionActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_SPITActions.add((Component)this.jButton_AdviseAction, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel_Frame.add((Component)this.jPanel_SPITActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel_Frame, gridBagConstraints);
        this.pack();
    }

    private void initComponentsFurther() {
        ComboBoxModel<ServerAutoDetect.DetectedServer> o_ListModel = this.m_ServerAutoDetect_Client.getDetectedServerListModel();
        this.jComboBox_DetectedServer.setModel(o_ListModel);
        this.jComboBox_DetectedServer.setRenderer(this.m_ServerAutoDetect_Client.getDetectedServer_CellRenderer());
        this.jTable_SPITTypes.setModel(SPIT_Type.s_SPIT_TypeModel);
        SPIT_Type.s_SPIT_TypeModel.finishJTable(this.jTable_SPITTypes);
        this.jTable_SPITTypes.setDefaultRenderer(String.class, new SPIT_TypeModel.SPITTypeTableCellRenderer(14));
        this.jTable_SPITTypes.getColumnModel().getColumn(0).getClass();
        this.jTable_SPITTypes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SPIT_ClientFrame.this.refreshGUI();
            }
        });
        this.jTable_SPITObjects.setModel(SPIT_Object.s_SPIT_ObjectModel);
        SPIT_Object.s_SPIT_ObjectModel.finishJTable(this.jTable_SPITObjects);
        this.jTable_SPITObjects.setDefaultRenderer(String.class, new SPIT_ObjectModel.SPITObjectTableCellRenderer(14));
        this.jTable_SPITObjects.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SPIT_ClientFrame.this.refreshGUI();
            }
        });
        this.jTable_Remote_SPITObjects.setModel(SPITRemote.s_RemoteSPITObjectModel);
        SPITRemote.s_RemoteSPITObjectModel.finishJTable(this.jTable_Remote_SPITObjects);
        this.jTable_Remote_SPITObjects.setDefaultRenderer(String.class, new RemoteSPITObjectTableModel.RemoteSPITObjectCellRenderer(14));
        this.jTable_Remote_SPITObjects.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                SPIT_ClientFrame.this.refreshGUI();
            }
        });
        this.jPanelActionRed.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SPIT_ClientFrame.this.setSelectedAction(SPIT_ClientFrame.this.jPanelActionRed);
            }
        });
        this.jPanelActionYellow.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SPIT_ClientFrame.this.setSelectedAction(SPIT_ClientFrame.this.jPanelActionYellow);
            }
        });
    }

    public void setSelectedAction(SPIT_Action_Interface p_SPIT_Action_Interface) {
        this.m_SelectedSPIT_Action_Interface = p_SPIT_Action_Interface == null ? null : (this.m_SelectedSPIT_Action_Interface == p_SPIT_Action_Interface ? null : p_SPIT_Action_Interface);
        this.refreshGUI();
    }

    public boolean connect(ServerAutoDetect.DetectedServer p_DetectedServer, int p_ClientPort, String p_LoginName, String p_LoginPassword) {
        if (p_DetectedServer == null) {
            return false;
        }
        SPIT_Client o_SPIT_Client = this.m_Spit_Client;
        if (o_SPIT_Client == null) {
            return false;
        }
        InetAddress o_ServerInetAddress = p_DetectedServer.getFirstInetAddress();
        int intServerPort = p_DetectedServer.getPort();
        this.m_ConnectionLost = false;
        return o_SPIT_Client.connect(o_ServerInetAddress, intServerPort, p_ClientPort, p_LoginName, p_LoginPassword);
    }

    public boolean disconnect() {
        SPIT_Client o_SPIT_Client = this.m_Spit_Client;
        if (o_SPIT_Client == null) {
            return false;
        }
        o_SPIT_Client.disconnect(false);
        this.refreshGUI();
        return true;
    }

    public void refreshGUI() {
        SPIT_Object_Interface o_SPIT_Object_Interface;
        String stringServerIP = "";
        String stringServerPort = "";
        SPIT_Client o_SPIT_Client = this.m_Spit_Client;
        if (o_SPIT_Client != null) {
            if (o_SPIT_Client.isConnected()) {
                this.jButton_Connect.setEnabled(false);
                this.jButton_Disconnect.setEnabled(true);
                SPIT_ClientSocket o_SPIT_ClientSocket = this.m_Spit_Client.getSPIT_ClientSocket();
                if (o_SPIT_ClientSocket != null) {
                    InetAddress o_InetAddress = o_SPIT_ClientSocket.getServerInetAddress();
                    if (o_InetAddress != null) {
                        stringServerIP = SPIT_Client.cleanIPAddress(o_InetAddress.getHostAddress());
                    }
                    stringServerPort = String.valueOf(o_SPIT_ClientSocket.getServerPort());
                }
                this.jLabel_ServerComputerName.setText(o_SPIT_Client.getServerComputerName() + "(" + stringServerIP + " " + stringServerPort + ")");
                this.jLabel_ServerName.setText(o_SPIT_Client.getServerName());
            } else {
                this.jButton_Connect.setEnabled(true);
                this.jButton_Disconnect.setEnabled(false);
                this.jLabel_ServerComputerName.setText("-");
                this.jLabel_ServerName.setText("-");
            }
        } else {
            this.jButton_Connect.setEnabled(false);
            this.jButton_Disconnect.setEnabled(false);
        }
        this.jLabel_ServerProjectName.setText(this.m_SPITServer_ProjectName);
        int intSelectedRowCount = this.jTable_SPITTypes.getSelectedRowCount();
        if (intSelectedRowCount <= 0) {
            this.jButton_RemoveSPITType.setEnabled(false);
        } else {
            this.jButton_RemoveSPITType.setEnabled(true);
        }
        if (this.jTable_SPITObjects.getSelectedRowCount() == 1) {
            this.jButton_AdviseAction.setEnabled(true);
        } else {
            this.jButton_AdviseAction.setEnabled(false);
        }
        if (this.m_SelectedSPIT_Action_Interface == null) {
            this.jPanelActionRed.setBorder(null);
            this.jPanelActionYellow.setBorder(null);
        } else if (this.m_SelectedSPIT_Action_Interface == this.jPanelActionRed) {
            this.jPanelActionRed.setBorder(this.m_SelectedBorder);
            this.jPanelActionYellow.setBorder(null);
        } else {
            this.jPanelActionRed.setBorder(null);
            this.jPanelActionYellow.setBorder(this.m_SelectedBorder);
        }
        int intRow = this.jTable_Remote_SPITObjects.getSelectedRow();
        if (intRow < 0) {
            o_SPIT_Object_Interface = null;
        } else {
            try {
                intRow = this.jTable_Remote_SPITObjects.convertRowIndexToModel(intRow);
                o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object(intRow);
            }
            catch (Exception e) {
                o_SPIT_Object_Interface = null;
            }
        }
        if (o_SPIT_Object_Interface == null) {
            this.jButton_RemotePlay.setVisible(true);
            this.jButton_RemotePlay.setEnabled(false);
            this.jButton_RemoteValueMinus.setVisible(false);
            this.jButton_RemoteValuePlus.setVisible(false);
        } else if (o_SPIT_Object_Interface.getValueUse() == 0) {
            this.jButton_RemotePlay.setVisible(true);
            this.jButton_RemotePlay.setEnabled(true);
            this.jButton_RemoteValueMinus.setVisible(false);
            this.jButton_RemoteValuePlus.setVisible(false);
        } else {
            this.jButton_RemotePlay.setVisible(false);
            this.jButton_RemotePlay.setEnabled(false);
            this.jButton_RemoteValueMinus.setVisible(true);
            this.jButton_RemoteValuePlus.setVisible(true);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        SPIT_Client o_SPIT_Client = this.m_Spit_Client;
        SPIT_ActionPlayer.removeTimeCodeListener(this);
        if (o_SPIT_Client != null) {
            o_SPIT_Client.close();
        }
        this.m_ServerAutoDetect_Client.removeServerAutoDetectListener(this);
        this.m_ServerAutoDetect_Client.stopDetection(this);
    }

    private void jButton_ConnectActionPerformed(ActionEvent evt) {
        SPIT_Client o_Spit_Client = this.m_Spit_Client;
        if (o_Spit_Client == null) {
            return;
        }
        ServerAutoDetect.DetectedServer o_DetectedServer = (ServerAutoDetect.DetectedServer)this.jComboBox_DetectedServer.getSelectedItem();
        if (o_DetectedServer == null) {
            return;
        }
        this.connect(o_DetectedServer, 0, "", "");
    }

    private void jButton_AddSPITTypeActionPerformed(ActionEvent evt) {
        SPIT_Client o_Spit_Client = this.m_Spit_Client;
        if (o_Spit_Client == null) {
            return;
        }
        SPIT_Type o_SPIT_Type = new SPIT_Type();
        SPIT_Type.addSPIT_Type(o_SPIT_Type, o_Spit_Client);
    }

    private void jButton_RemoveSPITTypeActionPerformed(ActionEvent evt) {
        SPIT_Client o_Spit_Client = this.m_Spit_Client;
        if (o_Spit_Client == null) {
            return;
        }
        int[] o_SelectedRows = this.jTable_SPITTypes.getSelectedRows();
        for (int intSelectedRow = o_SelectedRows.length - 1; intSelectedRow >= 0; --intSelectedRow) {
            SPIT_Type_Interface o_SPIT_Type_Interface;
            int intRow = o_SelectedRows[intSelectedRow];
            try {
                intRow = this.jTable_SPITTypes.convertRowIndexToModel(intRow);
                o_SPIT_Type_Interface = SPIT_Type.getSPIT_Type(intRow);
            }
            catch (Exception e) {
                o_SPIT_Type_Interface = null;
            }
            if (o_SPIT_Type_Interface == null) {
                return;
            }
            if (o_SPIT_Type_Interface.getFixed()) {
                return;
            }
            SPIT_Type.removeSPIT_Type(o_SPIT_Type_Interface, o_Spit_Client);
        }
    }

    private void jButton_RemotePlayActionPerformed(ActionEvent evt) {
        SPIT_Object_Interface o_SPIT_Object_Interface;
        int intRow = this.jTable_Remote_SPITObjects.getSelectedRow();
        if (intRow < 0) {
            return;
        }
        try {
            intRow = this.jTable_Remote_SPITObjects.convertRowIndexToModel(intRow);
            o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object(intRow);
        }
        catch (Exception e) {
            o_SPIT_Object_Interface = null;
        }
        if (o_SPIT_Object_Interface == null) {
            return;
        }
        SPITRemote.playClientRemoteSPIT_Object(this.m_Spit_Client, o_SPIT_Object_Interface);
    }

    private void jButton_RemoteValuePlusActionPerformed(ActionEvent evt) {
        SPIT_Object_Interface o_SPIT_Object_Interface;
        int intRow = this.jTable_Remote_SPITObjects.getSelectedRow();
        if (intRow < 0) {
            return;
        }
        try {
            intRow = this.jTable_Remote_SPITObjects.convertRowIndexToModel(intRow);
            o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object(intRow);
        }
        catch (Exception e) {
            o_SPIT_Object_Interface = null;
        }
        if (o_SPIT_Object_Interface == null) {
            return;
        }
        SPITRemote.playClientRemoteSPIT_Object(this.m_Spit_Client, o_SPIT_Object_Interface, 50000, true);
    }

    private void jButton_RemoteValueMinusActionPerformed(ActionEvent evt) {
        SPIT_Object_Interface o_SPIT_Object_Interface;
        int intRow = this.jTable_Remote_SPITObjects.getSelectedRow();
        if (intRow < 0) {
            return;
        }
        try {
            intRow = this.jTable_Remote_SPITObjects.convertRowIndexToModel(intRow);
            o_SPIT_Object_Interface = SPITRemote.getRemoteSPIT_Object(intRow);
        }
        catch (Exception e) {
            o_SPIT_Object_Interface = null;
        }
        if (o_SPIT_Object_Interface == null) {
            return;
        }
        SPITRemote.playClientRemoteSPIT_Object(this.m_Spit_Client, o_SPIT_Object_Interface, 50000, false);
    }

    private void jButton_AdviseActionActionPerformed(ActionEvent evt) {
        SPIT_Object_Interface o_SPIT_Object_Interface;
        if (this.jTable_SPITObjects.getSelectedRowCount() != 1) {
            return;
        }
        int intRow = this.jTable_SPITObjects.getSelectedRow();
        if (intRow < 0) {
            return;
        }
        try {
            intRow = this.jTable_SPITObjects.convertRowIndexToModel(intRow);
            o_SPIT_Object_Interface = SPIT_Object.getSPIT_Object(intRow);
        }
        catch (Exception e) {
            o_SPIT_Object_Interface = null;
        }
        if (o_SPIT_Object_Interface == null) {
            return;
        }
        o_SPIT_Object_Interface.setSPIT_Action_Interface(this.m_SelectedSPIT_Action_Interface, null);
    }

    private void jButton_DisconnectActionPerformed(ActionEvent evt) {
        this.disconnect();
    }

    private void jButton_RemoveSPITObjectActionPerformed(ActionEvent evt) {
        SPIT_Client o_Spit_Client = this.m_Spit_Client;
        if (o_Spit_Client == null) {
            return;
        }
        int[] o_SelectedRows = this.jTable_SPITObjects.getSelectedRows();
        for (int intSelectedRow = o_SelectedRows.length - 1; intSelectedRow >= 0; --intSelectedRow) {
            SPIT_Object_Interface o_SPIT_Object_Interface;
            int intRow = o_SelectedRows[intSelectedRow];
            try {
                intRow = this.jTable_SPITObjects.convertRowIndexToModel(intRow);
                o_SPIT_Object_Interface = SPIT_Object.getSPIT_Object(intRow);
            }
            catch (Exception e) {
                o_SPIT_Object_Interface = null;
            }
            if (o_SPIT_Object_Interface == null) {
                return;
            }
            if (o_SPIT_Object_Interface.getFixed()) {
                return;
            }
            SPIT_Object.removeSPIT_Object(o_SPIT_Object_Interface, o_Spit_Client);
        }
    }

    @Override
    public void eventServer_SPITProject(SPIT_ClientInterface p_SPIT_Client) {
        if (p_SPIT_Client == null) {
            return;
        }
        this.m_SPITServer_ProjectName = p_SPIT_Client.getServerProjectName();
        this.refreshGUI();
    }

    @Override
    public void eventServer_SPITProject_Closed(SPIT_ClientInterface p_SPIT_Client) {
        if (p_SPIT_Client == null) {
            return;
        }
        this.m_SPITServer_ProjectName = "";
        this.refreshGUI();
    }

    @Override
    public void eventServer_SPITProject_TransferStart(SPIT_ClientInterface p_SPIT_Client) {
        if (p_SPIT_Client == null) {
            return;
        }
    }

    @Override
    public void eventServer_SPITProject_TransferEnd(SPIT_ClientInterface p_SPIT_Client) {
        if (p_SPIT_Client == null) {
            return;
        }
    }

    @Override
    public void eventConnected(SPIT_ClientInterface p_SPIT_Client) {
        this.m_ConnectionLost = false;
        this.refreshGUI();
        this.m_ServerAutoDetect_Client.stopDetection(this);
    }

    @Override
    public void eventDisconnected(SPIT_ClientInterface p_SPIT_Client, boolean p_ConnectionLost) {
        this.m_ConnectionLost = p_ConnectionLost;
        this.refreshGUI();
        this.m_ServerAutoDetect_Client.startDetection(this);
    }

    @Override
    public void eventTimeCode(long p_PlayFrame, long FramesOerSecond) {
        this.jLabel_TimeCode.setText(String.valueOf(p_PlayFrame));
    }

    @Override
    public void eventSPIT_Type_Added(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return;
        }
    }

    @Override
    public void eventSPIT_Type_Changed(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return;
        }
    }

    @Override
    public void eventSPIT_Type_Removed(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return;
        }
    }

    @Override
    public void eventRemoteSPIT_Type_Added(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return;
        }
    }

    @Override
    public void eventRemoteSPIT_Type_Changed(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return;
        }
    }

    @Override
    public void eventRemoteSPIT_Type_Removed(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return;
        }
    }

    @Override
    public void eventSPIT_Object_Added(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
    }

    @Override
    public void eventSPIT_Object_Changed(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
    }

    @Override
    public void eventSPIT_Object_Removed(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
    }

    @Override
    public void eventRemoteSPIT_Object_Added(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
    }

    @Override
    public void eventRemoteSPIT_Object_Changed(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
    }

    @Override
    public void eventRemoteSPIT_Object_Removed(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return;
        }
    }

    @Override
    public void eventDetectedServer_Added(ServerAutoDetect.DetectedServer p_DetectedServer) {
        if (this.m_ServerAutoDetect_Client.getDetectedServerCount() == 1) {
            final ServerAutoDetect.DetectedServer o_DetectedServer = this.m_ServerAutoDetect_Client.getDetectedServer(0);
            EventQueueHandler.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SPIT_ClientFrame.this.jComboBox_DetectedServer.setSelectedItem(o_DetectedServer);
                    SPIT_ClientFrame.this.revalidate();
                    SPIT_ClientFrame.this.repaint();
                }
            });
        } else {
            EventQueueHandler.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SPIT_ClientFrame.this.jComboBox_DetectedServer.setSelectedItem(null);
                    SPIT_ClientFrame.this.revalidate();
                    SPIT_ClientFrame.this.repaint();
                }
            });
        }
    }

    @Override
    public void eventDetectedServer_Changed(ServerAutoDetect.DetectedServer p_DetectedServer) {
    }

    @Override
    public void eventDetectedServer_Removed(ServerAutoDetect.DetectedServer p_DetectedServer) {
        if (this.m_ServerAutoDetect_Client.getDetectedServerCount() == 1) {
            final ServerAutoDetect.DetectedServer o_DetectedServer = this.m_ServerAutoDetect_Client.getDetectedServer(0);
            EventQueueHandler.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SPIT_ClientFrame.this.jComboBox_DetectedServer.setSelectedItem(o_DetectedServer);
                    SPIT_ClientFrame.this.revalidate();
                    SPIT_ClientFrame.this.repaint();
                }
            });
        } else if (this.m_ServerAutoDetect_Client.getDetectedServerCount() <= 0) {
            EventQueueHandler.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SPIT_ClientFrame.this.jComboBox_DetectedServer.setSelectedItem(null);
                    SPIT_ClientFrame.this.revalidate();
                    SPIT_ClientFrame.this.repaint();
                }
            });
        }
    }
}

