/*
 * Decompiled with CFR 0.152.
 */
package SPITClientPackage;

import SPITClientPackage.SPIT_Client;
import SPITLibraryPackage.SPIT_Message;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;

public class SPIT_ClientSocket {
    public static boolean s_DEBUGON = true;
    private SPIT_Client m_SPITClient;
    private DatagramSocket m_DatagramSocket;
    private InetAddress m_ServerInetAddress;
    private int m_ServerPort;
    private Runnable m_RunnableReceive;
    private boolean m_StopReceive;
    private Thread m_ThreadReceive;
    private final Object m_Sync = new Object();

    public SPIT_ClientSocket(SPIT_Client p_SPITClient) {
        this.initMembers();
        this.m_SPITClient = p_SPITClient;
    }

    private void initMembers() {
        this.m_DatagramSocket = null;
        this.m_ServerInetAddress = null;
        this.m_ServerPort = 0;
        this.initRunnableReceive();
    }

    public boolean connect(InetAddress p_ServerInetAddress, int p_ServerPort, int p_ClientPort, String p_LoginName, String p_LoginPassword) {
        if (p_ServerInetAddress == null) {
            return false;
        }
        if (p_ServerPort < 0 || p_ServerPort > 65535) {
            return false;
        }
        if (p_ClientPort > 65535) {
            return false;
        }
        this.disconnect();
        SPIT_Client o_SPIT_Client = this.m_SPITClient;
        if (o_SPIT_Client == null) {
            return false;
        }
        try {
            this.m_ServerInetAddress = p_ServerInetAddress;
            this.m_ServerPort = p_ServerPort;
            this.m_DatagramSocket = p_ClientPort <= 0 ? new DatagramSocket() : new DatagramSocket(p_ServerPort);
        }
        catch (Exception e) {
            this.m_ServerInetAddress = null;
            this.m_ServerPort = 0;
            this.m_DatagramSocket = null;
            System.out.println("SPIT_ClientSocket connect ERROR: " + e.getMessage());
            return false;
        }
        try {
            this.m_DatagramSocket.setSendBufferSize(131072);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_StopReceive = false;
        this.m_ThreadReceive = new Thread(this.m_RunnableReceive);
        this.m_ThreadReceive.start();
        SPIT_Message o_SPIT_Message = SPIT_Message.createConnect(o_SPIT_Client.getClientComputerName(), o_SPIT_Client.getName(), p_LoginName, p_LoginPassword, SPIT_Client.cleanIPAddress(this.m_ServerInetAddress.getHostAddress()), this.m_ServerPort);
        return SPIT_Client.sendMessage(o_SPIT_Message);
    }

    public boolean disconnect() {
        this.m_StopReceive = true;
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return true;
        }
        if (o_DatagramSocket.isClosed()) {
            this.m_DatagramSocket = null;
            return true;
        }
        boolean boolOK = this.sendDisconnect();
        o_DatagramSocket.close();
        this.m_DatagramSocket = null;
        return boolOK;
    }

    private void initRunnableReceive() {
        this.m_RunnableReceive = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                byte[] o_BytesReceived = new byte[512];
                while (!SPIT_ClientSocket.this.m_StopReceive) {
                    Object object = SPIT_ClientSocket.this.m_Sync;
                    synchronized (object) {
                        if (SPIT_ClientSocket.this.m_DatagramSocket == null || SPIT_ClientSocket.this.m_DatagramSocket.isClosed()) {
                            SPIT_ClientSocket.this.m_StopReceive = true;
                            continue;
                        }
                    }
                    DatagramPacket o_DatagramPacket = new DatagramPacket(o_BytesReceived, o_BytesReceived.length);
                    try {
                        SPIT_ClientSocket.this.m_DatagramSocket.receive(o_DatagramPacket);
                    }
                    catch (SocketTimeoutException e_SocketTimeoutException) {
                        o_DatagramPacket = null;
                        continue;
                    }
                    catch (Exception e) {
                        SPIT_ClientSocket.this.m_StopReceive = true;
                        o_DatagramPacket = null;
                    }
                    if (o_DatagramPacket == null) continue;
                    SPIT_Client o_SPITClient = SPIT_ClientSocket.this.m_SPITClient;
                    SPIT_Message o_SPIT_Message = new SPIT_Message(o_DatagramPacket.getData());
                    SPIT_Message.Header o_SPIT_Message_Header = o_SPIT_Message.getHeader();
                    if (o_SPIT_Message_Header == null) {
                        if (s_DEBUGON) {
                            System.out.println("SPIT_ClientSocket RunnableReceive ERROR SPIT_Message_Header is NULL");
                        }
                        o_SPIT_Message = null;
                        continue;
                    }
                    SPIT_Message.OPPart o_SPIT_Message_OPPart = o_SPIT_Message.getOPPart();
                    if (o_SPIT_Message_OPPart == null) {
                        if (s_DEBUGON) {
                            System.out.println("Error SPIT_ClientSocket RunnableReceive ERROR SPIT_Message_OPPart is NULL");
                        }
                        o_SPIT_Message = null;
                        continue;
                    }
                    if (o_SPITClient == null) continue;
                    if (s_DEBUGON) {
                        System.out.println("<- Client receiveSPIT_Message OP " + o_SPIT_Message.getOPPart().getClass().getSimpleName());
                    }
                    o_SPITClient.parseSPIT_Message(o_SPIT_Message);
                }
            }
        };
    }

    public int getPort() {
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return 0;
        }
        return o_DatagramSocket.getPort();
    }

    public String getIPAddress() {
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return "";
        }
        InetAddress o_InetAddress = o_DatagramSocket.getInetAddress();
        if (o_InetAddress == null) {
            return "";
        }
        String stringIPAddress = SPIT_Client.cleanIPAddress(o_InetAddress.getHostAddress());
        return stringIPAddress;
    }

    public InetAddress getInetAddress() {
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return null;
        }
        InetAddress o_InetAddress = o_DatagramSocket.getInetAddress();
        return o_InetAddress;
    }

    public boolean sendSPIT_Message(SPIT_Message p_SPIT_Message) {
        if (p_SPIT_Message == null) {
            return false;
        }
        DatagramSocket o_DatagramSocket = this.m_DatagramSocket;
        if (o_DatagramSocket == null) {
            return false;
        }
        byte[] o_MessageBytes = p_SPIT_Message.getMessageBytes();
        if (o_MessageBytes == null) {
            return false;
        }
        if (s_DEBUGON) {
            System.out.println("-> Client sendSPIT_Message OP " + p_SPIT_Message.getOPPart().getClass().getSimpleName());
        }
        DatagramPacket o_DatagramPacket = new DatagramPacket(o_MessageBytes, o_MessageBytes.length, this.m_ServerInetAddress, this.m_ServerPort);
        try {
            o_DatagramSocket.send(o_DatagramPacket);
        }
        catch (Exception e) {
            System.out.println("SPIT_ClientSocket sendSPIT_Message ERROR " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean sendDisconnect() {
        if (this.m_SPITClient == null) {
            return false;
        }
        SPIT_Message o_SPIT_Message = SPIT_Message.createDisconnect();
        return SPIT_Client.sendMessage(o_SPIT_Message);
    }

    public InetAddress getServerInetAddress() {
        return this.m_ServerInetAddress;
    }

    public String getServerHostAddress() {
        if (this.m_ServerInetAddress == null) {
            return "";
        }
        String stringIPAddress = SPIT_Client.cleanIPAddress(this.m_ServerInetAddress.getHostAddress());
        return stringIPAddress;
    }

    public int getServerPort() {
        return this.m_ServerPort;
    }
}

