/*
 * Decompiled with CFR 0.152.
 */
package SPITServerAutoDetectPackage;

import SPITServerAutoDetectPackage.ServerAutoDetect;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.UUID;

public class ServerAutoDetect_Server {
    public static boolean DEBUGON = true;
    public static String s_ComputerName;
    public static ArrayList<ServerAutoDetect_Server> s_ServerAutoDetect_Servers;
    public static final Object s_SyncServerAutoDetectServers;
    public static InetAddress s_MulticastGroup_IP4;
    public static InetAddress s_MulticastGroup_IP6;
    private String m_ServerID;
    private String m_ServerTaskID;
    private String m_ServerTaskName;
    private int m_LocalPortConnected;
    private String m_ServerAddition;
    private Runnable m_RunnableMulticast_IP6;
    private Thread m_MulticastThread_IP6;
    private MulticastSocket m_MulticastSocket_IP6;
    public static boolean m_IsMulticastRunning_IP6;
    private boolean m_StopAutoDetect;
    public String getServerName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServerAutoDetect(String p_ServerID, String p_ServerTaskID, String p_ServerTaskName, int p_LocalPortConnected, String p_ServerAdditon) {
        ServerAutoDetect_Server o_ServerAutoDetect_Server;
        if (p_ServerTaskID == null) {
            p_ServerTaskID = "";
        }
        try {
            s_ComputerName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            s_ComputerName = "";
        }
        if (s_MulticastGroup_IP6 == null) {
            try {
                s_MulticastGroup_IP6 = InetAddress.getByName(ServerAutoDetect.MULTICASTGROUPNAME_IP6);
            }
            catch (Exception e) {
                s_MulticastGroup_IP6 = null;
            }
        }
        Object object = s_SyncServerAutoDetectServers;
        synchronized (object) {
            o_ServerAutoDetect_Server = ServerAutoDetect_Server.getServerAutoDetect_Server(p_ServerID);
            if (o_ServerAutoDetect_Server == null) {
                o_ServerAutoDetect_Server = new ServerAutoDetect_Server(p_ServerID, p_ServerTaskID, p_ServerTaskName, p_LocalPortConnected, p_ServerAdditon);
                s_ServerAutoDetect_Servers.add(o_ServerAutoDetect_Server);
            }
        }
        o_ServerAutoDetect_Server.startDetection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerAutoDetect_Server getServerAutoDetect_Server(String p_ServerID) {
        if (p_ServerID == null) {
            return null;
        }
        Object object = s_SyncServerAutoDetectServers;
        synchronized (object) {
            for (int intServer = 0; intServer < s_ServerAutoDetect_Servers.size(); ++intServer) {
                ServerAutoDetect_Server o_ServerAutoDetect_Server = s_ServerAutoDetect_Servers.get(intServer);
                if (!p_ServerID.equals(o_ServerAutoDetect_Server.getServerID())) continue;
                return o_ServerAutoDetect_Server;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopServerAutoDetect(String p_ServerID) {
        ServerAutoDetect_Server o_ServerAutoDetect_Server = null;
        Object object = s_SyncServerAutoDetectServers;
        synchronized (object) {
            try {
                o_ServerAutoDetect_Server = ServerAutoDetect_Server.getServerAutoDetect_Server(p_ServerID);
                if (o_ServerAutoDetect_Server != null) {
                    s_ServerAutoDetect_Servers.remove(o_ServerAutoDetect_Server);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (o_ServerAutoDetect_Server != null) {
            o_ServerAutoDetect_Server.stopDetection();
        }
    }

    public ServerAutoDetect_Server(String p_ServerID, String p_ServerTaskID, String p_ServerTaskName, int p_LocalPortConnected, String p_ServerAddition) {
        if (p_ServerTaskID == null) {
            p_ServerTaskID = "";
        }
        this.initMembers();
        if (p_ServerID != null) {
            this.m_ServerID = p_ServerID;
        }
        this.m_ServerTaskID = p_ServerTaskID;
        this.m_ServerTaskName = p_ServerTaskName;
        this.m_LocalPortConnected = p_LocalPortConnected;
        this.m_ServerAddition = p_ServerAddition;
        if (this.m_ServerAddition == null) {
            this.m_ServerAddition = "";
        }
    }

    private void initMembers() {
        this.m_ServerID = UUID.randomUUID().toString();
        this.m_ServerAddition = "";
        m_IsMulticastRunning_IP6 = false;
        this.m_StopAutoDetect = false;
        this.checkRunnables();
    }

    private void checkRunnables() {
        if (this.m_RunnableMulticast_IP6 == null) {
            this.m_RunnableMulticast_IP6 = new Runnable(){

                @Override
                public void run() {
                    if (s_MulticastGroup_IP6 == null) {
                        return;
                    }
                    try {
                        ServerAutoDetect_Server.this.m_MulticastSocket_IP6 = new MulticastSocket(15110);
                        ServerAutoDetect_Server.this.m_MulticastSocket_IP6.setSoTimeout(1000);
                        ServerAutoDetect_Server.this.m_MulticastSocket_IP6.setReuseAddress(true);
                        ServerAutoDetect_Server.this.m_MulticastSocket_IP6.joinGroup(s_MulticastGroup_IP6);
                    }
                    catch (Exception e) {
                        if (DEBUGON) {
                            System.out.println(this.getClass().getName() + " IP6 Error can't join group " + s_MulticastGroup_IP6.getHostAddress() + " : " + 15110 + " : " + e.getMessage());
                        }
                        m_IsMulticastRunning_IP6 = false;
                        return;
                    }
                    byte[] byteArray_Received = new byte[15000];
                    StringBuffer stringBufferAnswer = new StringBuffer();
                    while (!ServerAutoDetect_Server.this.m_StopAutoDetect) {
                        String[] o_StringMessageParts;
                        String stringMessage;
                        DatagramPacket o_DatagramPacket_Received = new DatagramPacket(byteArray_Received, byteArray_Received.length);
                        try {
                            ServerAutoDetect_Server.this.m_MulticastSocket_IP6.receive(o_DatagramPacket_Received);
                        }
                        catch (Exception e) {
                            if (e instanceof SocketTimeoutException) {
                                if (!ServerAutoDetect_Server.this.m_StopAutoDetect) {
                                    continue;
                                }
                            } else if (DEBUGON) {
                                System.out.println(this.getClass().getName() + " IP6 Error can't listen to " + s_MulticastGroup_IP6.getHostAddress() + " : " + 15110 + " : " + e.getMessage());
                            }
                            try {
                                ServerAutoDetect_Server.this.m_MulticastSocket_IP6.leaveGroup(s_MulticastGroup_IP6);
                                if (!ServerAutoDetect_Server.this.m_MulticastSocket_IP6.isClosed()) {
                                    ServerAutoDetect_Server.this.m_MulticastSocket_IP6.close();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            m_IsMulticastRunning_IP6 = false;
                            return;
                        }
                        try {
                            stringMessage = new String(o_DatagramPacket_Received.getData(), o_DatagramPacket_Received.getOffset(), o_DatagramPacket_Received.getLength(), ServerAutoDetect.CHARSET).trim();
                        }
                        catch (Exception e) {
                            continue;
                        }
                        if (!stringMessage.startsWith("#SAD#") || (o_StringMessageParts = stringMessage.split("#,#")).length < 2) continue;
                        String stringMessageServerTaskID = o_StringMessageParts[1];
                        if (!ServerAutoDetect_Server.this.m_ServerTaskID.equals(stringMessageServerTaskID) && !"*".equals(stringMessageServerTaskID)) continue;
                        stringBufferAnswer.delete(0, stringBufferAnswer.length());
                        stringBufferAnswer.append("#SAD#");
                        stringBufferAnswer.append("#,#");
                        stringBufferAnswer.append(ServerAutoDetect_Server.this.m_ServerTaskID);
                        stringBufferAnswer.append("#,#");
                        stringBufferAnswer.append(ServerAutoDetect_Server.this.m_ServerTaskName);
                        stringBufferAnswer.append("#,#");
                        stringBufferAnswer.append(ServerAutoDetect_Server.this.m_ServerID);
                        stringBufferAnswer.append("#,#");
                        stringBufferAnswer.append(s_ComputerName);
                        stringBufferAnswer.append("#,#");
                        stringBufferAnswer.append(ServerAutoDetect_Server.this.m_LocalPortConnected);
                        stringBufferAnswer.append("#,#");
                        InetAddress o_InetAddress = o_DatagramPacket_Received.getAddress();
                        String stringClientIP = ServerAutoDetect.cleanIPAddress(o_InetAddress.toString());
                        stringBufferAnswer.append(stringClientIP);
                        if (ServerAutoDetect_Server.this.m_ServerAddition == null) {
                            ServerAutoDetect_Server.this.m_ServerAddition = "";
                        }
                        stringBufferAnswer.append("#,#");
                        stringBufferAnswer.append(ServerAutoDetect_Server.this.m_ServerAddition);
                        byte[] byteArray_Send = stringBufferAnswer.toString().getBytes(ServerAutoDetect.CHARSET);
                        DatagramPacket o_DatagramPacket_Send = new DatagramPacket(byteArray_Send, byteArray_Send.length, o_DatagramPacket_Received.getAddress(), o_DatagramPacket_Received.getPort());
                        try {
                            ServerAutoDetect_Server.this.m_MulticastSocket_IP6.send(o_DatagramPacket_Send);
                        }
                        catch (Exception e) {
                            if (!DEBUGON) continue;
                            System.out.println(this.getClass().getName() + " IP6 ERROR: multicast server cannot send to client: " + o_DatagramPacket_Received.getAddress() + " : " + o_DatagramPacket_Received.getPort() + " : " + e.getMessage());
                        }
                    }
                    try {
                        ServerAutoDetect_Server.this.m_MulticastSocket_IP6.leaveGroup(s_MulticastGroup_IP6);
                        if (!ServerAutoDetect_Server.this.m_MulticastSocket_IP6.isClosed()) {
                            ServerAutoDetect_Server.this.m_MulticastSocket_IP6.close();
                        }
                        m_IsMulticastRunning_IP6 = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
        }
    }

    public void startDetection() {
        this.m_StopAutoDetect = false;
        if (!m_IsMulticastRunning_IP6) {
            m_IsMulticastRunning_IP6 = true;
            this.m_MulticastThread_IP6 = new Thread(this.m_RunnableMulticast_IP6, ServerAutoDetect_Server.class.getName());
            this.m_MulticastThread_IP6.start();
        }
    }

    public void stopDetection() {
        this.m_StopAutoDetect = true;
    }

    public String getServerTaskID() {
        return this.m_ServerTaskID;
    }

    public String getServerID() {
        return this.m_ServerID;
    }

    static {
        s_ServerAutoDetect_Servers = new ArrayList();
        s_SyncServerAutoDetectServers = new Object();
    }
}

