/*
 * Decompiled with CFR 0.152.
 */
package SPITServerAutoDetectPackage;

import SPITServerAutoDetectPackage.EventQueueHandler;
import SPITServerAutoDetectPackage.ServerAutoDetect;
import SwingModelPackage.ListTools;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.ComboBoxModel;

public class ServerAutoDetect_Client {
    public static boolean DEBUGON = true;
    public static int s_MulticastZyclusTime = 5000;
    public static ArrayList<ServerAutoDetect_Client> s_ServerAutoDetect_Clients = new ArrayList();
    public static final Object s_SyncServerAutoDetectClients = new Object();
    private ArrayList<Object> m_CallerObjects;
    private ArrayList<ServerAutoDetect.DetectedServer> m_DetectedServers;
    private ArrayList<ServerAutoDetect.DetectedServer> m_DetectedServers_Added;
    private ArrayList<ServerAutoDetect.DetectedServer> m_DetectedServers_Removed;
    private ArrayList<ServerAutoDetect.DetectedServer> m_DetectedServers_Changed;
    private final Object m_SyncDetectedServers = new Object();
    private ListTools.ListModel<ServerAutoDetect.DetectedServer> m_DetectedServer_ListModel;
    private ServerAutoDetect.DetectedServer_ListCellRenderer m_DetectedServer_CellRenderer;
    private String m_ServerTaskID;
    private int m_MutlicastZyclusTime;
    private Runnable m_Runnable_Send;
    private Runnable m_Runnable_Receive;
    private Thread m_ThreadSend;
    private Thread m_ThreadReceive;
    private boolean m_IsMulticastRunning;
    private boolean m_RunBroadcast = true;
    private DatagramSocket m_DatagramSocket;
    private boolean m_StopAutoDetect;
    private ArrayList<ServerAutoDetect.ServerAutoDetect_Listener> m_ServerAutoDetect_Listeners;
    private ArrayList<ServerAutoDetect.ServerAutoDetect_Listener> m_NewServerAutoDetect_Listeners;
    private final Object m_SyncListeners = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerAutoDetect_Client startServerAutoDetect(Object p_CallerObject, String p_ServerTaskID) {
        ServerAutoDetect_Client o_ServerAutoDetect_Client;
        if (p_ServerTaskID == null || p_ServerTaskID.length() <= 0) {
            p_ServerTaskID = "*";
        }
        Object object = s_SyncServerAutoDetectClients;
        synchronized (object) {
            o_ServerAutoDetect_Client = ServerAutoDetect_Client.getServerAutoDetect_Client(p_ServerTaskID);
            if (o_ServerAutoDetect_Client != null) {
                o_ServerAutoDetect_Client.startDetection(p_CallerObject);
            } else {
                o_ServerAutoDetect_Client = new ServerAutoDetect_Client(p_ServerTaskID);
                ServerAutoDetect_Client.addServerAutoDetect_Client(o_ServerAutoDetect_Client);
                o_ServerAutoDetect_Client.startDetection(p_CallerObject);
            }
        }
        return o_ServerAutoDetect_Client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerAutoDetect_Client getServerAutoDetect_Client(String p_ServerTsskID) {
        if (p_ServerTsskID == null) {
            return null;
        }
        Object object = s_SyncServerAutoDetectClients;
        synchronized (object) {
            for (int intClient = 0; intClient < s_ServerAutoDetect_Clients.size(); ++intClient) {
                ServerAutoDetect_Client o_ServerAutoDetect_Client = s_ServerAutoDetect_Clients.get(intClient);
                if (!p_ServerTsskID.equals(o_ServerAutoDetect_Client.getServerTaskID())) continue;
                return o_ServerAutoDetect_Client;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopServerAutoDetect_All() {
        ArrayList<ServerAutoDetect_Client> o_ServerAutoDetect_Clients;
        Object object = s_SyncServerAutoDetectClients;
        synchronized (object) {
            o_ServerAutoDetect_Clients = new ArrayList<ServerAutoDetect_Client>(s_ServerAutoDetect_Clients.size());
            o_ServerAutoDetect_Clients.addAll(s_ServerAutoDetect_Clients);
            s_ServerAutoDetect_Clients.clear();
        }
        for (int intServer = 0; intServer < o_ServerAutoDetect_Clients.size(); ++intServer) {
            ServerAutoDetect_Client o_ServerAutoDetect_Client = (ServerAutoDetect_Client)o_ServerAutoDetect_Clients.get(intServer);
            o_ServerAutoDetect_Client.stopDetectionAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerAutoDetect_Client stopServerAutoDetect(Object p_CallerObject, String p_ServerTaskID) {
        if (p_ServerTaskID == null || p_ServerTaskID.length() <= 0) {
            p_ServerTaskID = "*";
        }
        ServerAutoDetect_Client o_ServerAutoDetect_Client = null;
        Object object = s_SyncServerAutoDetectClients;
        synchronized (object) {
            if (p_ServerTaskID != null && (o_ServerAutoDetect_Client = ServerAutoDetect_Client.getServerAutoDetect_Client(p_ServerTaskID)) != null) {
                o_ServerAutoDetect_Client.stopDetection(p_CallerObject);
            }
        }
        return o_ServerAutoDetect_Client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerAutoDetect_Client addServerAutoDetect_Client(ServerAutoDetect_Client p_ServerAutoDetect_Client) {
        if (p_ServerAutoDetect_Client == null) {
            return null;
        }
        Object object = s_SyncServerAutoDetectClients;
        synchronized (object) {
            ServerAutoDetect_Client o_ServerAutoDetect_Client = ServerAutoDetect_Client.getServerAutoDetect_Client(p_ServerAutoDetect_Client.getServerTaskID());
            if (o_ServerAutoDetect_Client != null) {
                return o_ServerAutoDetect_Client;
            }
            s_ServerAutoDetect_Clients.add(p_ServerAutoDetect_Client);
        }
        return p_ServerAutoDetect_Client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerAutoDetect_Client removeServerAutoDetect_Client(String p_TaskID) {
        if (p_TaskID == null) {
            return null;
        }
        ServerAutoDetect_Client o_ServerAutoDetect_Client = null;
        Object object = s_SyncServerAutoDetectClients;
        synchronized (object) {
            o_ServerAutoDetect_Client = ServerAutoDetect_Client.getServerAutoDetect_Client(p_TaskID);
            if (o_ServerAutoDetect_Client != null) {
                s_ServerAutoDetect_Clients.remove(o_ServerAutoDetect_Client);
            }
        }
        return o_ServerAutoDetect_Client;
    }

    public static void setMutlicastRefreshTime(int p_Milliseconds) {
        if (p_Milliseconds < 1000) {
            p_Milliseconds = 1000;
        }
        if (p_Milliseconds > 60000) {
            p_Milliseconds = 60000;
        }
        s_MulticastZyclusTime = p_Milliseconds;
    }

    public ServerAutoDetect_Client(String p_ServerTaskID) {
        this.initMembers();
        this.m_ServerTaskID = p_ServerTaskID == null ? "*" : p_ServerTaskID;
    }

    private void initMembers() {
        this.m_CallerObjects = new ArrayList();
        this.m_ServerAutoDetect_Listeners = new ArrayList();
        this.m_NewServerAutoDetect_Listeners = new ArrayList();
        this.m_DetectedServers = new ArrayList();
        this.m_DetectedServers_Added = new ArrayList();
        this.m_DetectedServers_Removed = new ArrayList();
        this.m_DetectedServers_Changed = new ArrayList();
        this.m_StopAutoDetect = false;
        this.m_IsMulticastRunning = false;
        this.m_MutlicastZyclusTime = s_MulticastZyclusTime;
    }

    public String getServerTaskID() {
        return this.m_ServerTaskID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multicastZyclusStart() {
        Object object = this.m_SyncDetectedServers;
        synchronized (object) {
            for (int intServer = 0; intServer < this.m_DetectedServers.size(); ++intServer) {
                ServerAutoDetect.DetectedServer o_DetectedServer = this.m_DetectedServers.get(intServer);
                o_DetectedServer.multicastZyclusStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void multicastZyclusEnd() {
        int intDetectedServer;
        ServerAutoDetect.DetectedServer o_DetectedServer;
        Object object = this.m_SyncDetectedServers;
        synchronized (object) {
            int intServer;
            this.m_DetectedServers_Added.clear();
            this.m_DetectedServers_Changed.clear();
            this.m_DetectedServers_Removed.clear();
            for (intServer = 0; intServer < this.m_DetectedServers.size(); ++intServer) {
                o_DetectedServer = this.m_DetectedServers.get(intServer);
                o_DetectedServer.multicastZyclusEnd();
                if (o_DetectedServer.isNew()) {
                    this.m_DetectedServers_Added.add(o_DetectedServer);
                    continue;
                }
                if (!o_DetectedServer.IsDetected()) {
                    this.m_DetectedServers_Removed.add(o_DetectedServer);
                    continue;
                }
                if (!o_DetectedServer.isChanged()) continue;
                this.m_DetectedServers_Changed.add(o_DetectedServer);
            }
            for (intServer = 0; intServer < this.m_DetectedServers_Removed.size(); ++intServer) {
                o_DetectedServer = this.m_DetectedServers_Removed.get(intServer);
                this.m_DetectedServers.remove(o_DetectedServer);
            }
        }
        boolean boolNewListenersAdded = false;
        Object intServer = this.m_SyncListeners;
        synchronized (intServer) {
            if (this.m_NewServerAutoDetect_Listeners.size() > 0) {
                boolNewListenersAdded = true;
            }
        }
        if (boolNewListenersAdded) {
            ArrayList<ServerAutoDetect.DetectedServer> o_DetectedServers;
            ArrayList<ServerAutoDetect.ServerAutoDetect_Listener> o_NewServerAutoDetect_Listeners;
            Object object2 = this.m_SyncListeners;
            synchronized (object2) {
                o_NewServerAutoDetect_Listeners = new ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>(this.m_NewServerAutoDetect_Listeners.size());
                o_NewServerAutoDetect_Listeners.addAll(this.m_NewServerAutoDetect_Listeners);
                this.m_NewServerAutoDetect_Listeners.clear();
            }
            object2 = this.m_SyncDetectedServers;
            synchronized (object2) {
                o_DetectedServers = new ArrayList<ServerAutoDetect.DetectedServer>(this.m_DetectedServers.size());
                o_DetectedServers.addAll(this.m_DetectedServers);
            }
            for (int intListener = 0; intListener < o_NewServerAutoDetect_Listeners.size(); ++intListener) {
                ServerAutoDetect.ServerAutoDetect_Listener o_Listener = (ServerAutoDetect.ServerAutoDetect_Listener)o_NewServerAutoDetect_Listeners.get(intListener);
                for (int intDetectesServer = 0; intDetectesServer < o_DetectedServers.size(); ++intDetectesServer) {
                    o_DetectedServer = (ServerAutoDetect.DetectedServer)o_DetectedServers.get(intDetectesServer);
                    if (this.m_DetectedServers_Added.contains(o_DetectedServer)) continue;
                    o_Listener.eventDetectedServer_Added(o_DetectedServer);
                }
            }
        }
        for (intDetectedServer = 0; intDetectedServer < this.m_DetectedServers_Added.size(); ++intDetectedServer) {
            o_DetectedServer = this.m_DetectedServers_Added.get(intDetectedServer);
            this.notifyDetectedServerAdded(o_DetectedServer);
        }
        for (intDetectedServer = 0; intDetectedServer < this.m_DetectedServers_Removed.size(); ++intDetectedServer) {
            o_DetectedServer = this.m_DetectedServers_Removed.get(intDetectedServer);
            this.notifyDetectedServerRemoved(o_DetectedServer);
        }
        for (intDetectedServer = 0; intDetectedServer < this.m_DetectedServers_Changed.size(); ++intDetectedServer) {
            o_DetectedServer = this.m_DetectedServers_Changed.get(intDetectedServer);
            this.notifyDetectedServerChanged(o_DetectedServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDetection(Object p_CallerObject) {
        if (p_CallerObject == null) {
            return;
        }
        this.addCallerObject(p_CallerObject);
        if (this.m_IsMulticastRunning) {
            return;
        }
        this.m_IsMulticastRunning = true;
        try {
            this.m_DatagramSocket = new DatagramSocket();
            this.m_DatagramSocket.setBroadcast(true);
            if (DEBUGON) {
                System.out.println(this.getClass().getName() + " StartDetection DatagramSocket created");
            }
        }
        catch (Exception e) {
            if (DEBUGON) {
                System.out.println(this.getClass().getName() + "Error can't create DatagramSocket: " + e.getMessage());
            }
            this.m_IsMulticastRunning = false;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                this.m_CallerObjects.remove(p_CallerObject);
            }
            return;
        }
        this.checkRunnables();
        this.m_StopAutoDetect = false;
        this.m_ThreadReceive = new Thread(this.m_Runnable_Receive, this.getClass().getName());
        this.m_ThreadSend = new Thread(this.m_Runnable_Send, this.getClass().getName());
        this.m_ThreadReceive.start();
        this.m_ThreadSend.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCallerObject(Object p_CallerObject) {
        if (p_CallerObject == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_CallerObjects.contains(p_CallerObject)) {
                return;
            }
            this.m_CallerObjects.add(p_CallerObject);
            if (p_CallerObject instanceof ServerAutoDetect.ServerAutoDetect_Listener) {
                ServerAutoDetect.ServerAutoDetect_Listener o_ServerAutoDetect_Listener = (ServerAutoDetect.ServerAutoDetect_Listener)p_CallerObject;
                this.addServerAutoDetectListener(o_ServerAutoDetect_Listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeCallerObject(Object p_CallerObject) {
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (p_CallerObject == null) {
                return this.m_CallerObjects.size();
            }
            if (this.m_CallerObjects.contains(p_CallerObject)) {
                this.m_CallerObjects.remove(p_CallerObject);
                if (p_CallerObject instanceof ServerAutoDetect.ServerAutoDetect_Listener) {
                    this.removeServerAutoDetectListener((ServerAutoDetect.ServerAutoDetect_Listener)p_CallerObject);
                }
            }
            return this.m_CallerObjects.size();
        }
    }

    private void checkRunnables() {
        if (this.m_Runnable_Receive == null) {
            this.m_Runnable_Receive = new Runnable(){

                @Override
                public void run() {
                    String stringServerAddition = null;
                    byte[] byteArray_Received = new byte[ServerAutoDetect.BYTEBUFFERSIZE];
                    while (!ServerAutoDetect_Client.this.m_StopAutoDetect) {
                        int intAnserServerPortConnected;
                        String[] o_StringMessageParts;
                        String stringMessage;
                        DatagramPacket o_AnswerDatagramPacket;
                        block10: {
                            o_AnswerDatagramPacket = new DatagramPacket(byteArray_Received, byteArray_Received.length);
                            try {
                                ServerAutoDetect_Client.this.m_DatagramSocket.receive(o_AnswerDatagramPacket);
                            }
                            catch (SocketTimeoutException e_SocketTimeoutException) {
                                o_AnswerDatagramPacket = null;
                                continue;
                            }
                            catch (Exception e) {
                                if (DEBUGON) {
                                    System.out.println(this.getClass().getName() + " " + ServerAutoDetect_Client.this.m_DatagramSocket.getInetAddress() + " Error receiving message: " + e.getMessage());
                                }
                                ServerAutoDetect_Client.this.m_StopAutoDetect = true;
                                o_AnswerDatagramPacket = null;
                            }
                            if (o_AnswerDatagramPacket == null) continue;
                            try {
                                stringMessage = new String(o_AnswerDatagramPacket.getData(), o_AnswerDatagramPacket.getOffset(), o_AnswerDatagramPacket.getLength(), ServerAutoDetect.CHARSET).trim();
                                if (!DEBUGON) break block10;
                                System.out.println(this.getClass().getName() + " " + ServerAutoDetect_Client.this.m_DatagramSocket.getInetAddress() + " received udp message: " + stringMessage);
                            }
                            catch (Exception e) {
                                if (!DEBUGON) continue;
                                System.out.println(this.getClass().getName() + " " + ServerAutoDetect_Client.this.m_DatagramSocket.getInetAddress() + " Error converting charset message: " + e.getMessage());
                                continue;
                            }
                        }
                        if (!stringMessage.startsWith("#SAD#", 0) || (o_StringMessageParts = stringMessage.split("#,#")).length < 7) continue;
                        String stringAnswerServerTaskID = o_StringMessageParts[1];
                        if (!"*".equals(ServerAutoDetect_Client.this.m_ServerTaskID) && !ServerAutoDetect_Client.this.m_ServerTaskID.equals(stringAnswerServerTaskID)) continue;
                        String stringAnswerServerTaskName = o_StringMessageParts[2];
                        String stringAnswerServerID = o_StringMessageParts[3];
                        String stringAnswerComputerName = o_StringMessageParts[4];
                        try {
                            intAnserServerPortConnected = Integer.valueOf(o_StringMessageParts[5]);
                        }
                        catch (Exception e) {
                            if (!DEBUGON) continue;
                            System.out.println(this.getClass().getName() + " ERROR received Packet " + o_StringMessageParts[1] + " wrong Port " + o_StringMessageParts[4]);
                            continue;
                        }
                        String stringAnswerClientIP = o_StringMessageParts[6];
                        stringServerAddition = "";
                        if (o_StringMessageParts.length >= 8) {
                            stringServerAddition = o_StringMessageParts[7];
                        }
                        ServerAutoDetect_Client.this.serverDetected(stringAnswerServerID, stringAnswerServerTaskID, stringAnswerServerTaskName, stringAnswerComputerName, o_AnswerDatagramPacket.getAddress(), intAnserServerPortConnected, stringAnswerClientIP, stringServerAddition);
                        if (!DEBUGON) continue;
                        System.out.println(this.getClass().getSimpleName() + " Server detected " + o_AnswerDatagramPacket.getAddress());
                    }
                    ServerAutoDetect_Client.this.m_IsMulticastRunning = false;
                }
            };
        }
        if (this.m_Runnable_Send == null) {
            this.m_Runnable_Send = new Runnable(){

                @Override
                public void run() {
                    InetAddress o_InetAddressMulticast_IP6;
                    StringBuffer o_StringBuffer_Send = new StringBuffer();
                    try {
                        o_InetAddressMulticast_IP6 = InetAddress.getByName(ServerAutoDetect.MULTICASTGROUPNAME_IP6);
                    }
                    catch (Exception e) {
                        o_InetAddressMulticast_IP6 = null;
                    }
                    o_StringBuffer_Send.delete(0, o_StringBuffer_Send.length());
                    o_StringBuffer_Send.append("#SAD#");
                    o_StringBuffer_Send.append("#,#");
                    o_StringBuffer_Send.append(ServerAutoDetect_Client.this.m_ServerTaskID);
                    byte[] byteArray_Send_IP4 = o_StringBuffer_Send.toString().getBytes(ServerAutoDetect.CHARSET);
                    byte[] byteArray_Send_IP6 = o_StringBuffer_Send.toString().getBytes(ServerAutoDetect.CHARSET);
                    while (!ServerAutoDetect_Client.this.m_StopAutoDetect) {
                        block20: {
                            DatagramPacket o_DatagramPacket_Send;
                            Enumeration<NetworkInterface> o_NetworkInterfaces;
                            ServerAutoDetect_Client.this.multicastZyclusStart();
                            try {
                                o_NetworkInterfaces = NetworkInterface.getNetworkInterfaces();
                            }
                            catch (Exception e) {
                                o_NetworkInterfaces = null;
                            }
                            if (o_NetworkInterfaces != null) {
                                while (o_NetworkInterfaces.hasMoreElements()) {
                                    NetworkInterface o_NetworkInterface = o_NetworkInterfaces.nextElement();
                                    try {
                                        if (!o_NetworkInterface.isUp()) {
                                        }
                                    }
                                    catch (Exception e) {}
                                    continue;
                                    for (InterfaceAddress o_InterfaceAddress : o_NetworkInterface.getInterfaceAddresses()) {
                                        InetAddress o_InetAddressBroadcast_IP4 = o_InterfaceAddress.getBroadcast();
                                        if (o_InetAddressBroadcast_IP4 == null) continue;
                                        try {
                                            if (DEBUGON) {
                                                System.out.println(this.getClass().getName() + " send message to : " + o_InetAddressBroadcast_IP4.toString());
                                                System.out.println(o_StringBuffer_Send.toString());
                                            }
                                            o_DatagramPacket_Send = new DatagramPacket(byteArray_Send_IP4, byteArray_Send_IP4.length, o_InetAddressBroadcast_IP4, 15110);
                                            ServerAutoDetect_Client.this.m_DatagramSocket.send(o_DatagramPacket_Send);
                                        }
                                        catch (Exception e) {
                                            if (!DEBUGON) continue;
                                            System.out.println(this.getClass().getName() + " ERROR IP4 send DatagramPacket to : " + o_InetAddressBroadcast_IP4.toString() + e.getMessage());
                                        }
                                    }
                                }
                            }
                            if (o_InetAddressMulticast_IP6 != null) {
                                try {
                                    if (DEBUGON) {
                                        System.out.println(this.getClass().getName() + " send message to : " + o_InetAddressMulticast_IP6.toString());
                                        System.out.println(o_StringBuffer_Send.toString());
                                    }
                                    o_DatagramPacket_Send = new DatagramPacket(byteArray_Send_IP6, byteArray_Send_IP6.length, o_InetAddressMulticast_IP6, 15110);
                                    ServerAutoDetect_Client.this.m_DatagramSocket.send(o_DatagramPacket_Send);
                                }
                                catch (Exception e) {
                                    if (!DEBUGON) break block20;
                                    System.out.println(this.getClass().getName() + " ERROR IP6 send DatagramPacket: " + e.getMessage());
                                }
                            }
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(ServerAutoDetect_Client.this.m_MutlicastZyclusTime);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ServerAutoDetect_Client.this.multicastZyclusEnd();
                    }
                    ServerAutoDetect_Client.this.m_IsMulticastRunning = false;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverDetected(String p_ServerID, String p_ServerTaskID, String p_ServerTaskName, String p_ComputerName, InetAddress p_InetAddress, int p_Port, String p_ClientIP, String p_ServerAddition) {
        ServerAutoDetect.DetectedServer o_DetectedServer;
        Object object = this.m_SyncDetectedServers;
        synchronized (object) {
            o_DetectedServer = this.getDetectedServer_ByID(p_ServerID);
            if (o_DetectedServer == null) {
                o_DetectedServer = new ServerAutoDetect.DetectedServer(p_ServerID, p_ServerTaskID, p_ServerTaskName, p_ComputerName, p_Port, p_ClientIP, p_ServerAddition);
                this.m_DetectedServers.add(o_DetectedServer);
            }
        }
        o_DetectedServer.addInetAddress(p_InetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDetectionAll() {
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_CallerObjects.clear();
        }
        this.m_StopAutoDetect = true;
        if (this.m_DatagramSocket != null) {
            try {
                if (!this.m_DatagramSocket.isClosed()) {
                    this.m_DatagramSocket.close();
                    if (DEBUGON) {
                        System.out.println(this.getClass().getName() + " stopDetectionAll - DatagramSocket closed");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.m_SyncDetectedServers;
        synchronized (object) {
            this.m_DetectedServers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDetection(Object p_CallerObject) {
        int intRestCallerCount = this.removeCallerObject(p_CallerObject);
        if (intRestCallerCount > 0) {
            return;
        }
        this.m_StopAutoDetect = true;
        if (this.m_DatagramSocket != null) {
            try {
                if (!this.m_DatagramSocket.isClosed()) {
                    this.m_DatagramSocket.close();
                    if (DEBUGON) {
                        System.out.println(this.getClass().getName() + " stopDetection - DatagramSocket closed");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object object = this.m_SyncDetectedServers;
        synchronized (object) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDetectedServerCount() {
        Object object = this.m_SyncDetectedServers;
        synchronized (object) {
            return this.m_DetectedServers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerAutoDetect.DetectedServer getDetectedServer(int p_Index) {
        ServerAutoDetect.DetectedServer o_DetectedServer;
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncDetectedServers;
        synchronized (object) {
            if (p_Index >= this.m_DetectedServers.size()) {
                return null;
            }
            o_DetectedServer = this.m_DetectedServers.get(p_Index);
        }
        return o_DetectedServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ServerAutoDetect.DetectedServer> getDetectedServers() {
        ArrayList<ServerAutoDetect.DetectedServer> o_DetectedServers;
        Object object = this.m_SyncDetectedServers;
        synchronized (object) {
            o_DetectedServers = new ArrayList<ServerAutoDetect.DetectedServer>(this.m_DetectedServers.size());
            o_DetectedServers.addAll(this.m_DetectedServers);
        }
        return o_DetectedServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerAutoDetect.DetectedServer getDetectedServer_ByID(String p_ServerID) {
        if (p_ServerID == null) {
            return null;
        }
        Object object = this.m_SyncDetectedServers;
        synchronized (object) {
            for (int intServer = 0; intServer < this.m_DetectedServers.size(); ++intServer) {
                ServerAutoDetect.DetectedServer o_DetectedServer = this.m_DetectedServers.get(intServer);
                if (!p_ServerID.equals(o_DetectedServer.getServerID())) continue;
                return o_DetectedServer;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerAutoDetect.DetectedServer getDetectedServer_ByIPPort(String p_ServerIP, int p_ServerPort) {
        if (p_ServerIP == null) {
            return null;
        }
        Object object = this.m_SyncDetectedServers;
        synchronized (object) {
            for (int intServer = 0; intServer < this.m_DetectedServers.size(); ++intServer) {
                ServerAutoDetect.DetectedServer o_DetectedServer = this.m_DetectedServers.get(intServer);
                if (o_DetectedServer.getPort() != p_ServerPort || !o_DetectedServer.containsIP(p_ServerIP)) continue;
                return o_DetectedServer;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerAutoDetect.DetectedServer getDetectedServer_ByHostNamePort(String p_ServerHostName, int p_ServerPort) {
        if (p_ServerHostName == null) {
            return null;
        }
        p_ServerHostName.trim();
        Object object = this.m_SyncDetectedServers;
        synchronized (object) {
            for (int intServer = 0; intServer < this.m_DetectedServers.size(); ++intServer) {
                ServerAutoDetect.DetectedServer o_DetectedServer = this.m_DetectedServers.get(intServer);
                if (o_DetectedServer.getPort() != p_ServerPort || !p_ServerHostName.equals(o_DetectedServer.getComputerName())) continue;
                return o_DetectedServer;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComboBoxModel<ServerAutoDetect.DetectedServer> getDetectedServerListModel() {
        if (this.m_DetectedServer_ListModel == null) {
            this.m_DetectedServer_ListModel = new ListTools.ListModel<Object>(null);
            this.m_DetectedServer_CellRenderer = new ServerAutoDetect.DetectedServer_ListCellRenderer(false, false, true, true, true, true);
            Object object = this.m_SyncDetectedServers;
            synchronized (object) {
                for (int intServer = 0; intServer < this.m_DetectedServers.size(); ++intServer) {
                    ServerAutoDetect.DetectedServer o_DetectedServer = this.m_DetectedServers.get(intServer);
                    if (o_DetectedServer == null) continue;
                    this.m_DetectedServer_ListModel.addElement(o_DetectedServer);
                }
            }
        }
        return this.m_DetectedServer_ListModel;
    }

    public ServerAutoDetect.DetectedServer_ListCellRenderer getDetectedServer_CellRenderer() {
        if (this.m_DetectedServer_ListModel == null) {
            this.getDetectedServerListModel();
        }
        return this.m_DetectedServer_CellRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerAutoDetectListener(ServerAutoDetect.ServerAutoDetect_Listener p_ServerAutoDetect_Listener) {
        if (p_ServerAutoDetect_Listener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_ServerAutoDetect_Listeners.contains(p_ServerAutoDetect_Listener)) {
                return;
            }
            this.m_ServerAutoDetect_Listeners.add(p_ServerAutoDetect_Listener);
            this.m_NewServerAutoDetect_Listeners.add(p_ServerAutoDetect_Listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServerAutoDetectListener(ServerAutoDetect.ServerAutoDetect_Listener p_ServerAutoDetect_Listener) {
        if (p_ServerAutoDetect_Listener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            this.m_ServerAutoDetect_Listeners.remove(p_ServerAutoDetect_Listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDetectedServerAdded(final ServerAutoDetect.DetectedServer p_DetectedServer) {
        ArrayList<ServerAutoDetect.ServerAutoDetect_Listener> o_Listeners;
        if (p_DetectedServer == null) {
            return;
        }
        if (this.m_DetectedServer_ListModel != null) {
            EventQueueHandler.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ServerAutoDetect_Client.this.m_DetectedServer_ListModel != null) {
                        ServerAutoDetect_Client.this.m_DetectedServer_ListModel.addElement(p_DetectedServer);
                    }
                }
            });
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_ServerAutoDetect_Listeners.size() <= 0) {
                return;
            }
            o_Listeners = new ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>(this.m_ServerAutoDetect_Listeners.size());
            o_Listeners.addAll(this.m_ServerAutoDetect_Listeners);
        }
        for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
            ServerAutoDetect.ServerAutoDetect_Listener o_Listener = (ServerAutoDetect.ServerAutoDetect_Listener)o_Listeners.get(intListener);
            o_Listener.eventDetectedServer_Added(p_DetectedServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDetectedServerRemoved(final ServerAutoDetect.DetectedServer p_DetectedServer) {
        ArrayList<ServerAutoDetect.ServerAutoDetect_Listener> o_Listeners;
        if (p_DetectedServer == null) {
            return;
        }
        if (this.m_DetectedServer_ListModel != null) {
            EventQueueHandler.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ServerAutoDetect_Client.this.m_DetectedServer_ListModel != null) {
                        ServerAutoDetect_Client.this.m_DetectedServer_ListModel.remove(p_DetectedServer);
                    }
                }
            });
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_ServerAutoDetect_Listeners.size() <= 0) {
                return;
            }
            o_Listeners = new ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>(this.m_ServerAutoDetect_Listeners.size());
            o_Listeners.addAll(this.m_ServerAutoDetect_Listeners);
        }
        for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
            ServerAutoDetect.ServerAutoDetect_Listener o_Listener = (ServerAutoDetect.ServerAutoDetect_Listener)o_Listeners.get(intListener);
            o_Listener.eventDetectedServer_Removed(p_DetectedServer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyDetectedServerChanged(final ServerAutoDetect.DetectedServer p_DetectedServer) {
        ArrayList<ServerAutoDetect.ServerAutoDetect_Listener> o_Listeners;
        if (p_DetectedServer == null) {
            return;
        }
        if (this.m_DetectedServer_ListModel != null) {
            EventQueueHandler.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (ServerAutoDetect_Client.this.m_DetectedServer_ListModel != null) {
                        ServerAutoDetect_Client.this.m_DetectedServer_ListModel.changed(p_DetectedServer);
                    }
                }
            });
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_ServerAutoDetect_Listeners.size() <= 0) {
                return;
            }
            o_Listeners = new ArrayList<ServerAutoDetect.ServerAutoDetect_Listener>(this.m_ServerAutoDetect_Listeners.size());
            o_Listeners.addAll(this.m_ServerAutoDetect_Listeners);
        }
        for (int intListener = 0; intListener < o_Listeners.size(); ++intListener) {
            ServerAutoDetect.ServerAutoDetect_Listener o_Listener = (ServerAutoDetect.ServerAutoDetect_Listener)o_Listeners.get(intListener);
            o_Listener.eventDetectedServer_Changed(p_DetectedServer);
        }
    }
}

