/*
 * Decompiled with CFR 0.152.
 */
package SwingModelPackage;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class SinglePropertyChangeSupport {
    private PropertyChangeListener[] s_EmptyList = new PropertyChangeListener[0];
    private HashMap<String, ArrayList<PropertyChangeListener>> m_HashMapPropertyChangeListeners;
    private Object m_ObjectSource;
    private final Object m_SyncListeners = new Object();

    public SinglePropertyChangeSupport(Object p_ObjectSource) {
        if (p_ObjectSource == null) {
            throw new NullPointerException();
        }
        this.initMembers();
        this.m_ObjectSource = p_ObjectSource;
    }

    private void initMembers() {
        this.m_HashMapPropertyChangeListeners = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_HashMapPropertyChangeListeners != null) {
                Iterator<ArrayList<PropertyChangeListener>> o_IteratorPropertyName = this.m_HashMapPropertyChangeListeners.values().iterator();
                while (o_IteratorPropertyName.hasNext()) {
                    ArrayList<PropertyChangeListener> o_PropertyChangeListeners = o_IteratorPropertyName.next();
                    if (o_PropertyChangeListeners != null) {
                        for (int intListener = o_PropertyChangeListeners.size() - 1; intListener >= 0; --intListener) {
                            PropertyChangeListener o_PropertyChangeListener = o_PropertyChangeListeners.get(intListener);
                            o_PropertyChangeListeners.remove(o_PropertyChangeListener);
                        }
                        o_PropertyChangeListeners.clear();
                    }
                    o_IteratorPropertyName.remove();
                }
                this.m_HashMapPropertyChangeListeners.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            ArrayList<PropertyChangeListener> o_PropertyChangeListeners = this.m_HashMapPropertyChangeListeners.get(null);
            if (o_PropertyChangeListeners == null) {
                o_PropertyChangeListeners = new ArrayList();
                this.m_HashMapPropertyChangeListeners.put(null, o_PropertyChangeListeners);
            }
            if (o_PropertyChangeListeners.contains(p_PropertyChangeListener)) {
                return;
            }
            o_PropertyChangeListeners.add(p_PropertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            ArrayList<PropertyChangeListener> o_PropertyChangeListeners = this.m_HashMapPropertyChangeListeners.get(null);
            if (o_PropertyChangeListeners == null) {
                return;
            }
            o_PropertyChangeListeners.remove(p_PropertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyChangeListener[] getPropertyChangeListeners() {
        ArrayList<PropertyChangeListener> o_PropertyChangeListeners;
        Object object = this.m_SyncListeners;
        synchronized (object) {
            o_PropertyChangeListeners = new ArrayList<PropertyChangeListener>();
            if (this.m_HashMapPropertyChangeListeners != null) {
                for (ArrayList<PropertyChangeListener> o_PropertyChangeListenersInMap : this.m_HashMapPropertyChangeListeners.values()) {
                    for (int intListener = 0; intListener < o_PropertyChangeListenersInMap.size(); ++intListener) {
                        PropertyChangeListener o_PropertyChangeListener = o_PropertyChangeListenersInMap.get(intListener);
                        if (o_PropertyChangeListeners.contains(o_PropertyChangeListener)) continue;
                        o_PropertyChangeListeners.add(o_PropertyChangeListener);
                    }
                }
            }
        }
        PropertyChangeListener[] arrayPropertyChangeListeners = new PropertyChangeListener[o_PropertyChangeListeners.size()];
        for (int intListener = 0; intListener < o_PropertyChangeListeners.size(); ++intListener) {
            arrayPropertyChangeListeners[intListener] = (PropertyChangeListener)o_PropertyChangeListeners.get(intListener);
        }
        return arrayPropertyChangeListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null || p_PropertyName == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            ArrayList<PropertyChangeListener> o_PropertyChangeListeners = this.m_HashMapPropertyChangeListeners.get(p_PropertyName);
            if (o_PropertyChangeListeners == null) {
                o_PropertyChangeListeners = new ArrayList();
                this.m_HashMapPropertyChangeListeners.put(p_PropertyName, o_PropertyChangeListeners);
            }
            if (o_PropertyChangeListeners.contains(p_PropertyChangeListener)) {
                return;
            }
            o_PropertyChangeListeners.add(p_PropertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String p_PropertyName, PropertyChangeListener p_PropertyChangeListener) {
        if (p_PropertyChangeListener == null || p_PropertyName == null) {
            return;
        }
        Object object = this.m_SyncListeners;
        synchronized (object) {
            ArrayList<PropertyChangeListener> o_PropertyChangeListeners = this.m_HashMapPropertyChangeListeners.get(p_PropertyName);
            if (o_PropertyChangeListeners == null) {
                return;
            }
            o_PropertyChangeListeners.remove(p_PropertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyChangeListener[] getPropertyChangeListeners(String p_PropertyName) {
        if (p_PropertyName != null) {
            Object object = this.m_SyncListeners;
            synchronized (object) {
                ArrayList<PropertyChangeListener> o_PropertyChangeListeners = this.m_HashMapPropertyChangeListeners.get(p_PropertyName);
                if (o_PropertyChangeListeners != null) {
                    PropertyChangeListener[] arrayPropertyChangeListeners = new PropertyChangeListener[o_PropertyChangeListeners.size()];
                    for (int intListener = 0; intListener < o_PropertyChangeListeners.size(); ++intListener) {
                        arrayPropertyChangeListeners[intListener] = o_PropertyChangeListeners.get(intListener);
                    }
                    return arrayPropertyChangeListeners;
                }
            }
        }
        return this.s_EmptyList;
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.firePropertyChange(new PropertyChangeEvent(this.m_ObjectSource, propertyName, oldValue, newValue));
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(PropertyChangeEvent event) {
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            ArrayList<PropertyChangeListener> o_PropertyChangeListeners;
            String stringPropertyName = event.getPropertyName();
            int intListenerCount = 0;
            ArrayList<PropertyChangeListener> o_PropertyChangeListeners_Null = null;
            ArrayList<PropertyChangeListener> o_PropertyChangeListeners_Named = null;
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_PropertyChangeListeners_Null = this.m_HashMapPropertyChangeListeners.get(null);
                if (o_PropertyChangeListeners_Null != null) {
                    intListenerCount = o_PropertyChangeListeners_Null.size();
                }
                if (stringPropertyName != null && (o_PropertyChangeListeners_Named = this.m_HashMapPropertyChangeListeners.get(stringPropertyName)) != null) {
                    intListenerCount += o_PropertyChangeListeners_Named.size();
                }
                if (intListenerCount <= 0) {
                    return;
                }
                o_PropertyChangeListeners = new ArrayList<PropertyChangeListener>(intListenerCount);
                if (o_PropertyChangeListeners_Null != null) {
                    o_PropertyChangeListeners.addAll(o_PropertyChangeListeners_Null);
                }
                if (o_PropertyChangeListeners_Named != null) {
                    o_PropertyChangeListeners.addAll(o_PropertyChangeListeners_Named);
                }
            }
            SinglePropertyChangeSupport.fire(o_PropertyChangeListeners, event);
            o_PropertyChangeListeners.clear();
        }
    }

    private static void fire(ArrayList<PropertyChangeListener> p_PropertyChangeListeners, PropertyChangeEvent p_PropertyChangeEvent) {
        if (p_PropertyChangeListeners != null) {
            for (int intListener = 0; intListener < p_PropertyChangeListeners.size(); ++intListener) {
                p_PropertyChangeListeners.get(intListener).propertyChange(p_PropertyChangeEvent);
            }
        }
    }

    public void fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        if (oldValue == null || newValue == null || !oldValue.equals(newValue)) {
            this.firePropertyChange(new IndexedPropertyChangeEvent(this.m_ObjectSource, propertyName, oldValue, newValue, index));
        }
    }

    public void fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        if (oldValue != newValue) {
            this.fireIndexedPropertyChange(propertyName, index, (Object)oldValue, (Object)newValue);
        }
    }

    public void fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            this.fireIndexedPropertyChange(propertyName, index, (Object)oldValue, (Object)newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners(String propertyName) {
        Object object = this.m_SyncListeners;
        synchronized (object) {
            if (this.m_HashMapPropertyChangeListeners == null) {
                return false;
            }
            ArrayList<PropertyChangeListener> o_PropertyChangeListeners = this.m_HashMapPropertyChangeListeners.get(propertyName);
            if (o_PropertyChangeListeners == null) {
                return false;
            }
            return o_PropertyChangeListeners.size() > 0;
            {
            }
        }
    }
}

