/*
 * Decompiled with CFR 0.152.
 */
package SwingModelPackage;

import SPITLibraryPackage.SPIT_Type_Interface;
import SwingModelPackage.SPIT_TimeTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class SPIT_TypeModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int COLUMNCOUNT = 4;
    public static final int COLUMNINDEX_GROUPNAME = 0;
    public static final int COLUMNINDEX_TYPENAME = 1;
    public static final int COLUMNINDEX_DELAY = 2;
    public static final int COLUMNINDEX_DURATION = 3;
    public static String COLUMN_TYPENAME = "Name";
    public static String COLUMN_GROUPNAME = "Group";
    public static String COLUMN_DELAYNAME = "Delay";
    public static String COLUMN_DURATIONNAME = "Duration";
    public static double FRAMESPERSECOND = 44100.0;
    public static boolean s_LanguageLoaded = false;
    private ArrayList<SPIT_Type_Interface> m_SPIT_Types;
    private HashMap<String, SPIT_Type_Interface> m_SPIT_TypesByID;
    private TableRowSorter m_TableRowSorter;
    private SPITRowFilter m_SPITRowFilter;
    private final Object m_SyncObject = new Object();
    private SPIT_TypeListModel m_SPIT_TypeListModel;
    private SPIT_TypeLListRenderer m_SPIT_TypeListRenderer;

    public SPIT_TypeModel() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_SPIT_Types = new ArrayList();
        this.m_SPIT_TypesByID = new HashMap();
        this.m_TableRowSorter = new TableRowSorter<SPIT_TypeModel>(this);
        this.m_SPITRowFilter = new SPITRowFilter(this);
        this.m_SPIT_TypeListModel = new SPIT_TypeListModel();
        this.m_SPIT_TypeListRenderer = new SPIT_TypeLListRenderer();
    }

    public void finishJTable(JTable p_JTable) {
        if (p_JTable == null) {
            return;
        }
        p_JTable.setRowSorter(this.m_TableRowSorter);
        this.fireTableStructureChanged();
        this.m_TableRowSorter.setComparator(1, new StringComparator_Normal());
        this.m_TableRowSorter.setComparator(0, new StringComparator_Normal());
        this.m_TableRowSorter.setComparator(2, new StringComparator_Time());
        this.m_TableRowSorter.setComparator(3, new StringComparator_Time());
        this.m_TableRowSorter.setRowFilter(this.m_SPITRowFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int intLastRow;
        Object object = this.m_SyncObject;
        synchronized (object) {
            intLastRow = this.m_SPIT_Types.size() - 1;
            this.m_SPIT_Types.clear();
            this.m_SPIT_TypesByID.clear();
            this.m_SPIT_TypeListModel.clear();
        }
        if (intLastRow >= 0) {
            this.fireTableRowsDeleted(0, intLastRow);
        }
    }

    public SPIT_TypeListModel getSPIT_TypeListModel() {
        return this.m_SPIT_TypeListModel;
    }

    public SPIT_TypeLListRenderer getSPIT_TypeLListRenderer() {
        return this.m_SPIT_TypeListRenderer;
    }

    public void filter(String p_FilterString) {
        if (this.m_SPITRowFilter == null) {
            return;
        }
        this.m_SPITRowFilter.setFilterString(p_FilterString);
    }

    public boolean contains(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return false;
        }
        return this.contains(p_SPIT_Type_Interface.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String p_ID) {
        SPIT_Type_Interface o_SPIT_Type_Interface;
        if (p_ID == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            o_SPIT_Type_Interface = this.getSPIT_Type(p_ID);
        }
        return o_SPIT_Type_Interface != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_Type_Interface getSPIT_Type(String p_ID) {
        SPIT_Type_Interface o_SPIT_Type_Interface;
        Object object = this.m_SyncObject;
        synchronized (object) {
            o_SPIT_Type_Interface = this.m_SPIT_TypesByID.get(p_ID);
        }
        return o_SPIT_Type_Interface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface) {
        int intRow;
        if (p_SPIT_Type_Interface == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Types.indexOf(p_SPIT_Type_Interface);
            if (intRow >= 0) {
                this.fireTableRowsUpdated(intRow, intRow);
                return false;
            }
            this.m_SPIT_Types.add(p_SPIT_Type_Interface);
            intRow = this.m_SPIT_Types.size() - 1;
            this.m_SPIT_TypesByID.put(p_SPIT_Type_Interface.getID(), p_SPIT_Type_Interface);
            p_SPIT_Type_Interface.addPropertyChangeListener(this);
            this.m_SPIT_TypeListModel.addSorted(p_SPIT_Type_Interface);
            p_SPIT_Type_Interface.addPropertyChangeListener(this.m_SPIT_TypeListModel);
        }
        this.fireTableRowsInserted(intRow, intRow);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface) {
        int intIndex;
        if (p_SPIT_Type_Interface == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intIndex = this.m_SPIT_Types.indexOf(p_SPIT_Type_Interface);
            if (intIndex < 0) {
                return false;
            }
            this.m_SPIT_Types.remove(p_SPIT_Type_Interface);
            this.m_SPIT_TypesByID.remove(p_SPIT_Type_Interface.getID());
            p_SPIT_Type_Interface.removePropertyChangeListener(this);
            this.m_SPIT_TypeListModel.removeSPITType(p_SPIT_Type_Interface);
            p_SPIT_Type_Interface.removePropertyChangeListener(this.m_SPIT_TypeListModel);
        }
        this.fireTableRowsDeleted(intIndex, intIndex);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowOfSPIT_Type(SPIT_Type_Interface p_SPIT_Type_Interface) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_SPIT_Types.indexOf(p_SPIT_Type_Interface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedSPIT_Type(JTable p_JTable, SPIT_Type_Interface p_SPIT_Type_Interface) {
        int intRow;
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_Type_Interface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Types.indexOf(p_SPIT_Type_Interface);
            if (intRow < 0) {
                return;
            }
            intRow = p_JTable.convertRowIndexToView(intRow);
        }
        p_JTable.setRowSelectionInterval(intRow, intRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedSPIT_Type(JTable p_JTable, SPIT_Type_Interface p_SPIT_Type_Interface) {
        int intRow;
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_Type_Interface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Types.indexOf(p_SPIT_Type_Interface);
            if (intRow < 0) {
                return;
            }
            intRow = p_JTable.convertRowIndexToView(intRow);
        }
        p_JTable.removeRowSelectionInterval(intRow, intRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_Type_Interface getSPIT_Type(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_SPIT_Types.size()) {
                return null;
            }
            return this.m_SPIT_Types.get(p_Index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getSPIT_Types() {
        Object[] o_SPIT_TypeInterfaces;
        Object object = this.m_SyncObject;
        synchronized (object) {
            o_SPIT_TypeInterfaces = this.m_SPIT_Types.toArray();
        }
        return o_SPIT_TypeInterfaces;
    }

    @Override
    public int getRowCount() {
        return this.m_SPIT_Types.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    public void setColumnName(int p_Column, String p_ColumnName) {
        if (p_ColumnName == null) {
            return;
        }
        if (p_Column < 0 || p_Column >= 4) {
            return;
        }
        switch (p_Column) {
            case 0: {
                COLUMN_GROUPNAME = p_ColumnName;
                break;
            }
            case 1: {
                COLUMN_TYPENAME = p_ColumnName;
                break;
            }
            case 2: {
                COLUMN_DELAYNAME = p_ColumnName;
                break;
            }
            case 3: {
                COLUMN_DURATIONNAME = p_ColumnName;
            }
        }
        this.fireTableStructureChanged();
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return COLUMN_GROUPNAME;
            }
            case 1: {
                return COLUMN_TYPENAME;
            }
            case 2: {
                return COLUMN_DELAYNAME;
            }
            case 3: {
                return COLUMN_DURATIONNAME;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String stringValue = "";
        Object object = this.m_SyncObject;
        synchronized (object) {
            SPIT_Type_Interface o_SPIT_Type_Interface = this.getSPIT_Type(rowIndex);
            if (o_SPIT_Type_Interface == null) {
                return stringValue;
            }
            switch (columnIndex) {
                case 0: {
                    stringValue = o_SPIT_Type_Interface.getGroupName();
                    break;
                }
                case 1: {
                    stringValue = o_SPIT_Type_Interface.getName();
                    break;
                }
                case 2: {
                    stringValue = SPIT_TimeTools.getTimeStringFromFrames(o_SPIT_Type_Interface.getDelay(), FRAMESPERSECOND);
                    break;
                }
                case 3: {
                    stringValue = SPIT_TimeTools.getTimeStringFromFrames(o_SPIT_Type_Interface.getDuration(), FRAMESPERSECOND);
                }
            }
            return stringValue;
        }
    }

    public Class<? extends Object> getColumnClass(int c) {
        Object o_Value = this.getValueAt(0, c);
        if (o_Value == null) {
            return Object.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object value, int row, int col) {
        SPIT_Type_Interface o_SPIT_Type_Interface;
        if (!(value instanceof String)) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (row < 0 || row >= this.m_SPIT_Types.size()) {
                return;
            }
            o_SPIT_Type_Interface = this.m_SPIT_Types.get(row);
            if (o_SPIT_Type_Interface == null) {
                return;
            }
        }
        switch (col) {
            case 0: {
                String stringValue = (String)value;
                o_SPIT_Type_Interface.setGroupName(stringValue);
                break;
            }
            case 1: {
                String stringValue = (String)value;
                o_SPIT_Type_Interface.setName(stringValue);
                break;
            }
            case 2: {
                String stringValue = (String)value;
                long longFrames = SPIT_TimeTools.getFramesFromTimeString(stringValue, FRAMESPERSECOND);
                o_SPIT_Type_Interface.setDelay(longFrames);
                break;
            }
            case 3: {
                String stringValue = (String)value;
                long longFrames = SPIT_TimeTools.getFramesFromTimeString(stringValue, FRAMESPERSECOND);
                o_SPIT_Type_Interface.setDuration(longFrames);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPIT_Type_Interface) {
            int intRow;
            Object object = this.m_SyncObject;
            synchronized (object) {
                intRow = this.m_SPIT_Types.indexOf(evt.getSource());
                if (intRow < 0) {
                    return;
                }
            }
            if ("paramchanged".equals(evt.getPropertyName())) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SPIT_TypeModel.this.fireTableRowsUpdated(intRow, intRow);
                    }
                });
            } else if ("confirmed".equals(evt.getPropertyName())) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SPIT_TypeModel.this.fireTableRowsUpdated(intRow, intRow);
                    }
                });
            }
        }
    }

    public static class SPIT_TypeLListRenderer
    extends DefaultListCellRenderer {
        public static Dimension s_DimensionIcon = new Dimension(20, 20);

        public SPIT_TypeLListRenderer() {
            this.initMembers();
        }

        private void initMembers() {
        }

        private void initComponents() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value == null || !(value instanceof SPIT_Type_Interface)) {
                this.setIcon(null);
                this.setText("");
            } else {
                SPIT_Type_Interface o_SPIT_Type_Interface = (SPIT_Type_Interface)value;
                this.setIcon(o_SPIT_Type_Interface.getIcon());
                this.setText(o_SPIT_Type_Interface.getName());
            }
            return this;
        }
    }

    public static class SPIT_TypeListModel
    extends DefaultComboBoxModel<SPIT_Type_Interface>
    implements PropertyChangeListener {
        private final Object m_SyncObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Object object = this.m_SyncObject;
            synchronized (object) {
                for (int intType = super.getSize() - 1; intType >= 0; --intType) {
                    SPIT_Type_Interface o_SPIT_Type_Interface = this.getElementAt(intType);
                    this.removeSPITType(o_SPIT_Type_Interface);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSPITType(SPIT_Type_Interface p_SPIT_Type_Interface) {
            if (p_SPIT_Type_Interface == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intIndex = this.getIndexOf(p_SPIT_Type_Interface);
                if (intIndex >= 0) {
                    return;
                }
                this.addSorted(p_SPIT_Type_Interface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSPITType(SPIT_Type_Interface p_SPIT_Type_Interface) {
            if (p_SPIT_Type_Interface == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intIndex = this.getIndexOf(p_SPIT_Type_Interface);
                if (intIndex < 0) {
                    return;
                }
                this.removeElementAt(intIndex);
            }
            p_SPIT_Type_Interface.removePropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addSorted(SPIT_Type_Interface p_SPIT_Type_Interface) {
            if (p_SPIT_Type_Interface == null) {
                return;
            }
            Object object = this.m_SyncObject;
            synchronized (object) {
                SPIT_Type_Interface o_SPIT_Type_Interface;
                int intType;
                for (intType = 0; intType < this.getSize() && (o_SPIT_Type_Interface = this.getElementAt(intType)).getName().compareToIgnoreCase(p_SPIT_Type_Interface.getName()) < 0; ++intType) {
                }
                super.insertElementAt(p_SPIT_Type_Interface, intType);
            }
            p_SPIT_Type_Interface.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resort(SPIT_Type_Interface p_SPIT_Type_Interface) {
            if (p_SPIT_Type_Interface == null) {
                return;
            }
            boolean boolWasSelected = false;
            Object object = this.m_SyncObject;
            synchronized (object) {
                int intIndex = this.getIndexOf(p_SPIT_Type_Interface);
                if (intIndex < 0) {
                    return;
                }
                if (p_SPIT_Type_Interface == this.getSelectedItem()) {
                    boolWasSelected = true;
                }
                this.removeElementAt(intIndex);
            }
            p_SPIT_Type_Interface.removePropertyChangeListener(this);
            this.addSPITType(p_SPIT_Type_Interface);
            if (boolWasSelected) {
                this.setSelectedItem(p_SPIT_Type_Interface);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SPIT_Type_Interface getElementAt(int p_Index) {
            Object object = this.m_SyncObject;
            synchronized (object) {
                return (SPIT_Type_Interface)super.getElementAt(p_Index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof SPIT_Type_Interface) {
                int intIndex;
                Object object = this.m_SyncObject;
                synchronized (object) {
                    intIndex = this.getIndexOf(evt.getSource());
                    if (intIndex < 0) {
                        return;
                    }
                }
                if ("paramchanged".equals(evt.getPropertyName())) {
                    this.resort((SPIT_Type_Interface)evt.getSource());
                } else if ("confirmed".equals(evt.getPropertyName())) {
                    this.fireContentsChanged(this, intIndex, intIndex);
                }
            }
        }
    }

    public static class SPITTypeTableCellRenderer
    extends JLabel
    implements TableCellRenderer,
    Serializable {
        private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
        protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;
        private Color m_UnselectedForeground;
        private Color m_UnselectedBackground;
        public static Color s_NotConfirmedColor = new Color(255, 200, 200);
        public static Color s_FIXEDColor = new Color(0, 100, 0);

        public SPITTypeTableCellRenderer(int p_FontSize) {
            super.setFont(new Font(this.getFont().getFamily(), 0, p_FontSize));
            this.setOpaque(true);
            this.setBorder(this.getNoFocusBorder());
            this.setName("Table.cellRenderer");
        }

        private Border getNoFocusBorder() {
            return this.m_NoFocusBorder;
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.m_UnselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.m_UnselectedBackground = c;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTable.DropLocation dropLocation;
            Color colorBackground = table.getBackground();
            Color colorForeground = table.getForeground();
            if (table.getModel() instanceof SPIT_TypeModel) {
                SPIT_Type_Interface o_SPIT_Type_Interface;
                SPIT_TypeModel o_SPITTypeTableModel = (SPIT_TypeModel)table.getModel();
                try {
                    int intRowModel = table.convertRowIndexToModel(row);
                    o_SPIT_Type_Interface = o_SPITTypeTableModel.getSPIT_Type(intRowModel);
                }
                catch (Exception e) {
                    o_SPIT_Type_Interface = null;
                }
                if (o_SPIT_Type_Interface != null) {
                    if (!o_SPIT_Type_Interface.getConfirmed()) {
                        colorBackground = s_NotConfirmedColor;
                    }
                    if (o_SPIT_Type_Interface.getFixed()) {
                        colorForeground = s_FIXEDColor;
                    }
                }
            }
            if ((dropLocation = table.getDropLocation()) != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
                isSelected = true;
            }
            try {
                if (table.convertColumnIndexToModel(column) == 0) {
                    this.setIcon(null);
                } else {
                    this.setIcon(null);
                }
            }
            catch (Exception e) {
                this.setIcon(null);
            }
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(colorForeground);
                super.setBackground(colorBackground);
            }
            this.setFont(super.getFont());
            if (hasFocus) {
                this.setBorder(this.m_NoFocusBorder);
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = table.getForeground();
                    super.setForeground(col);
                    col = table.getBackground();
                    super.setBackground(col);
                }
            } else {
                this.setBorder(this.getNoFocusBorder());
            }
            this.setText(value == null ? "" : value.toString());
            return this;
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void repaint() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if ("text".equals(propertyName) || "labelFor".equals(propertyName) || "displayedMnemonic".equals(propertyName) || ("font".equals(propertyName) || "foreground".equals(propertyName)) && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        public static class UIResource
        extends DefaultTableCellRenderer
        implements javax.swing.plaf.UIResource {
        }
    }

    public static class SPITRowFilter
    extends RowFilter<SPIT_Type_Interface, Integer> {
        private SPIT_TypeModel m_SPIT_TypeModel;
        private String m_FilterString;

        public SPITRowFilter(SPIT_TypeModel p_SPIT_TypeModel) {
            this.initMembers();
            this.m_SPIT_TypeModel = p_SPIT_TypeModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_SPIT_TypeModel != null) {
                this.m_SPIT_TypeModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_SPIT_TypeModel == null) {
                return false;
            }
            int intRow = (Integer)entry.getIdentifier();
            SPIT_Type_Interface o_SPIT_Type_Interface = this.m_SPIT_TypeModel.getSPIT_Type(intRow);
            if (o_SPIT_Type_Interface == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            if (o_SPIT_Type_Interface.getGroupName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            return o_SPIT_Type_Interface.getName().toLowerCase().contains(this.m_FilterString);
        }
    }

    public static class StringComparator_Time
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            Long milli2;
            Long milli1;
            if (o1 == null || o2 == null) {
                return 0;
            }
            try {
                milli1 = SPIT_TimeTools.getMillisecondsFromString(o1);
                milli2 = SPIT_TimeTools.getMillisecondsFromString(o2);
            }
            catch (Exception e) {
                return 0;
            }
            return milli1.compareTo(milli2);
        }
    }

    public static class StringComparator_NumericInteger
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            Integer int2;
            Integer int1;
            if (o1 == null || o2 == null) {
                return 0;
            }
            try {
                int1 = Integer.valueOf(o1);
                int2 = Integer.valueOf(o2);
            }
            catch (Exception e) {
                return 0;
            }
            return int1.compareTo(int2);
        }
    }

    public static class StringComparator_Normal
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

