/*
 * Decompiled with CFR 0.152.
 */
package SwingModelPackage;

import SPITLibraryPackage.SPIT_ClientInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class SPITClientTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int COLUMNCOUNT = 3;
    public static final int COLUMNINDEX_CLIENTCMPUTERNAME = 0;
    public static final int COLUMNINDEX_CLIENTNAME = 1;
    public static final int COLUMNINDEX_CLIENTPROJECTNAME = 2;
    public static String COLUMN_CLIENTCOMPUTERNAME = "Computer";
    public static String COLUMN_CLIENTNAME = "Client";
    public static String COLUMN_CLIENTPROJECTNAME = "Project";
    public static boolean s_LanguageLoaded = false;
    private ArrayList<SPIT_ClientInterface> m_SPIT_Clients;
    private TableRowSorter m_TableRowSorter;
    private final Object m_SyncObject = new Object();

    public SPITClientTableModel() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_SPIT_Clients = new ArrayList();
        this.m_TableRowSorter = new TableRowSorter<SPITClientTableModel>(this);
    }

    public void finishJTable(JTable p_JTable) {
        if (p_JTable == null) {
            return;
        }
        p_JTable.setRowSorter(this.m_TableRowSorter);
        this.fireTableStructureChanged();
        this.m_TableRowSorter.setComparator(1, new StringComparator_Normal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int intLastRow;
        Object object = this.m_SyncObject;
        synchronized (object) {
            intLastRow = this.m_SPIT_Clients.size() - 1;
            this.m_SPIT_Clients.clear();
        }
        if (intLastRow >= 0) {
            this.fireTableRowsDeleted(0, intLastRow);
        }
    }

    public boolean contains(SPIT_ClientInterface p_SPIT_ClientInterface) {
        if (p_SPIT_ClientInterface == null) {
            return false;
        }
        return this.m_SPIT_Clients.contains(p_SPIT_ClientInterface);
    }

    public boolean contains(String p_ID) {
        if (p_ID == null) {
            return false;
        }
        SPIT_ClientInterface o_SPIT_ClientInterface = this.getSPIT_ClientInterface(p_ID);
        return o_SPIT_ClientInterface != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_ClientInterface getSPIT_ClientInterface(String p_ID) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intClient = 0; intClient < this.m_SPIT_Clients.size(); ++intClient) {
                SPIT_ClientInterface o_SPIT_ClientInterface = this.m_SPIT_Clients.get(intClient);
                if (o_SPIT_ClientInterface == null || !p_ID.equals(o_SPIT_ClientInterface.getID())) continue;
                return o_SPIT_ClientInterface;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
        int intRow;
        if (p_SPIT_ClientInterface == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Clients.indexOf(p_SPIT_ClientInterface);
            if (intRow >= 0) {
                this.fireTableRowsUpdated(intRow, intRow);
                return false;
            }
            this.m_SPIT_Clients.add(p_SPIT_ClientInterface);
            intRow = this.m_SPIT_Clients.size() - 1;
            p_SPIT_ClientInterface.addPropertyChangeListener(this);
        }
        this.fireTableRowsInserted(intRow, intRow);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
        int intRow;
        if (p_SPIT_ClientInterface == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Clients.indexOf(p_SPIT_ClientInterface);
            if (intRow < 0) {
                return false;
            }
            this.m_SPIT_Clients.remove(intRow);
            p_SPIT_ClientInterface.removePropertyChangeListener(this);
        }
        this.fireTableRowsDeleted(intRow, intRow);
        return true;
    }

    public int getRowOfSPIT_ClientInterface(SPIT_ClientInterface p_SPIT_ClientInterface) {
        return this.m_SPIT_Clients.indexOf(p_SPIT_ClientInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedSPIT_ClientInterface(JTable p_JTable, SPIT_ClientInterface p_SPIT_ClientInterface) {
        int intRow;
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_ClientInterface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Clients.indexOf(p_SPIT_ClientInterface);
            if (intRow < 0) {
                return;
            }
            intRow = p_JTable.convertRowIndexToView(intRow);
        }
        p_JTable.setRowSelectionInterval(intRow, intRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedSPIT_ClientInterface(JTable p_JTable, SPIT_ClientInterface p_SPIT_ClientInterface) {
        int intRow;
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_ClientInterface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Clients.indexOf(p_SPIT_ClientInterface);
            if (intRow < 0) {
                return;
            }
            intRow = p_JTable.convertRowIndexToView(intRow);
        }
        p_JTable.removeRowSelectionInterval(intRow, intRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_ClientInterface getSPIT_ClientInterface(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_SPIT_Clients.size()) {
                return null;
            }
            return this.m_SPIT_Clients.get(p_Index);
        }
    }

    public ArrayList<SPIT_ClientInterface> getArrayList() {
        return this.m_SPIT_Clients;
    }

    @Override
    public int getRowCount() {
        return this.m_SPIT_Clients.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 1: {
                return COLUMN_CLIENTNAME;
            }
            case 0: {
                return COLUMN_CLIENTCOMPUTERNAME;
            }
            case 2: {
                return COLUMN_CLIENTPROJECTNAME;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String stringValue = "";
        Object object = this.m_SyncObject;
        synchronized (object) {
            SPIT_ClientInterface o_SPIT_ClientInterface = this.getSPIT_ClientInterface(rowIndex);
            if (o_SPIT_ClientInterface == null) {
                return stringValue;
            }
            switch (columnIndex) {
                case 1: {
                    stringValue = o_SPIT_ClientInterface.getName();
                    break;
                }
                case 0: {
                    stringValue = o_SPIT_ClientInterface.getClientComputerName();
                    break;
                }
                case 2: {
                    stringValue = o_SPIT_ClientInterface.getClientProjectName();
                }
            }
            return stringValue;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object value, int row, int col) {
        if (!(value instanceof String)) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (row < 0 || row >= this.m_SPIT_Clients.size()) {
                return;
            }
            SPIT_ClientInterface o_SPIT_ClientInterface = this.m_SPIT_Clients.get(row);
            if (o_SPIT_ClientInterface == null) {
                return;
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPIT_ClientInterface) {
            int intRow;
            Object object = this.m_SyncObject;
            synchronized (object) {
                intRow = this.m_SPIT_Clients.indexOf(evt.getSource());
                if (intRow < 0) {
                    return;
                }
            }
            this.fireTableRowsUpdated(intRow, intRow);
        }
    }

    public static class SPIT_ClientInterfaceTableCellRenderer
    extends JLabel
    implements TableCellRenderer,
    Serializable {
        private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
        protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;
        private Color m_UnselectedForeground;
        private Color m_UnselectedBackground;
        public static Color s_NotConfirmedColor = new Color(255, 200, 200);
        public static Color s_FIXEDColor = new Color(0, 100, 0);

        public SPIT_ClientInterfaceTableCellRenderer(int p_FontSize) {
            super.setFont(new Font(this.getFont().getFamily(), 0, p_FontSize));
            this.setOpaque(true);
            this.setBorder(this.getNoFocusBorder());
            this.setName("Table.cellRenderer");
        }

        private Border getNoFocusBorder() {
            return this.m_NoFocusBorder;
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.m_UnselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.m_UnselectedBackground = c;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTable.DropLocation dropLocation;
            Color colorBackground = table.getBackground();
            Color colorForeground = table.getForeground();
            if (table.getModel() instanceof SPITClientTableModel) {
                SPITClientTableModel o_SPITClientTableModel = (SPITClientTableModel)table.getModel();
                try {
                    int intRowModel = table.convertRowIndexToModel(row);
                    SPIT_ClientInterface o_SPIT_ClientInterface = o_SPITClientTableModel.getSPIT_ClientInterface(intRowModel);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((dropLocation = table.getDropLocation()) != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
                isSelected = true;
            }
            try {
                if (table.convertColumnIndexToModel(column) == 0) {
                    this.setIcon(null);
                } else {
                    this.setIcon(null);
                }
            }
            catch (Exception e) {
                this.setIcon(null);
            }
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(colorForeground);
                super.setBackground(colorBackground);
            }
            this.setFont(super.getFont());
            if (hasFocus) {
                this.setBorder(this.m_NoFocusBorder);
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = table.getForeground();
                    super.setForeground(col);
                    col = table.getBackground();
                    super.setBackground(col);
                }
            } else {
                this.setBorder(this.getNoFocusBorder());
            }
            this.setText(value == null ? "" : value.toString());
            return this;
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void repaint() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if ("text".equals(propertyName) || "labelFor".equals(propertyName) || "displayedMnemonic".equals(propertyName) || ("font".equals(propertyName) || "foreground".equals(propertyName)) && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        public static class UIResource
        extends DefaultTableCellRenderer
        implements javax.swing.plaf.UIResource {
        }
    }

    public static class StringComparator_NumericInteger
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            Integer int2;
            Integer int1;
            if (o1 == null || o2 == null) {
                return 0;
            }
            try {
                int1 = Integer.valueOf(o1);
                int2 = Integer.valueOf(o2);
            }
            catch (Exception e) {
                return 0;
            }
            return int1.compareTo(int2);
        }
    }

    public static class StringComparator_Normal
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

