/*
 * Decompiled with CFR 0.152.
 */
package SwingModelPackage;

import SPITActionPackage.SPIT_ActionStatus;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import SwingModelPackage.SPIT_TimeTools;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class SPIT_ObjectModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int COLUMNCOUNT = 7;
    public static final int COLUMNINDEX_OBJECTPLAYTIME = 0;
    public static final int COLUMNINDEX_OBJECTPLAYVALUE = 1;
    public static final int COLUMNINDEX_OBJECTSTARTTIME = 2;
    public static final int COLUMNINDEX_OBJECTNAME = 3;
    public static final int COLUMNINDEX_OBJECTDELAY = 4;
    public static final int COLUMNINDEX_OBJECTDURATION = 5;
    public static final int COLUMNINDEX_OBJECTSPITTYPE = 6;
    public static String COLUMN_OBJECTPLAYTIME = "Time";
    public static String COLUMN_OBJECTPLAYVALUE = "Value %";
    public static String COLUMN_OBJECTSTARTTIME = "Start";
    public static String COLUMN_OBJECTNAME = "Name";
    public static String COLUMN_OBJECTDELAY = "Delay";
    public static String COLUMN_OBJECTDURATION = "Duration";
    public static String COLUMN_OBJECTSPITTYPE = "TriggerType";
    public static double FRAMESPERSECOND = 44100.0;
    private ArrayList<SPIT_Object_Interface> m_SPIT_Objects;
    private TableRowSorter m_TableRowSorter;
    private SPITRowFilter m_SPITRowFilter;
    private final Object m_SyncObject = new Object();

    public SPIT_ObjectModel() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_SPIT_Objects = new ArrayList();
        this.m_TableRowSorter = new TableRowSorter<SPIT_ObjectModel>(this);
        this.m_SPITRowFilter = new SPITRowFilter(this);
    }

    public void finishJTable(JTable p_JTable) {
        if (p_JTable == null) {
            return;
        }
        p_JTable.setRowSorter(this.m_TableRowSorter);
        this.fireTableStructureChanged();
        this.m_TableRowSorter.setComparator(3, new StringComparator_Normal());
        this.m_TableRowSorter.setRowFilter(this.m_SPITRowFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int intLastRow;
        Object object = this.m_SyncObject;
        synchronized (object) {
            intLastRow = this.m_SPIT_Objects.size() - 1;
            this.m_SPIT_Objects.clear();
        }
        if (intLastRow >= 0) {
            this.fireTableRowsDeleted(0, intLastRow);
        }
    }

    public void filter(String p_FilterString) {
        if (this.m_SPITRowFilter == null) {
            return;
        }
        this.m_SPITRowFilter.setFilterString(p_FilterString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_SPIT_Objects.contains(p_SPIT_Type_Interface);
        }
    }

    public boolean contains(String p_ID) {
        if (p_ID == null) {
            return false;
        }
        SPIT_Object_Interface o_SPIT_Object_Interface = this.getSPIT_Object(p_ID);
        return o_SPIT_Object_Interface != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_Object_Interface getSPIT_Object(String p_ID) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intType = 0; intType < this.m_SPIT_Objects.size(); ++intType) {
                SPIT_Object_Interface o_SPIT_Object_Interface = this.m_SPIT_Objects.get(intType);
                if (o_SPIT_Object_Interface == null || !p_ID.equals(o_SPIT_Object_Interface.getID())) continue;
                return o_SPIT_Object_Interface;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
        int intRow;
        if (p_SPIT_Object_Interface == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
            if (intRow >= 0) {
                this.fireTableRowsUpdated(intRow, intRow);
                return false;
            }
            this.m_SPIT_Objects.add(p_SPIT_Object_Interface);
            intRow = this.m_SPIT_Objects.size() - 1;
            p_SPIT_Object_Interface.addPropertyChangeListener(this);
        }
        this.fireTableRowsInserted(intRow, intRow);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
        int intRow;
        if (p_SPIT_Object_Interface == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
            if (intRow < 0) {
                return false;
            }
            this.m_SPIT_Objects.remove(intRow);
            p_SPIT_Object_Interface.removePropertyChangeListener(this);
        }
        this.fireTableRowsDeleted(intRow, intRow);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowOfSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedSPIT_Object(JTable p_JTable, SPIT_Object_Interface p_SPIT_Object_Interface) {
        int intRow;
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
            if (intRow < 0) {
                return;
            }
            intRow = p_JTable.convertRowIndexToView(intRow);
        }
        p_JTable.setRowSelectionInterval(intRow, intRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedSPIT_Object(JTable p_JTable, SPIT_Object_Interface p_SPIT_Object_Interface) {
        int intRow;
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
            if (intRow < 0) {
                return;
            }
            intRow = p_JTable.convertRowIndexToView(intRow);
        }
        p_JTable.removeRowSelectionInterval(intRow, intRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_Object_Interface getSPIT_Object(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_SPIT_Objects.size()) {
                return null;
            }
            return this.m_SPIT_Objects.get(p_Index);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_SPIT_Objects.size();
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return COLUMN_OBJECTPLAYTIME;
            }
            case 1: {
                return COLUMN_OBJECTPLAYVALUE;
            }
            case 2: {
                return COLUMN_OBJECTSTARTTIME;
            }
            case 3: {
                return COLUMN_OBJECTNAME;
            }
            case 4: {
                return COLUMN_OBJECTDELAY;
            }
            case 5: {
                return COLUMN_OBJECTDURATION;
            }
            case 6: {
                return COLUMN_OBJECTSPITTYPE;
            }
        }
        return "";
    }

    public Class<? extends Object> getColumnClass(int c) {
        Object o_Value = this.getValueAt(0, c);
        if (o_Value == null) {
            return Object.class;
        }
        return this.getValueAt(0, c).getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String stringValue = "";
        Object object = this.m_SyncObject;
        synchronized (object) {
            SPIT_Object_Interface o_SPIT_Object_Interface = this.getSPIT_Object(rowIndex);
            if (o_SPIT_Object_Interface == null) {
                return stringValue;
            }
            SPIT_ActionStatus o_SPIT_ActionStatus = o_SPIT_Object_Interface.getSPIT_ActionStatus();
            switch (columnIndex) {
                case 0: {
                    if (o_SPIT_ActionStatus.getPlayFrameInside() < 0L) {
                        stringValue = "";
                        break;
                    }
                    stringValue = String.valueOf(o_SPIT_ActionStatus.getPlayFrameInside());
                    break;
                }
                case 1: {
                    if (o_SPIT_ActionStatus.getPlayValue() == 0) {
                        stringValue = "";
                        break;
                    }
                    stringValue = String.valueOf((int)((float)o_SPIT_ActionStatus.getPlayValue() * ((float)o_SPIT_Object_Interface.getValueFactor() / 1000000.0f) / 10000.0f));
                    break;
                }
                case 2: {
                    stringValue = String.valueOf(o_SPIT_Object_Interface.getFrameStart());
                    break;
                }
                case 3: {
                    stringValue = o_SPIT_Object_Interface.getName();
                    break;
                }
                case 4: {
                    stringValue = SPIT_TimeTools.getTimeStringFromFrames(o_SPIT_Object_Interface.getDelay(), FRAMESPERSECOND);
                    break;
                }
                case 5: {
                    stringValue = SPIT_TimeTools.getTimeStringFromFrames(o_SPIT_Object_Interface.getDuration(), FRAMESPERSECOND);
                    break;
                }
                case 6: {
                    SPIT_Type_Interface o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type();
                    if (o_SPIT_Type_Interface == null) {
                        return "";
                    }
                    stringValue = o_SPIT_Type_Interface.getName();
                }
            }
            return stringValue;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 6: {
                return false;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object value, int row, int col) {
        SPIT_Object_Interface o_SPIT_Object_Interface;
        if (!(value instanceof String)) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (row < 0 || row >= this.m_SPIT_Objects.size()) {
                return;
            }
            o_SPIT_Object_Interface = this.m_SPIT_Objects.get(row);
            if (o_SPIT_Object_Interface == null) {
                return;
            }
        }
        switch (col) {
            case 3: {
                String stringValue = (String)value;
                o_SPIT_Object_Interface.setName(stringValue);
                break;
            }
            case 4: {
                String stringValue = (String)value;
                long longFrames = SPIT_TimeTools.getFramesFromTimeString(stringValue, FRAMESPERSECOND);
                o_SPIT_Object_Interface.setDelay(longFrames);
                break;
            }
            case 5: {
                String stringValue = (String)value;
                long longFrames = SPIT_TimeTools.getFramesFromTimeString(stringValue, FRAMESPERSECOND);
                o_SPIT_Object_Interface.setDuration(longFrames);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPIT_Object_Interface) {
            int intRow;
            Object object = this.m_SyncObject;
            synchronized (object) {
                intRow = this.m_SPIT_Objects.indexOf(evt.getSource());
                if (intRow < 0) {
                    return;
                }
            }
            if ("paramchanged".equals(evt.getPropertyName())) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SPIT_ObjectModel.this.fireTableRowsUpdated(intRow, intRow);
                    }
                });
            } else if ("confirmed".equals(evt.getPropertyName())) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SPIT_ObjectModel.this.fireTableRowsUpdated(intRow, intRow);
                    }
                });
            }
        }
    }

    public static class SPITObjectTableCellRenderer
    extends JLabel
    implements TableCellRenderer,
    Serializable {
        private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
        protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;
        private Color m_UnselectedForeground;
        private Color m_UnselectedBackground;
        public static Color s_NotConfirmedColor = new Color(255, 200, 200);
        public static Color s_FIXEDColor = new Color(0, 100, 0);

        public SPITObjectTableCellRenderer(int p_FontSize) {
            super.setFont(new Font(this.getFont().getFamily(), 0, p_FontSize));
            this.setOpaque(true);
            this.setBorder(this.getNoFocusBorder());
            this.setName("Table.cellRenderer");
        }

        private Border getNoFocusBorder() {
            return this.m_NoFocusBorder;
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.m_UnselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.m_UnselectedBackground = c;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTable.DropLocation dropLocation;
            Color colorBackground = table.getBackground();
            Color colorForeground = table.getForeground();
            if (table.getModel() instanceof SPIT_ObjectModel) {
                SPIT_Object_Interface o_SPIT_Object_Interface;
                SPIT_ObjectModel o_SPITObjectTableModel = (SPIT_ObjectModel)table.getModel();
                try {
                    int intRowModel = table.convertRowIndexToModel(row);
                    o_SPIT_Object_Interface = o_SPITObjectTableModel.getSPIT_Object(intRowModel);
                }
                catch (Exception e) {
                    o_SPIT_Object_Interface = null;
                }
                if (o_SPIT_Object_Interface != null) {
                    if (!o_SPIT_Object_Interface.getConfirmed()) {
                        colorBackground = s_NotConfirmedColor;
                    }
                    if (o_SPIT_Object_Interface.getRemark().length() > 0) {
                        this.setToolTipText(o_SPIT_Object_Interface.getRemark());
                    } else {
                        this.setToolTipText(null);
                    }
                }
            }
            if ((dropLocation = table.getDropLocation()) != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
                isSelected = true;
            }
            if (table.convertColumnIndexToModel(column) == 0) {
                this.setIcon(null);
            } else {
                this.setIcon(null);
            }
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(colorForeground);
                super.setBackground(colorBackground);
            }
            this.setFont(super.getFont());
            if (hasFocus) {
                this.setBorder(this.m_NoFocusBorder);
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = table.getForeground();
                    super.setForeground(col);
                    col = table.getBackground();
                    super.setBackground(col);
                }
            } else {
                this.setBorder(this.getNoFocusBorder());
            }
            this.setText(value == null ? "" : value.toString());
            return this;
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void repaint() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if ("text".equals(propertyName) || "labelFor".equals(propertyName) || "displayedMnemonic".equals(propertyName) || ("font".equals(propertyName) || "foreground".equals(propertyName)) && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        public static class UIResource
        extends DefaultTableCellRenderer
        implements javax.swing.plaf.UIResource {
        }
    }

    public static class SPITRowFilter
    extends RowFilter<SPIT_Object_Interface, Integer> {
        private SPIT_ObjectModel m_SPIT_ObjectModel;
        private String m_FilterString;

        public SPITRowFilter(SPIT_ObjectModel p_SPIT_ObjectModel) {
            this.initMembers();
            this.m_SPIT_ObjectModel = p_SPIT_ObjectModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_SPIT_ObjectModel != null) {
                this.m_SPIT_ObjectModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_SPIT_ObjectModel == null) {
                return false;
            }
            int intRow = (Integer)entry.getIdentifier();
            SPIT_Object_Interface o_SPIT_Object_Interface = this.m_SPIT_ObjectModel.getSPIT_Object(intRow);
            if (o_SPIT_Object_Interface == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            if (o_SPIT_Object_Interface.getName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            SPIT_Type_Interface o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type();
            if (o_SPIT_Type_Interface == null) {
                return false;
            }
            if (o_SPIT_Type_Interface.getGroupName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            return o_SPIT_Type_Interface.getName().toLowerCase().contains(this.m_FilterString);
        }
    }

    public static class StringComparator_NumericInteger
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            Integer int2;
            Integer int1;
            if (o1 == null || o2 == null) {
                return 0;
            }
            try {
                int1 = Integer.valueOf(o1);
                int2 = Integer.valueOf(o2);
            }
            catch (Exception e) {
                return 0;
            }
            return int1.compareTo(int2);
        }
    }

    public static class StringComparator_Normal
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

