/*
 * Decompiled with CFR 0.152.
 */
package SwingModelPackage;

import SPITActionPackage.SPIT_ActionStatus;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;

public class RemoteSPITObjectTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int COLUMNCOUNT = 4;
    public static final int COLUMNINDEX_SPITTYPEGROUPNAME = 0;
    public static final int COLUMNINDEX_SPITTYPENAME = 1;
    public static final int COLUMNINDEX_OBJECTNAME = 2;
    public static final int COLUMNINDEX_OBJECTPLAYVALUE = 3;
    public static String COLUMN_SPITTYPEGROUPNAME = "Group";
    public static String COLUMN_OBJECTNAME = "Name";
    public static String COLUMN_OBJECTPLAYVALUE = "Value %";
    public static String COLUMN_SPITTYPENAME = "TriggerType";
    public static boolean s_LanguageLoaded = false;
    private ArrayList<SPIT_Object_Interface> m_SPIT_Objects;
    private TableRowSorter m_TableRowSorter;
    private SPITRowFilter m_SPITRowFilter;
    private final Object m_SyncObject = new Object();

    public RemoteSPITObjectTableModel() {
        this.initMembers();
    }

    private void initMembers() {
        this.m_SPIT_Objects = new ArrayList();
        this.m_TableRowSorter = new TableRowSorter<RemoteSPITObjectTableModel>(this);
        this.m_SPITRowFilter = new SPITRowFilter(this);
    }

    public void finishJTable(JTable p_JTable) {
        if (p_JTable == null) {
            return;
        }
        p_JTable.setRowSorter(this.m_TableRowSorter);
        this.fireTableStructureChanged();
        this.m_TableRowSorter.setComparator(2, new StringComparator_Normal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        int intLastRow;
        Object object = this.m_SyncObject;
        synchronized (object) {
            intLastRow = this.m_SPIT_Objects.size() - 1;
            this.m_SPIT_Objects.clear();
        }
        if (intLastRow >= 0) {
            this.fireTableRowsDeleted(0, intLastRow);
        }
    }

    public void filter(String p_FilterString) {
        if (this.m_SPITRowFilter == null) {
            return;
        }
        this.m_SPITRowFilter.setFilterString(p_FilterString);
    }

    public boolean contains(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return false;
        }
        return this.m_SPIT_Objects.contains(p_SPIT_Type_Interface);
    }

    public boolean contains(String p_ID) {
        if (p_ID == null) {
            return false;
        }
        SPIT_Object_Interface o_SPIT_Object_Interface = this.getSPIT_Object(p_ID);
        return o_SPIT_Object_Interface != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_Object_Interface getSPIT_Object(String p_ID) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            for (int intType = 0; intType < this.m_SPIT_Objects.size(); ++intType) {
                SPIT_Object_Interface o_SPIT_Object_Interface = this.m_SPIT_Objects.get(intType);
                if (o_SPIT_Object_Interface == null || !p_ID.equals(o_SPIT_Object_Interface.getID())) continue;
                return o_SPIT_Object_Interface;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
        int intRow;
        if (p_SPIT_Object_Interface == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
            if (intRow >= 0) {
                this.fireTableRowsUpdated(intRow, intRow);
                return false;
            }
            this.m_SPIT_Objects.add(p_SPIT_Object_Interface);
            intRow = this.m_SPIT_Objects.size() - 1;
            p_SPIT_Object_Interface.addPropertyChangeListener(this);
        }
        this.fireTableRowsInserted(intRow, intRow);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
        int intRow;
        if (p_SPIT_Object_Interface == null) {
            return false;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
            if (intRow < 0) {
                return false;
            }
            this.m_SPIT_Objects.remove(p_SPIT_Object_Interface);
            p_SPIT_Object_Interface.removePropertyChangeListener(this);
        }
        this.fireTableRowsDeleted(intRow, intRow);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowOfSPIT_Object(SPIT_Object_Interface p_SPIT_Object_Interface) {
        Object object = this.m_SyncObject;
        synchronized (object) {
            return this.m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectedSPIT_Object(JTable p_JTable, SPIT_Object_Interface p_SPIT_Object_Interface) {
        int intRow;
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
            if (intRow < 0) {
                return;
            }
            intRow = p_JTable.convertRowIndexToView(intRow);
        }
        p_JTable.setRowSelectionInterval(intRow, intRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedSPIT_Object(JTable p_JTable, SPIT_Object_Interface p_SPIT_Object_Interface) {
        int intRow;
        if (p_JTable == null) {
            return;
        }
        if (p_SPIT_Object_Interface == null) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            intRow = this.m_SPIT_Objects.indexOf(p_SPIT_Object_Interface);
            if (intRow < 0) {
                return;
            }
            intRow = p_JTable.convertRowIndexToView(intRow);
        }
        p_JTable.removeRowSelectionInterval(intRow, intRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPIT_Object_Interface getSPIT_Object(int p_Index) {
        if (p_Index < 0) {
            return null;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (p_Index >= this.m_SPIT_Objects.size()) {
                return null;
            }
            return this.m_SPIT_Objects.get(p_Index);
        }
    }

    @Override
    public int getRowCount() {
        return this.m_SPIT_Objects.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return COLUMN_SPITTYPEGROUPNAME;
            }
            case 2: {
                return COLUMN_OBJECTNAME;
            }
            case 3: {
                return COLUMN_OBJECTPLAYVALUE;
            }
            case 1: {
                return COLUMN_SPITTYPENAME;
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String stringValue = "";
        Object object = this.m_SyncObject;
        synchronized (object) {
            SPIT_Object_Interface o_SPIT_Object_Interface = this.getSPIT_Object(rowIndex);
            if (o_SPIT_Object_Interface == null) {
                return stringValue;
            }
            SPIT_ActionStatus o_SPIT_ActionStatus = o_SPIT_Object_Interface.getSPIT_ActionStatus();
            SPIT_Type_Interface o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type();
            switch (columnIndex) {
                case 0: {
                    if (o_SPIT_Type_Interface == null) {
                        return "";
                    }
                    stringValue = o_SPIT_Type_Interface.getGroupName();
                    break;
                }
                case 2: {
                    stringValue = o_SPIT_Object_Interface.getName();
                    break;
                }
                case 3: {
                    if (o_SPIT_ActionStatus.getPlayValue() == 0) {
                        stringValue = "";
                        break;
                    }
                    stringValue = String.valueOf((int)((float)o_SPIT_ActionStatus.getPlayValue() * ((float)o_SPIT_Object_Interface.getValueFactor() / 1000000.0f) / 10000.0f));
                    break;
                }
                case 1: {
                    if (o_SPIT_Type_Interface == null) {
                        return "";
                    }
                    stringValue = o_SPIT_Type_Interface.getName();
                }
            }
            return stringValue;
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 0: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object value, int row, int col) {
        if (!(value instanceof String)) {
            return;
        }
        Object object = this.m_SyncObject;
        synchronized (object) {
            if (row < 0 || row >= this.m_SPIT_Objects.size()) {
                return;
            }
            SPIT_Object_Interface o_SPIT_Object_Interface = this.m_SPIT_Objects.get(row);
            if (o_SPIT_Object_Interface == null) {
                return;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof SPIT_Object_Interface) {
            int intRow;
            SPIT_Object_Interface o_SPIT_Object_Interface = (SPIT_Object_Interface)evt.getSource();
            if ("paramchanged".equals(evt.getPropertyName()) && (intRow = this.getRowOfSPIT_Object(o_SPIT_Object_Interface)) >= 0) {
                this.fireTableRowsUpdated(intRow, intRow);
            }
            if ("confirmed".equals(evt.getPropertyName()) && (intRow = this.getRowOfSPIT_Object(o_SPIT_Object_Interface)) >= 0) {
                this.fireTableRowsUpdated(intRow, intRow);
            }
        }
    }

    public static class RemoteSPITObjectCellRenderer
    extends JLabel
    implements TableCellRenderer,
    Serializable {
        private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
        protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;
        private Color m_UnselectedForeground;
        private Color m_UnselectedBackground;
        public static Color s_NotConfirmedColor = new Color(255, 200, 200);
        public static Color s_FIXEDColor = new Color(0, 100, 0);

        public RemoteSPITObjectCellRenderer(int p_FontSize) {
            super.setFont(new Font(this.getFont().getFamily(), 0, p_FontSize));
            this.setOpaque(true);
            this.setBorder(this.getNoFocusBorder());
            this.setName("Table.cellRenderer");
        }

        private Border getNoFocusBorder() {
            return this.m_NoFocusBorder;
        }

        @Override
        public void setForeground(Color c) {
            super.setForeground(c);
            this.m_UnselectedForeground = c;
        }

        @Override
        public void setBackground(Color c) {
            super.setBackground(c);
            this.m_UnselectedBackground = c;
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setForeground(null);
            this.setBackground(null);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color colorBackground = table.getBackground();
            Color colorForeground = table.getForeground();
            JTable.DropLocation dropLocation = table.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
                isSelected = true;
            }
            try {
                if (table.convertColumnIndexToModel(column) == 0) {
                    this.setIcon(null);
                } else {
                    this.setIcon(null);
                }
            }
            catch (Exception e) {
                this.setIcon(null);
            }
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(colorForeground);
                super.setBackground(colorBackground);
            }
            this.setFont(super.getFont());
            if (hasFocus) {
                this.setBorder(this.m_NoFocusBorder);
                if (!isSelected && table.isCellEditable(row, column)) {
                    Color col = table.getForeground();
                    super.setForeground(col);
                    col = table.getBackground();
                    super.setBackground(col);
                }
            } else {
                this.setBorder(this.getNoFocusBorder());
            }
            this.setText(value == null ? "" : value.toString());
            return this;
        }

        @Override
        public boolean isOpaque() {
            Color back = this.getBackground();
            Container p = this.getParent();
            if (p != null) {
                p = p.getParent();
            }
            boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
            return !colorMatch && super.isOpaque();
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        public void repaint() {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if ("text".equals(propertyName) || "labelFor".equals(propertyName) || "displayedMnemonic".equals(propertyName) || ("font".equals(propertyName) || "foreground".equals(propertyName)) && oldValue != newValue && this.getClientProperty("html") != null) {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        public static class UIResource
        extends DefaultTableCellRenderer
        implements javax.swing.plaf.UIResource {
        }
    }

    public static class SPITRowFilter
    extends RowFilter<SPIT_Object_Interface, Integer> {
        private RemoteSPITObjectTableModel m_RemoteSPITObjectTableModel;
        private String m_FilterString;

        public SPITRowFilter(RemoteSPITObjectTableModel p_SPIT_ObjectModel) {
            this.initMembers();
            this.m_RemoteSPITObjectTableModel = p_SPIT_ObjectModel;
        }

        private void initMembers() {
            this.m_FilterString = null;
        }

        public void setFilterString(String p_FilterString) {
            this.m_FilterString = p_FilterString == null ? "" : p_FilterString.toLowerCase();
            if (this.m_RemoteSPITObjectTableModel != null) {
                this.m_RemoteSPITObjectTableModel.fireTableDataChanged();
            }
        }

        @Override
        public boolean include(RowFilter.Entry entry) {
            if (this.m_RemoteSPITObjectTableModel == null) {
                return false;
            }
            int intRow = (Integer)entry.getIdentifier();
            SPIT_Object_Interface o_SPIT_Object_Interface = this.m_RemoteSPITObjectTableModel.getSPIT_Object(intRow);
            if (o_SPIT_Object_Interface == null) {
                return false;
            }
            if (this.m_FilterString == null) {
                return true;
            }
            if (this.m_FilterString.length() <= 0) {
                return true;
            }
            if (o_SPIT_Object_Interface.getName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            SPIT_Type_Interface o_SPIT_Type_Interface = o_SPIT_Object_Interface.getSPIT_Type();
            if (o_SPIT_Type_Interface == null) {
                return false;
            }
            if (o_SPIT_Type_Interface.getGroupName().toLowerCase().contains(this.m_FilterString)) {
                return true;
            }
            return o_SPIT_Type_Interface.getName().toLowerCase().contains(this.m_FilterString);
        }
    }

    public static class StringComparator_NumericInteger
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            Integer int2;
            Integer int1;
            if (o1 == null || o2 == null) {
                return 0;
            }
            try {
                int1 = Integer.valueOf(o1);
                int2 = Integer.valueOf(o2);
            }
            catch (Exception e) {
                return 0;
            }
            return int1.compareTo(int2);
        }
    }

    public static class StringComparator_Normal
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            if (o1 == null || o2 == null) {
                return 0;
            }
            return o1.compareToIgnoreCase(o2);
        }
    }
}

