/*
 * Decompiled with CFR 0.152.
 */
package SwingModelPackage;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListTools {

    public static class ListRenderer
    extends DefaultListCellRenderer {
        private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(2, 2, 2, 2);
        protected Border m_NoFocusBorder = DEFAULT_NO_FOCUS_BORDER;

        public ListRenderer() {
            this.setHorizontalAlignment(0);
        }

        private Border getNoFocusBorder() {
            return this.m_NoFocusBorder;
        }

        private String getName(Object p_Element) {
            if (p_Element == null) {
                return null;
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod("getName", new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (String)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setComponentOrientation(list.getComponentOrientation());
            Color bg = null;
            Color fg = null;
            JList.DropLocation dropLocation = list.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
                isSelected = true;
            }
            if (isSelected) {
                this.setBackground(bg == null ? list.getSelectionBackground() : bg);
                this.setForeground(fg == null ? list.getSelectionForeground() : fg);
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            String stringName = this.getName(value);
            if (value instanceof Icon) {
                this.setIcon((Icon)value);
                this.setText("");
            } else if (stringName != null) {
                this.setText(stringName);
            } else {
                this.setIcon(null);
                this.setText(value == null ? "" : value.toString());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            Border border = null;
            if (cellHasFocus) {
                if (isSelected) {
                    border = this.getNoFocusBorder();
                }
                if (border == null) {
                    border = this.getNoFocusBorder();
                }
            } else {
                border = this.getNoFocusBorder();
            }
            this.setBorder(border);
            return this;
        }
    }

    public static class ListModelWrapper<T>
    implements MutableComboBoxModel {
        private ListModel<T> m_ListModel;
        private T m_SelectedElement;
        protected EventListenerList m_ListenerList;
        private final Object m_SyncEventListeners = new Object();

        public ListModelWrapper(ListModel<T> p_ListModel) {
            this.initMembers();
            this.m_ListModel = p_ListModel;
            this.m_ListModel.addListModelWrapper(this);
            if (this.m_ListModel.getSize() == 1) {
                this.setSelectedItem(this.m_ListModel.getElementAt(0));
            }
        }

        private void initMembers() {
            this.m_SelectedElement = null;
            this.m_ListenerList = new EventListenerList();
        }

        public void close() {
            if (this.m_ListModel != null) {
                this.m_ListModel.removeListModelWrapper(this);
            }
        }

        public ListModel<T> getListModel() {
            return this.m_ListModel;
        }

        public boolean containsElement(T p_Element) {
            return this.m_ListModel.containsElement(p_Element);
        }

        public void addElement(Object p_Element) {
            this.m_ListModel.addElement(p_Element);
        }

        @Override
        public void removeElement(Object p_Element) {
            this.m_ListModel.removeElement(p_Element);
        }

        public void clear() {
            this.removeElementsAll();
        }

        public void removeElementsAll() {
            this.m_ListModel.removeElementsAll();
        }

        @Override
        public int getSize() {
            return this.m_ListModel.getSize();
        }

        @Override
        public Object getElementAt(int index) {
            return this.m_ListModel.getElementAt(index);
        }

        public int getIndexOf(T anObject) {
            return this.m_ListModel.indexOf(anObject);
        }

        @Override
        public T getSelectedItem() {
            return this.m_SelectedElement;
        }

        @Override
        public void setSelectedItem(Object p_Element) {
            try {
                this.m_SelectedElement = p_Element;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListDataListener(ListDataListener l) {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                this.m_ListenerList.add(ListDataListener.class, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListDataListener(ListDataListener l) {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                this.m_ListenerList.remove(ListDataListener.class, l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ListDataListener[] getListDataListeners() {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                return (ListDataListener[])this.m_ListenerList.getListeners(ListDataListener.class);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireContentsChanged(Object source, int index0, int index1) {
            Object[] listenersCopy;
            ListDataEvent e = null;
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                Object[] listeners = this.m_ListenerList.getListenerList();
                listenersCopy = new Object[listeners.length];
                System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
            }
            for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
                if (listenersCopy[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 0, index0, index1);
                }
                ((ListDataListener)listenersCopy[i + 1]).contentsChanged(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            Object[] listenersCopy;
            ListDataEvent e = null;
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                Object[] listeners = this.m_ListenerList.getListenerList();
                listenersCopy = new Object[listeners.length];
                System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
            }
            if (this.m_ListModel.getSize() == 1) {
                this.setSelectedItem(this.m_ListModel.getElementAt(0));
            }
            for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
                if (listenersCopy[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 1, index0, index1);
                }
                ((ListDataListener)listenersCopy[i + 1]).intervalAdded(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            Object[] listenersCopy;
            ListDataEvent e = null;
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                Object[] listeners = this.m_ListenerList.getListenerList();
                listenersCopy = new Object[listeners.length];
                System.arraycopy(listeners, 0, listenersCopy, 0, listeners.length);
            }
            boolean boolSelectedFound = false;
            for (int intElement = 0; intElement <= this.m_ListModel.getSize(); ++intElement) {
                T o_Element = this.m_ListModel.getElementAt(intElement);
                if (o_Element != this.m_SelectedElement) continue;
                boolSelectedFound = true;
                break;
            }
            if (!boolSelectedFound) {
                if (this.m_ListModel.getSize() <= 0) {
                    this.setSelectedItem(null);
                } else {
                    this.setSelectedItem(this.m_ListModel.getElementAt(0));
                }
            }
            for (int i = listenersCopy.length - 2; i >= 0; i -= 2) {
                if (listenersCopy[i] != ListDataListener.class) continue;
                if (e == null) {
                    e = new ListDataEvent(source, 2, index0, index1);
                }
                ((ListDataListener)listenersCopy[i + 1]).intervalRemoved(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
            Object object = this.m_SyncEventListeners;
            synchronized (object) {
                return this.m_ListenerList.getListeners(listenerType);
            }
        }

        public void insertElementAt(Object anObject, int index) {
            this.m_ListModel.insertElementAt(anObject, index);
            this.fireIntervalAdded(this, index, index);
        }

        @Override
        public void removeElementAt(int index) {
            if (this.getElementAt(index) == this.m_SelectedElement) {
                if (index == 0) {
                    this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(index + 1));
                } else {
                    this.setSelectedItem(this.getElementAt(index - 1));
                }
            }
            this.m_ListModel.removeElementAt(index);
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public static class ListModel<T>
    implements ComboBoxModel,
    PropertyChangeListener {
        protected ArrayList<T> m_Elements;
        protected ArrayList<T> m_ElementsFilterNegative;
        protected ArrayList<T> m_ElementsFilterTemp;
        protected final Object m_SyncElements = new Object();
        protected T m_SelectedElement;
        protected ArrayList<ListModelWrapper<T>> m_ListModelWrappers;
        protected final Object m_SyncWrappers = new Object();
        protected ArrayList<ListDataListener> m_ListDataListeners;
        protected final Object m_SyncListeners = new Object();

        public ListModel() {
            this.initMembers();
        }

        public ListModel(T p_FirstElement) {
            this.initMembers();
            this.addElement(p_FirstElement);
        }

        private void initMembers() {
            this.m_Elements = new ArrayList();
            this.m_ElementsFilterNegative = new ArrayList();
            this.m_ElementsFilterTemp = new ArrayList();
            this.m_ListModelWrappers = new ArrayList();
            this.m_SelectedElement = null;
            this.m_ListDataListeners = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.m_SyncListeners;
            synchronized (object) {
                for (int intListener = this.m_ListDataListeners.size() - 1; intListener >= 0; --intListener) {
                    ListDataListener o_ListDataListener = this.m_ListDataListeners.get(intListener);
                    this.m_ListDataListeners.remove(intListener);
                }
            }
            Object object2 = this.m_SyncWrappers;
            synchronized (object2) {
                for (int intWrapper = this.m_ListModelWrappers.size() - 1; intWrapper >= 0; --intWrapper) {
                    ListModelWrapper<T> o_ListModelWrapper = this.m_ListModelWrappers.get(intWrapper);
                    this.removeListModelWrapper(o_ListModelWrapper);
                }
            }
            this.removeElementsAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListModelWrapper(ListModelWrapper<T> p_ListModelWrapper) {
            if (p_ListModelWrapper == null) {
                return;
            }
            Object object = this.m_SyncWrappers;
            synchronized (object) {
                if (this.m_ListModelWrappers.contains(p_ListModelWrapper)) {
                    return;
                }
                this.m_ListModelWrappers.add(p_ListModelWrapper);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListModelWrapper(ListModelWrapper p_ListModelWrapper) {
            if (p_ListModelWrapper == null) {
                return;
            }
            Object object = this.m_SyncWrappers;
            synchronized (object) {
                this.m_ListModelWrappers.remove(p_ListModelWrapper);
            }
        }

        public int size() {
            return this.getSize();
        }

        @Override
        public int getSize() {
            return this.m_Elements.size();
        }

        public boolean contains(T p_Element) {
            return this.containsElement(p_Element);
        }

        public boolean containsElement(T p_Element) {
            return this.m_Elements.contains(p_Element);
        }

        public String getListSortPreFix(T p_Element) {
            if (p_Element == null) {
                return null;
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodSortPreFix = o_Class.getMethod("getListSortPreFix", new Class[0]);
                if (o_MethodSortPreFix == null) {
                    return null;
                }
                return (String)o_MethodSortPreFix.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addSortedByName(T p_Element, boolean p_ExludeFirst, boolean p_UseClassName, boolean p_UseListSortPreFix) {
            int intElement;
            if (this.contains(p_Element)) {
                return true;
            }
            int intStartIndex = p_ExludeFirst ? 1 : 0;
            if (this.m_Elements.size() < intStartIndex + 1) {
                return this.addElement(p_Element);
            }
            String stringTemp = null;
            if (p_UseListSortPreFix) {
                stringTemp = this.getListSortPreFix(p_Element);
            }
            String stringNameNew = stringTemp != null ? stringTemp : "";
            if (p_UseClassName && p_Element != null) {
                stringNameNew = stringNameNew + p_Element.getClass().getSimpleName();
            }
            if ((stringTemp = this.getName(p_Element)) != null) {
                stringNameNew = stringNameNew + stringTemp;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                for (intElement = intStartIndex; intElement < this.m_Elements.size(); ++intElement) {
                    T o_Element = this.m_Elements.get(intElement);
                    stringTemp = null;
                    if (p_UseListSortPreFix) {
                        stringTemp = this.getListSortPreFix(o_Element);
                    }
                    String stringName = stringTemp != null ? stringTemp : "";
                    if (p_UseClassName && o_Element != null) {
                        stringName = stringName + o_Element.getClass().getSimpleName();
                    }
                    if ((stringTemp = this.getName(o_Element)) != null) {
                        stringName = stringName + stringTemp;
                    }
                    if (stringName.compareToIgnoreCase(stringNameNew) > 0) break;
                }
            }
            return this.add(intElement, p_Element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resortByName(T p_Element, boolean p_ExludeFirst, boolean p_UseClassName, boolean p_UseListSortPreFix) {
            int intElement;
            int intOldIndex;
            if (p_Element == null) {
                return;
            }
            String stringTemp = null;
            if (p_UseListSortPreFix) {
                stringTemp = this.getListSortPreFix(p_Element);
            }
            String stringNameNew = stringTemp != null ? stringTemp : "";
            if (p_UseClassName && p_Element != null) {
                stringNameNew = stringNameNew + p_Element.getClass().getSimpleName();
            }
            if ((stringTemp = this.getName(p_Element)) != null) {
                stringNameNew = stringNameNew + stringTemp;
            }
            if ((intOldIndex = this.m_Elements.indexOf(p_Element)) < 0) {
                return;
            }
            int intStartIndex = p_ExludeFirst ? 1 : 0;
            Object object = this.m_SyncElements;
            synchronized (object) {
                if (this.m_Elements.size() < intStartIndex + 1) {
                    return;
                }
                for (intElement = intStartIndex; intElement < this.m_Elements.size(); ++intElement) {
                    if (intElement == intOldIndex) continue;
                    T o_Element = this.m_Elements.get(intElement);
                    stringTemp = null;
                    if (p_UseListSortPreFix) {
                        stringTemp = this.getListSortPreFix(o_Element);
                    }
                    String stringName = stringTemp != null ? stringTemp : "";
                    if (p_UseClassName && o_Element != null) {
                        stringName = stringName + o_Element.getClass().getSimpleName();
                    }
                    if ((stringTemp = this.getName(o_Element)) != null) {
                        stringName = stringName + stringTemp;
                    }
                    if (stringName.compareToIgnoreCase(stringNameNew) > 0) break;
                }
            }
            if (intElement == intOldIndex + 1) {
                return;
            }
            if (intElement < intOldIndex) {
                this.removeElement(p_Element);
                this.add(intElement, p_Element);
            }
            if (intElement > intOldIndex) {
                this.removeElement(p_Element);
                this.add(intElement - 1, p_Element);
            }
        }

        private String getName(T p_Element) {
            if (p_Element == null) {
                return null;
            }
            Class<?> o_Class = p_Element.getClass();
            try {
                Method o_MethodGetName = o_Class.getMethod("getName", new Class[0]);
                if (o_MethodGetName == null) {
                    return null;
                }
                return (String)o_MethodGetName.invoke(p_Element, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T findByName(String p_SearchString) {
            if (p_SearchString == null) {
                return null;
            }
            if (p_SearchString.length() <= 0) {
                return null;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                for (int intElement = 0; intElement < this.m_Elements.size(); ++intElement) {
                    T o_Element = this.m_Elements.get(intElement);
                    String stringName = this.getName(o_Element);
                    if (stringName == null || stringName.length() < p_SearchString.length() || !stringName.toLowerCase().contains(p_SearchString.toLowerCase())) continue;
                    return o_Element;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void filterByName(String p_FilterString, boolean p_ExludeFirst, boolean p_UseClassName, boolean p_UseListSortPreFix) {
            if (p_FilterString == null || p_FilterString.length() <= 0) {
                for (int intElement = this.m_ElementsFilterNegative.size() - 1; intElement >= 0; --intElement) {
                    T o_Element = this.m_ElementsFilterNegative.get(intElement);
                    this.addSortedByName(o_Element, p_ExludeFirst, p_UseClassName, p_UseListSortPreFix);
                    this.m_ElementsFilterNegative.remove(intElement);
                }
                return;
            }
            String stringFilter = p_FilterString.toLowerCase();
            int intStartIndex = !p_ExludeFirst ? 0 : 1;
            Object object = this.m_SyncElements;
            synchronized (object) {
                String stringName;
                T o_Element;
                int intElement;
                for (intElement = this.m_Elements.size() - 1; intElement >= intStartIndex; --intElement) {
                    o_Element = this.m_Elements.get(intElement);
                    stringName = this.getName(o_Element).toLowerCase();
                    if (stringName.contains(stringFilter)) continue;
                    this.remove(o_Element);
                    this.m_ElementsFilterTemp.add(o_Element);
                }
                for (intElement = this.m_ElementsFilterNegative.size() - 1; intElement >= 0; --intElement) {
                    o_Element = this.m_ElementsFilterNegative.get(intElement);
                    stringName = this.getName(o_Element).toLowerCase();
                    if (!stringName.contains(stringFilter)) continue;
                    this.addSortedByName(o_Element, p_ExludeFirst, p_UseClassName, p_UseListSortPreFix);
                    this.m_ElementsFilterNegative.remove(intElement);
                }
                this.m_ElementsFilterNegative.addAll(this.m_ElementsFilterTemp);
            }
        }

        public boolean add(T p_Element) {
            return this.addElement(p_Element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addElement(Object p_Element) {
            Object o_Element;
            if (p_Element == null) {
                // empty if block
            }
            boolean boolAdded = false;
            try {
                o_Element = p_Element != null ? p_Element : null;
            }
            catch (Exception e) {
                return false;
            }
            if (this.containsElement(o_Element)) {
                return true;
            }
            if (o_Element != null) {
                this.call_AddPropertyChangeListener(o_Element);
            }
            Object e = this.m_SyncElements;
            synchronized (e) {
                boolAdded = this.m_Elements.add(o_Element);
            }
            if (boolAdded) {
                int intIndex = this.m_Elements.indexOf(p_Element);
                try {
                    this.fireIntervalAdded(this, intIndex, intIndex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        public boolean add(int p_Index, T p_Element) {
            return this.insertElementAt(p_Element, p_Index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean insertElementAt(T anObject, int index) {
            if (this.contains(anObject)) {
                return true;
            }
            boolean boolAdded = false;
            Object object = this.m_SyncElements;
            synchronized (object) {
                try {
                    this.m_Elements.add(index, anObject);
                    boolAdded = true;
                }
                catch (Exception e) {
                    boolAdded = false;
                }
            }
            if (boolAdded) {
                this.fireIntervalAdded(this, index, index);
            }
            return boolAdded;
        }

        public boolean remove(T p_Element) {
            return this.removeElement(p_Element);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeElement(Object p_Element) {
            boolean boolRemoved;
            int intIndex;
            Object o_Element;
            if (p_Element == null) {
                // empty if block
            }
            try {
                o_Element = p_Element != null ? p_Element : null;
            }
            catch (Exception e) {
                return false;
            }
            Object object = this.m_SyncElements;
            synchronized (object) {
                intIndex = this.m_Elements.indexOf(o_Element);
                if (intIndex < 0) {
                    return false;
                }
                if (o_Element != null) {
                    this.call_RemovePropertyChangeListener(o_Element);
                }
                boolRemoved = this.m_Elements.remove(o_Element);
            }
            if (boolRemoved) {
                this.fireIntervalRemoved(this, intIndex, intIndex);
            }
            return boolRemoved;
        }

        public void remove(int p_Index) {
            this.removeElementAt(p_Index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeElementAt(int index) {
            Object o_Object = null;
            Object object = this.m_SyncElements;
            synchronized (object) {
                if (index < 0 || index >= this.m_Elements.size()) {
                    return;
                }
                try {
                    o_Object = this.m_Elements.remove(index);
                }
                catch (Exception e) {
                    o_Object = null;
                }
            }
            if (o_Object != null) {
                this.fireIntervalRemoved(this, index, index);
            }
        }

        public void removeElementsAll() {
            int intSize = this.getSize();
            for (int intElement = intSize - 1; intElement >= 0; --intElement) {
                this.removeElementAt(intElement);
            }
        }

        public void clear() {
            this.removeElementsAll();
        }

        @Override
        public T getElementAt(int p_Index) {
            return this.get(p_Index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get(int p_Index) {
            Object object = this.m_SyncElements;
            synchronized (object) {
                if (p_Index < 0 || p_Index >= this.m_Elements.size()) {
                    return null;
                }
                return this.m_Elements.get(p_Index);
            }
        }

        public ArrayList<T> getArrayList() {
            return this.m_Elements;
        }

        public int indexOf(T p_Element) {
            return this.m_Elements.indexOf(p_Element);
        }

        protected void call_AddPropertyChangeListener(Object p_Element) {
            if (p_Element == null) {
                return;
            }
            Method o_Method = null;
            try {
                o_Method = p_Element.getClass().getDeclaredMethod("addPropertyChangeListener", PropertyChangeListener.class);
                if (o_Method != null) {
                    o_Method.invoke(p_Element, this);
                }
            }
            catch (Exception e) {
                o_Method = null;
            }
        }

        protected void call_RemovePropertyChangeListener(Object p_Element) {
            if (p_Element == null) {
                return;
            }
            Method o_Method = null;
            try {
                o_Method = p_Element.getClass().getDeclaredMethod("removePropertyChangeListener", PropertyChangeListener.class);
                if (o_Method != null) {
                    o_Method.invoke(p_Element, this);
                }
            }
            catch (Exception e) {
                o_Method = null;
            }
        }

        public T[] toArray() {
            Object[] o_Array = new Object[this.getSize()];
            for (int intElement = 0; intElement < this.getSize(); ++intElement) {
                T o_Element = this.getElementAt(intElement);
                o_Array[intElement] = o_Element;
            }
            return o_Array;
        }

        public ArrayList<T> toArrayList() {
            return (ArrayList)this.m_Elements.clone();
        }

        public T getSelectedItem() {
            return this.m_SelectedElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireContentsChanged(Object source, int index0, int index1) {
            ArrayList<ListModelWrapper<T>> o_ListModelWrappers;
            ArrayList<ListDataListener> o_ListDataListeners;
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 0, index0, index1);
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_ListDataListeners = new ArrayList<ListDataListener>(this.m_ListDataListeners.size());
                o_ListDataListeners.addAll(this.m_ListDataListeners);
            }
            for (int intListener = 0; intListener < o_ListDataListeners.size(); ++intListener) {
                ListDataListener o_Listener = (ListDataListener)o_ListDataListeners.get(intListener);
                o_Listener.contentsChanged(o_ListDataEvent);
            }
            Object object2 = this.m_SyncWrappers;
            synchronized (object2) {
                o_ListModelWrappers = new ArrayList<ListModelWrapper<T>>(this.m_ListModelWrappers.size());
                o_ListModelWrappers.addAll(this.m_ListModelWrappers);
            }
            for (int intSingleModel = 0; intSingleModel < o_ListModelWrappers.size(); ++intSingleModel) {
                ((ListModelWrapper)o_ListModelWrappers.get(intSingleModel)).fireContentsChanged(source, index0, index1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            ArrayList<ListModelWrapper<T>> o_ListModelWrappers;
            ArrayList<ListDataListener> o_ListDataListeners;
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 1, index0, index1);
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_ListDataListeners = new ArrayList<ListDataListener>(this.m_ListDataListeners.size());
                o_ListDataListeners.addAll(this.m_ListDataListeners);
            }
            for (int intListener = 0; intListener < o_ListDataListeners.size(); ++intListener) {
                ListDataListener o_Listener = (ListDataListener)o_ListDataListeners.get(intListener);
                o_Listener.intervalAdded(o_ListDataEvent);
            }
            Object object2 = this.m_SyncWrappers;
            synchronized (object2) {
                o_ListModelWrappers = new ArrayList<ListModelWrapper<T>>(this.m_ListModelWrappers.size());
                o_ListModelWrappers.addAll(this.m_ListModelWrappers);
            }
            for (int intSingleModel = 0; intSingleModel < o_ListModelWrappers.size(); ++intSingleModel) {
                ((ListModelWrapper)o_ListModelWrappers.get(intSingleModel)).fireIntervalAdded(source, index0, index1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            ArrayList<ListModelWrapper<T>> o_ListModelWrappers;
            ArrayList<ListDataListener> o_ListDataListeners;
            ListDataEvent o_ListDataEvent = new ListDataEvent(this, 2, index0, index1);
            Object object = this.m_SyncListeners;
            synchronized (object) {
                o_ListDataListeners = new ArrayList<ListDataListener>(this.m_ListDataListeners.size());
                o_ListDataListeners.addAll(this.m_ListDataListeners);
            }
            for (int intListener = 0; intListener < o_ListDataListeners.size(); ++intListener) {
                ListDataListener o_Listener = (ListDataListener)o_ListDataListeners.get(intListener);
                o_Listener.intervalRemoved(o_ListDataEvent);
            }
            Object object2 = this.m_SyncWrappers;
            synchronized (object2) {
                o_ListModelWrappers = new ArrayList<ListModelWrapper<T>>(this.m_ListModelWrappers.size());
                o_ListModelWrappers.addAll(this.m_ListModelWrappers);
            }
            for (int intSingleModel = 0; intSingleModel < o_ListModelWrappers.size(); ++intSingleModel) {
                ((ListModelWrapper)o_ListModelWrappers.get(intSingleModel)).fireIntervalRemoved(source, index0, index1);
            }
        }

        public void changed(T p_Element) {
            int intIndex = this.indexOf(p_Element);
            if (intIndex < 0) {
                return;
            }
            this.fireContentsChanged(this, intIndex, intIndex);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.changed(evt.getSource());
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.m_SelectedElement = anItem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addListDataListener(ListDataListener l) {
            if (l == null) {
                return;
            }
            Object object = this.m_SyncListeners;
            synchronized (object) {
                if (this.m_ListDataListeners.contains(l)) {
                    return;
                }
                this.m_ListDataListeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeListDataListener(ListDataListener l) {
            Object object = this.m_SyncListeners;
            synchronized (object) {
                this.m_ListDataListeners.remove(l);
            }
        }
    }
}

