/*
 * Decompiled with CFR 0.152.
 */
package SPITLibraryPackage;

import SPITLibraryPackage.SPIT_ClientInterface;
import SPITLibraryPackage.SPIT_Message;

public class SPIT_Watchdog {
    public static int WATCHDOG_TIME = 3000;
    private SPIT_ClientInterface m_SPITClient;
    private boolean m_StopWatchdog;
    private boolean m_WatchdogConfirmed;
    private Thread m_ThreadWatchdog;
    private Runnable m_RunnableWatchdog;
    private final Object m_SyncWatchdog = new Object();

    public SPIT_Watchdog(SPIT_ClientInterface p_SPIT_ClientInterface) {
        this.initMembers();
        this.m_SPITClient = p_SPIT_ClientInterface;
        this.initRunnable();
    }

    private void initMembers() {
    }

    public void close() {
        this.stopWatchdog();
    }

    private void initRunnable() {
        this.m_RunnableWatchdog = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SPIT_Message o_SPIT_Message = SPIT_Message.createWatchdog();
                while (!SPIT_Watchdog.this.m_StopWatchdog) {
                    SPIT_ClientInterface o_SPIT_Client;
                    Object object = SPIT_Watchdog.this.m_SyncWatchdog;
                    synchronized (object) {
                        o_SPIT_Client = SPIT_Watchdog.this.m_SPITClient;
                        if (o_SPIT_Client == null) {
                            break;
                        }
                    }
                    SPIT_Watchdog.this.m_WatchdogConfirmed = false;
                    o_SPIT_Client.sendSPIT_Message(o_SPIT_Message);
                    object = SPIT_Watchdog.this.m_SyncWatchdog;
                    synchronized (object) {
                        try {
                            SPIT_Watchdog.this.m_SyncWatchdog.wait(WATCHDOG_TIME);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (SPIT_Watchdog.this.m_StopWatchdog) break;
                    if (SPIT_Watchdog.this.m_WatchdogConfirmed) continue;
                    o_SPIT_Client.watchdogMissed();
                    break;
                }
            }
        };
    }

    public void startWatchdog() {
        Thread o_Thread = this.m_ThreadWatchdog;
        if (o_Thread != null) {
            this.stopWatchdog();
            try {
                o_Thread.join(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_StopWatchdog = false;
        this.m_ThreadWatchdog = new Thread(this.m_RunnableWatchdog);
        this.m_ThreadWatchdog.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWatchdog() {
        this.m_StopWatchdog = true;
        Object object = this.m_SyncWatchdog;
        synchronized (object) {
            this.m_SyncWatchdog.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventWatchdogAnswer() {
        Object object = this.m_SyncWatchdog;
        synchronized (object) {
            this.m_WatchdogConfirmed = true;
        }
    }
}

