/*
 * Decompiled with CFR 0.152.
 */
package SPITLibraryPackage;

import SPITActionPackage.SPIT_ActionStatus;
import SPITLibraryPackage.SPIT_MessagePlayPool;
import SPITLibraryPackage.SPIT_Object_Interface;
import SPITLibraryPackage.SPIT_Type_Interface;
import java.nio.charset.Charset;

public class SPIT_Message {
    public static final String SPITID = "#spit#";
    public static final int SPITVERSION = 1;
    public static final Charset CHARSET = Charset.forName("ISO-8859-15");
    public static String s_ParseError = "ParseError";
    private byte[] m_MessageBytes;
    private Header m_Header;
    private OPPart m_OPPart;
    public static final byte VALUEUSE_DISCARD = 0;
    public static final byte VALUEUSE_INRANGE = 1;
    public static final byte VALUEUSE_OVERRIDE = 2;
    public static final byte PLAYERTYPE_MAIN = 2;
    public static final byte PLAYERTYPE_CONTINIOUS = 1;
    public static final byte PLAYERTYPE_DISCRETE = 0;
    public static final byte VALUEFLAG_DIRECT = 0;
    public static final byte VALUEFLAG_INCREASE = 1;
    public static final byte VALUEFLAG_DECREASE = 2;

    private void initMembers() {
        this.m_MessageBytes = null;
        this.m_Header = null;
        this.m_OPPart = null;
    }

    public SPIT_Message(byte[] p_MessageBytes) {
        this.initMembers();
        this.m_MessageBytes = p_MessageBytes;
        if (this.m_MessageBytes == null) {
            return;
        }
        if (this.parse() == null) {
            // empty if block
        }
    }

    public OPPart parse() {
        if (this.m_MessageBytes == null) {
            return null;
        }
        this.m_OPPart = null;
        this.m_Header = new Header();
        if (!this.m_Header.parse(this.m_MessageBytes)) {
            this.m_Header = null;
            this.m_OPPart = null;
            return this.m_OPPart;
        }
        switch (this.m_Header.getOPFlag()) {
            case 1: {
                this.m_OPPart = new Connect(this.m_Header);
                break;
            }
            case 2: {
                this.m_OPPart = new ConnectAnswer(this.m_Header);
                break;
            }
            case 3: {
                this.m_OPPart = new Disconnect(this.m_Header);
                break;
            }
            case 8: {
                this.m_OPPart = new Watchdog(this.m_Header);
                break;
            }
            case 9: {
                this.m_OPPart = new WatchdogAnswer(this.m_Header);
                break;
            }
            case 11: {
                this.m_OPPart = new ReportSPITProject(this.m_Header);
                break;
            }
            case 13: {
                this.m_OPPart = new CloseSPITProject(this.m_Header);
                break;
            }
            case 15: {
                this.m_OPPart = new RequestProjectTransfer(this.m_Header);
                break;
            }
            case 16: {
                this.m_OPPart = new StartProjectTransfer(this.m_Header);
                break;
            }
            case 17: {
                this.m_OPPart = new EndProjectTransfer(this.m_Header);
                break;
            }
            case 21: {
                this.m_OPPart = new ReportSPITType(this.m_Header);
                break;
            }
            case 23: {
                this.m_OPPart = new RemoveSPITType(this.m_Header);
                break;
            }
            case 31: {
                this.m_OPPart = new ReportSPITObject(this.m_Header);
                break;
            }
            case 33: {
                this.m_OPPart = new RemoveSPITObject(this.m_Header);
                break;
            }
            case 37: {
                this.m_OPPart = new PlaySPITStart(this.m_Header);
                break;
            }
            case 38: {
                this.m_OPPart = new PlaySPITObject(this.m_Header);
                break;
            }
            case 39: {
                this.m_OPPart = new PlaySPITEnd(this.m_Header);
                break;
            }
            case 40: {
                this.m_OPPart = new ReportPlayStatus(this.m_Header);
                break;
            }
        }
        if (this.m_OPPart != null && !this.m_OPPart.parse(this.m_MessageBytes)) {
            this.m_Header = null;
            this.m_OPPart = null;
        }
        return this.m_OPPart;
    }

    public Header getHeader() {
        return this.m_Header;
    }

    public OPPart getOPPart() {
        return this.m_OPPart;
    }

    public int getOPFlag() {
        if (this.m_Header == null) {
            return -1;
        }
        return this.m_Header.getOPFlag();
    }

    public SPIT_Message(OPPart p_OPPart) {
        this.initMembers();
        this.m_OPPart = p_OPPart;
        if (this.m_OPPart == null) {
            return;
        }
        this.m_Header = this.m_OPPart.getHeader();
        if (this.m_Header == null) {
            this.m_OPPart = null;
            return;
        }
    }

    private boolean fillBytes() {
        if (this.m_OPPart == null) {
            return false;
        }
        if (this.m_MessageBytes == null) {
            this.m_MessageBytes = SPIT_Message.createByteArray(this.m_OPPart);
        }
        return this.m_OPPart.fillBytes(this.m_MessageBytes);
    }

    public byte[] getMessageBytes() {
        if (this.m_OPPart == null) {
            return null;
        }
        if (!this.fillBytes()) {
            return null;
        }
        return this.m_MessageBytes;
    }

    public static byte[] createByteArray(OPPart p_OPPart) {
        byte[] o_ByteArray;
        if (p_OPPart == null) {
            return null;
        }
        int intBytesCount = 0;
        try {
            intBytesCount = p_OPPart.getHeader().getBytesCount();
            o_ByteArray = new byte[intBytesCount += p_OPPart.getBytesCount()];
        }
        catch (Exception e) {
            return null;
        }
        return o_ByteArray;
    }

    public static int setString(String p_String, byte[] p_Bytes, int p_Offset, int p_Length) throws Exception {
        if (p_String == null) {
            throw new Exception(s_ParseError);
        }
        if (p_Offset < 0) {
            throw new Exception(s_ParseError);
        }
        int intMaxStringLength = p_Length - 1;
        if (intMaxStringLength < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (p_Bytes == null || p_Bytes.length < p_Offset + p_Length) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        StringBuilder o_StringBuilder = new StringBuilder(p_Length);
        if (p_String.length() > intMaxStringLength) {
            o_StringBuilder.append(p_String, 0, intMaxStringLength);
        } else {
            o_StringBuilder.append(p_String);
        }
        System.arraycopy(o_StringBuilder.toString().getBytes(CHARSET), 0, p_Bytes, p_Offset, o_StringBuilder.length());
        if (o_StringBuilder.length() < p_Length) {
            p_Bytes[p_Offset + p_String.length()] = 0;
        }
        return p_Length;
    }

    public static String getString(byte[] p_Bytes, int p_Offset, int p_Length) throws Exception {
        int intPos;
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (p_Bytes == null || p_Bytes.length < p_Offset + p_Length) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        for (intPos = 0; intPos < p_Length && p_Bytes[p_Offset + intPos] != 0; ++intPos) {
        }
        if (intPos >= p_Length) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        return new String(p_Bytes, p_Offset, intPos, CHARSET);
    }

    public static int getInt(byte[] p_Bytes, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (p_Bytes == null || p_Bytes.length < p_Offset + 4) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        int intValue = 0;
        intValue += p_Bytes[p_Offset] & 0xFF;
        intValue += (p_Bytes[p_Offset + 1] & 0xFF) << 8;
        intValue += (p_Bytes[p_Offset + 2] & 0xFF) << 16;
        return intValue += (p_Bytes[p_Offset + 3] & 0xFF) << 24;
    }

    public static long getLong(byte[] p_Bytes, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (p_Bytes == null || p_Bytes.length < p_Offset + 8) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        long intValue = 0L;
        intValue += (long)(p_Bytes[p_Offset] & 0xFF);
        intValue += (long)(p_Bytes[p_Offset + 1] & 0xFF) << 8;
        intValue += (long)(p_Bytes[p_Offset + 2] & 0xFF) << 16;
        intValue += (long)(p_Bytes[p_Offset + 3] & 0xFF) << 24;
        intValue += (long)(p_Bytes[p_Offset + 4] & 0xFF) << 32;
        intValue += (long)(p_Bytes[p_Offset + 5] & 0xFF) << 40;
        intValue += (long)(p_Bytes[p_Offset + 6] & 0xFF) << 48;
        return intValue += (long)(p_Bytes[p_Offset + 7] & 0xFF) << 56;
    }

    public static int setInt(int p_Value, byte[] p_Bytes, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (p_Bytes == null || p_Bytes.length < p_Offset + 4) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        p_Bytes[p_Offset + 0] = (byte)(p_Value & 0xFF);
        p_Bytes[p_Offset + 1] = (byte)((p_Value & 0xFF00) >> 8);
        p_Bytes[p_Offset + 2] = (byte)((p_Value & 0xFF0000) >> 16);
        p_Bytes[p_Offset + 3] = (byte)((p_Value & 0xFF000000) >> 24);
        return 4;
    }

    public static int setLong(long p_Value, byte[] p_Bytes, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (p_Bytes == null || p_Bytes.length < p_Offset + 8) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        p_Bytes[p_Offset + 0] = (byte)(p_Value & 0xFFL);
        p_Bytes[p_Offset + 1] = (byte)((p_Value & 0xFF00L) >> 8);
        p_Bytes[p_Offset + 2] = (byte)((p_Value & 0xFF0000L) >> 16);
        p_Bytes[p_Offset + 3] = (byte)((p_Value & 0xFF000000L) >> 24);
        p_Bytes[p_Offset + 4] = (byte)((p_Value & 0xFF00000000L) >> 32);
        p_Bytes[p_Offset + 5] = (byte)((p_Value & 0xFF0000000000L) >> 40);
        p_Bytes[p_Offset + 6] = (byte)((p_Value & 0xFF000000000000L) >> 48);
        p_Bytes[p_Offset + 7] = (byte)((p_Value & 0xFF00000000000000L) >> 56);
        return 8;
    }

    public static boolean getBoolean(byte[] p_Bytes, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (p_Bytes == null || p_Bytes.length < p_Offset + 1) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        return p_Bytes[p_Offset] > 0;
    }

    public static int setBoolean(boolean p_Value, byte[] p_Bytes, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (p_Bytes == null || p_Bytes.length < p_Offset + 1) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        p_Bytes[p_Offset] = !p_Value ? (byte)0 : 1;
        return 1;
    }

    public static byte getByte(byte[] p_Bytes, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (p_Bytes == null || p_Bytes.length < p_Offset + 1) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        return p_Bytes[p_Offset];
    }

    public static int setByte(int p_Value, byte[] p_Bytes, int p_Offset) throws Exception {
        if (p_Offset < 0) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        if (p_Bytes == null || p_Bytes.length < p_Offset + 1) {
            throw new Exception(s_ParseError + " at byte " + p_Offset);
        }
        p_Bytes[p_Offset] = (byte)(p_Value & 0xFF);
        return 1;
    }

    public static SPIT_Message createConnect(String p_ClientComputerName, String p_ClientName, String p_LoginName, String p_LoginPassword, String p_ServerIP, int p_Serverport) {
        Connect o_Connect = new Connect();
        o_Connect.setClientComputerName(p_ClientComputerName);
        o_Connect.setClientName(p_ClientName);
        o_Connect.setLoginName(p_LoginName);
        o_Connect.setLoginPassword(p_LoginPassword);
        o_Connect.setServerIP(p_ServerIP);
        o_Connect.setServerPort(p_Serverport);
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_Connect);
        return o_SPIT_Message;
    }

    public static SPIT_Message createConnectAnswer(boolean p_ConnectOK, String p_ServerComputerName, String p_ServerName, int p_ServerStepTime) {
        ConnectAnswer o_ConnectAnswer = new ConnectAnswer();
        o_ConnectAnswer.setConnected(p_ConnectOK);
        o_ConnectAnswer.setServerComputerName(p_ServerComputerName);
        o_ConnectAnswer.setServerName(p_ServerName);
        o_ConnectAnswer.setStepTime(p_ServerStepTime);
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_ConnectAnswer);
        return o_SPIT_Message;
    }

    public static SPIT_Message createDisconnect() {
        Disconnect o_Disconnect = new Disconnect();
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_Disconnect);
        return o_SPIT_Message;
    }

    public static SPIT_Message createReportSPITProject(String p_ProjectID, String p_ProjectName, int p_ServerTimeResolution) {
        ReportSPITProject o_ReportSPITProject = new ReportSPITProject();
        o_ReportSPITProject.setProjectID(p_ProjectID);
        o_ReportSPITProject.setProjectName(p_ProjectName);
        o_ReportSPITProject.setFramesPerSecond(p_ServerTimeResolution);
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_ReportSPITProject);
        return o_SPIT_Message;
    }

    public static SPIT_Message createCloseSPITProject(String p_ProjectID) {
        CloseSPITProject o_CloseSPITProject = new CloseSPITProject();
        o_CloseSPITProject.setProjectID(p_ProjectID);
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_CloseSPITProject);
        return o_SPIT_Message;
    }

    public static SPIT_Message createRequestProjectTransfer() {
        RequestProjectTransfer o_RequestProjectTransfer = new RequestProjectTransfer();
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_RequestProjectTransfer);
        return o_SPIT_Message;
    }

    public static SPIT_Message createStartProjectTransfer() {
        StartProjectTransfer o_StartProjectTransfer = new StartProjectTransfer();
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_StartProjectTransfer);
        return o_SPIT_Message;
    }

    public static SPIT_Message createEndProjectTransfer() {
        EndProjectTransfer o_EndProjectTransfer = new EndProjectTransfer();
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_EndProjectTransfer);
        return o_SPIT_Message;
    }

    public static SPIT_Message createReportSPITType(SPIT_Type_Interface p_SPIT_Type_Interface) {
        if (p_SPIT_Type_Interface == null) {
            return null;
        }
        ReportSPITType o_ReportSPITType = new ReportSPITType();
        o_ReportSPITType.setConfirmed(p_SPIT_Type_Interface.getConfirmed());
        o_ReportSPITType.setID(p_SPIT_Type_Interface.getID());
        o_ReportSPITType.setFixed(p_SPIT_Type_Interface.getFixed());
        o_ReportSPITType.setServerRemote(p_SPIT_Type_Interface.getServerRemote());
        o_ReportSPITType.setServerProjectIndepended(p_SPIT_Type_Interface.getServerProjectIndepended());
        o_ReportSPITType.setGroupName(p_SPIT_Type_Interface.getGroupName());
        o_ReportSPITType.setName(p_SPIT_Type_Interface.getName());
        o_ReportSPITType.setDelay(p_SPIT_Type_Interface.getDelay());
        o_ReportSPITType.setDuration(p_SPIT_Type_Interface.getDuration());
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_ReportSPITType);
        return o_SPIT_Message;
    }

    public static SPIT_Message createRemoveSPITType(String p_SPIT_Type_ID) {
        if (p_SPIT_Type_ID == null) {
            return null;
        }
        RemoveSPITType o_RemoveSPITType = new RemoveSPITType();
        o_RemoveSPITType.setID(p_SPIT_Type_ID);
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_RemoveSPITType);
        return o_SPIT_Message;
    }

    public static SPIT_Message createReportSPITObject(SPIT_Object_Interface p_SPIT_Object_Interface) {
        ReportSPITObject o_ReportSPITObject = new ReportSPITObject();
        o_ReportSPITObject.setConfirmed(p_SPIT_Object_Interface.getConfirmed());
        o_ReportSPITObject.setID(p_SPIT_Object_Interface.getID());
        o_ReportSPITObject.setFixed(p_SPIT_Object_Interface.getFixed());
        o_ReportSPITObject.setServerRemote(p_SPIT_Object_Interface.getServerRemote());
        o_ReportSPITObject.setName(p_SPIT_Object_Interface.getName());
        o_ReportSPITObject.setRemark(p_SPIT_Object_Interface.getRemark());
        o_ReportSPITObject.setSPITTypeID(p_SPIT_Object_Interface.getSPITTypeID());
        o_ReportSPITObject.setServerParams(p_SPIT_Object_Interface.getServerParams());
        o_ReportSPITObject.setFrameStart(p_SPIT_Object_Interface.getFrameStart());
        o_ReportSPITObject.setFrameLength(p_SPIT_Object_Interface.getFrameLength());
        o_ReportSPITObject.setFrameFadeInLength(p_SPIT_Object_Interface.getFrameFadeInLength());
        o_ReportSPITObject.setFrameFadeOutLength(p_SPIT_Object_Interface.getFrameFadeOutLength());
        o_ReportSPITObject.setValueFactor(p_SPIT_Object_Interface.getValueFactor());
        o_ReportSPITObject.setValueUse(p_SPIT_Object_Interface.getValueUse());
        o_ReportSPITObject.setTrack(p_SPIT_Object_Interface.getTrack());
        o_ReportSPITObject.setDelay(p_SPIT_Object_Interface.getDelay());
        o_ReportSPITObject.setDuration(p_SPIT_Object_Interface.getDuration());
        o_ReportSPITObject.setActionAssigned(p_SPIT_Object_Interface.getActionAssigned());
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_ReportSPITObject);
        return o_SPIT_Message;
    }

    public static SPIT_Message createRemoveSPITObject(String p_SPIT_ObjectID) {
        RemoveSPITObject o_RemoveSPITObject = new RemoveSPITObject();
        o_RemoveSPITObject.setID(p_SPIT_ObjectID);
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_RemoveSPITObject);
        return o_SPIT_Message;
    }

    public static SPIT_Message createPlaySPITStart(String p_PlayerID, String p_PLayerName, byte p_PlayerType, boolean p_PlayerIsRunning, long p_TimeFrames) {
        SPIT_Message o_SPIT_Message = SPIT_MessagePlayPool.getPlaySPITStart();
        PlaySPITStart o_PlaySPITStart = (PlaySPITStart)o_SPIT_Message.getOPPart();
        o_PlaySPITStart.setPlayerID(p_PlayerID);
        o_PlaySPITStart.setPlayerName(p_PLayerName);
        o_PlaySPITStart.setPlayerType(p_PlayerType);
        o_PlaySPITStart.setPlayerIsRunning(p_PlayerIsRunning);
        o_PlaySPITStart.setTime(p_TimeFrames);
        return o_SPIT_Message;
    }

    public static SPIT_Message createPlaySPITEnd(String p_PlayerID) {
        SPIT_Message o_SPIT_Message = SPIT_MessagePlayPool.getPlaySPITEnd();
        PlaySPITEnd o_PlaySPITEnd = (PlaySPITEnd)o_SPIT_Message.getOPPart();
        o_PlaySPITEnd.setPlayerID(p_PlayerID);
        return o_SPIT_Message;
    }

    public static SPIT_Message createPlaySPITObject(String p_PlayerID, String p_SPIT_ObjectID, long p_FrameInside, boolean p_IsPreObject, int p_Value, byte p_ValueFlag) {
        SPIT_Message o_SPIT_Message = SPIT_MessagePlayPool.getPlaySPITObject();
        PlaySPITObject o_PlaySPITObject = (PlaySPITObject)o_SPIT_Message.getOPPart();
        o_PlaySPITObject.setPlayerID(p_PlayerID);
        o_PlaySPITObject.setID(p_SPIT_ObjectID);
        o_PlaySPITObject.setFrameInsideObject(p_FrameInside);
        o_PlaySPITObject.setPlayPrePosition(p_IsPreObject);
        o_PlaySPITObject.setValue(p_Value);
        o_PlaySPITObject.setValueFlag(p_ValueFlag);
        return o_SPIT_Message;
    }

    public static SPIT_Message createWatchdog() {
        Watchdog o_Watchdog = new Watchdog();
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_Watchdog);
        return o_SPIT_Message;
    }

    public static SPIT_Message createReportPlayStatus(SPIT_Object_Interface p_SPIT_Object_Interface) {
        if (p_SPIT_Object_Interface == null) {
            return null;
        }
        SPIT_ActionStatus o_SPIT_ActionStatus = p_SPIT_Object_Interface.getSPIT_ActionStatus();
        if (o_SPIT_ActionStatus == null) {
            return null;
        }
        SPIT_Message o_SPIT_Message = SPIT_MessagePlayPool.getReportPlayStatus();
        ReportPlayStatus o_ReportPlayStatus = (ReportPlayStatus)o_SPIT_Message.getOPPart();
        o_ReportPlayStatus.setID(p_SPIT_Object_Interface.getID());
        o_ReportPlayStatus.setFrameInsideObject(o_SPIT_ActionStatus.getPlayFrameInside());
        o_ReportPlayStatus.setValue(o_SPIT_ActionStatus.getPlayValue());
        return o_SPIT_Message;
    }

    public static SPIT_Message createWatchdogAnswer() {
        WatchdogAnswer o_WatchdogAnswer = new WatchdogAnswer();
        SPIT_Message o_SPIT_Message = new SPIT_Message(o_WatchdogAnswer);
        return o_SPIT_Message;
    }

    public static class ReportPlayStatus
    extends OPPart {
        public static final int OPFLAG = 40;
        public static final int BYTESLENGTH = 57;
        private String m_SPITObjectID;
        private long m_FrameInsideObject;
        private int m_Value;

        private void initMembers() {
            this.m_SPITObjectID = "";
            this.m_FrameInsideObject = 0L;
            this.m_Value = 0;
            this.m_BytesCount = 57;
        }

        public ReportPlayStatus(Header p_Header) {
            super(p_Header, 40);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 40) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_SPITObjectID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
                this.m_FrameInsideObject = SPIT_Message.getLong(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 8;
                this.m_Value = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getID() {
            return this.m_SPITObjectID;
        }

        public long getFrameInsideObject() {
            return this.m_FrameInsideObject;
        }

        public int getValue() {
            return this.m_Value;
        }

        public ReportPlayStatus() {
            this.initMembers();
            this.m_Header = new Header(1, 40);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setID(String p_ID) {
            this.m_SPITObjectID = p_ID;
        }

        public void setFrameInsideObject(long p_TimeInside) {
            this.m_FrameInsideObject = p_TimeInside;
        }

        public void setValue(int p_Value) {
            this.m_Value = p_Value;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_SPITObjectID, p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += SPIT_Message.setLong(this.m_FrameInsideObject, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setInt(this.m_Value, p_MessageBytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class PlaySPITEnd
    extends OPPart {
        public static final int OPFLAG = 39;
        public static final int BYTESLENGTH = 45;
        private String m_PlayerID;

        private void initMembers() {
            this.m_PlayerID = "";
            this.m_BytesCount = 45;
        }

        public PlaySPITEnd(Header p_Header) {
            super(p_Header, 39);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 39) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_PlayerID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getPlayerID() {
            return this.m_PlayerID;
        }

        public PlaySPITEnd() {
            this.initMembers();
            this.m_Header = new Header(1, 39);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setPlayerID(String p_PlayerID) {
            if (p_PlayerID == null) {
                p_PlayerID = "";
            }
            this.m_PlayerID = p_PlayerID;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_PlayerID, p_MessageBytes, this.m_ParseOffset, 41);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class PlaySPITObject
    extends OPPart {
        public static final int OPFLAG = 38;
        public static final int BYTESLENGTH = 100;
        private String m_PlayerID;
        private String m_SPITObjectID;
        private long m_FrameInsideObject;
        private boolean m_PlayPrePosition;
        private int m_Value;
        private byte m_ValueFlag;

        private void initMembers() {
            this.m_PlayerID = "";
            this.m_SPITObjectID = "";
            this.m_FrameInsideObject = 0L;
            this.m_Value = 0;
            this.m_ValueFlag = 0;
            this.m_BytesCount = 100;
        }

        public PlaySPITObject(Header p_Header) {
            super(p_Header, 38);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 38) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_PlayerID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
                this.m_SPITObjectID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
                this.m_FrameInsideObject = SPIT_Message.getLong(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 8;
                this.m_PlayPrePosition = SPIT_Message.getBoolean(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_Value = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_ValueFlag = SPIT_Message.getByte(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getPlayerID() {
            return this.m_PlayerID;
        }

        public String getID() {
            return this.m_SPITObjectID;
        }

        public long getFrameInsideObject() {
            return this.m_FrameInsideObject;
        }

        public boolean getPlayPrePosition() {
            return this.m_PlayPrePosition;
        }

        public int getValue() {
            return this.m_Value;
        }

        public byte getValueFlag() {
            return this.m_ValueFlag;
        }

        public PlaySPITObject() {
            this.initMembers();
            this.m_Header = new Header(1, 38);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setPlayerID(String p_PlayerID) {
            if (p_PlayerID == null) {
                p_PlayerID = "";
            }
            this.m_PlayerID = p_PlayerID;
        }

        public void setID(String p_ID) {
            this.m_SPITObjectID = p_ID;
        }

        public void setFrameInsideObject(long p_TimeInside) {
            this.m_FrameInsideObject = p_TimeInside;
        }

        public void setPlayPrePosition(boolean p_PlayOldPosition) {
            this.m_PlayPrePosition = p_PlayOldPosition;
        }

        public void setValue(int p_Value) {
            this.m_Value = p_Value;
        }

        public void setValueFlag(byte p_ValueFlag) {
            this.m_ValueFlag = p_ValueFlag;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_PlayerID, p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += SPIT_Message.setString(this.m_SPITObjectID, p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += SPIT_Message.setLong(this.m_FrameInsideObject, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setBoolean(this.m_PlayPrePosition, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setInt(this.m_Value, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setByte(this.m_ValueFlag, p_MessageBytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class PlaySPITStart
    extends OPPart {
        public static final int OPFLAG = 37;
        public static final int BYTESLENGTH = 119;
        private String m_PlayerID;
        private String m_PlayerName;
        private byte m_PlayerType;
        private boolean m_PlayerIsRunning;
        private long m_Time;

        private void initMembers() {
            this.m_PlayerID = "";
            this.m_PlayerName = "";
            this.m_PlayerType = 0;
            this.m_Time = 0L;
            this.m_PlayerIsRunning = false;
            this.m_BytesCount = 119;
        }

        public PlaySPITStart(Header p_Header) {
            super(p_Header, 37);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 37) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_PlayerID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
                this.m_PlayerName = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_PlayerType = SPIT_Message.getByte(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_PlayerIsRunning = SPIT_Message.getBoolean(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_Time = SPIT_Message.getLong(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 8;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getPlayerID() {
            return this.m_PlayerID;
        }

        public String getPlayerName() {
            return this.m_PlayerName;
        }

        public byte getPlayerType() {
            return this.m_PlayerType;
        }

        public boolean getPlayerIsRunning() {
            return this.m_PlayerIsRunning;
        }

        public long getTime() {
            return this.m_Time;
        }

        public PlaySPITStart() {
            this.initMembers();
            this.m_Header = new Header(1, 37);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setPlayerID(String p_PlayerID) {
            if (p_PlayerID == null) {
                p_PlayerID = "";
            }
            this.m_PlayerID = p_PlayerID;
        }

        public void setPlayerName(String p_PlayerName) {
            if (p_PlayerName == null) {
                p_PlayerName = "";
            }
            this.m_PlayerName = p_PlayerName;
        }

        public void setPlayerType(byte p_PlayerType) {
            this.m_PlayerType = p_PlayerType;
        }

        public void setPlayerIsRunning(boolean p_IsPlaying) {
            this.m_PlayerIsRunning = p_IsPlaying;
        }

        public void setTime(long p_Time) {
            this.m_Time = p_Time;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_PlayerID, p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += SPIT_Message.setString(this.m_PlayerName, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setByte(this.m_PlayerType, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setBoolean(this.m_PlayerIsRunning, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setLong(this.m_Time, p_MessageBytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class RemoveSPITObject
    extends OPPart {
        public static final int OPFLAG = 33;
        public static final int BYTESLENGTH = 45;
        private String m_SPITObjectID;

        private void initMembers() {
            this.m_SPITObjectID = "";
            this.m_BytesCount = 45;
        }

        public RemoveSPITObject(Header p_Header) {
            super(p_Header, 33);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 33) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_SPITObjectID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getID() {
            return this.m_SPITObjectID;
        }

        public RemoveSPITObject() {
            this.initMembers();
            this.m_Header = new Header(1, 33);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setID(String p_ID) {
            this.m_SPITObjectID = p_ID;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_SPITObjectID, p_MessageBytes, this.m_ParseOffset, 41);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class ReportSPITObject
    extends OPPart {
        public static final int OPFLAG = 31;
        public static final int BYTESLENGTH = 339;
        private boolean m_Confirmed;
        private String m_SPITObjectID;
        private Boolean m_Fixed;
        private boolean m_ServerRemote;
        private String m_SPITObjectName;
        private String m_SPITTypeID;
        private String m_ServerParams;
        private long m_FrameStart;
        private long m_FrameLength;
        private long m_FrameFadeInLength;
        private long m_FrameFadeOutLength;
        private int m_ValueFactor;
        private byte m_ValueUse;
        private int m_Track;
        private String m_Remark;
        private long m_Delay;
        private long m_Duration;
        private boolean m_ActionAssigned;

        private void initMembers() {
            this.m_Confirmed = false;
            this.m_SPITObjectID = "";
            this.m_Fixed = false;
            this.m_ServerRemote = false;
            this.m_SPITObjectName = "";
            this.m_SPITTypeID = "";
            this.m_ServerParams = "";
            this.m_FrameStart = 0L;
            this.m_FrameLength = 0L;
            this.m_FrameFadeInLength = 0L;
            this.m_FrameFadeOutLength = 0L;
            this.m_ValueFactor = 0;
            this.m_ValueUse = 0;
            this.m_Track = 0;
            this.m_Remark = "";
            this.m_Delay = 0L;
            this.m_Duration = 0L;
            this.m_ActionAssigned = false;
            this.m_BytesCount = 339;
        }

        public ReportSPITObject(Header p_Header) {
            super(p_Header, 31);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 31) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_Confirmed = SPIT_Message.getBoolean(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_SPITObjectID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
                this.m_Fixed = SPIT_Message.getBoolean(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_ServerRemote = SPIT_Message.getBoolean(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_SPITObjectName = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_SPITTypeID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
                this.m_ServerParams = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_FrameStart = SPIT_Message.getLong(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 8;
                this.m_FrameLength = SPIT_Message.getLong(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 8;
                this.m_FrameFadeInLength = SPIT_Message.getLong(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 8;
                this.m_FrameFadeOutLength = SPIT_Message.getLong(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 8;
                this.m_ValueFactor = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_ValueUse = SPIT_Message.getByte(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_Track = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_Remark = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_Delay = SPIT_Message.getLong(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 8;
                this.m_Duration = SPIT_Message.getLong(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 8;
                this.m_ActionAssigned = SPIT_Message.getBoolean(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public boolean getConfirmed() {
            return this.m_Confirmed;
        }

        public String getID() {
            return this.m_SPITObjectID;
        }

        public boolean getFixed() {
            return this.m_Fixed;
        }

        public boolean getServerRemote() {
            return this.m_ServerRemote;
        }

        public String getName() {
            return this.m_SPITObjectName;
        }

        public String getSPITTypeID() {
            return this.m_SPITTypeID;
        }

        public String getServerParams() {
            return this.m_ServerParams;
        }

        public long getFrameStart() {
            return this.m_FrameStart;
        }

        public long getFrameLength() {
            return this.m_FrameLength;
        }

        public long getFrameFadeInLength() {
            return this.m_FrameFadeInLength;
        }

        public long getFrameFadeOutLength() {
            return this.m_FrameFadeOutLength;
        }

        public int getValueFactor() {
            return this.m_ValueFactor;
        }

        public byte getValueUse() {
            return this.m_ValueUse;
        }

        public int getTrack() {
            return this.m_Track;
        }

        public String getRemark() {
            return this.m_Remark;
        }

        public long getDelay() {
            return this.m_Delay;
        }

        public long getDuration() {
            return this.m_Duration;
        }

        public boolean getActionAssigned() {
            return this.m_ActionAssigned;
        }

        public ReportSPITObject() {
            this.initMembers();
            this.m_Header = new Header(1, 31);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setConfirmed(boolean p_Confirmed) {
            this.m_Confirmed = p_Confirmed;
        }

        public void setID(String p_ID) {
            this.m_SPITObjectID = p_ID;
        }

        public void setFixed(boolean p_Fixed) {
            this.m_Fixed = p_Fixed;
        }

        public void setServerRemote(boolean p_IsRemote) {
            this.m_ServerRemote = p_IsRemote;
        }

        public void setName(String p_Name) {
            this.m_SPITObjectName = p_Name;
        }

        public void setSPITTypeID(String p_ID) {
            this.m_SPITTypeID = p_ID;
        }

        public void setServerParams(String p_Parameters) {
            this.m_ServerParams = p_Parameters;
        }

        public void setFrameStart(long p_StartTime) {
            this.m_FrameStart = p_StartTime;
        }

        public void setFrameLength(long p_Length) {
            this.m_FrameLength = p_Length;
        }

        public void setFrameFadeInLength(long p_FadeInTime) {
            this.m_FrameFadeInLength = p_FadeInTime;
        }

        public void setFrameFadeOutLength(long p_FadeOutTime) {
            this.m_FrameFadeOutLength = p_FadeOutTime;
        }

        public void setValueFactor(int p_Volume) {
            this.m_ValueFactor = p_Volume;
        }

        public void setValueUse(byte p_ValueUse) {
            this.m_ValueUse = p_ValueUse;
        }

        public void setTrack(int p_Track) {
            this.m_Track = p_Track;
        }

        public void setRemark(String p_Description) {
            this.m_Remark = p_Description;
        }

        public void setDelay(long p_Delay) {
            if (p_Delay < 0L) {
                p_Delay = 0L;
            }
            this.m_Delay = p_Delay;
        }

        public void setDuration(long p_Duration) {
            if (p_Duration < 0L) {
                p_Duration = 0L;
            }
            this.m_Duration = p_Duration;
        }

        public void setActionAssigned(boolean p_ActionAssigned) {
            this.m_ActionAssigned = p_ActionAssigned;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setBoolean(this.m_Confirmed, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_SPITObjectID, p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += SPIT_Message.setBoolean(this.m_Fixed, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setBoolean(this.m_ServerRemote, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_SPITObjectName, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setString(this.m_SPITTypeID, p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += SPIT_Message.setString(this.m_ServerParams, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setLong(this.m_FrameStart, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setLong(this.m_FrameLength, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setLong(this.m_FrameFadeInLength, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setLong(this.m_FrameFadeOutLength, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setInt(this.m_ValueFactor, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setByte(this.m_ValueUse, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setInt(this.m_Track, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_Remark, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setLong(this.m_Delay, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setLong(this.m_Duration, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setBoolean(this.m_ActionAssigned, p_MessageBytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class RemoveSPITType
    extends OPPart {
        public static final int OPFLAG = 23;
        public static final int BYTESLENGTH = 45;
        private String m_SPITTypeID;

        private void initMembers() {
            this.m_SPITTypeID = "";
            this.m_BytesCount = 45;
        }

        public RemoveSPITType(Header p_Header) {
            super(p_Header, 23);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 23) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_SPITTypeID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getID() {
            return this.m_SPITTypeID;
        }

        public RemoveSPITType() {
            this.initMembers();
            this.m_Header = new Header(1, 23);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setID(String p_ID) {
            this.m_SPITTypeID = p_ID;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_SPITTypeID, p_MessageBytes, this.m_ParseOffset, 41);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class ReportSPITType
    extends OPPart {
        public static final int OPFLAG = 21;
        public static final int BYTESLENGTH = 168;
        private boolean m_Confirmed;
        private String m_SPITTypeID;
        private boolean m_Fixed;
        private boolean m_ServerRemote;
        private boolean m_ServerProjectIndepended;
        private String m_SPITTypeGroupName;
        private String m_SPITTypeName;
        private long m_Delay;
        private long m_Duration;

        private void initMembers() {
            this.m_Confirmed = false;
            this.m_SPITTypeID = "";
            this.m_Fixed = false;
            this.m_ServerRemote = false;
            this.m_ServerProjectIndepended = false;
            this.m_SPITTypeGroupName = "";
            this.m_SPITTypeName = "";
            this.m_Delay = 0L;
            this.m_Duration = 0L;
            this.m_BytesCount = 168;
        }

        public ReportSPITType(Header p_Header) {
            super(p_Header, 21);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 21) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_Confirmed = SPIT_Message.getBoolean(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_SPITTypeID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
                this.m_Fixed = SPIT_Message.getBoolean(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_ServerRemote = SPIT_Message.getBoolean(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_ServerProjectIndepended = SPIT_Message.getBoolean(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_SPITTypeGroupName = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 39);
                this.m_ParseOffset += 39;
                this.m_SPITTypeName = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_Delay = SPIT_Message.getLong(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 8;
                this.m_Duration = SPIT_Message.getLong(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 8;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public boolean getConfirmed() {
            return this.m_Confirmed;
        }

        public String getID() {
            return this.m_SPITTypeID;
        }

        public boolean getFixed() {
            return this.m_Fixed;
        }

        public boolean getServerRemote() {
            return this.m_ServerRemote;
        }

        public boolean getServerProjectIndepended() {
            return this.m_ServerProjectIndepended;
        }

        public String getGroupName() {
            return this.m_SPITTypeGroupName;
        }

        public String getName() {
            return this.m_SPITTypeName;
        }

        public long getDelay() {
            return this.m_Delay;
        }

        public long getDuration() {
            return this.m_Duration;
        }

        public ReportSPITType() {
            this.initMembers();
            this.m_Header = new Header(1, 21);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setConfirmed(boolean p_Confirmed) {
            this.m_Confirmed = p_Confirmed;
        }

        public void setID(String p_ID) {
            this.m_SPITTypeID = p_ID;
        }

        public void setFixed(boolean p_Fixed) {
            this.m_Fixed = p_Fixed;
        }

        public void setServerRemote(boolean p_IsServerRemote) {
            this.m_ServerRemote = p_IsServerRemote;
        }

        public void setServerProjectIndepended(boolean p_ProjectIndpended) {
            this.m_ServerProjectIndepended = p_ProjectIndpended;
        }

        public void setGroupName(String p_GroupName) {
            this.m_SPITTypeGroupName = p_GroupName;
        }

        public void setName(String p_Name) {
            this.m_SPITTypeName = p_Name;
        }

        public void setDelay(long p_Delay) {
            this.m_Delay = p_Delay;
        }

        public void setDuration(long p_Duration) {
            this.m_Duration = p_Duration;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setBoolean(this.m_Confirmed, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_SPITTypeID, p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += SPIT_Message.setBoolean(this.m_Fixed, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setBoolean(this.m_ServerRemote, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setBoolean(this.m_ServerProjectIndepended, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_SPITTypeGroupName, p_MessageBytes, this.m_ParseOffset, 39);
                this.m_ParseOffset += SPIT_Message.setString(this.m_SPITTypeName, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setLong(this.m_Delay, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setLong(this.m_Duration, p_MessageBytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class EndProjectTransfer
    extends OPPart {
        public static final int OPFLAG = 17;
        public static final int BYTESLENGTH = 4;

        private void initMembers() {
            this.m_BytesCount = 4;
        }

        public EndProjectTransfer(Header p_Header) {
            super(p_Header, 17);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 17) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public EndProjectTransfer() {
            this.initMembers();
            this.m_Header = new Header(1, 17);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class StartProjectTransfer
    extends OPPart {
        public static final int OPFLAG = 16;
        public static final int BYTESLENGTH = 4;

        private void initMembers() {
            this.m_BytesCount = 4;
        }

        public StartProjectTransfer(Header p_Header) {
            super(p_Header, 16);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 16) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public StartProjectTransfer() {
            this.initMembers();
            this.m_Header = new Header(1, 16);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class RequestProjectTransfer
    extends OPPart {
        public static final int OPFLAG = 15;
        public static final int BYTESLENGTH = 4;

        private void initMembers() {
            this.m_BytesCount = 4;
        }

        public RequestProjectTransfer(Header p_Header) {
            super(p_Header, 15);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 15) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public RequestProjectTransfer() {
            this.initMembers();
            this.m_Header = new Header(1, 15);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class CloseSPITProject
    extends OPPart {
        public static final int OPFLAG = 13;
        public static final int BYTESLENGTH = 45;
        private String m_ProjectID;

        private void initMembers() {
            this.m_ProjectID = "";
            this.m_BytesCount = 45;
        }

        public CloseSPITProject(Header p_Header) {
            super(p_Header, 13);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 13) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_ProjectID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getProjectID() {
            return this.m_ProjectID;
        }

        public CloseSPITProject() {
            this.initMembers();
            this.m_Header = new Header(1, 13);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setProjectID(String p_ClientID) {
            this.m_ProjectID = p_ClientID;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_ProjectID, p_MessageBytes, this.m_ParseOffset, 41);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class ReportSPITProject
    extends OPPart {
        public static final int OPFLAG = 11;
        public static final int BYTESLENGTH = 113;
        private String m_ProjectID;
        private String m_ProjectName;
        private int m_FramesPerSecond;

        private void initMembers() {
            this.m_ProjectID = "";
            this.m_ProjectName = "";
            this.m_BytesCount = 113;
            this.m_FramesPerSecond = 1000;
        }

        public ReportSPITProject(Header p_Header) {
            super(p_Header, 11);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 11) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_ProjectID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
                this.m_ProjectName = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_FramesPerSecond = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getProjectID() {
            return this.m_ProjectID;
        }

        public String getProjectName() {
            return this.m_ProjectName;
        }

        public int getFramesPerSecond() {
            return this.m_FramesPerSecond;
        }

        public ReportSPITProject() {
            this.initMembers();
            this.m_Header = new Header(1, 11);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setProjectID(String p_ProjectID) {
            this.m_ProjectID = p_ProjectID;
        }

        public void setProjectName(String p_ProjectName) {
            this.m_ProjectName = p_ProjectName;
        }

        public void setFramesPerSecond(int p_FramesPerSecond) {
            this.m_FramesPerSecond = p_FramesPerSecond;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_ProjectID, p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += SPIT_Message.setString(this.m_ProjectName, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setInt(this.m_FramesPerSecond, p_MessageBytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class WatchdogAnswer
    extends OPPart {
        public static final int OPFLAG = 9;
        public static final int BYTESLENGTH = 4;

        private void initMembers() {
            this.m_BytesCount = 4;
        }

        public WatchdogAnswer(Header p_Header) {
            super(p_Header, 9);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 9) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public WatchdogAnswer() {
            this.initMembers();
            this.m_Header = new Header(1, 9);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class Watchdog
    extends OPPart {
        public static final int OPFLAG = 8;
        public static final int BYTESLENGTH = 4;

        private void initMembers() {
            this.m_BytesCount = 4;
        }

        public Watchdog(Header p_Header) {
            super(p_Header, 8);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 8) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public Watchdog() {
            this.initMembers();
            this.m_Header = new Header(1, 8);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class Disconnect
    extends OPPart {
        public static final int OPFLAG = 3;
        public static final int BYTESLENGTH = 4;

        private void initMembers() {
            this.m_BytesCount = 4;
        }

        public Disconnect(Header p_Header) {
            super(p_Header, 3);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 3) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public Disconnect() {
            this.initMembers();
            this.m_Header = new Header(1, 3);
            super.setHeader(this.m_Header);
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class ConnectAnswer
    extends OPPart {
        public static final int OPFLAG = 2;
        public static final int BYTESLENGTH = 137;
        private String m_ServerComputerName;
        private String m_ServerName;
        private boolean m_Connected;
        private int m_StepTime;

        private void initMembers() {
            this.m_ServerComputerName = "";
            this.m_ServerName = "";
            this.m_Connected = false;
            this.m_BytesCount = 137;
            this.m_StepTime = 40;
        }

        public ConnectAnswer(Header p_Header) {
            super(p_Header, 2);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 2) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_ServerComputerName = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_ServerName = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_StepTime = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_Connected = SPIT_Message.getBoolean(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getServerComputerName() {
            return this.m_ServerComputerName;
        }

        public String getServerName() {
            return this.m_ServerName;
        }

        public boolean getConnected() {
            return this.m_Connected;
        }

        public int getStepTime() {
            return this.m_StepTime;
        }

        public ConnectAnswer() {
            this.initMembers();
            this.m_Header = new Header(1, 2);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setServerComputerName(String p_ServerComputerName) {
            if (p_ServerComputerName == null) {
                p_ServerComputerName = "";
            }
            this.m_ServerComputerName = p_ServerComputerName;
        }

        public void setServerName(String p_ServerName) {
            if (p_ServerName == null) {
                p_ServerName = "";
            }
            this.m_ServerName = p_ServerName;
        }

        public void setConnected(boolean p_Connected) {
            this.m_Connected = p_Connected;
        }

        public void setStepTime(int p_StepTime_ms) {
            if (p_StepTime_ms < 0) {
                p_StepTime_ms = 1;
            }
            this.m_StepTime = p_StepTime_ms;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_ServerComputerName, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setString(this.m_ServerName, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setInt(this.m_StepTime, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setBoolean(this.m_Connected, p_MessageBytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static class Connect
    extends OPPart {
        public static final int OPFLAG = 1;
        public static final int BYTESLENGTH = 304;
        private String m_ClientComputerName;
        private String m_ClientName;
        private String m_LoginName;
        private String m_LoginPassword;
        private String m_ServerIP;
        private int m_ServerPort;

        private void initMembers() {
            this.m_ClientComputerName = "";
            this.m_ClientName = "";
            this.m_LoginName = "";
            this.m_LoginPassword = "";
            this.m_ServerIP = "";
            this.m_ServerPort = 0;
            this.m_BytesCount = 304;
        }

        public Connect(Header p_Header) {
            super(p_Header, 1);
            this.initMembers();
        }

        @Override
        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            int intOPFlag = this.m_Header.getOPFlag();
            if (intOPFlag != 1) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
                this.m_ClientComputerName = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_ClientName = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_LoginName = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_LoginPassword = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += 64;
                this.m_ServerIP = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 40);
                this.m_ParseOffset += 40;
                this.m_ServerPort = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += 4;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getClientComputerName() {
            return this.m_ClientComputerName;
        }

        public String getClientName() {
            return this.m_ClientName;
        }

        public String getLoginName() {
            return this.m_LoginName;
        }

        public String getLoginPassword() {
            return this.m_LoginPassword;
        }

        public String getServerIP() {
            return this.m_ServerIP;
        }

        public int getServerPort() {
            return this.m_ServerPort;
        }

        public Connect() {
            this.initMembers();
            this.m_Header = new Header(1, 1);
            super.setHeader(this.m_Header);
            this.m_ParseOffset = 99;
        }

        public void setClientComputerName(String p_ComputerName) {
            this.m_ClientComputerName = p_ComputerName;
        }

        public void setClientName(String p_ClientName) {
            this.m_ClientName = p_ClientName;
        }

        public void setLoginName(String p_LoginName) {
            this.m_LoginName = p_LoginName;
        }

        public void setLoginPassword(String p_LoginPassword) {
            this.m_LoginPassword = p_LoginPassword;
        }

        public void setServerIP(String p_ServerIP) {
            if (p_ServerIP == null) {
                p_ServerIP = "";
            }
            this.m_ServerIP = p_ServerIP;
        }

        public void setServerPort(int p_ServerPort) {
            if (p_ServerPort < 0 || p_ServerPort > 65535) {
                p_ServerPort = 0;
            }
            this.m_ServerPort = p_ServerPort;
        }

        @Override
        public boolean fillBytes(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            if (this.m_Header == null) {
                return false;
            }
            if (!this.m_Header.fillBytes(p_MessageBytes)) {
                return false;
            }
            try {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_MessageBytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_ClientComputerName, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setString(this.m_ClientName, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setString(this.m_LoginName, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setString(this.m_LoginPassword, p_MessageBytes, this.m_ParseOffset, 64);
                this.m_ParseOffset += SPIT_Message.setString(this.m_ServerIP, p_MessageBytes, this.m_ParseOffset, 40);
                this.m_ParseOffset += SPIT_Message.setInt(this.m_ServerPort, p_MessageBytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }

    public static abstract class OPPart {
        protected Header m_Header;
        protected int m_ParseOffset;
        protected int m_BytesCount;

        public OPPart() {
            this.m_Header = null;
            this.m_ParseOffset = 0;
        }

        public abstract boolean fillBytes(byte[] var1);

        public OPPart(Header p_Header, int p_OPFlag) {
            this.m_Header = p_Header;
            if (this.m_Header != null) {
                this.m_ParseOffset = this.m_Header.getBytesCount();
                this.m_Header.setOPFlag(p_OPFlag);
            }
        }

        public void setHeader(Header p_Header) {
            this.m_Header = p_Header;
            if (this.m_Header != null) {
                this.m_ParseOffset = this.m_Header.getBytesCount();
            }
        }

        public Header getHeader() {
            return this.m_Header;
        }

        public void setBytesCount(int p_BytesCount) {
            this.m_BytesCount = p_BytesCount;
        }

        public int getBytesCount() {
            return this.m_BytesCount;
        }

        public String getServerID() {
            if (this.m_Header == null) {
                return "";
            }
            return this.m_Header.getServerID();
        }

        public String getClientID() {
            if (this.m_Header == null) {
                return "";
            }
            return this.m_Header.getClientID();
        }

        public int getOPFlag() {
            if (this.m_Header == null) {
                return -1;
            }
            return this.m_Header.getOPFlag();
        }

        public abstract boolean parse(byte[] var1);
    }

    public static class Header {
        public static final int BYTESLENGTH = 99;
        private String m_SPITID;
        private int m_SPITVersion;
        private byte m_MessageNumber;
        private int m_BytesCount;
        private String m_ServerID;
        private String m_ClientID;
        private int m_OPFlag;
        private int m_ParseOffset = 0;

        public Header() {
            this.initMembers();
        }

        private void initMembers() {
            this.m_SPITID = SPIT_Message.SPITID;
            this.m_SPITVersion = 1;
            this.m_MessageNumber = 0;
            this.m_BytesCount = 99;
            this.m_ServerID = "";
            this.m_ClientID = "";
        }

        public boolean parse(byte[] p_MessageBytes) {
            if (p_MessageBytes == null) {
                return false;
            }
            try {
                this.m_ParseOffset = 0;
                String stringSPIT_ID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 7);
                if (!SPIT_Message.SPITID.toLowerCase().equals(stringSPIT_ID.toLowerCase())) {
                    return false;
                }
                this.m_ParseOffset += 7;
                this.m_SPITVersion = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                if (this.m_SPITVersion < 0) {
                    return false;
                }
                this.m_ParseOffset += 4;
                this.m_MessageNumber = SPIT_Message.getByte(p_MessageBytes, this.m_ParseOffset);
                ++this.m_ParseOffset;
                this.m_BytesCount = SPIT_Message.getInt(p_MessageBytes, this.m_ParseOffset);
                if (this.m_BytesCount < 0) {
                    return false;
                }
                this.m_ParseOffset += 4;
                this.m_ServerID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
                this.m_ClientID = SPIT_Message.getString(p_MessageBytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += 41;
                this.m_OPFlag = p_MessageBytes[this.m_ParseOffset] & 0xFF;
                ++this.m_ParseOffset;
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }

        public String getSPITID() {
            return this.m_SPITID;
        }

        public int getSPITVersion() {
            return this.m_SPITVersion;
        }

        public byte getMessageNumber() {
            return this.m_MessageNumber;
        }

        public int getBytesCount() {
            return this.m_BytesCount;
        }

        public String getServerID() {
            return this.m_ServerID;
        }

        public String getClientID() {
            return this.m_ClientID;
        }

        public int getOPFlag() {
            return this.m_OPFlag;
        }

        public Header(int p_SPITVersion, int p_OPFlag) {
            this.initMembers();
            this.m_SPITVersion = p_SPITVersion;
            this.m_OPFlag = p_OPFlag;
        }

        public void setMessageNumber(byte p_MessageNumber) {
            this.m_MessageNumber = p_MessageNumber;
        }

        public void setBytesCount(int p_BytesCount) {
            this.m_BytesCount = p_BytesCount;
        }

        public void setServerID(String p_ID) {
            this.m_ServerID = p_ID;
        }

        public void setClientID(String p_ID) {
            this.m_ClientID = p_ID;
        }

        public void setOPFlag(int p_OPFlag) {
            this.m_OPFlag = p_OPFlag;
        }

        public boolean fillBytes(byte[] p_Bytes) {
            if (p_Bytes == null) {
                return false;
            }
            try {
                this.m_ParseOffset = 0;
                this.m_ParseOffset += SPIT_Message.setString(this.m_SPITID, p_Bytes, this.m_ParseOffset, 7);
                this.m_ParseOffset += SPIT_Message.setInt(1, p_Bytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setByte(this.m_MessageNumber, p_Bytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setInt(this.m_BytesCount, p_Bytes, this.m_ParseOffset);
                this.m_ParseOffset += SPIT_Message.setString(this.m_ServerID, p_Bytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += SPIT_Message.setString(this.m_ClientID, p_Bytes, this.m_ParseOffset, 41);
                this.m_ParseOffset += SPIT_Message.setByte(this.m_OPFlag, p_Bytes, this.m_ParseOffset);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }
}

