/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   SPIT_ClientInterface.h
 * Author: Hagi
 *
 * Created on 17. April 2019, 16:15
 * Changed on 13. December 2022
 * 
 * Every App (myApp) has to implement the SPIT_ClientInterface. the pointer to MyApp is referred in the constructor of SPIT_Client.<br>
 * The SPIT_Client calls the SPIT_ClientInterface's functions when an event occurs (for excample parsing a SPIT_Message, adding/removing a SPITType,..).
 */

#ifndef SPIT_CLIENTINTERFACE_H
#define SPIT_CLIENTINTERFACE_H

//#include <string>

#include "SPITType.h"
#include "SPITObject.h"
#include "SPITPlayer.h"
#include "SAD_DetectedServer.h"
#include "SPIT_Client.h"

using namespace std;

class SPIT_ClientInterface {
public:
	
	virtual string getClientProjectID() = 0;
	virtual string getClientProjectName() = 0;
	
	/**
	 * If a new server was found by the ServerAutoDetect mechanism, this function is called.
	 * If a server can be reached via several IP addresses, the IP address is selected according to the following preference:<br>
	 * 1.) If a loopback address is available, it is used.<br>
	 * 2.) If an IP4 address is available, it is used.<br>
	 * 3.) In the other cases the IP6 address is used.<br>
	 * @param p_ID the id of the server (every started server should generate an id)
	 * @param p_Name the name of the SPIT server
	 * @param p_ComputerName the Hostname of the cpmputer on which the SPIT server is running
	 * @param p_IP the selected ip address of the SPIT server
	 * @param p_Port the port of the SPIT server
	 * @param p_Addition sometimes server may have additional informations
	 * @param p_isLoopback the server ip is a loopback address
	 * @param p_IsIP4 the server ip is a ip4 address
	 * @param p_IsIP6 the server ip is a ip6 address
	 */
	virtual void eventServerDetected(const SAD_DetectedServer& p_DetectedServer) = 0;
	virtual void eventServerLost(const SAD_DetectedServer& p_DetectedServer) = 0;
	virtual void eventServerChanged(const SAD_DetectedServer& p_DetectedServer) = 0;
	
	virtual void eventConnectionStatus(string p_ServerID, string p_ServerComputerName, string p_ServerName, int p_ServerStepTime, int p_ConnectionStatus, int p_OldConnectionStatus) = 0;
	
	virtual void eventReportProject_Server(string p_ProjectID, string p_ProjectName, int p_FramesPerSeoond) = 0;
	virtual void eventProjectClosed_Server(string p_ProjectID) = 0;
	
	
	virtual void eventStartProjectTransfer_Server() = 0;
	virtual void eventEndProjectTransfer_Server() = 0;
	virtual void eventStartProjectTransfer_Client() = 0;
	virtual void eventEndProjectTransfer_Client() = 0;

	/**
	* The SPITCLientInterface will be asked to veto the SPITType while SPIT_Client.parseReportSPITType.<br>
	* @param p_ReportSPITType
	* @return false = the SPITType is denied, true = the SPITType is accepted
	*/
	virtual bool checkSPITTypeVeto(SPIT_Message::ReportSPITType* p_ReportSPITType) = 0;
	
	virtual void eventSPITType(bool p_New, const SPITType& p_SPITType) = 0;
	virtual void eventSPITTypeRemote(bool p_New, const SPITType& p_SPITType) = 0;
	
	virtual void eventSPITTypeRemoved(const SPITType& p_SPITType) = 0;
	virtual void eventSPITTypeRemoteRemoved(const SPITType& p_SPITType) = 0;

	/**
	* The SPITCLientInterface will be asked to veto the SPITObject while SPIT_Client.parseReportSPITObject.<br>
	* @param p_ReportSPITType
	* @return false = the SPITObject is denied, true = the SPITObject is accepted
	*/
	virtual bool checkSPITObjectVeto(SPIT_Message::ReportSPITObject* p_ReportSPITOnject) = 0;
	
	virtual void eventSPITObject(bool p_New, const SPITType& p_SPITType, const SPITObject& p_SPITObject) = 0;
	virtual void eventSPITObjectRemote(bool p_New, const SPITType& p_SPITType, const SPITObject& p_SPITObject) = 0;
	virtual void eventSPITObjectRemoved(const SPITType& p_SPITType, const SPITObject& p_SPITObject) = 0;
	virtual void eventSPITObjectRemoteRemoved(const SPITType& p_SPITType, const SPITObject& p_SPITObject) = 0;
	
	virtual void eventPlay(string p_PlayerID, string p_PlayerName, char p_PlayerType, bool p_PlayerIsRunning, long long p_TimeFrames) = 0;
	
	virtual void eventPlaySPITType(string p_PlayerID, string SPITTypeID, bool p_PlkayerIsRunning, bool p_Started, bool p_Ended, double p_Value) = 0;
	
	
	//REMOTE Server->Client
	virtual void eventSPITObjectPlayStatus(const SPITType& p_SPITType, const SPITObject& p_SPITObject, long long p_FrameInsideObject, int p_Value) = 0;
};

#endif /* SPIT_CLIENTINTERFACE_H */

