/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   SPITType.h
 * Author: Hagi
 *
 * Created on 8. April 2019, 08:40
 */

#ifndef SPITTYPE_H
#define SPITTYPE_H

#include "_SPITMACROS.h"
#include "SPIT_Message.h"
#include <string>
#include <unordered_map>
#include <mutex>


using namespace std;

class SPITTypeListener;

class SPITType {
private:
	static recursive_mutex					s_MutexSPITType;	
	static unordered_map<string, SPITType*> s_SPITTypes;
	static unordered_map<string, SPITType*> s_SPITTypesRemote;
	
	

public:
	static recursive_mutex* getMutex() {
		return &s_MutexSPITType;
	}
	static SPITType* getSPITType(string p_ID);
	static const SPITType& getSPITTypeRef(string p_ID);
	static bool addSPITType(SPITType* p_ptrSpitType);
	static bool removeSPITType(SPITType* p_ptrSpitType);
	static int	getSPITTypeCount();
	static SPITType* getSPITType(int p_Index);
	static const SPITType& getSPITTypeRef(int p_Index);
	static void clearSPITTypes();
	static void setConfirmedFalse();

	static SPITType* getSPITTypeRemote(string p_ID);
	static const SPITType& getSPITTypeRemoteRef(string p_ID);
	static bool addSPITTypeRemote(SPITType* p_ptrSpitType);
	static bool removeSPITTypeRemote(SPITType* p_ptrSpitType);
	static int	getSPITTypeRemoteCount();
	static SPITType* getSPITTypeRemote(int p_Index);
	static const SPITType& getSPITTypeRemoteRef(int p_Index);
	static void clearSPITTypesRemote();
	
	static void eventProjectClosed();
	
	SPITType();
	SPITType(string p_ID, string p_GroupName, string p_Name, bool p_Fixed, bool p_ProjectIndepended,long long p_DefaultDelay, long long p_DefaultDuration);
//	SPITType(const SPITType& orig);
	~SPITType();
private:
	
	bool		m_Confirmed;
	string		m_ID;
	bool		m_Fixed;
	bool		m_ServerRemote;
	bool		m_ServerProjectIndepended;
	string		m_GroupName;
	string		m_Name;
	long long	m_DefaultDelay;
	long long	m_DefaultDuration;
	
	bool		m_CreatedByClient;	//flag true = the SPITTyype is created by the client
									//false = the SPITType is received from the server
	
	bool		m_ActionAssigned;	//This is a virtual flag if user associates an action with a SPITType.
									//Can be used to setActionAssigned for all SPITObjects with this SPITType 
		
	void initMembers();
		
public:
	string getID() const{
		return m_ID;
	}
	string getGroupName() const {
		return m_GroupName;
	}
	string getName() const {
		return m_Name;
	}
	/**
	 * Returns if the SPITType triggers an action on the Server or on the client.
	 * @return false = the action is triggered on the client The client waits for the server to play objects of this SPITType<br>
	 * true = the action is triggered on the server. The server waits for the client to play objects of this SPITType.
	 */
	bool getServerRemote() const {
		return m_ServerRemote;
	}
	
	bool getProjectIndepended() const {
		return m_ServerProjectIndepended;
	}
	/**
	 * This is used by the server and client to tell if the other side has registered the changes.
	 * @return true = other side has registered the changes.
	 */	
	bool getConfirmed() const {
		return m_Confirmed;
	}
	bool getFixed() const {
		return m_Fixed;
	}
	long long getDefaultDelay() const {
		return m_DefaultDelay;
	}
	long long getDefaultDuration() const {
		return m_DefaultDuration;
	}
	
	bool getCreatedByClient() const {
		return m_CreatedByClient;
	}
	
	/**
	 * Virtual construct - means ActionAssigned for SPITTypes is is not implemented in SPITProtocol.<br>
	 * This can used to setActionAssigned to all SPITObjects with this SPITType.<br>
	 * This may be used in the case when the same action should be done for every SPITObject with this SPITType associated.<br>
	 * @return true = the user has associated an action with this SPITType.
	 */
	bool getActionAssigned() const {
		return m_ActionAssigned;
	}
	
	
public:
	void setID(string p_ID);
	bool setGroupName(string p_GroupName);
	bool setName(string p_Name);
	bool setServerRemote(bool p_BelongstoServer);
	bool setProjectIndepended(bool p_ProjectIndepeneded);
	bool setConfirmed(bool p_Confirmed);
	bool setFixed(bool p_Fixed);
	bool setDefaultDelay(long long p_Delay);
	bool setDefaultDuration(long long p_Duration);
	
	void setCreatedByClient(bool p_CreatedByClient);
	
	/**
	 * Virtual construct - means ActionAssigned for SPITTypes is is not implemented in SPITProtocol.<br>
	 * This can used to setActionAssigned to all SPITObjects with this SPITType.<br>
	 * This may be used in the case when the same action should be done for every SPITObject with this SPITType associated.<br>
	 * @return true = the m_ActionAssigned has changed.
	 */
	bool setActionAssigned(bool p_ActionAssigned);
	
	bool setMessageOP(SPIT_Message::ReportSPITType* p_ReportSPITType);
	void fillMessageOP(SPIT_Message::ReportSPITType* p_ReportSPITType);
	void fillMessageOP(SPIT_Message::RemoveSPITType* p_RemoveSPITType);
//	static char* stringCopy(const char* p_String);
};



#endif /* SPITTYPE_H */

