/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * SPITSOcket is the base class for WindowsSocket and UnixSocket.
 * File:   SPITSocket.cpp
 * Author: Hagi
 * 
 * Created on 12. April 2019, 15:40
 */

#include "SPITSocket.h"

//----- initialize static members -----
recursive_mutex SPITSocket::s_MutexIPAddresses;
unordered_map<string, SPITSocket::IPAddress*> SPITSocket::s_IPAddresses;
int SPITSocket::FAMILY_IP4 = 2;
int SPITSocket::FAMILY_IP6 = 23;


SPITSocket::SPITSocket() {
	m_ServerIP = "";
	m_ServerPort = "";
	m_ClientIP = "";
	m_ClientPort = "";
	m_BoundClientPort = "";
	m_BoundClientFamily = 0;
	m_IsBound = false;
}


SPITSocket::~SPITSocket() {
	{
		unique_lock<recursive_mutex> o_LockSocket(m_MutexSocket);
		m_IsBound = false;
	}
}
void SPITSocket::setConnectionParams(string p_ServerIP, string p_ServerPort, string p_ClientIP, string p_ClientPort) {
	m_ServerIP = p_ServerIP;
	m_ServerPort = p_ServerPort;
	m_ClientIP = p_ClientIP;
	m_ClientPort = p_ClientPort;
}
string SPITSocket::getServerIP() {
	return m_ServerIP;
}
string SPITSocket::getServerPort(){
	return m_ServerPort;
}
string SPITSocket::getClientIP() {
	return m_ClientIP;
}
string SPITSocket::getClientPort() {
	return m_ClientPort;
}
string SPITSocket::getBoundClientPort() {
	return m_BoundClientPort;
}
void SPITSocket::setBoundClientPort(string p_Port) {
	m_BoundClientPort = p_Port;
}
int SPITSocket::getBoundClientFamily() {
	return m_BoundClientFamily;
}
void SPITSocket::setBoundClientFamily(int p_Family) {
	m_BoundClientFamily = p_Family;
}

void SPITSocket::setIsBound(bool p_IsBound) {
	{
		unique_lock<recursive_mutex> o_LockSocket(m_MutexSocket);
		m_IsBound = p_IsBound;
	}
}
bool SPITSocket::getIsBound() {
	return m_IsBound;
}

int SPITSocket::sendMessage(const char* p_MessageBytes, int p_MessageLength) {
	if (m_ServerPort.length() <= 0) return -1;
	int intResult;
	{
		unique_lock<recursive_mutex> o_LockSocket(m_MutexSocket);
		if (m_IsBound == false) return -1;
		intResult = sendMessageTo(m_BoundClientFamily, m_ServerIP, m_ServerPort, p_MessageBytes, p_MessageLength);
	}
	return intResult;
}



//---------- IP Adresses ---------
void SPITSocket::addIPAddress(string p_IPAddress, string p_SubnetMask) {
		IPAddress* o_IPAddress;
		{
			unique_lock<recursive_mutex> o_LockIP(s_MutexIPAddresses);
			auto i = s_IPAddresses.find(p_IPAddress);
			if (i != s_IPAddresses.end()) {
				o_IPAddress = i->second;
			}
			else {
				o_IPAddress = new IPAddress();
			}
			o_IPAddress->setIPAddress(p_IPAddress);
			o_IPAddress->setSubnetMask(p_SubnetMask);
			o_IPAddress->setFound(true);
			s_IPAddresses[o_IPAddress->getIPAddress()] = o_IPAddress;
		}
}
void SPITSocket::removeIPAddress(string p_IPAddress) {
		IPAddress* o_IPAddress;
		{
			unique_lock<recursive_mutex> o_LockIP(s_MutexIPAddresses);
			auto i = s_IPAddresses.find(p_IPAddress);
			if (i != s_IPAddresses.end()) {
				o_IPAddress = i->second;
				i = s_IPAddresses.erase(i);
				delete o_IPAddress;
			}
		}
}
int SPITSocket::getIPAddressCount() {
	return s_IPAddresses.size();
}
SPITSocket::IPAddress* SPITSocket::getIPAddress(int p_Index) {
		IPAddress* ptr_IPAddress = NULL;
		
		{
			unique_lock<recursive_mutex> o_LockIP(s_MutexIPAddresses);
			if (p_Index <= (int)s_IPAddresses.size()) {
				unordered_map<string, IPAddress*>::iterator i = next(s_IPAddresses.begin(), p_Index);
				ptr_IPAddress = i->second;
			}
			return ptr_IPAddress;
		}
}
void SPITSocket::clearIPAddresses() {
		IPAddress* o_IPAddress;
		{
			unique_lock<recursive_mutex> o_LockIP(s_MutexIPAddresses);
			for (auto i = s_IPAddresses.begin(); i != s_IPAddresses.end(); i++) {
				o_IPAddress = i->second;
				i = s_IPAddresses.erase(i);
				delete o_IPAddress;
				if (i == s_IPAddresses.end()) {
					break;
				}
			}
		}
	}
	
	
void SPITSocket::resetFoundIPAddresses() {
		IPAddress* o_IPAddress;
		{
			unique_lock<recursive_mutex> o_LockIP(s_MutexIPAddresses);
			for (auto i = s_IPAddresses.begin(); i != s_IPAddresses.end(); i++) {
				o_IPAddress = i->second;
				o_IPAddress->setFound(false);
			}
		}
}
void SPITSocket::removeNotFoundIPAddresses() {
		IPAddress* o_IPAddress;
		{
			unique_lock<recursive_mutex> o_LockIP(s_MutexIPAddresses);
			for (auto i = s_IPAddresses.begin(); i != s_IPAddresses.end(); i++) {
				o_IPAddress = i->second;
				if (o_IPAddress->getFound() == false) {
					i = s_IPAddresses.erase(i);
					delete o_IPAddress;
					if (i == s_IPAddresses.end()) {
						break;
					}
				}
			}
		}
}



//------------ IPAddress -------------------
SPITSocket::IPAddress::IPAddress() {
	m_IPAddress = "";
	m_SubnetMask = "";
	m_Found = false;
}
SPITSocket::IPAddress::~IPAddress() {
	m_Found = false;
}
void SPITSocket::IPAddress::setIPAddress(const string& p_IPAddress) {
	m_IPAddress = p_IPAddress;
}
void SPITSocket::IPAddress::setSubnetMask(const string& p_SubnetMask) {
	m_SubnetMask = p_SubnetMask;
}
void SPITSocket::IPAddress::setFound(bool p_Found) {
	m_Found = p_Found;
}
