/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * SPITPlayer describes a virtual SPIT Player.
 * File:   SPITPLayer.cpp
 * Author: Hagi
 * 
 * Created on 30. April 2019, 11:44
 */

#include <vector>

#include "SPITPlayer.h"

recursive_mutex SPITPlayer::s_Mutex;
unordered_map<string, SPITPlayer*> SPITPlayer::s_SPITPlayers;

SPITPlayer* SPITPlayer::getSPITPlayer(string p_PlayerID) {
	{
		unique_lock<recursive_mutex> o_LockSPITPlayer(*SPITPlayer::getMutex());
		auto i = s_SPITPlayers.find(p_PlayerID);
		if (i == s_SPITPlayers.end()) {
			s_SPITPlayers[p_PlayerID] = new SPITPlayer(p_PlayerID);
		}
		i = s_SPITPlayers.find(p_PlayerID);
		if (i == s_SPITPlayers.end()) return NULL;
		return i->second;
	}
}

void SPITPlayer::clearPlayers() {
	SPITPlayer* ptrSPITPlayer;
	vector<SPITPlayer*> o_SPITPlayers;
	{
		unique_lock<recursive_mutex> o_LockSPITPlayer(*SPITPlayer::getMutex());
		for (auto i = s_SPITPlayers.begin(); i != s_SPITPlayers.end(); i++) {
			ptrSPITPlayer = i->second;
			o_SPITPlayers.push_back(ptrSPITPlayer);
		}	
	}
	for (auto i = o_SPITPlayers.begin(); i != o_SPITPlayers.end(); i++) {
		ptrSPITPlayer = *i;
		delete ptrSPITPlayer;
	}
	o_SPITPlayers.clear();
}

SPITPlayer::SPITPlayer(string p_PlayerID) {
	m_ID = p_PlayerID;
	s_SPITPlayers[p_PlayerID] = this;
}


SPITPlayer::~SPITPlayer() {
	{
		unique_lock<recursive_mutex> o_LockPlayer(s_Mutex);
		PlaySPITType* ptrPlaySPITType;
		for (auto i = m_PlaySPITTypes.begin(); i != m_PlaySPITTypes.end(); i++) {
			ptrPlaySPITType = i->second;
			i = m_PlaySPITTypes.erase(i);
			delete ptrPlaySPITType;
			if (i == m_PlaySPITTypes.end()) {
				break;
			}
		}
	}
}

void SPITPlayer::setIsRunning(bool p_IsRunning) {
	m_IsRunning = p_IsRunning;
}
void SPITPlayer::setName(string p_Name) {
	m_Name = p_Name;
}
void SPITPlayer::setType(char p_Type) {
	m_Type = p_Type;
}
void SPITPlayer::setTime(long long p_Frames) {
	m_TimeFrames = p_Frames;
}



unordered_map<string, SPITPlayer::PlaySPITType*>* SPITPlayer::getPlaySPITTypes() {
		return &m_PlaySPITTypes;
}

/**
 * 
 * @param p_SPITTypeID
 * @return true = new PlaySPITType added<br>
 * false = PlaySPITType exists 
 */
SPITPlayer::PlaySPITType* SPITPlayer::addSPITType_Playing (string p_SPITTypeID) {
	PlaySPITType* ptrPlaySPITType;
	{
		unique_lock<recursive_mutex> o_LockSPITPlayer(*SPITPlayer::getMutex());
		auto i = m_PlaySPITTypes.find(p_SPITTypeID);
		if (i == m_PlaySPITTypes.end()) {
			ptrPlaySPITType = new PlaySPITType(this, p_SPITTypeID);
			ptrPlaySPITType->setIsPlayed(true);
			ptrPlaySPITType->setIsNew(true);
			m_PlaySPITTypes[p_SPITTypeID] = ptrPlaySPITType;
		}
		else {
			ptrPlaySPITType = i->second;
			ptrPlaySPITType->setIsPlayed(true);
		}
		return ptrPlaySPITType;
	}
}


void SPITPlayer::startPlaySequence() {
	PlaySPITType* ptrPlaySPITType;
	{
		unique_lock<recursive_mutex> o_LockSPITPlayer(*SPITPlayer::getMutex());
		for (auto i = m_PlaySPITTypes.begin(); i != m_PlaySPITTypes.end(); i++) {
			ptrPlaySPITType = i->second;
			ptrPlaySPITType->startPlaySequence();
		}
	}
}

void SPITPlayer::endPlaySequence() {
	PlaySPITType* ptrPlaySPITType;
	{
		unique_lock<recursive_mutex> o_LockSPITPlayer(*SPITPlayer::getMutex());
		for (auto i = m_PlaySPITTypes.begin(); i != m_PlaySPITTypes.end(); i++) {
			ptrPlaySPITType = i->second;
			if (ptrPlaySPITType->getIsPlayed() == false) {
				i = m_PlaySPITTypes.erase(i);
				delete ptrPlaySPITType;
				if (i == m_PlaySPITTypes.end()) {
					break;
				}
			}
		}
	}
}
SPITPlayer::PlaySPITType::PlaySPITType() {
}
SPITPlayer::PlaySPITType::PlaySPITType(SPITPlayer* p_SPITPlayer, string p_SPITTypeID) {
	m_SPITTypeID = p_SPITTypeID;
	m_PlayerID = p_SPITPlayer->getID();
	m_PlayerName = p_SPITPlayer->getName();
	startPlaySequence();
	m_IsNew = true;
}
SPITPlayer::PlaySPITType::PlaySPITType(const PlaySPITType& orig) {
	m_SPITTypeID = orig.getSPITTypeID();
	m_IsPlayed = orig.getIsPlayed();
	m_IsNew = orig.getIsNew();

	m_PlayerID = orig.getPlayerID();
	m_PlayerName = orig.getPlayerName();
	m_PlayerRuns = orig.getPlayerIsRunning();

	m_Value = orig.getValue();
}
void SPITPlayer::PlaySPITType::startPlaySequence() {
	m_IsPlayed = false;
	m_IsNew = false;
			
	m_Value = 0;
}





