/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * SAD_DetectedServer holds information about SPIT Server detected by ServerAutoDetection (SAD).
 * File:   SAD_DetectedServer.cpp
 * Author: Hagi
 * 
 * Created on 4. Mai 2019, 13:51
 */

#include "SAD_DetectedServer.h"

recursive_mutex SAD_DetectedServer::s_MutexDetectedServer;
unordered_map<string, SAD_DetectedServer*> SAD_DetectedServer::s_DetectedServers;

SAD_DetectedServer::~SAD_DetectedServer() {
}
//----- Detected Server -----
SAD_DetectedServer::SAD_DetectedServer() {
	m_ID = "";
	m_Name = "";
	m_ComputerName = "";
	m_ServerProjectName = "";
	m_ClientIP = "";
	m_Port = "";
	m_Additions = "";
	m_IPIsLoopback = false;
	m_IPIsIP4 = false;
	m_IPIsIP6 = false;
	m_Changed = false;
	m_New = false;
}

void SAD_DetectedServer::setID(string p_ID) {
	m_ID = p_ID;
}
void SAD_DetectedServer::setName(string p_Name) {
	m_Name = p_Name;
}
void SAD_DetectedServer::setComputerName(string p_ComputerName) {
	m_ComputerName = p_ComputerName;
}
void SAD_DetectedServer::setIP(string p_IP) {
	m_IP = p_IP;
}
void SAD_DetectedServer::setClientIP(string p_IP) {
	m_ClientIP = p_IP;
}
void SAD_DetectedServer::setPort(string p_Port) {
	m_Port = p_Port;
}
void SAD_DetectedServer::setAdditions(string p_Additions) {
	m_Additions = p_Additions;
}
void SAD_DetectedServer::setProjectName(string p_ServerProjectName) {
	if (m_ServerProjectName.compare(p_ServerProjectName) != 0) {
		if (m_New == false) {
			m_Changed = true;
		}
	}
	m_ServerProjectName = p_ServerProjectName;
}

void SAD_DetectedServer::cycleStart() {
	{
		unique_lock<recursive_mutex>o_lock(s_MutexDetectedServer);
		for (auto i = s_DetectedServers.begin(); i != s_DetectedServers.end(); i++) {
			i->second->startCycleSAD();
		}
	}
}
void SAD_DetectedServer::cycleEnd(SAD_ClientInterface* p_SADClientInterface) {
	list<SAD_DetectedServer*> o_LostServers;
	list<SAD_DetectedServer*> o_NewServers;
	list<SAD_DetectedServer*> o_ChangedServers;
	SAD_DetectedServer* ptrDetectedServer;
	{
		unique_lock<recursive_mutex> o_lock(s_MutexDetectedServer);
		for (auto i = s_DetectedServers.begin(); i != s_DetectedServers.end(); i++) {
			ptrDetectedServer = i->second;
			if (ptrDetectedServer->getFoundAgain() == false) {
				o_LostServers.push_back(ptrDetectedServer);
				ptrDetectedServer->endCycleSAD();
			} 
			else if (ptrDetectedServer->getNew()) {
				o_NewServers.push_back(ptrDetectedServer);
				ptrDetectedServer->setNew(false);
				ptrDetectedServer->endCycleSAD();
			}
			else if (ptrDetectedServer->getChanged()) {
	//			p_SADClientInterface->
				o_ChangedServers.push_back(ptrDetectedServer);
				ptrDetectedServer->endCycleSAD();
			}
			else {
				ptrDetectedServer->endCycleSAD();
			}
		}
	}
	//Notify client interface about lost servers
	for (auto i = o_LostServers.begin(); i != o_LostServers.end(); i++) {
		ptrDetectedServer = *i;
		if (p_SADClientInterface != NULL) {
			p_SADClientInterface->eventServerLost(ptrDetectedServer->getID(), ptrDetectedServer->getName(), 
				ptrDetectedServer->getComputerName(), ptrDetectedServer->getIP(), ptrDetectedServer->getPort(), ptrDetectedServer->getAdditions(), ptrDetectedServer->getProjectName(),
				ptrDetectedServer->getClientIP(),
				ptrDetectedServer->getIpIsLoopback(), ptrDetectedServer->getIpIsIP4(), ptrDetectedServer->getIpIsIP6());
		}
	}
	//Remove lost servers
	for (auto i = o_LostServers.begin(); i != o_LostServers.end(); i++) {
		ptrDetectedServer = *i;
		removeDetectedServer(ptrDetectedServer);
	}
	o_LostServers.clear();
	
	for (auto i = o_NewServers.begin(); i != o_NewServers.end(); i++) {
		ptrDetectedServer = *i;
		if (p_SADClientInterface != NULL) {
			p_SADClientInterface->eventServerDetected(ptrDetectedServer->getID(), ptrDetectedServer->getName(), 
				ptrDetectedServer->getComputerName(), ptrDetectedServer->getIP(), ptrDetectedServer->getPort(), ptrDetectedServer->getAdditions(), ptrDetectedServer->getProjectName(), 
				ptrDetectedServer->getClientIP(),
				ptrDetectedServer->getIpIsLoopback(), ptrDetectedServer->getIpIsIP4(), ptrDetectedServer->getIpIsIP6());
		}
	}
	o_NewServers.clear();
	for (auto i = o_ChangedServers.begin(); i != o_ChangedServers.end(); i++) {
		ptrDetectedServer = *i;
		if (p_SADClientInterface != NULL) {
			p_SADClientInterface->eventServerChanged(ptrDetectedServer->getID(), ptrDetectedServer->getName(), 
				ptrDetectedServer->getComputerName(), ptrDetectedServer->getIP(), ptrDetectedServer->getPort(), ptrDetectedServer->getAdditions(), ptrDetectedServer->getProjectName(),
				ptrDetectedServer->getClientIP(),
				ptrDetectedServer->getIpIsLoopback(), ptrDetectedServer->getIpIsIP4(), ptrDetectedServer->getIpIsIP6());
		}
	}
	o_ChangedServers.clear();

	
}
	/**
	 * Used by SAD_Client to add a found SPITServer - don't use this manually
	 * @param p_IsIP4 true = the server is reached via a IP4 address<br>false = the server is reahed via a IP6 address
	 * @param p_ServerID the id of the server, every instance of a SPITServer has an own id
	 * @param p_ServerParams the server's parameter
	 */
void SAD_DetectedServer::addDetectedServer(bool p_IsIP4, string p_ServerID, string  p_ServerParams[]) {
		SAD_DetectedServer* ptrDetectedServer;
		bool boolIP6 = false;
		{
			unique_lock<recursive_mutex> o_Lock(s_MutexDetectedServer);
			auto i = s_DetectedServers.find(p_ServerID);
			if (i != s_DetectedServers.end()) {
				ptrDetectedServer = i->second;
			}
			else {
				ptrDetectedServer = new SAD_DetectedServer();
				ptrDetectedServer->setID(p_ServerParams[PARAMINDEX_ID]);
				ptrDetectedServer->setNew(true);
			}
			ptrDetectedServer->setFoundAgain();
			
			//Check if the serverIP starts with loopback ip4
			if (p_ServerParams[PARAMINDEX_IP].find("127.") == 0) { //IP4 loopback 127.0.0.1
				//we prefer IP4 first
				boolIP6 = false;
				ptrDetectedServer->setIP(p_ServerParams[PARAMINDEX_IP]);
				ptrDetectedServer->setIPIsLoopback(true);
				ptrDetectedServer->setClientIP(p_ServerParams[PARAMINDEX_CLIENTIP]);
			}
			//Check if the serverIP starts with loopback ip6
			if (ptrDetectedServer->getIpIsLoopback() == false) { 
				if (p_ServerParams[PARAMINDEX_IP].find("0000:0000:0000:0000:0000:0000:0000:0001") == 0|| //IP6 loopback 0000:0000:0000:0000:0000:0000:0000:0001/128
					p_ServerParams[PARAMINDEX_IP].find("0:0:0:0:0:0:0:1") == 0||
					p_ServerParams[PARAMINDEX_IP].find("::1") == 0) {
					boolIP6 = true;
					ptrDetectedServer->setIP(p_ServerParams[PARAMINDEX_IP]);
					ptrDetectedServer->setIPIsLoopback(true);
					ptrDetectedServer->setClientIP(p_ServerParams[PARAMINDEX_CLIENTIP]);
				}
			}
			if (ptrDetectedServer->getIpIsLoopback() == false) { //loopback is preferred
				if (p_IsIP4 == true) {
					//we prefer IP4 first
					boolIP6 = false;
					ptrDetectedServer->setIP(p_ServerParams[PARAMINDEX_IP]);
					ptrDetectedServer->setIPIsIP4(true);
					ptrDetectedServer->setClientIP(p_ServerParams[PARAMINDEX_CLIENTIP]);
				}
				else if (ptrDetectedServer->getIpIsIP4() == false){
					boolIP6 = true;
					//Check if p_ServerIP has a scope_id (zone index, network interface id) postfix, the scope_id postfix is added with "%" to the ip6-address
					//the scope_id is the index of the networkinterface which is used to bind the socket
					//if SAD is used, the client will send SAD-Request to the server and the server sends an answer to the client.
					//The server will set the client's ip-Address as he saw the client (with the scope_id of the server's environment
					//but on client side we need the scope_id of the client's environment for the client's ip6 address
					//--> replace the client's scope_id (set by the server) with the scope_id as the client saw the server with the the scope_id of the clients's environment
					size_t sizeFound;
					string stringScopeID;
					sizeFound = p_ServerParams[PARAMINDEX_IP].find("%");
					if (sizeFound != string::npos) {
						//the scope_id postfix of the server's ip6 address exists
						//--> change the scope_id of the client's ip6-address
						stringScopeID = p_ServerParams[PARAMINDEX_IP].substr(sizeFound, p_ServerParams[PARAMINDEX_IP].length() - sizeFound);
						
						sizeFound = p_ServerParams[PARAMINDEX_CLIENTIP].find("%");
						if (sizeFound != string::npos) {
							p_ServerParams[PARAMINDEX_CLIENTIP] = p_ServerParams[PARAMINDEX_CLIENTIP].substr(0, sizeFound);
						}
						p_ServerParams[PARAMINDEX_CLIENTIP] += stringScopeID;
					}
					ptrDetectedServer->setProjectName(p_ServerParams[PARAMINDEX_SERVERPROJECTNAME]);
					ptrDetectedServer->setIP(p_ServerParams[PARAMINDEX_IP]);
					ptrDetectedServer->setIPIsIP6(true);
					
					ptrDetectedServer->setClientIP(p_ServerParams[PARAMINDEX_CLIENTIP]);
				}
				
			}
			ptrDetectedServer->setName(p_ServerParams[PARAMINDEX_NAME]);
			ptrDetectedServer->setComputerName(p_ServerParams[PARAMINDEX_COMPUTERNAME]);
			ptrDetectedServer->setPort(p_ServerParams[PARAMINDEX_PORT]);		
			ptrDetectedServer->setAdditions(p_ServerParams[PARAMINDEX_ADDITIONS]);
			ptrDetectedServer->setProjectName(p_ServerParams[PARAMINDEX_SERVERPROJECTNAME]);

			s_DetectedServers[ptrDetectedServer->getID()] = ptrDetectedServer;
				
		}

	}
	/**
	 * Used by SAD_Client to remove a SPITServer - don't use this manually
	 * @param p_DetectedServer
	 */
void SAD_DetectedServer::removeDetectedServer(SAD_DetectedServer* p_DetectedServer) {
		SAD_DetectedServer* o_DetectedServer;
		{
			unique_lock<recursive_mutex> o_Lock(s_MutexDetectedServer);
			auto i = s_DetectedServers.find(p_DetectedServer->getID());
			if (i != s_DetectedServers.end()) {
				o_DetectedServer = i->second;
				i = s_DetectedServers.erase(i);
				delete o_DetectedServer;
			}
		}
	}
	
	/**
	 * Used by SAD_Client to clear all found SPITServers - don't use this manually
	 */
void SAD_DetectedServer::clearDetectedServers() {
		SAD_DetectedServer* ptrDetectedServer;
		{
			unique_lock<recursive_mutex> o_Lock(s_MutexDetectedServer);
			for (auto i = s_DetectedServers.begin(); i != s_DetectedServers.end(); i++) {
				ptrDetectedServer = i->second;
				i = s_DetectedServers.erase(i);
				delete ptrDetectedServer;
				if (i == s_DetectedServers.end()) {
					break;
				}
			}
		}
	}
