/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   WindowsSocket.h
 * Author: Hagi
 *
 * Created on 11. April 2019, 08:36
 */



#ifndef WINDOWSSOCKET_H
#define WINDOWSSOCKET_H

#include "_SPITMACROS.h"
#if defined(OS_WINDOWS)
#include "WindowsSocket.h"

#include <WinSock2.h>
#include <iphlpapi.h>
#include <ws2tcpip.h>
#include <thread>

#include "SPITSocket.h"

using namespace std;

class WindowsSocket : public SPITSocket{
public:
	WindowsSocket();
	virtual ~WindowsSocket();
private:
	SOCKET m_UDPSocketIP4;
	SOCKET m_UDPSocketIP6;
public:
	void getAdaptersInfo();
	string getBroadcastIP4(IPAddress* p_IPAdress);
	int setBroadcast(bool p_Broadcast);
	static int init();
	static int cleanUp();
	bool createSocket_UDP();
	int bindSocket(string p_ServerIP, string p_ClientIP, string p_ClientPort);
	int sendMessageTo(int p_InetFamily, string p_ServerIP, string p_ServerPort, const char* p_MessageBytes, int p_MessageLength);
	int receiveMessage(int p_InetFamily, char* p_Buffer, int p_BufferLength, string* p_ServerIP);
};
#endif

#endif /* WINDOWSSOCKET_H */

