/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * SPIT_Message contains all SPIT messages.
 * A SPIT_Message contains a Header and an OPPart.
 * 
 * File:   SPIT_Message.cpp
 * Author: Hagi
 * 
 * Created on 3. April 2019, 08:51
 */

#include "SPIT_Message.h"

SPIT_Message::SPIT_Message() {
	initMembers();
}
//---------- Receive ---------
SPIT_Message::SPIT_Message(char* p_MessageBytes, int p_MessageByteCount) {
	initMembers();
	m_MessageBytes = p_MessageBytes;
	if (m_MessageBytes == NULL) {
		m_MessageByteCount = 0;
		return;
	}
	m_MessageByteCount = p_MessageByteCount;
	if (parse() == NULL) {			
	}
}

SPIT_Message::~SPIT_Message() {
	delete m_OPPart;
	if (m_MessageBytesCreated && m_MessageBytes != NULL) {
		free(m_MessageBytes);
	}
}

void SPIT_Message::initMembers() {
	m_MessageBytes = NULL;
	m_MessageByteCount = 0;
	m_Header = NULL;
	m_OPPart = NULL;
	m_MessageBytesCreated = false;
}
	
	//Receive

SPIT_Message::OPPart* SPIT_Message::parse() {
	if (m_MessageBytes == NULL) return NULL;
		m_OPPart = NULL;
		m_MessageBytesCreated = false;
		//parse Header
		m_Header = new Header();
		if (m_Header->parse(m_MessageBytes, m_MessageByteCount) == false) {
			m_Header = NULL;
			m_OPPart = NULL;
			return NULL;
		}
		
		//parse OP
		switch (m_Header->getOPFlag()) {
			//Connection
			case SPIT_Message::Connect::OPFLAG: {
				m_OPPart = new Connect(m_Header);
			}
			break;
			case SPIT_Message::ConnectAnswer::OPFLAG: {
				m_OPPart = new ConnectAnswer(m_Header);
			}
				break;
			case Disconnect::OPFLAG: {
				m_OPPart = new Disconnect(m_Header);
			}
				break;
			case Watchdog::OPFLAG: {
				m_OPPart = new Watchdog(m_Header);
			}
				break;
			case WatchdogAnswer::OPFLAG: {
				m_OPPart = new WatchdogAnswer(m_Header);
			}
				break;
				
			//SPITProject
			case ReportSPITProject::OPFLAG: {
				m_OPPart = new ReportSPITProject(m_Header);
			}
				break;
			case CloseSPITProject::OPFLAG: {
				m_OPPart = new CloseSPITProject(m_Header);
			}
				break;
			case RequestProjectTransfer::OPFLAG: {
				m_OPPart = new RequestProjectTransfer(m_Header);
			}
				break;
			case StartProjectTransfer::OPFLAG: {
				m_OPPart = new StartProjectTransfer(m_Header);
			}
				break;
			case EndProjectTransfer::OPFLAG: {
				m_OPPart = new EndProjectTransfer(m_Header);
			}
				break;
				
			//SPITType
			case ReportSPITType::OPFLAG: {
				m_OPPart = new ReportSPITType(m_Header);
			}
				break;
			case RemoveSPITType::OPFLAG: {
				m_OPPart = new RemoveSPITType(m_Header);
			}
				break;
				
			//SPITObject
			case ReportSPITObject::OPFLAG: {
				m_OPPart = new ReportSPITObject(m_Header);
			}
				break;
			case RemoveSPITObject::OPFLAG: {
				m_OPPart = new RemoveSPITObject(m_Header);
			}
				break;
			//PlaySPITObjects
			case PlaySPITStart::OPFLAG: {
				m_OPPart = new PlaySPITStart(m_Header);				
			}
				break;
			case PlaySPITObject::OPFLAG: {
				m_OPPart = new PlaySPITObject(m_Header);
			}
				break;
			case PlaySPITEnd::OPFLAG: {
				m_OPPart = new PlaySPITEnd(m_Header);
			}
				break;
			case ReportPlayStatus::OPFLAG: {
				m_OPPart = new ReportPlayStatus(m_Header);
			}
				break;
			default:
				m_OPPart = NULL;
				break;
		}
		if (m_OPPart != NULL) {		
			if (m_OPPart->parse(m_MessageBytes, m_MessageByteCount) == false) {
				delete m_OPPart;
				m_Header = NULL;
				m_OPPart = NULL;
				return NULL;
			}		
		}
		return m_OPPart;
}

//---------- Send ----------
SPIT_Message::SPIT_Message(OPPart* p_OPPart) {
	initMembers();
	if (p_OPPart == NULL) return;
	m_OPPart = p_OPPart;
	m_Header = m_OPPart->getHeader();
	if (m_Header == NULL) {
		m_OPPart = NULL;
		return;
	}
}
bool SPIT_Message::fillBytes() {
	if (m_OPPart == NULL) return false;
	try {
		if (m_MessageBytes == NULL) m_MessageBytes = createByteArray(m_OPPart, &m_MessageByteCount);
		if (m_MessageBytes == NULL) return false;
		m_MessageBytesCreated = true;
		return m_OPPart->fillBytes(m_MessageBytes, m_MessageByteCount);
	}
	catch(...) {
		return false;
	}
	return true;
}
const char* SPIT_Message::getMessageBytes() {
	if (m_OPPart == NULL) return NULL;
	if (fillBytes() == false) return NULL;
	return m_MessageBytes;
}



//----------- Header -----------
	SPIT_Message::Header::~Header() {
	}
	SPIT_Message::Header::Header(const Header& orig) {
		initMembers();
		m_MessageNumber = orig.getMessageNumber();
		m_ServerID = orig.getServerID();
		m_ClientID = orig.getClientID();
	}
	//Receive
	SPIT_Message::Header::Header() {
		initMembers();
	}
	
	void SPIT_Message::Header::initMembers() {
		m_SPITID = &SPITID[0];
		m_SPITVersion = SPITVERSION;
		m_MessageNumber = 0;
		m_BytesCount = BYTESLENGTH;
		m_ServerID = "";
		m_ClientID = "";
	}
		
	bool SPIT_Message::Header::parse(char* p_MessageBytes, int p_MessageBytesLength) {
			if (p_MessageBytes == NULL) return false;
			string stringSPIT_ID;
			try {
				m_ParseOffset = 0;
				//SPIT ID
				stringSPIT_ID = getString(p_MessageBytes, p_MessageBytesLength, m_ParseOffset, 7);
				m_ParseOffset += 7;
				if (SPITID != stringSPIT_ID) return false;
				m_SPITVersion = getInt(p_MessageBytes, p_MessageBytesLength, m_ParseOffset);
				if (m_SPITVersion < 0) return false;
				m_ParseOffset += 4;
				m_MessageNumber = getByte(p_MessageBytes, p_MessageBytesLength, m_ParseOffset);
				m_ParseOffset += 1;
				m_BytesCount = getInt(p_MessageBytes, p_MessageBytesLength, m_ParseOffset);
				if (m_BytesCount < 0) return false;
				m_ParseOffset += 4;
				m_ServerID = getString(p_MessageBytes, p_MessageBytesLength, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_ClientID = getString(p_MessageBytes, p_MessageBytesLength, m_ParseOffset, 41);
				m_ParseOffset += 41;
				m_OPFlag = p_MessageBytes[m_ParseOffset] & 0xFF;
				m_ParseOffset += 1;
			}
			catch (...) {
				return false;
			}
			return true;			
	}
		
	//Send
	SPIT_Message::Header::Header(int p_SPITVersion, int p_OPFlag) {
		initMembers();
		m_SPITVersion = p_SPITVersion;
		m_OPFlag = p_OPFlag;
	}
		
	void SPIT_Message::Header::setMessageNumber(unsigned char p_MessageNumber) {
			m_MessageNumber = p_MessageNumber;
	}
		
	void SPIT_Message::Header::setServerID(string p_ID) {
		m_ServerID = p_ID;
	}
	void SPIT_Message::Header::setClientID(string p_ID) {
		m_ClientID = p_ID;
	}
	void SPIT_Message::Header::setOPFlag(int p_OPFlag) {
			m_OPFlag = p_OPFlag;
	}
	bool SPIT_Message::Header::fillBytes(char* p_Bytes, int p_ByteCount) {
		if (p_Bytes == NULL) return false;
		try {
			m_ParseOffset = 0;
			m_ParseOffset += setString(m_SPITID, p_Bytes, p_ByteCount, m_ParseOffset, 7);
			m_ParseOffset += setInt(SPITVERSION, p_Bytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setByte(m_MessageNumber, p_Bytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setInt(m_BytesCount, p_Bytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_ServerID, p_Bytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += setString(m_ClientID, p_Bytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += setByte(m_OPFlag, p_Bytes, p_ByteCount, m_ParseOffset);
		}
		catch (...) {
			return false;
		}
		return true;
	}

	
	
//----------- OPPart -----------
	SPIT_Message::OPPart::~OPPart() {
		if (m_Header != NULL) {
			delete m_Header;
		}
		m_Header = NULL;
	}
	void SPIT_Message::OPPart::initMembers() {
		m_Header = NULL;
		m_ParseOffset = 0;
		m_BytesCount = 0;
	}

	//Receive
	SPIT_Message::OPPart::OPPart(Header* p_Header, int p_OPFlag) {
		initMembers();
		m_Header = p_Header;
		if (m_Header != NULL) {
			m_ParseOffset = Header::BYTESLENGTH;
			m_Header->setOPFlag(p_OPFlag);
		}
	}
	void SPIT_Message::OPPart::setHeader(Header* p_Header) {
		m_Header = p_Header;
		if (m_Header != NULL) {
			m_ParseOffset = Header::BYTESLENGTH;
		}
	}
	
	//Send
	SPIT_Message::OPPart::OPPart() {
		initMembers();
	}
	
//--------------------------- Connection --------------------------------
	
	
//----------- Connect -----------
	SPIT_Message::Connect::~Connect(){
	}
/*	SPIT_Message::Connect::Connect(const Connect& orig) : OPPart(new Header(*orig.getHeader()), OPFLAG) {
		initMembers();
		if (orig.getHeader() == NULL) return;
		m_ClientComputerName = stringCopy(orig.getClientComputerName());
		m_ClientName = stringCopy(orig.getClientName());
		m_LoginName = stringCopy(orig.getLoginName());
		m_LoginPassword = stringCopy(orig.getLoginPassword());
		m_ServerIP = stringCopy(orig.getServerIP());
		m_ServerPort = orig.getServerPort();
	}
*/
	//Receive
	SPIT_Message::Connect::Connect(Header* p_Header) : OPPart(p_Header, OPFLAG){
		initMembers();
	}
	
	void SPIT_Message::Connect::initMembers() {
		m_ClientComputerName = "";
		m_ClientName = "";
		m_LoginName = "";
		m_LoginPassword = "";
		m_ServerIP = "";
		m_ServerPort = 0;
		m_BytesCount = BYTESLENGTH;
	}
	
	bool SPIT_Message::Connect::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_ClientComputerName = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_ClientName = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_LoginName = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_LoginPassword = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_ServerIP = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 40);
			m_ParseOffset += 40;
			m_ServerPort = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
	
	//Send
	SPIT_Message::Connect::Connect() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
	void SPIT_Message::Connect::setClientComputerName(string p_ComputerName) {
		m_ClientComputerName = p_ComputerName;
	}
	void SPIT_Message::Connect::setClientName(string p_ClientName) {
		m_ClientName = p_ClientName;
	}
	void SPIT_Message::Connect::setLoginName(string p_LoginName) {
		m_LoginName = p_LoginName;
	}
	void SPIT_Message::Connect::setLoginPassword(string p_LoginPassword) {
		m_LoginPassword = p_LoginPassword;
	}
	void SPIT_Message::Connect::setServerIP(string p_ServerIP) {
		m_ServerIP = p_ServerIP;
	}
	void SPIT_Message::Connect::setServerPort(int p_ServerPort) {
			if (p_ServerPort < 0 || p_ServerPort > 65535) p_ServerPort = 0;
			m_ServerPort = p_ServerPort;
		}
	bool SPIT_Message::Connect::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_ClientComputerName, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setString(m_ClientName, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setString(m_LoginName, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setString(m_LoginPassword, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setString(m_ServerIP, p_MessageBytes, p_ByteCount, m_ParseOffset, 40);
			m_ParseOffset += setInt(m_ServerPort, p_MessageBytes, p_ByteCount, m_ParseOffset);
		}
		catch (...) {
			return false;
		}		
		return true;
	}
	
//----------- ConnectAnswer -----------
	
	void SPIT_Message::ConnectAnswer::initMembers() {
		m_ServerComputerName = "";
		m_ServerName = "";
		m_Connected = false;
		m_BytesCount = BYTESLENGTH;
		m_StepTime = 40;
	}
	SPIT_Message::ConnectAnswer::~ConnectAnswer() {
	}
	SPIT_Message::ConnectAnswer::ConnectAnswer(const ConnectAnswer& orig) {
		
	}
	//Receive
	SPIT_Message::ConnectAnswer::ConnectAnswer(Header* p_Header) : OPPart(p_Header, OPFLAG) {
		initMembers();
	}
	bool SPIT_Message::ConnectAnswer::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_ServerComputerName = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_ServerName = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_StepTime = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_Connected = getBoolean(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;	
		}
		catch (...) {
			return false;
		}			
		return true;
	}
	
	//Send
	SPIT_Message::ConnectAnswer::ConnectAnswer() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
	void SPIT_Message::ConnectAnswer::setServerComputerName(string p_ServerComputerName) {
		m_ServerComputerName = p_ServerComputerName;
	}
	void SPIT_Message::ConnectAnswer::setServerName(string p_ServerName) {
		m_ServerName = p_ServerName;
	}
	void SPIT_Message::ConnectAnswer::setConnected(bool p_Connected) {
		m_Connected = p_Connected;
	}
	void SPIT_Message::ConnectAnswer::setStepTime(int p_StepTime_ms) {
		if (p_StepTime_ms < 0) p_StepTime_ms = 1;
		m_StepTime = p_StepTime_ms;
	}
	bool SPIT_Message::ConnectAnswer::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_ServerComputerName, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setString(m_ServerName, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setInt(m_StepTime, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setBoolean(m_Connected, p_MessageBytes, p_ByteCount, m_ParseOffset);
		}
		catch (...) {
			return false;
		}		
		return true;
	}
	
//----------- Disconnect -----------
	
	void SPIT_Message::Disconnect::initMembers() {
			m_BytesCount = BYTESLENGTH;
	}
	SPIT_Message::Disconnect::~Disconnect() {
	}
	//Receive
	SPIT_Message::Disconnect::Disconnect(Header* p_Header) : OPPart(p_Header, OPFLAG){
		initMembers();
	}
	bool SPIT_Message::Disconnect::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
		}
		catch (...) {
			return false;
		}
		return true;
	}
		
	// Send
	SPIT_Message::Disconnect::Disconnect() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
	}
				
	bool SPIT_Message::Disconnect::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
		}
		catch (...) {
			return false;
		}
		return true;
	}

	
//----------- Watchdog -----------
	void SPIT_Message::Watchdog::initMembers() {
		m_BytesCount = BYTESLENGTH;
	}
	SPIT_Message::Watchdog::~Watchdog() {
		
	}

	//Receive
	SPIT_Message::Watchdog::Watchdog(Header* p_Header) : OPPart(p_Header, OPFLAG) {
		initMembers();
	}		
	bool SPIT_Message::Watchdog::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
		}
		catch (...) {
			return false;
		}
		return true;
	}
				
		// Send
	SPIT_Message::Watchdog::Watchdog() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}
	bool SPIT_Message::Watchdog::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;	
		}
		catch (...) {
			return false;
		}
		return true;
	}
	
//----------- WatchdogAnswer -----------

	void SPIT_Message::WatchdogAnswer::initMembers() {
			m_BytesCount = BYTESLENGTH;
	}
	SPIT_Message::WatchdogAnswer::~WatchdogAnswer() {

	}

	//Receive
	SPIT_Message::WatchdogAnswer::WatchdogAnswer(Header* p_Header) : OPPart(p_Header, OPFLAG) {
		initMembers();
	}		
	bool SPIT_Message::WatchdogAnswer::parse(char* p_MessageBytes, int p_ByteCount) {
			if (p_MessageBytes == NULL) return false;
			if (m_Header == NULL) return false;
			int intOPFlag = m_Header->getOPFlag();
			if (intOPFlag != OPFLAG) return false;
			try {
				m_ParseOffset = Header::BYTESLENGTH;
				m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
				m_ParseOffset += 4;
			}
			catch (...) {
				return false;
			}
			return true;
		}
		
		
	// Send
	SPIT_Message::WatchdogAnswer::WatchdogAnswer() : OPPart(){
			initMembers();
			m_Header = new Header(SPITVERSION, OPFLAG);
			setHeader(m_Header);
			m_ParseOffset = Header::BYTESLENGTH;
		}
	bool SPIT_Message::WatchdogAnswer::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
		}
		catch (...) {
			return false;
		}
		return true;
	}
	
	
	
	
	
//--------------------------- SPITProject --------------------------------
	
//----------- ReportSPITProject -----------
	void SPIT_Message::ReportSPITProject::initMembers() {
		m_ProjectID = "";
		m_ProjectName = "";
		m_BytesCount = BYTESLENGTH;
		m_FramesPerSecond = 1000;
	}
	SPIT_Message::ReportSPITProject::~ReportSPITProject() {
	}
	//Receive
	SPIT_Message::ReportSPITProject::ReportSPITProject(Header* p_Header) : OPPart(p_Header, OPFLAG){
		initMembers();
	}		
	bool SPIT_Message::ReportSPITProject::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_ProjectID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
			m_ProjectName = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_FramesPerSecond = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
		// Send
	SPIT_Message::ReportSPITProject::ReportSPITProject() : OPPart(){
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
		
	void SPIT_Message::ReportSPITProject::setProjectID(string p_ProjectID) {
		m_ProjectID = p_ProjectID;
	}
	void SPIT_Message::ReportSPITProject::setProjectName(string p_ProjectName) {
		m_ProjectName = p_ProjectName;
	}
	void SPIT_Message::ReportSPITProject::setFramesPerSecond(const int p_FramesPerSecond) {
		m_FramesPerSecond = p_FramesPerSecond;
	}
	bool SPIT_Message::ReportSPITProject::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_ProjectID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += setString(m_ProjectName, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setInt(m_FramesPerSecond, p_MessageBytes, p_ByteCount, m_ParseOffset);
		}
		catch (...) {
			return false;
		}		
		return true;
	}

//----------- StartProjectTransfer -----------

	void SPIT_Message::CloseSPITProject::initMembers() {
		m_ProjectID = "";
		m_BytesCount = BYTESLENGTH;
	}
	SPIT_Message::CloseSPITProject::~CloseSPITProject() {
	}
		//Receive
	SPIT_Message::CloseSPITProject::CloseSPITProject(Header* p_Header) : OPPart(p_Header, OPFLAG) {
		initMembers();
	}
	bool SPIT_Message::CloseSPITProject::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount,  m_ParseOffset);
			m_ParseOffset += 4;
			m_ProjectID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
	// Send
	SPIT_Message::CloseSPITProject::CloseSPITProject() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
		
	void SPIT_Message::CloseSPITProject::setProjectID(string p_ProjectID) {
		m_ProjectID = p_ProjectID;
	}
	bool SPIT_Message::CloseSPITProject::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_ProjectID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
		}
		catch (...) {
			return false;
		}		
		return true;
	}

//----------- RequestProjectTransfer -----------
	
	void SPIT_Message::RequestProjectTransfer::initMembers() {
			m_BytesCount = BYTESLENGTH;
		}
	SPIT_Message::RequestProjectTransfer::~RequestProjectTransfer() {
		
	}
		//Receive
	SPIT_Message::RequestProjectTransfer::RequestProjectTransfer(Header* p_Header) : OPPart(p_Header, OPFLAG) {
		initMembers();
	}
	bool SPIT_Message::RequestProjectTransfer::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
	// Send
	SPIT_Message::RequestProjectTransfer::RequestProjectTransfer() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
	bool SPIT_Message::RequestProjectTransfer::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
		}
		catch (...) {
			return false;
		}		
		return true;
	}
	
//----------- StartProjectTransfer -----------
	
	void SPIT_Message::StartProjectTransfer::initMembers() {
		m_BytesCount = BYTESLENGTH;
	}
	SPIT_Message::StartProjectTransfer::~StartProjectTransfer() {
	}
		//Receive
	SPIT_Message::StartProjectTransfer::StartProjectTransfer(Header* p_Header) : OPPart(p_Header, OPFLAG){
		initMembers();
	}
	bool SPIT_Message::StartProjectTransfer::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
		// Send
	SPIT_Message::StartProjectTransfer::StartProjectTransfer() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
		
	bool SPIT_Message::StartProjectTransfer::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
		}
		catch (...) {
			return false;
		}		
		return true;
	}

//----------- ENdProjectTransfer -----------
	
	void SPIT_Message::EndProjectTransfer::initMembers() {
		m_BytesCount = BYTESLENGTH;
	}
	SPIT_Message::EndProjectTransfer::~EndProjectTransfer() {
		
	}
		//Receive
	SPIT_Message::EndProjectTransfer::EndProjectTransfer(Header* p_Header) : OPPart(p_Header, OPFLAG){
		initMembers();
	}
	bool SPIT_Message::EndProjectTransfer::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
		// Send
	SPIT_Message::EndProjectTransfer::EndProjectTransfer() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
	bool SPIT_Message::EndProjectTransfer::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
		}
		catch (...) {
			return false;
		}		
		return true;
	}

	
	
	
	
	
//--------------------------- SPITType ---------------------------------

	//----------- ReportSPITType -----------
	
	void SPIT_Message::ReportSPITType::initMembers() {
		m_Confirmed = false;
		m_SPITTypeID = "";
		m_Fixed = false;
		m_ServerRemote = false;
		m_ServerProjectIndepended = false;
		m_SPITTypeGroupName = "";
		m_SPITTypeName = "";
		m_Delay = 0;
		m_Duration = 0;
		m_BytesCount = BYTESLENGTH;
	}
	SPIT_Message::ReportSPITType::~ReportSPITType() {
	}
		//Receive
	SPIT_Message::ReportSPITType::ReportSPITType(Header* p_Header) : OPPart(p_Header, OPFLAG) {
		initMembers();
	}
	bool SPIT_Message::ReportSPITType::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_Confirmed = getBoolean(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
			m_SPITTypeID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
			m_Fixed = getBoolean(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
			m_ServerRemote = getBoolean(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
			m_ServerProjectIndepended = getBoolean(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
			m_SPITTypeGroupName = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 39);
			m_ParseOffset += 39;
			m_SPITTypeName = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_Delay = getLong(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 8;
			m_Duration = getLong(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 8;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
	// Send
	SPIT_Message::ReportSPITType::ReportSPITType() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
		
	void SPIT_Message::ReportSPITType::setConfirmed(bool p_Confirmed) {
		m_Confirmed = p_Confirmed;
	}
	void SPIT_Message::ReportSPITType::setID(string p_ID) {
		m_SPITTypeID = p_ID;
	}
	void SPIT_Message::ReportSPITType::setFixed(bool p_Fixed) {
		m_Fixed = p_Fixed;
	}
	void SPIT_Message::ReportSPITType::setServerRemote(bool p_IsServerRemote) {
		m_ServerRemote = p_IsServerRemote;
	}
	void SPIT_Message::ReportSPITType::setServerProjectIndepended(bool p_ProjectIndpended) {
		m_ServerProjectIndepended = p_ProjectIndpended;
	}
	void SPIT_Message::ReportSPITType::setGroupName(string p_GroupName) {
		m_SPITTypeGroupName = p_GroupName;
	}
	void SPIT_Message::ReportSPITType::setName(string p_Name) {
		m_SPITTypeName = p_Name;
	}
	void SPIT_Message::ReportSPITType::setDelay(long long p_Delay) {
		m_Delay = p_Delay;
	}
	void SPIT_Message::ReportSPITType::setDuration(long long p_Duration) {
		m_Duration = p_Duration;
	}
	bool SPIT_Message::ReportSPITType::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = m_Header->BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setBoolean(m_Confirmed, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_SPITTypeID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += setBoolean(m_Fixed, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setBoolean(m_ServerRemote, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setBoolean(m_ServerProjectIndepended, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_SPITTypeGroupName, p_MessageBytes, p_ByteCount, m_ParseOffset, 39);
			m_ParseOffset += setString(m_SPITTypeName, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setLong(m_Delay, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setLong(m_Duration, p_MessageBytes, p_ByteCount, m_ParseOffset);
		}
		catch (...) {
			return false;
		}		
		return true;
	}

	
//----------- ReportSPITType -----------
	
	void SPIT_Message::RemoveSPITType::initMembers() {
		m_SPITTypeID = "";
		m_BytesCount = BYTESLENGTH;
	}
	SPIT_Message::RemoveSPITType::~RemoveSPITType() {
	}
		//Receive
	SPIT_Message::RemoveSPITType::RemoveSPITType(Header* p_Header) : OPPart(p_Header, OPFLAG){
		initMembers();
	}
	bool SPIT_Message::RemoveSPITType::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_SPITTypeID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
		// Send
	SPIT_Message::RemoveSPITType::RemoveSPITType() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
		
	void SPIT_Message::RemoveSPITType::setID(string p_ID) {
		m_SPITTypeID = p_ID;
	}
	bool SPIT_Message::RemoveSPITType::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_SPITTypeID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
		}
		catch (...) {
			return false;
		}		
		return true;
	}

	
//---------------------------- SPITObjects ----------------------------------
	
//----------- ReportSPITObject -----------
	void SPIT_Message::ReportSPITObject::initMembers() {
		m_Confirmed = false;
		m_SPITObjectID = "";
		m_Fixed = false;
		m_ServerRemote = false;
		m_SPITObjectName = "";
		m_SPITTypeID = "";
		m_ServerParams = "";
		m_FrameStart = 0;
		m_FrameLength = 0;
		m_FrameFadeInLength = 0;
		m_FrameFadeOutLength = 0;
		m_ValueFactor = 0;
		m_ValueUse = VALUEUSE_DISCARD;
		m_Track = 0;
		m_Remark = "";
		m_Delay = 0;
		m_Duration = 0;
		m_ActionAssigned = false;
		m_BytesCount = BYTESLENGTH;
	}
	SPIT_Message::ReportSPITObject::~ReportSPITObject() {
	}
	//Receive
	SPIT_Message::ReportSPITObject::ReportSPITObject(Header* p_Header) : OPPart(p_Header, OPFLAG) {
		initMembers();
	}
	bool SPIT_Message::ReportSPITObject::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_Confirmed = getBoolean(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
			m_SPITObjectID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
			m_Fixed = getBoolean(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
			m_ServerRemote = getBoolean(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
			m_SPITObjectName = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_SPITTypeID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
			m_ServerParams = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_FrameStart = getLong(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 8;
			m_FrameLength = getLong(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 8;
			m_FrameFadeInLength = getLong(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 8;
			m_FrameFadeOutLength = getLong(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 8;
			m_ValueFactor = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_ValueUse = getByte(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
			m_Track = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_Remark = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_Delay = getLong(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 8;
			m_Duration = getLong(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 8;
			m_ActionAssigned = getBoolean(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
		// Send
	SPIT_Message::ReportSPITObject::ReportSPITObject() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
		
	void SPIT_Message::ReportSPITObject::setConfirmed(bool p_Confirmed) {
		m_Confirmed = p_Confirmed;
	}
	void SPIT_Message::ReportSPITObject::setID(string p_ID) {
		m_SPITObjectID = p_ID;
	}
	void SPIT_Message::ReportSPITObject::setFixed(bool p_Fixed) {
			m_Fixed = p_Fixed;
		}
	void SPIT_Message::ReportSPITObject::setServerRemote(bool p_IsRemote) {
			m_ServerRemote = p_IsRemote;
		}
	void SPIT_Message::ReportSPITObject::setName(string p_Name) {
		m_SPITObjectName = p_Name;
	}
	void SPIT_Message::ReportSPITObject::setSPITTypeID(string p_ID) {
		m_SPITTypeID = p_ID;
	}
	void SPIT_Message::ReportSPITObject::setServerParams(string p_Parameters) {
		m_ServerParams = p_Parameters;
	}
	void SPIT_Message::ReportSPITObject::setFrameStart(long long p_StartTime) {
		m_FrameStart = p_StartTime;
	}
	void SPIT_Message::ReportSPITObject::setFrameLength(long long p_Length) {
		m_FrameLength = p_Length;
	}
	void SPIT_Message::ReportSPITObject::setFrameFadeInLength(long long p_FadeInTime) {
		m_FrameFadeInLength = p_FadeInTime;
	}
	void SPIT_Message::ReportSPITObject::setFrameFadeOutLength(long long p_FadeOutTime) {
		m_FrameFadeOutLength = p_FadeOutTime;
	}
	void SPIT_Message::ReportSPITObject::setValueFactor(int p_Volume) {
		m_ValueFactor = p_Volume;
	}
	void SPIT_Message::ReportSPITObject::setValueUse(char p_ValueUse) {
		m_ValueUse = p_ValueUse;
	}
	void SPIT_Message::ReportSPITObject::setTrack(int p_Track) {
		m_Track = p_Track;
	}
	void SPIT_Message::ReportSPITObject::setRemark(string p_Description) {
		m_Remark = p_Description;
	}
	void SPIT_Message::ReportSPITObject::setDelay(long long p_Delay) {
		if (p_Delay < 0) p_Delay = 0;
		m_Delay = p_Delay;
	}
	void SPIT_Message::ReportSPITObject::setDuration(long long p_Duration) {
		if (p_Duration < 0) p_Duration = 0;
		m_Duration = p_Duration;
	}
		
	void SPIT_Message::ReportSPITObject::setActionAssigned(bool p_ActionAssigned) {
			m_ActionAssigned = p_ActionAssigned;
		}
	bool SPIT_Message::ReportSPITObject::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setBoolean(m_Confirmed, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_SPITObjectID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += setBoolean(m_Fixed, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setBoolean(m_ServerRemote, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_SPITObjectName, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setString(m_SPITTypeID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += setString(m_ServerParams, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setLong(m_FrameStart, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setLong(m_FrameLength, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setLong(m_FrameFadeInLength, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setLong(m_FrameFadeOutLength, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setInt(m_ValueFactor, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setByte(m_ValueUse, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setInt(m_Track, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_Remark, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setLong(m_Delay, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setLong(m_Duration, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setBoolean(m_ActionAssigned, p_MessageBytes, p_ByteCount, m_ParseOffset);
		}
		catch (...) {
			return false;
		}		
		return true;
	}

//----------- RemoveSPITObject -----------
	void SPIT_Message::RemoveSPITObject::initMembers() {
		m_SPITObjectID = "";
		m_BytesCount = BYTESLENGTH;
	}
	SPIT_Message::RemoveSPITObject::~RemoveSPITObject() {
	}
	//Receive
	SPIT_Message::RemoveSPITObject::RemoveSPITObject(Header* p_Header) : OPPart(p_Header, OPFLAG) {
		initMembers();
	}
	bool SPIT_Message::RemoveSPITObject::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_SPITObjectID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
		
	// Send
	SPIT_Message::RemoveSPITObject::RemoveSPITObject() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
		
	void SPIT_Message::RemoveSPITObject::setID(string p_ID) {
		m_SPITObjectID = p_ID;
	}
	bool SPIT_Message::RemoveSPITObject::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_SPITObjectID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
		}
		catch (...) {
			return false;
		}		
		return true;
	}
	
//---------------------------- SPITPlayer ----------------------------------
	
//----------- PlaySPITStart -----------
	void SPIT_Message::PlaySPITStart::initMembers() {
			m_PlayerID = "";
			m_PlayerName = "";
			m_PlayerType = 0x00;
			m_Time = 0;
			m_PlayerIsRunning = false;
			m_BytesCount = BYTESLENGTH;
		}
	SPIT_Message::PlaySPITStart::~PlaySPITStart() {
	}
		//Receive
	SPIT_Message::PlaySPITStart::PlaySPITStart(Header* p_Header) : OPPart(p_Header, OPFLAG){
		initMembers();
	}
	bool SPIT_Message::PlaySPITStart::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_PlayerID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
			m_PlayerName = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += 64;
			m_PlayerType = getByte(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
			m_PlayerIsRunning = getBoolean(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
			m_Time = getLong(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset+= 8;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
		
	// Send
	SPIT_Message::PlaySPITStart::PlaySPITStart() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
		
	void SPIT_Message::PlaySPITStart::setPlayerID(string p_PlayerID) {
		m_PlayerID = p_PlayerID;
	}
	void SPIT_Message::PlaySPITStart::setPlayerName(string p_PlayerName) {
		m_PlayerName = p_PlayerName;
	}
	void SPIT_Message::PlaySPITStart::setPlayerType(char p_PlayerType) {
		m_PlayerType = p_PlayerType;
	}
	void SPIT_Message::PlaySPITStart::setPlayerIsRunning(bool p_IsPlaying) {
		m_PlayerIsRunning = p_IsPlaying;
	}
	void SPIT_Message::PlaySPITStart::setTime(long long p_Time) {
		m_Time = p_Time;
	}
	bool SPIT_Message::PlaySPITStart::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_PlayerID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += setString(m_PlayerName, p_MessageBytes, p_ByteCount, m_ParseOffset, 64);
			m_ParseOffset += setByte(m_PlayerType, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setBoolean(m_PlayerIsRunning, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setLong(m_Time, p_MessageBytes, p_ByteCount, m_ParseOffset);
		}
		catch (...) {
			return false;
		}		
		return true;
	}
	
//----------- PlaySPITObject -----------

	void SPIT_Message::PlaySPITObject::initMembers() {
			m_PlayerID = "";
			m_SPITObjectID = "";
			m_FrameInsideObject = 0;
			m_Value = 0;
			m_ValueFlag = VALUEFLAG_DIRECT;
			m_BytesCount = BYTESLENGTH;
		}
	SPIT_Message::PlaySPITObject::~PlaySPITObject() {
	}
		//Receive
	SPIT_Message::PlaySPITObject::PlaySPITObject(Header* p_Header) : OPPart(p_Header, OPFLAG){
		initMembers();
	}
	bool SPIT_Message::PlaySPITObject::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_PlayerID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
			m_SPITObjectID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
			m_FrameInsideObject = getLong(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 8;
			m_PlayPrePosition = getBoolean(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
			m_Value = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_ValueFlag = getByte(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 1;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
	// Send
	SPIT_Message::PlaySPITObject::PlaySPITObject() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
	void SPIT_Message::PlaySPITObject::setPlayerID(string p_PlayerID) {
		m_PlayerID = p_PlayerID;
	}
	void SPIT_Message::PlaySPITObject::setID(string p_ID) {
		m_SPITObjectID = p_ID;
	}
	void SPIT_Message::PlaySPITObject::setFrameInsideObject(long long p_TimeInside) {
		m_FrameInsideObject = p_TimeInside;
	}
	void SPIT_Message::PlaySPITObject::setPlayPrePosition(bool p_PlayOldPosition) {
		m_PlayPrePosition = p_PlayOldPosition;
	}
	void SPIT_Message::PlaySPITObject::setValue(int p_Value) {
		m_Value = p_Value;
	}
	void SPIT_Message::PlaySPITObject::setValueFlag(char p_ValueFlag) {
		m_ValueFlag = p_ValueFlag;
	}
	bool SPIT_Message::PlaySPITObject::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_PlayerID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += setString(m_SPITObjectID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += setLong(m_FrameInsideObject, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setBoolean(m_PlayPrePosition, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setInt(m_Value, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setByte(m_ValueFlag, p_MessageBytes, p_ByteCount, m_ParseOffset);
		}
		catch (...) {
			return false;
		}		
		return true;
	}
	
//----------- PlaySPITEnd -----------

	void SPIT_Message::PlaySPITEnd::initMembers() {
			m_PlayerID = "";
			m_BytesCount = BYTESLENGTH;
		}
	SPIT_Message::PlaySPITEnd::~PlaySPITEnd() {
	}
		//Receive
	SPIT_Message::PlaySPITEnd::PlaySPITEnd(Header* p_Header) : OPPart(p_Header, OPFLAG){
		initMembers();
	}
	bool SPIT_Message::PlaySPITEnd::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_PlayerID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
		// Send
	SPIT_Message::PlaySPITEnd::PlaySPITEnd() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
		
	void SPIT_Message::PlaySPITEnd::setPlayerID(string p_PlayerID) {
		m_PlayerID = p_PlayerID;
	}
	bool SPIT_Message::PlaySPITEnd::fillBytes(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += setString(m_PlayerID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
		}
		catch (...) {
			return false;
		}		
		return true;
	}

//----------- ReportPlayStatus -----------
	
	void SPIT_Message::ReportPlayStatus::initMembers() {
			m_SPITObjectID = "";
			m_FrameInsideObject = 0;
			m_Value = 0;
			m_BytesCount = BYTESLENGTH;
		}
	SPIT_Message::ReportPlayStatus::~ReportPlayStatus() {
	}
	//Receive
	SPIT_Message::ReportPlayStatus::ReportPlayStatus(Header* p_Header) : OPPart(p_Header, OPFLAG){
		initMembers();
	}
	bool SPIT_Message::ReportPlayStatus::parse(char* p_MessageBytes, int p_ByteCount) {
		if (p_MessageBytes == NULL) return false;
		if (m_Header == NULL) return false;
		int intOPFlag = m_Header->getOPFlag();
		if (intOPFlag != OPFLAG) return false;
		try {
			m_ParseOffset = Header::BYTESLENGTH;
			m_BytesCount = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
			m_SPITObjectID = getString(p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
			m_ParseOffset += 41;
			m_FrameInsideObject = getLong(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 8;
			m_Value = getInt(p_MessageBytes, p_ByteCount, m_ParseOffset);
			m_ParseOffset += 4;
		}
		catch (...) {
			return false;
		}			
		return true;
	}
	// Send
	SPIT_Message::ReportPlayStatus::ReportPlayStatus() : OPPart() {
		initMembers();
		m_Header = new Header(SPITVERSION, OPFLAG);
		setHeader(m_Header);
		m_ParseOffset = Header::BYTESLENGTH;
	}	
		
	void SPIT_Message::ReportPlayStatus::setID(string p_ID) {
		m_SPITObjectID = p_ID;
	}
	void SPIT_Message::ReportPlayStatus::setFrameInsideObject(long long p_TimeInside) {
		m_FrameInsideObject = p_TimeInside;
	}
	void SPIT_Message::ReportPlayStatus::setValue(int p_Value) {
		m_Value = p_Value;
	}
	bool SPIT_Message::ReportPlayStatus::fillBytes(char* p_MessageBytes, int p_ByteCount) {
			if (p_MessageBytes == NULL) return false;
			if (m_Header == NULL) return false;
			if (m_Header->fillBytes(p_MessageBytes, p_ByteCount) == false) return false;
			try {
				m_ParseOffset = Header::BYTESLENGTH;
				m_ParseOffset += setInt(m_BytesCount, p_MessageBytes, p_ByteCount, m_ParseOffset);
				m_ParseOffset += setString(m_SPITObjectID, p_MessageBytes, p_ByteCount, m_ParseOffset, 41);
				m_ParseOffset += setLong(m_FrameInsideObject, p_MessageBytes, p_ByteCount, m_ParseOffset);
				m_ParseOffset += setInt(m_Value, p_MessageBytes, p_ByteCount, m_ParseOffset);
			}
			catch (...) {
				return false;
			}		
			return true;
		}
	
	
//---------------------------- static helper functions -----------------------
	bool SPIT_Message::isSystemLittleEndian() {
		int		intOne = 1;
		char*	firstByte;
		firstByte = (char*)&intOne;
//		firstByte = intOne & 0xff000000;
		if (firstByte > 0) return false;
		else return true;
	} 
	int SPIT_Message::getInt(char* p_Bytes, int p_ByteCount, int p_Offset) {
		if (p_Offset < 0) {
			throw "ParseError_received";
		}
		if (p_Bytes == NULL || p_ByteCount < p_Offset + 4) {
			throw "ParseError_received";
		}
		//low byte first
		int intValue = 0;
		if (isSystemLittleEndian() == false) {
			intValue += ((p_Bytes[p_Offset+0] & 0x000000ff));
			intValue += ((p_Bytes[p_Offset+1] & 0x000000ff)<<8);
			intValue += ((p_Bytes[p_Offset+2] & 0x000000ff)<<16);
			intValue += ((p_Bytes[p_Offset+3] & 0x000000ff)<<24);
		}
		else {
			intValue += ((p_Bytes[p_Offset+3] & 0x000000ff));
			intValue += ((p_Bytes[p_Offset+2] & 0x000000ff)<<8);
			intValue += ((p_Bytes[p_Offset+1] & 0x000000ff)<<16);
			intValue += ((p_Bytes[p_Offset+0] & 0x000000ff)<<24);
		}
		return intValue;
	}

	int SPIT_Message::setInt(int p_Value, char* p_Bytes, int p_ByteCount, int p_Offset) {
		if (p_Offset < 0) {
			throw "ParseError_send";
		}
		if (p_Bytes == NULL || p_ByteCount < p_Offset + 4) {
			throw "ParseError_send";
		}
		//low byte first
		int intTest;
		if (isSystemLittleEndian() == false) {
			p_Bytes[p_Offset+0] = (char)(p_Value & 0x000000ff);
			p_Bytes[p_Offset+1] = (char)((p_Value & 0x0000ff00)>>8);
			p_Bytes[p_Offset+2] = (char)((p_Value & 0x00ff0000)>>16);
			p_Bytes[p_Offset+3] = (char)((p_Value & 0xff000000)>>24);
			
			intTest = getInt(p_Bytes, p_ByteCount, p_Offset);
		}
		else {
			p_Bytes[p_Offset+3] = (char)(p_Value & 0x000000ff);
			p_Bytes[p_Offset+2] = (char)((p_Value & 0x0000ff00)>>8);
			p_Bytes[p_Offset+1] = (char)((p_Value & 0x00ff0000)>>16);
			p_Bytes[p_Offset+0] = (char)((p_Value & 0xff000000)>>24);

			intTest = getInt(p_Bytes, p_ByteCount, p_Offset);
		}
		return 4;
	}
	long long SPIT_Message::getLong(char* p_Bytes, int p_ByteCount, int p_Offset) {
		if (p_Offset < 0) {
			throw "ParseError_received";
		}
		if (p_Bytes == NULL || p_ByteCount < p_Offset + 8) {
			throw "ParseError_received";
		}
		//low byte first
		long long intValue = 0;
		if (isSystemLittleEndian() == false) {
			intValue += ((long long)(p_Bytes[p_Offset] & 0x000000ff));
			intValue += ((long long)(p_Bytes[p_Offset+1] & 0x000000ff)<<8);
			intValue += ((long long)(p_Bytes[p_Offset+2] & 0x000000ff)<<16);
			intValue += ((long long)(p_Bytes[p_Offset+3] & 0x000000ff)<<24);
			intValue += ((long long)(p_Bytes[p_Offset+4] & 0x000000ff)<<32);
			intValue += ((long long)(p_Bytes[p_Offset+5] & 0x000000ff)<<40);
			intValue += ((long long)(p_Bytes[p_Offset+6] & 0x000000ff)<<48);
			intValue += ((long long)(p_Bytes[p_Offset+7] & 0x000000ff)<<56);
		}
		else {
			intValue += ((long long)(p_Bytes[p_Offset+7] & 0x000000ff));
			intValue += ((long long)(p_Bytes[p_Offset+6] & 0x000000ff)<<8);
			intValue += ((long long)(p_Bytes[p_Offset+5] & 0x000000ff)<<16);
			intValue += ((long long)(p_Bytes[p_Offset+4] & 0x000000ff)<<24);
			intValue += ((long long)(p_Bytes[p_Offset+3] & 0x000000ff)<<32);
			intValue += ((long long)(p_Bytes[p_Offset+2] & 0x000000ff)<<40);
			intValue += ((long long)(p_Bytes[p_Offset+1] & 0x000000ff)<<48);
			intValue += ((long long)(p_Bytes[p_Offset+0] & 0x000000ff)<<56);			
		}
		return intValue;
	}
	int SPIT_Message::setLong(long long p_Value, char* p_Bytes, int p_ByteCount, int p_Offset) {
		if (p_Offset < 0) {
			throw "ParseError_send";
		}
		if (p_Bytes == NULL || p_ByteCount < p_Offset + 8) {
			throw "ParseError_send";
		}
		//low byte first
		if (isSystemLittleEndian() == false) {
			p_Bytes[p_Offset+0] = (char)((p_Value & 0x00000000000000ff));
			p_Bytes[p_Offset+1] = (char)((p_Value & 0x000000000000ff00)>>8);
			p_Bytes[p_Offset+2] = (char)((p_Value & 0x0000000000ff0000)>>16);
			p_Bytes[p_Offset+3] = (char)((p_Value & 0x00000000ff000000)>>24);
			p_Bytes[p_Offset+4] = (char)((p_Value & 0x000000ff00000000)>>32);
			p_Bytes[p_Offset+5] = (char)((p_Value & 0x0000ff0000000000)>>40);
			p_Bytes[p_Offset+6] = (char)((p_Value & 0x00ff000000000000)>>48);
			p_Bytes[p_Offset+7] = (char)((p_Value & 0xff00000000000000)>>56);
		}
		else {
			p_Bytes[p_Offset+7] = (char)((p_Value & 0x00000000000000ff));
			p_Bytes[p_Offset+6] = (char)((p_Value & 0x000000000000ff00)>>8);
			p_Bytes[p_Offset+5] = (char)((p_Value & 0x0000000000ff0000)>>16);
			p_Bytes[p_Offset+4] = (char)((p_Value & 0x00000000ff000000)>>24);
			p_Bytes[p_Offset+3] = (char)((p_Value & 0x000000ff00000000)>>32);
			p_Bytes[p_Offset+2] = (char)((p_Value & 0x0000ff0000000000)>>40);
			p_Bytes[p_Offset+1] = (char)((p_Value & 0x00ff000000000000)>>48);
			p_Bytes[p_Offset+0] = (char)((p_Value & 0xff00000000000000)>>56);
		}
		return 8;
	}
	bool SPIT_Message::getBoolean(char* p_Bytes, int p_ByteCount, int p_Offset) {
		if (p_Offset < 0) {
			throw "ParseError_received";
		}
		if (p_Bytes == NULL || p_ByteCount < p_Offset + 1) {
			throw "ParseError_received";
		}
		//low byte first
		if (p_Bytes[p_Offset] > 0x00) return true;
		else return false;
	}
	int SPIT_Message::setBoolean(bool p_Value, char* p_Bytes, int p_ByteCount, int p_Offset) {
		if (p_Offset < 0) {
			throw "ParseError_send";
		}
		if (p_Bytes == NULL || p_ByteCount < p_Offset + 1) {
			throw "ParseError_send";
		}
		if (p_Value == false) {
			p_Bytes[p_Offset] = 0x00;
		}
		else {
			p_Bytes[p_Offset] = 0x01;
		}
		return 1;
	}
	char SPIT_Message::getByte(char* p_Bytes, int p_ByteCount, int p_Offset) {
		if (p_Offset < 0) {
			throw "ParseError_received";
		}
		if (p_Bytes == NULL || p_ByteCount < p_Offset + 1) {
			throw "ParseError_received";
		}
		//low byte first
		return p_Bytes[p_Offset];
	}
	int SPIT_Message::setByte(int p_Value, char* p_Bytes, int p_ByteCount, int p_Offset) {
		if (p_Offset < 0) {
			throw "ParseError_send";
		}
		if (p_Bytes == NULL || p_ByteCount < p_Offset + 1) {
			throw "ParseError_send";
		}
		p_Bytes[p_Offset] = (char)(p_Value & 0xff);
		return 1;
	}
	string SPIT_Message::getString(char* p_Bytes, int p_ByteCount, int p_Offset, int p_Length) {
		if (p_Offset < 0) {
			throw "ParseError_received getString()";
		}
		if (p_Bytes == NULL || p_ByteCount < p_Offset + p_Length) {
			throw "ParseError_received getString()";
		}
		int intPos;
		//get Length of String
		for (intPos = 0; intPos < p_Length; intPos++) {
			if (p_Bytes[p_Offset + intPos] == 0x00) break;
		}
		if (intPos >= p_Length) {
			throw "ParseError_received getString()";
		}
		string stringResult;
		stringResult = &p_Bytes[p_Offset];
		return stringResult;
	}
	
	int SPIT_Message::setString(string p_String, char* p_Bytes, int p_ByteCount, int p_Offset, int p_Length) {
		if (p_Offset < 0) {
			throw "ParseError_send";
		}
		int intChar = 0;
		bool boolNullChar = false;
		if (p_Length < 1) {
			throw "ParseError_send";
		}
		if (p_Bytes == NULL || p_ByteCount < p_Offset + p_Length) {
			throw "ParseError_send";
		}
		
		int intLength;
		if ((int)p_String.length()+1 > p_Length) {
			intLength = p_Length;
		}
		else {
			intLength = p_String.length()+1;
		}
		while(intChar < intLength) {
			p_Bytes[p_Offset + intChar] = p_String.data()[intChar];
			if (p_String[intChar] == nullChar[0]) {
				boolNullChar = true;
				break;
			}
			intChar++;
		}
		if (boolNullChar == false) {
			p_Bytes[p_Offset + intLength -1] = nullChar[0];
		}
		return p_Length;
	}
	
	
	
	char* SPIT_Message::createByteArray(const OPPart* p_OPPart, int* p_ByteCount) {
		if (p_OPPart == NULL) return NULL;
		int intBytesCount = 0;
		char* o_ByteArray;
		try {
			intBytesCount = Header::BYTESLENGTH;
			intBytesCount += p_OPPart->getBytesCount();
			o_ByteArray = (char*) malloc(intBytesCount);
			*p_ByteCount = intBytesCount;
		}
		catch (...) {
			return NULL;
		}
		return o_ByteArray;
	}
