/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   SPIT_Handler.h
 * Author: Hagi
 *
 * Created on 24. April 2019, 11:17
 */

#ifndef SPIT_HANDLER_H
#define SPIT_HANDLER_H

#include <mutex>
#include <condition_variable>
#include <thread>
#include <list>

using namespace std;

class SPIT_Handler {
public:
	class Runnable {
	public:
		Runnable() {};
		virtual ~Runnable();
		virtual void run() = 0;
	};

private:
	static list<Runnable*>			s_Runnables;
	static mutex					s_MutexLock;
	static condition_variable		s_ConditionVariable;
	static thread					s_HandlerThread;

	static bool						s_WakeUp;
	static bool						s_Close;
	static void run();
public:
	static void addRunnable(Runnable* p_Runnable);
	static void closeHandler();
};

#endif /* SPIT_HANDLER_H */

