/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * SPITHandler lists runnable instances and processes them in order.
 * File:   SPIT_Handler.cpp
 * Author: Hagi
 * 
 * Created on 24. April 2019, 11:18
 */

#include "SPIT_Handler.h"


mutex SPIT_Handler::s_MutexLock;
condition_variable SPIT_Handler::s_ConditionVariable;
list<SPIT_Handler::Runnable*> SPIT_Handler::s_Runnables;
bool SPIT_Handler::s_WakeUp = false;
bool SPIT_Handler::s_Close = false;
thread SPIT_Handler::s_HandlerThread(SPIT_Handler::run);
SPIT_Handler::Runnable::~Runnable() {}


void SPIT_Handler::addRunnable(Runnable* p_Runnable) {
	if (p_Runnable == NULL) return;
	{
		unique_lock<mutex> o_Unique_Lock(s_MutexLock);
		if (s_Close == true) return;
		s_Runnables.push_back(p_Runnable);
		s_WakeUp = true;
	}
	if (this_thread::get_id() != s_HandlerThread.get_id()) {
		s_ConditionVariable.notify_one();
	}
}

void SPIT_Handler::closeHandler() {
	if (s_Close == true) return;
	{
		unique_lock<mutex> o_Unique_Lock(s_MutexLock);
		if (s_Close == true) return;

		s_Close = true;
		s_WakeUp = true;
	}
	if (this_thread::get_id() != s_HandlerThread.get_id()) {
		s_ConditionVariable.notify_one();
		s_HandlerThread.join();
	}
}
void SPIT_Handler::run() {
	Runnable* o_Runnable;
	bool boolWait = false;
	while (s_Close == false) {
		boolWait = false;	
		{
			unique_lock<mutex> o_Lock(s_MutexLock);
			
			if (s_Runnables.empty()) {
				s_ConditionVariable.wait(o_Lock, []{return s_WakeUp;});
			}
			if (s_Close == true) {
				s_WakeUp = true;
				return;;
			}
			
			s_WakeUp = false;

			if (s_Runnables.empty()) {
				o_Lock.unlock();
				continue;
			}
			else {
				o_Runnable = s_Runnables.front();
				s_Runnables.erase(s_Runnables.begin());
			}
		}
		
		if (o_Runnable != NULL) {
			try {
				o_Runnable->run();
				delete o_Runnable;
			}
			catch(...) {
#if defined(DEBUGOUTPUT)
				printf("ERROR SPITHandler o_Runable->run()\n");
#endif
			}
		}
	}
}
