/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * SPITSocket is the base class for WindowsSocket, UnixSocket,..<br>
 * Used by SPIT_Client and SAD_Client.
 * File:   SPITSocket.h
 * Author: Hagi
 *
 * Created on 12. April 2019, 15:40
 */

#ifndef SPITSOCKET_H
#define SPITSOCKET_H
#include "_SPITMACROS.h"
#include <mutex>
#include <unordered_map>
#include <string>

using namespace std;

class SPITSocket{
	public:
		static int FAMILY_IP4;
		static int FAMILY_IP6;
	
	//-------- nested classes --------------
	
public:
	/**
	 * IPAddress class is used to fetch all available IP addresses of the computer.<br>
	 * This is for internal usage.<br>
	 */
	class IPAddress {
	public:
		IPAddress();
		~IPAddress();
	private:
		string	m_IPAddress;
		string	m_SubnetMask;
		bool	m_Found;
	public:
		const string& getIPAddress() {
			return m_IPAddress;
		}
		const string& getSubnetMask() {
			return m_SubnetMask;
		}
		bool getFound() {
			return m_Found;
		}
		
		void setIPAddress(const string& p_IPAddress);
		void setSubnetMask(const string& p_SubnetMask);
		void setFound(bool p_Found);		
	};
	
private:
	static recursive_mutex s_MutexIPAddresses;	
public:
	static unordered_map<string, IPAddress*> s_IPAddresses;
	static void addIPAddress(string p_IPAddress, string p_SubnetMask);
	static void removeIPAddress(string p_IPAddress);
	static int getIPAddressCount();
	static IPAddress* getIPAddress(int p_Index);
	static void clearIPAddresses();
	static void resetFoundIPAddresses();
	static void removeNotFoundIPAddresses();
	
	
	//-------- class --------------
	
	SPITSocket();
	virtual ~SPITSocket();
private:
	string	m_ServerIP;
	string	m_ServerPort;
	string	m_ClientIP;
	string	m_ClientPort;		//port given by the user maybe "0"
	string	m_BoundClientPort;	//port set after bind
	int		m_BoundClientFamily;
	bool	m_IsBound;
	recursive_mutex	m_MutexSocket;
public:
	/**
	 * Sets the ip address and port for server and client. 
	 * @param p_ServerIP
	 * @param p_ServerPort
	 * @param p_ClientIP
	 * @param p_ClientPort
	 */
	void setConnectionParams(string p_ServerIP, string p_ServerPort, string p_ClientIP, string p_ClientPort);
	
	/**
	 * Send a message to the server as set by setConnectionParams.<br>
	 * @param p_MessageBytes  byte buffer containing the message
	 * @param p_MessageLength length of the messaeg
	 * @return 
	 */
	int sendMessage(const char* p_MessageBytes, int p_MessageLength);
	/**
	 * Call this for receiving a message.<br>
	 * This will block until a message is received or the underlying socket is closed.<br>
	 * @param p_InetFamily either AF_INET or AF_INET6<br>
	 * The SPITSocket creates two udp sockets, one for IP4 and one for IP6.<br>
	 * This parameter decides from which socket should a message recieved.<br>
	 * @param p_Buffer the buffer containing the received message later.
	 * @param p_BufferLength the size of the buffer
	 * @param p_ServerIP a pointer to a string, when a messages is received the string will contain the ip address of the sender/server.<br>
	 * if p_ServerIP is NULL - no detection of the server will be done.
	 * @return 
	 */
	virtual int receiveMessage(int p_InetFamily, char* p_Buffer, int p_BufferLength, string* p_ServerIP) = 0;
	
	
	/**
	 * Returns the broadcast address of an ip4 address.<br>
	 * @param p_IPAdress
	 * @return 
	 */ 
	virtual string getBroadcastIP4(IPAddress* p_IPAdress) = 0;
	/**
	 * Set whether the sockat are brodcast sockets or not
	 * @param p_Broadcast true = the sockets are broadcast sockets
	 * @return 0 = ok, -1 = error
	 */
	virtual int setBroadcast(bool p_Broadcast) = 0;
	/**
	 * Bind the client's udp socket to an ip address and port.<br> 
	 * @param p_ClientIP	the ip address either IP4 or IP6
	 * @param p_ClientPort	the client port number.<br>
	 * "0" = bind to any free port.<br>
	 * @return 
	 */
	virtual int bindSocket(string p_ServerIP, string p_ClientIP, string p_ClientPort) = 0;
	/**
	 * Internal usage - don't use this manually.<br>
	 * Use sendMessage instead.<br>
	 * @param p_InetFamily
	 * @param p_ServerIP
	 * @param p_Port
	 * @param p_MessageBytes
	 * @param p_MessageLength
	 * @return 
	 */
	virtual int sendMessageTo(int p_InetFamily, string p_ServerIP, string p_Port, const char* p_MessageBytes, int p_MessageLength) = 0;
	/**
	 * Internal usage - don't use this manually.<br> 
	 */
	virtual void getAdaptersInfo() = 0;
	
	
	string	getServerIP();
	string	getServerPort();
	string	getClientIP();
	string	getClientPort();
	string	getBoundClientPort();
	void	setBoundClientPort(string p_Port);
	void	setBoundClientFamily(int p_Family);
	int		getBoundClientFamily();
	void	setIsBound(bool p_IsBound);
	bool	getIsBound();
	

};

#endif /* SPITSOCKET_H */

