/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * File:   SPITObject.h
 * Author: Hagi
 *
 * Created on 9. April 2019, 12:11
 */

#ifndef SPITOBJECT_H
#define SPITOBJECT_H

//#include "_SPITMACROS.h"
#include "SPIT_Message.h"
#include "SPITType.h"
#include <string>
#include <unordered_map>
#include <mutex>

using namespace std;

class SPITObjectListener;

class SPITObject {
private:
	
	static recursive_mutex						s_MutexSPITObject;	
	static unordered_map<string, SPITObject*>	s_SPITObjects;
	static unordered_map<string, SPITObject*>	s_SPITObjectsRemote;
public:
	static recursive_mutex* getMutex() {
		return &s_MutexSPITObject;
	}
	static SPITObject* getSPITObject(string p_ID);
	static const SPITObject& getSPITObjectRef(string p_ID);
	static bool addSPITObject(SPITObject* p_ptrSpitObject);
	static bool removeSPITObject(SPITObject* p_ptrSpitObject);
	static bool removeSPITObject(string p_SpitObjectID);
	static int	getSPITObjectCount();
	static SPITObject* getSPITObject(int p_Index);
	static const SPITObject& getSPITObjectRef(int p_Index);
	static void clearSPITObjects();
	static void clearUnconfirmedSPITObjects();
	static void setConfirmedFalse();
		
	static SPITObject* getSPITObjectRemote(string p_ID);
	static const SPITObject& getSPITObjectRemoteRef(string p_ID);
	static bool addSPITObjectRemote(SPITObject* p_ptrSpitObject);
	static bool removeSPITObjectRemote(SPITObject* p_ptrSpitObject);
	static bool removeSPITObjectRemote(string p_SpitObjectID);
	static int	getSPITObjectRemoteCount();
	static SPITObject* getSPITObjectRemote(int p_Index);
	static const SPITObject& getSPITObjectRemoteRef(int p_Index);
	static void clearSPITObjectsRemote();
	
	static void eventProjectClosed();
	
	SPITObject();
//	SPITObject(const SPITObject& orig);
	~SPITObject();
private:
		string		m_ID;
		string		m_Name;
		string		m_SPITTypeID;
		string		m_ServerParams;
		string		m_Remark;
		bool		m_Confirmed;
		bool		m_Fixed;
		bool		m_CreatedByClient;	//flag true = the SPITObject is created by the client
		bool		m_ServerRemote;
		bool		m_ActionAssigned;
		bool		m_ActionAssignedType; //Virtual construct
		long long	m_FrameStart;
		long long	m_FrameLength;
		long long	m_FrameFadeInLength;
		long long	m_FrameFadeOutLength;
		char		m_ValueUse;
		int			m_ValueFactor;
		int			m_Track;
		long long	m_Delay;
		long long	m_Duration;
		
		bool		m_PlayPrePosition;
		long long	m_PlayTimeInsideFrames;
		int			m_PlayValue;
		char		m_PlayValueFlag;
		
		
		void initMembers();
public:
	string getID() const {
		return m_ID;
	}
	string getName() const {
		return m_Name;
	}
	string getRemark() const {
		return m_Remark;
	}
	string getSPITTypeID() const {
		return m_SPITTypeID;
	}
	string getServerParams() const {
		return m_ServerParams;
	}
	
	/**
	 * Returns if the SPITType triggers an action on the Server or on the client.
	 * @return false = the action is triggered on the client The client waits for the server to play objects of this SPITType<br>
	 * true = the action is triggered on the server. The server waits for the client to play objects of this SPITType.
	 */
	bool getServerRemote() const {
		return m_ServerRemote;
	}
	
	/**
	 * This is used by the server and client to tell if the other side has registered the changes.
	 * @return true = other side has registered the changes.
	 */	
	bool getConfirmed() const {
		return m_Confirmed;
	}
	bool getFixed() const {
		return m_Fixed;
	}
	bool getCreatedByClient() {
	return m_CreatedByClient;
	}
	/**
	 * This is a virtual construct - ActionAssignedType is not implemented in the SPITProtocol.<br>
	 * This is used when an action is associated with a SPITType. <br>
	 * Then this action is done for every SPITObject with the SPITType.  
	 * @return true = an action is assigned for the SPITType.
	 */
	bool getActionAssignedType() const {
		return m_ActionAssignedType;
	}
	/** Returns if this SPITObject has an associated action or not.<br>
	 * @return true = the user has asscociated an action with this SPITObject or <br>
	 *  the user has asscociated an action with the SPITType of this SPITObject
	 */
	bool getActionAssigned() const {
		return m_ActionAssigned || m_ActionAssignedType;
	}
	
	long long getFrameStart() const {
		return m_FrameStart;
	}
	long long getFrameLength() const {
		return m_FrameLength;
	}
	long long getFrameFadeInLength() const {
		return m_FrameFadeInLength;
	}
	long long getFrameFadeOutLength() const {
		return m_FrameFadeOutLength;
	}
	char getValueUse() const {
		return m_ValueUse;
	}
	int	 getValueFactor() const {
		return m_ValueFactor;
	}
	int getTrack() const {
		return m_Track;
	}

	long long getDelay() const {
		return m_Delay;
	}
	long long getDuration() const {
		return m_Duration;
	}
	
	bool getProjectIndepended() const {
		SPITType* ptrSPITType;
		if (m_ServerRemote == false) {
			ptrSPITType = SPITType::getSPITType(m_SPITTypeID);
			if (ptrSPITType == NULL) return true;
			return ptrSPITType->getProjectIndepended();
		}
		else {
			ptrSPITType = SPITType::getSPITTypeRemote(m_SPITTypeID);
			if (ptrSPITType == NULL) return true;
			return ptrSPITType->getProjectIndepended();
		}		
	};

	void setID(string p_ID);
	bool setConfirmed(bool p_Confirmed);
	void setCreatedByClient(bool p_CreatedByClient);
	bool setName(string p_Name);
	bool setRemark(string p_Remark);
	bool setServerParams(string p_ServerParams);
	bool setSPITTypeID(string p_GroupName);
	bool setServerRemote(bool p_BelongstoServer);
	bool setActionAssignedType(bool p_ActionAssigned);
	bool setActionAssigned(bool p_ActionAssigned);
	bool setFixed(bool p_Fixed);
	bool setFrameStart(long long p_FrameStart);
	bool setFrameLength(long long p_FrameLength);
	bool setFrameFadeInLength(long long	p_FrameFadeInLength);
	bool setFrameFadeOutLength(long long p_FrameFadeOutLength);
	bool setValueUse(char p_ValueUse);
	bool setValueFactor(int p_ValueFactor);
	bool setTrack(int p_Track);	
	bool setDelay(long long p_Delay);
	bool setDuration(long long p_Duration);

	bool setMessageOP(SPIT_Message::ReportSPITObject* p_ReportSPITObject);
	void fillMessageOP(SPIT_Message::ReportSPITObject* p_ReportSPITObject);
	void fillMessageOP(SPIT_Message::RemoveSPITObject* p_RemoveSPITObject);
};


#endif /* SPITOBJECT_H */

