/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/* 
 * SPITObject describes a SPIT Object 
 * File:   SPITObject.cpp
 * Author: Hagi
 * 
 * Created on 9. April 2019, 12:11
 * Changed on 13. December 2022
 */

#include "SPITObject.h"
#include "_SPITMACROS.h"

	unordered_map<string, SPITObject*> SPITObject::s_SPITObjects;
	unordered_map<string, SPITObject*> SPITObject::s_SPITObjectsRemote;
	recursive_mutex SPITObject::s_MutexSPITObject; 	
	
	SPITObject* SPITObject::getSPITObject(string p_ID) {
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			auto i = s_SPITObjects.find(p_ID);
			if (i == s_SPITObjects.end()) {
				return NULL;
			}
			return i->second;
		}
	}
	/**
	 * Returns the reference of the SPITObject with ID == p_ID.<br>
	 * Throws an exception if no SPITObject is not found.<br>
	 * @param p_ID the ID
	 * @return reference of the SPITType with ID == p_ID
	 */
	const SPITObject& SPITObject::getSPITObjectRef(string p_ID) {
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			auto i = s_SPITObjects.find(p_ID);
			if (i == s_SPITObjects.end()) {
				throw "SPITObject no SPITObject with given id";
			}
			return *(i->second);
		}
	}
	
	SPITObject* SPITObject::getSPITObjectRemote(string p_ID) {
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			auto i = s_SPITObjectsRemote.find(p_ID);
			if (i == s_SPITObjectsRemote.end()) {
				return NULL;
			}
			return i->second;
		}
	}
	/**
	 * Returns the reference of the remote SPITObject with ID == p_ID.<br>
	 * Throws an exception if no SPITObject is not found.<br>
	 * @param p_ID the ID
	 * @return reference of the SPITType with ID == p_ID
	 */
	const SPITObject& SPITObject::getSPITObjectRemoteRef(string p_ID) {
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			auto i = s_SPITObjectsRemote.find(p_ID);
			if (i == s_SPITObjectsRemote.end()) {
				throw "Remote SPITObject no SPITObject with given id";
			}
			return *(i->second);
		}
	}

	bool SPITObject::addSPITObject(SPITObject* p_ptrSPITObject) {
		if (p_ptrSPITObject == NULL) return false;
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			s_SPITObjects[p_ptrSPITObject->getID()] = p_ptrSPITObject;
			return true;
		}
	}
	bool SPITObject::addSPITObjectRemote(SPITObject* p_ptrSPITObject) {
		if (p_ptrSPITObject == NULL) return false;
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			s_SPITObjectsRemote[p_ptrSPITObject->getID()] = p_ptrSPITObject;
			return true;
		}
	}
	bool SPITObject::removeSPITObject(SPITObject* p_ptrSPITObject) {
		if (p_ptrSPITObject == NULL) return false;
		return removeSPITObject(p_ptrSPITObject->getID());
	}
	bool SPITObject::removeSPITObject(string p_SPITObjectID) {
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			auto i = s_SPITObjects.find(p_SPITObjectID);
			if (i == s_SPITObjects.end()) {
				return false;
			}
			i = s_SPITObjects.erase(i);
			return true;
		}
	}
	
	bool SPITObject::removeSPITObjectRemote(SPITObject* p_ptrSPITObject) {
		if (p_ptrSPITObject == NULL) return false;
		return removeSPITObjectRemote(p_ptrSPITObject->getID());
	}
	bool SPITObject::removeSPITObjectRemote(string p_ptrSPITObject) {
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			auto i = s_SPITObjectsRemote.find(p_ptrSPITObject);
			if (i == s_SPITObjectsRemote.end()) {
				return false;
			}
			i = s_SPITObjectsRemote.erase(i);
			return true;
		}
	}

	int	SPITObject::getSPITObjectCount() {
		return s_SPITObjects.size();
	}
	int	SPITObject::getSPITObjectRemoteCount() {
		return s_SPITObjectsRemote.size();
	}
	SPITObject* SPITObject::getSPITObject(int p_Index) {
		SPITObject* ptrSPITObject = NULL;
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			if (p_Index >= 0 && p_Index < (int)s_SPITObjects.size()) {
				unordered_map<string, SPITObject*>::iterator i = next(s_SPITObjects.begin(), p_Index);
				ptrSPITObject = i->second;
				return ptrSPITObject;
			}
			else {
				return NULL;
			}
		}
	}
	/**
	 * Returns a reference to the SPITObject at position p_Index.<br>
	 * Throws an exception if p_Index is out of range.<br>
	 * @param p_Index position
	 * @return the reference of the SPITObject at position. 
	 */
	const SPITObject& SPITObject::getSPITObjectRef(int p_Index) {
		SPITObject* ptrSPITObject = NULL;
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			if (p_Index >= 0 && p_Index < (int)s_SPITObjects.size()) {
				unordered_map<string, SPITObject*>::iterator i = next(s_SPITObjects.begin(), p_Index);
				ptrSPITObject = i->second;
				return *ptrSPITObject;
			}
			else {
				throw "SPITObject index out of range";
			}
		}
	}
	SPITObject* SPITObject::getSPITObjectRemote(int p_Index) {
		SPITObject* ptrSPITObject = NULL;
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			if (p_Index >= 0 && p_Index < (int)s_SPITObjectsRemote.size()) {
				unordered_map<string, SPITObject*>::iterator i = next(s_SPITObjectsRemote.begin(), p_Index);
				ptrSPITObject = i->second;
				return ptrSPITObject;
			}
			else {
				return NULL;
			}
		}
	}
	/**
	 * Returns a reference to the remote SPITObject at position p_Index.<br>
	 * Throws an exception if p_Index is out of range.<br>
	 * @param p_Index position
	 * @return the reference of the SPITObject at position. 
	 */
	const SPITObject& SPITObject::getSPITObjectRemoteRef(int p_Index) {
		SPITObject* ptrSPITObject = NULL;
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			if (p_Index >= 0 && p_Index < (int)s_SPITObjectsRemote.size()) {
				unordered_map<string, SPITObject*>::iterator i = next(s_SPITObjectsRemote.begin(), p_Index);
				ptrSPITObject = i->second;
				return *ptrSPITObject;
			}
			else {
				throw "Remote SPITObject index out of range";
			}
		}
	}
	
	void SPITObject::clearSPITObjects() {
		SPITObject* ptrSPITObject;
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			for (auto i = s_SPITObjects.begin(); i != s_SPITObjects.end(); i++) {
				ptrSPITObject = i->second;
				i = s_SPITObjects.erase(i);
				delete ptrSPITObject;
				if (i == s_SPITObjects.end()) {
					break;
				}
			}
		}
	}

	void SPITObject::clearSPITObjectsRemote() {
		SPITObject* ptrSPITObject;
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			for (auto i = s_SPITObjectsRemote.begin(); i != s_SPITObjectsRemote.end(); i++) {
				ptrSPITObject = i->second;
				i = s_SPITObjectsRemote.erase(i);
				delete ptrSPITObject;
				if (i == s_SPITObjectsRemote.end()) {
					break;
				}
			}
		}
	}
	
	/**
	* clears all unconfirmed SPITObjects not created by this SPIT_Client. 
	 */
	void SPITObject::clearUnconfirmedSPITObjects() {
		SPITObject* ptrSPITObject;
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			for (auto i = s_SPITObjects.begin(); i != s_SPITObjects.end(); i++) {
				ptrSPITObject = i->second;
				if (ptrSPITObject->getCreatedByClient() == false && ptrSPITObject->getConfirmed() == false) {
					i = s_SPITObjects.erase(i);
					delete ptrSPITObject;
				}
				if (i == s_SPITObjects.end()) {
					break;
				}
			}
		}
		
	}

	void SPITObject::eventProjectClosed() {
		SPITObject* ptrSPITObject;
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			for (auto i = s_SPITObjects.begin(); i != s_SPITObjects.end(); i++) {
				ptrSPITObject = i->second;
				if (ptrSPITObject->getCreatedByClient() == true) {
					continue;
				}
				i = s_SPITObjects.erase(i);
				delete ptrSPITObject;
				if (i == s_SPITObjects.end()) {
					break;
				}
			}
			//Remote
			for (auto i = s_SPITObjectsRemote.begin(); i != s_SPITObjectsRemote.end(); i++) {
				ptrSPITObject = i->second;
				i = s_SPITObjectsRemote.erase(i);
				delete ptrSPITObject;
				if (i == s_SPITObjectsRemote.end()) {
					break;
				}
			}
		}
	}	

	

	/**
	 * sets confirmed = false for all SPITObjects.<br>
	 * This should be called when the client has loaded a project.<br>
	 */
	void SPITObject::setConfirmedFalse() {
		SPITObject* ptrSPITObject;
		{
			unique_lock<recursive_mutex> o_LockObject(s_MutexSPITObject);
			for (auto i = s_SPITObjects.begin(); i != s_SPITObjects.end(); i++) {
				ptrSPITObject = i->second;
				ptrSPITObject->setConfirmed(false);
			}
		}
	}


	
SPITObject::SPITObject() {
	initMembers();
}
void SPITObject::initMembers() {
	m_ActionAssigned = false;
	m_ActionAssignedType = false;
	m_Confirmed = false;
	m_Delay = 0;
	m_Duration = 0;
	m_Fixed = false;
	m_CreatedByClient = false;
	m_FrameFadeInLength = 0;
	m_FrameFadeOutLength = 0;
	m_FrameLength = 0;
	m_FrameStart = 0;
	m_Remark = "";
	m_ID = createGUID();
	m_Name = "";
	m_SPITTypeID = "";
	m_ServerParams = "";
	m_ServerRemote = false;
	m_Track = 0;
	m_ValueFactor = 1000000; //Values are given in ppm -> 1000000 = 1/1;
	m_ValueUse = 0x01;	
}
/*
SPITObject::SPITObject(const SPITObject& orig) {
	m_ActionAssigned = orig.getActionAssigned();
	m_Confirmed = orig.getConfirmed();
	m_Delay = orig.getDelay();
	m_Duration = orig.getDuration();
	m_Fixed = orig.getFixed();
	m_FrameFadeInLength = orig.getFrameFadeInLength();
	m_FrameFadeOutLength = orig.getFrameFadeOutLength();
	m_FrameLength = orig.getFrameLength();
	m_FrameStart = orig.getFrameStart();
	m_Remark = orig.getRemark();
	m_ID = orig.getID();
	m_Name = orig.getName();
	m_SPITTypeID = orig.getSPITTypeID();
	m_ServerParams = orig.getServerParams();
	m_ServerRemote = orig.getServerRemote();
	m_Track = orig.getTrack();
	m_ValueFactor = orig.getValueFactor();
	m_ValueUse = orig.getValueUse();	
}
*/
SPITObject::~SPITObject() {
	int intTest = 0;
}


bool SPITObject::setMessageOP(SPIT_Message::ReportSPITObject* p_ReportSPITObject) {
	bool boolChangeAllowed;
	bool boolChanged = false;
	
	if (m_CreatedByClient == true && m_Fixed == true) {
		boolChangeAllowed = false;
	}
	else {
		boolChangeAllowed = true;
	}
	
	//Confirmation should be changable
	if (m_CreatedByClient) {
		//Server reports a client created SPITType -> the type is confirmed
		m_Confirmed = true;
	}
	else {
		//type is NOT client created -> the client has to confirm the SPITtype
		m_Confirmed = p_ReportSPITObject->getConfirmed();
	}
	
	if (m_Delay != p_ReportSPITObject->getDelay()) {
		if (boolChangeAllowed == false) throw new exception();
		m_Delay = p_ReportSPITObject->getDelay();
		boolChanged = true;
	}
	if (m_Duration != p_ReportSPITObject->getDuration()) {
		if (boolChangeAllowed == false) throw new exception();
		m_Duration = p_ReportSPITObject->getDuration();
		boolChanged = true;
	}
	if (m_Fixed != p_ReportSPITObject->getFixed()) {
		if (boolChangeAllowed == false) throw new exception();
		m_Fixed = p_ReportSPITObject->getFixed();
		boolChanged = true;
	}
	if (m_FrameFadeInLength != p_ReportSPITObject->getFrameFadeInLength()) {
		if (boolChangeAllowed == false) throw new exception();
		m_FrameFadeInLength = p_ReportSPITObject->getFrameFadeInLength();
		boolChanged= true;
	}
	if (m_FrameFadeOutLength != p_ReportSPITObject->getFrameFadeOutLength()) {
		if (boolChangeAllowed == false) throw new exception();
		m_FrameFadeOutLength = p_ReportSPITObject->getFrameFadeOutLength();
		boolChanged = true;
	}
	if (m_FrameLength != p_ReportSPITObject->getFrameLength()) {
		if (boolChangeAllowed == false) throw new exception();
		m_FrameLength = p_ReportSPITObject->getFrameLength();
		boolChanged = true;
	}
	if (m_FrameStart != p_ReportSPITObject->getFrameStart()) {
		if (boolChangeAllowed == false) throw new exception();
		m_FrameStart = p_ReportSPITObject->getFrameStart();
		boolChanged = true;
	}
	if (m_Remark != p_ReportSPITObject->getRemark()) {
		if (boolChangeAllowed == false) throw new exception();
		m_Remark = p_ReportSPITObject->getRemark();
		boolChanged = true;
	}
	if (m_ID != p_ReportSPITObject->getID()) {
		if (boolChangeAllowed == false) throw new exception();
		m_ID = p_ReportSPITObject->getID();
		boolChanged = true;
	}
	if (m_Name != p_ReportSPITObject->getName()) {
		if (boolChangeAllowed == false) throw new exception();
		m_Name = p_ReportSPITObject->getName();
		boolChanged = true;
	}
	if (m_SPITTypeID != p_ReportSPITObject->getSPITTypeID()) {
		if (boolChangeAllowed == false) throw new exception();
		m_SPITTypeID = p_ReportSPITObject->getSPITTypeID();
		boolChanged =  true;
	}
	if (m_ServerParams != p_ReportSPITObject->getServerParams()) {
		if (boolChangeAllowed == false) throw new exception();
		m_ServerParams = p_ReportSPITObject->getServerParams();
		boolChanged = true;
	}
	if (m_ServerRemote != p_ReportSPITObject->getServerRemote()) {
		if (boolChangeAllowed == false) throw new exception();
		m_ServerRemote = p_ReportSPITObject->getServerRemote();
		boolChanged = true;
	}
	if (m_Track != p_ReportSPITObject->getTrack()) {
		if (boolChangeAllowed == false) throw new exception();
		m_Track = p_ReportSPITObject->getTrack();
		boolChanged = true;
	}
	if (m_ValueFactor != p_ReportSPITObject->getValueFactor()) {
		if (boolChangeAllowed == false) throw new exception();
		m_ValueFactor = p_ReportSPITObject->getValueFactor();
		boolChanged = true;
	}
	if (m_ValueUse != p_ReportSPITObject->getValueUse()) {
		if (boolChangeAllowed == false) throw new exception();
		m_ValueUse = p_ReportSPITObject->getValueUse();	
		boolChanged = true;
	}
	return boolChanged;
}

void SPITObject::fillMessageOP(SPIT_Message::ReportSPITObject* p_ReportSPITObject) {
	p_ReportSPITObject->setActionAssigned(getActionAssigned()); //Action can be assigned to type or to this object
	p_ReportSPITObject->setConfirmed(m_Confirmed);
	p_ReportSPITObject->setDelay(m_Delay);
	p_ReportSPITObject->setDuration(m_Duration);
	p_ReportSPITObject->setFixed(m_Fixed);
	p_ReportSPITObject->setFrameFadeInLength(m_FrameFadeInLength);
	p_ReportSPITObject->setFrameFadeOutLength(m_FrameFadeOutLength);
	p_ReportSPITObject->setFrameLength(m_FrameLength);
	p_ReportSPITObject->setFrameStart(m_FrameStart);
	p_ReportSPITObject->setID(m_ID);
	p_ReportSPITObject->setName(m_Name);
	p_ReportSPITObject->setRemark(m_Remark);
	p_ReportSPITObject->setSPITTypeID(m_SPITTypeID);
	p_ReportSPITObject->setServerParams(m_ServerParams);
	p_ReportSPITObject->setServerRemote(m_ServerRemote);
	p_ReportSPITObject->setTrack(m_Track);
	p_ReportSPITObject->setValueFactor(m_ValueFactor);
	p_ReportSPITObject->setValueUse(m_ValueUse);	
}
void SPITObject::fillMessageOP(SPIT_Message::RemoveSPITObject* p_RemoveSPITObject) {
	p_RemoveSPITObject->setID(m_ID);
}

void SPITObject::setID(string p_ID) {
	m_ID = p_ID;
}
void SPITObject::setCreatedByClient(bool p_CreatedByClient) {
	m_CreatedByClient = p_CreatedByClient;
}

/**
 * This is used by the server and client to tell if the other side has registered the changes.
 * @param p_Confirmed
 * @return if m_Confirmed has changed
 */
bool SPITObject::setConfirmed(bool p_Confirmed) {
	if (m_Confirmed == p_Confirmed) return false;
	m_Confirmed = p_Confirmed;
	return true;
}

bool SPITObject::setName(string p_Name) {
	if (m_Name == p_Name) return false;
	m_Name = p_Name;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setRemark(string p_Remark) {
	if (m_Remark == p_Remark) return false;
	m_Remark = p_Remark;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setServerParams(string p_ServerParams) {
	if (m_ServerParams == p_ServerParams) return false;
	m_ServerParams = p_ServerParams;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setSPITTypeID(string p_SPITTypeID) {
	if (m_SPITTypeID == p_SPITTypeID) return false;
	m_SPITTypeID = p_SPITTypeID;
	m_Confirmed = false;
	return true;
}

bool SPITObject::setServerRemote(bool p_BelongstoServer) {
	if (m_ServerRemote == p_BelongstoServer) return false;
	m_ServerRemote = p_BelongstoServer;
	m_Confirmed = false;
	return true;
}
	/**
	 * This is a virtual construct - ActionAssignedType is not implemented in the SPITProtocol.<br>
	 * This is used when an action is associated with a SPITType. <br>
	 * Then this action is done for every SPITObject with the SPITType.  
	 * @return true = an action is assigned for the SPITType.
	 */
bool SPITObject::setActionAssignedType(bool p_ActionAssigned) {
	if (m_ActionAssignedType == p_ActionAssigned) return false;
	bool boolOldActionAssigend;
	boolOldActionAssigend = getActionAssigned();
	m_ActionAssignedType = p_ActionAssigned;
	if (getActionAssigned() == boolOldActionAssigend) return false;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setActionAssigned(bool p_ActionAssigned) {
	if (m_ActionAssigned == p_ActionAssigned) return false;
	bool boolOldActionAssigend;
	boolOldActionAssigend = getActionAssigned();
	m_ActionAssigned = p_ActionAssigned;
	if (getActionAssigned() == boolOldActionAssigend) return false;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setFixed(bool p_Fixed) {
	if (m_Fixed == p_Fixed) return false;
	m_Fixed = p_Fixed;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setFrameStart(long long p_FrameStart) {
	if (m_FrameStart == p_FrameStart) return false;
	m_FrameStart = p_FrameStart;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setFrameLength(long long p_FrameLength) {
	if (m_FrameLength == p_FrameLength) return false;
	m_FrameLength = p_FrameLength;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setFrameFadeInLength(long long	p_FrameFadeInLength) {
	if (m_FrameFadeInLength == p_FrameFadeInLength) return false;
	m_FrameFadeInLength = p_FrameFadeInLength;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setFrameFadeOutLength(long long p_FrameFadeOutLength) {
	if (m_FrameFadeOutLength == p_FrameFadeOutLength) return false;
	m_FrameFadeOutLength = p_FrameFadeOutLength;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setValueUse(char p_ValueUse) {
	if (m_ValueUse == p_ValueUse) return false;
	m_ValueUse = p_ValueUse;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setValueFactor(int p_ValueFactor) {
	if (m_ValueFactor == p_ValueFactor) return false;
	m_ValueFactor = p_ValueFactor;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setTrack(int p_Track) {
	if (m_Track == p_Track) return false;
	m_Track = p_Track;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setDelay(long long p_Delay) {
	if (m_Delay == p_Delay) return false;
	m_Delay = p_Delay;
	m_Confirmed = false;
	return true;
}
bool SPITObject::setDuration(long long p_Duration) {
	if (m_Duration == p_Duration) return false;
	m_Duration = p_Duration;
	m_Confirmed = false;
	return true;
}
